/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicMenuItemUI
extends MenuItemUI {
    protected Font acceleratorFont;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected int defaultTextIconGap;
    protected Color disabledForeground;
    protected MenuDragMouseListener menuDragMouseListener;
    protected JMenuItem menuItem;
    protected MenuKeyListener menuKeyListener;
    protected MouseInputListener mouseInputListener;
    protected boolean oldBorderPainted;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private String acceleratorDelimiter;
    private ItemListener itemListener;
    private int defaultAcceleratorLabelGap;
    private int MenuGap;
    PropertyChangeHandler propertyChangeListener;

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuItemUI();
    }

    protected void doClick(MenuSelectionManager menuSelectionManager) {
        this.menuItem.doClick();
        menuSelectionManager.clearSelectedPath();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public MenuElement[] getPath() {
        ArrayList arrayList = new ArrayList();
        if (this.menuItem instanceof JMenu) {
            arrayList.add(((JMenu)this.menuItem).getPopupMenu());
        }
        Component component = this.menuItem;
        while (component instanceof MenuElement) {
            arrayList.add(0, component);
            component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        }
        Object[] objectArray = new MenuElement[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(jMenuItem, n);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        if (keyStroke != null) {
            Rectangle rectangle = this.getAcceleratorRect(keyStroke, jMenuItem.getToolkit().getFontMetrics(this.acceleratorFont));
            dimension.width += rectangle.width + this.defaultAcceleratorLabelGap;
            if (dimension.height < rectangle.height) {
                dimension.height = rectangle.height;
            }
        }
        if (icon != null) {
            dimension.width += icon.getIconWidth() + n;
            if (icon.getIconHeight() > dimension.height) {
                dimension.height = icon.getIconHeight();
            }
        }
        if (icon2 != null && jComponent instanceof JMenu) {
            int n2 = jMenuItem.getParent().getWidth();
            dimension.width = !((JMenu)jComponent).isTopLevelMenu() && dimension.width < n2 ? n2 - jMenuItem.getInsets().left - jMenuItem.getInsets().right : (dimension.width += icon2.getIconWidth() + this.MenuGap);
            if (icon2.getIconHeight() > dimension.height) {
                dimension.height = icon2.getIconHeight();
            }
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredMenuItemSize(jComponent, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installComponents(JMenuItem jMenuItem) {
    }

    protected void installDefaults() {
        String string = this.getPropertyPrefix();
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        this.menuItem.setMargin(UIManager.getInsets(string + ".margin"));
        this.acceleratorFont = UIManager.getFont(string + ".acceleratorFont");
        this.acceleratorForeground = UIManager.getColor(string + ".acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor(string + ".acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor(string + ".selectionBackground");
        this.selectionForeground = UIManager.getColor(string + ".selectionForeground");
        this.acceleratorDelimiter = UIManager.getString(string + ".acceleratorDelimiter");
        this.checkIcon = UIManager.getIcon(string + ".checkIcon");
        this.menuItem.setHorizontalTextPosition(11);
        this.menuItem.setHorizontalAlignment(10);
    }

    protected void installKeyboardActions() {
        KeyStroke keyStroke;
        InputMap inputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (inputMap == null) {
            inputMap = new ComponentInputMapUIResource(this.menuItem);
        }
        if ((keyStroke = this.menuItem.getAccelerator()) != null) {
            inputMap.put(keyStroke, "doClick");
        }
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, inputMap);
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.menuItem);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
        }
        actionMap.put("doClick", new ClickAction());
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
    }

    protected void installListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addItemListener(this.itemListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintMenuItem(graphics, jComponent, this.checkIcon, this.arrowIcon, jComponent.getBackground(), jComponent.getForeground(), this.defaultTextIconGap);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.isContentAreaFilled()) {
            if (jMenuItem.isSelected() && this.checkIcon == null || buttonModel != null && buttonModel.isArmed() && jMenuItem.getParent() instanceof MenuElement) {
                graphics.setColor(this.selectionBackground);
            } else {
                graphics.setColor(color);
            }
            graphics.fillRect(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
        }
    }

    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        JMenuItem jMenuItem = (JMenuItem)jComponent;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Rectangle rectangle5 = new Rectangle();
        Rectangle rectangle6 = new Rectangle();
        int n2 = jMenuItem.getVerticalAlignment();
        int n3 = jMenuItem.getHorizontalAlignment();
        int n4 = jMenuItem.getVerticalTextPosition();
        int n5 = jMenuItem.getHorizontalTextPosition();
        Font font = jMenuItem.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        SwingUtilities.calculateInnerArea(jMenuItem, rectangle3);
        this.paintBackground(graphics, jMenuItem, color);
        Insets insets = jMenuItem.getInsets();
        rectangle4.x -= insets.left;
        rectangle4.y -= insets.top;
        rectangle4.width += insets.right + insets.left;
        rectangle4.height += insets.top + insets.bottom;
        if (icon != null) {
            SwingUtilities.layoutCompoundLabel(jMenuItem, fontMetrics, null, icon, n2, n3, n4, n5, rectangle3, rectangle6, rectangle, n);
            icon.paintIcon(jMenuItem, graphics, rectangle6.x, rectangle6.y);
            rectangle3.x = rectangle6.x + rectangle6.width + n;
        }
        if (icon2 != null && jComponent instanceof JMenu && !((JMenu)jComponent).isTopLevelMenu()) {
            int n6 = icon2.getIconWidth();
            int n7 = icon2.getIconHeight();
            int n8 = (rectangle3.height - n7) / 2;
            icon2.paintIcon(jMenuItem, graphics, rectangle3.width - n6, rectangle3.y + n8);
        }
        Icon icon3 = jMenuItem.getIcon();
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, jMenuItem.getText(), icon3, n2, n3, n4, n5, rectangle3, rectangle2, rectangle, n);
        if (icon3 != null) {
            icon3.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        this.paintText(graphics, jMenuItem, rectangle, jMenuItem.getText());
        String string = "";
        if (jMenuItem.getAccelerator() != null) {
            string = this.getAcceleratorText(jMenuItem.getAccelerator());
            fontMetrics = graphics.getFontMetrics(this.acceleratorFont);
            rectangle5.width = fontMetrics.stringWidth(string);
            rectangle5.x = rectangle4.width - rectangle5.width;
            rectangle3.x = rectangle4.width - rectangle5.width - n;
            SwingUtilities.layoutCompoundLabel(jMenuItem, fontMetrics, string, null, n2, n3, n4, n5, rectangle3, rectangle2, rectangle5, n);
            this.paintAccelerator(graphics, jMenuItem, rectangle5, string);
        }
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        Font font = jMenuItem.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (string != null && !string.equals("")) {
            if (jMenuItem.isEnabled()) {
                ButtonModel buttonModel = jMenuItem.getModel();
                if (jMenuItem.isSelected() && this.checkIcon == null || buttonModel != null && buttonModel.isArmed() && jMenuItem.getParent() instanceof MenuElement) {
                    graphics.setColor(this.selectionForeground);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                }
            } else {
                graphics.setColor(Color.gray);
            }
            int n = jMenuItem.getDisplayedMnemonicIndex();
            if (n != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                BasicGraphicsUtils.drawString(graphics, string, 0, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
    }

    protected void uninstallComponents(JMenuItem jMenuItem) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setForeground(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setMargin(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.arrowIcon = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.acceleratorDelimiter = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removeItemListener(this.itemListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.menuItem = null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    private final String getAcceleratorText(KeyStroke keyStroke) {
        String string = "";
        int n = keyStroke.getModifiers();
        char c = keyStroke.getKeyChar();
        int n2 = keyStroke.getKeyCode();
        if (n != 0) {
            string = KeyEvent.getKeyModifiersText(n) + this.acceleratorDelimiter;
        }
        if (n2 == 0) {
            return string + c;
        }
        return string + KeyEvent.getKeyText(n2);
    }

    private final Rectangle getAcceleratorRect(KeyStroke keyStroke, FontMetrics fontMetrics) {
        int n = fontMetrics.stringWidth(this.getAcceleratorText(keyStroke));
        int n2 = fontMetrics.getHeight();
        return new Rectangle(0, 0, n, n2);
    }

    private final void paintAccelerator(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        graphics.setFont(this.acceleratorFont);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.acceleratorFont);
        if (jMenuItem.isEnabled()) {
            graphics.setColor(this.acceleratorForeground);
        } else {
            graphics.setColor(Color.gray);
        }
        BasicGraphicsUtils.drawString(graphics, string, 0, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    private final /* synthetic */ void this() {
        this.defaultTextIconGap = 4;
        this.defaultAcceleratorLabelGap = 10;
        this.MenuGap = 10;
    }

    public BasicMenuItemUI() {
        this.this();
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.itemListener = new ItemHandler();
        this.propertyChangeListener = new PropertyChangeHandler();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            if (menuElementArray[menuElementArray.length - 1] instanceof JMenuItem) {
                ((JMenuItem)menuElementArray[menuElementArray.length - 1]).doClick();
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        private MenuDragMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuKeyHandler
    implements MenuKeyListener {
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        private MenuKeyHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (component.getParent() instanceof MenuElement) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(BasicMenuItemUI.this.getPath());
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle rectangle = BasicMenuItemUI.this.menuItem.getBounds();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (mouseEvent.getX() > 0 && mouseEvent.getX() < rectangle.width && mouseEvent.getY() > 0 && mouseEvent.getY() < rectangle.height) {
                menuSelectionManager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick();
            } else {
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        protected MouseInputHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ClickAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicMenuItemUI.this.doClick(MenuSelectionManager.defaultManager());
        }

        ClickAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = false;
            if (BasicMenuItemUI.this.menuItem instanceof JCheckBoxMenuItem) {
                if (itemEvent.getStateChange() == 1) {
                    bl = true;
                }
                ((JCheckBoxMenuItem)BasicMenuItemUI.this.menuItem).setState(bl);
            }
            BasicMenuItemUI.this.menuItem.revalidate();
            BasicMenuItemUI.this.menuItem.repaint();
        }

        private ItemHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "accelerator") {
                InputMap inputMap = SwingUtilities.getUIInputMap(BasicMenuItemUI.this.menuItem, 2);
                if (inputMap != null) {
                    inputMap.remove((KeyStroke)propertyChangeEvent.getOldValue());
                } else {
                    inputMap = new ComponentInputMapUIResource(BasicMenuItemUI.this.menuItem);
                }
                KeyStroke keyStroke = (KeyStroke)propertyChangeEvent.getNewValue();
                if (keyStroke != null) {
                    inputMap.put(keyStroke, "doClick");
                }
            }
        }

        PropertyChangeHandler() {
        }
    }
}

