/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StreamHandler
extends Handler {
    private static final int STATE_FRESH = 0;
    private static final int STATE_PUBLISHED = 1;
    private static final int STATE_CLOSED = 2;
    private OutputStream out;
    private Writer writer;
    private int streamState;
    static /* synthetic */ Class class$java$util$logging$SimpleFormatter;
    static /* synthetic */ Class class$java$util$logging$Filter;
    static /* synthetic */ Class class$java$util$logging$Formatter;

    private final void checkOpen() {
        if (this.streamState == 2) {
            throw new IllegalStateException(this.toString() + " has been closed");
        }
    }

    private final void checkFresh() {
        this.checkOpen();
        if (this.streamState != 0) {
            throw new IllegalStateException("some log records have been published to " + this);
        }
    }

    private final void changeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string);
        if (this.streamState != 0 || this.writer != null) {
            this.close();
        }
        this.writer = outputStreamWriter;
        this.out = outputStream;
        this.encoding = string;
        this.streamState = 0;
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        this.checkFresh();
        if (this.out != null) {
            this.writer = string == null ? new OutputStreamWriter(this.out) : new OutputStreamWriter(this.out, string);
        }
    }

    protected void setOutputStream(OutputStream outputStream) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        outputStream.getClass();
        try {
            this.changeWriter(outputStream, this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.streamState == 0) {
            try {
                this.writer.write(this.formatter.getHead(this));
            }
            catch (IOException iOException) {
                this.reportError(null, iOException, 1);
                return;
            }
            catch (Exception exception) {
                this.reportError(null, exception, 0);
                return;
            }
            this.streamState = 1;
        }
        try {
            string = this.formatter.format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        boolean bl = false;
        if (this.writer != null && super.isLoggable(logRecord)) {
            bl = true;
        }
        return bl;
    }

    public void flush() {
        try {
            this.checkOpen();
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    public void close() throws SecurityException {
        LogManager.getLogManager().checkAccess();
        try {
            this.checkOpen();
            this.flush();
            if (this.writer != null) {
                if (this.formatter != null) {
                    if (this.streamState == 0) {
                        this.writer.write(this.formatter.getHead(this));
                    }
                    if (this.streamState != 2) {
                        this.writer.write(this.formatter.getTail(this));
                    }
                }
                this.streamState = 2;
                this.writer.close();
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.streamState = 0;
    }

    public StreamHandler() {
        this(null, null);
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        Class clazz = class$java$util$logging$SimpleFormatter;
        if (clazz == null) {
            clazz = class$java$util$logging$SimpleFormatter = StreamHandler.class("[Ljava.util.logging.SimpleFormatter;", false);
        }
        this(outputStream, "java.util.logging.StreamHandler", Level.INFO, formatter, clazz);
    }

    StreamHandler(OutputStream outputStream, String string, Level level, Formatter formatter, Class clazz) {
        this.this();
        this.level = LogManager.getLevelProperty(string + ".level", level);
        String string2 = string + ".filter";
        Class clazz2 = class$java$util$logging$Filter;
        if (clazz2 == null) {
            clazz2 = class$java$util$logging$Filter = StreamHandler.class("[Ljava.util.logging.Filter;", false);
        }
        this.filter = (Filter)LogManager.getInstanceProperty(string2, clazz2, null);
        if (formatter != null) {
            this.formatter = formatter;
        } else {
            String string3 = string + ".formatter";
            Class clazz3 = class$java$util$logging$Formatter;
            if (clazz3 == null) {
                clazz3 = class$java$util$logging$Formatter = StreamHandler.class("[Ljava.util.logging.Formatter;", false);
            }
            this.formatter = (Formatter)LogManager.getInstanceProperty(string3, clazz3, clazz);
        }
        try {
            String string4 = LogManager.getLogManager().getProperty(string + ".encoding");
            if (string4 != null && string4.length() > 0) {
                new String(new byte[0], string4);
            }
            this.encoding = string4;
        }
        catch (Exception exception) {}
        if (outputStream != null) {
            try {
                this.changeWriter(outputStream, this.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage());
            }
        }
    }
}

