/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import gnu.java.awt.color.CieXyzConverter;
import gnu.java.awt.color.ClutProfileConverter;
import gnu.java.awt.color.ColorSpaceConverter;
import gnu.java.awt.color.GrayProfileConverter;
import gnu.java.awt.color.GrayScaleConverter;
import gnu.java.awt.color.LinearRGBConverter;
import gnu.java.awt.color.PyccConverter;
import gnu.java.awt.color.RgbProfileConverter;
import gnu.java.awt.color.SrgbConverter;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ICC_ColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit;
    private transient int type;
    private transient int nComponents;
    private transient ColorSpaceConverter converter;

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    public float[] toRGB(float[] fArray) {
        return this.converter.toRGB(fArray);
    }

    public float[] fromRGB(float[] fArray) {
        return this.converter.fromRGB(fArray);
    }

    public float[] toCIEXYZ(float[] fArray) {
        return this.converter.toCIEXYZ(fArray);
    }

    public float[] fromCIEXYZ(float[] fArray) {
        return this.converter.fromCIEXYZ(fArray);
    }

    public boolean isCS_sRGB() {
        return this.converter instanceof SrgbConverter;
    }

    public float getMinValue(int n) {
        if (this.type == 1 && (n == 1 || n == 2)) {
            return -128.0f;
        }
        if (n < 0 || n >= this.nComponents) {
            throw new IllegalArgumentException();
        }
        return 0.0f;
    }

    public float getMaxValue(int n) {
        if (this.type == 0 && n >= 0 && n <= 2) {
            return 1.9999695f;
        }
        if (this.type == 1) {
            if (n == 0) {
                return 100.0f;
            }
            if (n == 1 || n == 2) {
                return 127.0f;
            }
        }
        if (n < 0 || n >= this.nComponents) {
            throw new IllegalArgumentException();
        }
        return 1.0f;
    }

    private final ColorSpaceConverter getConverter(ICC_Profile iCC_Profile) {
        ColorSpaceConverter colorSpaceConverter;
        switch (iCC_Profile.isPredefined()) {
            case 1000: {
                colorSpaceConverter = new SrgbConverter();
                break;
            }
            case 1001: {
                colorSpaceConverter = new CieXyzConverter();
                break;
            }
            case 1003: {
                colorSpaceConverter = new GrayScaleConverter();
                break;
            }
            case 1004: {
                colorSpaceConverter = new LinearRGBConverter();
                break;
            }
            case 1002: {
                colorSpaceConverter = new PyccConverter();
                break;
            }
            default: {
                colorSpaceConverter = iCC_Profile instanceof ICC_ProfileRGB ? new RgbProfileConverter((ICC_ProfileRGB)iCC_Profile) : (iCC_Profile instanceof ICC_ProfileGray ? new GrayProfileConverter((ICC_ProfileGray)iCC_Profile) : new ClutProfileConverter(iCC_Profile));
            }
        }
        return colorSpaceConverter;
    }

    private final void makeArrays() {
        this.minVal = new float[this.nComponents];
        this.maxVal = new float[this.nComponents];
        this.diffMinMax = null;
        this.invDiffMinMax = null;
        int n = 0;
        while (n < this.nComponents) {
            this.minVal[n] = this.getMinValue(n);
            this.maxVal[n] = this.getMaxValue(n);
            ++n;
        }
        this.needScaleInit = true;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.converter = this.getConverter(this.thisProfile);
        this.nComponents = this.thisProfile.getNumComponents();
        this.type = this.thisProfile.getColorSpaceType();
    }

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(iCC_Profile.getColorSpaceType(), iCC_Profile.getNumComponents());
        this.converter = this.getConverter(iCC_Profile);
        this.thisProfile = iCC_Profile;
        this.nComponents = iCC_Profile.getNumComponents();
        this.type = iCC_Profile.getColorSpaceType();
        this.makeArrays();
    }
}

