/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DomParser
implements XMLReader {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";
    private DefaultHandler2 defaultHandler;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errHandler;
    private EntityResolver resolver;
    private Locale locale;
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces;
    private boolean showXML1_0;
    private NamespaceSupport prefixStack;
    private boolean isDocument;

    public final EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public final void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            entityResolver = this.defaultHandler;
        }
        this.resolver = entityResolver;
    }

    public final void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.defaultHandler;
        }
        this.errHandler = errorHandler;
    }

    public final ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public final void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.defaultHandler;
        }
        this.contentHandler = contentHandler;
    }

    public final DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public final void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.defaultHandler;
        }
        this.dtdHandler = dTDHandler;
    }

    public final void parse(String string) throws SAXException {
        this.parse();
    }

    public final void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void parse() throws SAXException {
        block4: {
            try {
                this.walk();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.isDocument) {
                    this.contentHandler.endDocument();
                }
                this.current = null;
                this.prefixStack.reset();
                throw throwable;
            }
            {
                Object var2_3 = null;
                if (!this.isDocument) break block4;
            }
            this.contentHandler.endDocument();
        }
        this.current = null;
        this.prefixStack.reset();
    }

    private final boolean getIsL2(Node node2) {
        Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
        if (document == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature("XML", "2.0");
    }

    public final boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string) || "http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string) || "http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(string);
    }

    public final Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return this.declHandler == this.defaultHandler ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.lexicalHandler == this.defaultHandler ? null : this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(string);
    }

    public final void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean bl2 = this.getFeature(string);
        if (bl2 == bl) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!this.showXML1_0 && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = bl;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (!this.showNamespaces && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = bl;
            return;
        }
        throw new SAXNotSupportedException(string);
    }

    public final void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (!(object instanceof DeclHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.declHandler = (DeclHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (!(object instanceof LexicalHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.lexicalHandler = (LexicalHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            if (object == null || object instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException("property is readonly during parse:  " + string);
                }
                this.setStart((Node)object);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(string);
    }

    private final void setStart(Node node2) {
        this.start = node2;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void walk() throws SAXException {
        var4_1 = new AttributesImpl();
        var8_2 = this;
        synchronized (var8_2) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            block42: {
                var1_3 = this.current.getNodeType();
                switch (var1_3) {
                    case 9: {
                        this.contentHandler.startDocument();
                        break block42;
                    }
                    case 1: {
                        var2_4 = this.current.getAttributes();
                        var3_5 = var2_4.getLength();
                        this.prefixStack.pushContext();
                        var10_10 = 0;
                        while (true) {
                            if (var10_10 < var3_5) ** GOTO lbl33
                            if (!this.showNamespaces) break;
                            if (!this.isL2) {
                                throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                            }
                            var6_7 = this.current.getNamespaceURI();
                            if (var6_7 == null) {
                                var6_7 = "";
                            }
                            if ((var7_8 = this.current.getLocalName()) == null) {
                                var7_8 = this.current.getNodeName();
                            }
                            ** GOTO lbl58
lbl33:
                            // 1 sources

                            var11_11 = (Attr)var2_4.item(var10_10);
                            var12_13 = var11_11.getNodeName();
                            if (!this.showNamespaces || !var12_13.startsWith("xmlns")) ** GOTO lbl42
                            var13_14 = "xmlns".equals(var12_13) != false ? "" : var12_13.substring(6);
                            var14_15 = var11_11.getNodeValue();
                            this.prefixStack.declarePrefix(var13_14, var14_15);
                            this.contentHandler.startPrefixMapping(var13_14, var14_15);
                            if (!this.showXML1_0) ** GOTO lbl54
lbl42:
                            // 2 sources

                            if (this.showNamespaces) {
                                if (!this.isL2) {
                                    throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                                }
                                var6_7 = var11_11.getNamespaceURI();
                                if (var6_7 == null) {
                                    var6_7 = "";
                                }
                                if ((var7_8 = var11_11.getLocalName()) == null) {
                                    var7_8 = var12_13;
                                }
                            } else {
                                var7_8 = "";
                                var6_7 = "";
                            }
                            var4_1.addAttribute(var6_7, (String)var7_8, (String)var12_13, "CDATA", var11_11.getNodeValue());
lbl54:
                            // 2 sources

                            ++var10_10;
                        }
                        var7_8 = "";
                        var6_7 = "";
lbl58:
                        // 2 sources

                        this.contentHandler.startElement(var6_7, (String)var7_8, this.current.getNodeName(), var4_1);
                        if (var3_5 != 0) {
                            var4_1.clear();
                        }
                        break block42;
                    }
                    case 4: {
                        this.lexicalHandler.startCDATA();
                        var5_6 = this.current.getNodeValue().toCharArray();
                        this.contentHandler.characters(var5_6, 0, var5_6.length);
                        this.lexicalHandler.endCDATA();
                        break block42;
                    }
                    case 8: {
                        var5_6 = this.current.getNodeValue().toCharArray();
                        this.lexicalHandler.comment(var5_6, 0, var5_6.length);
                        break block42;
                    }
                    case 10: {
                        var10_9 = (DocumentType)this.current;
                        if (this.isL2) {
                            this.lexicalHandler.startDTD(var10_9.getName(), var10_9.getPublicId(), var10_9.getSystemId());
                        } else {
                            this.lexicalHandler.startDTD(var10_9.getName(), null, null);
                        }
                        var11_11 = this.isL2 != false && var10_9.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                        var12_13 = var11_11.toCharArray();
                        this.lexicalHandler.comment((char[])var12_13, 0, ((char[])var12_13).length);
                        var2_4 = var10_9.getNotations();
                        var3_5 = var2_4.getLength();
                        var11_12 = 0;
                        while (true) {
                            if (var11_12 < var3_5) ** GOTO lbl90
                            var2_4 = var10_9.getEntities();
                            var3_5 = var2_4.getLength();
                            var11_12 = 0;
                            if (true) ** GOTO lbl113
lbl90:
                            // 1 sources

                            var12_13 = (Notation)var2_4.item(var11_12);
                            this.dtdHandler.notationDecl(var12_13.getNodeName(), var12_13.getPublicId(), var12_13.getSystemId());
                            ++var11_12;
                        }
                    }
                    case 5: {
                        this.lexicalHandler.startEntity(this.current.getNodeName());
                        break block42;
                    }
                    case 7: {
                        this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                        break block42;
                    }
                    case 3: {
                        var5_6 = this.current.getNodeValue().toCharArray();
                        this.contentHandler.characters(var5_6, 0, var5_6.length);
                        break block42;
                    }
                    default: {
                        throw new SAXException("Illegal DOM Node type in Document:  " + this.current.getNodeType());
                    }
                }
                do {
                    if ((var13_14 = (var12_13 = (Entity)var2_4.item(var11_12)).getNotationName()) != null) {
                        this.dtdHandler.unparsedEntityDecl(var12_13.getNodeName(), var12_13.getPublicId(), var12_13.getSystemId(), var13_14);
                    } else if (var12_13.getSystemId() != null) {
                        this.declHandler.externalEntityDecl(var12_13.getNodeName(), var12_13.getPublicId(), var12_13.getSystemId());
                    }
                    ++var11_12;
lbl113:
                    // 2 sources

                } while (var11_12 < var3_5);
                this.lexicalHandler.endDTD();
            }
            switch (var1_3) {
                case 1: 
                case 5: 
                case 9: {
                    var10_9 = this.current.getFirstChild();
                    if (var10_9 != null) {
                        this.current = var10_9;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    throw new SAXException("Illegal DOM Node type found:  " + this.current.getNodeType());
                }
            }
            while (true) {
                if ((var10_9 = this.current.getNextSibling()) != null) {
                    this.current = var10_9;
                    continue block17;
                }
                this.current = this.current.getParentNode();
                if (this.current == null || this.current == this.start) {
                    return;
                }
                this.callEnd(this.current);
            }
            break;
        }
    }

    private final void callEnd(Node node2) throws SAXException {
        switch (node2.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName());
                    Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
                    while (enumeration.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)enumeration.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node2.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node2.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException("Illegal DOM container type found:  " + this.current.getNodeType());
    }

    private final /* synthetic */ void this() {
        this.defaultHandler = new DefaultHandler2();
        this.contentHandler = this.defaultHandler;
        this.dtdHandler = this.defaultHandler;
        this.declHandler = this.defaultHandler;
        this.lexicalHandler = this.defaultHandler;
        this.errHandler = this.defaultHandler;
        this.resolver = this.defaultHandler;
        this.locale = Locale.getDefault();
        this.showNamespaces = true;
        this.showXML1_0 = false;
        this.prefixStack = new NamespaceSupport();
    }

    public DomParser() {
        this.this();
    }

    public DomParser(Node node2) {
        this.this();
        this.setStart(node2);
    }
}

