/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

final class Extensions {
    private static final Integer _512 = new Integer(512);
    private static final Integer _1024 = new Integer(1024);
    private static final Integer _2048 = new Integer(2048);
    private static final Integer _4096 = new Integer(4096);

    static final List getServerName(Extension extension) {
        LinkedList linkedList = new LinkedList();
        byte[] byArray = extension.getValue();
        int n = 0;
        try {
            while (n < byArray.length) {
                if (byArray[n++] == 0) {
                    int n2 = (byArray[n++] & 0xFF) << 8;
                    linkedList.add(new String(byArray, n, n2 |= byArray[n++] & 0xFF, "UTF-8"));
                    n += n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return Collections.unmodifiableList(linkedList);
    }

    static final List getClientCertTypes(Extension extension) throws IOException {
        LinkedList linkedList = new LinkedList();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extension.getValue());
        int n = byteArrayInputStream.read() & 0xFF;
        int n2 = 0;
        while (n2 < n) {
            linkedList.add(CertificateType.read(byteArrayInputStream));
            ++n2;
        }
        return Collections.unmodifiableList(linkedList);
    }

    static final CertificateType getServerCertType(Extension extension) throws IOException {
        return CertificateType.read(new ByteArrayInputStream(extension.getValue()));
    }

    static final Integer getMaxFragmentLength(Extension extension) {
        switch (extension.getValue()[0] & 0xFF) {
            case 1: {
                return _512;
            }
            case 2: {
                return _1024;
            }
            case 3: {
                return _2048;
            }
            case 4: {
                return _4096;
            }
        }
        throw new IllegalArgumentException();
    }

    static final Object[] getTrustedCA(Extension extension) {
        byte[] byArray = extension.getValue();
        int n = byArray[0] & 0xFF;
        try {
            switch (n) {
                case 0: {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = new Integer(n);
                    return objectArray;
                }
                case 1: 
                case 3: {
                    return new Object[]{new Integer(n), Util.trim(byArray, 1, 20)};
                }
                case 2: {
                    return new Object[]{new Integer(n), new X500Principal(Util.trim(byArray, 1, 20))};
                }
            }
        }
        catch (Exception exception) {}
        throw new IllegalArgumentException();
    }

    static final String getSRPUsername(Extension extension) {
        int n = extension.getValue()[0] & 0xFF;
        if (n > extension.getValue().length - 1) {
            throw new IllegalArgumentException();
        }
        try {
            return new String(extension.getValue(), 1, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.toString());
        }
    }

    private Extensions() {
    }
}

