/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertPathEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.PasswordEncryptedEntry;
import gnu.javax.crypto.keyring.PrivateKeyEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.keyring.PublicKeyEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class GnuPrivateKeyring
extends BaseKeyring
implements IPrivateKeyring {
    public static final int USAGE = 3;
    protected String mac;
    protected int maclen;
    protected String cipher;
    protected String mode;
    protected int keylen;

    public boolean containsPrivateKey(String string) {
        if (!this.containsAlias(string)) {
            return false;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof PasswordAuthenticatedEntry)) continue;
            return true;
        }
        return false;
    }

    public Key getPrivateKey(String string, char[] cArray) throws UnrecoverableKeyException {
        Entry entry;
        if (!this.containsAlias(string)) {
            return null;
        }
        List list2 = this.get(string);
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = null;
        PasswordEncryptedEntry passwordEncryptedEntry = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (!(entry instanceof PasswordAuthenticatedEntry)) continue;
            passwordAuthenticatedEntry = (PasswordAuthenticatedEntry)entry;
            break;
        }
        if (passwordAuthenticatedEntry == null) {
            return null;
        }
        try {
            passwordAuthenticatedEntry.verify(cArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("authentication failed");
        }
        iterator = passwordAuthenticatedEntry.getEntries().iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (!(entry instanceof PasswordEncryptedEntry)) continue;
            passwordEncryptedEntry = (PasswordEncryptedEntry)entry;
            break;
        }
        if (passwordEncryptedEntry == null) {
            return null;
        }
        try {
            passwordEncryptedEntry.decrypt(cArray);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException("decryption failed");
        }
        iterator = passwordEncryptedEntry.get(string).iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (!(entry instanceof PrivateKeyEntry)) continue;
            return ((PrivateKeyEntry)entry).getKey();
        }
        return null;
    }

    public void putPrivateKey(String string, Key key, char[] cArray) {
        if (this.containsPrivateKey(string)) {
            return;
        }
        string = this.fixAlias(string);
        Properties properties = new Properties();
        properties.put("alias", string);
        PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry(key, new Date(), properties);
        PasswordEncryptedEntry passwordEncryptedEntry = new PasswordEncryptedEntry(this.cipher, this.mode, this.keylen, new Properties());
        PasswordAuthenticatedEntry passwordAuthenticatedEntry = new PasswordAuthenticatedEntry(this.mac, this.maclen, new Properties());
        passwordEncryptedEntry.add(privateKeyEntry);
        passwordAuthenticatedEntry.add(passwordEncryptedEntry);
        try {
            passwordEncryptedEntry.encode(null, cArray);
            passwordAuthenticatedEntry.encode(null, cArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
        this.keyring.add(passwordAuthenticatedEntry);
    }

    public boolean containsPublicKey(String string) {
        if (!this.containsAlias(string)) {
            return false;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof PublicKeyEntry)) continue;
            return true;
        }
        return false;
    }

    public PublicKey getPublicKey(String string) {
        if (!this.containsAlias(string)) {
            return null;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!(entry instanceof PublicKeyEntry)) continue;
            return ((PublicKeyEntry)entry).getKey();
        }
        return null;
    }

    public void putPublicKey(String string, PublicKey publicKey) {
        if (this.containsPublicKey(string)) {
            return;
        }
        Properties properties = new Properties();
        properties.put("alias", this.fixAlias(string));
        this.add(new PublicKeyEntry(publicKey, new Date(), properties));
    }

    public boolean containsCertPath(String string) {
        if (!this.containsAlias(string)) {
            return false;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof CertPathEntry)) continue;
            return true;
        }
        return false;
    }

    public Certificate[] getCertPath(String string) {
        if (!this.containsAlias(string)) {
            return null;
        }
        List list2 = this.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!(entry instanceof CertPathEntry)) continue;
            return ((CertPathEntry)entry).getCertPath();
        }
        return null;
    }

    public void putCertPath(String string, Certificate[] certificateArray) {
        if (this.containsCertPath(string)) {
            return;
        }
        Properties properties = new Properties();
        properties.put("alias", this.fixAlias(string));
        this.add(new CertPathEntry(certificateArray, new Date(), properties));
    }

    protected void load(InputStream inputStream, char[] cArray) throws IOException {
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (inputStream.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        this.keyring = PasswordAuthenticatedEntry.decode(new DataInputStream(inputStream), cArray);
    }

    protected void store(OutputStream outputStream, char[] cArray) throws IOException {
        outputStream.write(3);
        this.keyring.encode(new DataOutputStream(outputStream), cArray);
    }

    public GnuPrivateKeyring(String string, int n, String string2, String string3, int n2) {
        this.keyring = new PasswordAuthenticatedEntry(string, n, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
        this.mac = string;
        this.maclen = n;
        this.cipher = string2;
        this.mode = string3;
        this.keylen = n2;
    }

    public GnuPrivateKeyring() {
        this("HMAC-SHA-1", 20, "AES", "OFB", 16);
    }
}

