/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.CpoolUtf8;
import gnu.bytecodecvssnap.ObjectType;
import gnu.bytecodecvssnap.Type;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpoolClass
extends CpoolEntry {
    CpoolUtf8 name;

    public int getTag() {
        return 7;
    }

    public final CpoolUtf8 getName() {
        return this.name;
    }

    public final String getStringName() {
        return this.name.string;
    }

    public final ObjectType getClassType() {
        String string = this.name.string;
        if (string.charAt(0) == '[') {
            return (ObjectType)Type.signatureToType(string);
        }
        return ClassType.make(string.replace('/', '.'));
    }

    static final int hashCode(CpoolUtf8 cpoolUtf8) {
        return cpoolUtf8.hashCode() ^ 0xF0F;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = CpoolClass.hashCode(this.name);
        }
        return this.hash;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeShort(this.name.index);
    }

    public void print(ClassTypeWriter classTypeWriter, int n) {
        if (n == 1) {
            classTypeWriter.print("Class ");
        } else if (n > 1) {
            classTypeWriter.print("Class name: ");
            classTypeWriter.printOptionalIndex(this.name);
        }
        classTypeWriter.print(this.name.string.replace('/', '.'));
    }

    CpoolClass() {
    }

    CpoolClass(ConstantPool constantPool, int n, CpoolUtf8 cpoolUtf8) {
        super(constantPool, n);
        this.name = cpoolUtf8;
    }
}

