/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.giop.grmic;

import gnu.classpath.tools.AbstractMethodGenerator;
import gnu.classpath.tools.giop.grmic.GiopIo;
import gnu.classpath.tools.giop.grmic.GiopRmicCompiler;
import java.lang.reflect.Method;
import java.util.Properties;

public class MethodGenerator
implements AbstractMethodGenerator {
    Method method;
    GiopRmicCompiler rmic;
    MethodGenerator previous;
    int hashCharPosition;

    private /* synthetic */ void finit$() {
        this.previous = null;
    }

    public MethodGenerator(Method method, GiopRmicCompiler giopRmicCompiler) {
        this.finit$();
        this.method = method;
        this.rmic = giopRmicCompiler;
    }

    public String getGiopMethodName() {
        String string = this.method.getName();
        if (string.startsWith("get")) {
            return "_get_J" + string.substring("get".length());
        }
        if (string.startsWith("set")) {
            return "_set_J" + string.substring("set".length());
        }
        return string;
    }

    public String getArgumentList() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(this.rmic.name(classArray[i]));
            stringBuffer.append(" p" + i);
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getArgumentNames() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(" p" + i);
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getThrows() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(this.rmic.name(classArray[i]));
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String generateStubMethod() {
        String string;
        Properties properties = new Properties(this.rmic.vars);
        properties.put("#return_type", this.rmic.name(this.method.getReturnType()));
        properties.put("#method_name", this.method.getName());
        properties.put("#giop_method_name", this.getGiopMethodName());
        properties.put("#argument_list", this.getArgumentList());
        properties.put("#argument_names", this.getArgumentNames());
        properties.put("#argument_write", this.getStubParaWriteStatement());
        if (this.method.getReturnType().equals(Void.TYPE)) {
            properties.put("#read_return", "return;");
        } else {
            properties.put("#read_return", "return " + GiopIo.getReadStatement(this.method.getReturnType(), this.rmic));
        }
        String string2 = this.getThrows();
        if (string2.length() > 0) {
            properties.put("#throws", "\n    throws " + string2);
        } else {
            properties.put("#throws", "");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            string = "StubMethodVoid.jav";
        } else {
            properties.put("#write_result", GiopIo.getWriteStatement(this.method.getReturnType(), "result", this.rmic));
            string = "StubMethod.jav";
        }
        String string3 = this.rmic.getResource(string);
        String string4 = this.rmic.replaceAll(string3, properties);
        return string4;
    }

    public String generateTieMethod() {
        String string;
        Properties properties = new Properties(this.rmic.vars);
        properties.put("#return_type", this.rmic.name(this.method.getReturnType()));
        properties.put("#method_name", this.method.getName());
        properties.put("#giop_method_name", this.getGiopMethodName());
        properties.put("#argument_list", this.getArgumentList());
        properties.put("#argument_names", this.getArgumentNames());
        properties.put("#argument_write", this.getStubParaWriteStatement());
        if (this.previous == null || this.previous.getHashChar() != this.getHashChar()) {
            properties.put("#hashCodeLabel", "    case '" + this.getHashChar() + "':");
        } else {
            properties.put("#hashCodeLabel", "    // also '" + this.getHashChar() + "':");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            string = "TieMethodVoid.jav";
        } else {
            properties.put("#write_result", GiopIo.getWriteStatement(this.method.getReturnType(), "result", this.rmic));
            string = "TieMethod.jav";
        }
        properties.put("#read_and_define_args", this.getRda());
        String string2 = this.rmic.getResource(string);
        String string3 = this.rmic.replaceAll(string2, properties);
        return string3;
    }

    public String getRda() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append("                ");
            stringBuffer.append(this.rmic.name(classArray[i]));
            stringBuffer.append(" ");
            stringBuffer.append("p" + i);
            stringBuffer.append(" = ");
            stringBuffer.append(GiopIo.getReadStatement(classArray[i], this.rmic));
            if (i >= classArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getStubParaWriteStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append("             ");
            stringBuffer.append(GiopIo.getWriteStatement(classArray[i], "p" + i, this.rmic));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public char getHashChar() {
        return this.getGiopMethodName().charAt(this.hashCharPosition);
    }
}

