/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = 4755994433709540381L;
    char[] content;
    private int count;
    private Vector positions;

    private /* synthetic */ void finit$() {
        this.positions = new Vector();
    }

    public StringContent() {
        this(10);
    }

    public StringContent(int n) {
        this.finit$();
        if (n < 1) {
            n = 1;
        }
        this.content = new char[n];
        this.content[0] = 10;
        this.count = 1;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        Vector vector2 = new Vector();
        Iterator iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            Position position = (Position)iterator.next();
            if (n > position.getOffset() || position.getOffset() > n + n2) continue;
            vector2.add(position);
        }
        return vector2;
    }

    public Position createPosition(int n) throws BadLocationException {
        if (n < this.count || n > this.count) {
            this.checkLocation(n, 0);
        }
        StickyPosition stickyPosition = new StickyPosition(this, n);
        this.positions.add(stickyPosition);
        return stickyPosition;
    }

    public int length() {
        return this.count;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        Object object;
        this.checkLocation(n, 0);
        if (n == this.count) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[this.content.length + cArray.length];
        this.count += cArray.length;
        if (n > 0) {
            System.arraycopy(this.content, 0, cArray2, 0, n);
        }
        System.arraycopy(cArray, 0, cArray2, n, cArray.length);
        System.arraycopy(this.content, n, cArray2, n + cArray.length, cArray2.length - n - cArray.length);
        if (this.content.length < cArray2.length) {
            this.content = new char[cArray2.length];
        }
        System.arraycopy(cArray2, 0, this.content, 0, cArray2.length);
        Vector vector = this.getPositionsInRange(this.positions, n, cArray2.length - n);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (StickyPosition)iterator.next();
            ((StickyPosition)object).setOffset(((StickyPosition)object).getOffset() + string.length());
        }
        object = new InsertUndo(this, n, cArray.length);
        return object;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2 + 1);
        char[] cArray = new char[this.content.length - n2];
        this.count -= n2;
        RemoveUndo removeUndo = new RemoveUndo(this, n, new String(this.content, n, n2));
        System.arraycopy(this.content, 0, cArray, 0, n);
        System.arraycopy(this.content, n + n2, cArray, n, this.content.length - n - n2);
        this.content = new char[cArray.length];
        System.arraycopy(cArray, 0, this.content, 0, this.content.length);
        Vector vector = this.getPositionsInRange(this.positions, n, this.content.length + n2 - n);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            StickyPosition stickyPosition = (StickyPosition)iterator.next();
            int n3 = stickyPosition.getOffset() - n2;
            stickyPosition.setOffset(n3);
            if (n3 >= 0) continue;
            this.positions.remove(stickyPosition);
        }
        return removeUndo;
    }

    public String getString(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2);
        return new String(this.content, n, n2);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        this.checkLocation(n, n2);
        segment.array = this.content;
        segment.offset = n;
        segment.count = n2;
    }

    protected void updateUndoPositions(Vector vector) {
    }

    void checkLocation(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (n > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
    }

    private class StickyPosition
    implements Position {
        private /* synthetic */ StringContent this$0;
        private int offset;

        private /* synthetic */ void finit$() {
            this.offset = -1;
        }

        public StickyPosition(StringContent stringContent, int n) {
            this.this$0 = stringContent;
            this.finit$();
            this.offset = n;
        }

        void setOffset(int n) {
            this.offset = this.offset >= 0 ? n : -1;
        }

        public int getOffset() {
            if (this.offset < 0) {
                return 0;
            }
            return this.offset;
        }
    }

    private class RemoveUndo
    extends AbstractUndoableEdit {
        private /* synthetic */ StringContent this$0;
        private int start;
        private String undoString;

        public RemoveUndo(StringContent stringContent, int n, String string) {
            this.this$0 = stringContent;
            this.start = n;
            this.undoString = string;
        }

        public void undo() {
            super.undo();
            try {
                this.this$0.insertString(this.start, this.undoString);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                int n = this.undoString.length();
                this.this$0.remove(this.start, n);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        private /* synthetic */ StringContent this$0;
        private int start;
        private int length;
        private String redoContent;

        public InsertUndo(StringContent stringContent, int n, int n2) {
            this.this$0 = stringContent;
            this.start = n;
            this.length = n2;
        }

        public void undo() {
            super.undo();
            try {
                this.this$0.checkLocation(this.start, this.length);
                this.redoContent = new String(this.this$0.content, this.start, this.length);
                this.this$0.remove(this.start, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                this.this$0.insertString(this.start, this.redoContent);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }
}

