/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    private String directoryLabel;
    private JComboBox directoryComboBox;
    DirectoryComboBoxModel directoryModel;
    private String fileLabel;
    private JTextField fileTextField;
    private String filterLabel;
    private JPanel topPanel;
    private JPanel controls;
    private JPanel bottomPanel = new JPanel(new GridLayout(3, 2));
    private JPanel buttonPanel = new JPanel();
    private JButton approveButton;
    JList fileList;
    JTable fileTable;
    JPanel fileListPanel;
    JPanel fileTablePanel;
    private FilterComboBoxModel filterModel;
    private ActionMap actionMap;
    boolean listView;
    boolean startEditing;
    JScrollPane scrollPane;
    String save;
    String look;
    JLabel dirLabel;
    ListSelectionListener listSelList;
    MouseListener doubleClickList;
    SingleClickListener singleClickList;
    TableClickListener tableClickList;

    static /* synthetic */ JPanel access$5(MetalFileChooserUI metalFileChooserUI, JPanel jPanel) {
        metalFileChooserUI.topPanel = jPanel;
        return metalFileChooserUI.topPanel;
    }

    static /* synthetic */ JPanel access$4(MetalFileChooserUI metalFileChooserUI, JPanel jPanel) {
        metalFileChooserUI.controls = jPanel;
        return metalFileChooserUI.controls;
    }

    static /* synthetic */ JButton access$3(MetalFileChooserUI metalFileChooserUI, JButton jButton) {
        metalFileChooserUI.approveButton = jButton;
        return metalFileChooserUI.approveButton;
    }

    static /* synthetic */ FilterComboBoxModel access$2(MetalFileChooserUI metalFileChooserUI, FilterComboBoxModel filterComboBoxModel) {
        metalFileChooserUI.filterModel = filterComboBoxModel;
        return metalFileChooserUI.filterModel;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        JFileChooser jFileChooser = (JFileChooser)jComponent;
        return new MetalFileChooserUI(jFileChooser);
    }

    public MetalFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.actionMap = this.createActionMap();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.actionMap = null;
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout());
        this.dirLabel = new JLabel(this.directoryLabel);
        this.topPanel.add((Component)this.dirLabel, "West");
        this.controls = new JPanel();
        this.addControlButtons();
        JPanel jPanel = new JPanel(new VerticalMidLayout(this));
        this.directoryModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox = new JComboBox(this.directoryModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        jPanel.add(this.directoryComboBox);
        this.topPanel.add(jPanel);
        this.topPanel.add((Component)this.controls, "East");
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        jFileChooser.add((Component)this.topPanel, "North");
        JPanel jPanel2 = this.createList(jFileChooser);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jFileChooser.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.getBottomPanel();
        this.filterModel = this.createFilterComboBoxModel();
        JComboBox jComboBox = new JComboBox(this.filterModel);
        jComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.fileTextField = new JTextField();
        JPanel jPanel4 = new JPanel(new VerticalMidLayout(this));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 5));
        jPanel4.add(this.fileTextField);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)new JLabel(this.fileLabel), "West");
        jPanel5.add(jPanel4);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)new JLabel(this.filterLabel), "West");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel6.add(jComboBox);
        jPanel3.add(jPanel6);
        JPanel jPanel7 = new JPanel(new ButtonLayout(this));
        this.approveButton = new JButton(this.getApproveSelectionAction());
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        jPanel7.add(this.approveButton);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JButton jButton = new JButton(this.getCancelSelectionAction());
        jButton.setText(this.cancelButtonText);
        jButton.setToolTipText(this.cancelButtonToolTipText);
        jButton.setMnemonic(this.cancelButtonMnemonic);
        jPanel7.add(jButton);
        jPanel3.add((Component)jPanel7, "South");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        jFileChooser.add((Component)jPanel3, "South");
        jFileChooser.add((Component)this.getAccessoryPanel(), "East");
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this.bottomPanel);
        this.bottomPanel = null;
        jFileChooser.remove(this.fileListPanel);
        jFileChooser.remove(this.fileTablePanel);
        this.fileTablePanel = null;
        this.fileListPanel = null;
        jFileChooser.remove(this.topPanel);
        this.topPanel = null;
        this.directoryModel = null;
        this.fileTextField = null;
        this.directoryComboBox = null;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new GridLayout(3, 2));
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.look = "Look In: ";
        this.save = "Save In: ";
        this.directoryLabel = jFileChooser.getDialogType() == 1 ? this.save : this.look;
        this.fileLabel = "File Name: ";
        this.filterLabel = "Files of Type: ";
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = "Cancel";
        this.cancelButtonToolTipText = "Abort file chooser dialog";
        this.directoryOpenButtonMnemonic = 0;
        this.directoryOpenButtonText = "Open";
        this.directoryOpenButtonToolTipText = "Open selected directory";
        this.helpButtonMnemonic = 0;
        this.helpButtonText = "Help";
        this.helpButtonToolTipText = "Filechooser help";
        this.openButtonMnemonic = 0;
        this.openButtonText = "Open";
        this.openButtonToolTipText = "Open selected file";
        this.saveButtonMnemonic = 0;
        this.saveButtonText = "Save";
        this.saveButtonToolTipText = "Save selected file";
        this.updateButtonMnemonic = 0;
        this.updateButtonText = "Update";
        this.updateButtonToolTipText = "Update directory listing";
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.directoryComboBox.setAction(new DirectoryComboBoxAction(this));
        jFileChooser.addPropertyChangeListener(this.filterModel);
        this.listSelList = this.createListSelectionListener(jFileChooser);
        this.doubleClickList = this.createDoubleClickListener(jFileChooser, this.fileList);
        this.singleClickList = new SingleClickListener(this, this.fileList);
        this.fileList.addListSelectionListener(this.listSelList);
        this.fileList.addMouseListener(this.doubleClickList);
        this.fileList.addMouseListener(this.singleClickList);
        super.installListeners(jFileChooser);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        jFileChooser.removePropertyChangeListener(this.filterModel);
        this.directoryComboBox.setAction(null);
        this.fileList.removeListSelectionListener(this.listSelList);
        this.fileList.removeMouseListener(this.doubleClickList);
        this.fileList.removeMouseListener(this.singleClickList);
        if (this.fileTable != null) {
            this.fileTable.removeMouseListener(this.tableClickList);
        }
    }

    protected ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = this.createActionMap();
        }
        return this.actionMap;
    }

    protected ActionMap createActionMap() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("approveSelection", this.getApproveSelectionAction());
        actionMap.put("cancelSelection", this.getCancelSelectionAction());
        actionMap.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMap;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        if (this.fileList == null) {
            this.fileListPanel = new JPanel(new BorderLayout());
            this.fileList = new JList(this.getModel());
            this.scrollPane = new JScrollPane(this.fileList);
            this.fileList.setLayoutOrientation(1);
            this.fileList.setCellRenderer(new FileRenderer(this));
        } else {
            this.fileList.setModel(this.getModel());
            this.fileListPanel.removeAll();
            this.scrollPane.getViewport().setView(this.fileList);
        }
        this.fileListPanel.add(this.scrollPane);
        this.fileListPanel.setPreferredSize(new Dimension(405, 135));
        return this.fileListPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        this.fileTablePanel = new JPanel(new BorderLayout());
        Object[] objectArray = new Object[]{"Name", "Size", "Modified"};
        Object[][] objectArray2 = new Object[this.fileList.getModel().getSize()][3];
        this.fileTable = new JTable(new DefaultTableModel(objectArray2, objectArray));
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.fileTable.setSelectionMode(2);
        } else {
            this.fileTable.setSelectionMode(0);
        }
        this.fileTable.setShowGrid(false);
        this.fileTable.setColumnSelectionAllowed(false);
        this.fileTable.setDefaultRenderer(MetalFileChooserUI.class$("java.lang.Object"), new TableFileRenderer(this));
        this.tableClickList = new TableClickListener(this, this.fileTable, jFileChooser);
        this.fileTable.addMouseListener(this.tableClickList);
        return this.updateTable();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    JPanel updateTable() {
        int n;
        int n2;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.fileTable.getModel();
        ListModel listModel = this.fileList.getModel();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        File file = null;
        int n3 = listModel.getSize();
        for (n2 = n = defaultTableModel.getRowCount(); n2 < n3; ++n2) {
            defaultTableModel.addRow(new Object[3]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            file = (File)listModel.getElementAt(n2);
            this.fileTable.setValueAt(file.getName(), n2, 0);
            this.fileTable.setValueAt(this.formatSize(file.length()), n2, 1);
            this.fileTable.setValueAt(dateFormat.format(new Date(file.lastModified())), n2, 2);
        }
        while (n > n3) {
            defaultTableModel.removeRow(--n);
        }
        this.scrollPane.getViewport().setView(this.fileTable);
        this.scrollPane.setColumnHeaderView(this.fileTable.getTableHeader());
        this.fileTablePanel.removeAll();
        this.fileTablePanel.add(this.scrollPane);
        return this.fileTablePanel;
    }

    private String formatSize(long l) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        long l2 = (long)Math.pow(2.0, 20.0);
        long l3 = (long)Math.pow(2.0, 10.0);
        long l4 = (long)Math.pow(2.0, 30.0);
        double d = 0.0;
        String string = "";
        if (l / l4 >= 1L) {
            d = (double)l / (double)l4;
            string = "GB";
        } else if (l / l2 >= 1L) {
            d = (double)l / (double)l2;
            string = "MB";
        } else if (l / l3 >= 1L) {
            d = (double)l / (double)l3;
            string = "KB";
        } else {
            d = l;
            string = "Bytes";
        }
        return numberFormat.format(d) + " " + string;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new MetalFileChooserSelectionListener(this);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.topPanel.getPreferredSize();
        Dimension dimension2 = this.bottomPanel.getPreferredSize();
        Dimension dimension3 = this.fileListPanel.getPreferredSize();
        return new Dimension(dimension3.width, dimension.height + dimension2.height + dimension3.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.topPanel.getMinimumSize();
        Dimension dimension2 = this.bottomPanel.getMinimumSize();
        Dimension dimension3 = this.fileListPanel.getMinimumSize();
        return new Dimension(dimension3.width, dimension.height + dimension2.height + dimension3.height);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new MetalFileChooserPropertyChangeListener(this);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel(this);
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer(this, jFileChooser);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel(this);
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer(this);
    }

    protected void addControlButtons() {
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton);
        JButton jButton2 = new JButton(this.getGoHomeAction());
        jButton2.setText(null);
        jButton2.setIcon(this.homeFolderIcon);
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton2);
        JButton jButton3 = new JButton(this.getNewFolderAction());
        jButton3.setText(null);
        jButton3.setIcon(this.newFolderIcon);
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.controls.add(jButton3);
        JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.addActionListener(new ListViewActionListener(this));
        jToggleButton.setSelected(true);
        this.listView = true;
        this.controls.add(jToggleButton);
        JToggleButton jToggleButton2 = new JToggleButton(this.detailsViewIcon);
        jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton2.addActionListener(new DetailViewActionListener(this));
        jToggleButton2.setSelected(false);
        this.controls.add(jToggleButton2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
    }

    protected void removeControlButtons() {
        this.controls.removeAll();
        this.controls.revalidate();
        this.controls.repaint();
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.directoryModel.setSelectedItem(jFileChooser.getCurrentDirectory());
        this.getModel().validateFileCache();
        if (!this.listView) {
            this.updateTable();
        } else {
            this.createList(jFileChooser);
        }
    }

    public String getFileName() {
        String string = null;
        if (this.fileTextField != null) {
            string = this.fileTextField.getText();
        }
        return string;
    }

    public void setFileName(String string) {
        this.fileTextField.setText(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    class ButtonLayout
    implements LayoutManager {
        private /* synthetic */ MetalFileChooserUI this$0;
        static final int GAP = 4;

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n > 0) {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    n2 = Math.max(dimension.width, n2);
                }
                Insets insets = container.getInsets();
                int n3 = container.getHeight() - insets.top - insets.bottom;
                int n4 = container.getWidth() - insets.right;
                for (int i = n - 1; i >= 0; --i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    int n5 = Math.max(0, (n3 - dimension.height) / 2);
                    component.setBounds(n4 -= dimension.width, insets.top + n5, dimension.width, (int)Math.min(dimension.getHeight(), (double)n3));
                    n4 -= 4;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = container.getComponentCount();
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    n = Math.max(dimension.width, n);
                    n2 = Math.max(dimension.height, n2);
                }
            }
            return new Dimension(n * n3 + 4 * (n3 - 1) + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        ButtonLayout(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }
    }

    class VerticalMidLayout
    implements LayoutManager {
        private /* synthetic */ MetalFileChooserUI this$0;

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n > 0) {
                Insets insets = container.getInsets();
                Component component = container.getComponent(0);
                Dimension dimension = component.getPreferredSize();
                int n2 = container.getHeight() - insets.top - insets.bottom;
                int n3 = Math.max(0, (n2 - dimension.height) / 2);
                component.setBounds(insets.left, insets.top + n3, container.getWidth() - insets.left - insets.right, (int)Math.min(dimension.getHeight(), (double)n2));
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (container.getComponentCount() > 0) {
                return container.getComponent(0).getPreferredSize();
            }
            return null;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        VerticalMidLayout(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        private /* synthetic */ MetalFileChooserUI this$0;
        JTable table;
        JFileChooser fc;
        Object lastSelected;
        File editFile;
        JTextField editField;

        public TableClickListener(MetalFileChooserUI metalFileChooserUI, JTable jTable, JFileChooser jFileChooser) {
            this.this$0 = metalFileChooserUI;
            this.table = jTable;
            this.fc = jFileChooser;
            this.lastSelected = metalFileChooserUI.fileList.getSelectedValue();
            metalFileChooserUI.setDirectorySelected(false);
            metalFileChooserUI.startEditing = false;
            this.editFile = null;
            this.editField = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.table.getSelectedRow();
            Object object = this.this$0.fileList.getModel().getElementAt(n);
            if (object == null) {
                return;
            }
            FileSystemView fileSystemView = this.fc.getFileSystemView();
            if (mouseEvent.getClickCount() == 1 && object.equals(this.lastSelected) && mouseEvent.getButton() == 1) {
                File[] fileArray = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || fileArray != null && fileArray.length <= 1) && !this.this$0.startEditing) {
                    this.editFile = (File)object;
                    this.editFile(n);
                }
            } else if (mouseEvent.getClickCount() >= 2 && object.equals(this.lastSelected)) {
                File file;
                if (this.this$0.startEditing) {
                    this.completeEditing();
                }
                if (this.fc.isTraversable(file = fileSystemView.createFileObject(this.lastSelected.toString()))) {
                    this.fc.setCurrentDirectory(file);
                    this.fc.rescanCurrentDirectory();
                } else {
                    this.fc.setSelectedFile(file);
                    this.fc.approveSelection();
                    this.closeDialog();
                }
            } else {
                if (this.this$0.startEditing) {
                    this.completeEditing();
                }
                String string = object.toString();
                File file = fileSystemView.createFileObject(string);
                this.fc.setSelectedFile(file);
                if (this.fc.isTraversable(file)) {
                    this.this$0.setDirectorySelected(true);
                    this.this$0.setDirectory(file);
                } else {
                    this.this$0.setDirectorySelected(false);
                    this.this$0.setDirectory(null);
                }
                this.lastSelected = object;
                if (file.isFile()) {
                    this.this$0.setFileName(string.substring(string.lastIndexOf("/") + 1));
                } else if (this.fc.getFileSelectionMode() != 0) {
                    this.this$0.setFileName(string);
                }
            }
            this.this$0.fileTable.repaint();
        }

        void editFile(int n) {
            Rectangle rectangle = this.table.getCellRect(n, 0, true);
            this.table.scrollRectToVisible(rectangle);
            if (this.editFile.canWrite()) {
                this.this$0.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener(this));
                rectangle.y = n * this.table.getRowHeight();
                this.editField.setBounds(rectangle);
                this.table.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.table.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                String string = this.editField.getText();
                if (string != null && string != "" && !string.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), string))) {
                    this.this$0.rescanCurrentDirectory(this.fc);
                }
                this.table.remove(this.editField);
            }
            this.this$0.startEditing = false;
            this.editFile = null;
            this.editField = null;
            this.table.repaint();
        }

        public void closeDialog() {
            Window window = SwingUtilities.windowForComponent(this.fc);
            if (window instanceof JDialog) {
                ((JDialog)window).dispose();
            }
        }

        class EditingActionListener
        implements ActionListener {
            private /* synthetic */ TableClickListener this$1;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.this$1.editField != null) {
                    this.this$1.completeEditing();
                }
            }

            EditingActionListener(TableClickListener tableClickListener) {
                this.this$1 = tableClickListener;
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        private /* synthetic */ MetalFileChooserUI this$0;
        JList list;
        File editFile;
        JFileChooser fc;
        Object lastSelected;
        JTextField editField;

        public SingleClickListener(MetalFileChooserUI metalFileChooserUI, JList jList) {
            this.this$0 = metalFileChooserUI;
            this.list = jList;
            this.editFile = null;
            this.fc = metalFileChooserUI.getFileChooser();
            this.lastSelected = null;
            metalFileChooserUI.startEditing = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                File[] fileArray = this.fc.getSelectedFiles();
                if ((!this.fc.isMultiSelectionEnabled() || fileArray != null && fileArray.length <= 1) && n >= 0 && !this.this$0.startEditing && this.list.isSelectedIndex(n)) {
                    Object object = this.list.getModel().getElementAt(n);
                    if (this.lastSelected != null && this.lastSelected.equals(object)) {
                        this.editFile(n);
                    }
                    this.lastSelected = object;
                } else {
                    this.completeEditing();
                }
            } else {
                this.completeEditing();
            }
        }

        void editFile(int n) {
            Rectangle rectangle = this.list.getCellBounds(n, n);
            this.list.scrollRectToVisible(rectangle);
            this.editFile = (File)this.list.getModel().getElementAt(n);
            if (this.editFile.canWrite()) {
                this.this$0.startEditing = true;
                this.editField = new JTextField(this.editFile.getName());
                this.editField.addActionListener(new EditingActionListener(this));
                Icon icon = this.this$0.getFileView(this.fc).getIcon(this.editFile);
                if (icon != null) {
                    int n2 = icon.getIconWidth() + 4;
                    rectangle.x += n2;
                    rectangle.width -= n2;
                }
                this.editField.setBounds(rectangle);
                this.list.add(this.editField);
                this.editField.requestFocus();
                this.editField.selectAll();
            } else {
                this.completeEditing();
            }
            this.list.repaint();
        }

        void completeEditing() {
            if (this.editField != null && this.editFile != null) {
                File file;
                String string = this.editField.getText();
                if (string != null && string != "" && !string.equals(this.fc.getName(this.editFile)) && this.editFile.renameTo(file = this.fc.getFileSystemView().createFileObject(this.fc.getCurrentDirectory(), string))) {
                    this.this$0.rescanCurrentDirectory(this.fc);
                }
                this.list.remove(this.editField);
            }
            this.this$0.startEditing = false;
            this.editFile = null;
            this.lastSelected = null;
            this.editField = null;
            this.list.repaint();
        }

        class EditingActionListener
        implements ActionListener {
            private /* synthetic */ SingleClickListener this$1;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.this$1.editField != null) {
                    this.this$1.completeEditing();
                }
            }

            EditingActionListener(SingleClickListener singleClickListener) {
                this.this$1 = singleClickListener;
            }
        }
    }

    class MetalFileChooserSelectionListener
    implements ListSelectionListener {
        private /* synthetic */ MetalFileChooserUI this$0;

        protected MetalFileChooserSelectionListener(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            File file = (File)this.this$0.fileList.getSelectedValue();
            if (file == null) {
                return;
            }
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            if (!jFileChooser.isTraversable(file)) {
                jFileChooser.setSelectedFile(file);
            } else {
                jFileChooser.setSelectedFile(null);
            }
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;

        public FilterComboBoxRenderer(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            this.setText(fileFilter.getDescription());
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private /* synthetic */ MetalFileChooserUI this$0;
        protected FileFilter[] filters = new FileFilter[1];
        private Object selected;

        protected FilterComboBoxModel(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
            this.filters[0] = metalFileChooserUI.getAcceptAllFileFilter(metalFileChooserUI.getFileChooser());
            this.selected = this.filters[0];
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                this.filters = fileFilterArray;
                this.fireContentsChanged(this, 0, this.filters.length);
                this.selected = propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (propertyChangeEvent.getPropertyName().equals("ChoosableFileFilterChangedProperty")) {
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
                this.filters = fileFilterArray;
                this.fireContentsChanged(this, 0, this.filters.length);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int n) {
            return this.filters[n];
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;

        protected FileRenderer(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FileView fileView = this.this$0.getFileView(this.this$0.getFileChooser());
            File file = (File)object;
            if (file != null) {
                this.setText(fileView.getName(file));
                this.setIcon(fileView.getIcon(file));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultListCellRenderer.noFocusBorder);
            }
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        private /* synthetic */ MetalFileChooserUI this$0;
        private static final int INDENT = 10;
        private Icon icon;
        private int depth;

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        void setDepth(int n) {
            this.depth = n;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
        }

        IndentIcon(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;
        private IndentIcon indentIcon;

        public DirectoryComboBoxRenderer(MetalFileChooserUI metalFileChooserUI, JFileChooser jFileChooser) {
            this.this$0 = metalFileChooserUI;
            this.indentIcon = new IndentIcon(metalFileChooserUI);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            this.setText(this.this$0.getFileChooser().getName(file));
            Icon icon = this.this$0.getFileChooser().getIcon(file);
            this.indentIcon.setIcon(icon);
            int n2 = this.this$0.directoryModel.getDepth(n);
            this.indentIcon.setDepth(n2);
            this.setIcon(this.indentIcon);
            return this;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        private /* synthetic */ MetalFileChooserUI this$0;

        protected DirectoryComboBoxAction(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            jFileChooser.setCurrentDirectory((File)this.this$0.directoryModel.getSelectedItem());
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private /* synthetic */ MetalFileChooserUI this$0;
        private List items = new ArrayList();
        private int selectedIndex = -1;

        public DirectoryComboBoxModel(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int n) {
            return this.items.get(n);
        }

        public int getDepth(int n) {
            return Math.max(n, 0);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            this.items.clear();
            FileSystemView fileSystemView = this.this$0.getFileChooser().getFileSystemView();
            File file = (File)object;
            while (file != null) {
                this.items.add(0, file);
                file = fileSystemView.getParentDirectory(file);
            }
            this.selectedIndex = this.items.indexOf(object);
            this.fireContentsChanged(this, 0, this.items.size() - 1);
        }
    }

    class MetalFileChooserPropertyChangeListener
    implements PropertyChangeListener {
        private /* synthetic */ MetalFileChooserUI this$0;

        public MetalFileChooserPropertyChangeListener(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("MultiSelectionEnabledChangedProperty")) {
                int n = -1;
                n = jFileChooser.isMultiSelectionEnabled() ? 2 : 0;
                if (this.this$0.listView) {
                    this.this$0.fileList.setSelectionMode(n);
                } else {
                    this.this$0.fileTable.setSelectionMode(n);
                }
            } else if (string.equals("SelectedFileChangedProperty")) {
                File file = jFileChooser.getSelectedFile();
                if (file != null && jFileChooser.getDialogType() == 1) {
                    if (file.isDirectory() && jFileChooser.isTraversable(file)) {
                        this.this$0.directoryLabel = this.this$0.look;
                        this.this$0.dirLabel.setText(this.this$0.directoryLabel);
                        jFileChooser.setApproveButtonText(this.this$0.openButtonText);
                        jFileChooser.setApproveButtonToolTipText(this.this$0.openButtonToolTipText);
                    } else if (file.isFile()) {
                        this.this$0.directoryLabel = this.this$0.save;
                        this.this$0.dirLabel.setText(this.this$0.directoryLabel);
                        jFileChooser.setApproveButtonText(this.this$0.saveButtonText);
                        jFileChooser.setApproveButtonToolTipText(this.this$0.saveButtonToolTipText);
                    }
                }
                if (file == null) {
                    this.this$0.setFileName(null);
                } else if (file.isFile() || jFileChooser.getFileSelectionMode() != 0) {
                    this.this$0.setFileName(file.getName());
                }
                int n = -1;
                n = this.this$0.getModel().indexOf(file);
                if (n >= 0) {
                    if (this.this$0.listView) {
                        this.this$0.fileList.setSelectedIndex(n);
                        this.this$0.fileList.ensureIndexIsVisible(n);
                        this.this$0.fileList.revalidate();
                        this.this$0.fileList.repaint();
                    } else {
                        this.this$0.fileTable.getSelectionModel().addSelectionInterval(n, n);
                        this.this$0.fileTable.scrollRectToVisible(this.this$0.fileTable.getCellRect(n, 0, true));
                        this.this$0.fileTable.revalidate();
                        this.this$0.fileTable.repaint();
                    }
                }
            } else if (string.equals("directoryChanged")) {
                if (this.this$0.listView) {
                    this.this$0.fileList.clearSelection();
                    this.this$0.fileList.revalidate();
                    this.this$0.fileList.repaint();
                } else {
                    this.this$0.fileTable.clearSelection();
                    this.this$0.fileTable.revalidate();
                    this.this$0.fileTable.repaint();
                }
                this.this$0.setDirectorySelected(false);
                File file = jFileChooser.getCurrentDirectory();
                this.this$0.setDirectory(file);
                boolean bl = file.getParentFile() != null;
                this.this$0.getChangeToParentDirectoryAction().setEnabled(bl);
            } else if (string.equals("ChoosableFileFilterChangedProperty")) {
                this.this$0.filterModel.propertyChange(propertyChangeEvent);
            } else if (string.equals("fileFilterChanged")) {
                this.this$0.filterModel.propertyChange(propertyChangeEvent);
            } else if (string.equals("DialogTypeChangedProperty") || string.equals("DialogTitleChangedProperty")) {
                Window window = SwingUtilities.windowForComponent(jFileChooser);
                if (window instanceof JDialog) {
                    ((JDialog)window).setTitle(this.this$0.getDialogTitle(jFileChooser));
                }
                this.this$0.approveButton.setText(this.this$0.getApproveButtonText(jFileChooser));
                this.this$0.approveButton.setToolTipText(this.this$0.getApproveButtonToolTipText(jFileChooser));
                this.this$0.approveButton.setMnemonic(this.this$0.getApproveButtonMnemonic(jFileChooser));
            } else if (string.equals("ApproveButtonTextChangedProperty")) {
                this.this$0.approveButton.setText(this.this$0.getApproveButtonText(jFileChooser));
            } else if (string.equals("ApproveButtonToolTipTextChangedProperty")) {
                this.this$0.approveButton.setToolTipText(this.this$0.getApproveButtonToolTipText(jFileChooser));
            } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                this.this$0.approveButton.setMnemonic(this.this$0.getApproveButtonMnemonic(jFileChooser));
            } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                if (jFileChooser.getControlButtonsAreShown()) {
                    this.this$0.topPanel.add((Component)this.this$0.controls, "East");
                } else {
                    this.this$0.topPanel.remove(this.this$0.controls);
                }
                this.this$0.topPanel.revalidate();
                this.this$0.topPanel.repaint();
                this.this$0.topPanel.doLayout();
            } else if (string.equals("acceptAllFileFilterUsedChanged")) {
                if (jFileChooser.isAcceptAllFileFilterUsed()) {
                    jFileChooser.addChoosableFileFilter(this.this$0.getAcceptAllFileFilter(jFileChooser));
                } else {
                    jFileChooser.removeChoosableFileFilter(this.this$0.getAcceptAllFileFilter(jFileChooser));
                }
            } else if (string.equals("AccessoryChangedProperty")) {
                JComponent jComponent;
                JComponent jComponent2 = (JComponent)propertyChangeEvent.getOldValue();
                if (jComponent2 != null) {
                    this.this$0.getAccessoryPanel().remove(jComponent2);
                }
                if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                    this.this$0.getAccessoryPanel().add(jComponent);
                }
            }
            if (string.equals("directoryChanged") || string.equals("fileFilterChanged") || string.equals("FileHidingChanged")) {
                if (this.this$0.fileTable != null) {
                    this.this$0.fileTable.removeAll();
                }
                if (this.this$0.fileList != null) {
                    this.this$0.fileList.removeAll();
                }
                this.this$0.startEditing = false;
                if (jFileChooser.getDialogType() == 1) {
                    this.this$0.directoryLabel = this.this$0.save;
                    this.this$0.dirLabel.setText(this.this$0.directoryLabel);
                    jFileChooser.setApproveButtonText(this.this$0.saveButtonText);
                    jFileChooser.setApproveButtonToolTipText(this.this$0.saveButtonToolTipText);
                }
                this.this$0.rescanCurrentDirectory(jFileChooser);
            }
            jFileChooser.revalidate();
            jFileChooser.repaint();
        }
    }

    class DetailViewActionListener
    implements ActionListener {
        private /* synthetic */ MetalFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.listView) {
                int[] nArray = this.this$0.fileList.getSelectedIndices();
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                this.this$0.listView = false;
                jFileChooser.remove(this.this$0.fileListPanel);
                if (this.this$0.fileTable == null) {
                    this.this$0.createDetailsView(jFileChooser);
                } else {
                    this.this$0.updateTable();
                }
                this.this$0.fileTable.getSelectionModel().clearSelection();
                if (nArray.length > 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.this$0.fileTable.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
                    }
                }
                jFileChooser.add((Component)this.this$0.fileTablePanel, "Center");
                jFileChooser.revalidate();
                jFileChooser.repaint();
            }
        }

        DetailViewActionListener(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }
    }

    class ListViewActionListener
    implements ActionListener {
        private /* synthetic */ MetalFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.this$0.listView) {
                int[] nArray = this.this$0.fileTable.getSelectedRows();
                this.this$0.listView = true;
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                jFileChooser.remove(this.this$0.fileTablePanel);
                this.this$0.createList(jFileChooser);
                this.this$0.fileList.getSelectionModel().clearSelection();
                if (nArray.length > 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.this$0.fileList.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
                    }
                }
                jFileChooser.add((Component)this.this$0.fileListPanel, "Center");
                jFileChooser.revalidate();
                jFileChooser.repaint();
            }
        }

        ListViewActionListener(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }
    }

    class TableFileRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ MetalFileChooserUI this$0;

        public TableFileRenderer(MetalFileChooserUI metalFileChooserUI) {
            this.this$0 = metalFileChooserUI;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                FileView fileView = this.this$0.getFileView(this.this$0.getFileChooser());
                ListModel listModel = this.this$0.fileList.getModel();
                if (n < listModel.getSize()) {
                    this.setIcon(fileView.getIcon((File)listModel.getElementAt(n)));
                }
            } else {
                this.setIcon(null);
            }
            this.setText(object.toString());
            this.setOpaque(true);
            this.setEnabled(jTable.isEnabled());
            this.setFont(this.this$0.fileList.getFont());
            if (this.this$0.startEditing && n2 == 0 || !bl) {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            } else {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            }
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            }
            return this;
        }
    }
}

