/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected int beginDragDividerLocation;
    protected int dividerSize;
    transient int lastDragLocation;
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    protected ActionListener keyboardDownRightListener;
    protected ActionListener keyboardEndListener;
    protected ActionListener keyboardHomeListener;
    protected ActionListener keyboardResizeToggleListener;
    protected ActionListener keyboardUpLeftListener;
    protected BasicHorizontalLayoutManager layoutManager;
    protected KeyStroke dividerResizeToggleKey;
    protected KeyStroke downKey;
    protected KeyStroke endKey;
    protected KeyStroke homeKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected boolean draggingHW;
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected Component nonContinuousLayoutDivider;
    protected JSplitPane splitPane;
    private int dividerLocation;

    private /* synthetic */ void finit$() {
        this.lastDragLocation = -1;
    }

    static /* synthetic */ int access$9(BasicSplitPaneUI basicSplitPaneUI, int n) {
        basicSplitPaneUI.dividerLocation = n;
        return basicSplitPaneUI.dividerLocation;
    }

    public BasicSplitPaneUI() {
        this.finit$();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSplitPaneUI();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JSplitPane) {
            this.splitPane = (JSplitPane)jComponent;
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.splitPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.splitPane, "SplitPane.background", "SplitPane.foreground");
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        this.divider = this.createDefaultDivider();
        this.divider.setBorder(UIManager.getBorder("SplitPaneDivider.border"));
        this.resetLayoutManager();
        this.nonContinuousLayoutDivider = this.createDefaultNonContinuousLayoutDivider();
        this.splitPane.add((Component)this.divider, "divider");
        this.splitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
        this.splitPane.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.layoutManager = null;
        this.splitPane.remove(this.divider);
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        if (this.splitPane.getBackground() instanceof UIResource) {
            this.splitPane.setBackground(null);
        }
        if (this.splitPane.getBorder() instanceof UIResource) {
            this.splitPane.setBorder(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        this.splitPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
        this.splitPane.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("SplitPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("SplitPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("toggleFocus", new AbstractAction(this, "toggleFocus"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        actionMapUIResource.put("startResize", new AbstractAction(this, "startResize"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.splitPane.requestFocus();
            }
        });
        actionMapUIResource.put("selectMax", new AbstractAction(this, "selectMax"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.splitPane.setDividerLocation(1.0);
            }
        });
        actionMapUIResource.put("selectMin", new AbstractAction(this, "selectMin"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.splitPane.setDividerLocation(0.0);
            }
        });
        actionMapUIResource.put("negativeIncrement", new AbstractAction(this, "negativeIncrement"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setDividerLocation(this.this$0.splitPane, Math.max(this.this$0.dividerLocation - KEYBOARD_DIVIDER_MOVE_OFFSET, 0));
            }
        });
        actionMapUIResource.put("positiveIncrement", new AbstractAction(this, "positiveIncrement"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setDividerLocation(this.this$0.splitPane, this.this$0.dividerLocation + KEYBOARD_DIVIDER_MOVE_OFFSET);
            }
        });
        actionMapUIResource.put("focusOutBackward", new AbstractAction(this, "focusOutBackward"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        actionMapUIResource.put("focusOutForward", new AbstractAction(this, "focusOutForward"){
            private /* synthetic */ BasicSplitPaneUI this$0;
            {
                this.this$0 = basicSplitPaneUI;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        return actionMapUIResource;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.splitPane, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.splitPane, null);
        SwingUtilities.replaceUIInputMap(this.splitPane, 1, null);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler(this);
    }

    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler(this);
    }

    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler(this);
    }

    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler(this);
    }

    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler(this);
    }

    public int getOrientation() {
        return this.splitPane.getOrientation();
    }

    public void setOrientation(int n) {
        this.splitPane.setOrientation(n);
    }

    public boolean isContinuousLayout() {
        return this.splitPane.isContinuousLayout();
    }

    public void setContinuousLayout(boolean bl) {
        this.splitPane.setContinuousLayout(bl);
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int n) {
        this.lastDragLocation = n;
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        if (this.nonContinuousLayoutDivider == null) {
            this.nonContinuousLayoutDivider = new Canvas();
            Color color = UIManager.getColor("SplitPaneDivider.draggingColor");
            this.nonContinuousLayoutDivider.setBackground(color);
        }
        return this.nonContinuousLayoutDivider;
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
        this.nonContinuousLayoutDivider = component;
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        if (this.divider == null) {
            this.divider = new BasicSplitPaneDivider(this);
        }
        return this.divider;
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        this.layoutManager.resetToPreferredSizes();
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        this.dividerLocation = n;
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        return this.dividerLocation;
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n = this.layoutManager.getInitialLocation(jSplitPane.getInsets());
        if (this.layoutManager.components[0] != null) {
            n += this.layoutManager.minimumSizeOfComponent(0);
        }
        return n;
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        int n = this.layoutManager.getInitialLocation(jSplitPane.getInsets()) + this.layoutManager.getAvailableSize(jSplitPane.getSize(), jSplitPane.getInsets()) - this.splitPane.getDividerSize();
        if (this.layoutManager.components[1] != null) {
            n -= this.layoutManager.minimumSizeOfComponent(1);
        }
        return n;
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (!this.splitPane.isContinuousLayout() && this.nonContinuousLayoutDivider != null && this.nonContinuousLayoutDivider.isVisible()) {
            SwingUtilities.paintComponent(graphics, this.nonContinuousLayoutDivider, null, this.nonContinuousLayoutDivider.getBounds());
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.layoutManager.preferredLayoutSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.layoutManager.minimumLayoutSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.layoutManager.maximumLayoutSize(jComponent);
    }

    public Insets getInsets(JComponent jComponent) {
        return this.splitPane.getBorder().getBorderInsets(this.splitPane);
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.getOrientation() == 1 ? new BasicHorizontalLayoutManager(this) : new BasicVerticalLayoutManager(this);
        this.getSplitPane().setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.getSplitPane().revalidate();
    }

    protected void startDragging() {
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.dividerSize = this.divider.getDividerSize();
        this.setLastDragLocation(-1);
        if (component != null && !component.isLightweight() || component2 != null && !component2.isLightweight()) {
            this.draggingHW = true;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.nonContinuousLayoutDivider.setVisible(false);
        } else {
            this.nonContinuousLayoutDivider.setVisible(true);
            this.nonContinuousLayoutDivider.setBounds(this.divider.getBounds());
        }
    }

    protected void dragDividerTo(int n) {
        n = this.validLocation(n);
        if (this.beginDragDividerLocation == -1) {
            this.beginDragDividerLocation = n;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.splitPane.setDividerLocation(n);
        } else {
            Point point = this.nonContinuousLayoutDivider.getLocation();
            if (this.getOrientation() == 1) {
                point.x = n;
            } else {
                point.y = n;
            }
            this.nonContinuousLayoutDivider.setLocation(point);
        }
        this.setLastDragLocation(n);
        this.splitPane.repaint();
    }

    protected void finishDraggingTo(int n) {
        if (this.nonContinuousLayoutDivider != null) {
            this.nonContinuousLayoutDivider.setVisible(false);
        }
        this.draggingHW = false;
        n = this.validLocation(n);
        this.splitPane.setDividerLocation(n);
        this.splitPane.setLastDividerLocation(this.beginDragDividerLocation);
        this.beginDragDividerLocation = -1;
    }

    protected int getDividerBorderSize() {
        if (this.getOrientation() == 1) {
            return this.divider.getBorder().getBorderInsets((Component)this.divider).left;
        }
        return this.divider.getBorder().getBorderInsets((Component)this.divider).top;
    }

    private int validLocation(int n) {
        int n2 = this.getMinimumDividerLocation(this.splitPane);
        int n3 = this.getMaximumDividerLocation(this.splitPane);
        if (n2 > 0 && n < n2) {
            return n2;
        }
        if (n3 > 0 && n > n3) {
            return n3;
        }
        return n;
    }

    static {
        NON_CONTINUOUS_DIVIDER = NON_CONTINUOUS_DIVIDER;
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("dividerSize")) {
                int n = this.this$0.splitPane.getDividerSize();
                int[] nArray = this.this$0.layoutManager.getSizes();
                this.this$0.dividerSize = nArray[2];
                int n2 = n - nArray[2];
                nArray[2] = n;
                nArray[0] = nArray[0] + n2 / 2;
                nArray[1] = nArray[1] + n2 / 2;
                this.this$0.layoutManager.setSizes(nArray);
            } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                int n = this.this$0.layoutManager.getAvailableSize(this.this$0.splitPane.getSize(), this.this$0.splitPane.getInsets());
                int n3 = this.this$0.getDividerLocation(this.this$0.splitPane);
                double d = (double)n3 / (double)n;
                this.this$0.resetLayoutManager();
                if (d <= 1.0 && d >= 0.0) {
                    this.this$0.splitPane.setDividerLocation(d);
                }
            }
        }

        public PropertyHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public KeyboardUpLeftHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public KeyboardResizeToggleHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public KeyboardHomeHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public KeyboardEndHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public KeyboardDownRightHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        private /* synthetic */ BasicSplitPaneUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.divider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.this$0.divider.repaint();
        }

        public FocusHandler(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        private /* synthetic */ BasicSplitPaneUI this$0;

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            return dimension.height - insets.top - insets.bottom;
        }

        protected int getInitialLocation(Insets insets) {
            return insets.top;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            Dimension dimension = component.getPreferredSize();
            if (dimension != null) {
                return dimension.height;
            }
            return 0;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getHeight();
        }

        public Dimension minimumLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                Insets insets = container.getInsets();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.components.length; ++i) {
                    Dimension dimension;
                    if (this.components[i] == null || (dimension = this.components[i].getMinimumSize()) == null) continue;
                    n += dimension.height;
                    n2 = Math.max(n2, dimension.width);
                }
                return new Dimension(n2, n);
            }
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                Insets insets = container.getInsets();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.components.length; ++i) {
                    Dimension dimension;
                    if (this.components[i] == null || (dimension = this.components[i].getPreferredSize()) == null) continue;
                    n += dimension.height;
                    n2 = Math.max(n2, dimension.width);
                }
                return new Dimension(n2, n);
            }
            return null;
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            int n3 = n2;
            int n4 = insets.left;
            int n5 = n;
            int n6 = dimension.width - insets.left - insets.right;
            component.setBounds(n4, n3, n6, n5);
        }

        int minimumSizeOfComponent(int n) {
            Dimension dimension = this.components[n].getMinimumSize();
            if (dimension != null) {
                return dimension.height;
            }
            return 0;
        }

        public BasicVerticalLayoutManager(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
            super(basicSplitPaneUI);
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        private /* synthetic */ BasicSplitPaneUI this$0;
        protected Component[] components;
        protected int[] sizes;

        private /* synthetic */ void finit$() {
            this.components = new Component[3];
            this.sizes = new int[3];
        }

        BasicHorizontalLayoutManager(BasicSplitPaneUI basicSplitPaneUI) {
            this.this$0 = basicSplitPaneUI;
            this.finit$();
        }

        public void addLayoutComponent(Component component, Object object) {
            this.addLayoutComponent((String)object, component);
        }

        public void addLayoutComponent(String string, Component component) {
            int n = 0;
            if (string == null) {
                n = 2;
            } else if (string.equals("top") || string.equals("left")) {
                n = 0;
            } else if (string.equals("bottom") || string.equals("right")) {
                n = 1;
            } else {
                throw new IllegalArgumentException("Illegal placement in JSplitPane");
            }
            this.components[n] = component;
            this.resetSizeAt(n);
            this.this$0.splitPane.revalidate();
            this.this$0.splitPane.repaint();
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            return dimension.width - insets.left - insets.right;
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.left;
            }
            return 0;
        }

        public float getLayoutAlignmentX(Container container) {
            return container.getAlignmentX();
        }

        public float getLayoutAlignmentY(Container container) {
            return container.getAlignmentY();
        }

        protected int getPreferredSizeOfComponent(Component component) {
            Dimension dimension = component.getPreferredSize();
            if (dimension != null) {
                return dimension.width;
            }
            return 0;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getWidth();
        }

        protected int[] getSizes() {
            return this.sizes;
        }

        public void invalidateLayout(Container container) {
        }

        public void layoutContainer(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                this.distributeExtraSpace();
                Insets insets = jSplitPane.getInsets();
                Dimension dimension = jSplitPane.getSize();
                int n = this.getInitialLocation(insets);
                int n2 = this.getAvailableSize(dimension, insets);
                this.sizes[0] = this.this$0.getDividerLocation(jSplitPane) - n;
                this.sizes[1] = n2 - this.sizes[0] - this.sizes[2];
                this.setComponentToSize(this.components[0], this.sizes[0], n, insets, dimension);
                this.setComponentToSize(this.components[2], this.sizes[2], n += this.sizes[0], insets, dimension);
                this.setComponentToSize(this.components[1], this.sizes[1], n += this.sizes[2], insets, dimension);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                Insets insets = container.getInsets();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.components.length; ++i) {
                    Dimension dimension;
                    if (this.components[i] == null || (dimension = this.components[i].getMinimumSize()) == null) continue;
                    n2 += dimension.width;
                    n = Math.max(n, dimension.height);
                }
                return new Dimension(n2, n);
            }
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                Insets insets = container.getInsets();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.components.length; ++i) {
                    Dimension dimension;
                    if (this.components[i] == null || (dimension = this.components[i].getPreferredSize()) == null) continue;
                    n2 += dimension.width;
                    if (this.components[i] instanceof BasicSplitPaneDivider) continue;
                    n = Math.max(n, dimension.height);
                }
                return new Dimension(n2, n);
            }
            return null;
        }

        public void removeLayoutComponent(Component component) {
            for (int i = 0; i < this.components.length; ++i) {
                if (component != this.components[i]) continue;
                this.components[i] = null;
                this.sizes[i] = 0;
            }
        }

        protected void resetSizeAt(int n) {
            if (this.components[n] != null) {
                this.sizes[n] = this.getPreferredSizeOfComponent(this.components[n]);
            }
        }

        public void resetToPreferredSizes() {
            for (int i = 0; i < this.components.length; ++i) {
                this.resetSizeAt(i);
            }
            this.this$0.setDividerLocation(this.this$0.splitPane, this.getInitialLocation(this.this$0.splitPane.getInsets()) + this.sizes[0]);
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            int n3 = n;
            int n4 = dimension.height - insets.top - insets.bottom;
            int n5 = n2;
            int n6 = insets.top;
            component.setBounds(n5, n6, n3, n4);
        }

        protected void setSizes(int[] nArray) {
            this.sizes = nArray;
        }

        protected void updateComponents() {
            Component component = this.this$0.splitPane.getLeftComponent();
            Component component2 = this.this$0.splitPane.getRightComponent();
            if (component != null) {
                this.components[0] = component;
                this.resetSizeAt(0);
            }
            if (component2 != null) {
                this.components[1] = component2;
                this.resetSizeAt(1);
            }
            this.components[2] = this.this$0.divider;
            this.resetSizeAt(2);
        }

        void distributeExtraSpace() {
        }

        int minimumSizeOfComponent(int n) {
            Dimension dimension = this.components[n].getMinimumSize();
            if (dimension != null) {
                return dimension.width;
            }
            return 0;
        }
    }
}

