/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    static WeakHashMap currentRepaintManagers;
    private static Rectangle rectCache;
    private HashMap dirtyComponents = new HashMap();
    private HashMap dirtyComponentsWork = new HashMap();
    private RepaintWorker repaintWorker;
    private ArrayList invalidComponents = new ArrayList();
    private boolean doubleBufferingEnabled = true;
    private WeakHashMap offscreenBuffers;
    private boolean repaintUnderway = false;
    private HashMap commitRequests;
    private Dimension doubleBufferMaximumSize;

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker(this);
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
        this.offscreenBuffers = new WeakHashMap();
        this.commitRequests = new HashMap();
    }

    public static RepaintManager currentManager(Component component) {
        ThreadGroup threadGroup;
        RepaintManager repaintManager;
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        if ((repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup = Thread.currentThread().getThreadGroup())) == null) {
            repaintManager = new RepaintManager();
            currentRepaintManagers.put(threadGroup, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        currentRepaintManagers.put(threadGroup, repaintManager);
    }

    public void addInvalidComponent(JComponent jComponent) {
        Container container;
        Container container2 = null;
        for (container = jComponent; container != null; container = container.getParent()) {
            if (container instanceof CellRendererPane || !container.isDisplayable()) {
                return;
            }
            if (!(container instanceof JComponent) || !((JComponent)container).isValidateRoot()) continue;
            container2 = container;
            break;
        }
        if (container2 == null) {
            return;
        }
        for (container = container2; container != null; container = container.getParent()) {
            if (container.isVisible() && container.isDisplayable()) continue;
            return;
        }
        if (this.invalidComponents.contains(container2)) {
            return;
        }
        this.invalidComponents.add(container2);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    public void removeInvalidComponent(JComponent jComponent) {
        ArrayList arrayList = this.invalidComponents;
        synchronized (arrayList) {
            try {
                this.invalidComponents.remove(jComponent);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        block8: {
            if (n3 <= 0) {
                return;
            }
            if (n4 <= 0) {
                return;
            }
            if (!jComponent.isShowing()) {
                return;
            }
            Container container = jComponent.getParent();
            jComponent.computeVisibleRect(rectCache);
            SwingUtilities.computeIntersection(n, n2, n3, n4, rectCache);
            if (rectCache.isEmpty()) return;
            if (this.dirtyComponents.containsKey(jComponent)) {
                SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, (Rectangle)this.dirtyComponents.get(jComponent));
            } else {
                HashMap hashMap = this.dirtyComponents;
                // MONITORENTER : hashMap
                this.dirtyComponents.put(jComponent, rectCache.getBounds());
                Object var8_8 = null;
                // MONITOREXIT : hashMap
            }
            break block8;
            catch (Throwable throwable) {
                Object var8_9 = null;
                // MONITOREXIT : hashMap
                throw throwable;
            }
        }
        if (this.repaintWorker.isLive()) return;
        this.repaintWorker.setLive(true);
        SwingUtilities.invokeLater(this.repaintWorker);
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void markCompletelyClean(JComponent jComponent) {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            try {
                this.dirtyComponents.remove(jComponent);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        boolean bl = false;
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        if (rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void validateInvalidComponents() {
        while (this.invalidComponents.size() > 0) {
            Object var3_3;
            Component component;
            ArrayList arrayList = this.invalidComponents;
            // MONITORENTER : arrayList
            try {
                component = (Component)this.invalidComponents.remove(0);
            }
            catch (Throwable throwable) {
                var3_3 = null;
                // MONITOREXIT : arrayList
                throw throwable;
            }
            var3_3 = null;
            // MONITOREXIT : arrayList
            if (!component.isVisible()) {
                continue;
            }
            if (!component.isShowing()) continue;
            component.validate();
        }
    }

    public void paintDirtyRegions() {
        if (this.dirtyComponents.size() == 0) {
            return;
        }
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            JComponent jComponent;
            Cloneable cloneable;
            try {
                cloneable = this.dirtyComponents;
                this.dirtyComponents = this.dirtyComponentsWork;
                this.dirtyComponentsWork = cloneable;
            }
            finally {
                cloneable = null;
            }
            cloneable = new HashSet();
            Set set = this.dirtyComponentsWork.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                this.compileRepaintRoots(this.dirtyComponentsWork, jComponent, (HashSet)cloneable);
            }
            this.repaintUnderway = true;
            iterator = ((HashSet)cloneable).iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                Rectangle rectangle = (Rectangle)this.dirtyComponentsWork.remove(jComponent);
                if (rectangle == null || rectangle.isEmpty()) continue;
                jComponent.paintImmediately(rectangle);
            }
            this.dirtyComponentsWork.clear();
            this.repaintUnderway = false;
            this.commitRemainingBuffers();
            return;
        }
    }

    private void compileRepaintRoots(HashMap hashMap, JComponent jComponent, HashSet hashSet) {
        Container container;
        Container container2 = jComponent;
        JComponent jComponent2 = jComponent;
        while ((container = container2.getParent()) != null && container instanceof JComponent) {
            container2 = container;
            if (!hashMap.containsKey(container)) continue;
            jComponent2 = container2;
        }
        if (jComponent2 != jComponent) {
            Rectangle rectangle = (Rectangle)hashMap.get(jComponent);
            rectangle = SwingUtilities.convertRectangle(jComponent, rectangle, jComponent2);
            Rectangle rectangle2 = (Rectangle)hashMap.get(jComponent2);
            SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
        }
        hashSet.add(jComponent2);
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        Window window = SwingUtilities.getWindowAncestor(component);
        Image image = (Image)this.offscreenBuffers.get(window);
        if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2) {
            int n3 = Math.max(n, window.getWidth());
            n3 = Math.min(this.doubleBufferMaximumSize.width, n3);
            int n4 = Math.max(n2, window.getHeight());
            n4 = Math.min(this.doubleBufferMaximumSize.height, n4);
            image = window.createImage(n3, n4);
            this.offscreenBuffers.put(window, image);
        }
        return image;
    }

    void commitBuffer(Component component, Rectangle rectangle) {
        Component component2 = this.getHeavyweightParent(component);
        Rectangle rectangle2 = SwingUtilities.convertRectangle(component, rectangle, component2);
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            try {
                this.blitBuffer(component2, rectangle2);
            }
            finally {
                Object var6_6 = null;
            }
            return;
        }
    }

    private void blitBuffer(Component component, Rectangle rectangle) {
        if (!component.isShowing()) {
            return;
        }
        Component component2 = component;
        Rectangle rectangle2 = rectangle.getBounds();
        if (!(component2 instanceof Window)) {
            component2 = SwingUtilities.getWindowAncestor(component2);
            SwingUtilities.convertRectangleToAncestor(component, rectangle, component2);
        }
        Graphics graphics = component.getGraphics();
        Image image = (Image)this.offscreenBuffers.get(component2);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(image, rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, component);
        graphics.dispose();
    }

    private Component getHeavyweightParent(Component component) {
        while (component != null && component.isLightweight()) {
            component = component.getParent();
        }
        return component;
    }

    private void commitRemainingBuffers() {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            try {
                Set set = this.commitRequests.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Component component = (Component)entry.getKey();
                    Rectangle rectangle = (Rectangle)entry.getValue();
                    this.blitBuffer(component, rectangle);
                    iterator.remove();
                }
                set = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        Window window = SwingUtilities.getWindowAncestor(component);
        Image image = (Image)this.offscreenBuffers.get(window);
        if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2 || !(image instanceof VolatileImage)) {
            int n3 = Math.max(n, window.getWidth());
            n3 = Math.min(this.doubleBufferMaximumSize.width, n3);
            int n4 = Math.max(n2, window.getHeight());
            image = window.createVolatileImage(n3, n4 = Math.min(this.doubleBufferMaximumSize.height, n4));
            if (image != null) {
                this.offscreenBuffers.put(window, image);
            }
        }
        return image;
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaximumSize = dimension;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    static {
        rectCache = new Rectangle();
    }

    private class RepaintWorker
    implements Runnable {
        private /* synthetic */ RepaintManager this$0;
        boolean live = false;

        public RepaintWorker(RepaintManager repaintManager) {
            this.this$0 = repaintManager;
        }

        public synchronized void setLive(boolean bl) {
            this.live = bl;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        public void run() {
            ThreadGroup threadGroup;
            try {
                threadGroup = Thread.currentThread().getThreadGroup();
                RepaintManager repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup);
                repaintManager.validateInvalidComponents();
                repaintManager.paintDirtyRegions();
            }
            finally {
                threadGroup = null;
                this.setLive(false);
            }
        }
    }
}

