/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.util.Locale;
import javax.imageio.IIOParam;

public class ImageWriteParam
extends IIOParam {
    public static final int MODE_DISABLED = 0;
    public static final int MODE_DEFAULT = 1;
    public static final int MODE_EXPLICIT = 2;
    public static final int MODE_COPY_FROM_METADATA = 3;
    protected boolean canOffsetTiles;
    protected boolean canWriteCompressed;
    protected boolean canWriteProgressive;
    protected boolean canWriteTiles;
    protected int compressionMode;
    protected float compressionQuality;
    protected String compressionType;
    protected String[] compressionTypes;
    protected Locale locale;
    protected Dimension[] preferredTileSizes;
    protected int progressiveMode;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int tileHeight;
    protected int tileWidth;
    protected int tilingMode;
    protected boolean tilingSet;

    private /* synthetic */ void finit$() {
        this.compressionMode = 3;
        this.progressiveMode = 3;
    }

    protected ImageWriteParam() {
        this.finit$();
    }

    public ImageWriteParam(Locale locale) {
        this.finit$();
        this.locale = locale;
    }

    public float getBitRate(float f) {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return -1.0f;
    }

    private void checkSupportsCompression() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("compression not supported");
        }
    }

    private void checkNotExplicitCompression() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("compression mode is not MODE_EXPLICIT");
        }
    }

    private void checkCompressionTypesSet() {
        if (this.getCompressionType() == null && this.getCompressionTypes() != null) {
            throw new IllegalStateException("no compression type set");
        }
    }

    private void checkSupportsProgressiveEncoding() {
        if (!this.canWriteProgressive()) {
            throw new UnsupportedOperationException("progressive output not supported");
        }
    }

    private void checkSupportsTiling() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("tiling not supported");
        }
    }

    private void checkNotExplicitTiling() {
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("tiling mode not MODE_EXPLICIT");
        }
    }

    private void checkTilingInitialized() {
        if (!this.tilingSet) {
            throw new IllegalStateException("tiling parameters not set");
        }
    }

    private void checkMode(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("mode not supported");
        }
    }

    public boolean canOffsetTiles() {
        return this.canOffsetTiles;
    }

    public boolean canWriteCompressed() {
        return this.canWriteCompressed;
    }

    public boolean canWriteProgressive() {
        return this.canWriteProgressive;
    }

    public boolean canWriteTiles() {
        return this.canWriteTiles;
    }

    public int getCompressionMode() {
        this.checkSupportsCompression();
        return this.compressionMode;
    }

    public float getCompressionQuality() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return this.compressionQuality;
    }

    public String[] getCompressionQualityDescriptions() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return null;
    }

    public float[] getCompressionQualityValues() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return null;
    }

    public String getCompressionType() {
        this.checkNotExplicitCompression();
        return this.compressionType;
    }

    public String[] getCompressionTypes() {
        this.checkSupportsCompression();
        if (this.compressionTypes != null) {
            return (String[])this.compressionTypes.clone();
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedCompressionTypeName() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return this.getCompressionType();
    }

    public Dimension[] getPreferredTileSizes() {
        this.checkSupportsTiling();
        return this.preferredTileSizes;
    }

    public int getProgressiveMode() {
        this.checkSupportsProgressiveEncoding();
        return this.progressiveMode;
    }

    public int getTileGridXOffset() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileHeight;
    }

    public int getTileWidth() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileWidth;
    }

    public int getTilingMode() {
        this.checkSupportsTiling();
        return this.tilingMode;
    }

    public boolean isCompressionLossless() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return true;
    }

    public void setCompressionMode(int n) {
        this.checkSupportsCompression();
        this.checkMode(n);
        this.compressionMode = n;
        if (n == 2) {
            this.unsetCompression();
        }
    }

    public void setCompressionQuality(float f) {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("quality out of range");
        }
        this.compressionQuality = f;
    }

    public void setCompressionType(String string) {
        this.checkNotExplicitCompression();
        String[] stringArray = this.getCompressionTypes();
        if (stringArray == null) {
            throw new UnsupportedOperationException("no settable compression types");
        }
        if (string == null) {
            this.compressionType = null;
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!stringArray[i].equals(string)) continue;
            this.compressionType = string;
            return;
        }
        throw new IllegalArgumentException("unknown compression type");
    }

    public void setProgressiveMode(int n) {
        this.checkSupportsProgressiveEncoding();
        this.checkMode(n);
        this.progressiveMode = n;
    }

    public void setTiling(int n, int n2, int n3, int n4) {
        this.checkNotExplicitTiling();
        if (!this.canOffsetTiles && n3 != 0 && n4 != 0) {
            throw new UnsupportedOperationException("tile offsets not supported");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("negative tile dimension");
        }
        if (this.preferredTileSizes != null) {
            boolean bl = false;
            for (int i = 0; i < this.preferredTileSizes.length; i += 2) {
                if (n < this.preferredTileSizes[i].width || n > this.preferredTileSizes[i + 1].width || n2 < this.preferredTileSizes[i].height || n2 > this.preferredTileSizes[i + 1].height) continue;
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException("illegal tile size");
            }
        }
        this.tilingSet = true;
        this.tileWidth = n;
        this.tileHeight = n2;
        this.tileGridXOffset = n3;
        this.tileGridYOffset = n4;
    }

    public void setTilingMode(int n) {
        this.checkSupportsTiling();
        this.checkMode(n);
        this.tilingMode = n;
    }

    public void unsetCompression() {
        this.checkNotExplicitCompression();
        this.compressionType = null;
        this.compressionQuality = 1.0f;
    }

    public void unsetTiling() {
        this.checkNotExplicitTiling();
        this.tileWidth = 0;
        this.tileHeight = 0;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
    }
}

