/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.PlainSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl;
    private InetSocketAddress local;

    ServerSocket(SocketImpl socketImpl) throws IOException {
        if (socketImpl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = socketImpl;
        this.impl.create(true);
    }

    SocketImpl getImpl() {
        return this.impl;
    }

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this();
        this.bind(new InetSocketAddress(inetAddress, n), n2);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        InetAddress inetAddress;
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address type not supported");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(inetSocketAddress.getPort());
        }
        if ((inetAddress = inetSocketAddress.getAddress()) == null) {
            inetAddress = InetAddress.ANY_IF;
        }
        try {
            this.impl.bind(inetAddress, inetSocketAddress.getPort());
            this.impl.listen(n);
            this.local = new InetSocketAddress((InetAddress)this.impl.getOption(15), this.impl.getLocalPort());
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        catch (Error error) {
            this.close();
            throw error;
        }
    }

    public InetAddress getInetAddress() {
        if (this.local == null) {
            return null;
        }
        return this.local.getAddress();
    }

    public int getLocalPort() {
        if (this.local == null) {
            return -1;
        }
        return this.local.getPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.local;
    }

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        try {
            this.implAccept(socket);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((PlainSocketImpl)this.getImpl()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.accept(socket.impl);
        socket.implCreated = true;
        socket.bound = true;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.impl.close();
        this.impl = null;
        if (this.getChannel() != null) {
            this.getChannel().close();
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.local != null;
    }

    public boolean isClosed() {
        return this.impl == null;
    }

    public void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(n));
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4102);
        if (!(object instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)object;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        this.impl.setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4);
        if (!(object instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)object;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, new Integer(n));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("ServerSocket is closed");
        }
        Object object = this.impl.getOption(4098);
        if (!(object instanceof Integer)) {
            throw new SocketException("Internal Error: Unexpected type");
        }
        return (Integer)object;
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",port=" + this.impl.getPort() + ",localport=" + this.impl.getLocalPort() + "]";
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }
}

