/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class DirectColorModel
extends PackedColorModel {
    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(ColorSpace.getInstance(1000), n, n2, n3, n4, 0, false, Buffers.smallestAppropriateTransferType(n));
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        this(ColorSpace.getInstance(1000), n, n2, n3, n4, n5, false, Buffers.smallestAppropriateTransferType(n));
    }

    public DirectColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(colorSpace, n, n2, n3, n4, n5, bl, n5 == 0 ? 1 : 3, n6);
    }

    public final int getRedMask() {
        return this.getMask(0);
    }

    public final int getGreenMask() {
        return this.getMask(1);
    }

    public final int getBlueMask() {
        return this.getMask(2);
    }

    public final int getAlphaMask() {
        if (this.hasAlpha()) {
            return this.getMask(3);
        }
        return 0;
    }

    public final int getRed(int n) {
        return this.extractAndNormalizeSample(n, 0);
    }

    public final int getGreen(int n) {
        return this.extractAndNormalizeSample(n, 1);
    }

    public final int getBlue(int n) {
        return this.extractAndNormalizeSample(n, 2);
    }

    public final int getAlpha(int n) {
        if (!this.hasAlpha()) {
            return 255;
        }
        return this.extractAndScaleSample(n, 3);
    }

    private int extractAndNormalizeSample(int n, int n2) {
        int n3 = this.extractAndScaleSample(n, n2);
        if (this.hasAlpha() && this.isAlphaPremultiplied() && this.getAlpha(n) != 0) {
            n3 = n3 * 255 / this.getAlpha(n);
        }
        return n3;
    }

    private int extractAndScaleSample(int n, int n2) {
        int n3 = n & this.getMask(n2);
        int n4 = 8 - this.shifts[n2] - this.getComponentSize(n2);
        if (n4 > 0) {
            return n3 << (n4 & 0x1F);
        }
        return n3 >>> (-n4 & 0x1F);
    }

    public final int getRGB(int n) {
        return super.getRGB(n);
    }

    public int getRed(Object object) {
        return this.getRed(this.getPixelFromArray(object));
    }

    public int getGreen(Object object) {
        return this.getGreen(this.getPixelFromArray(object));
    }

    public int getBlue(Object object) {
        return this.getBlue(this.getPixelFromArray(object));
    }

    public int getAlpha(Object object) {
        return this.getAlpha(this.getPixelFromArray(object));
    }

    public int getRGB(Object object) {
        return this.getRGB(this.getPixelFromArray(object));
    }

    public Object getDataElements(int n, Object object) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.hasAlpha()) {
            n4 = n >>> 24 & 0xFF;
            n3 = this.valueToField(n4, 3, 8);
        }
        if (this.hasAlpha() && this.isAlphaPremultiplied()) {
            int n5 = (n >>> 8 & 0xFF00) * n4 / 255;
            int n6 = (n >>> 0 & 0xFF00) * n4 / 255;
            n2 = (n << 8 & 0xFF00) * n4 / 255;
            n3 |= this.valueToField(n5, 0, 16) | this.valueToField(n6, 1, 16) | this.valueToField(n2, 2, 16);
        } else {
            int n7 = n >>> 16 & 0xFF;
            int n8 = n >>> 8 & 0xFF;
            n2 = n >>> 0 & 0xFF;
            n3 |= this.valueToField(n7, 0, 8) | this.valueToField(n8, 1, 8) | this.valueToField(n2, 2, 8);
        }
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, 1);
        dataBuffer.setElem(0, n3);
        return Buffers.getData(dataBuffer);
    }

    private int valueToField(int n, int n2, int n3) {
        int n4 = this.getComponentSize(n2) + this.shifts[n2] - n3;
        int n5 = n4 > 0 ? n << (n4 & 0x1F) : n >>> (-n4 & 0x1F);
        return n5 & this.getMask(n2);
    }

    private int value16ToField(int n, int n2) {
        int n3 = this.getComponentSize(n2) + this.shifts[n2] - 16;
        if (n3 > 0) {
            return n << (n3 & 0x1F);
        }
        return n >>> (-n3 & 0x1F);
    }

    public final int[] getComponents(int n, int[] nArray, int n2) {
        int n3 = this.getNumComponents();
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        for (int i = 0; i < n3; ++i) {
            nArray[n2++] = (n & this.getMask(i)) >>> (this.shifts[i] & 0x1F);
        }
        return nArray;
    }

    public final int[] getComponents(Object object, int[] nArray, int n) {
        return this.getComponents(this.getPixelFromArray(object), nArray, n);
    }

    public final WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width (=" + n + ") and height (=" + n2 + ") must be > 0");
        }
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel, point);
    }

    public int getDataElement(int[] nArray, int n) {
        int n2 = this.getNumComponents();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= nArray[n++] << (this.shifts[i] & 0x1F) & this.getMask(i);
        }
        return n3;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = this.getDataElement(nArray, n);
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, 1);
        dataBuffer.setElem(0, n2);
        return Buffers.getData(dataBuffer);
    }

    public final ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        if (this.isAlphaPremultiplied == bl) {
            return this;
        }
        super.coerceData(writableRaster, bl);
        return new ComponentColorModel(this.cspace, this.bits, this.hasAlpha(), bl, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        return super.isCompatibleRaster(raster);
    }

    String stringParam() {
        return super.stringParam() + ", redMask=" + Integer.toHexString(this.getRedMask()) + ", greenMask=" + Integer.toHexString(this.getGreenMask()) + ", blueMask=" + Integer.toHexString(this.getBlueMask()) + ", alphaMask=" + Integer.toHexString(this.getAlphaMask());
    }

    public String toString() {
        return super.toString();
    }
}

