/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SwingCallbackHandler
extends AbstractCallbackHandler {
    public SwingCallbackHandler() {
        super("SWING");
    }

    protected void handleChoice(ChoiceCallback choiceCallback) throws IOException {
        JDialog jDialog = new JDialog();
        jDialog.setResizable(false);
        Container container = jDialog.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(choiceCallback.getPrompt(), 2);
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 5, 5));
        Object[] objectArray = choiceCallback.getChoices();
        JList jList = new JList(objectArray);
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        int n = choiceCallback.getDefaultChoice();
        jList.setSelectedIndex(n);
        jList.setSelectionMode(choiceCallback.allowMultipleSelections() ? 2 : 0);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        jDialog.getRootPane().setDefaultButton(jButton2);
        jButton.addActionListener(new ActionListener(this, n, jList, jDialog, choiceCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ int val$defaultChoice;
            private /* synthetic */ JList val$choicesList;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ ChoiceCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(n, jList, jDialog, choiceCallback);
            }

            private /* synthetic */ void finit$(int n, JList jList, JDialog jDialog, ChoiceCallback choiceCallback) {
                this.val$callback = choiceCallback;
                this.val$dialog = jDialog;
                this.val$choicesList = jList;
                this.val$defaultChoice = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$callback.setSelectedIndex(this.val$defaultChoice);
                this.val$dialog.setVisible(false);
                ChoiceCallback choiceCallback = this.val$callback;
                synchronized (choiceCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var3_3 = null;
                    }
                    return;
                }
            }
        });
        jButton2.addActionListener(new ActionListener(this, n, jList, jDialog, choiceCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ int val$defaultChoice;
            private /* synthetic */ JList val$choicesList;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ ChoiceCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(n, jList, jDialog, choiceCallback);
            }

            private /* synthetic */ void finit$(int n, JList jList, JDialog jDialog, ChoiceCallback choiceCallback) {
                this.val$callback = choiceCallback;
                this.val$dialog = jDialog;
                this.val$choicesList = jList;
                this.val$defaultChoice = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (this.val$callback.allowMultipleSelections()) {
                    object = this.val$choicesList.getSelectedIndices();
                    if (object != null && ((int[])object).length > 0) {
                        this.val$callback.setSelectedIndexes((int[])object);
                    } else {
                        this.val$callback.setSelectedIndex(this.val$defaultChoice);
                    }
                } else {
                    int n = this.val$choicesList.getSelectedIndex();
                    if (n != -1) {
                        this.val$callback.setSelectedIndex(n);
                    } else {
                        this.val$callback.setSelectedIndex(this.val$defaultChoice);
                    }
                }
                this.val$dialog.setVisible(false);
                object = this.val$callback;
                synchronized (object) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var3_4 = null;
                    }
                    return;
                }
            }
        });
        jDialog.pack();
        jDialog.setSize(new Dimension(400, 400));
        jDialog.setVisible(true);
        this.waitForInput(jDialog, choiceCallback);
    }

    protected void handleConfirmation(ConfirmationCallback confirmationCallback) throws IOException {
        JDialog jDialog = new JDialog();
        switch (confirmationCallback.getMessageType()) {
            case 2: {
                jDialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                jDialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                jDialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        String string = confirmationCallback.getPrompt();
        if (string != null) {
            container.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 25), 0, 0));
        }
        String[] stringArray = confirmationCallback.getOptions();
        ActionListener actionListener = new ActionListener(this, stringArray, jDialog, confirmationCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ String[] val$options;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ ConfirmationCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(stringArray, jDialog, confirmationCallback);
            }

            private /* synthetic */ void finit$(String[] stringArray, JDialog jDialog, ConfirmationCallback confirmationCallback) {
                this.val$callback = confirmationCallback;
                this.val$dialog = jDialog;
                this.val$options = stringArray;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (this.val$options != null) {
                    for (int i = 0; i < this.val$options.length; ++i) {
                        if (!string.equals(this.val$options[i])) continue;
                        this.val$callback.setSelectedIndex(i);
                        break;
                    }
                } else if (string.equals("cancel")) {
                    this.val$callback.setSelectedIndex(2);
                } else if (string.equals("okay")) {
                    this.val$callback.setSelectedIndex(3);
                } else if (string.equals("yes")) {
                    this.val$callback.setSelectedIndex(0);
                } else if (string.equals("no")) {
                    this.val$callback.setSelectedIndex(1);
                }
                this.val$dialog.setVisible(false);
                ConfirmationCallback confirmationCallback = this.val$callback;
                synchronized (confirmationCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var4_5 = null;
                    }
                    return;
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        switch (confirmationCallback.getOptionType()) {
            case 1: {
                JButton jButton = new JButton(this.messages.getString("callback.cancel"));
                jPanel.add(jButton);
                jButton.setActionCommand("cancel");
                jButton.addActionListener(actionListener);
            }
            case 0: {
                JButton jButton = new JButton(this.messages.getString("callback.yes"));
                JButton jButton2 = new JButton(this.messages.getString("callback.no"));
                jPanel.add(jButton2);
                jPanel.add(jButton);
                jButton.setActionCommand("yes");
                jButton.addActionListener(actionListener);
                jButton2.setActionCommand("no");
                jButton2.addActionListener(actionListener);
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 2: {
                JButton jButton = new JButton(this.messages.getString("callback.ok"));
                JButton jButton3 = new JButton(this.messages.getString("callback.cancel"));
                jPanel.add(jButton3);
                jPanel.add(jButton);
                jButton.setActionCommand("okay");
                jButton.addActionListener(actionListener);
                jButton3.setActionCommand("cancel");
                jButton3.addActionListener(actionListener);
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case -1: {
                for (int i = 0; i < stringArray.length; ++i) {
                    JButton jButton = new JButton(stringArray[i]);
                    jPanel.add(jButton);
                    jButton.setActionCommand(stringArray[i]);
                    jButton.addActionListener(actionListener);
                    if (i != stringArray.length - 1) continue;
                    jDialog.getRootPane().setDefaultButton(jButton);
                }
                break;
            }
        }
        container.add((Component)jPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 14, 1, new Insets(5, 5, 5, 5), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        this.waitForInput(jDialog, confirmationCallback);
    }

    protected void handleLanguage(LanguageCallback languageCallback) throws IOException {
        Object object;
        Locale locale = Locale.getDefault();
        Locale[] localeArray = Locale.getAvailableLocales();
        String[] stringArray = new String[localeArray.length + 1];
        int n = 0;
        for (int i = 0; i < localeArray.length; ++i) {
            stringArray[i + 1] = localeArray[i].getDisplayLanguage(localeArray[i]);
            object = localeArray[i].getDisplayCountry(localeArray[i]);
            if (((String)object).length() > 0) {
                stringArray[i + 1] = stringArray[i + 1] + new StringBuffer(" (").append((String)object).append(")");
            }
            if (!localeArray[i].equals(locale)) continue;
            n = i;
        }
        localeArray[0] = locale;
        stringArray[0] = locale.getDisplayLanguage(locale);
        String string = locale.getDisplayCountry(locale);
        if (string.length() > 0) {
            stringArray[0] = stringArray[0] + new StringBuffer(" (").append(string).append(")");
        }
        object = new ChoiceCallback(this.messages.getString("callback.language"), stringArray, 0, false);
        this.handleChoice((ChoiceCallback)object);
        int n2 = ((ChoiceCallback)object).getSelectedIndexes()[0];
        if (n2 > 0) {
            languageCallback.setLocale(localeArray[n2 - 1]);
        } else {
            languageCallback.setLocale(locale);
        }
    }

    protected void handleName(NameCallback nameCallback) throws IOException {
        JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(nameCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        JTextField jTextField = new JTextField();
        jTextField.setColumns(20);
        String string = nameCallback.getDefaultName();
        if (string != null) {
            jTextField.setText(string);
        }
        container.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener actionListener = new ActionListener(this, jTextField, jDialog, nameCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ JTextField val$name;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ NameCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(jTextField, jDialog, nameCallback);
            }

            private /* synthetic */ void finit$(JTextField jTextField, JDialog jDialog, NameCallback nameCallback) {
                this.val$callback = nameCallback;
                this.val$dialog = jDialog;
                this.val$name = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    this.val$callback.setName(this.val$name.getText());
                }
                this.val$dialog.setVisible(false);
                NameCallback nameCallback = this.val$callback;
                synchronized (nameCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    return;
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, nameCallback);
    }

    protected void handlePassword(PasswordCallback passwordCallback) throws IOException {
        JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(passwordCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setColumns(20);
        jPasswordField.setEchoChar(passwordCallback.isEchoOn() ? (char)'\u0000' : '\u2022');
        container.add((Component)jPasswordField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener actionListener = new ActionListener(this, jPasswordField, jDialog, passwordCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ JPasswordField val$password;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ PasswordCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(jPasswordField, jDialog, passwordCallback);
            }

            private /* synthetic */ void finit$(JPasswordField jPasswordField, JDialog jDialog, PasswordCallback passwordCallback) {
                this.val$callback = passwordCallback;
                this.val$dialog = jDialog;
                this.val$password = jPasswordField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    this.val$callback.setPassword(this.val$password.getPassword());
                }
                this.val$dialog.setVisible(false);
                PasswordCallback passwordCallback = this.val$callback;
                synchronized (passwordCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    return;
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, passwordCallback);
    }

    protected void handleTextInput(TextInputCallback textInputCallback) throws IOException {
        JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(textInputCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 15, 5), 0, 0));
        JTextArea jTextArea = new JTextArea(24, 80);
        jTextArea.setEditable(true);
        String string = textInputCallback.getDefaultText();
        if (string != null) {
            jTextArea.setText(string);
        }
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        ActionListener actionListener = new ActionListener(this, jTextArea, jDialog, textInputCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ JTextArea val$text;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ TextInputCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(jTextArea, jDialog, textInputCallback);
            }

            private /* synthetic */ void finit$(JTextArea jTextArea, JDialog jDialog, TextInputCallback textInputCallback) {
                this.val$callback = textInputCallback;
                this.val$dialog = jDialog;
                this.val$text = jTextArea;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    this.val$callback.setText(this.val$text.getText());
                }
                this.val$dialog.setVisible(false);
                TextInputCallback textInputCallback = this.val$callback;
                synchronized (textInputCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    return;
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, textInputCallback);
    }

    protected void handleTextOutput(TextOutputCallback textOutputCallback) throws IOException {
        JDialog jDialog = new JDialog();
        switch (textOutputCallback.getMessageType()) {
            case 2: {
                jDialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                jDialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                jDialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea(24, 80);
        jTextArea.setEditable(false);
        jTextArea.setText(textOutputCallback.getMessage());
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        ActionListener actionListener = new ActionListener(this, jTextArea, jDialog, textOutputCallback){
            private /* synthetic */ SwingCallbackHandler this$0;
            private /* synthetic */ JTextArea val$text;
            private /* synthetic */ JDialog val$dialog;
            private /* synthetic */ TextOutputCallback val$callback;
            {
                this.this$0 = swingCallbackHandler;
                this.finit$(jTextArea, jDialog, textOutputCallback);
            }

            private /* synthetic */ void finit$(JTextArea jTextArea, JDialog jDialog, TextOutputCallback textOutputCallback) {
                this.val$callback = textOutputCallback;
                this.val$dialog = jDialog;
                this.val$text = jTextArea;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dialog.setVisible(false);
                TextOutputCallback textOutputCallback = this.val$callback;
                synchronized (textOutputCallback) {
                    try {
                        this.val$callback.notify();
                    }
                    finally {
                        Object var3_3 = null;
                    }
                    return;
                }
            }
        };
        JButton jButton = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("okay");
        jButton.addActionListener(actionListener);
        container.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton);
        this.waitForInput(jDialog, textOutputCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForInput(JDialog jDialog, Callback callback) {
        Callback callback2 = callback;
        synchronized (callback2) {
            try {
                while (jDialog.isVisible()) {
                    try {
                        callback.wait(1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
        jDialog.dispose();
    }
}

