/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.Registry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class BaseKeyring
implements IKeyring {
    protected PasswordAuthenticatedEntry keyring;
    protected CompressedEntry keyring2;

    public void load(Map map) throws IOException {
        InputStream inputStream = (InputStream)map.get("gnu.crypto.keyring.data.in");
        if (inputStream == null) {
            throw new IllegalArgumentException("no input stream");
        }
        char[] cArray = (char[])map.get("gnu.crypto.keyring.password");
        if (cArray == null) {
            cArray = new char[]{};
        }
        if (inputStream.read() != Registry.GKR_MAGIC[0] || inputStream.read() != Registry.GKR_MAGIC[1] || inputStream.read() != Registry.GKR_MAGIC[2] || inputStream.read() != Registry.GKR_MAGIC[3]) {
            throw new MalformedKeyringException("magic");
        }
        this.load(inputStream, cArray);
        List list2 = this.keyring.getEntries();
        if (list2.size() == 1 && list2.get(0) instanceof CompressedEntry) {
            this.keyring2 = (CompressedEntry)list2.get(0);
        }
    }

    public void store(Map map) throws IOException {
        OutputStream outputStream = (OutputStream)map.get("gun.crypto.keyring.data.out");
        if (outputStream == null) {
            throw new IllegalArgumentException("no output stream");
        }
        char[] cArray = (char[])map.get("gnu.crypto.keyring.password");
        if (cArray == null) {
            cArray = new char[]{};
        }
        if (this.keyring == null) {
            throw new IllegalStateException("empty keyring");
        }
        outputStream.write(Registry.GKR_MAGIC);
        this.store(outputStream, cArray);
    }

    public void reset() {
        this.keyring = null;
    }

    public int size() {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        return ((StringTokenizer)this.aliases()).countTokens();
    }

    public Enumeration aliases() {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        return new StringTokenizer(this.keyring.getAliasList(), ";");
    }

    public boolean containsAlias(String string) {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        return this.keyring.containsAlias(string);
    }

    public List get(String string) {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        return this.keyring.get(string);
    }

    public void add(Entry entry) {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        if (this.keyring2 != null) {
            this.keyring2.add(entry);
        } else {
            this.keyring.add(entry);
        }
    }

    public void remove(String string) {
        if (this.keyring == null) {
            throw new IllegalStateException("keyring not loaded");
        }
        this.keyring.remove(string);
    }

    protected String fixAlias(String string) {
        return string.replace(';', '_');
    }

    protected abstract void load(InputStream var1, char[] var2) throws IOException;

    protected abstract void store(OutputStream var1, char[] var2) throws IOException;
}

