/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected char[] lookupTable;
    protected static final char NONE = '\ufffd';

    ByteCharset(String string, String[] stringArray) {
        super(string, stringArray);
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset.getClass() == this.getClass();
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        private byte[] lookup;

        Encoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            char c;
            int n;
            char[] cArray = byteCharset.getLookupTable();
            char c2 = '\u0000';
            for (n = 0; n < cArray.length; ++n) {
                c = cArray[n];
                c2 = c > c2 && c < '\ufffd' ? c : c2;
            }
            this.lookup = new byte[c2 + 1];
            for (n = 0; n < cArray.length; ++n) {
                c = cArray[n];
                if (c == '\u0000' || c >= '\ufffd') continue;
                this.lookup[c] = (byte)n;
            }
        }

        public boolean canEncode(char c) {
            byte by = c < this.lookup.length ? this.lookup[c] : (byte)0;
            return by != 0 || c == '\u0000';
        }

        public boolean canEncode(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.canEncode(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                byte by;
                char c = charBuffer.get();
                if (!byteBuffer.hasRemaining()) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byte by2 = by = c < this.lookup.length ? this.lookup[c] : (byte)0;
                if (by != 0 || c == '\u0000') {
                    byteBuffer.put(by);
                    continue;
                }
                charBuffer.position(charBuffer.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private char[] lookup;

        Decoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            this.lookup = byteCharset.getLookupTable();
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (!charBuffer.hasRemaining()) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                char c = this.lookup[by & 0xFF];
                if (c == '\ufffd') {
                    // empty if block
                }
                charBuffer.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

