/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ChannelWriter
extends Writer {
    private static final int DEFAULT_BUFFER_CAP = 8192;
    private WritableByteChannel byteChannel;
    private CharsetEncoder enc;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;

    private void writeBuffer() throws IOException {
        this.byteBuffer.flip();
        this.byteChannel.write(this.byteBuffer);
    }

    public ChannelWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        this.byteChannel = writableByteChannel;
        this.enc = charsetEncoder;
        if (n == -1) {
            n = 8192;
        }
        this.byteBuffer = ByteBuffer.allocate((int)((float)n * charsetEncoder.maxBytesPerChar()));
        this.charBuffer = CharBuffer.allocate(n);
        this.charBuffer.clear();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            CoderResult coderResult;
            try {
                if (this.enc == null) {
                    throw new IOException("writer already closed");
                }
                this.byteBuffer.clear();
                this.charBuffer.flip();
                coderResult = this.enc.encode(this.charBuffer, this.byteBuffer, true);
                if (coderResult.isError() || coderResult.isMalformed() || coderResult.isUnmappable()) {
                    coderResult.throwException();
                }
                this.writeBuffer();
                this.byteBuffer.clear();
                coderResult = this.enc.flush(this.byteBuffer);
                if (coderResult.isError() || coderResult.isMalformed() || coderResult.isUnmappable()) {
                    coderResult.throwException();
                }
                this.writeBuffer();
                this.enc = null;
            }
            finally {
                coderResult = null;
            }
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.enc == null) {
                    throw new IOException("writer already closed");
                }
                int n3 = -1;
                while (n2 > 0) {
                    Object object2;
                    int n4 = Math.min(this.charBuffer.remaining(), n2);
                    this.charBuffer.put(cArray, n, n4);
                    n += n4;
                    this.charBuffer.flip();
                    if ((n2 -= n4) == n3) {
                        if (n2 <= this.charBuffer.remaining()) {
                            this.charBuffer.put(cArray, n, n2);
                            this.charBuffer.flip();
                            break;
                        }
                        object2 = CharBuffer.allocate(this.charBuffer.length() + n2);
                        ((CharBuffer)object2).put(this.charBuffer);
                        ((CharBuffer)object2).put(cArray, n, n2);
                        this.charBuffer = object2;
                        break;
                    }
                    n3 = n2;
                    this.byteBuffer.clear();
                    object2 = this.enc.encode(this.charBuffer, this.byteBuffer, false);
                    this.charBuffer.compact();
                    if (((CoderResult)object2).isError() || ((CoderResult)object2).isMalformed() || ((CoderResult)object2).isUnmappable()) {
                        ((CoderResult)object2).throwException();
                    }
                    this.writeBuffer();
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }
}

