/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.math;

public class MPN {
    public static int add_1(int[] nArray, int[] nArray2, int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(l += (long)nArray2[i] & 0xFFFFFFFFL);
            l >>= 32;
        }
        return (int)l;
    }

    public static int add_n(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(l += ((long)nArray2[i] & 0xFFFFFFFFL) + ((long)nArray3[i] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        return (int)l;
    }

    public static int sub_n(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray3[i];
            int n4 = nArray2[i];
            n2 = ((n3 += n2) ^ Integer.MIN_VALUE) < (n2 ^ Integer.MIN_VALUE) ? 1 : 0;
            n3 = n4 - n3;
            n2 += (n3 ^ Integer.MIN_VALUE) > (n4 ^ Integer.MIN_VALUE) ? 1 : 0;
            nArray[i] = n3;
        }
        return n2;
    }

    public static int mul_1(int[] nArray, int[] nArray2, int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(l2 += ((long)nArray2[i] & 0xFFFFFFFFL) * l);
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static void mul(int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        nArray[n] = MPN.mul_1(nArray, nArray2, n, nArray3[0]);
        for (int i = 1; i < n2; ++i) {
            long l = (long)nArray3[i] & 0xFFFFFFFFL;
            long l2 = 0L;
            for (int j = 0; j < n; ++j) {
                nArray[i + j] = (int)(l2 += ((long)nArray2[j] & 0xFFFFFFFFL) * l + ((long)nArray[i + j] & 0xFFFFFFFFL));
                l2 >>>= 32;
            }
            nArray[i + n] = (int)l2;
        }
    }

    public static long udiv_qrnnd(long l, int n) {
        long l2;
        long l3;
        long l4 = l >>> 32;
        long l5 = l & 0xFFFFFFFFL;
        if (n >= 0) {
            if (l4 < ((long)n - l4 - (l5 >>> 31) & 0xFFFFFFFFL)) {
                l3 = l / (long)n;
                l2 = l % (long)n;
            } else {
                long l6 = l - ((long)n << 31);
                l3 = l6 / (long)n;
                l2 = l6 % (long)n;
                l3 += Integer.MIN_VALUE;
            }
        } else {
            long l7 = n >>> 1;
            long l8 = l >>> 1;
            if (l4 < l7 || l4 >> 1 < l7) {
                if (l4 < l7) {
                    l3 = l8 / l7;
                    l2 = l8 % l7;
                } else {
                    l8 = l8 - (l7 << 32) ^ (long)-1;
                    l3 = l8 / l7;
                    l2 = l8 % l7;
                    l3 = (l3 ^ (long)-1) & 0xFFFFFFFFL;
                    l2 = l7 - 1L - l2;
                }
                l2 = (long)2 * l2 + (l5 & 1L);
                if ((n & 1) != 0) {
                    if (l2 >= l3) {
                        l2 -= l3;
                    } else if (l3 - l2 <= ((long)n & 0xFFFFFFFFL)) {
                        l2 = l2 - l3 + (long)n;
                        --l3;
                    } else {
                        l2 = l2 - l3 + (long)n + (long)n;
                        l3 -= (long)2;
                    }
                }
            } else if (l5 >= ((long)(-n) & 0xFFFFFFFFL)) {
                l3 = -1;
                l2 = l5 + (long)n;
            } else {
                l3 = -2;
                l2 = l5 + (long)n + (long)n;
            }
        }
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    public static int divmod_1(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n - 1;
        long l = nArray2[n3];
        if ((l & 0xFFFFFFFFL) >= ((long)n2 & 0xFFFFFFFFL)) {
            l = 0L;
        } else {
            nArray[n3--] = 0;
            l <<= 32;
        }
        while (n3 >= 0) {
            int n4 = nArray2[n3];
            l = l & 0xFFFFFFFF00000000L | (long)n4 & 0xFFFFFFFFL;
            l = MPN.udiv_qrnnd(l, n2);
            nArray[n3] = (int)l;
            --n3;
        }
        return (int)(l >> 32);
    }

    public static int submul_1(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        long l = (long)n3 & 0xFFFFFFFFL;
        int n4 = 0;
        int n5 = 0;
        do {
            long l2 = ((long)nArray2[n5] & 0xFFFFFFFFL) * l;
            int n6 = (int)l2;
            int n7 = (int)(l2 >> 32);
            n4 = (((n6 += n4) ^ Integer.MIN_VALUE) < (n4 ^ Integer.MIN_VALUE) ? 1 : 0) + n7;
            int n8 = nArray[n + n5];
            if (((n6 = n8 - n6) ^ Integer.MIN_VALUE) > (n8 ^ Integer.MIN_VALUE)) {
                ++n4;
            }
            nArray[n + n5] = n6;
        } while (++n5 < n2);
        return n4;
    }

    public static void divide(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n;
        do {
            int n4;
            if (nArray[n3] == nArray2[n2 - 1]) {
                n4 = -1;
            } else {
                long l = ((long)nArray[n3] << 32) + ((long)nArray[n3 - 1] & 0xFFFFFFFFL);
                n4 = (int)MPN.udiv_qrnnd(l, nArray2[n2 - 1]);
            }
            if (n4 != 0) {
                int n5 = MPN.submul_1(nArray, n3 - n2, nArray2, n2, n4);
                int n6 = nArray[n3];
                long l = ((long)n6 & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
                while (l != 0L) {
                    --n4;
                    long l2 = 0L;
                    for (int i = 0; i < n2; ++i) {
                        nArray[n3 - n2 + i] = (int)(l2 += ((long)nArray[n3 - n2 + i] & 0xFFFFFFFFL) + ((long)nArray2[i] & 0xFFFFFFFFL));
                        l2 >>>= 32;
                    }
                    int n7 = n3;
                    nArray[n7] = nArray[n7] + (int)l2;
                    l = l2 - 1L;
                }
            }
            nArray[n3] = n4;
        } while (--n3 >= n2);
    }

    public static int chars_per_word(int n) {
        if (n < 10) {
            if (n < 8) {
                if (n <= 2) {
                    return 32;
                }
                if (n == 3) {
                    return 20;
                }
                if (n == 4) {
                    return 16;
                }
                return 18 - n;
            }
            return 10;
        }
        if (n < 12) {
            return 9;
        }
        if (n <= 16) {
            return 8;
        }
        if (n <= 23) {
            return 7;
        }
        if (n <= 40) {
            return 6;
        }
        if (n <= 256) {
            return 4;
        }
        return 1;
    }

    public static int count_leading_zeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        for (int i = 16; i > 0; i >>= 1) {
            int n3 = n >>> (i & 0x1F);
            if (n3 == 0) {
                n2 += i;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    public static int set_str(int[] nArray, byte[] byArray, int n, int n2) {
        int n3 = 0;
        if ((n2 & n2 - 1) == 0) {
            int n4 = 0;
            int n5 = 0;
            int n6 = n2;
            while ((n6 >>= 1) != 0) {
                ++n5;
            }
            n6 = 0;
            int n7 = n;
            while (--n7 >= 0) {
                byte by = byArray[n7];
                n6 |= by << (n4 & 0x1F);
                if ((n4 += n5) < 32) continue;
                nArray[n3++] = n6;
                n6 = by >> (n5 - (n4 -= 32) & 0x1F);
            }
            if (n6 != 0) {
                nArray[n3++] = n6;
            }
        } else {
            int n8 = MPN.chars_per_word(n2);
            int n9 = 0;
            while (n9 < n) {
                int n10;
                int n11 = n - n9;
                if (n11 > n8) {
                    n11 = n8;
                }
                int n12 = byArray[n9++];
                int n13 = n2;
                while (--n11 > 0) {
                    n12 = n12 * n2 + byArray[n9++];
                    n13 *= n2;
                }
                if (n3 == 0) {
                    n10 = n12;
                } else {
                    n10 = MPN.mul_1(nArray, nArray, n3, n13);
                    n10 += MPN.add_1(nArray, nArray, n3, n12);
                }
                if (n10 == 0) continue;
                nArray[n3++] = n10;
            }
        }
        return n3;
    }

    public static int cmp(int[] nArray, int[] nArray2, int n) {
        while (--n >= 0) {
            int n2 = nArray[n];
            int n3 = nArray2[n];
            if (n2 == n3) continue;
            if ((n2 ^ Integer.MIN_VALUE) > (n3 ^ Integer.MIN_VALUE)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static int cmp(int[] nArray, int n, int[] nArray2, int n2) {
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return MPN.cmp(nArray, nArray2, n);
    }

    public static int rshift(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = 32 - n3;
        int n5 = nArray2[n];
        int n6 = n5 << (n4 & 0x1F);
        for (int i = 1; i < n2; ++i) {
            int n7 = nArray2[n + i];
            nArray[i - 1] = n5 >>> (n3 & 0x1F) | n7 << (n4 & 0x1F);
            n5 = n7;
        }
        nArray[i - 1] = n5 >>> (n3 & 0x1F);
        return n6;
    }

    public static void rshift0(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n3 > 0) {
            MPN.rshift(nArray, nArray2, n, n2, n3);
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = nArray2[i + n];
            }
        }
    }

    public static long rshift_long(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n2 >> 5;
        int n5 = nArray[n - 1] < 0 ? -1 : 0;
        int n6 = n4 >= n ? n5 : nArray[n4];
        int n7 = n3 = ++n4 >= n ? n5 : nArray[n4];
        if ((n2 &= 0x1F) != 0) {
            int n8 = ++n4 >= n ? n5 : nArray[n4];
            n6 = n6 >>> (n2 & 0x1F) | n3 << (32 - n2 & 0x1F);
            n3 = n3 >>> (n2 & 0x1F) | n8 << (32 - n2 & 0x1F);
        }
        return (long)n3 << 32 | (long)n6 & 0xFFFFFFFFL;
    }

    public static int lshift(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 32 - n3;
        int n5 = n2 - 1;
        int n6 = nArray2[n5];
        int n7 = n6 >>> (n4 & 0x1F);
        ++n;
        while (--n5 >= 0) {
            int n8 = nArray2[n5];
            nArray[n + n5] = n6 << (n3 & 0x1F) | n8 >>> (n4 & 0x1F);
            n6 = n8;
        }
        nArray[n + n5] = n6 << (n3 & 0x1F);
        return n7;
    }

    public static int findLowestBit(int n) {
        int n2 = 0;
        while ((n & 0xF) == 0) {
            n >>= 4;
            n2 += 4;
        }
        if ((n & 3) == 0) {
            n >>= 2;
            n2 += 2;
        }
        if ((n & 1) == 0) {
            ++n2;
        }
        return n2;
    }

    public static int findLowestBit(int[] nArray) {
        int n = 0;
        while (nArray[n] == 0) {
            ++n;
        }
        return 32 * n + MPN.findLowestBit(nArray[n]);
    }

    public static int gcd(int[] nArray, int[] nArray2, int n) {
        int n2;
        int[] nArray3;
        int[] nArray4;
        int n3;
        int n4 = 0;
        while ((n3 = nArray[n4] | nArray2[n4]) == 0) {
            ++n4;
        }
        int n5 = n4;
        int n6 = MPN.findLowestBit(n3);
        MPN.rshift0(nArray, nArray, n5, n -= n5, n6);
        MPN.rshift0(nArray2, nArray2, n5, n, n6);
        if ((nArray[0] & 1) != 0) {
            nArray4 = nArray;
            nArray3 = nArray2;
        } else {
            nArray4 = nArray2;
            nArray3 = nArray;
        }
        block1: while (true) {
            n4 = 0;
            while (nArray3[n4] == 0) {
                ++n4;
            }
            if (n4 > 0) {
                for (n2 = 0; n2 < n - n4; ++n2) {
                    nArray3[n2] = nArray3[n2 + n4];
                }
                while (n2 < n) {
                    nArray3[n2] = 0;
                    ++n2;
                }
            }
            if ((n4 = MPN.findLowestBit(nArray3[0])) > 0) {
                MPN.rshift(nArray3, nArray3, 0, n, n4);
            }
            if ((n4 = MPN.cmp(nArray4, nArray3, n)) == 0) break;
            if (n4 > 0) {
                MPN.sub_n(nArray4, nArray4, nArray3, n);
                int[] nArray5 = nArray4;
                nArray4 = nArray3;
                nArray3 = nArray5;
            } else {
                MPN.sub_n(nArray3, nArray3, nArray4, n);
            }
            while (true) {
                if (nArray4[n - 1] != 0 || nArray3[n - 1] != 0) continue block1;
                --n;
            }
            break;
        }
        if (n5 + n6 > 0) {
            if (n6 > 0) {
                n2 = MPN.lshift(nArray, n5, nArray, n, n6);
                if (n2 != 0) {
                    nArray[n++ + n5] = n2;
                }
            } else {
                n4 = n;
                while (--n4 >= 0) {
                    nArray[n4 + n5] = nArray[n4];
                }
            }
            n4 = n5;
            while (--n4 >= 0) {
                nArray[n4] = 0;
            }
            n += n5;
        }
        return n;
    }

    public static int intLength(int n) {
        return 32 - MPN.count_leading_zeros(n < 0 ? ~n : n);
    }

    public static int intLength(int[] nArray, int n) {
        return MPN.intLength(nArray[--n]) + 32 * n;
    }
}

