/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.util;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;

class Debug {
    private final PrintStream p;
    private final int maxdepth;
    private final int maxArrayLength;
    private final boolean printStaticFields;
    private int depth;
    private final IdentityHashMap h;

    private /* synthetic */ void finit$() {
        this.h = new IdentityHashMap();
    }

    Debug(PrintStream printStream, int n, int n2, boolean bl) {
        this.finit$();
        this.p = printStream;
        this.maxdepth = n;
        this.maxArrayLength = n2;
        this.printStaticFields = bl;
    }

    Debug(PrintStream printStream) {
        this(printStream, 0, 10, false);
    }

    Debug(int n, boolean bl) {
        this(new PrintStream(new FileOutputStream(FileDescriptor.err), true), n, n > 0 ? 1000 : 10, bl);
    }

    Debug(int n) {
        this(n, false);
    }

    Debug() {
        this(0, false);
    }

    private final void indent() {
        for (int i = 0; i < this.depth; ++i) {
            this.p.print("  ");
        }
    }

    private static native Field[] getDeclaredFields(Class var0);

    private static native Object getField(Object var0, Field var1);

    private static native long getAddr(Object var0);

    private Field[] internalGetFields(Class clazz) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(Arrays.asList(Debug.getDeclaredFields(clazz)));
        Class[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.addAll(Arrays.asList(this.internalGetFields(classArray[i])));
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            hashSet.addAll(Arrays.asList(this.internalGetFields(clazz2)));
        }
        return (Field[])hashSet.toArray(new Field[hashSet.size()]);
    }

    private static Class getItsClass(Object object) {
        return object.getClass();
    }

    private void print(Object object) {
        int n = this.depth++;
        this.h.put(object, object);
        try {
            Class clazz = Debug.getItsClass(object);
            this.p.print(clazz.getName() + "@");
            this.p.println(Long.toHexString(Debug.getAddr(object)));
            if (clazz.isArray()) {
                this.indent();
                this.p.println("{");
                this.indent();
                clazz = clazz.getComponentType();
                int n2 = Array.getLength(object);
                for (int i = 0; i < n2; ++i) {
                    Object object2 = Array.get(object, i);
                    this.print0(object2, clazz);
                    this.p.print(", ");
                    if (i <= this.maxArrayLength) continue;
                    this.p.print("...");
                    break;
                }
                --this.depth;
                this.p.println();
                this.indent();
                this.p.print("}");
                return;
            }
            this.indent();
            this.p.println("{");
            ++this.depth;
            if (clazz == Debug.class$("java.lang.Class")) {
                this.indent();
                this.p.println("class = " + object.toString() + ",");
            } else if (clazz == Debug.class$("java.lang.reflect.Field")) {
                this.indent();
                this.p.println("<field> = \"" + object.toString() + "\",");
            } else if (clazz == Debug.class$("java.lang.String")) {
                this.indent();
                this.p.println("<string> = \"" + object.toString() + "\",");
            }
            Field[] fieldArray = this.internalGetFields(clazz);
            for (int i = 0; i < fieldArray.length; ++i) {
                boolean bl;
                Class clazz2 = fieldArray[i].getType();
                boolean bl2 = bl = (fieldArray[i].getModifiers() & 8) != 0;
                if (bl && !this.printStaticFields) continue;
                this.indent();
                if (bl) {
                    this.p.print("static ");
                }
                this.p.print(clazz2.getName() + " " + fieldArray[i].getName() + " = ");
                Object object3 = Debug.getField(object, fieldArray[i]);
                this.print0(object3, clazz2);
                this.p.println(",");
            }
            --this.depth;
            this.indent();
            this.p.print("}");
        }
        catch (Throwable throwable) {
            this.p.print("error: 0x" + Long.toHexString(Debug.getAddr(object)) + ";");
            this.depth = n;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void print0(Object object, Class clazz) {
        try {
            if (object == null) {
                this.p.print("null");
                return;
            }
            if (clazz != Debug.class$("gnu.gcj.RawData") && clazz != Debug.class$("gnu.gcj.RawDataManaged")) {
                if (clazz.isPrimitive()) {
                    if (Debug.getItsClass(object) == Debug.class$("java.lang.Character")) {
                        this.p.print("'" + object + "'");
                    } else {
                        this.p.print(object);
                    }
                    return;
                }
                if (Debug.getItsClass(object) == Debug.class$("java.lang.String")) {
                    this.p.print("\"" + object + "\"");
                    return;
                }
                if (this.depth < this.maxdepth && this.h.get(object) == null) {
                    ++this.depth;
                    this.print(object);
                    --this.depth;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.p.print("0x" + Long.toHexString(Debug.getAddr(object)));
    }

    public void write(Object object) {
        this.depth = 0;
        this.print(object);
        this.p.flush();
    }
}

