reorder.factor             package:stats             R Documentation

_R_e_o_r_d_e_r _L_e_v_e_l_s _o_f _a _F_a_c_t_o_r

_D_e_s_c_r_i_p_t_i_o_n:

     'reorder' is a generic function.  Its '"factor"' method reorders
     the levels of a factor depending on values of a second variable,
     usually numeric.  The '"character"' method is a convenient alias.

_U_s_a_g_e:

     reorder(x, ...)

     ## S3 method for class 'factor':
     reorder(x, X, FUN = mean, ...,
             order = is.ordered(x))

     ## S3 method for class 'character':
     reorder(x, X, FUN = mean, ...,
             order = is.ordered(x))

_A_r_g_u_m_e_n_t_s:

       x: a character vector or factor (possibly ordered) or whose
          levels will be reordered. 

       X: a vector of the same length as 'x', whose subset of values
          for each unique level of 'x' determines the eventual order of
          that level. 

     FUN: a function whose first argument is a vector and returns a
          scalar, to be applied to each subset of 'X' determined by the
          levels of 'x'. 

     ...: optional: extra arguments supplied to 'FUN'

   order: logical, whether return value will be an ordered factor
          rather than a factor. 

_V_a_l_u_e:

     A factor or an ordered factor (depending on the value of 'order'),
     with the order of the levels determined by 'FUN' applied to 'X'
     grouped by 'x'.  The levels are ordered such that the values
     returned by 'FUN' are in increasing order.

     Additionally, the values of 'FUN' applied to the subsets of 'X'
     (in the original order of the levels of 'x') is returned as the
     '"scores"' attribute.

_A_u_t_h_o_r(_s):

     Deepayan Sarkar deepayan.sarkar@r-project.org

_S_e_e _A_l_s_o:

     'reorder.dendrogram', 'levels', 'relevel'.

_E_x_a_m_p_l_e_s:

     require(graphics)

     bymedian <- with(InsectSprays, reorder(spray, count, median))
     boxplot(count ~ bymedian, data = InsectSprays,
             xlab = "Type of spray", ylab = "Insect count",
             main = "InsectSprays data", varwidth = TRUE,
             col = "lightgray")

