#################################################################
# DO NOT EDIT!
#
# This file is automatically generated from files in the Text/ subdirectory
#
#  TkRat software and its included text is Copyright 1996-2002 by
#  Martin Forssen
#
#  The full text of the legal notices is contained in the file called
#  COPYRIGHT, included with this distribution.
#


# The following is the function which does the actual work
proc init_help_en {} {
global help
set help(title,intro) Introduction
set help(intro) {                        Help system for TkRat


  Overview

TkRat is a Mail User Agent (MUA) which is meant for reading, sending and
managing electronic mail.

The main window of TkRat is the Folder window. This is the window that appears
when you start TkRat. At the top of this window is a menu bar and a line which
describes the current folder. Below that is a listing of the messages in the
folder, you can select messages in this list with the mouse to see the
individual message below. Below the folder listing comes a message line and a
row of buttons. Below that is the content of the current message shown.

Before you can send a message, you must first compose (i.e. write) it. There
are multiple ways to reach the Compose window. If you want to create a new
message, you should press the Compose button. If you wish to reply to the
current message, you should press one of the Reply buttons.

By default, the Folder window shows your INBOX, that is the folder where your
incoming mail is placed. When you have read (and perhaps replied to) a message,
you might want to save it somewhere else (so as to not clutter up your INBOX).
This is done by moving the message to another folder. There are many different
types of folders with different properties.

If a new message arrives when the program is iconified, a small Watcher
window pops up.

TkRat is a very complex program. Although I have tried to make it easy to use,
the complexity shows in the number of different things you can customize. All
the different options should have reasonable defaults.


  More information

Information about the latest version, etc. can be found at the following URL:

 http://www.TkRat.org/
}
set help(title,deleting) {Deleting messages}
set help(deleting) {				Deleting messages

Deletion of messages is a two-step process. First, the messages are marked
for deletion, and then at some later time the marked messages are actually
removed from the folder.

Messages marked for deletion are indicated by a 'D' next to them in the list
of messages. To mark the current message for deletion, simply press the
"Delete" button. You can perform all the usual operations on a message marked
for deletion since the message is not actually deleted yet.

You can remove the deletion mark from the current message by selecting
"Undelete" in the message menu.

The actual deletion of the marked messages occurs whenever you synchronize the
folder (via "Synchronize folder" in the Admin menu) or when you close the
folder (opening another folder causes the current folder to be closed, as
does quitting TkRat).
}
set help(title,grouping) {Grouping messages}
set help(grouping) {				Grouping messages

Grouping messages is a convenient way of performing the same operation on
multiple messages in just one step (after the group is created).

The current group always consists of all flagged messages in the current folder.
Flagged messages are indicated by a 'F' in the list of messages (this F is
actually a part of the status flags, so if you do not have %S in your list
format, you will not see it). Messages may keep their flagged status next time
they are accessed.

Currently, you can perform the following operations on a group (must be done
via the Group menu):
  * Delete	- Mark messages for deletion
  * Undelete	- Remove deletion mark from messages
  * Move	- Move messages to another folder

There are currently five different ways to add/remove messages from a group:

  * Use the "Clear group marking" entry in the Group menu
    This will remove all group markings in the current folder

  * Press the right mousebutton on a message in the message list
    This will toggle the group flag for that message

  * Use the "Create in window..." entry in the Group menu
    This will create a separate window which contains a list of all messages
    in the current folder, you can select/deselect messages in it. Finally,
    when you press the OK button, your selection will become the group
    selection.

  * Use the "Create by expression..." entry in the Group menu
    This opens a window where you can give an expression, all messages in
    in the current folder that match that expression will be added to the
    current group

  * Use the "Use saved expression" submenu in the Group menu
    This menu contains entries for each expression you have saved earlier
}
set help(title,folders) Folders
set help(folders) {                            Folders

A folder is a collection of zero or more messages. There are a lot of
different ways of storing and accessing the messages in a folder. TkRat
currently understands four different types of folders.

To open a folder, you need to know which type it is, and some additional type-
specific data about it. To help you, TkRat has something called Virtual folders
(also known as vfolders). When you define a vfolder, you have to specify a
name, type, and all other data about the folder. This name will then appear in
the "Folders" and "Move" menus for easy selection and message insertion.

  The following types of folders are supported

* UNIX mailbox
  A UNIX mailbox consists of a flat text file where the messages are separated
  by a certain marker line (which starts with "From " or "^A^A^A"). This is the
  normal way of handling mail on UNIX systems.
  Data needed: The name of the file

* IMAP4
  IMAP (version 4) is a protocol for accessing mailboxes over a network.
  One user can have multiple IMAP mailboxes on one host. If you wish to use
  rimap-style authentication, you should make the port number field empty.
  Data needed: The name of the server
	       Which user to access the folder as
	       A password (asked for when opening the folder)
	       The name of the mailbox

* Disconnected
  A disconnected folder is a local copy of an IMAP folder. These folders
  are then synchronized so that any changes made to one of them are mirrored
  in the other. This is very useful for reading and answering your mail
  offline.
  Data needed: The name of the server
	       Which user to access the folder as
	       A password (asked for when opening the folder)
	       The name of the mailbox

* POP3
  POP (version 3) is a protocol for accessing mailboxes over a network.
  Each user can have a maximum of one POP mailbox on one host.
  Data needed: The name of the server
	       Which user to access the folder as
	       A password (asked for when opening the folder)

* Database
  A database folder is a collection of messages where each message has
  keywords associated with it. Opening the database is equivalent to
  searching it (you can search for attributes other than the keywords).
  Messages can also have an expiration time, and when this time is reached,
  something happens to the message (it may, for example. be deleted). Every
  user can have one database each (you can only access your own database).
  Data needed: A search expression
	       Expiration time and type (for insertion)

* Dynamic
  This is a special form of the File folder. It is specified as a directory,
  and when you insert messages into it, the message is actually placed in
  a file folder in that directory. The name of the file folder is the first
  part of the sender's email address. When you open a dynamic folder, you will
  see a list of the files in that directory.
  Data needed: The name of the directory
}
set help(title,folderdef) {Defining folders}
set help(folderdef) {				Defining folders

TkRat lets you organize your folders in a tree-like structure. This structure
is then used to build the Folders and Move menus. When you call "New/Edit
folder" the vfolderdef window will appear. This window lets you modify the
structure, add/edit/delete folders, etc.

One important fact to remember is that the structure only exists within TkRat
and does not necessarily reflect the actual layout on disk.

The "Define virtual folder" window is divided into two parts. The left part
shows the tree and the right part shows details about the currently selected
node in the tree. The tree has two nodes at the top level, one which contains
all your IMAP servers and one which contains all the folders. You can drag and
drop folders in the folder part of the tree. And, pressing the right
mousebutton gives you a small context menu which, among other things, allows
you to delete the current node.

One of the folders has the string 'INBOX' to the right of it, this is the
designated inbox. It means that this is the folder TkRat opens by default when
starting. It may also be used when expiring the database. You can have only
one INBOX.

Folders can be used to store outgoing messages. The folder to store the
messages in can be configured separately for each role in the Preferences 
window (see also 'Roles').

  Importing folders

For some folder types (file, imap and mh) you can import an entire structure
of folders. To do this, select the appropriate Import-type of a folder. Then,
provide the path to the folders that will be imported. What you have to write
here depends on the mailbox type and server, common good values are nothing
and the full path to your home directory. For IMAP imports you can also
specify if the folders should be imported as disconnected folders (which means
that TkRat will keep a local copy of them).

The next field to fill in is the pattern. The pattern limits which folders to
actually import. Only folders matching the pattern will be imported. There are
two wildcards which may be useful. A '*' matches everything and will cause the
import to descend into matching subdirectories. A '%' matches all files but
does not descend into subfolders. You can also limit the import to only
subscribed folders.

Hint: If you are trying to import your IMAP folders from another program, you
should probably try with the 'Subscribed folders only' option enabled
first. Another tip is that, when you are unsure what you actually will import,
then try with pattern '%' to avoid recursing your entire file system. 

It may be worthwhile to note that the structure of imported folders is
read-only. That is, you can not drag and drop among imported folders. Also,
any changes you make to the layout on disk will be picked up the next time
you re-import the folder.
}
set help(title,dbase) {The database}
set help(dbase) {				The database

The database is a place for storing messages. Each message is associated with
a number of keywords and an expiration time (can be eternity).

When you insert a message into the database, you can give the following
information to be associated with it:
  * keywords		- An optional list of keywords
  * expiration time	- A time when the message expires from the database.
			  The time is given as a plus sign and a number and
			  the number is the number of days it should remain in
			  the database. The filed may be blank and then the
			  message never expires.
  * expiration action	- What to do when the message expires. The possible
			  actions are:
	* Remove   - Delete the message
	* Incoming - Move the message to the incoming folder again
	* Backup   - Move the message to some backup format

When you want to fetch messages from the database, you can search the
following fields: to, from, cc, subject, keywords and the entire message.
You can find messages which match all criteria or just one.
}
set help(title,notification) Notifications
set help(notification) {				Notifications

	About Notifications

Notifications (the technical term is Delivery Status Notifications (DSN)) let
you know when your message has been delivered to the recipient's mailbox. DSN
works on the SMTP level so you must use SMTP to send your messages, and since it
is an extension to the protocol, not all SMTP servers support it. There is a
Probe button in the Preferences window which lets you test if your system
supports DSN. All systems on the route to the recipient must also support
DSN for it to work.

	The Notifications window

The Notifications window contains a list of all messages for which a
notification was requested that has been sent within the last seven days
(the time is configurable). Each message is listed with the date of sending,
subject and all recipients. In front of each recipient is the current status
shown. There are six different statuses possible:

-	  - Means that TkRat does not yet know anything about this recipient
Failed	  - The messages did not reach this recipient
Delivered - The message has been successfully delivered. This does NOT in
	    any way imply that the recipient has even seen the message yet.
Relayed	  - The message has been forwarded to some agent (MTA) which does not
	    support notifications
Expanded  - The message has been delivered, but the destination was an alias
	    which expanded to one or more different address(es). Further
	    notifications will arrive.
Delayed	  - The message has not yet reached this recipient but further
	    attempts to deliver it will be done

You can get more information about any notification by pointing at the
recipient line and pressing the right mousebutton. This will pop up the
Notification window which shows one notification in greater detail.

	The Notification window

The Notification window contains one scrollable text part. This part will
show a text that should be readable by a human being and describes what
caused this notification. Below that are fields which will help the more
knowledgeable person to determine exactly what went wrong (or right). The
"See more of returned message" will add more text in the text part. The new
text will be the portion of the original message that was returned in this
notification.

For more technical information about notifications, see the approporiate
RFC's (currently 1891, 1893 and 1894).
}
set help(title,userproc) Userprocs
set help(userproc) {			User defined procedures

User defined procedures are a way for the user to have more control over
certain features. The procedures are ordinary tcl procedures (i.e. they are
written in tcl7.5). None of the procedures must exist, they will be used
only if they exist.

The user may define procedures in the ~/.ratatosk/userproc file (or
whatever the userproc option is set to). If the procedures need any global
variables, these must start with "ratUP_". The following procedures may
be defined:

RatUP_IsMe mailbox domain personal adl
        mailbox  -      Mailbox name
        domain   -      The domain part
        personal -      The personal name phrase (if any)
        adl      -      At-domain-list source route
    This procedure should determine if the address is pointing to me or not.
    It should return a boolean value, which should be true if the address
    is pointing at me.

RatUP_Translate mailbox domain personal adl
        mailbox  -      Mailbox name
        domain   -      The domain part
        personal -      The personal name phrase (if any)
        adl      -      At-domain-list source route (probably empty)
    When we are replying to a message, all addresses we are sending to
    are run through this procedure. It is expected to return a list with
    four elements {mailbox domain personal adl}.

RatUP_Signature message
	message -	The name of a global array which may contain
			information about the message the signature will be
			appended to
    This function should return a text string which will later be
    appended to the first text part of the message. The message argument is
    the name of a global array which MAY contain information about the message.
    See the section on RatSend in the interface file). Note that this routine
    gets called before the user has had any chance to edit the message so
    there will not be any interesting information available at all for
    new messages.  It only contains interesting things for replies and
    forwards.

RatUP_Bell
    This function should notify the user that new mail has arrived. If
    this function does not exist, then the terminal bell is rung.

RatUP_ShowURL url
        url -   A URL to show
    This function may get called when the user presses the left mousebutton
    over a URL in a message. It is expected to invoke a browser (in the
    background).

RatUP_Citation message
        message -       The handler for the message which is being cited
    This function should return a string which will be prepended to all
    lines in the body of the cited message. It will be called when you reply
    to a message.

RatUP_NetsyncFolder spec user prot
        spec -  A network folder specification {host:port}mailbox
        user -  User to connect as
        prot -  Protocol (currently always imap)
    This function should return a boolean value which indicates if
    the disconnected folder given as an argument should be synchronized
    at this moment or not. That means that this function will be called
    once for each disconnected mailbox when you select "Network sync"
    from the menu. It will NOT be called when you select "Network sync. folder"
    from the Admin menu to synchronize the current folder.
}
set help(title,bugreport) {Reporting bugs}
set help(bugreport) {				Reporting bugs

You should send bug reports to maf@TkRat.org. This is best done by
selecting "Send bug report..." in the Help menu (of the Folder window).
This will open a Compose window with a template bug report. The recipient
is already filled in as is part of the subject. You should complete the
subject and write a detailed description of what you did to discover the bug
(and the bug itself) in the body of the message.

TkRat has already added an attachment which contains information about your
configuration. This attachment contains the output from "uname -a" on your
system, TkRat version number and date, tcl/tk version used, and a copy of
all the settings in the Preferences window.

If you wish to see exactly what is sent, then look at the contents of a file
with a name like ~/.ratatosk/send/rat.X.Y (it is most probably the last file).
This file gets created when you start "Send bug report..." and gets deleted
when the report is sent.
}
set help(title,roles) Roles
set help(roles) {                              Roles

The Roles feature is a way for you to have different identities. Associated
with each role is address info and also settings on how to send email. You can
then always change the role and the selected role will affect composed
messages. You can also associate roles with folders so that, when working with
a particular folder, you use a particular role.

Roles are defined in the Preferences window. To create a new role, select
'Roles' in the tree and then press 'Create new role.' This will create a new
role in the tree and you can then edit it as much as you want.

In the 'Save outgoing' field, you may define a folder in which messages sent
using this role should be saved by default.
}
}
#
# DO NOT EDIT!
# This file is automatically generated from files in the Text/ subdirectory
##############################################################################


