/*
 * h341_oid.h
 *
 * H.341 MIB Definitions for the h323plus library.
 *
 *
 * Copyright (c) 2007 ISVO (Asia) Pte Ltd. All Rights Reserved.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the General Public License (the  "GNU License"), in which case the
 * provisions of GNU License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the GNU License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the GNU License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the GNU License."
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is derived from and used in conjunction with the 
 * h323plus Project (www.h323plus.org/)
 *
 * The Initial Developer of the Original Code is ISVO (Asia) Pte Ltd.
 *
 * Note: this file originally auto-generated by mib2c using
 *  : mib2c.openh323.conf,v 1.0 2007/07/29 05:42:47 hardaker Exp $
 *
 * Contributor(s): ______________________________________.
 *
 *
 */

//#include <ptlib.h>

#ifndef H341_OID_H
#define H341_OID_H

#include <ptclib/asner.h>

// Access permissions
#define H341_ReadOnly   1
#define H341_ReadWrite  2
#define H341_Create     3
#define H341_NoAccess   4

// field Types
#define ASN_COUNTER     PASNObject::Counter
#define ASN_INTEGER     PASNObject::UInteger32
#define ASN_TIMETICKS   PASNObject::TimeTicks
#define ASN_UNSIGNED    PASNObject::UInteger32
#define ASN_OCTET_STR   PASNObject::String
#define ASN_ARRAY       PASNObject::Sequence


/*
 * Entry definitions for table callSignalConfigTable 
 */

#define H341_CALLSIGNALCONFIGTABLE			"0.0.8.341.1.1.1.1.1"
#define H341_CALLSIGNALCONFIGMAXCONNECTIONS			"0.0.8.341.1.1.1.1.1.1.1"
#define H341_CALLSIGNALCONFIGAVAILABLECONNECTIONS			"0.0.8.341.1.1.1.1.1.1.2"
#define H341_CALLSIGNALCONFIGT303			"0.0.8.341.1.1.1.1.1.1.3"
#define H341_CALLSIGNALCONFIGT301			"0.0.8.341.1.1.1.1.1.1.4"
#define H341_CALLSIGNALCONFIGENABLENOTIFICATIONS			"0.0.8.341.1.1.1.1.1.1.5"


/*
 * Entry definitions for table callSignalStatsTable 
 */

#define H341_CALLSIGNALSTATSTABLE			"0.0.8.341.1.1.1.2.1"
#define H341_CALLSIGNALSTATSCALLCONNECTIONSIN			"0.0.8.341.1.1.1.2.1.1.1"
#define H341_CALLSIGNALSTATSCALLCONNECTIONSOUT			"0.0.8.341.1.1.1.2.1.1.2"
#define H341_CALLSIGNALSTATSALERTINGMSGSIN			"0.0.8.341.1.1.1.2.1.1.3"
#define H341_CALLSIGNALSTATSALERTINGMSGSOUT			"0.0.8.341.1.1.1.2.1.1.4"
#define H341_CALLSIGNALSTATSCALLPROCEEDINGSIN			"0.0.8.341.1.1.1.2.1.1.5"
#define H341_CALLSIGNALSTATSCALLPROCEEDINGSOUT			"0.0.8.341.1.1.1.2.1.1.6"
#define H341_CALLSIGNALSTATSSETUPMSGSIN			"0.0.8.341.1.1.1.2.1.1.7"
#define H341_CALLSIGNALSTATSSETUPMSGSOUT			"0.0.8.341.1.1.1.2.1.1.8"
#define H341_CALLSIGNALSTATSSETUPACKMSGSIN			"0.0.8.341.1.1.1.2.1.1.9"
#define H341_CALLSIGNALSTATSSETUPACKMSGSOUT			"0.0.8.341.1.1.1.2.1.1.10"
#define H341_CALLSIGNALSTATSPROGRESSMSGSIN			"0.0.8.341.1.1.1.2.1.1.11"
#define H341_CALLSIGNALSTATSPROGRESSMSGSOUT			"0.0.8.341.1.1.1.2.1.1.12"
#define H341_CALLSIGNALSTATSRELEASECOMPLETEMSGSIN			"0.0.8.341.1.1.1.2.1.1.13"
#define H341_CALLSIGNALSTATSRELEASECOMPLETEMSGSOUT			"0.0.8.341.1.1.1.2.1.1.14"
#define H341_CALLSIGNALSTATSSTATUSMSGSIN			"0.0.8.341.1.1.1.2.1.1.15"
#define H341_CALLSIGNALSTATSSTATUSMSGSOUT			"0.0.8.341.1.1.1.2.1.1.16"
#define H341_CALLSIGNALSTATSSTATUSINQUIRYMSGSIN			"0.0.8.341.1.1.1.2.1.1.17"
#define H341_CALLSIGNALSTATSSTATUSINQUIRYMSGSOUT			"0.0.8.341.1.1.1.2.1.1.18"
#define H341_CALLSIGNALSTATSFACILITYMSGSIN			"0.0.8.341.1.1.1.2.1.1.19"
#define H341_CALLSIGNALSTATSFACILITYMSGSOUT			"0.0.8.341.1.1.1.2.1.1.20"
#define H341_CALLSIGNALSTATSINFOMSGSIN			"0.0.8.341.1.1.1.2.1.1.21"
#define H341_CALLSIGNALSTATSINFOMSGSOUT			"0.0.8.341.1.1.1.2.1.1.22"
#define H341_CALLSIGNALSTATSNOTIFYMSGSIN			"0.0.8.341.1.1.1.2.1.1.23"
#define H341_CALLSIGNALSTATSNOTIFYMSGSOUT			"0.0.8.341.1.1.1.2.1.1.24"
#define H341_CALLSIGNALSTATSAVERAGECALLDURATION			"0.0.8.341.1.1.1.2.1.1.25"
#define H341_CALLSIGNALSTATSCALLCONNECTIONS			"0.0.8.341.1.1.1.2.1.1.26"
#define H341_CALLSIGNALSTATSALERTINGMSGS			"0.0.8.341.1.1.1.2.1.1.27"
#define H341_CALLSIGNALSTATSCALLPROCEEDINGS			"0.0.8.341.1.1.1.2.1.1.28"
#define H341_CALLSIGNALSTATSSETUPMSGS			"0.0.8.341.1.1.1.2.1.1.29"
#define H341_CALLSIGNALSTATSSETUPACKMSGS			"0.0.8.341.1.1.1.2.1.1.30"
#define H341_CALLSIGNALSTATSPROGRESSMSGS			"0.0.8.341.1.1.1.2.1.1.31"
#define H341_CALLSIGNALSTATSRELEASECOMPLETEMSGS			"0.0.8.341.1.1.1.2.1.1.32"
#define H341_CALLSIGNALSTATSSTATUSMSGS			"0.0.8.341.1.1.1.2.1.1.33"
#define H341_CALLSIGNALSTATSSTATUSINQUIRYMSGS			"0.0.8.341.1.1.1.2.1.1.34"
#define H341_CALLSIGNALSTATSFACILITYMSGS			"0.0.8.341.1.1.1.2.1.1.35"
#define H341_CALLSIGNALSTATSINFOMSGS			"0.0.8.341.1.1.1.2.1.1.36"
#define H341_CALLSIGNALSTATSNOTIFYMSGS			"0.0.8.341.1.1.1.2.1.1.37"


/*
 * Entry definitions for table connectionsTable 
 */

#define H341_CONNECTIONSTABLE			"0.0.8.341.1.1.1.3.2"
#define H341_CONNECTIONSSRCTRANSPORTADDRESSTAG			"0.0.8.341.1.1.1.3.2.1.1"
#define H341_CONNECTIONSSRCTRANSPORTADDRESS			"0.0.8.341.1.1.1.3.2.1.2"
#define H341_CONNECTIONSCALLIDENTIFIER			"0.0.8.341.1.1.1.3.2.1.3"
#define H341_CONNECTIONSROLE			"0.0.8.341.1.1.1.3.2.1.4"
#define H341_CONNECTIONSSTATE			"0.0.8.341.1.1.1.3.2.1.5"
#define H341_CONNECTIONSDESTTRANSPORTADDRESSTAG			"0.0.8.341.1.1.1.3.2.1.6"
#define H341_CONNECTIONSDESTTRANSPORTADDRESS			"0.0.8.341.1.1.1.3.2.1.7"
#define H341_CONNECTIONSDESTALIASTAG			"0.0.8.341.1.1.1.3.2.1.8"
#define H341_CONNECTIONSDESTALIAS			"0.0.8.341.1.1.1.3.2.1.9"
#define H341_CONNECTIONSSRCH245SIGTRANSPORTADDRESSTAG			"0.0.8.341.1.1.1.3.2.1.10"
#define H341_CONNECTIONSSRCH245SIGTRANSPORTADDRESS			"0.0.8.341.1.1.1.3.2.1.11"
#define H341_CONNECTIONSDESTH245SIGTRANSPORTADDRESSTAG			"0.0.8.341.1.1.1.3.2.1.12"
#define H341_CONNECTIONSDESTH245SIGTRANSPORTADDRESS			"0.0.8.341.1.1.1.3.2.1.13"
#define H341_CONNECTIONSCONFID			"0.0.8.341.1.1.1.3.2.1.14"
#define H341_CONNECTIONSCALLEDPARTYNUMBER			"0.0.8.341.1.1.1.3.2.1.15"
#define H341_CONNECTIONSDESTXTRACALLINGNUMBER1			"0.0.8.341.1.1.1.3.2.1.16"
#define H341_CONNECTIONSDESTXTRACALLINGNUMBER2			"0.0.8.341.1.1.1.3.2.1.17"
#define H341_CONNECTIONSDESTXTRACALLINGNUMBER3			"0.0.8.341.1.1.1.3.2.1.18"
#define H341_CONNECTIONSDESTXTRACALLINGNUMBER4			"0.0.8.341.1.1.1.3.2.1.19"
#define H341_CONNECTIONSDESTXTRACALLINGNUMBER5			"0.0.8.341.1.1.1.3.2.1.20"
#define H341_CONNECTIONSFASTCALL			"0.0.8.341.1.1.1.3.2.1.21"
#define H341_CONNECTIONSSECURITY			"0.0.8.341.1.1.1.3.2.1.22"
#define H341_CONNECTIONSH245TUNNELING			"0.0.8.341.1.1.1.3.2.1.23"
#define H341_CONNECTIONSCANOVERLAPSEND			"0.0.8.341.1.1.1.3.2.1.24"
#define H341_CONNECTIONSCRV			"0.0.8.341.1.1.1.3.2.1.25"
#define H341_CONNECTIONSCALLTYPE			"0.0.8.341.1.1.1.3.2.1.26"
#define H341_CONNECTIONSREMOTEEXTENSIONADDRESS			"0.0.8.341.1.1.1.3.2.1.27"
#define H341_CONNECTIONSEXTRACRV1			"0.0.8.341.1.1.1.3.2.1.28"
#define H341_CONNECTIONSEXTRACRV2			"0.0.8.341.1.1.1.3.2.1.29"
#define H341_CONNECTIONSCONNECTIONSTARTTIME			"0.0.8.341.1.1.1.3.2.1.30"
#define H341_CONNECTIONSENDPOINTTYPE			"0.0.8.341.1.1.1.3.2.1.31"
#define H341_CONNECTIONSRELEASECOMPLETEREASON			"0.0.8.341.1.1.1.3.2.1.32"


/*
 * Entry definitions for table rasConfigurationTable 
 */

#define H341_RASCONFIGURATIONTABLE			"0.0.8.341.1.1.2.1.1"
#define H341_RASCONFIGURATIONGATEKEEPERIDENTIFIER			"0.0.8.341.1.1.2.1.1.1.1"
#define H341_RASCONFIGURATIONTIMER			"0.0.8.341.1.1.2.1.1.1.2"
#define H341_RASCONFIGURATIONMAXNUMBEROFRETRIES			"0.0.8.341.1.1.2.1.1.1.3"
#define H341_RASCONFIGURATIONGATEKEEPERDISCOVERYADDRESSTAG			"0.0.8.341.1.1.2.1.1.1.4"
#define H341_RASCONFIGURATIONGATEKEEPERDISCOVERYADDRESS			"0.0.8.341.1.1.2.1.1.1.5"


/*
 * Entry definitions for table rasRegistrationTable 
 */

#define H341_RASREGISTRATIONTABLE			"0.0.8.341.1.1.2.2.1"
#define H341_RASREGISTRATIONCALLSIGNALLINGADDRESSTAG			"0.0.8.341.1.1.2.2.1.1.1"
#define H341_RASREGISTRATIONCALLSIGNALLINGADDRESS			"0.0.8.341.1.1.2.2.1.1.2"
#define H341_RASREGISTRATIONSRCRASADDRESSTAG			"0.0.8.341.1.1.2.2.1.1.3"
#define H341_RASREGISTRATIONSRCRASADDRESS			"0.0.8.341.1.1.2.2.1.1.4"
#define H341_RASREGISTRATIONISGATEKEEPER			"0.0.8.341.1.1.2.2.1.1.5"
#define H341_RASREGISTRATIONGATEKEEPERID			"0.0.8.341.1.1.2.2.1.1.6"
#define H341_RASREGISTRATIONENDPOINTID			"0.0.8.341.1.1.2.2.1.1.7"
#define H341_RASREGISTRATIONENCRYPTION			"0.0.8.341.1.1.2.2.1.1.8"
#define H341_RASREGISTRATIONWILLSUPPLYUUIE			"0.0.8.341.1.1.2.2.1.1.9"
#define H341_RASREGISTRATIONINTEGRITYCHECKVALUE			"0.0.8.341.1.1.2.2.1.1.10"
#define H341_RASREGISTRATIONTABLENUMBEROFALIASES			"0.0.8.341.1.1.2.2.1.1.11"
#define H341_RASREGISTRATIONTABLEROWSTATUS			"0.0.8.341.1.1.2.2.1.1.12"
#define H341_RASREGISTRATIONENDPOINTTYPE			"0.0.8.341.1.1.2.2.1.1.13"
#define H341_RASREGISTRATIONPREGRANTEDARQ			"0.0.8.341.1.1.2.2.1.1.14"
#define H341_RASREGISTRATIONISREGISTEREDBYRRQ			"0.0.8.341.1.1.2.2.1.1.15"


/*
 * Entry definitions for table rasRegistrationAliasTable 
 */

#define H341_RASREGISTRATIONALIASTABLE			"0.0.8.341.1.1.2.2.2"
#define H341_RASREGISTRATIONALIASTABLEINDEX			"0.0.8.341.1.1.2.2.2.1.1"
#define H341_RASREGISTRATIONALIASTAG			"0.0.8.341.1.1.2.2.2.1.2"
#define H341_RASREGISTRATIONALIAS			"0.0.8.341.1.1.2.2.2.1.3"


/*
 * Entry definitions for table rasRegistrationRasAddressTable 
 */

#define H341_RASREGISTRATIONRASADDRESSTABLE			"0.0.8.341.1.1.2.2.3"
#define H341_RASREGISTRATIONRASADDRESSTABLEINDEX			"0.0.8.341.1.1.2.2.3.1.1"
#define H341_RASREGISTRATIONADDITIONALSRCRASADDRESSTAG			"0.0.8.341.1.1.2.2.3.1.2"
#define H341_RASREGISTRATIONADDITIONALSRCRASADDRESS			"0.0.8.341.1.1.2.2.3.1.3"


/*
 * Entry definitions for table rasRegistrationCallSignalingAddressTable 
 */

#define H341_RASREGISTRATIONCALLSIGNALINGADDRESSTABLE			"0.0.8.341.1.1.2.2.4"
#define H341_RASREGISTRATIONCALLSIGNALINGADDRESSTABLEINDEX			"0.0.8.341.1.1.2.2.4.1.1"
#define H341_RASREGISTRATIONADDITIONALCALLSIGNALINGADDRESSTAG			"0.0.8.341.1.1.2.2.4.1.2"
#define H341_RASREGISTRATIONADDITIONALCALLSIGNALINGADDRESS			"0.0.8.341.1.1.2.2.4.1.3"


/*
 * Entry definitions for table rasAdmissionTable 
 */

#define H341_RASADMISSIONTABLE			"0.0.8.341.1.1.2.3.1"
#define H341_RASADMISSIONSRCCALLSIGNALLINGADDRESSTAG			"0.0.8.341.1.1.2.3.1.1.1"
#define H341_RASADMISSIONSRCCALLSIGNALLINGADDRESS			"0.0.8.341.1.1.2.3.1.1.2"
#define H341_RASADMISSIONDESTCALLSIGNALLINGADDRESSTAG			"0.0.8.341.1.1.2.3.1.1.3"
#define H341_RASADMISSIONDESTCALLSIGNALLINGADDRESS			"0.0.8.341.1.1.2.3.1.1.4"
#define H341_RASADMISSIONCALLIDENTIFIER			"0.0.8.341.1.1.2.3.1.1.5"
#define H341_RASADMISSIONCONFERENCEID			"0.0.8.341.1.1.2.3.1.1.6"
#define H341_RASADMISSIONRASADDRESSTAG			"0.0.8.341.1.1.2.3.1.1.7"
#define H341_RASADMISSIONRASADDRESS			"0.0.8.341.1.1.2.3.1.1.8"
#define H341_RASADMISSIONCRV			"0.0.8.341.1.1.2.3.1.1.9"
#define H341_RASADMISSIONISGATEKEEPER			"0.0.8.341.1.1.2.3.1.1.10"
#define H341_RASADMISSIONSRCALIASADDRESSTAG			"0.0.8.341.1.1.2.3.1.1.11"
#define H341_RASADMISSIONSRCALIASADDRESS			"0.0.8.341.1.1.2.3.1.1.12"
#define H341_RASADMISSIONDESTALIASADDRESSTAG			"0.0.8.341.1.1.2.3.1.1.13"
#define H341_RASADMISSIONDESTALIASADDRESS			"0.0.8.341.1.1.2.3.1.1.14"
#define H341_RASADMISSIONANSWERCALLINDICATOR			"0.0.8.341.1.1.2.3.1.1.15"
#define H341_RASADMISSIONTIME			"0.0.8.341.1.1.2.3.1.1.16"
#define H341_RASADMISSIONENDPOINTID			"0.0.8.341.1.1.2.3.1.1.17"
#define H341_RASADMISSIONBANDWIDTH			"0.0.8.341.1.1.2.3.1.1.18"
#define H341_RASADMISSIONIRRFREQUENCY			"0.0.8.341.1.1.2.3.1.1.19"
#define H341_RASADMISSIONCALLTYPE			"0.0.8.341.1.1.2.3.1.1.20"
#define H341_RASADMISSIONCALLMODEL			"0.0.8.341.1.1.2.3.1.1.21"
#define H341_RASADMISSIONSRCHANDLESBANDWIDTH			"0.0.8.341.1.1.2.3.1.1.22"
#define H341_RASADMISSIONDESTHANDLESBANDWIDTH			"0.0.8.341.1.1.2.3.1.1.23"
#define H341_RASADMISSIONSECURITY			"0.0.8.341.1.1.2.3.1.1.24"
#define H341_RASADMISSIONSRCWILLSUPPLYUUIE			"0.0.8.341.1.1.2.3.1.1.25"
#define H341_RASADMISSIONDESTWILLSUPPLYUUIE			"0.0.8.341.1.1.2.3.1.1.26"
#define H341_RASADMISSIONTABLEROWSTATUS			"0.0.8.341.1.1.2.3.1.1.27"


/*
 * Entry definitions for table rasStatsTable 
 */

#define H341_RASSTATSTABLE			"0.0.8.341.1.1.2.4.1"
#define H341_RASSTATSGATEKEEPERCONFIRMS			"0.0.8.341.1.1.2.4.1.1.1"
#define H341_RASSTATSGATEKEEPERREJECTS			"0.0.8.341.1.1.2.4.1.1.2"
#define H341_RASSTATSREGISTRATIONCONFIRMS			"0.0.8.341.1.1.2.4.1.1.3"
#define H341_RASSTATSREGISTRATIONREJECTS			"0.0.8.341.1.1.2.4.1.1.4"
#define H341_RASSTATSUNREGISTRATIONCONFIRMS			"0.0.8.341.1.1.2.4.1.1.5"
#define H341_RASSTATSUNREGISTRATIONREJECTS			"0.0.8.341.1.1.2.4.1.1.6"
#define H341_RASSTATSADMISSIONCONFIRMS			"0.0.8.341.1.1.2.4.1.1.7"
#define H341_RASSTATSADMISSIONREJECTS			"0.0.8.341.1.1.2.4.1.1.8"
#define H341_RASSTATSBANDWIDTHCONFIRMS			"0.0.8.341.1.1.2.4.1.1.9"
#define H341_RASSTATSBANDWIDTHREJECTS			"0.0.8.341.1.1.2.4.1.1.10"
#define H341_RASSTATSDISENGAGECONFIRMS			"0.0.8.341.1.1.2.4.1.1.11"
#define H341_RASSTATSDISENGAGEREJECTS			"0.0.8.341.1.1.2.4.1.1.12"
#define H341_RASSTATSLOCATIONCONFIRMS			"0.0.8.341.1.1.2.4.1.1.13"
#define H341_RASSTATSLOCATIONREJECTS			"0.0.8.341.1.1.2.4.1.1.14"
#define H341_RASSTATSINFOREQUESTS			"0.0.8.341.1.1.2.4.1.1.15"
#define H341_RASSTATSINFOREQUESTRESPONSES			"0.0.8.341.1.1.2.4.1.1.16"
#define H341_RASSTATSNONSTANDARDMESSAGES			"0.0.8.341.1.1.2.4.1.1.17"
#define H341_RASSTATSUNKNOWNMESSAGES			"0.0.8.341.1.1.2.4.1.1.18"
#define H341_RASSTATSREQUESTINPROGRESS			"0.0.8.341.1.1.2.4.1.1.19"
#define H341_RASSTATSRESOURCEAVAILABILITYINDICATOR			"0.0.8.341.1.1.2.4.1.1.20"
#define H341_RASSTATSRESOURCEAVAILABILITYCONFIRM			"0.0.8.341.1.1.2.4.1.1.21"
#define H341_RASSTATSREGISTEREDENDPOINTSNO			"0.0.8.341.1.1.2.4.1.1.22"
#define H341_RASSTATSADMITTEDENDPOINTSNO			"0.0.8.341.1.1.2.4.1.1.23"
#define H341_RASSTATSINAKS			"0.0.8.341.1.1.2.4.1.1.24"
#define H341_RASSTATSIACKS			"0.0.8.341.1.1.2.4.1.1.25"
#define H341_RASSTATSGKROUTEDCALLS			"0.0.8.341.1.1.2.4.1.1.26"
#define H341_RASSTATSRESOURCEAVAILABILITYINDICATIONS			"0.0.8.341.1.1.2.4.1.1.27"
#define H341_RASSTATSRESOURCEAVAILABILITYCONFIRMATIONS			"0.0.8.341.1.1.2.4.1.1.28"


/*
 * Entry definitions for table h323TermSystemTable 
 */

#define H341_H323TERMSYSTEMTABLE			"0.0.8.341.1.1.3.1.1"
#define H341_H323TERMSYSTEMDESCR			"0.0.8.341.1.1.3.1.1.1.1"
#define H341_H323TERMSYSTEMHWVERSIONNO			"0.0.8.341.1.1.3.1.1.1.2"
#define H341_H323TERMSYSTEMSWVERSIONNO			"0.0.8.341.1.1.3.1.1.1.3"
#define H341_H323TERMSYSTEMCONTACT			"0.0.8.341.1.1.3.1.1.1.4"
#define H341_H323TERMSYSTEMT35COUNTRYCODE			"0.0.8.341.1.1.3.1.1.1.5"
#define H341_H323TERMSYSTEMT35COUNTRYCODEEXTENTION			"0.0.8.341.1.1.3.1.1.1.6"
#define H341_H323TERMSYSTEMT35MANUFACTURERCODE			"0.0.8.341.1.1.3.1.1.1.7"
#define H341_H323TERMSYSTEMLOCATION			"0.0.8.341.1.1.3.1.1.1.8"
#define H341_H323TERMSYSTEMUPTIME			"0.0.8.341.1.1.3.1.1.1.9"
#define H341_H323TERMSYSTEMLOCALTIME			"0.0.8.341.1.1.3.1.1.1.10"
#define H341_H323TERMSYSTEMDIAGNOSTICS			"0.0.8.341.1.1.3.1.1.1.11"
#define H341_H323TERMSYSTEMSTATUS			"0.0.8.341.1.1.3.1.1.1.12"


/*
 * Entry definitions for table h323TerminalCapsTable 
 */

#define H341_H323TERMINALCAPSTABLE			"0.0.8.341.1.1.3.2.1"
#define H341_H323TERMINALCAPSMAXLINERATE			"0.0.8.341.1.1.3.2.1.1.1"
#define H341_H323TERMINALCAPSVIDEOCAPS			"0.0.8.341.1.1.3.2.1.1.2"
#define H341_H323TERMINALCAPSMAXVIDEORATE			"0.0.8.341.1.1.3.2.1.1.3"
#define H341_H323TERMINALCAPSAUDIOCAPS			"0.0.8.341.1.1.3.2.1.1.4"
#define H341_H323TERMINALCAPSDATACAPS			"0.0.8.341.1.1.3.2.1.1.5"
#define H341_H323TERMINALCAPSRDCCAPS			"0.0.8.341.1.1.3.2.1.1.6"


/*
 * Entry definitions for table h323TerminalControlTable 
 */

#define H341_H323TERMINALCONTROLTABLE			"0.0.8.341.1.1.3.3.1"
#define H341_H323TERMINALCONTROLADMINCONTROL			"0.0.8.341.1.1.3.3.1.1.1"
#define H341_H323TERMINALCONTROLENABLELOCALLOOPBACK			"0.0.8.341.1.1.3.3.1.1.2"
#define H341_H323TERMINALCONTROLENABLEREMOTELOOPBACK			"0.0.8.341.1.1.3.3.1.1.3"


/*
 * Entry definitions for table h323McSystemTable 
 */

#define H341_H323MCSYSTEMTABLE			"0.0.8.341.1.1.4.1.1"
#define H341_H323MCSYSTEMNAMEANDMAKER			"0.0.8.341.1.1.4.1.1.1.1"
#define H341_H323MCSYSTEMSOFTWAREVERSIONNUMBER			"0.0.8.341.1.1.4.1.1.1.2"
#define H341_H323MCSYSTEMHARDWAREVERSIONNUMBER			"0.0.8.341.1.1.4.1.1.1.3"
#define H341_H323MCSYSTEMSTARTUPTIME			"0.0.8.341.1.1.4.1.1.1.4"


/*
 * Entry definitions for table h323McConfigTable 
 */

#define H341_H323MCCONFIGTABLE			"0.0.8.341.1.1.4.2.1"
#define H341_H323MCCONFIGMCCALLSIGNALINGTAG			"0.0.8.341.1.1.4.2.1.1.1"
#define H341_H323MCCONFIGMCCALLSIGNALINGADDRESS			"0.0.8.341.1.1.4.2.1.1.2"
#define H341_H323MCCONFIGGATEKEEPERADDRESSTAG			"0.0.8.341.1.1.4.2.1.1.3"
#define H341_H323MCCONFIGGATEKEEPERADDRESS			"0.0.8.341.1.1.4.2.1.1.4"
#define H341_H323MCCONFIGISREGISTEREDWITHGATEKEEPER			"0.0.8.341.1.1.4.2.1.1.5"
#define H341_H323MCCONFIGENABLENOTIFICATIONS			"0.0.8.341.1.1.4.2.1.1.6"


/*
 * Entry definitions for table h323McConferenceTable 
 */

#define H341_H323MCCONFERENCETABLE			"0.0.8.341.1.1.4.3.1"
#define H341_H323MCCONFERENCECONFERENCEID			"0.0.8.341.1.1.4.3.1.1.1"
#define H341_H323MCCONFERENCECONFERENCESTARTTIME			"0.0.8.341.1.1.4.3.1.1.2"
#define H341_H323MCCONFERENCECONFERENCEENDTIME			"0.0.8.341.1.1.4.3.1.1.3"
#define H341_H323MCCONFERENCECENTRALIZEDORDISTRIBUTED			"0.0.8.341.1.1.4.3.1.1.4"
#define H341_H323MCCONFERENCEUNIORMULTICAST			"0.0.8.341.1.1.4.3.1.1.5"
#define H341_H323MCCONFERENCEACTIVEMCADDRESS			"0.0.8.341.1.1.4.3.1.1.6"


/*
 * Entry definitions for table h323McConferenceParticipantsTable 
 */

#define H341_H323MCCONFERENCEPARTICIPANTSTABLE			"0.0.8.341.1.1.4.3.2"
#define H341_H323MCCONFERENCEPARTICIPANTSTABLEINDEX			"0.0.8.341.1.1.4.3.2.1.1"
#define H341_H323MCCONFERENCEPARTICIPANTSTERMINALLABEL			"0.0.8.341.1.1.4.3.2.1.2"
#define H341_H323MCCONFERENCEPARTICIPANTSCALLSIGNALINGTADDRESSTAG			"0.0.8.341.1.1.4.3.2.1.3"
#define H341_H323MCCONFERENCEPARTICIPANTSCALLSIGNALINGADDRESS			"0.0.8.341.1.1.4.3.2.1.4"
#define H341_H323MCCONFERENCEPARTICIPANTSCALLID			"0.0.8.341.1.1.4.3.2.1.5"
#define H341_H323MCCONFERENCEPARTICIPANTSCONTROLCHANNELINDEX			"0.0.8.341.1.1.4.3.2.1.6"
#define H341_H323MCCONFERENCEPARTICIPANTSNUMBEROFLOGICALCHANNELS			"0.0.8.341.1.1.4.3.2.1.7"
#define H341_H323MCCONFERENCEPARTICIPANTSRTPSESSIONINDEX			"0.0.8.341.1.1.4.3.2.1.8"


/*
 * Entry definitions for table h323MpConfigTable 
 */

#define H341_H323MPCONFIGTABLE			"0.0.8.341.1.1.5.1.1"
#define H341_H323MPCONFIGMAXAUDIOMIXCOUNT			"0.0.8.341.1.1.5.1.1.1.1"
#define H341_H323MPCONFIGMAXVIDEOMIXCOUNT			"0.0.8.341.1.1.5.1.1.1.2"


/*
 * Entry definitions for table h323MpConferenceTable 
 */

#define H341_H323MPCONFERENCETABLE			"0.0.8.341.1.1.5.2.1"
#define H341_H323MPCONFERENCECONFERENCEID			"0.0.8.341.1.1.5.2.1.1.1"
#define H341_H323MPCONFERENCEAUDIONOISETHRESHOLD			"0.0.8.341.1.1.5.2.1.1.2"
#define H341_H323MPCONFERENCELIPSYNCENABLE			"0.0.8.341.1.1.5.2.1.1.3"


/*
 * Entry definitions for table h323MpConferenceParticipantsTable 
 */

#define H341_H323MPCONFERENCEPARTICIPANTSTABLE			"0.0.8.341.1.1.5.2.2"
#define H341_H323MPCONFERENCEPARTICIPANTSTABLEINDEX			"0.0.8.341.1.1.5.2.2.1.1"
#define H341_H323MPCONFERENCEPARTICIPANTSENDPOINTID			"0.0.8.341.1.1.5.2.2.1.2"
#define H341_H323MPCONFERENCEPARTICIPANTSTRANSMITAUDIOSTATE			"0.0.8.341.1.1.5.2.2.1.3"
#define H341_H323MPCONFERENCEPARTICIPANTSRECEIVEAUDIOSTATE			"0.0.8.341.1.1.5.2.2.1.4"
#define H341_H323MPCONFERENCEPARTICIPANTSTRANSMITVIDEOSTATE			"0.0.8.341.1.1.5.2.2.1.5"
#define H341_H323MPCONFERENCEPARTICIPANTSRECEIVEVIDEOSTATE			"0.0.8.341.1.1.5.2.2.1.6"
#define H341_H323MPCONFERENCEPARTICIPANTSLOUDNESSMEASUREMENT			"0.0.8.341.1.1.5.2.2.1.7"
#define H341_H323MPCONFERENCEPARTICIPANTSVOICEACTIVITY			"0.0.8.341.1.1.5.2.2.1.8"
#define H341_H323MPCONFERENCEPARTICIPANTSINPUTAUDIOGAIN			"0.0.8.341.1.1.5.2.2.1.9"
#define H341_H323MPCONFERENCEPARTICIPANTSOUTPUTAUDIOGAIN			"0.0.8.341.1.1.5.2.2.1.10"
#define H341_H323MPCONFERENCEPARTICIPANTSMAXAUDIOENCODERPAYLOADSIZE			"0.0.8.341.1.1.5.2.2.1.11"
#define H341_H323MPCONFERENCEPARTICIPANTSMAXAUDIODECODERPAYLOADSIZE			"0.0.8.341.1.1.5.2.2.1.12"
#define H341_H323MPCONFERENCEPARTICIPANTSTOTALPACKETSTRANSMITTED			"0.0.8.341.1.1.5.2.2.1.13"
#define H341_H323MPCONFERENCEPARTICIPANTSTOTALPACKETSRECEIVED			"0.0.8.341.1.1.5.2.2.1.14"
#define H341_H323MPCONFERENCEPARTICIPANTSINVALIDPACKETERRORS			"0.0.8.341.1.1.5.2.2.1.15"
#define H341_H323MPCONFERENCEPARTICIPANTSLATEAUDIOPACKETSDROPPED			"0.0.8.341.1.1.5.2.2.1.16"
#define H341_H323MPCONFERENCEPARTICIPANTSRECEIVEDSILENCEPACKETS			"0.0.8.341.1.1.5.2.2.1.17"
#define H341_H323MPCONFERENCEPARTICIPANTSSILENCEPACKETSGENERATED			"0.0.8.341.1.1.5.2.2.1.18"
#define H341_H323MPCONFERENCEPARTICIPANTSVIDEOFRAMERATE			"0.0.8.341.1.1.5.2.2.1.19"
#define H341_H323MPCONFERENCEPARTICIPANTSVIDEORESOLUTION			"0.0.8.341.1.1.5.2.2.1.20"
#define H341_H323MPCONFERENCEPARTICIPANTSFULLPICTURECOUNTER			"0.0.8.341.1.1.5.2.2.1.21"


/*
 * Entry definitions for table h323MpConferenceGlobalAudioMixTable 
 */

#define H341_H323MPCONFERENCEGLOBALAUDIOMIXTABLE			"0.0.8.341.1.1.5.2.3"
#define H341_H323MPCONFERENCEGLOBALAUDIOMIXTABLEINDEX			"0.0.8.341.1.1.5.2.3.1.1"
#define H341_H323MPCONFERENCEGLOBALAUDIOMIXTERMINALIDENTIFIER			"0.0.8.341.1.1.5.2.3.1.2"


/*
 * Entry definitions for table h323MpConferenceGlobalVideoMixTable 
 */

#define H341_H323MPCONFERENCEGLOBALVIDEOMIXTABLE			"0.0.8.341.1.1.5.2.4"
#define H341_H323MPCONFERENCEGLOBALVIDEOMIXTABLEINDEX			"0.0.8.341.1.1.5.2.4.1.1"
#define H341_H323MPCONFERENCEGLOBALVIDEOMIXTERMINALIDENTIFIER			"0.0.8.341.1.1.5.2.4.1.2"


/*
 * Entry definitions for table h323ZoneTable 
 */

#define H341_H323ZONETABLE			"0.0.8.341.1.1.6.1.1"
#define H341_H323ZONEINDEX			"0.0.8.341.1.1.6.1.1.1.1"
#define H341_H323ZONEZONENAME			"0.0.8.341.1.1.6.1.1.1.2"
#define H341_H323ZONERASSIGNALADDRESSTAG			"0.0.8.341.1.1.6.1.1.1.3"
#define H341_H323ZONERASSIGNALADDRESS			"0.0.8.341.1.1.6.1.1.1.4"
#define H341_H323ZONEMAXBANDWIDTH			"0.0.8.341.1.1.6.1.1.1.5"
#define H341_H323ZONEALLOCATEDBANDWIDTH			"0.0.8.341.1.1.6.1.1.1.6"
#define H341_H323ZONEIRRFREQUENCY			"0.0.8.341.1.1.6.1.1.1.7"
#define H341_H323ZONELOCALZONE			"0.0.8.341.1.1.6.1.1.1.8"
#define H341_H323ZONEADMISSIONS			"0.0.8.341.1.1.6.1.1.1.9"
#define H341_H323ZONEADMISSIONSREJECTED			"0.0.8.341.1.1.6.1.1.1.10"
#define H341_H323ZONEROWSTATUS			"0.0.8.341.1.1.6.1.1.1.11"


/*
 * Entry definitions for table h323GatekeeperSystemTable 
 */

#define H341_H323GATEKEEPERSYSTEMTABLE			"0.0.8.341.1.1.6.2.1"
#define H341_H323GATEKEEPERSYSTEMNAMEANDMAKER			"0.0.8.341.1.1.6.2.1.1.1"
#define H341_H323GATEKEEPERSYSTEMSOFTWAREVERSIONNUMBER			"0.0.8.341.1.1.6.2.1.1.2"
#define H341_H323GATEKEEPERSYSTEMHARDWAREVERSIONNUMBER			"0.0.8.341.1.1.6.2.1.1.3"
#define H341_H323GATEKEEPERSYSTEMCONTACT			"0.0.8.341.1.1.6.2.1.1.4"
#define H341_H323GATEKEEPERSYSTEMT35COUNTRYCODE			"0.0.8.341.1.1.6.2.1.1.5"
#define H341_H323GATEKEEPERSYSTEMT35COUNTRYCODEEXTENTION			"0.0.8.341.1.1.6.2.1.1.6"
#define H341_H323GATEKEEPERSYSTEMT35MANUFACTURERCODE			"0.0.8.341.1.1.6.2.1.1.7"
#define H341_H323GATEKEEPERSYSTEMLOCATION			"0.0.8.341.1.1.6.2.1.1.8"
#define H341_H323GATEKEEPERSYSTEMUPTIME			"0.0.8.341.1.1.6.2.1.1.9"
#define H341_H323GATEKEEPERSYSTEMLOCALTIME			"0.0.8.341.1.1.6.2.1.1.10"


/*
 * Entry definitions for table h323GatekeeperConfigurationTable 
 */

#define H341_H323GATEKEEPERCONFIGURATIONTABLE			"0.0.8.341.1.1.6.3.1"
#define H341_H323GATEKEEPERCONFIGURATIONENABLENOTIFICATIONS			"0.0.8.341.1.1.6.3.1.1.1"
#define H341_H323GATEKEEPERCONFIGURATIONREGISTRATIONMODE			"0.0.8.341.1.1.6.3.1.1.2"


/*
 * Entry definitions for table h323GatekeeperStatisticsTable 
 */

#define H341_H323GATEKEEPERSTATISTICSTABLE			"0.0.8.341.1.1.6.4.1"
#define H341_H323GATEKEEPERSTATISTICSTOTALERRORS			"0.0.8.341.1.1.6.4.1.1.1"
#define H341_H323GATEKEEPERSTATISTICSLASTERROREVENTTIME			"0.0.8.341.1.1.6.4.1.1.2"
#define H341_H323GATEKEEPERSTATISTICSLASTERRORSEVERITY			"0.0.8.341.1.1.6.4.1.1.3"
#define H341_H323GATEKEEPERSTATISTICSLASTERRORPROBABLECAUSE			"0.0.8.341.1.1.6.4.1.1.4"
#define H341_H323GATEKEEPERSTATISTICSLASTERRORADDITIONALTEXT			"0.0.8.341.1.1.6.4.1.1.5"
#define H341_H323GATEKEEPERSTATISTICSZONENO			"0.0.8.341.1.1.6.4.1.1.6"


/*
 * Table definitions 
 */

typedef PASN_Array   H341_CALLSIGNALCONFIGTABLE_Table;
typedef PASN_Array   H341_CALLSIGNALSTATSTABLE_Table;
typedef PASN_Array   H341_CONNECTIONSTABLE_Table;
typedef PASN_Array   H341_RASCONFIGURATIONTABLE_Table;
typedef PASN_Array   H341_RASREGISTRATIONTABLE_Table;
typedef PASN_Array   H341_RASREGISTRATIONALIASTABLE_Table;
typedef PASN_Array   H341_RASREGISTRATIONRASADDRESSTABLE_Table;
typedef PASN_Array   H341_RASREGISTRATIONCALLSIGNALINGADDRESSTABLE_Table;
typedef PASN_Array   H341_RASADMISSIONTABLE_Table;
typedef PASN_Array   H341_RASSTATSTABLE_Table;
typedef PASN_Array   H341_H323TERMSYSTEMTABLE_Table;
typedef PASN_Array   H341_H323TERMINALCAPSTABLE_Table;
typedef PASN_Array   H341_H323TERMINALCONTROLTABLE_Table;
typedef PASN_Array   H341_H323MCSYSTEMTABLE_Table;
typedef PASN_Array   H341_H323MCCONFIGTABLE_Table;
typedef PASN_Array   H341_H323MCCONFERENCETABLE_Table;
typedef PASN_Array   H341_H323MCCONFERENCEPARTICIPANTSTABLE_Table;
typedef PASN_Array   H341_H323MPCONFIGTABLE_Table;
typedef PASN_Array   H341_H323MPCONFERENCETABLE_Table;
typedef PASN_Array   H341_H323MPCONFERENCEPARTICIPANTSTABLE_Table;
typedef PASN_Array   H341_H323MPCONFERENCEGLOBALAUDIOMIXTABLE_Table;
typedef PASN_Array   H341_H323MPCONFERENCEGLOBALVIDEOMIXTABLE_Table;
typedef PASN_Array   H341_H323ZONETABLE_Table;
typedef PASN_Array   H341_H323GATEKEEPERSYSTEMTABLE_Table;
typedef PASN_Array   H341_H323GATEKEEPERCONFIGURATIONTABLE_Table;
typedef PASN_Array   H341_H323GATEKEEPERSTATISTICSTABLE_Table;


/*
 * Type definitions 
 */

struct {
    PString         oid;
    PINDEX          type;
    PINDEX          access;
} H341_Field[] = {
    {
    H341_CALLSIGNALCONFIGTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_CALLSIGNALCONFIGMAXCONNECTIONS, ASN_INTEGER, H341_ReadOnly}, {
    H341_CALLSIGNALCONFIGAVAILABLECONNECTIONS, ASN_INTEGER, H341_ReadOnly},
    {
    H341_CALLSIGNALCONFIGT303, ASN_INTEGER, H341_ReadWrite}, {
    H341_CALLSIGNALCONFIGT301, ASN_INTEGER, H341_ReadWrite}, {
    H341_CALLSIGNALCONFIGENABLENOTIFICATIONS, ASN_INTEGER, H341_ReadWrite},
    {
    H341_CALLSIGNALSTATSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_CALLSIGNALSTATSCALLCONNECTIONSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSCALLCONNECTIONSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSALERTINGMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSALERTINGMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSCALLPROCEEDINGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSCALLPROCEEDINGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPACKMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPACKMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSPROGRESSMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSPROGRESSMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSRELEASECOMPLETEMSGSIN, ASN_COUNTER, H341_ReadOnly},
    {
    H341_CALLSIGNALSTATSRELEASECOMPLETEMSGSOUT, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSINQUIRYMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSINQUIRYMSGSOUT, ASN_COUNTER, H341_ReadOnly},
    {
    H341_CALLSIGNALSTATSFACILITYMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSFACILITYMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSINFOMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSINFOMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSNOTIFYMSGSIN, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSNOTIFYMSGSOUT, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSAVERAGECALLDURATION, ASN_INTEGER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSCALLCONNECTIONS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSALERTINGMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSCALLPROCEEDINGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSETUPACKMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSPROGRESSMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSRELEASECOMPLETEMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSSTATUSINQUIRYMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSFACILITYMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSINFOMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CALLSIGNALSTATSNOTIFYMSGS, ASN_COUNTER, H341_ReadOnly}, {
    H341_CONNECTIONSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_CONNECTIONSSRCTRANSPORTADDRESSTAG, ASN_INTEGER, H341_NoAccess}, {
    H341_CONNECTIONSSRCTRANSPORTADDRESS, ASN_OCTET_STR, H341_NoAccess}, {
    H341_CONNECTIONSCALLIDENTIFIER, ASN_OCTET_STR, H341_NoAccess}, {
    H341_CONNECTIONSROLE, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSSTATE, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSDESTTRANSPORTADDRESSTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSDESTTRANSPORTADDRESS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_CONNECTIONSDESTALIASTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSDESTALIAS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_CONNECTIONSSRCH245SIGTRANSPORTADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_CONNECTIONSSRCH245SIGTRANSPORTADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_CONNECTIONSDESTH245SIGTRANSPORTADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_CONNECTIONSDESTH245SIGTRANSPORTADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_CONNECTIONSCONFID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_CONNECTIONSCALLEDPARTYNUMBER, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_CONNECTIONSDESTXTRACALLINGNUMBER1, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSDESTXTRACALLINGNUMBER2, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSDESTXTRACALLINGNUMBER3, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSDESTXTRACALLINGNUMBER4, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSDESTXTRACALLINGNUMBER5, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSFASTCALL, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSSECURITY, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSH245TUNNELING, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSCANOVERLAPSEND, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSCRV, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSCALLTYPE, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSREMOTEEXTENSIONADDRESS, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_CONNECTIONSEXTRACRV1, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSEXTRACRV2, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSCONNECTIONSTARTTIME, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_CONNECTIONSENDPOINTTYPE, ASN_INTEGER, H341_ReadOnly}, {
    H341_CONNECTIONSRELEASECOMPLETEREASON, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASCONFIGURATIONTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASCONFIGURATIONGATEKEEPERIDENTIFIER, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_RASCONFIGURATIONTIMER, ASN_INTEGER, H341_ReadWrite}, {
    H341_RASCONFIGURATIONMAXNUMBEROFRETRIES, ASN_INTEGER, H341_ReadWrite},
    {
    H341_RASCONFIGURATIONGATEKEEPERDISCOVERYADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_RASCONFIGURATIONGATEKEEPERDISCOVERYADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_RASREGISTRATIONTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASREGISTRATIONCALLSIGNALLINGADDRESSTAG, ASN_INTEGER,
            H341_NoAccess}, {
    H341_RASREGISTRATIONCALLSIGNALLINGADDRESS, ASN_OCTET_STR,
            H341_NoAccess}, {
    H341_RASREGISTRATIONSRCRASADDRESSTAG, ASN_INTEGER, H341_NoAccess}, {
    H341_RASREGISTRATIONSRCRASADDRESS, ASN_OCTET_STR, H341_NoAccess}, {
    H341_RASREGISTRATIONISGATEKEEPER, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONGATEKEEPERID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASREGISTRATIONENDPOINTID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASREGISTRATIONENCRYPTION, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONWILLSUPPLYUUIE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONINTEGRITYCHECKVALUE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONTABLENUMBEROFALIASES, ASN_INTEGER, H341_ReadOnly},
    {
    H341_RASREGISTRATIONTABLEROWSTATUS, ASN_INTEGER, H341_Create}, {
    H341_RASREGISTRATIONENDPOINTTYPE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONPREGRANTEDARQ, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONISREGISTEREDBYRRQ, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONALIASTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASREGISTRATIONALIASTABLEINDEX, ASN_INTEGER, H341_NoAccess}, {
    H341_RASREGISTRATIONALIASTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASREGISTRATIONALIAS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASREGISTRATIONRASADDRESSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASREGISTRATIONRASADDRESSTABLEINDEX, ASN_INTEGER, H341_NoAccess},
    {
    H341_RASREGISTRATIONADDITIONALSRCRASADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_RASREGISTRATIONADDITIONALSRCRASADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_RASREGISTRATIONCALLSIGNALINGADDRESSTABLE, ASN_ARRAY,
            H341_NoAccess}, {
    H341_RASREGISTRATIONCALLSIGNALINGADDRESSTABLEINDEX, ASN_INTEGER,
            H341_NoAccess}, {
    H341_RASREGISTRATIONADDITIONALCALLSIGNALINGADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_RASREGISTRATIONADDITIONALCALLSIGNALINGADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_RASADMISSIONTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASADMISSIONSRCCALLSIGNALLINGADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_RASADMISSIONSRCCALLSIGNALLINGADDRESS, ASN_OCTET_STR,
            H341_NoAccess}, {
    H341_RASADMISSIONDESTCALLSIGNALLINGADDRESSTAG, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_RASADMISSIONDESTCALLSIGNALLINGADDRESS, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_RASADMISSIONCALLIDENTIFIER, ASN_OCTET_STR, H341_NoAccess}, {
    H341_RASADMISSIONCONFERENCEID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASADMISSIONRASADDRESSTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONRASADDRESS, ASN_OCTET_STR, H341_NoAccess}, {
    H341_RASADMISSIONCRV, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONISGATEKEEPER, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONSRCALIASADDRESSTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONSRCALIASADDRESS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASADMISSIONDESTALIASADDRESSTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONDESTALIASADDRESS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASADMISSIONANSWERCALLINDICATOR, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONTIME, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASADMISSIONENDPOINTID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_RASADMISSIONBANDWIDTH, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONIRRFREQUENCY, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONCALLTYPE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONCALLMODEL, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONSRCHANDLESBANDWIDTH, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONDESTHANDLESBANDWIDTH, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONSECURITY, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONSRCWILLSUPPLYUUIE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONDESTWILLSUPPLYUUIE, ASN_INTEGER, H341_ReadOnly}, {
    H341_RASADMISSIONTABLEROWSTATUS, ASN_INTEGER, H341_Create}, {
    H341_RASSTATSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_RASSTATSGATEKEEPERCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSGATEKEEPERREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSREGISTRATIONCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSREGISTRATIONREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSUNREGISTRATIONCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSUNREGISTRATIONREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSADMISSIONCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSADMISSIONREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSBANDWIDTHCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSBANDWIDTHREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSDISENGAGECONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSDISENGAGEREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSLOCATIONCONFIRMS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSLOCATIONREJECTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSINFOREQUESTS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSINFOREQUESTRESPONSES, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSNONSTANDARDMESSAGES, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSUNKNOWNMESSAGES, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSREQUESTINPROGRESS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSRESOURCEAVAILABILITYINDICATOR, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_RASSTATSRESOURCEAVAILABILITYCONFIRM, ASN_COUNTER, H341_ReadOnly},
    {
    H341_RASSTATSREGISTEREDENDPOINTSNO, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSADMITTEDENDPOINTSNO, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSINAKS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSIACKS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSGKROUTEDCALLS, ASN_COUNTER, H341_ReadOnly}, {
    H341_RASSTATSRESOURCEAVAILABILITYINDICATIONS, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_RASSTATSRESOURCEAVAILABILITYCONFIRMATIONS, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_H323TERMSYSTEMTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323TERMSYSTEMDESCR, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMSYSTEMHWVERSIONNO, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMSYSTEMSWVERSIONNO, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMSYSTEMCONTACT, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMSYSTEMT35COUNTRYCODE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMSYSTEMT35COUNTRYCODEEXTENTION, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323TERMSYSTEMT35MANUFACTURERCODE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMSYSTEMLOCATION, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMSYSTEMUPTIME, ASN_TIMETICKS, H341_ReadOnly}, {
    H341_H323TERMSYSTEMLOCALTIME, ASN_OCTET_STR, H341_ReadWrite}, {
    H341_H323TERMSYSTEMDIAGNOSTICS, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMSYSTEMSTATUS, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMINALCAPSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323TERMINALCAPSMAXLINERATE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMINALCAPSVIDEOCAPS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMINALCAPSMAXVIDEORATE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMINALCAPSAUDIOCAPS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMINALCAPSDATACAPS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323TERMINALCAPSRDCCAPS, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323TERMINALCONTROLTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323TERMINALCONTROLADMINCONTROL, ASN_INTEGER, H341_ReadWrite}, {
    H341_H323TERMINALCONTROLENABLELOCALLOOPBACK, ASN_INTEGER,
            H341_ReadWrite}, {
    H341_H323TERMINALCONTROLENABLEREMOTELOOPBACK, ASN_INTEGER,
            H341_ReadWrite}, {
    H341_H323MCSYSTEMTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MCSYSTEMNAMEANDMAKER, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MCSYSTEMSOFTWAREVERSIONNUMBER, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_H323MCSYSTEMHARDWAREVERSIONNUMBER, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_H323MCSYSTEMSTARTUPTIME, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MCCONFIGTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MCCONFIGMCCALLSIGNALINGTAG, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MCCONFIGMCCALLSIGNALINGADDRESS, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_H323MCCONFIGGATEKEEPERADDRESSTAG, ASN_INTEGER, H341_ReadWrite}, {
    H341_H323MCCONFIGGATEKEEPERADDRESS, ASN_OCTET_STR, H341_ReadWrite}, {
    H341_H323MCCONFIGISREGISTEREDWITHGATEKEEPER, ASN_INTEGER,
            H341_ReadWrite}, {
    H341_H323MCCONFIGENABLENOTIFICATIONS, ASN_INTEGER, H341_ReadWrite}, {
    H341_H323MCCONFERENCETABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MCCONFERENCECONFERENCEID, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MCCONFERENCECONFERENCESTARTTIME, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323MCCONFERENCECONFERENCEENDTIME, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_H323MCCONFERENCECENTRALIZEDORDISTRIBUTED, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MCCONFERENCEUNIORMULTICAST, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MCCONFERENCEACTIVEMCADDRESS, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MCCONFERENCEPARTICIPANTSTABLEINDEX, ASN_INTEGER,
            H341_NoAccess}, {
    H341_H323MCCONFERENCEPARTICIPANTSTERMINALLABEL, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSCALLSIGNALINGTADDRESSTAG,
            ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSCALLSIGNALINGADDRESS,
            ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSCALLID, ASN_OCTET_STR, H341_ReadOnly},
    {
    H341_H323MCCONFERENCEPARTICIPANTSCONTROLCHANNELINDEX, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSNUMBEROFLOGICALCHANNELS,
            ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MCCONFERENCEPARTICIPANTSRTPSESSIONINDEX, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFIGTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MPCONFIGMAXAUDIOMIXCOUNT, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MPCONFIGMAXVIDEOMIXCOUNT, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MPCONFERENCETABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MPCONFERENCECONFERENCEID, ASN_OCTET_STR, H341_NoAccess}, {
    H341_H323MPCONFERENCEAUDIONOISETHRESHOLD, ASN_INTEGER, H341_ReadOnly},
    {
    H341_H323MPCONFERENCELIPSYNCENABLE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MPCONFERENCEPARTICIPANTSTABLEINDEX, ASN_INTEGER,
            H341_NoAccess}, {
    H341_H323MPCONFERENCEPARTICIPANTSENDPOINTID, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSTRANSMITAUDIOSTATE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSRECEIVEAUDIOSTATE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSTRANSMITVIDEOSTATE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSRECEIVEVIDEOSTATE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSLOUDNESSMEASUREMENT, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSVOICEACTIVITY, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSINPUTAUDIOGAIN, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSOUTPUTAUDIOGAIN, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSMAXAUDIOENCODERPAYLOADSIZE,
            ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSMAXAUDIODECODERPAYLOADSIZE,
            ASN_INTEGER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSTOTALPACKETSTRANSMITTED,
            ASN_COUNTER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSTOTALPACKETSRECEIVED, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSINVALIDPACKETERRORS, ASN_COUNTER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSLATEAUDIOPACKETSDROPPED,
            ASN_COUNTER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSRECEIVEDSILENCEPACKETS,
            ASN_COUNTER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSSILENCEPACKETSGENERATED,
            ASN_COUNTER, H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSVIDEOFRAMERATE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSVIDEORESOLUTION, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEPARTICIPANTSFULLPICTURECOUNTER, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323MPCONFERENCEGLOBALAUDIOMIXTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MPCONFERENCEGLOBALAUDIOMIXTABLEINDEX, ASN_INTEGER,
            H341_NoAccess}, {
    H341_H323MPCONFERENCEGLOBALAUDIOMIXTERMINALIDENTIFIER,
            ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323MPCONFERENCEGLOBALVIDEOMIXTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323MPCONFERENCEGLOBALVIDEOMIXTABLEINDEX, ASN_INTEGER,
            H341_NoAccess}, {
    H341_H323MPCONFERENCEGLOBALVIDEOMIXTERMINALIDENTIFIER,
            ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323ZONETABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323ZONEINDEX, ASN_INTEGER, H341_NoAccess}, {
    H341_H323ZONEZONENAME, ASN_OCTET_STR, H341_Create}, {
    H341_H323ZONERASSIGNALADDRESSTAG, ASN_INTEGER, H341_Create}, {
    H341_H323ZONERASSIGNALADDRESS, ASN_OCTET_STR, H341_Create}, {
    H341_H323ZONEMAXBANDWIDTH, ASN_UNSIGNED, H341_Create}, {
    H341_H323ZONEALLOCATEDBANDWIDTH, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323ZONEIRRFREQUENCY, ASN_INTEGER, H341_Create}, {
    H341_H323ZONELOCALZONE, ASN_INTEGER, H341_Create}, {
    H341_H323ZONEADMISSIONS, ASN_COUNTER, H341_ReadOnly}, {
    H341_H323ZONEADMISSIONSREJECTED, ASN_COUNTER, H341_ReadOnly}, {
    H341_H323ZONEROWSTATUS, ASN_INTEGER, H341_Create}, {
    H341_H323GATEKEEPERSYSTEMTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323GATEKEEPERSYSTEMNAMEANDMAKER, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMSOFTWAREVERSIONNUMBER, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMHARDWAREVERSIONNUMBER, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMCONTACT, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMT35COUNTRYCODE, ASN_INTEGER, H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMT35COUNTRYCODEEXTENTION, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMT35MANUFACTURERCODE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMLOCATION, ASN_OCTET_STR, H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMUPTIME, ASN_TIMETICKS, H341_ReadOnly}, {
    H341_H323GATEKEEPERSYSTEMLOCALTIME, ASN_OCTET_STR, H341_ReadWrite}, {
    H341_H323GATEKEEPERCONFIGURATIONTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323GATEKEEPERCONFIGURATIONENABLENOTIFICATIONS, ASN_INTEGER,
            H341_ReadWrite}, {
    H341_H323GATEKEEPERCONFIGURATIONREGISTRATIONMODE, ASN_INTEGER,
            H341_ReadWrite}, {
    H341_H323GATEKEEPERSTATISTICSTABLE, ASN_ARRAY, H341_NoAccess}, {
    H341_H323GATEKEEPERSTATISTICSTOTALERRORS, ASN_COUNTER, H341_ReadOnly},
    {
    H341_H323GATEKEEPERSTATISTICSLASTERROREVENTTIME, ASN_OCTET_STR,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSTATISTICSLASTERRORSEVERITY, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSTATISTICSLASTERRORPROBABLECAUSE, ASN_INTEGER,
            H341_ReadOnly}, {
    H341_H323GATEKEEPERSTATISTICSLASTERRORADDITIONALTEXT,
            ASN_OCTET_STR, H341_ReadOnly}, {
H341_H323GATEKEEPERSTATISTICSZONENO, ASN_COUNTER, H341_ReadOnly}};




#endif                          /* H341_OID_H */
