/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

attachitemlistmodule.prototype = new ListModule;
attachitemlistmodule.prototype.constructor = attachitemlistmodule;
attachitemlistmodule.superclass = ListModule.prototype;

function attachitemlistmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

/**
 * Function will initialize this module
 */
attachitemlistmodule.prototype.init = function(id, element, title, data)
{
	attachitemlistmodule.superclass.init.call(this, id, element, title, data);

	this.attachments = new Array();
	this.tableGenerated = false;

	// hierarchy module element
	this.hierarchyElement = dhtml.getElementById("attach_item_targetfolder", "div", this.element);
	// table widget element
	this.contentElement = dhtml.getElementById("attach_item_tablewidget", "div", this.element);
	// initialize hierarchy tree
	this.initHierarchy();
	// initialize table widget
	this.initTableWidget();

	this.selectedFolders = false;
	this.containerClass = false;
}

/**
 * Function will initialize hierarchy tree in the module
 */
attachitemlistmodule.prototype.initHierarchy = function()
{
	// Load hierarchy module
	this.hierarchy = new hierarchyselectmodule();
	if(this.hierarchy) {
		var hierarchyID = webclient.addModule(this.hierarchy);
		this.hierarchy.addEventHandler("changefolder", this.hierarchy, this.hierarchyChangeFolder);
		this.hierarchy.init(hierarchyID, this.hierarchyElement, false);
		this.hierarchy.list();
	
		this.hierarchy.selectFolder(parentWebclient.hierarchy.defaultstore.defaultfolders.inbox);
	}
}

/**
 * Function will initialize table widget to show items of the selected folder
 * table widget is initialized only once, and then its reused
 */
attachitemlistmodule.prototype.initTableWidget = function()
{
	// initialize table widget
	this.tableWidget = new TableWidget(this.contentElement, true, false, true);
}

/**
 * Function which execute an action. This function is called by the XMLRequest object.
 * @param string type the action type
 * @param object action the action tag 
 */ 
attachitemlistmodule.prototype.execute = function(type, action)
{
	switch(type)
	{
		case "list":
			this.tableWidget.resetWidget();	
			this.messageList(action);
			break;
		case "attach_items":
			this.setAttachItemData(action);
			break;
		case "attach_items_in_body":
			this.setAttachAsBodyItemData(action);
			break;
	}
}

/**
 * Function which sends a request to the server, with the action "list".
 * which request the data items of the selected folder from hierarchy
 */ 
attachitemlistmodule.prototype.list = function()
{
	this.selectedFolders = this.hierarchy.getFolder(this.hierarchy.selectedFolder);
	this.containerClass = this.selectedFolders["container_class"];

	var data = new Object();
	data["store"] = this.hierarchy.selectedFolderStoreId;
	data["entryid"] = this.hierarchy.selectedFolder;
	data["container_class"] = this.containerClass;

	data["restriction"] = new Object();

	if(this.getRestrictionData) {
		data["restriction"] = this.getRestrictionData(); 
		if(data["restriction"] == false)
			return; // Abort list if module requires restriction but has none
	}

	data["restriction"]["start"] = this.rowstart;

	webclient.xmlrequest.addData(this, "list", data);
	webclient.xmlrequest.sendRequest();
}

/**
 * Function will add all items in the tableview, and also add columns to tableview
 * @param XMLNode action the action tag
 */
attachitemlistmodule.prototype.messageList = function(action)
{
	// get columns data from XML response
	this.getColumnDataFromXML(action);

	// get sorting info from XML response
	this.getSortDataFromXML(action);

	// add columns in table widget that is fetched from XML response
	attachItemAddColumns(this, this.properties);

	var items = action.getElementsByTagName("item");
	if(items.length > 0) {
		// store properties of messages
		this.getItemPropsFromXML(items);

		// create row column data and pass it to table widget to create layout
		this.tableGenerated = attachItemSetRowColumnData(this, items, this.properties);
	}else{
		this.tableWidget.showZeroResultMessage();
	}

	this.paging(action);
}

/**
 * Function which will add the selected items as embedded message(s) 
 *			attachments while composing the mail.
 * @param object action the action tag 
 */ 
attachitemlistmodule.prototype.setAttachItemData = function(action)
{
	window.windowData.module.messageAction = "forwardasattachment";
	window.windowData.module.setAttachItemData(action);
	window.close();
}

/**
 * Function which will add the selected items as text message attachments in body of the composing mail.
 * @param object action the action tag 
 */ 
attachitemlistmodule.prototype.setAttachAsBodyItemData = function(action)
{
	window.windowData.module.messageAction = "forwardasattachment";
	if(window.windowData.module.message_action == "reply" || window.windowData.module.message_action == "replyall"){
		window.windowData.module.deleteattachments = new Object();
		window.windowData.module.attachments = new Array();
	}

	var message = action.getElementsByTagName("item");
	for(var i=0;i<message.length;i++){
		window.windowData.module.setBody(message[i], true, false, true);
	}
	window.close();
}

/**
 * Function which takes care of the paging element
 * @param object action the action tag 
 */ 
attachitemlistmodule.prototype.paging = function(action, noReload)
{
	if(action) {
		var page = action.getElementsByTagName("page")[0];

		if(page) {
			var rowstart = page.getElementsByTagName("start")[0];
			if(rowstart && rowstart.firstChild) {
				this.rowstart = rowstart.firstChild.nodeValue * 1;
			}

			var rowcount = page.getElementsByTagName("rowcount")[0];
			if(rowcount && rowcount.firstChild) {
				this.rowcount = rowcount.firstChild.nodeValue * 1;
			}

			var totalrowcount = page.getElementsByTagName("totalrowcount")[0];
			if(totalrowcount && totalrowcount.firstChild) {
				this.totalrowcount = totalrowcount.firstChild.nodeValue * 1;
			}

			if(this.totalrowcount > this.rowcount) {
				var selected = attachItemPagingElement(this, this.totalrowcount, this.rowcount, this.rowstart);

				if(!selected && !noReload) {
					this.rowstart -= this.rowcount;
					this.list();
				}
			} else {
				attachItemRemovePagingElement(this);
				if(this.rowstart > 0 && !noReload) {
					this.rowstart = 0;
					this.list();
				}
			}
		}
	}
}

/**
 * @destructor 
 */
attachitemlistmodule.prototype.destructor = function()
{
	// remove paging elements
	if(this.pagingTool) {
		this.pagingTool.destructor();
		dhtml.deleteAllChildren(dhtml.getElementById("pageelement_"+ this.id, "div", this.element).parentNode);
	}

	// call destructor of widgets
	this.tableWidget.destructor();

	// remove registered events
	dhtml.removeEvents(this.element);

	attachitemlistmodule.superclass.destructor(this);
}

/**
 * Function called when hierarchy module has selected a folder
 */
attachitemlistmodule.prototype.hierarchyChangeFolder = function()
{
	// Simply call the list function to show the data in list.
	module.list();
}

/**
 * Function will be called when user double clicks on a message in table widget
 * @param Object tblWidget table widget object
 * @param String type type of event
 * @param HexString rowId rowid of element row
 * @param EventObject event event object
 */
attachitemlistmodule.prototype.eventAttachItemRowDblClick = function(tblWidget, type, rowId, event) {
	if(typeof rowId != "undefined" && rowId) {
		addAttachmentItems(this, window.dialog_attachment);
	}
}

/**
 * Event which is called when any folder in hierarchy tree is been selected
 * @param Object moduleObject
 * @param Html Element the element on which event occured
 * @param EventObject event event object
 */
function eventHierarchyChangeFolder(moduleObject, element, event)
{
	if(!event) {
		event = new Object();
	}
	
	if(event.button == 0 || event.button == 1 || !event.button) {
		var storeid = false;
		if(moduleObject.defaultstore) {
			storeid = moduleObject.defaultstore["id"];
		}
	
		var folder = moduleObject.getFolder(element.parentNode.id);
	
		if(folder) {
			var data = new Object();
			var storeid = moduleObject.folderstoreid;

			// Opened folder of another user will contain id and foldertype followed by '_', so remove foldertype
			if(storeid.indexOf("_") > 0)
				storeid = storeid.substr(0,storeid.indexOf("_"));
			
			moduleObject.setNumberItems(folder["content_count"], folder["content_unread"]);
			moduleObject.sendEvent("changefolder", storeid, folder);
			moduleObject.setDocumentTitle(folder);
		}
	}
}