#!/usr/bin/perl -w
#
# Stephan Uhlmann <su@su2.info>
#
# Removes expired IP addresses from the popauth file
# Execute it regularly via cron. At best in the same interval
# as as you set the expire time.
# example crontab entry:
# */5 * * * * /usr/local/sbin/cronpopauth.pl


# expiretime: the time after which an IP expires
# unit: minutes 
# default: 5

$expiretime = 5;


$popauth_file ="no";

if ($popauth_file ne "no")
{
 if ($popauth_file eq "yes")
  { $popauthfile = "/usr/local/var/popauth"; }
 else
  { $popauthfile = $popauth_file; }

 $popauthtempfile = "/usr/local/var/.popauth.tmp";

 $datafile = "/usr/local/var/popauth.dat";
 $datatempfile = "/usr/local/var/.popauth.dat.tmp";


 open(POPAUTHTEMPFILE,">$popauthtempfile") or die "Error opening temorary popauth file $popauthtempfile for writing";
 open(DATAFILE,"<$datafile") or die "Error opening popauth data file $datafile for reading";
 open(DATATEMPFILE,">$datatempfile") or die "Error opening temorary popauth data file $datatempfile for writing";

 while (<DATAFILE>)
 {
  /([0-9.]*):([0-9]*)/;			# $1 = ipaddress, $2 = timestamp

  if ( time() < ($2+$expiretime*60))
  {
   print DATATEMPFILE "$1:$2\n";
   print POPAUTHTEMPFILE "$1\n";
  }
 }

 close(DATAFILE);
 close(DATATEMPFILE);
 close(POPAUTHTEMPFILE);

 rename($datatempfile, $datafile);
 rename($popauthtempfile, $popauthfile);

}

