# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{home_run}
  s.version = "0.9.4"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Jeremy Evans"]
  s.date = %q{2010-10-18}
  s.default_executable = %q{home_run}
  s.description = %q{home_run is an implementation of ruby's Date/DateTime classes in C,
with much better performance (20-200x) than the version in the
standard library, while being almost completely compatible.
}
  s.email = %q{code@jeremyevans.net}
  s.executables = ["home_run"]
  s.extensions = ["ext/date_ext/extconf.rb"]
  s.extra_rdoc_files = ["README.rdoc", "CHANGELOG", "LICENSE"]
  s.files = ["LICENSE", "CHANGELOG", "README.rdoc", "Rakefile", "default.mspec", "bin/home_run", "lib/date.rb", "lib/date/format.rb", "lib/home_run.rb", "ext/date_ext/date_ext.c", "ext/date_ext/datetime.c", "ext/date_ext/date_parser.c", "ext/date_ext/date_ext.h", "ext/date_ext/extconf.rb", "ext/date_ext/date_parser.rl", "spec/date/accessor_spec.rb", "spec/date/add_month_spec.rb", "spec/date/add_spec.rb", "spec/date/boat_spec.rb", "spec/date/civil_spec.rb", "spec/date/commercial_spec.rb", "spec/date/constants_spec.rb", "spec/date/conversions_spec.rb", "spec/date/downto_spec.rb", "spec/date/eql_spec.rb", "spec/date/format_spec.rb", "spec/date/gregorian_spec.rb", "spec/date/hash_spec.rb", "spec/date/julian_spec.rb", "spec/date/leap_spec.rb", "spec/date/minus_month_spec.rb", "spec/date/minus_spec.rb", "spec/date/ordinal_spec.rb", "spec/date/parse_spec.rb", "spec/date/relationship_spec.rb", "spec/date/step_spec.rb", "spec/date/strftime_spec.rb", "spec/date/strptime_spec.rb", "spec/date/succ_spec.rb", "spec/date/today_spec.rb", "spec/date/upto_spec.rb", "spec/date/day_spec.rb", "spec/date/next_prev_spec.rb", "spec/date/parsing_spec.rb", "spec/date/allocate_spec.rb", "spec/date/limits_spec.rb", "spec/date/encoding_spec.rb", "spec/datetime/accessor_spec.rb", "spec/datetime/add_spec.rb", "spec/datetime/boat_spec.rb", "spec/datetime/constructor_spec.rb", "spec/datetime/conversions_spec.rb", "spec/datetime/eql_spec.rb", "spec/datetime/format_spec.rb", "spec/datetime/minus_spec.rb", "spec/datetime/now_spec.rb", "spec/datetime/parse_spec.rb", "spec/datetime/strftime_spec.rb", "spec/datetime/strptime_spec.rb", "spec/datetime/add_month_spec.rb", "spec/datetime/downto_spec.rb", "spec/datetime/hash_spec.rb", "spec/datetime/leap_spec.rb", "spec/datetime/minus_month_spec.rb", "spec/datetime/next_prev_spec.rb", "spec/datetime/parsing_spec.rb", "spec/datetime/relationship_spec.rb", "spec/datetime/step_spec.rb", "spec/datetime/succ_spec.rb", "spec/datetime/upto_spec.rb", "spec/datetime/day_spec.rb", "spec/datetime/allocate_spec.rb", "spec/datetime/limits_spec.rb", "spec/datetime/encoding_spec.rb", "spec/spec_helper.rb", "bench/mem_bench.rb", "bench/garbage_bench.rb", "bench/cpu_bench.rb", "bench/dt_mem_bench.rb", "bench/dt_garbage_bench.rb", "bench/cpu_bench_util.rb", "bench/parser_bench.rb"]
  s.homepage = %q{http://github.com/jeremyevans/home_run}
  s.rdoc_options = ["--quiet", "--line-numbers", "--inline-source", "--title", "home_run: Fast Date/DateTime classes for ruby", "--main", "README.rdoc"]
  s.require_paths = ["lib"]
  s.required_ruby_version = Gem::Requirement.new(">= 1.8.6")
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{Fast Date/DateTime classes for ruby}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
