# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Fernando Casanova <fcasanova@fluendo.com>

"""
Models specific to the LastFM plugin.
"""

from elisa.plugins.base.models.audio import AlbumModel

class LastFMAlbumModel(AlbumModel):

    """
    A LastFMAlbumModel contains some information queried to the LastFM Web
    Services.

    @ivar id: the item's LastFM Identification Number
    @type id: C{unicode}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(LastFMAlbumModel, self).__init__()
        self.id = None
