# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

if __name__ == '__main__':
    from twisted.internet import glib2reactor
    glib2reactor.install()

    from twisted.internet import reactor

    """
    import os
    os.unlink('test.db')
    """

    from elisa.plugins.database.media_scanner import MediaScanner, SCHEMA
    from elisa.plugins.base.local_resource import LocalResource
    from elisa.extern.twisted_storm.store import DeferredStore
    from storm.databases.sqlite import SQLite
    from storm.uri import URI

    from elisa.core import common
    from elisa.core.media_uri import MediaUri

    media = None

    class Appl(object):pass

    common.application = Appl()

    def set_manager(res):
        common.application.resource_manager = res

    def set_scanner(scanner):
        global media
        media = scanner
        db = SQLite(URI("sqlite:test.db"))
        con = db.connect()
        for line in SCHEMA:
            con.execute(line)
        con.commit()
        media.store = DeferredStore(db)
        media.parser.store = media.store
        return media.store.start()

    def printer(done):
        print "started"
        global media
        media.put(MediaUri('file://home/ben/media/audio/'),'')
 
    def setup():
        dfr = LocalResource.create({})
        dfr.addCallback(set_manager)
        dfr.addCallback(lambda x: MediaScanner.create({}))
        dfr.addCallback(set_scanner)
        dfr.addCallback(printer)


    reactor.callWhenRunning(setup)
    reactor.simulate()
    reactor.startRunning()
    import IPython
    IPython.Shell.IPShellGTK([], locals()).mainloop()

