/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.daemon.support;

import java.lang.reflect.Method;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonController;

public final class DaemonLoader {
    private static Controller controller = null;
    private static Context context = null;
    private static Object daemon = null;
    private static Method init = null;
    private static Method start = null;
    private static Method stop = null;
    private static Method destroy = null;
    static /* synthetic */ Class class$org$apache$commons$daemon$support$DaemonLoader;
    static /* synthetic */ Class class$org$apache$commons$daemon$DaemonContext;

    public static void version() {
        System.err.println("java version \"" + System.getProperty("java.version") + "\"");
        System.err.println(System.getProperty("java.runtime.name") + " (build " + System.getProperty("java.runtime.version") + ")");
        System.err.println(System.getProperty("java.vm.name") + " (build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
    }

    public static boolean check(String cn) {
        try {
            if (cn == null) {
                throw new NullPointerException("Null class name specified");
            }
            ClassLoader cl = (class$org$apache$commons$daemon$support$DaemonLoader == null ? (class$org$apache$commons$daemon$support$DaemonLoader = DaemonLoader.class$("org.apache.commons.daemon.support.DaemonLoader")) : class$org$apache$commons$daemon$support$DaemonLoader).getClassLoader();
            if (cl == null) {
                System.err.println("Cannot retrieve ClassLoader instance");
                return false;
            }
            Class<?> c = cl.loadClass(cn);
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            Object obj = c.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean load(String cn, String[] ar) {
        try {
            System.gc();
            if (ar == null) {
                ar = new String[]{};
            }
            if (cn == null) {
                throw new NullPointerException("Null class name specified");
            }
            ClassLoader cl = (class$org$apache$commons$daemon$support$DaemonLoader == null ? (class$org$apache$commons$daemon$support$DaemonLoader = DaemonLoader.class$("org.apache.commons.daemon.support.DaemonLoader")) : class$org$apache$commons$daemon$support$DaemonLoader).getClassLoader();
            if (cl == null) {
                System.err.println("Cannot retrieve ClassLoader instance");
                return false;
            }
            Class<?> c = cl.loadClass(cn);
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            boolean isdaemon = false;
            try {
                Class<?> dclass = cl.loadClass("org.apache.commons.daemon.Daemon");
                isdaemon = dclass.isAssignableFrom(c);
            }
            catch (Exception cnfex) {
                // empty catch block
            }
            Class[] myclass = new Class[]{isdaemon ? (class$org$apache$commons$daemon$DaemonContext == null ? (class$org$apache$commons$daemon$DaemonContext = DaemonLoader.class$("org.apache.commons.daemon.DaemonContext")) : class$org$apache$commons$daemon$DaemonContext) : ar.getClass()};
            init = c.getMethod("init", myclass);
            myclass = null;
            start = c.getMethod("start", myclass);
            stop = c.getMethod("stop", myclass);
            destroy = c.getMethod("destroy", myclass);
            daemon = c.newInstance();
            if (isdaemon) {
                controller = new Controller();
                DaemonLoader.controller.setAvailable(false);
                context = new Context();
                context.setArguments(ar);
                context.setController(controller);
                Object[] arg = new Object[]{context};
                init.invoke(daemon, arg);
            } else {
                Object[] arg = new Object[]{ar};
                init.invoke(daemon, arg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean start() {
        try {
            Object[] arg = null;
            start.invoke(daemon, arg);
            if (controller != null) {
                DaemonLoader.controller.setAvailable(true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean stop() {
        try {
            if (controller != null) {
                DaemonLoader.controller.setAvailable(false);
            }
            Object[] arg = null;
            stop.invoke(daemon, arg);
            System.gc();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean destroy() {
        try {
            Object[] arg = null;
            destroy.invoke(daemon, arg);
            daemon = null;
            controller = null;
            System.gc();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private static native void shutdown(boolean var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Context
    implements DaemonContext {
        DaemonController controller = null;
        String[] args = null;

        public DaemonController getController() {
            return this.controller;
        }

        public void setController(DaemonController controller) {
            this.controller = controller;
        }

        public String[] getArguments() {
            return this.args;
        }

        public void setArguments(String[] args) {
            this.args = args;
        }
    }

    public static class Controller
    implements DaemonController {
        boolean available = false;

        private Controller() {
            this.setAvailable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAvailable() {
            Controller controller = this;
            synchronized (controller) {
                return this.available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setAvailable(boolean available) {
            Controller controller = this;
            synchronized (controller) {
                this.available = available;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() throws IllegalStateException {
            Controller controller = this;
            synchronized (controller) {
                if (!this.isAvailable()) {
                    throw new IllegalStateException();
                }
                this.setAvailable(false);
                DaemonLoader.shutdown(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Controller controller = this;
            synchronized (controller) {
                if (!this.isAvailable()) {
                    throw new IllegalStateException();
                }
                this.setAvailable(false);
                DaemonLoader.shutdown(true);
            }
        }

        public void fail() throws IllegalStateException {
        }

        public void fail(String message) throws IllegalStateException {
        }

        public void fail(Exception exception) throws IllegalStateException {
        }

        public void fail(String message, Exception exception) throws IllegalStateException {
        }
    }
}

