/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;

public abstract class RealmBase
implements Lifecycle,
Realm {
    protected Container container = null;
    protected int debug = 0;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static MessageDigest md5Helper;
    protected static StringManager sm;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Principal authenticate(String username, String credentials) {
        String serverCredentials = this.getPassword(username);
        boolean validated = serverCredentials == null ? false : (this.hasMessageDigest() ? serverCredentials.equalsIgnoreCase(this.digest(credentials)) : serverCredentials.equals(credentials));
        if (!validated) {
            return null;
        }
        return this.getPrincipal(username);
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, credentials.toString());
    }

    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        String serverDigestValue = md5a1 + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = serverDigestValue.getBytes();
        } else {
            try {
                valueBytes = serverDigestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                this.log("Illegal digestEncoding: " + this.getDigestEncoding(), uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        String serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (this.debug >= 1) {
            this.log("Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < certs.length; ++i) {
                if (this.debug >= 2) {
                    this.log(" Checking validity for '" + certs[i].getSubjectDN().getName() + "'");
                }
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    if (this.debug >= 2) {
                        this.log("  Validity exception", e);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0]);
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        if (gp.getRealm() != this && this.debug >= 2) {
            this.log("Different realm " + this + " " + gp.getRealm());
        }
        boolean result = gp.hasRole(role);
        if (this.debug >= 2) {
            String name = principal.getName();
            if (result) {
                this.log(sm.getString("realmBase.hasRoleSuccess", name, role));
            } else {
                this.log(sm.getString("realmBase.hasRoleFailure", name, role));
            }
        }
        return result;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("realmBase.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", this.digest), e);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("realmBase.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.md = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                if (this.getDigestEncoding() == null) {
                    bytes = credentials.getBytes();
                } else {
                    try {
                        bytes = credentials.getBytes(this.getDigestEncoding());
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.log("Illegal digestEncoding: " + this.getDigestEncoding(), uee);
                        throw new IllegalArgumentException(uee.getMessage());
                    }
                }
                this.md.update(bytes);
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception e) {
                this.log(sm.getString("realmBase.digest"), e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new IllegalStateException();
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = digestValue.getBytes();
        } else {
            try {
                valueBytes = digestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                this.log("Illegal digestEncoding: " + this.getDigestEncoding(), uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        byte[] digest = md5Helper.digest(valueBytes);
        return md5Encoder.encode(digest);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected abstract Principal getPrincipal(String var1);

    protected Principal getPrincipal(X509Certificate usercert) {
        return this.getPrincipal(usercert.getSubjectDN().getName());
    }

    protected void log(String message) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + name + "]: " + message);
        } else {
            System.out.println(this.getName() + "[" + name + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        String name = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            name = this.container.getName();
        }
        if (logger != null) {
            logger.log(this.getName() + "[" + name + "]: " + message, throwable);
        } else {
            System.out.println(this.getName() + "[" + name + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public static final String Digest(String credentials, String algorithm, String encoding) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (encoding == null) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.convert(md.digest());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return credentials;
        }
    }

    public static void main(String[] args) {
        String encoding = null;
        int firstCredentialArg = 2;
        if (args.length > 4 && args[2].equalsIgnoreCase("-e")) {
            encoding = args[3];
            firstCredentialArg = 4;
        }
        if (args.length > firstCredentialArg && args[0].equalsIgnoreCase("-a")) {
            for (int i = firstCredentialArg; i < args.length; ++i) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.Digest(args[i], args[1], encoding));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> [-e <encoding>] <credentials>");
        }
    }

    static {
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

