<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"!" => " !",
"0|1, display the parsed report definition" => "0|1, afficher la définition des rapports de conversion",
"0|1, may not be used with colors" => "0|1, ne doit pas être utilisé avec les couleurs",
"0|1, parse wiki syntax within the html code" => "0|1, convertir la syntaxe wiki dans le code HTML",
"0|1, parse wiki syntax within the report" => "0|1, convertir la syntaxe wiki dans le rapport",
"0 for no refresh" => "0 pour ne pas rafraîchir",
"-1 for never" => "-1 pour jamais",
"1 suggestion" => "1 suggestion",
"Above" => "Au-dessus",
"Accept all" => "Accepter tout",
"Accept all characters" => "Accepter tous les caractères",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Options pour l'action&nbsp;: Intitulé, post, tiki-index.php, page&nbsp;: nomduchamp, highlight=test",
"Activate MySQL 'Full-Text' feature" => "Activate la fonctionnalité MySQL 'Full-Text'",
"Activate MySQL Full-Text feature" => "Activer la fonctionnalité 'texte intégral' (Full-Text) de MySQL",
"Active?" => "Activé?",
"Add Groups" => "Ajouter un groupe",
"Adding a new host" => "Ajouter un nouveau serveur",
"Additional permissions" => "Permissions additionnelles",
"Add new mail account" => "Ajouter un nouveau compte email géré par ce Webmail",
"Add new rule" => "Ajouter une nouvelle règle",
"Add or edit event" => "Ajouter/modifier un évènement",
"Add this object at the end of menu" => "Ajouter cet objet à la fin du menu",
"Add to List" => "Ajouter à la liste",
"Add Users" => "Ajouter un utilisateur",
"Add watch" => "Ajouter une notification",
"Admin Banners" => "Administrer bannières",
"Admin Banners tpl" => "Administrer gabarit bannières",
"Admin banning tpl" => "Gabarit de l'administration des bannières",
"Admin Cache" => "Administrer l'antémémoire",
"Admin Cache tpl" => "Gabarit de l'administration de l'antémémoire",
"Admin Categories tpl" => "Admin le gabarit des catégories",
"Admin category relationships" => "Administrer les relations entre catégories",
"Admin Charts" => "Administrer les palmarès",
"Admin Charts Template" => "Gabarit de l'administration des palmarès",
"Admin Content Templates Template" => "Gabarit de l'administration des gabarits",
"Admin Directory" => "Administrer les liens",
"Admin Directory Categories tpl" => "Gabarit de l'administration des catégories des liens",
"Admin Directory Related" => "Administrer les répertoires en relation",
"Admin Directory Sites" => "Administrer les sites des répertoires",
"Admin Directory Sites tpl" => "gabarit de l'administration des sites des répertoires",
"Admin Directory tpl" => "Gabarit de l'administration des répertoires de liens",
"Admin Drawings tpl" => "Administrer les modèles de dessins",
"Admin DSN" => "Administrer les DSNs",
"Admin DynamicContent tpl" => "Admin gabarit Contenu Dynamique",
"Admin email" => "E-mail de l'utilisateur admin",
"Admin Email Notifications" => "Admin notifications par courriel",
"Admin events" => "Administrer les évènements",
"Admin FAQs" => "Administrer les FAQs",
"Admin Featured Links" => "Administrer les liens vedette",
"Admin Featured Links Template" => "Gabarit de l'administration des liens vedette",
"Admin Forums Template" => "Gabarit de l'administration des forums",
"Admin Groups Template" => "Gabarit de l'administration des groupes",
"Admin home" => "Accueil-administrer",
"Admin Hotwords Template" => "Gabarit de l'administration des mot/liens automatiques",
"Admin Html Pages" => "Administrer les pages HTML",
"Admin Html Pages Template" => "Administrer les modèles de pages HTML",
"Administer modules" => "Administrer les modules",
"administer surveys template" => "gabarit de l'administration des enquêtes",
"Admin Live Support tpl" => "Gabarit de l'administration de l'assistance en ligne",
"Admin Mailing Template" => "Gabarit de l'administration des mail-ins",
"Admin Menu Builder" => "Administrer le constructeur de menu",
"Admin Menus Template" => "Gabarit de l'administration des menus",
"Admin Menus tpl" => "Gabarit de l'administration des menus",
"Admin Modules Template" => "Gabarit d'administration des modules",
"Admin Newsletters Template" => "Administrer un gabarit de lettre d'informations",
"Admin Notifications Template" => "Gabarit de l'administration des notifications",
"Admin Polls Template" => "Gabarit de l'administration des sondages",
"Admin Posts" => "Administrer les publications",
"Admin quiz" => "Administrer les QCMs",
"Admin quizzes" => "Administrer les QCMs",
"Admin Quizzes tpl" => "Gabarit de l'administration des QCMs",
"Admin Referer Stats" => "Administrer les statistiques des origines",
"Admin Referer Stats tpl" => "Gabarit de l'administration des statistiques des origines",
"Admin RSSmodules Template" => "Administrer les Gabarits des modules RSS",
"Admin Send Objects tpl" => "Gabarit des envois d'objets",
"Admin Shoutbox Words Template" => "Gabarit d'administration des mots du mégaphone",
"Admin structures template" => "Administrer les gabarits de structures",
"Admin Tiki Shoutbox" => "Administrer le mégaphone",
"Admin Shoutbox" => "Administrer le mégaphone",
"Admin Tiki Shoutbox tpl" => "Administrer le gabarit mégaphone",
"Admin Shoutbox template" => "Administrer le gabarit mégaphone",
"Admin Topics Template" => "Gabarit de l'administration des sujets",
"Admin Tracker" => "Administrer le formulaire",
"Admin trackers" => "Administrer les formulaires",
"Admin Trackers tpl" => "Admin le gabarit des formulaires",
"Admin Users Template" => "Gabarit de l'administration des utilisateurs",
"Admin Webmail" => "Administrer les Webmails",
"AdmMenu" => "Cliquer pour voir le sous-menu",
"%A %d of %B, %Y" => "%A %d %B %Y",
"%a %d of %b, %Y" => "%e/%m/%y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %e %B %Y [%Hh%M]",
"%a %d of %b, %Y[%H:%M %Z]" => "%e/%m/%y [%Hh%M]",
"Advanced search" => "Recherche avancée",
"Again" => "Encore",
"Again please" => "Encore une fois",
"<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Ajouter une catégorie</a>",
"ajax and mootools features mandatory for that feature" => "les fonctionnalités ajax et mootools sont obligatoires pour cette fonctionnalité",
"A leading minus sign indicates that this word must not be present in any row returned" => "Un signe - en tête signifie que ce mot doit être absent de chaque ligne retournée",
"A leading plus sign indicates that this word must be present in every object returned" => "Un signe + en tête signifie que ce mot doit être présent dans chaque objet retourné",
"alert" => "alerte",
"Allocating too little memory will cause Tiki to display blank pages" => "Allouer trop peu de mémoire provoque l'affichage de pages blanches par Tiki",
"Allocating too little memory will cause TikiWiki to display blank pages" => "Une trop faible allocation de mémoire provoque l'affichage de pages blanches",
"Allow Anonymous Poll Voting" => "Permettre aux anonymes de voter dans les sondages",
"Allow anonymous users to \"Contact Us\"" => "Permettre aux utilisateurs anonymes le \"Nous contacter\"",
"Allow first posts of a thread to have an empty body (will be a thread title)" => "Permettre aux premiers articles d'un fil de discussion d'avoir un corps vide (sera un titre d'article)",
"Allow Smileys" => "Permettre les frimousses",
"Allow to manage thread defaults in each forum configuration" => "Permettre de configurer les paramètres par défaut des articles dans chaque configuation de forum",
"Alternate text to display if impossible to load the image" => "Texte alternatif à afficher si le chargement de l'image est impossible",
"Anchor link label" => "Etiquette de l'ancre",
"An error as occured with the mapfile" => "Une erreur s'est produite avec le fichier carte",
"A new %s  major release branch is available" => "Une nouvelle %s version majeure est disponible",
"Anonymous editors must input anti-bot code" => "Les éditeurs anonymes doivent saisir un code de vérification anti-bot",
"Another post with the same title and content already exists." => "une autre publication avec les mêmes titre et contenu existe déjà.",
"Answer is mandatory" => "Réponse obligatoire",
"Antarctica" => "Antartique",
"Any help with the documentation is welcome." => "Toute aide avec la documentation est bienvenue.",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apache a les permissions pour écrire des fichiers dans le répertoire, ce qui active l'installation, la suppression ou la mise à jour des paquets. Quand vous aurez terminé ces opérations, pensez à fixer les permissions dans un état sécurisé (utilisez \"./setup.sh\" par exemple).",
"applicable for this item" => "s'applique à cet élément",
"Apply custom CSS class to the box" => "Appliquer une classe CSS personnalisée pour la boite",
"Apply permissions" => "Appliquer les permissions",
"Apr" => "avr.",
"Are your database login credentials correct" => "Vos données de connexion à la base de données sont-elles correctes",
"Are you sure you want to delete this entry ?" => "Êtes-vous certain de vouloir détruire cette entrée ?",
"Are you sure you want to delete this note" => "Êtes-vous sur de vouloir supprimer cette note",
"Are you sure you want to remove this module?" => "Etes-vous sûr(e) de vouloir supprimer ce module ?",
"Are you sure you want to remove this topic AND all the articles related" => "Êtes-vous sur de vouloir supprimer ce sujet ET tous les articles apparentés",
"Are you sure you want to remove this topic" => "Êtes-vous sur de vouloir supprimer ce sujet",
"Are you upgrading an existing Tiki site" => "Voulez-vous mettre à jour une installation TikiWiki existante",
"Article comments settings" => "Configuration des commentaires d'articles",
"Articles Home" => "Accueil-Articles",
"Article Types tpl" => "Gabarit des types d'article",
"As defined by CSS" => "Comme défini par CSS",
"As defined by CSS, name or Hex code" => "Même définition que CSS, nom ou code Hex",
"Assignments" => "Devoirs",
"Assign Module" => "Attribuer un module",
"Assign permissions to group" => "Attribuer des droits d'accès au groupe",
"Assign to Groups" => "Mettre dans les groupes",
"{\$atts_cnt} files attached" => "{\$atts_cnt} fichiers joints",
"Aug" => "août",
"Authentication required" => "Authentification requise",
"Author if not the file creator" => "Auteur si différent du créateur",
"Autogenerated content. Leave blank initially" => "Contenu généré automatiquement. Laisser vide initialement",
"Available languages (Ctrl+Click to select multiple languages)" => "Langues disponibles (faire Ctrl+Clic pour sélectionner plusieurs langues)",
"A wildcard pattern of originating pages to be ignored.<br />" => "Une expression régulière des pages d'origine à ignorer.<br />",
"babelfish it" => "utiliser Babelfish",
"back to admin" => "retourner à l'administration",
"back to forum" => "retourner au forum",
"Back to Homepage" => "Retourner à la page d'accueil",
"back to mailbox" => "retourner à la boîte à lettre",
"Backups" => "Sauvegardes",
"Backup your database with mysqldump, phpmyadmin, or other before upgrading." => "Sauvegarder votre base de données avec mysqldump ou phpmyadmin ou autres avant de faire la mise à jour.",
"bad type name" => "mauvais nom de type",
"Bar height in pixels" => "Hauteur de l'histogramme en pixels",
"Bar width in pixels" => "Largeur de l'histogramme en pixels",
"Batch upload" => "Envoi par lot",
"Be carefull to set the right permissions on the files you link to" => "Soyez vigilant aux permissions des fichiers que vous liez",
"%B %e" => "%e %B",
"Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Avant d'installer Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">regardez la documentation</a> et assurez vous que les pré-requis sont satisfaits",
"Below" => "Dessous",
"Blog comments settings" => "Configuration des commentaires de blogues",
"Blog features" => "Fonctionnalités des blogues",
"Blog level comments" => "Commentaires au niveau blogue",
"Blog listing configuration (when listing available blogs)" => "Configuration de l'affichage des blogues (quand la liste des blogues est disponible)",
"Blogs have a custom heading" => "Personnalisation des en-têtes de blogues",
"bold" => "gras",
"Browse directory" => "Parcourir le répertoire",
"Browse Directory" => "Parcourir les liens du répertoire",
"Browse file gallery" => "Parcourir la galerie de fichiers",
"Browse gallery" => "Parcourir la galerie",
"browse the category system" => "parcourir le système de catégories",
"Browsing Gallery" => "Galerie",
"Browsing Image" => "Image",
"... but need admin validation" => "... Mais a besoin d'une validation de l'administrateur",
"But still create line breaks within paragraphs" => "Crée cependant toujours des sauts de lignes à l'intérieur des paragraphes",
" But the login failed, so check the Username and Password" => "Mais l'authentification a échouée, vérifier l'identifiant et le mot de passe",
"Buttons: Edit, Source, Remove, .." => "Boutons: Editer, Source, Supprimer, ..",
"Buttons: Save, Preview, Cancel, .." => "Boutons: Sauvegarder, Aperçu, Annuler, ..",
"By clicking &quot;Continue&quot; you agree to the terms of this license" => "En cliquant sur &quot;Continuer&quot; vous acceptez les termes de la licence",
"By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "Par défaut (si ni le - ni le + ne sont spécifiés) le mot est optionnel, mais l'objet qui le contient devra mieux pondéré",
"by the" => "par la",
"Calendar manual selection of time/date" => "Sélection manuelle temps/date dans le calendrier",
"Can admin any mypage" => "Droit d'administrer les mespages",
"Can assign perms to mypage" => "Droit d'assigner des permissions aux mespages",
"Can edit any mypage" => "Droit d'édition de toutes les mespages",
"Can list mypages" => "Droit de lister les mespages",
"cannot be found" => "ne peut pas être trouvé",
"Cannot write to this file" => "Ne peut pas écrire sur ce fichier ",
"Can  receive tasks from other users" => "Peut se voir affecter des tâches par d'autres utilisateurs",
"Can specify notification emails when creating an article" => "Peut demander les mails de notification lors de la création d'un article",
"can't open mypage" => "ne peut pas ouvrir mespage",
"Can't parse remote HTML page" => "On ne peut pas analyser une page HTML distante",
"Can use Directoy Batch Load" => "Droit d'utiliser le téléchargement par lot",
"Can view  page backlinks" => "Droit de voir les liens pointant vers cette page",
"CAS server hostname" => "Adresse Internet du serveur CAS",
"CAS server path" => "Chemin d'accès au serveur CAS",
"CAS server port" => "Port du serveur CAS",
"Categories browse uses PhpLayers" => "Le parcours des catégories se fait à l'aide de PhpLayers",
"categorize this object" => "catégoriser cet objet",
"Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Options pour catégorie&nbsp;: parentId,d|m|radio|checkbox(default),1|0(default) pour avoir un bouton \"Sélectionner tout\", d pour liste déroulante (dropdown), m pour liste déroulante multiple",
"cc" => "cc",
"Change CAS preferences" => "Modifier les préférences CAS",
"Change Shibboleth preferences" => "Changer les préférences Shibboleth",
"Changes" => "Modifications",
"Change users defaults" => "Changer les valeurs par défaut des utilisateurs",
"ChartMenu" => "Cliquer pour voir le sous-menu",
"Charts Admin" => "Administrer les palmarès",
"charts" => "palmarès",
"Chat Admin" => "Administrer les discussions",
"Chat Administration" => "Administrer les discussions",
"Chat Admin tpl" => "gabarit de l'administration des discussions",
"Chat channels" => "Salons de discussion",
"chat" => "discuter",
"Checkbox options: put 1 if you need that next field is on the same row." => "À cocher&nbsp;: mettre 1 si vous voulez que le champ suivant soit sur la même rangée.",
"Choices separator" => "Séparateur des choix",
"Choose a field .." => "Choisir un champ ..",
"Choose Categories" => "Choisir les catégories",
"cleanup" => "nettoyage",
"Clear all Categories" => "Décocher toutes les catégories",
"Click" => "Cliquer",
"Click here to manage your personal menu" => "Cliquer ici pour gérer votre menu personnel",
"Click to see the ratings" => "Cliquer pour voir les notations",
"click to show/hide" => "cliquer pour afficher/masquer",
"Click to vote for this value" => "Cliquer pour votre pour ce choix",
"clip" => "clip",
"CMS features" => "Fonctionnalités du CMS",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Récupérer les pages d'origine ou voulues dans une cellule et afficher les dans une seconde colonne.<br />",
"Colon separated list of field IDs" => "IDs de champs séparés par des virgules",
"colons" => "points",
"(comma separated list of URIs)" => "(liste des URIs séparées par des virgules)",
"Complete these fields to configure common, general settings for your site" => "Complétez ces champs pour configurer les paramètres généraux et communs pour votre site",
"Complete URL, internal or external" => "URL complète, interne ou externe",
"component class not found" => "classe du composant introuvable",
"component name is invalid" => "le nom du composant n'est pas valide",
"Components" => "Composants",
"compose" => "composer",
"compression is handled by" => "compression géré par",
"Config Calendars" => "Config calendriers",
"Configuration bar settings are kept for all forums during the user session" => "Les paramètres d'affichage sont conservés pour tous les forums pendant la session de l'utilisateur",
"Configure Polls" => "Configurer les sondages",
"Consider we are in always in HTTPS, but do not check" => "Considère que nous sommes toujours en HTTPS, sans le vérifier",
"contact feature disabled" => "fonctionnalité contact désactivée",
"contacts" => "contacts",
"Contact Us (Anonymous)" => "Nous contacter (anonymement)",
"contact us" => "nous contacter",
"Content Features" => "Fonctionnalités contenu",
"Content Related" => "Contenu",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Contrôle la reconnaissance des liens Wiki avec la syntaxe des doubles parenthèses <i>((nom de la page))</i>.",
"convert the last sub directory to a sub gallery" => "convertir le dernier sous répertoire en une sous galerie",
"Copyright Management" => "Administration du Copyright",
"Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Options du sélecteur de pays&nbsp;: name/flag, sortorder - name/flag&nbsp;: 0,1 ou 2 où 1 n'affiche que le nom du pays, 2 n'affiche que le drapeau du pays, 0 affiche les deux (par défaut). sortorder&nbsp;: 0 ou 1 où 0 trie par rapport au texte traduit (défaut) et 1 trie en fonction du nom du pays en anglais même si les nomsd de pays sont traduits",
"Create a file gallery" => "Créer une galerie de fichiers",
"Create a group for each user <br />(with the same name as the user)" => "Créer un groupe pour chaque utilisateur<br />(avec le même nom que le nom utilisateur)",
"Create a new database (clean install) with profile" => "Créer une nouvelle base de données (installation propre) avec les profils",
"Create a Tag for the Current Wiki" => "Créer un marqueur pour le Wiki courant",
"Create/Edit Blog" => "Ajouter/modifier un blogue",
"Create/edit Calendars" => "Ajouter/modifier un calendrier",
"Create/edit channel" => "Ajouter/modifier un salon de discussion",
"Create/edit questions for survey" => "Ajouter/modifier une question de l'enquête",
"Create/Edit Trackers" => "Ajouter/modifier un formulaire",
"Create item" => "Créer une fiche",
"Create new RSS module" => "Créer un nouveau module RSS",
"Creates a box with the data" => "pour mettre le texte dans un pavé",
"Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Créé un lien vers une ancre dans une page. Les ancres peuvent être créées en utilisant le plugin ANAME",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Crée un lien sur le fichier nommé. Si la page n'est pas donnée, le fichier sera joint à la page courante. Si la description n'est pas donnée, le nom du fichier sera utilisé pour le texte du lien, à moins que showdesc soit utilisé, ce qui fait utiliser la description du fichier comme texte du lien. Si image=1, le fichier joint est traité comme une image et est affiché directement dans la page; aucun lien n'est généré",
"Creates an annotation block for an image" => "Crée un bloc d'annotations pour une image",
"creates a table" => "pour créer un tableau",
"creates a title bar" => "pour une barre de titre",
"Create Trackers" => "Créer un nouveau formulaire",
"Create user if not in Auth?" => "Créer un utilisateur s'il n'est pas dans Auth?",
"Create user if not in Tiki?" => "Créer un utilisateur s'il n'est pas dans Tiki?",
"Create with default group?" => "Créer avec un groupe par défaut ?",
"Crypt passwords method" => "Méthode d'encryptage des mots de passe",
"Current permissions" => "Permissions actives",
"Customer Extranet" => "Espace client dédié (extranet)",
"Database Independent Full Text Search or Tiki Search" => "Recherche \"Full text\" indépendente de la base données ou recherche Tiki",
"Database name" => "Nom de la base de données",
"database queries used" => "Requêtes à la base de données utilisées",
"Database Search using MySQL 'Full-Text' Feature" => "Recherche exploitant la fonctionnalité 'texte intégral' (Full-Text) de MySQL",
"Database type" => "Type de base de données",
"Database was left unchanged" => "La base de données n'a pas été modifiée",
"date" => "date",
"Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Options de Date et d'Heure: date_heure,année0,année1 où date_heure=d|dt(par défaut), d affiche seulement la date, année0 est la première année, année1 la dernière",
"Deactivate login autocomplete (do not remember login and password)" => "Désactiver le renseignement automatique du login (ne pas se souvenir du login et du mot de passe)",
"Debugger console" => "Console de debug",
"debugger console" => "console de débug",
"Dec" => "déc.",
"Default background color" => "Couleur de fond par défaut",
"Default Dimensions" => "Dimensions par défaut",
"Default group: " => "Groupe par défaut: ",
"Default Language" => "Langue choisie par défaut ",
"Default number of rows (comments)" => "Nombre de lignes par défaut (commentaires)",
"Default number of rows (forum)" => "Nombre de lignes par défaut (forum)",
"Default number of rows (forum replies)" => "Nombre de lignes par défaut (réponses de forum)",
"Default number of rows (wiki)" => "Nombre de lignes par défaut (wiki)",
"Default ordering for blog listing" => "Ordre par défaut d'affichage des blogues",
"Default thread sort mode" => "Tri par défaut des articles",
"Default thread style" => "Style par défaut du fil",
"Default value is specified by having the value indicated twice consecutively" => "La valeur par défaut est spécifiée en indiquant la valeur 2 fois de suite consécutivement",
"deleted" => "barré",
"delete entry" => "supprimer l'entrée",
"Delete this type" => "Supprimer ce type",
"Delete those pages" => "Détruire ces pages",
"Description text is tiki-parsed" => "Analyser le texte comme un format wiki",
"Description text is wiki-parsed" => "Analyser le texte comme un format wiki",
"Detect user timezone (if browser allows). Otherwise use site default" => "Détecter le fuseau horaire (si le navigateur le permet). Sinon utiliser celui du site par défaut",
"Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Etes-vous allé au terme du <a href='tiki-install.php' >Tiki Installer",
"Diff style" => "Style du Diff",
"Dimensions" => "Dimensions",
"directory admin related tpl" => "gabarit de l'administration des répertoires en relation",
"Directory batch" => "Téléchargement serveur",
"directory validate sites tpl" => "gabarit de l'administration des sites validés",
"DirMenu" => "Cliquer pour voir le sous-menu",
"disable" => "désactivé",
"Disable the installation script and enter TikiWiki" => "Désactiver les scripts d'installation et entrer dans TikiWiki",
"Disallow access to the site (except for those with permission)" => "Refuser l'accès au site (sauf pour les utilisateurs ayant le droit \"tiki_p_access_closed_site\")",
"Disallow access when load is above the threshold (except for those with permission)" => "Refuser l'accès au site quand la charge est au-dessus du seuil (sauf pour les utilisateurs ayant le droit \"tiki_p_access_closed_site\")",
"Display an image" => "Afficher une image",
"Display Available Translations" => "Afficher les Traductions Disponibles",
"Display details" => "Afficher les détails",
"Displays a countdown from now until the specified date" => "Affiche un compte à rebours de maintenant jusqu'à la date spécifiée",
"Displays a list of files" => "Afficher une liste de fichiers",
"displays an image" => "pour afficher une image;",
"Displays an miniquiz" => "Affiche un mini QCM",
"displays rss feed with id=n maximum=m items" => "pour afficher le canal de syndication RSS d'identifiant n avec m items au maximum",
"Displays user's contribution in the user information page" => "Afficher les contributions de l'utilisateur dans sa page d'information",
"Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Affiche les informations du formulaire utilisateur dans la page d'information d'un utilisateur. Format: IdFormulaire, IdChamp1, IdChamp2, …",
"Displays various information about the client" => "Affiche diverses informations à propos du client",
"Display thread configuration bar to override defaults" => "Afficher la barre de configuration de l'affichage pour pouvoir modifier les paramètres par défaut",
"Do nothing and enter Tiki" => "Ne faire rien et entrer dans Tiki",
"Do not use your browser's Back button." => "Ne pas utiliser le bouton 'Retour' de votre navigateur.",
"Dropdown options: list of items separated with commas." => "Liste déroulante&nbsp;: liste des éléments séparés par des virgules",
"dump" => "fichier-dump",
"Dump" => "Fichier-dump",
"Duplicate to" => "Dupliquer dans",
"During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "Lors d'une mise à jour, il est normal d'avoir des échecs SQL dont le message inclus '<strong>Table already exists</strong>'",
"Dynamic content" => "Contenu dynamique",
"dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "Options de la liste dynamique&nbsp;: IdFormulaire, ChampFiltreLàBas, ChampFiltreIci, ChampListéLàBas, statutLàBas - Insère les éléments de ChampListéLàbas du formulaire IdFormulaire si ChampFiltreLàBas correspond à ChampFiltreIci et le statut est statutLàBas",
"Each user in the file must already exist" => "Chaque utilisateur du fichier doit déjà exister",
"Edit Article" => "Modifier un article",
"Edit Article Tpl" => "Modifier le gabarit de l'article",
"Edit Blog Tpl" => "Gabarit de la modification des blogues",
"Edit Contribution" => "Modifier la contribution",
"Edit idle timeout" => "Modifier le timeout d'inactivité",
"Edit languages" => "Modifier une langue",
"Edit mail account" => "Modifier le compte mail",
"Edit mapfiles" => "Modifier les fichiers-carte",
"Edit Quiz Questions" => "Modifier les questions du QCM",
"Edit Quiz Questions Tpl" => "Modifier le gabarit de la modification des QCMs",
"Edit Quiz Stats Tpl" => "Modifier le gabarit de la liste des formulaires",
"Edit Submissions Tpl" => "Gabarit de la modification des soumissions",
"Edit Summary" => "Résumé de la modification",
"Edit survey questions" => "Modifier les questions d'une enquête",
"EditTemplates" => "Modifier les gabarits",
"EditTemplates tpl" => "gabarit de la modification des gabarits",
"Edit this RSS module" => "Modifier ce module RSS",
"Edit Translations" => "Modifier les traductions",
"Edit Translations Template" => "Gabarit de la modification de traductions",
"Edit User Contacts Preferences" => "Modifier les préférences contacts utilisateur",
"Edit User Files" => "Modifier les fichiers utilisateur",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Options pour l'adresse électronique&nbsp;: 0|1|2 où 0 affiche l'adresse en texte plein, 1 affiche le lien en hexadécimal (Plus protégé contre le spam et les robots web) et 2 fait le href mailto normal.",
"Email address to send test to" => "Destinataire du test",
"EMail notifications" => "Notification par email",
"Email sent by your site will use this address" => "Les e-mails envoyés par votre site utiliseront cette adresse",
"Enable auto indexing on file upload or change" => "Permettre l'indexation automatique à l'envoi ou changement de fichier",
"Enable Feature for Articles" => "Active le copyright pour les articles",
"Enable Feature for Blogues" => "Active le copyright pour les blogues",
"Enable Feature for Faqs" => "Active le copyright pour les FAQs",
"Enable Feature for Wiki" => "Active le copyright pour les pages wiki",
"Enable now." => "Activer maintenant.",
"Enable topics archiving" => "Activer l'archivage des sujets",
"Enter a database user with administrator permission for the Database" => "Entrez un nom d'utilisateur de la base de données ayant des droits d'administration pour la base de données",
"Entering TikiWiki" => "Entrer dans TikiWiki",
"Enter the host name or IP for your database" => "Donnez l'adresse Internet ou l'IP de votre base de données",
"Enter the name of the database that Tiki will use" => "Entrez le nom de la base de données que Tiki va utiliser",
"Enter Tiki" => "Accéder à Tiki",
"Enter TikiWiki <em>without</em> disabling the installation script" => "Entrer dans TikiWiki <em>sans</em> désactiver les scripts d'installation",
"Enter your database connection information" => "Entrez les informations pour se connecter à la base de données",
"Enter your email" => "Donner votre adresse mail",
"Enter your TNS Name here and leave Host empty" => "Entrez votre nom 'TNS' à cet endroit et laissez le champ 'Adresse Internet' vide",
"Ephemerides Admin" => "Administrer les éphémérides",
"Ephemerides" => "Éphémérides",
"EphMenu" => "Cliquer pour voir le sous-menu",
"equals" => "signes égal",
"error" => "erreur",
"Expire Date" => "Date d'expiration",
"External link icons" => "Icône pour un lien externe",
"External wikis" => "Wikis externes",
"Extra Stuff &amp; Fun" => "Spécial &amp; Fun",
"Faq Stats" => "Statistiques sur les FAQs",
"Favorites" => "Préférés",
"Feature documentation links" => "Liens vers la documentation des fonctionnalités",
"Feb" => "févr.",
"fields marked with a * are mandatory" => "les champs marqués par une * sont obligatoires",
"Fields to display on page" => "Champs à afficher sur la page",
"File author" => "Auteur du fichier",
"File galleries comments settings" => "Configuration des commentaires de galeries de fichiers",
"File galleries search indexing" => "Indexation des galeries de fichiers",
"FileGalMenu" => "Cliquer pour voir le sous-menu",
"File is not an image" => "Le fichier n'est pas une image",
"{|} Files Attached" => "{|} Fichiers attachés",
"File Title" => "Titre du fichier",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Seuls les fichiers avec un nom se terminant par -{\$user} sont modifiables. Les autres sont seulement duplicables et peuvent être utilisés comme modèle.",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filtrer la liste des pages voulues selon l'expression régulière ou le filtre local. La valeur par defaut est __current__ page_regex.<br />",
"Find term" => "Chercher un terme",
"First year in the dropdown, either year number, or relative to current year (+/- N)" => "Première année dans les listes déroulantes, sinon le nombre d'années, ou relativement à l'année courante (+/- N)",
"flagged" => "avec drapeau",
"Flash player not available" => "Le lecteur Flash n'est pas disponible",
"Font family to use" => "Famille de police à utiliser",
"Force immediate check" => "Forcer un contrôle immédiat",
"Force lowercase username" => "Forcer le nom d'utilisateur en minuscules",
"Force to use chars and nums in passwords" => "Obliger d'utiliser caractères et numériques dans un mot de passe",
"ForMenu" => "Cliquer pour voir le sous-menu",
"For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "Pour plus d'informations, veuillez visiter <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>",
"Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formule de calcul, utilisez # pour indiquer un champ et +,*,/,- ainsi que des parenthèses pour les opérations.",
"Formula" => "Formule",
"For not registered author" => "Pour auteurs non enregistrés",
"For Oracle" => "Pour Oracle",
"For" => "Pour",
"For SQLite, enter the path and filename to your database file" => "Pour SQLite, entrez le chemin et le nom de fichier de votre base de données",
"Forum for discussion" => "Forum pour les discussions",
"Forum listing configuration" => "Configuration de l'affichage des forums",
"Forum quick jumps" => "Aller directement au forum",
"Forums features" => "Fonctionnalités des forums",
"forward" => "transférer",
"Freetag 3D Browser Configuration" => "Configuration du navigateur de mots-clés 3D",
"Freetag Browsing" => "Parcourir les freetags",
"Freetags are disabled" => "Mots-clés désactivés",
"Freetags rock!" => "Freetags est super !",
"FriendsMenu" => "MenuAmis",
"friends tpl" => "Gabarit Amis",
"full headers" => "en-têtes complets",
"Full Path to the Zip File" => "Chemin complet de l'archive ZIP",
"galleries tpl" => "gabarit des galeries d'images",
"GalMenu" => "Cliquer pour voir le sous-menu",
"games tpl" => "gabarit jeu",
"Generate a\tpassword" => "Générer un\t mot de passe",
"Geourl" => "Geourl",
"Go back and run another install/upgrade script" => "Relancer le script d'installation et de mise à jour",
"Go directly to the <strong>Install/Upgrade</strong> step" => "Allez directement à l'étape <strong>Installer/Mettre à jour</strong>",
"Group calendar item view tab" => "Onglet vue d'un item pour le calendrier de groupe",
"Group calendar sticky popup" => "Popups des calendriers de groupe collante",
"Group Selector: use options for automatic field feeding&nbsp;: you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Sélection de groupe: Vous pouvez utiliser 1 pour le groupe de création et 2 pour le groupe de modification. Le groupe par défaut est utilisé par cette option et s'il n'est pas fixé le premier groupe trouvé pour l'utilisateur sera utilisé.",
"Half a second" => "Demi-seconde",
"Handle multilingual freetags" => "Gérer les freetags multilingues",
"heading2" => "Titre 2",
"heading3" => "Titre 3",
"height width desc link and align are optional" => "la hauteur, la largeur et la description du lien sont optionnelles",
"Help for Assigning Permissions" => "Aide pour attribuer des droits d'accès",
"Help on Articles" => "Aide sur les articles",
"Help on Banning System" => "Aide sur le système de bannières",
"Help on Communication Center" => "Aide sur le Centre de communication",
"Help on Drawings" => "Aide sur les dessins",
"Help on Dynamic Content" => "Aide sur le contenu dynamique",
"Help System (Feature documentation links)" => "Système d'aide (Liens vers la documentation des fontionnalités)",
"Hide Categories" => "Masquer les catégories",
"Highlight Group" => "Style appliqué aux noms d'utilisateur d'un groupe",
"hist" => "hist",
"History only for data, description, comment change" => "Historique seulement pour changement de contenu, description ou commentaire",
"%H:%M:%S %Z" => "%Hh%M",
"Hold down CTRL to select multiple categories" => "Maintenir la touche CTRL appuyée pour une sélection multiple",
"Home Forum" => "Accueil-Forum",
"home" => "page d'accueil",
"Homework" => "Devoirs",
"Host name" => "Adresse Internet",
"Hotwords in New Windows" => "Mot/liens automatiques dans une nouvelle fenêtre",
"hr" => "hr",
"HTTPS login" => "Connexion HTTPS",
"I18n setup" => "Configuration I18n",
"if no jscalendar" => "Si jscalendar non activé",
"I forgot my pass" => "J'ai oublié mon mot de passe",
"If not found, you will be given a chance to create it" => "Si le terme n'est pas trouvé, on vous donnera l'occasion de le créer",
"If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "Si ceci est votre première installation, ouvrez la page <strong>tiki-admin.php</strong> après connexion pour démarrer la configuration de votre Tiki",
"If your host requires SMTP authentication, additional configuration may be necessary" => "Si votre serveur nécessite une authentification SMTP, une configuration additionnelle peut s'avérer nécessaire",
"I have canceled my friendship request" => "J'ai annulé la demande de mise en relation",
"Image annotations changed" => "Les annotations sur l'image ont été modifiées",
"Image description." => "Description de l'image.",
"Image Gallery tpl" => "gabarit des galeries d'images",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Options pour image&nbsp;: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indiqués en pixels.",
"Image (url)" => "Image (url)",
"Im- Export Languages" => "Langues Im/Export",
"Important Information" => "Information importante",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"Import Page" => "Importer une page",
"Impossible to render the graphic." => "Impossible de générer le graphique.",
"Inserts a list of articles in the page" => "Inclut une liste d'articles dans la page",
"Includes content from the dynamic content system" => "Inclure le contenu provenant des contenues dynamiques",
"Includes the list of events from a calendar in the page" => "Inclure dans la page la liste des évènements d'un calendrier",
"In pixels or percentage. Default value is 100%" => "En pixels ou en pourcentage. La valeur par défaut est 100%",
"Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Insère une ancre dans une page wiki. Les liens vers les ancres peuvent être créés avec le plugin ALINK",
"Installation operations executed successfully" => "Opérations d'installation executées avec succès",
"In the same directory, include an icon for the opened folder" => "Dans le même répertoire, placer un fichier icône pour un répertoire ouvert",
"Invalid password.  Your current password is required to change administrative information" => "Mot de passe invalide. Votre mot de passe courant est nécessaire pour modifier les informations de votre compte",
"IP address displayed in history" => "L'adresse IP est affichée dans l'historique",
"IP Selector: use options for automatic field feeding&nbsp;: you can use 1 for author IP or 2 for modificator IP." => "Sélection de l'IP&nbsp;: mettre un eoption pour une sélection automatique&nbsp;: 1 pour l'IP du créateur ou 2 pour l'IP de l 'éditeur.",
"IRC log" => "log IRC",
"Isle_of_Man" => "Île de Man",
"Is your database up and running" => "Votre base de données est-elle en fonctionnement",
"italic" => "italique",
"item found" => "fiche trouvée",
"Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Options pour un lien de fiche&nbsp;: IdFormulaire,IdChamp,lienVersFiche,IdChamps - lien vers la fiche du formailre IdFormulaire dont fieldId correspond au contenu de ce champ, lienVersFiche 1|0 pour créer un lien vers le champ en mode vue ou liste, IdChamps pour remplacer IdChamps par une liste de champs séparés par |",
"items found" => "fiches trouvées",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Options pour la liste des fiches&nbsp;: IdFormulaire, IdChampLa, IdChampIci, IdChampAffichéLa, lienVersFiches affiche la liste des IdChampAffichéLa de la fiche dans le formulaire IdFormulaire où IdChampLa correspond à IdChampIci. LiensVersFiches 1|0 pour créer un lien vers les fiches en vue modification ou liste",
"Jan" => "janv.",
"Javascript filename" => "Nom du fichier Javascript",
"Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Options de Jscalendar&nbsp;: date_heure où date_heure=d|dt(par défaut), d affiche seulement la date",
"Jul" => "juill.",
"Jun" => "juin",
"Just use Tiki auth for admin?" => "Utiliser uniquement l'authentification Tiki pour l'administrateur?",
"Label displayed on the left side of the gauge" => "Etiquette sur le côté gauche de la jauge",
"Language: " => "Langue&nbsp;: ",
"Last modifications to the blog" => "Dernières modifications du blog",
"Last modification time" => "Dernière modif.",
"Last update from CVS" => "Dernière mise à jour CVS",
"Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Derniêre année dans les listes déroulantes, sinon le nombre d'années, ou relativement à l'année courante (+/- N)",
"Layer Management" => "Gestion des layers",
"LDAP Admin Pwd" => "Administrer les mots de passe LDAP",
"LDAP Admin User" => "Administrer les utilisateurs LDAP",
"LDAP Base DN" => "DN LDAP de la base",
"LDAP Group Attribute" => "Attribut LDAP du groupe",
"LDAP Group DN" => "DN LDAP du groupe",
"LDAP Group OC" => "OC LDAP d'un groupe",
"LDAP Host" => "Hôte LDAP",
"LDAP Member Attribute" => "Attribut LDAP d'un membre",
"LDAP Member Is DN" => "Attribut LDAP d'un membre est un DN",
"LDAP Port" => "Port LDAP",
"LDAP Realname Attribute" => "Attribut LDAP Realname",
"LDAP Scope" => "Scope LDAP",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "URL LDAP<br />Si positionné, écrasera le port et le hôte ci-dessous",
"LDAP User Attribute" => "Attribut LDAP d'un utilisateur",
"LDAP User DN" => "DN LDAP d'un utilisateur",
"LDAP User OC" => "OC LDAP d'un utilisateur",
"LDAP Version" => "Version LDAP",
"Leave box empty for deleting an option" => "Laisser la boite vide pour supprimer une option",
"Leave command blank to delete handler" => "Laisser la commande à blanc pour détruire l'association",
"Leave this empty" => "Laisser vide",
"left|right, for box with width less than 100%, make text wrap around the box" => "gauche|droite, pour les boites avec une largeur inférieure à 100%, placer le texte autour de la boite",
"left/right" => "gauche/droite",
"level configuration" => "configuration du niveau",
"License Page" => "Page de la licence",
"link, external" => "lien externe",
"Link to" => "Lien vers",
"link, wiki" => "lien wiki",
"List all pages linking to the specified page" => "Liste de toutes les pages ayant un lien vers la page spécifiée",
"List Articles Tpl" => "Gabarit des listes des articles",
"list bullets" => "liste à puces",
"List displayed by default" => "Liste affichée par défaut",
"List FAQs Tpl" => "Gabarit des listes de FAQs",
"list numbers" => "liste numérotée",
"List of colors to use" => "Liste de couleurs à utiliser",
"List of styles to use" => "Liste des styles à utiliser",
"List orphan pages" => "Liste les pages orphelines",
"List Posts Tpl" => "Gabarit des listes de publications",
"List quizzes" => "Liste des QCMs",
"List Quizzes Tpl" => "Gabarit de la liste de QCMs",
"List TikiSheets" => "Liste des feuillets",
"List trackers" => "Liste des formulaires",
"List Trackers Tpl" => "Gabarit de la liste des formulaires",
"listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listview=nst, n pour voir le nom / t pour voir le type / s pour voir le type / u pour voir l'utilisateur en mode liste",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\" et \"{literal}{maketoc}{/literal}\" affichent la table des matières de la page courante basée sur les structures (toc) ou sur les en-têtes (maketoc)",
"Locations separator" => "Séparateur de fils d'Ariane",
"Log Mail in Tiki Logs" => "Journaliser les mails dans les Tiki Logs",
"mailbox" => "boîte à lettre",
"make autonumbered headings" => "faire des en-têtes autonumérotées",
"make headings" => "faire des en-têtes",
"makes a horizontal rule" => "pour une règle horizontale",
"mark" => "marquer",
"Mar" => "mars",
"Max average server load threshold in the last minute" => "Moyenne maximale de la charge du serveur dans la dernière minute",
"Maximum amount of downloads" => "Le nombre maximum de téléchargement",
"Maximum number of entries to list" => "Nombre maximum amount d'entrées dans la liste",
"Maximum number of levels to display. On very large structures, this should be limited" => "Nombre Maximum de niveaux à afficher. Pour des structures très importantes, ceci devrait être limité",
"Maximum amount of results displayed" => "Nombre maximum de résultats affichés",
"Maximum file size is limited to" => "La taille maximum d'un fichier est limitée à",
"Maximum number of articles in home" => "Nombre maximal d'articles dans l'accueil",
"Maximum number of versions for history" => "Nombre maximum de versions dans l'historique",
"Maximum number of versions" => "Nombre maximum de versions",
"Maximum username length" => "Longueur maximale d'un nom d'utilisateur",
"Maybe You just want to modify the top of your Tiki site" => "Peut-être ne voulez vous modifier que la partie haute de votre site Tiki",
"Member list" => "Liste des membres",
"merge selected notes into" => "fusionner les notes sélectionnées dans",
"Message Broadcast" => "Diffusion du message",
"Message queue for" => "Messages en attente sur",
"Message to display when server is too busy" => "Message à afficher quand le serveur est trop chargé",
"Message to display when site is closed" => "Message à afficher quand le site est fermé",
"Meta Author" => "Méta auteur",
"Meta Description" => "Méta description",
"Meta Keywords" => "Méta mots clés",
"meta robots" => "méta robots",
"Mini calendar" => "Mon calendrier",
"Minimum password length" => "Longueur minimum d'un mot de passe",
"Minimum username length" => "Longueur minimale d'un nom d'utilisateur",
"Minor Edit" => "Modif. mineure",
"Minor edits do not flag new content for translation and do not send watch notifications" => "Les modifications mineures ne marque pas le nouveau contenu pour traduction et n'envoi pas notification de surveillance",
"Minor" => "Mineur",
"Misc" => "Divers",
"Missing parameter on page. objectId and objectType required." => "Paramètre manquant. objectId et objectType sont obligatoires.",
"Missing title or body when trying to post a comment" => "Titre ou contenu manquant pour publier un commentaire",
"Modify" => "Modifier",
"Mods Admin" => "Administrer les Mods",
"module decides" => "le module décide",
"More Links" => "Liens supplémentaires",
"Msg" => "Msg",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Les éléments récupérés multiples sont séparés dans des rangées distinctes, ou par virgule ou retour à la ligne dans une même cellule.<br />",
"Multiple values separated with | can be used" => "Vous pouvez saisir plusieurs valeur séparé par un |",
"MultiTiki setup" => "Configuration MultiTiki",
"My Files" => "Mes fichiers",
"MyMenu" => "Cliquer pour voir le sous-menu",
"Mypages Types" => "Types mesPages",
"mypage type unaivalable" => "type mesPages non trouvé",
"MyTiki Home" => "Accueil-MonTiki",
"my tiki tpl" => "gabarit MonTiki",
"name already exists" => "le nom existe déjà",
"Name is empty" => "Le nom est vide",
"Name length" => "Longueur du nom",
"Name of the drawing to display" => "Nom du dessin à afficher",
"Never delete versions younger than days" => "Ne jamais effacer des versions datant de moins de (jours)",
"New Article" => "Nouvel article",
"New article post at %s" => "Nouvel article publié sur %s",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nouvel article publié&nbsp;: {\$mail_title} par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"new calendar events" => "nouveaux évènements du calendrier",
"new sites" => "nouveaux sites",
"Newsletter subscription information at " => "Abonnement à une lettre d'informations sur ",
"new submissions" => "nouvelles soumissions",
"No articles." => "Pas d'articles.",
"No articles yet" => "Aucun article",
"No DSN connection string found" => "Il n'y pas de chaine de connexion DSN",
"No formula specified." => "Aucune formule spécifiée.",
"No gallery available" => "Pas de galerie disponible",
"No language is assigned to this page" => "Aucune langue n'est assignée à cette page",
"Non cacheable images" => "Images hors antémémoire",
"No occurences found" => "Aucune occurence trouvée",
"No page provided" => "Aucune page fournie",
"normal headers" => "en-têtes normaux",
"No scripts available." => "Aucun script disponible.",
"No specific permission" => "Pas de permission spécifique",
"No templates" => "Pas de gabarit",
"Note: This feature also requires PHPLayers to be turned on in " => "Remarque&nbsp;: cette fonctionnalité nécessite que la fonctionnalité PHPLayers soit activée dans ",
"Not your password" => "Pas votre mot de passe",
"Nov" => "nov.",
"~np~{~/np~EVENTS(calendarid=>1,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=>1,maxdays=>365,max=>-1,datetime=>0|1,desc=>0|1)}{EVENTS} Insère la syndication RSS dans une page Wiki",
"Number of lines" => "Nombre de lignes",
"Number of required answers (for multiple choices)" => "Nombre de réponses requises (pour les questions à choix multiples)",
"Number of Tags to show in Cloud" => "Nombre de mots-clés à afficher dans le nuage",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numérique: 1,taille,préfixe,suffixe la taille est en caractères, le préfixe et le suffixe entourent le champ, et le 1 initial indique que la prochaine colonne doit se trouver sur la même rangée.",
"Oct" => "oct.",
"One carat" => "Un caractère",
"One entry per line. Each line is in \"Term: Definition\" format" => "Une définition par ligne. Chaque ligne formattée de la manière suivante \"Term: Definition\"",
"Only accept alphanumeric ASCII freetags (no accents or special chars)" => "N'accepter que des mots-clés alphanumériques ASCII (pas d'accents ou de caractères spéciaux)",
"Only accept lowercase freetags" => "N'accepter les freetags qu'en minuscule",
"(Only .gif images, and aproximately 45px x 45px)" => "(Seulement les images .gif, et approximativement 45px x 45px)",
"Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Seul les groupes ayant le privilège tiki_p_minor (et l'admin) seront en mesure de sauvegarder des versions mineures lorsque celle-ci est activée",
"OpenID" => "OpenID",
"Operations failed" => "Opérations ayant échouées",
"Ordering for forums in the forum listing" => "Ordre des forums dans la liste",
"or list of fields separated by comma" => "ou liste de champs séparés par une virgule",
"orphan pages" => "pages orphelines",
"OS" => "Système d'exploitation",
"Other Options" => "Autres options",
"output compression is active." => "compression en sortie activée.",
"Output compression is active" => "La compression des pages est activée",
"Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Remplacez tnsnames.ora et entrez votre SID à cet endroit, puis votre 'hostname:port' dans le champ 'Adresse Internet'",
"Page description, icons, backlinks, .." => "Description de la page, icônes, liens, ..",
"Page generated in" => "Page générée en",
"Page is a staging copy. Translation must begin from the approved copy" => "La page est en cours de validation. La traduction ne peut commencer qu'à partir du page validée",
"Page IS being monitored. Click icon to STOP monitoring." => "Cette page EST sous surveillance. Cliquer sur l'icône pour ARRËTER de la surveiller.",
"Page is NOT being monitored. Click icon to START monitoring." => "Cette page n'est PAS sous surveillance. Cliquer sur l'icône pour commencer à la surveiller.",
"Page navigation bar position (displayed when page break '...page...' are used)" => "Position de la barre de navigation (affichée lorsque le saut de page '...page...' est utilisé)",
"Page saved (version %d)" => "Page sauvegardée (version %d)",
"Paramaters" => "Paramètres",
"Parameter not found" => "Paramètre non trouvé",
"Parentheses are used to group words into subexpressions" => "Les parenthèses sont utilisés pour grouper des mots en sous-expressions",
"Parse" => "Analyser",
"Parse the result (can be slow)" => "Analyser le résultat (peut être lent)",
"pass" => "mot de passe",
"Pass" => "Mot de passe ",
"Password invalid after days" => "Mot de passe invalide après (en jours)",
"PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "Les extensions PECL HTTP et cURL ne sont pas présente. Il sera impossible de rejouer les TikiTest",
"Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Pourcentage d'agrandissement de la taille normale. 100 représente la taille par défaut. 200 représente une image doublée",
"Perform action with selected" => "Réaliser l'action avec le ou les éléments sélectionnés",
"Performance issues" => "Améliorations de performance",
"Permission assigned to the group" => "Permission assignée au groupe",
"Permission assigned to the group through a category" => "Permission assignée au group via une catégorie",
"Permission denied you cannot remove pages" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas détruire de pages",
"Phillippines" => "Philippines",
"Php GD library required" => "Bibliothèque PHP GD obligatoire",
"PHP version" => "Version PHP",
"Please change your title or content then click Post." => "Veuillez changer le titre ou le contenu avant de publier à nouveau.",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Veuillez cliquer sur le lien suivant pour confirmer que votre désir de réinitialiser votre mot de passe puis allez sur l'écran où vous devrez saisir un nouveau mot de passe \"permanent\". Veuillez choisir un mot de passe dont vous vous souviendrez et ne le partagez avec personne.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nFait ! Vous devriez être connecté.",
"Please expect not found help-pages with the default-URL." => "SVP, attendez vous à des pages non trouvées avec l'URL par défaut.",
"Please login with your admin password to continue" => "Veuillez vous connecter avec votre mot de passe admin pour poursuivre",
"Please read the following license agreement" => "Veuillez consulter la licence suivante",
"Please read the following notes before entering Tikiwiki." => "Merci de lire les notes suivantes avant d'entrer dans Tikiwiki.",
"Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Veuillez voir <a href=\"http://doc.tikiwiki.org/\">la documentation</a> pour plus d'informations",
"Please select a language before performing translation" => "Merci de sélectionner une langue avant de traduire",
"Please wait 2 minutes between posts" => "SVP respectez un délai de 2 minutes entre chaque publication",
"Please wait.." => "Attendez, SVP",
"Plugin Help" => "Aide Plugin",
"PodCast directory (must be web accessible)" => "Répertoire de podcast (doit être accessible depuis le web)",
"posted by" => "publié par",
"Post level comments" => "Commentaires au niveau article",
"\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ ddonnées ~/pp~\" Affiche du texte préformatté. Aucun traitement wiki n'est appliqué à l'intérieur de ces sections (comme pour le tag np). L'espacement est fixe (les mots ne sont pas agrégés). \"~pre~ données ~/pre~\" affiche également du texte préformatté à taille fixe, mais le traitement wiki est appliqué.",
"Preference syntax" => "Syntaxe des préférences",
"Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Recherche aléatoire sur un tag en arrivant sur la <a href=\"tiki-browse_freetags.php\">page de recherche de freetags</a>",
"Prevent automatic/robot registration" => "Empêcher l'enregistrement automatique par des robots",
"Print article" => "Imprimer un article",
"Print Page" => "Impression de page",
"Profile list" => "Liste des Profils",
"Profiles can be used to pre-configure your site with specific features and settings" => "Les profils peuvent être utilisés pour pré-configurer votre site avec des paramètres et des fonctionnalités spécifiques",
"Program dynamic content for block" => "Programmer le contenu dynamique pour le bloc",
"Protect against CSRF with a confirmation step" => "Protéger contre CSRF avec une étape de confirmation",
"Proxy Host" => "IP du serveur proxy",
"Quick edit a Wiki page" => "Créer/modifier une page Wiki",
"Quicktag" => "Raccourci",
"QuizMenu" => "Cliquer pour voir le sous-menu",
"Radio buttons options: list of items separated with commas." => "Options des boutons radio&nbsp;: liste des valeurs séparées par des virgules.",
"Random tag cloud colors (separated by comma)" => "Couleurs des éléments du nuage choisies au hasard(liste séparée par des virgules)",
"rankings" => "classements",
"Read &amp; write" => "Lecture &amp; Écriture",
"read more" => "en lire plus",
"Received Articles" => "Articles reçus",
"received articles tpl" => "gabarit des articles reçus",
"received pages" => "pages reçues",
"Received pages" => "Pages reçues",
"received pages tpl" => "gabarit des pages reçues",
"Redirect the user to a wiki page or generic URL" => "Redirige l'utilisateur vers une page wiki ou une URL générique",
"Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Référez-vous à la <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> pour une information complète concernant ces paramètres (ou tout autre paramètre)",
"Reg users can change language" => "Les utilisateurs inscrits peuvent changer de langue",
"Reg users can change password" => "Les utilisateurs inscrits peuvent changer de mot de passe",
"Reinstall database." => "Réinstaller une base de données.",
"Release check" => "Contrôle de version",
"Release checks are made when you browse admin main page only" => "Les contrôles de version ne se font que lorsque vous naviguez sur la page d'administration principale",
"Remaining" => "Restant",
"Remember me domain" => "Domaine du cookie Mémorisez-moi",
"Remember me feature" => "Fonctionnalité \"Mémorisez moi\"",
"Remember me name" => "Mémorisez-moi",
"Remember me path" => "Chemin du cookie Mémorisez-moi",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Rappel de mot de passe par email (si \"Sauvegarder les mots de passe en texte plein\" est activé.) Sinon, Réinitialisation de votre mot de passe par email",
"Removal of your email address failed" => "Suppression de votre email échouée",
"Remove a Tag" => "Retirer un marqueur",
"Rename page" => "Renommer la page",
"reply all" => "répondre à tous",
"Reply posts are empty" => "Ne pas mettre de citation dans les réponses",
"Reported messages for" => "Messages signalés dans",
"Report to the Webmaster" => "Signaler à l'administrateur du site",
"Republic_of_Serbia" => "République de Serbie",
"Request passcode to register" => "Exiger un passcode pour s'inscrire",
"Request" => "Requête",
"Required for all the following features" => "Nécessaire pour toutes les fonctionalités suivantes",
"Reset database connection settings" => "Réinitialiser les paramètres de connexion base de données",
"Reset view to site-wide default" => "Réinitialiser la vue au défaut du site",
"Restart the installer" => "Redémarrer l'installateur",
"restore" => "restaurer",
"Restore the Wiki" => "Restaurer le Wiki",
"Restrict available languages" => "Limiter les langues disponibles",
"Return to HomePage" => "Retourner à la PageAccueil",
"return to wikipage" => "retourner à la page Wiki",
"Re-validate user by email after days" => "Demander aux utilisateurs de se confirmer par courrier électronique après x jours",
"Re-validate user by email after unsuccessful logins" => "Demander à l'utilisateur de se valider par courriel après x logins non réussis",
"Review Installation" => "Vérifier l'installation",
"Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => " Vérifiez la configuration email dans <strong>php.ini</strong> file (par exemple : vérifiez que le chemin d'accès à <strong>sendmail_path</strong> est correct)",
"Review Upgrade" => "Vérifier la mise à jour",
"Review your mail log for details" => "Vérifiez vos logs de mail pour plus de détails",
"revisit after" => "revisiter après",
"Right &amp; left boxes" => "Boîtes gauches &amp; droites",
"RSS Trackers" => "Canal de syndication RSS pour les formulaires",
"Russian Federation" => "Fédération de Russie",
"Sample plugin" => "Plugin modèle",
"sandbox" => "bac à sable",
"Score System" => "Système de score",
"Search features" => "Fonctionnalités de la recherche",
"Search in topics content on forum page (needs feature_search activated)" => "Rechercher dans le contenu des forums sur les pages des forums (nécessite l'activation de feature_search)",
"Search may show forbidden results. Much better performance though." => "La recherche peut montrer des résultats interdits. Les performances sont meilleures cependant",
"Search refresh mode" => "Mode d'indexation des données",
"Search refresh rate" => "Fréquence de réactualisation de la recherche",
"Search some forums by content on \"forum list\" (needs feature_search activated)" => "Trouver des forums par le contenu dans la liste des forums (nécessite l'activation de feature_search)",
"Search some forums by name (on \"forum list\")" => "Rechercher des forums par leur nom (sur la liste des forums)",
"SearchStats" => "Statistiques des recherches",
"search stats tpl" => "gabarit des statistiques des recherches",
"seconds (0 = cache inactive)" => "secondes (0 = pas de cache)",
"second" => "seconde",
"security admin" => "administrer la sécurité",
"security admin tpl" => "gabarit de l'administration de la sécurité",
"See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "Consultez la documentation pour <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description des profils disponibles.\">les descriptions des profils disponibles",
"select from address book" => "sélectionner du carnet d'adresses",
"Select the installation" => "Choisissez l'installation",
"Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Choisissez le profil d'installation (ou de mise à jour) à utiliser. Ce profil va peupler (ou mettre à jour) la base de données",
"Select the installation profile to use. This profile will populate the database" => "Choisissez le profil d'installation à utiliser. Ce profil va peupler la base de données",
"Select the type of database to use with Tiki" => "Selectionnez le type de base de données à utiliser avec Tiki",
"Select your language" => "Choisissez votre langue",
"Send articles" => "Envoyer des articles",
"Sender Email" => "Adresse électronique des messages envoyés",
"sender" => "expéditeur",
"Send events" => "Envoyer des évènements",
"Send newsletters" => "Envoyer une lettre d'informations",
"Send Pages" => "Envoyer des pages",
"Send trackback pings to" => "Envoyer des pings 'je vous ai référencé'",
"sent" => "envoyé",
"Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Séparer les permissions multiples avec une virgule (,) pour une condition ET ou avec une barre verticale (|) pour un OU",
"Separate multiple permissions with a comma ( , )." => "Séparer chaque permission par avec une virgule ( , ).",
"Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Séparer les sections multiples avec une virgule (,) pour une condition ET ou avec une barre verticale (|) pour un OU",
"Separate multiple sections with a comma ( , )." => "Séparer chaque section avec une virgule ( , ).",
"Sep" => "sept.",
"Server does not support image manipulation" => "Le serveur ne permet pas la manipulation d'image",
"Session lifetime in minutes" => "Durée d'une session en minutes",
"Set Database Connection" => "es",
"settings" => "configuration",
"Settings for page articles home" => "Configuration pour la page d'accueil des articles",
"Settings for searching content" => "Configuration pour chercher le contenu",
"Share Page" => "Partager une page",
"sheets tpl" => "gabarit feuillet",
"Show Babelfish Translation Logo" => "Afficher le logo de traduction Babelfish",
"Show Babelfish Translation URLs" => "Afficher les URLs de traduction Babelfish",
"Show Categories" => "Afficher les catégories",
"Show Category Objects" => "Montrer les objets de la catégorie",
"Show Category Path" => "Montrer l'arborescence des catégories",
"Show Filters" => "Afficher les filtres",
"show help" => "afficher l'aide",
"Show/hide heading icon displayed before the heading" => "Afficher/masquer l'icône d'en-tête affichée avant l'en-tête",
"Show/Hide Left Modules" => "Afficher/Cacher les Modules gauche",
"Show/Hide Right Modules" => "Afficher/Cacher les Modules droits",
"Show Module Controls" => "Afficher les contrôles de module",
"Show page ID" => "Afficher l'ID de la page",
"Show page title" => "Afficher le titre de la page",
"Show page version" => "Montrer le numéro de version de la page",
"Show Plugins Help" => "Montrer l'aide pour les modules d'extension(plugin)",
"Show quicktags over textareas (instead on left side)" => "Afficher les raccourcis au-dessus des zones de texte (en lieu et place du coté gauche)",
"Show Tag Cloud" => "Montrer le nuage de mots-clés (Tag Cloud)",
"Show Text Formatting Rules" => "Montrer les règles de présentation du texte",
"ShtMenu" => "MenuFeuillets",
"Site Logo" => "Logo du site",
"sites" => "sites",
"Site-wide" => "Global",
"`\$slvn_info.label`" => "`\$slvn_info.label`",
"some text" => "texte",
"Sort posts by" => "Trier les articles par",
"Specify the fields that will be asked in admin->groups" => "Choix des champs qui vont être demandés dans admin->groupes",
"Spellchecking" => "Correction orthographique",
"SQL queries" => "Requêtes SQL",
"SrvMenu" => "Cliquer pour voir le sous-menu",
"Start date after end date" => "Date de début après la date de fin",
"Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Options pour texte statique&nbsp;: pour utiliser la syntaxe Wiki 1 sinon 0, maxlist est le nombre maximum de caractères affichés en mode liste.",
"Stats for quiz" => "Statistiques sur les QCMs",
"Stats for survey" => "Statistiques sur les enquêtes",
"Stats for this survey Questions " => "Statistiques sur les questions de cette enquête",
"Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Stockage des mots de passe en clair. Vous ne devriez pas activé ceci sauf si vous savez vraiment ce que vous faites",
"Store plaintext passwords" => "Sauvegarder les mots de passe en texte plein",
"String used to separate the categories in the path. Default character is >" => "Caractère utilisé pour séparer les catégories dans le chemin. Le caractère par défaut est >",
"<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Pré-visualisez</strong> ou <strong>enregistrez</strong> votre travail pour remettre à zéro le compteur d'inactivité",
"structures" => "structures",
"subject" => "sujet",
"Submit a New Link" => "Soumettre un nouveau lien",
"Submit Notice" => "Soumettre une notice",
"subscribed" => "inscrit",
"Subscribe to This Newsletter" => "S'abonner à cette lettre d'informations",
"Subscription failed" => "Souscription échouée",
"suggestions" => "suggestions",
"Support tickets" => "Tickets d'assistance",
"Switch-on debug output with details about the items.<br />" => "Activer les traces détaillées sur les items.<br />",
"Switch-on debug output with details about the items. possible values" => "Activer les traces détaillés sur les items, valeurs possibles",
"Switch-on debug output with details about the items" => "Activer les traces détaillées sur les items",
"Switch to WYSIWYG editor" => "Basculer sur l'éditeur WYSIWYG",
"Syntax highlighting" => "Mise en relief de la syntaxe",
"SysLog" => "SysLog",
"system admin" => "administration système",
"System Admin" => "Admin système",
"system admin tpl" => "gabarit de l'administration système",
"System command" => "Commande système",
"System log help" => "Aide des system log",
"system logs" => "logs du système",
"system logs tpl" => "gabarit des logs du système",
"System Requirements" => "Pré-requis",
"Tag name" => "Nom du marqueur",
"\$tailtitle" => "\$tailtitle",
"Target date. Multiple formats accepted" => "Date cible. Divers formats acceptés",
"\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Commentaire Tiki ~/tc~\" Créé un commentaire Tiki. Ce commentaire sera enregistré avec la page (pour une utilisation future) mais ne sera pas affiché. \"~hc~ Commentaire HTML ~/hc~\" Créé un commentaire HTML qui sera introduit dans la page en tant que commentaire HTML; Ces commentaires ne sont, en principe, pas affichés par les navigateurs, mais peuvent être vus en utilisant la fonction \"voir le source\" (ou assimilée).",
"Technical Features" => "Fonctionnalités techniques",
"Technical" => "Technique",
"Technology" => "Techno.",
"Test email" => "Email de Test",
"Test mode" => "Mode Test",
"Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Options de la zone de texte: quicktags,width,height,max,listmax,wordmax - Utiliser les quicktags&nbsp;: 1 ou 0, width est donné en chiffre, height est la hauteur en nombre de lignes, max est le nombre max de caractères pouvant être enregistrés, listmax est le nombre max de caractères affichés en mode liste, wordmax>0&nbsp;: alerte si le nombre de mots max est dépassé, wordmax<0 affiche le nombre de mots.",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Champ texte&nbsp;: 1, taille, préfixe, suffixe, max. - avec taille en caractères, le préfixe et le suffixe entourent le champ, max est le nombre maximal de caractères qui sera sauvegardé, et le 1 initial indique que la prochaine colonne doit se trouver sur la même rangée. Si vous indiquez seulement le 1, le champ suivant est dans la même rangée aussi.",
"Text to append to the countdown" => "Texte à ajouter au compte à rebours",
"The number of articles to display in the list" => "Nombre d'articles à afficher dans la liste",
"The anchor name as defined in the ANAME plugin" => "Le nom de l'ancre telle que définie dans le plugin ANAME",
"The article field to display. Default field is Heading" => "Champ de l'article à afficher. Champ par défaut&nbsp;: en-tête",
"The article language to list" => "Langue de l'article à lire",
"The article to display. If no value is provided, most recent article will be used" => "Article à afficher. En l'absence de valeur, affichage de l'article le plus récent",
"The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "Le plugin Wiki Bloglist est activé. Vous pouvez l'utilisze avec l'éditeur Wiki pour divulger les posts privés des blogues",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "Le plugin Wiki \"Bloglist\" est installé. Il peut révéler aux éditeurs Wiki des publications privées de blogue.",
"The character, by which ignored patterns are separated.<br />" => "Le caractère par lequel les patterns ignorés sont séparés.<br />",
" The connection failed, so check the server names" => "Connexion échouée, vérifier le nom du serveur",
"The connection was OK" => "Connexion réussie",
"The \"Contact Us\" feature is disabled" => "La fonction \"Nous contacter\" est désactivée",
"The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "La base de données doit déjà exister. Vous pouvez la créer en utilisant mysqladmin, PHPMyAdmin, cPanel, ou en demandant sa création à votre hébergeur web. En principe, les tables de Tiki n'entreront pas en conflit avec les tables d'un autre logiciel qui serait installé dans la même base de données",
"The default help system may not be complete" => "Le système par défaut d'aide n'est pas complet",
"The default installation profile will be used" => "Le profil d'installation par défaut va être utilisé",
"The feature must be activated" => "La fonctionnalité doit être activée",
"The file will be saved in" => "Le fichier sera enregistré dans",
"The following error message was returned" => "Le message d'erreur suivant a été renvoyé",
"The following list of changes has been applied" => "La liste suivante de changement a été appliquée",
"The following pages added have automatically been categorized with the same categories as the structure" => "Les pages suivantes ont été catégorisées automatiquement avec les mêmes catégories que la structure",
"the former Yugoslav Republic of Macedonia" => "l'Ex-République yougoslave de Macédoine",
"The ID of the category to list from" => "ID de la catégorie à lister",
"The ID of the topic" => "ID du sujet",
"The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "Le plugin Wiki iframe est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour les \"cross site scripting attacks\"",
"The information you enter here can be changed later" => "L'information que vous saisissez ici peut être modifiée ultérieurement",
"The installation is complete" => "L'installation est terminée",
"The installer could not connect to the Profiles repository" => "L'installeur ne parvient pas à se connecter au dépôt de profils",
"The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "Le plugin Wiki JQ est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour utiliser du code javascript vous offrant plein de possibilité",
"The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "Le plugin Wiki JS est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour utiliser du code javascript vous offrant plein de possibilité",
"The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "Le plugin Wiki Lsdir est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour afficher le contenu d'un répertoire",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "Le plugin Wiki \"Lsdir\" est installé. Il peut révéler aux éditeurs Wiki le contenu de tout répertoire.",
"Theme Control Center: categories" => "Contrôle des thèmes/catégories",
"Theme Control Center: sections" => "Contrôle des thèmes/sections",
"ThemeControl" => "Contrôle des thèmes",
"ThemeControl Objects" => "Objets du contrôle des thèmes",
"theme control objects tpl" => "gabarit des objets du contrôle des thèmes",
"theme control sections tpl" => "gabarit des sections de contrôle de thème",
"ThemeControl tpl" => "gabarit du contrôle des thèmes",
"The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "Le plugin Wiki Module est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour ajouter des modules permettant l'accès à des informations( voir la liste des modules)",
"The name of a DSN connection defined by the Wiki administrator" => "Nom de la connexion DSN définie par l'administrateur Wiki",
"The name of the anchor" => "Nom de l'ancre",
"The name of the topic" => "Nom du sujet",
"The name of the wiki page containing the anchor" => "Nom de la page wiki qui contient l'ancre",
"Then rerun the installer using tiki_1.9to1.10." => "Ensuite, relancer l;installateur avec tiki_1.9to1.10.",
"The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "Le nom du fichier icône pour le \"répertoire ouvert\" devra être identique à celui pour le \"répertoire fermé\" préfixé de la lettre <strong>o</strong>",
"The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "Le plugin Wiki Redirect est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour les \"cross site scripting attacks\"",
"The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "Le plugin Wiki Regex est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour créer n'importe quel fichier HTML avec des remplacements par expression régulière",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "Le plugin \"Regex\" est installé. Il peut être utilisé par les éditeurs Wiki pour créer n'importe quel html avec le remplacement regex",
"There was an error connecting to your e-mail account" => "Une erreur s'est produite pendant la connexion à votre compte de messagerie",
"The selected account is not associated with your identity" => "Le compte sélectionné n'est pas associé à votre identité",
"The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "Le plugin Wiki Snard est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour inclure des pages HTML de votre réseaux local et créer des pages HTML à partir d'expressions régulières",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "Le plugin \"Snarf\" est installé. Il peut être utilisé par les éditeurs Wiki pour inclure des pages du réseau local et via le remplacement regexp créer n'importe quel page html.",
"The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "Le plugin Wiki SQL est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour exécuter des commandes SQL",
"The text in RED is" => "Le texte en rouge est",
"The TikiWiki community" => "La communauté TikiWiki",
"The translation set already contains a page in this language" => "Il existe déjà une page dans pour cette traduction",
"The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "Le plugin Wiki Usercount est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour afficher le nombre d'utilisateur",
"The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "Le plugin Wiki Userlist est activé. Vous pouvez l'utiliser avec l'éditeur Wiki pour afficher la liste des utilisateurs",
"The \"users can change theme\" feature will override the theme displayed" => "Les utilisateurs peuvent changer leur thème (cette fonction outrepasse le thème par défaut)",
"The wiki page the avatar will link to" => "Page wiki vers laquelle l'avatar va pointer",
"Things to check" => "Points à contrôler",
"This installer will perform some basic checks automatically" => "Cet installeur va effectuer quelques contrôles simples automatisés",
"This is" => "",
"This is activated by default if MySQL 'Full-Text' feature is not activated above" => "Ceci est activé par défaut si la recherche 'texte intégral'n'a pas été activée",
"This is an approximation based on your server memory limit" => "Ceci est une approximation basée sur la limite mémoire du serveur",
"This is normal for a new installation" => "Ceci est normal pour une première installation",
"This is the email address for your administrator account" => "Ceci est l'adresse e-mail de l'administrateur du site",
"This module requires parameters trackerId and name set" => "Ce module requiert que trackerId et name soient positionnés",
"This plugin does not contain any arguments" => "Ce plugin ne contient aucun argument",
"This plugin's body is empty" => "Le corps de ce plugin est vide",
"This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "Ce plugin a été ajouté/modifié récemment. Son exécution ne sera pas possible avant que l'éditeur de site ne valide ces paramètres",
"This probably means you have no set limit (all is well)" => "Cela signifie sans doute qu'il n'y a pas de limite (tout va bien)",
"This site has an admin account configured" => "Ce site a déjà un utilisateur admin",
"this survey stats" => "statistiques sur cette enquête",
"This will appear in the browser title bar" => "Ceci sera affiché dans la barre de titre du navigateur",
"This will be a group mail account" => "Ce sera un compte email partagé",
"This will be a personal mail account" => "Ce sera un compte email personnel",
"This will destroy your current database" => "Cette opération va détruire votre base de données",
"This would cause you problems (e.g. menus can stop collapsing/expanding)" => "Ceci peut poser des problèmes (e.g. les menus peuvent arrêter de s'ouvrir et de se refermer)",
"Threads default preferences" => "Préférences des articles par défaut",
"tiki-admin_dsn tpl" => "gabarit de l'administration des DSNs",
"tiki admin quicktags template" => "gabarit de l'administration des raccourcis",
"Tiki cannot find a database connection" => "Tiki ne peut pas accéder à la base de données",
"Tiki community" => "communauté Tiki",
"Tiki detected" => "Tiki a détecté",
"Tiki found an existing database connection in your local.php file" => "Tiki a trouvé des informations de connexion à une base de données existante dans votre fichier local.php",
"Tiki has detected your PHP memory_limit at" => "Tiki a détecté que votre limite de mémoire PHP (memory_limit) est fixée à",
"Tiki has detected your PHP memory limit at" => "Tiki a détecté que votre mémoire PHP est limitée à ",
"Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki n'a pas pu détecter une limite de la mémoire PHP. Cela veut probablement dire que vous n'avez pas de limite ( parfait! )",
"Tiki has not detected your PHP memory_limit" => "Tiki n'a pas pu détecter votre limite mémoire PHP (memory_limit)",
"tiki-import_phpwiki tpl" => "gabarit des tiki-import_phpwiki",
"Tiki integrator" => "Integrateur Tiki",
"Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki est un projet OpenSource, <em>vous</em> pouvez <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>rejoindre la communauté</a> et aider <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>au développement de Tiki</a>",
"Tiki is software distributed under the LGPL license" => "Tiki est un logiciel distribué sous licence LGPL",
"Tiki is unable to connect to the database " => "Tiki n'est pas en mesure de se connecter à la base de données ",
"Tiki requires an active database connection" => "Tiki a besoin d'une connexion à une base de données existante",
"Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki nécessite <strong>au moins</strong> 32MB de mémoire dans la configuration PHP",
"Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki utilise la bibliothèque GD pour le traitement d'images pour les galeries ou la génération de CAPTCHAS (anti-spams)",
"Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki utilise les fonctions Mail de PHP pour envoyer des messages et des notifications",
"Tiki was able to send a test message to info@tikiwiki.org" => "Tikiki a réussi à envoyer un message à info@tikiwiki.org",
"Tiki was not able to detect the GD library" => "Tiki n'a pas réussi à détecter de bibliothèque GD",
"Tiki was not able to send a test message" => "Tikiwiki n'a pas réussi à envoyer un message de test",
"Tiki was unable to retrieve login data from the database " => "Tiki n'a pas réussi à extraire les informations d'indentification provenant de la base données ",
"Tikiwiki Profiles" => "Profils Tikiwiki",
"TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver" => "TikiWiki nécessite <strong>au minimum</strong> 16Mo de mémoire PHP pour l'exécution des scripts. Utilisez le paramètre <strong>memory_limit</strong> de votre fichier <strong>php.ini</strong> (par exemple&nbsp;: memory_limit = 16M) et redémarrez votre serveur web",
"Tikiwiki settings" => "Configuration Tikiwiki",
"TikiWiki" => "TikiWiki",
"Tikiwiki version" => "Version Tikiwiki",
"Title text" => "Texte du titre",
"\$title" => "\$title",
"To add a new virtual host" => "Ajouter un nouveau serveur virtuel",
"To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "Pour ajouter un nouveau serveur virtuel, exécutez le script setup.sh avec le nom de domaine du nouveau site comme dernier paramètre",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Pour créer/modifier des pages Wiki facilement, ajoutez le module quick_edit , ou",
"To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "Pour ajouter de nouvelles options au menu, positionnez le champ optionId à 0. Pour retirer une option, positionnez le champ suppression à 'y'",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Pour créer/supprimer une galerie de fichiers, allez dans \"Galeries de fichiers\" dans le menu application, ou",
"To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "Pour changer la limite de mémoire, modifiez le paramètre <strong>memory_limit</strong> dans votre fichier <strong>php.ini </strong> (par exemple: memory_limit = 32M) et redémarrez votre serveur web",
"To create users and assign them to groups, got to admin->users" => "Pour créer des utilisateurs et les affecter à des groupes, allez dans administrer->utilisateurs",
"To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "Pour activer ce fichier, renommez simplement le fichier <strong>_htaccess</strong> (situé dans le répertoire principal de votre installation de Tiki) en <strong>.htaccess</strong>",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Pour installer, supprimer ou mettre à jour les paquets, vous devez donner les droits à Apache d'écrire des fichiers dans l'arborescence de votre site web (vous pouvez utiliser \"./setup.sh open\" pour lui donner les droits). Après l'installation vous devrez supprimer les permissions (utilisez \"./setup.sh\").",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "Pour installer, supprimer ou mettre à jour les paquets, vous devez donner les droits à Apache d'écrire des fichiers dans l'arborescence de votre site web (vous pouvez utiliser \"sh setup.sh open\" pour lui donner les droits). Après l'installation vous devrez supprimer les permissions (utilisez \"sh setup.sh\").",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Pour apprendre plus sur les <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">thèmes</a>.",
"To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>" => "Pour en savoir plus, visitez: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>",
"Topic ID" => "ID du sujet",
"Topic name" => "Nom du sujet",
"To run this installer in your language, use <strong>tiki-install.php?lang=XX</strong> where <strong>XX</strong> is the two-letter code for your language" => "To run this installer in your languagPour installez en francais, utilisez <strong>tiki-install.php?lang=fr</strong>",
"To secure your Tiki installation - and if you are using Apache web server - you should rename the <span style=\"font-weight: bold\">_htaccess</span> file to <span style=\"font-weight: bold\">.htaccess</span> (this file is in the main directory)" => "Pour sécuriser votre installation de Tiki - et si vous utilisez le serveur web Apache - vous devriez renommer le fichier <span style=\"font-weight: bold\">_htaccess</span> en <span style=\"font-weight: bold\">.htaccess</span> (ce fichier est placé dans le répertoire principal)",
"To test your system configuration, Tiki will attempt to send a test message to info@tikiwiki.org" => "Pour tester votre configuration système, Tiki va essayer d'envoyer un message à info@tikiwiki.org",
"To test your system configuration, Tiki will attempt to send a test message to you" => "Pour tester votre configuration, Tiki va essayer de vous envoyer un email de test",
"To upgrade from" => "Pour mettre à jour de",
"To use a menu in a tiki format" => "Pour utiliser un menu dans un format tiki",
"To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "Pour utiliser une icône personnalisée pour les répertoires, spécifier le chemin de l'icône pour un répertoire <strong>fermé</strong>",
"To use menu in a css/suckerfish format" => "Pour utiliser un menu dans un format css/suckerfish",
"To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "Pour utiliser ces liens, vous devez assigner le <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.Liens vedette",
"to_version" => "à la version",
"Trackbacks Pings" => " Pings 'je vous ai référencé'",
"Tracker Items for" => "liste des fiches de",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "Le nom du formulaire doit être unique, les noms des champs doivent être uniques dans le formulaire et doivent être des noms valides SQL",
"Trackers attachments" => "Fichiers joints des formulaires",
"Trackers attachments preferences" => "Préférence pour les fichiers joints de formulaire",
"tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
"Translate a string using Tikiwiki translation table" => "Traduire une chaine en utilisant la table de traduction Tikiwiki",
"Translate in" => "Traduire en",
"Translation Assitant" => "Assistant de Traduction",
"Transparent" => "Transparent",
"TrkMenu" => "Cliquer pour voir le sous-menu",
"true|false, if the numeric value is displayed" => "vrai|faux, si vrai on affiche la valeur numérique",
"true|false, if true then a percentage of the maximum is displayed" => "vrai|faux, si vrai on affiche le pourcentage du maximum",
"Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Code de langue à deux caractères pour filtrer la liste des pages. Il n'y aura que les pages non disponibles dans cette langue",
"Two letter language code to filter pages listed" => "Code de langue à deux caractères pour filtrer la liste des pages",
"type class not found" => "classe type non trouvée",
"UI enhancement" => "Améliorations UI",
"Unassign module" => "Désattribuer un module",
"(unchanged)" => "(sans changement)",
"Uncheck the above checkbox to uncategorize this page/object" => "Décochez la case au-dessus pour décategoriser l'objet ou page",
"Uncheck the box to import in another database" => "Décocher la case pour faire l'import à partir d'une autre base de données",
"underline" => "souligné",
"underscores" => "soulignements",
"unread private messages" => "messages privés non lus",
"Unzip all zip files" => "Dézipper tous les fichiers zip",
"Update database using script" => "Mettre à jour la base de données en utilisant le script",
"Update '{\$page}' based on '{\$source_page}'" => "Mise à jour de la page '{\$page}' basée sur '{\$source_page}'",
"Upgrade operations executed successfully" => "Opérations de mise à jour executées avec succès",
"Upload big files (e.g. PodCast files) here" => "Envoi de fichiers volumineux (e.g. PodCast files) ici",
"Uploaded filenames cannot match regex" => "Noms de fichiers envoyés ne doivent pas correspondre aux expressions régulières",
"Upload from disk" => "Envoyer à partir de son disque",
"Urgent Translation" => "Traduction Urgente",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Utiliser %1 pour indiquer le nom du fichier interne dans la commande (exemple: \"strings %1\" pour convertir le fichier en texte en utilisant la commande unix strings)",
"Use BLOGLIST to include posts from a blog" => "Utiliser BLOGLIST pour inclure des posts d'un blogue",
"Use cache for external images" => "Utiliser l'antémémoire pour les images externes",
"Use categories to regroup various Tiki objects" => "Utilisez les catégories pour regrouper différents objets Tiki",
"Use context menus for actions (icons) (only in file galleries yet)" => "Utiliser les menus contextuels pour les actions (icônes) (seulement dans les galeries de fichiers pour l'heure)",
"Use context menus for actions (text) (only in file galleries yet)" => "Utiliser les menus contextuels pour les actions (texte) (seulement dans les galeries de fichiers pour l'heure)",
"Use Ctrl+Click to select multiple categories" => "Utiliser Ctrl+Click pour sélectionner plusieurs catégories",
"Use Ctrl+Click to select multiple directory categories" => "Utiliser Ctrl+Click pour sélectionner plusieurs catégories de répertoire",
"Use Ctrl+Click to select multiple fields" => "Utiliser Ctrl+Click pour séléctionner plusieurs champs",
"Use database (full-text) search" => "Utiliser les recherches (full-text) en base de données",
"Used to embed Flash content in wiki pages, banners etc" => "Utiliser pour intégrer des contenus Flash dans une page wiki, une bannière etc",
"Use external link icons" => "Utiliser une icône pour un lien externe",
"Use File Galleries for images inclusion" => "Utiliser les galeries de fichiers pour l'inclusion d'images",
"Use Google Maps." => "Utiliser Google Maps.",
"Use gzipped output" => "Compacter les sorties (gzip)",
"Use login as email" => "Utilisez votre adresse électronique pour vous connecter",
"Use one of these links to continue" => "Utikisez l'un de ces liens pour poursuivre",
"Use page description" => "Utiliser la description de la page",
"User accounts" => "Comptes utilisateur",
"User Assigned Modules" => "Modules utilisateur assignés",
"User Assigned Modules tpl" => "gabarit des modules utilisateur assignés",
"User Bookmarks tpl" => "gabarit des signets utilisateur",
"User Calendar Doc" => "Doc calendrier utilisateur",
"User Calendar Doc tpl" => "Gabarit de la doc. de mon calendrier",
"User Calendar" => "Mon calendrier",
"User Calendar Preferences Doc tpl" => "Gabarit de la doc préférences du calendrier utilisateur",
"User can choose beyond these groups at registration time" => "Un utilisateur peut choisir parmi ces groupes à l'inscription",
"User identity features" => "Configuration de l'identité d'un utilisateur",
"User list" => "Liste des utilisateurs",
"User menu" => "Menu utilisateur",
"User must already exist." => "L'utilisateur doit déjà exister.",
"User must change his password at first login" => "L'utilisateur doit changer son mot de passe lors de sa première connexion",
"User name" => "Nom de l'utilisateur",
"UserPreferences tpl" => "gabarit des préférences utilisateur",
"User registration and login" => "Inscription et connexion des utilisateurs",
"Users can Configure Modules" => "Les utilisateurs peuvent configurer les modules",
"Users can lock pages (if perm)" => "Les utilisateurs (ayant les droits) peuvent verrouiller une page",
"Users can Shade Modules" => "Les utilisateurs peuvent afficher/cacher les modules",
"Users Defaults" => "Paramètres par défaut des utilisateurs",
"User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "Options du sélecteur d'utilisateurs&nbsp;: remplissage automatique de champ,email - feeding=1 pour le login de l'auteur ou feeding=2 pour le login du modificateur - email=1 pour envoyer un mail à l'utilisateur si le formulaire est modifié",
"Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with&nbsp;:)" => "Champs du formulaire utilisateur demandé à l'enregistrement<br />(IdChamps séparés par&nbsp;:)",
"User's Page" => "Mes pages",
"Users sort order" => "Ordre de tri des utilisateurs",
"User Tasks tpl" => "Gabarit des tâches utilisateurs",
"User Watches tpl" => "Gabarit de notification de changement utilisateur",
"Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Utilisez <strong>localhost</strong> si la base de données est sur le même serveur que celui de Tiki",
"Use templates" => "Utiliser les gabarits",
"Use the format: trackerId, fieldId1, fieldId2, .." => "Utiliser le format&nbsp;: trackerId, fieldId1, fieldId2, ..",
"Use the 'Quick Edit' module to easily create or edit wiki pages" => "Utilisez le module 'Quick Edit' pour créer ou éditer facilement des pages wiki",
"Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Utiliser cette page pour créer une nouvelle base de données, ou utiliser <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">le processus manuel d'installation</a>",
"Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" title=\"manual installation\">manual installation process</a>" => "Utilisez cette page pour créer une connexion à votre base de données, ou utilisez le <a href=\"http://doc.tikiwiki.org/Manual+Installation\" title=\"installation manuelle\">processus d'installation manuelle</a>",
"Use this page to create a new database connection" => "Utilisez cette page pour créer une connexion à votre base de données",
"Use this script" => "Utiliser ce script",
"Use this thread to discuss the %s page." => "Utilisez la page %s pour discuter le fil de discussion",
"Use tracker for more group information" => "Utiliser les formulaires pour plus d'information sur les groupes",
"Use tracker for more user information" => "Utiliser les formulaires pour plus d'informations sur les utilisateurs",
"Use URI as Home Page" => "Utiliser cette URI comme page d'accueil",
"Use @version:x.x specified in theme css or 1.8 if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou 1.8 si non spécifiée",
"Use \"watches\" to monitor wiki pages or other objects" => "Utiliser \"watches\" pour la surveillance des pages Wiki et des autres objets",
"Use WebServer authentication for Tiki" => "Utiliser l'authentification du serveur Web pour Tiki",
"Use Wiki paragraph formatting" => "Utiliser le wiki pour formatter les paragraphes (insérer &lt;p&gt; pour aller à la ligne)",
"Use WikiWords" => "Utiliser les MotWikis (NomDePage)",
"UsrMenu" => "Cliquer pour voir le sous-menu",
"UTC" => "UTC",
"Validate links" => "Valider les liens",
"Validate Sites" => "Sites validés",
"Validate user email server" => "Valider le serveur de messagerie de l'utilisateur",
"Validate users by email" => "Valider les utilisateurs par email",
"Value to compare against" => "Valeur à comparer avec",
"Video Lenght" => "Largeur de la vidéo",
"View All" => "Afficher tout",
"View changes since last approval" => "Voir les changements depuis la dernière approbation",
"View FAQ Tpl" => "Gabarit de l'affichage des FAQs",
"View graphic" => "Voir le graphique",
"Viewing of changes since last approval is possible only after first approval" => "Voir les changements depuis la dernière version approuvée n'est possible qu'après une première version approuvée",
"Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visitez <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> pour plus d'information",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Attention&nbsp;: changer le nom utilisateur va demander de changer le mot de passe et va créer des problèmes avec les sites esclaves InterTiki qui utilisent ce site comme maître",
"Warning: changing the username will require the user to change his password" => "Attention: changer le nom de l'utilisateur va lui demander de changer son mot de passe",
"__WARNING__: Plugin disabled \$plugin" => "__Avertissement__: Le Plugin \$plugin est désactivé",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Attention&nbsp;: comme le site tiki est en mode esclave, toute information utilisateur que vous entrez manuellement sera automatiquement écrasée par l'autre site, y compris les permissions utilisateur",
"Watch minor" => "Surveiller les modifications mineures",
"Webmail Doc" => "Documentation Webmail",
"Webmail Doc template" => "gabarit de la documentation Webmail",
"weeks" => "semaines",
"Welcome to" => "Bienvenue sur",
"Welcome to the Tiki installation and upgrade script" => "Bienvenue dans le script d'installation et de mise à jour de Tiki",
"Welcome to TikiWiki" => "Bienvenue à TikiWiki",
"WfMenu" => "Cliquer pour voir le sous-menu",
"When possible, show the real user name instead of login" => "Si possible, afficher le nom réel de l'utilisateur au lieu du login",
"When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page" => "Lors de l'appel d'une page, si celle-ci n'existe pas et qu'il existe une page similaire, rediriger automatiquement vers celle-ci",
"Whether to include external wikis in the list.<br />" => "Inclure ou pas les wikis externes dans la liste.<br />",
"Width in pixels allocated to the label" => "Largeur en pixel allouée à l'étiquette",
"Wiki actions bar position (e.g. Save, Preview, Cancel, ...)" => "Position de la barre des actions du Wiki (e.g. Enregistrer, Visualiser, Annuler, ...)",
"Wiki Administration" => "Administration Wiki",
"Wiki Cache" => "Antémémoire Wiki",
"Wiki Comments Settings" => "Configuration des commentaires Wiki",
"Wiki Discussion" => "Discussion Wiki",
"Wiki Features" => "Fonctionnalités Wiki",
"Wiki File Attachments" => "Fichiers joints Wiki",
"Wiki History" => "Historique Wiki",
"Wiki Home Page" => "Page d'accueil Wiki",
"Wiki Link Format" => "Format d'un lien Wiki",
"WikiMenu" => "Cliquer pour voir le sous-menu",
"Wiki Page List Configuration" => "Configuration de l'affichage de la liste des pages Wiki",
"Wiki page name to include" => "Nom de la page Wiki à inclure",
"Wiki page name to redirect to" => "Nome de la page wiki vers laquelle rediriger",
"Wiki page %s changed" => "La page Wiki %s a été modifiée",
"Wiki syntax containing the text to display" => "Syntaxe Wiki contenant le texte à afficher",
"Wiki textaera" => "Zone de texte Wiki",
"Wiki Watch" => "Notification par email des changements Wiki",
"Will be replaced by the actual value of the dynamic content block with id=n" => "pour afficher la valeur courante du contenu dynamique d'identifiant n",
"Will display using the indicated HTML color or color name" => "Va afficher le texte avec la couleur indiquée (code ou nom Html)",
"window not found" => "fenêtre non trouvée",
"Window not found" => "Fenêtre non trouvée",
"Without template" => "Sans gabarit",
"You are about to delete a TikiTest file, do you want to continue " => "Vous allez supprimer ce fichier Tikitest, voulez-vous continuer ",
"You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "Vous êtes entrain de quitter cette page. Si vous avez fait des modifications sans les sauvegarder, elles seront perdues. Êtes-vous sûr de vouloir quitter cette page",
"You are allowed to" => "Vous êtes autorisés à",
"You are editing the approved copy of this page" => "Vous éditer la version approuvée de cette page",
"You are not the owner of this page" => "Vous n'êtes pas le propriétaire de cette page",
"You are not yet validated" => "Vous n'êtes pas encore validé",
"You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "Vous pouvez approuver l'utilisateur de plugin sur <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
"You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "Vous pouvez désactiver les plugins dangereux sur (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
"You can help with the TikiWiki documentation" => "Vous pouvez trouver de l'aide sur le site TikiWiki documentation",
"You can not download files" => "Vous ne pouvez pas télécharger de fichiers",
"You cannot have more than one windows of this type." => "Vous ne pouvez pas avoir plus d'une fenêtre de ce type.",
"You cannot rename staging pages. Please rename the approved page instead" => "Vous ne pouvez pas renommer une page en cours de validation. Merci de plutôt renommer la page validée",
"You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "Veuillez  n'utiliser que optionId=0 pour créer une nouvelle option ou un optionId correspondant un un id déjà présent dans le menu pour le mettre à jour",
"You do not have permission to view this part of content" => "Vous n'avez pas les droits de voir cette partie de contenu",
"You have completed the TikiWiki installation" => "L'installation de TikiWiki est maintenant terminée",
"You have completed the TikiWiki upgrade" => "L'évolution de TikiWiki est maintenant terminée",
"You have {\$unread} unread private messages" => "Vous avez {\$unread} messages privés non lus",
"You must create the database and user <em>before</em> completing this page" => "Il faut créer la base de données et son utilisateur <em>avant</em> de compléter cette page",
"You must suggest a question; please try again" => "Vous devez proposer un question, merci de recommencer",
"You need to create one calendar" => "Vous devez créer un calendrier",
"you or someone registered this email address at" => "Vous (ou quelqu'un d'autre) a inscrit cette adresse électronique à",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Votre demande de compte a été enregistrée et va être traitée dès que possible par un administrateur.",
"Your comment will have to be approved by the moderator before it is displayed" => "Votre commentaire doit être approuvé par le modérateur avant d'être affiché",
"Your database has been configured and Tiki is ready to run" => "Votre connexion à la base de données fonctionne et Tiki est prêt",
"Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using TikiWiki with an incorrect database version usually causes errors" => "Votre base de données a besoin d'une mise à niveau pour correspondre à la version actuelle de Tiki. Merci d'utiliser <a href=\"tiki-install.php\">l'installeur</a>. L'utilisation de Tiki avec une mauvaise base de données peut provoquer des erreurs",
"Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Votre aide est requise! Merci de visiter<a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> pour en savoir plus",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Votre message est mis en attente jusqu'à ce qu'il soit approuvé par un modérateur.",
"Your post has not been posted" => "Votre publication n'a pas été publiée",
"Your Tiki information registration" => "Votre inscription",
"Your registration" => "Votre inscription",
"You will not see the latest queries" => "Vous ne verrez pas les dernières requêtes",
"Zoom" => "Zoom",
"page|desc" => "page|desc",
"Prologue" => "Prologue",
"Re" => "Re",
"Lines" => "Lignes",
"Select a Wiki page to link to" => "Sélectionnez une page Wiki vers laquelle pointer le lien",
"Cannot open this file" => "Impossible d'ouvrir ce fichier",
"Query point" => "Point de recherche",
"layer" => "couche",
"Record" => "Enregistrement",
"User Map Generated in" => "Carte utilisateur générée dans",
"Image Map Generated in" => "Carte image générée dans",
"Help page" => "Page d'aide",
"View the tracker item at" => "Voir la fiche du formulaire à",
"wrote" => "écrit",
"RSS Id incorrect" => "Identifiant RSS incorrect",
"Incorrect fieldId" => "Mauvais fieldId",
"posts" => "Articles",
"reported" => "signalé",
"queued" => "en attente",
"Move to topic" => "Déplacer vers le sujet",
"Type of contribution" => "Type de contribution",
"The files can be locked at download" => "Les fichiers peuvent être verrouillés au téléchargement",
"Perhaps you were looking for" => "Peut-être cherchez-vous",
"Hi {\$mail_user} has sent you this link" => "Bonjour, {\$mail_user} vous signale ce lien",
"Somebody or you tried to subscribe this email address at our site" => "Une demande d'inscription de votre adresse électronique a été faite sur notre site",
"To the newsletter" => "à la lettre d'informations",
"In order to confirm your subscription you must access the following URL" => "Pour confirmer votre inscription, cliquez sur le lien ci-dessous",
"To validate your account and login to the site, please click on the following link" => "Pour valider votre compte et vous connecter au site, veuillez cliquer sur le lien suivant",
"New topic" => "Nouveau sujet",
"You sent a request with the subject" => "Vous avez envoyé une requête avec le sujet",
"Use the subject to indicate the operation to apply" => "Utilisez le sujet du message pour indiquer l'opération à appliquer",
"Page not found" => "Aucune page trouvée",
"To login with your username and password, please follow this link" => "Pour vous connecter avec votre nom d'utilisateur et votre mot de passe, suivez le lien",
"To validate that account, please follow the link" => "Pour valider ce compte, suivez ce lien",
"registered at your site<" => "s'est inscrit au site",
"This email address has been removed to the list of subscriptors of" => "Cette adresse électronique a été supprimée de la liste des inscrits à",
"This email address has been added to the list of subscriptors of" => "Cette adresse électronique a été ajoutée à la liste des inscrits à",
"You can always cancel your subscription using" => "Vous pouvez toujours vous désinscrire en allant sur",
"You can edit the submission following this link" => "Vous pouvez modifier la soumission en suivant le lien",
"Look at this link" => "Allez voir ce lien",
"A friend sends you a link from" => "Un ami vous a envoyé un lien de",
"Download the file at" => "Télécharger le fichier à",
"Please visit this link before login again" => "Merci de visiter ce lien avant de vous re-connecter",
"If you want to be a registered user in this site you will have to use the following link to login for the first time" => "Si vous voulez pouvoir vous connecter sur ce site, vous devrez suivre le lien suivant pour la première connexion",
"View the article at" => "Pour voir cet article",
"If you don't want to receive these notifications follow this link" => "Si vous ne voulez plus recevoir ces notifications, suivez le lien",
"View the blog at" => "Le blogue peut être vu à",
"View item calendar at" => "voir cet évènement de calendrier à",
"You can view the updated map following this link" => "Vous pouvez afficher la carte mise à jour en suivant ce lien",
"You can edit the map following this link" => "Vous pouvez modifier la carte en suivant ce lien",
"A page has been added to your watched sub-structure" => "Une page a été ajoutée à la sous-structure que vous surveillez",
"A page has been removed from your watched sub-structure" => "Une page a été retirée de la sous-structure que vous surveillez",
"A page has been promoted out your watched sub-structure" => "Une page a été promue dans la sous-structure que vous surveillez",
"A page has been demoted to your watched structure" => "Une page a été dépromue de la sous-structure que vous surveillez",
"You can view the page by following this link" => "Vous pouvez voir la page en suivant le lien",
"You can view a diff back to the previous version by following this link" => "Vous pouvez voir les différences avec la version immédiatement précédente en suivant le lien",
"you have requested to download the layer" => "vous avez demandé de télécharger la layer",
"from the mapfile" => "du fichier-carte",
"Here are the files to download, do not forget to rename them" => "Ici sont les fichiers à télécharger, n'oubliez pas de les renommer",
"Create Directory" => "Créer un répertoire",
"index file (.shp)" => "fichier index (.shp)",
"files to index (regexp)" => "fichiers à indexer (regexp)",
"Auto-archive age for read messages" => "Temps où les messages sont auto-archivés",
"Your registration code" => "Votre code d'enregistrement",
"Site Language" => "Langue du site",
"PHP error reporting level" => "Niveau de rapport d'erreurs PHP",
"Available styles" => "Styles disponibles",
"Max. number of links around the current item" => "Nombre maximum de liens autour de l'élément courant",
"Max. number of links after the first or before the last item" => "Nombre maximum de liens après le premier ou avant le dernier élément",
"Favicon icon file name" => "Nom du fichier de l'icône Favicon",
"Favicon icon MIME type" => "Type MIME de l'icône",
"Caching time" => "Temps en antémémoire",
"Create webhelp from structure" => "Créer l'aide web à partir d'une structure",
"UserPage prefix" => "Préfixe de la page utilisateur",
"Legend background color" => "Couleur de fond des légendes",
"Save graphs to image gallery" => "Enregistrer les graphiques dans la galerie d'image",
"Delete events older than" => "Effacer les évènements plus vieux que",
"Current Category ID" => "ID Catégorie courant",
"Edit this category" => "Modifier cette catégorie",
"Edit this template" => "Modifier ce gabarit",
"Edit the contribution" => "Modifier la contribution",
"Edit this Forum" => "Modifier ce forum",
"Store attachments in" => "Sauver les fichiers joints dans",
"Edit this HTML page" => "Modifier cette page HTML",
"Edit Rules for Repository" => "Modifier les règles du répertoire",
"Edit this Featured Link" => "Modifier ce lien vedette",
"To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "Pour utiliser <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, vous pouvez utiliser l'une des trois syntaxes suivantes",
"To customizing the menu's css id (#id)" => "Pour personnaliser l'identifiant css du menu (#id)",
"To customize the menu's CSS id (#)" => "Pour personnaliser l'identifiant css du menu (#id)",
"Edit this Menu" => "Modifier ce menu",
"Edit this assigned module" => "Modifier ce module attribué",
"Edit this user module" => "Modifier ce module utilisateur",
"Add email" => "Ajouter l'adresse électronique",
"Add user" => "Ajouter l'utilisateur",
"Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Veuillez noter que les pages suivantes font également partie d'une autre structure. Assurez-vous que les permissions d'accès (le cas échéant) ne rentrent pas en conflit",
"The following pages have automatically been categorized with the same categories as the structure" => "Les pages suivantes ont été automatiquement catégorisées dans la même catégorie que la structure",
"The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "Les pages suivantes sont dans des catégories contrairement à la structure. Pour rester consistant, il faudrait les sortir de ces catégories",
"The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "Les pages suivantes sont dans des catégories dans laquelle ne se trouve pas la structure. Pour assurer la cohérence, vous pourriez vouloir les recatégoriser",
"Select list items that will be displayed" => "Choisir la liste des éléments qui seront affichés",
"Visible by" => "Visible par",
"Editable by" => "Editable par",
"Error message" => "Message d'erreur",
"Format if not the default short one" => "Format si n'est pas le format court par défaut",
"Assign users to group" => "Affecter des utilisateurs à des groupes",
"the following groups" => "les groupes suivants",
"Overwrite groups" => "Groupes qui ont été écrasés",
"Mark entry as private" => "Marquer l'entrée comme privée",
"Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Donner la liste des participants en les séparants par des virgules. Les rôles des participants sont à donner en préfixant par un double-point(:) comme dans l'exemple suivant",
"Upload from disk to change the image" => "Charger depuis le disque pour changer l'image",
"Block description" => "Description du bloc",
"You are editing block" => "Vous éditez le bloc",
"and its subpages from the structure, now you have two options" => "et ses sous-pages de la structure, maintenant vous avez 2 choix",
"Save Only in the Theme" => "Sauvegarder uniquement dans le thème",
"Delete the copy in the theme" => "Supprimer la copie dans le thème",
"Perhaps you are looking for" => "Peut-être cherchez-vous",
"Perfom action with checked" => "Réaliser l'opération sur les éléments cochés",
"Add transition from" => "Ajouter une transition de",
"Add transition to" => "Ajouter une transition à",
"ver" => "ver",
"Edit this gallery" => "Modifier cette galerie",
"The cache is used by" => "L'antémémoire est utilisée par",
"Create New FAQ" => "Créer une nouvelle FAQ",
"To display the objects you created or contributed to" => "Pour afficher les objets auxquels vous participez",
"Reading note" => "Note lue",
"and also to all pages of the sub-structure" => "et aussi à toutes els pages de la sous structure",
"Items found" => "Fiches trouvées",
"Epilogue" => "Epilogue",
"A link to this post was sent to the following addresses" => "Un lien vers cet article a été envoyé aux adresses suivantes",
"Edit this sheet" => "Modifier ce feuillet",
"Focus" => "Focus",
"The link was sent to the following addresses" => "Le lien a été envoyé à ces adresses",
"Edit File" => "Fichier modifié",
"Used space" => "Volume utilisé",
"expires" => "expire",
"Reported Messages" => "Messages signalés",
"Queued Messages" => "Messages en attente",
"Tracker Item" => "Fiche du formulaire",
"Word Count" => "Nombre de mots",
"Use this thread to discuss the page" => "Utilisez ce fil de discussion pour discuter sur la page",
"Click here to delete the category" => "Cliquez ici pour supprimer la catégorie",
"The file does not have the required header" => "Le fichier n'a pas les en-têtes nécessaires",
"Detected, Version" => "Trouvé. Version",
"You do not have permission to write the template" => "Droit d'accès refusé&nbsp;: vous n'avez pas droit d'écrire le gabarit",
"Warning: Empty file" => "Attention&nbsp;: fichier vide",
"Cannot read file" => "Ne peut pas lire le fichier",
"Cannot read the file" => "Ne peut pas lire le fichier",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site" => "Vous pouvez parcourir ce site de votre mobile en suivant le lien",
"merged note" => "note de fusion",
"Notice: this variable may not be empty" => "Cette variable ne peut pas être vide",
"Notice: invalid variable value" => "Remarque&nbsp;: valeur de variable invalide",
"Task entries" => "Description de la tâche",
"wysiwyg toolbar" => "Barre d'outils wysiwyg",
"system os" => "Système d'exploitation",
"If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "Si vous voulez installer une nouvelle version de Tiki, assurez vous d'avoir lu et compris les <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">instructions de mise à niveau</a>",
"PostgeSQL 7.2+" => "PostgeSQL 7.2+",
"Oracle" => "Oracle",
"Sybase" => "Sybase",
"SQLLite" => "SQLLite",
"MSSQL" => "MSSQL",
"latin" => "latin",
"crypt-md5" => "crypt-md5",
"crypt-des" => "crypt-des",
"Admins" => "Admins",
"#FFFFFF" => "#FFFFFF",
"podcast (audio)" => "podcast (audio)",
"podcast (video)" => "podcast (video)",
"\$module_title" => "\$module_title",
"\$modcattitle" => "\$modcattitle",
"\$type" => "\$type",
"Menu" => "Menu",
"JsCalendar" => "JsCalendar",
"Mootools" => "Mootools",
"Workflow" => "Workflow",
"Unix" => "Unix",
"Windows" => "Windows",
"(standard)" => "(standard)",
"PEAR::Auth" => "PEAR::Auth",
"LDAP version" => "LDAP version",
"Realname attribute" => "Realname attribute",
"Base DN" => "Base DN",
"User DN" => "User DN",
"User attribute" => "User attribute",
"User OC" => "User OC",
"Group DN" => "Group DN",
"Group attribute" => "Group attribute",
"Group OC" => "Group OC",
"LDAP Member" => "LDAP Member",
"Member attribute" => "Member attribute",
"Member is DN" => "Member is DN",
"Admin user" => "Admin user",
"Admin password" => "Admin password",
"hits" => "hits",
"Ver" => "Ver",
"phpLayersMenus" => "phpLayersMenus",
"table" => "table",
"interactive" => "interactive",
"Minutes" => "Minutes",
"Int" => "Int",
"Interactive" => "Interactive",
"inter" => "inter",
"route" => "route",
"val" => "val",
"Instance" => "Instance",
"Workitems" => "Workitems",
"exception" => "exception",
"If:SetNextact" => "If:SetNextact",
"Proc" => "Proc",
"auto" => "auto",
"int" => "int",
"Instances" => "Instances",
"Exceptions" => "Exceptions",
"instance" => "instance",
"/" => "/",
"Msgs" => "Msgs",
"Newsgroup" => "Newsgroup",
"chg" => "chg",
"info/vote" => "info/vote",
"Dif" => "Dif",
"Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Les bibliothèques Text_Wiki doivent être installées. Veuillez prendre connaissance de http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
"This instance of activity is already complete" => "Cette instance est déjà finie",
"Fatal error: cannot execute automatic activity \$activityId" => "Erreur fatale&nbsp;: Ne peut pas exécuter l'activité \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Erreur fatale&nbsp;: l'activité suivante pointe vers une activité inexistante",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Erreur fatale&nbsp;: aucune activité candidate pour l'activité suivante",
"Fatal error: non-deterministic decision for autorouting activity" => "Erreur fatale&nbsp;: plusieurs activités suivantes possibles",
"Fatal error: trying to send an instance to an activity but no transition found" => "Erreur fatale :aucune transition trouvée lors de l'envoi d'une instance à une activité",
"Cannot add transition only split activities can have more than one outbound transition" => "Ne peut pas ajouter de transition - seulement les activités découpées peuvent avoir plus d'une transition outbound",
"Circular reference found some activity has a transition leading to itself" => "Boucle trouvée&nbsp;: une activité a une transition pointant vers elle-même",
"Process does not have a start activity" => "Le processus n'a pas d'activité initiale",
"Process does not have exactly one end activity" => "Le processus n'a pas une et une seule activité finale",
"End activity is not reachable from start activity" => "L'activité finale ne peut être atteinte depuis l'activité initiale",
"is interactive but has no role assigned" => "est interactive sans rôle attribué",
"is non-interactive and non-autorouted but has no role assigned" => "est ni interactive, ni autoroutée mais n'a pas de rôle attribué",
"is standalone but has transitions" => "est indépendante mais n'a pas de transition",
"Role" => "Rôle",
"is not mapped" => "n'est pas associée",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "L'activité '.\$res['name'].' est indépendante et utilise l'objet \$instance",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "L'activité '.\$res['name'].' est interactive et ainsi doit utiliser la méthode \$instance->complete()",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "L'activité '.\$res['name'].' n'est pas interactive et doit ainsi utiliser la méthode \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activité '.\$res['name'].' est échangé ainsi la méthode \$instance->setNextActivity(\$actname) doit être utilisée",
"Process %d has been activated" => "Le processus %d a été activé",
"Process %d has been deactivated" => "Le processus %d a été désactivé",
"Process %s %s imported" => "Processus %s %s importé",
"Process %s removed" => "Processus %s supprimé",
"Process %s has been updated" => "Le processus %s a été mis à jour",
"Process %s has been created" => "Le processus %s a été créé",
"newest" => "plus récent",
"oldest" => "plus ancien",
"on left side" => "à gauche",
"on center" => "au centre",
"on right side" => "à droite",
"<return> for rows" => "<Entrée> pour les rangées",
"Any 2 versions" => "2 versions au choix",
"english" => "anglais",
"Report all errors except notices" => "Rapporter toutes les erreurs sauf les notices",
"1 hour" => "1 heure",
"2 hours" => "2 heures",
"10 hours" => "10 heures",
"20 hours" => "20 heures",
"1 day" => "1 jour",
"1 week" => "1 semaine",
"1 month" => "1 mois",
"1 year" => "1 an",
"Just Tiki" => "Juste Tiki",
"Tiki and PEAR::Auth" => "Tiki et PEAR::Auth",
"OpenID and Tiki" => "OpenID et Tiki",
"choose a group ..." => "choisir un groupe...",
"Never use transition css" => "Ne jamais utiliser de feuille de style de transition",
"Use @version:x.x specified in theme css or none if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou aucune si non spécifiée",
"Use @version:x.x specified in theme css or 1.9 if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou 1.9 si non spécifiée",
"Use @version:x.x specified in theme css or 2.0 if not specified" => "Utiliser @version:x.x spécifiée dans le thème css ou 2.0 si non spécifiée",
"No forums" => "Aucun forum",
"%s enabled" => "Fonctionnalité activée&nbsp;: %s",
"\$feature is turned on" => "\$feature est activée",
"%s disabled" => "Fonctionnalité désactivée&nbsp;: %s",
"\$feature is turned off" => "\$feature est désactivée",
"\$feature set to nothing" => "\$feature n'est pas positionné",
"Charts" => "Palmarès",
"Forums last topics" => "Derniers sujets de forum",
"Directory categories" => "Catégories de répertoire",
"You need either JQuery or MooTools enabled for this feature" => "Il faut activer soit JQuery soit MooTools pour cette fonctionnalité",
"An error occured in a database query!" => "Une erreur a été rencontrée dans une requête à la base de données!",
"games" => "jeux",
"You are not allowed to upload this type of file." => "Vous n'êtes pas autorisé à envoyer ce type de fichiers.",
"You must select a file." => "Vous devez sélectionner un fichier.",
"Altering database table failed" => "Échec de la modification de la table de la base de données",
"Insert a division block on wiki page" => "Insère un bloc div dans une page Wiki",
"Draw" => "Dessin",
"Displays drawings in the wiki page" => "Affiche des dessins dans une page wiki",
"drawing not found" => "dessin non trouvé",
"Name parameter missing" => "Nom du paramètre manquant",
"heads and cells separated by ~|~" => "en-têtes et cellules séparés par ~|~",
"Displays an image." => "Affiche une image.",
"Alternate Text" => "Texte alternatif",
"Link Title" => "Titre du lien",
"Default: #F5F5F5" => "Défaut: #F5F5F5",
"list topics with links to the articles" => "liste des sujets avec liens vers les articles",
"Please provide an Id" => "SVP donnez un ID",
"Autovalidate suggestions" => "Validation automatique des suggestions",
"Can abort a process instance" => "Peut interrompre une instance d'un processus",
"Can admin charts" => "Droit d'administrer les palmarès",
"Can admin drawings" => "Droit d'administrer les dessins",
"Can admin games" => "Droit d'administrer les jeux",
"Can admin quicktags" => "Droit d'administrer les raccourcis",
"Can admin rss modules" => "Droit d'administrer les modules rss",
"Can admin workflow processes" => "Droit d'administrer les processus du workflow",
"Can declare an instance as exception" => "Droit de déclarer une instance comme exception",
"Can edit drawings" => "Droit de modifier les dessins",
"Can edit items in categories" => "Droit de modifier les éléments dans les catégories",
"Can execute workflow activities" => "Droit d'exécution d'instances du workflow",
"Can rate wiki pages" => "Droit de participer à la notation des pages du wiki",
"Can play games" => "Droit de jouer aux jeux",
"Can search on objects of this category" => "Droit de lancer des recherches sur des objets de cette catégorie",
"Can send instances after completion" => "Droit d'envoyer des éléments après accomplissement",
"Can suggest items" => "Droit de suggérer des éléments",
"Can use the newsreader" => "Droit d'utiliser le lecteur de news",
"Can view categories" => "Droit de voir des catégories",
"Can view categorized items" => "Droit de voir des éléments catégorisés",
"Can view charts" => "Droit de voir le palmarès",
"Can vote" => "Droit de vote",
"Quicktags" => "Raccourcis",
"any file" => "tout fichier",
"This Gallery is Public" => "Cette galerie est publique",
"Users with perms and not only the owner of the gallery can upload in it" => "En plus du propriétaire de la galerie, les utilisateurs avec les droits suffisant peuvent télécharger",
"Listing configuration" => "Configuration de l'affichage",
"Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Séparer les freetags par des espaces. Les tags formés par des mots composés sont à saisir sans espaces entre les différents mots (ex pour \"en dehors\" saisir \"endehors\").",
"Loading" => "Chargement",
"\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076F\\074/span\\076ermer",
"\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076S\\074/span\\076uivant",
"\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076récédant",
"Tiki User Account Activated" => "Compte utilisateur Tiki activé",
"best regards" => "Salutations",
"your Tikiwiki" => "votre Tikiwiki",
"Tiki User Registration Request" => "Demande d'inscription d'un utilisateur",
"Tiki email notification" => "Email de notification Tiki",
"Someone coming from IP Address" => "Quelqu'un avec cette adresse IP",
"Your Tiki account information for %s" => "Les informations de votre compte Tiki sur %s",
"QuickTags" => "Raccourcis",
"TikiWiki Assistant" => "Assistant Tikiwiki",
"Last `\$module_rows` blog comments" => "`\$module_rows` derniers commentaires de blogues",
"Last blog comments" => "Derniers commentaires de blogues",
"Recently visited pages" => "Dernières pages visitées",
"Last `\$module_rows` Sites" => "Les `\$module_rows` derniers sites",
"Last Sites" => "Derniers sites",
"Directory Stats" => "Statistiques sur le répertoire des liens",
"Sites to validate" => "Sites à valider",
"Visited links" => "Liens visités",
"Top \$module_rows Sites" => "Les \$module_rows sites les plus populaires",
"Top Sites" => "Sites vedette",
"Top `\$module_rows` topics" => "Les `\$module_rows` sujets les plus populaires",
"Last `\$module_rows` forum posts" => "Derniers `\$module_rows` articles de forum",
"Last `\$module_rows` forum topics" => "Les `\$module_rows` derniers sujets de forum",
"Folksonomy" => "Folksonomie",
"Last `\$module_rows` actions" => "Dernières `\$module_rows` actions",
"Last `\$module_rows` articles" => "Les `\$module_rows` derniers articles",
"Last articles" => "Derniers articles",
"Last `\$module_rows` blog posts" => "Les `\$module_rows` derniers articles de blogues",
"Last `\$module_rows` Created blogs" => "Les `\$module_rows` derniers blogues créés",
"Last `\$module_rows` Created FAQs" => "Les `\$module_rows` derniers FAQs créés",
"Last `\$module_rows` Created Quizzes" => "Les `\$module_rows` derniers QCMs créés",
"Last `\$module_rows` modified file galleries" => "Les `\$module_rows` dernières galeries de fichier modifiées",
"Last `\$module_rows` Files" => "Les `\$module_rows` derniers fichiers",
"Last `\$module_rows` galleries" => "Les `\$module_rows` dernières galeries d'images",
"Last galleries" => "Dernières galeries",
"Last `\$module_rows` Images" => "Dernières `\$module_rows` Images",
"Last `\$module_rows` modified events" => "Derniers `\$module_rows` évènements modifiés",
"Last `\$module_rows` changes" => "Les `\$module_rows` dernières modifications",
"Last `\$module_rows` Modified Items" => "Les `\$module_rows` dernières fiches modifiés",
"Last `\$module_rows` Modified blogs" => "Les `\$module_rows` derniers blogues modifiés",
"Last `\$module_rows` submissions" => "Les `\$module_rows` dernières soumissions",
"Last `\$module_rows` Modified Comments" => "Derniers `\$module_rows` commentaires modifiés",
"Last Modified Comments" => "Derniers commentaires modifiés",
"Last `\$module_rows` Items" => "Les `\$module_rows` dernières fiches",
"New Messages" => "Nouveaux messages",
"New Message" => "Nouveau message",
"Random Images" => "Images choisies au hasard",
"Top `\$module_rows` articles" => "Les `\$module_rows` articles les plus populaires",
"Top `\$module_rows` File Galleries" => "Les `\$module_rows` galeries de fichiers les plus populaires",
"Top `\$module_rows` files" => "Les `\$module_rows` fichiers les plus populaires",
"Top `\$module_rows` Forum Posters" => "Les `\$module_rows` plus actifs publieurs de forum",
"Top `\$module_rows` games" => "Les `\$module_rows` jeux les plus populaires",
"Top games" => "Jeux les plus populaires",
"Top `\$module_rows` galleries" => "Les `\$module_rows` galeries d'images les plus populaires",
"Top `\$module_rows` Images" => "Les `\$module_rows` images les plus populaires",
"Top `\$module_rows` Objects" => "Les `\$module_rows` objets les plus vus",
"Top `\$module_rows` Pages" => "Les `\$module_rows` pages les plus populaires",
"Top `\$module_rows` Quizzes" => "Les `\$module_rows` QCMS les plus populaires",
"Most `\$module_rows` visited blogs" => "Les `\$module_rows` blogues les plus visités",
"Top `\$module_rows` Visited FAQs" => "Les `\$module_rows` FAQs les plus visités",
"Better translations" => "Meilleures traductions",
"Equivalent translations" => "Traductions équivalentes",
"Translations that need improvement" => "Traductions à affiner",
"Upcoming `\$module_rows` events" => "Les `\$module_rows` prochains évènements",
"The Next Event" => "Le prochain évènement",
"No Upcoming Events" => "Aucun évènement à venir",
"Whats related" => "En relation",
"Last `\$module_rows` wiki comments" => "Les `\$module_rows` derniers commentaires Wiki",
"on page" => "sur la page",
"show structures" => "montrer les structures",
"hide structures" => "masquer les structures",
"Blogs Listing" => "Liste des Blogs",
"Creation date" => "Date de création",
"PHPLayers is disabled" => "PHPLayers désactivé",
"My workflow" => "Mon workflow",
"Number of columns per page when listing categories" => "Nombre de colonnes par page à l'affichage des catégories",
"enable cool sites" => "Activer les sites cools",
"No tabs" => "Pas d'onglets",
"Main" => "Principales",
"Global Features" => "Fonctionnalités globales",
"More Functionality" => "Autres Fonctionnalités",
"UI Enhancements" => "Interface",
"Main Features" => "Fonctionnalités Principales",
"Action log setting" => "Configuration du journal des actions",
"Additional Features" => "Fonctionnalités additionnelles",
"Featured Help" => "Aide Liens vedette",
"Copyright System" => "Droits réservés(Copyright)",
"Copyright system" => "Système de copyright",
"Comments Moderation" => "Modération des Commentaires",
"PhpLayers Dynamic menus" => "Menus dynamiques PhpLayers",
"Allow users to activate fullscreen mode" => "Autoriser les utilisateurs à activer le mode plein écran",
"Experimental Features" => "Fonctionnalités expérimentales",
"HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Le contenu est nettoyé en XHTML 1.1 Strict à chaque enregistrement)",
"JQuery: JavaScript UI effects" => "JQuery: Effets sur l'interface utilisateur à l'aide de JavaScript",
"Tiki Sheet" => "Feuillet Tiki",
"These features have critical faults - not recommended" => "Cette fonctionnalités a beaucoup d'erreur critique - non recommandée",
"Drawings" => "Dessins",
"Friendship" => "Réseaux d'amis",
"Games" => "Jeux",
"Administration Features" => "Fonctionnalités administrateur",
"Banning System" => "Système d'interdiction",
"Action Calendar" => "Calendrier des actions",
"Tiki action calendar" => "calendrier des actions Tiki",
"User Features" => "Fonctionnalités utilisateur",
"Newsreader" => "Lecteur de news",
"requires PHP5 or more" => "nécessite PHP5 ou plus",
"Workflow engine" => "Moteur de workflow",
"Gallery Listing" => "Préférences d'affichage",
"Admin Password" => "Mot de passe de l'Admin",
"Tiki version" => "Version de Tiki",
"Use TikiWiki feature as homepage" => "Utiliser cette fonction Tiki comme page d'accueil",
"Server OS" => "Système d'exploitation du serveur",
"Unknown/Other" => "Inconnu/Autre",
"Do not allow php code in smarty templates" => "N'autorise pas l'utilisation de code PHP dans les modèles smarty ",
"(some Unix MTA)" => "(certains serveurs de mail Unix. Ex: gmail)",
"Visible to Admin only" => "Visible par Admin seulement",
"Log queries using more than" => "Noter les requêtes SQL prenant plus de",
"Tikiwiki.org help" => "Aide de Tikiwiki.org",
"Store session data in database" => "Sauvegarder les données de session dans la base de données",
"Allow anonymous visitors to use the \"Contact Us\"" => "Autoriser les visiteurs anonymes à utiliser \"Nous contacter\"",
"Show user's real name instead of login (when possible)" => "Afficher le nom de l'utilisateur plutôt que son identifiant (lorsque c'est possible)",
"Default timezone" => "Fuseau horaire par défaut",
"Long date format" => "Format long pour la date",
"Sample" => "Résultat",
"Short date format" => "Format court pour la date",
"Long time format" => "Format long pour l'heure",
"Short time format" => "Format court pour l'heure",
"Fields display order" => "Ordre d'affichage des champs",
"New password" => "Nouveau mot de passe",
"Google Map setup" => "Configuration des cartes Google",
"Google Map Key" => "Clé Carte Google",
"Show pages in user's preferred language" => "Afficher les pages dans la langue préférée de l'utilisateur ",
"User preferences are disabled" => "Les préférences utilisateurs sont désactivées",
"Use Ctrl+Click to select multiple languages" => "Utiliser Ctrl+Click pour sélectionner plusieurs langues",
"Changing page language will also change the site language" => "Le changement de la langue d'une page wiki entrainera le changement de langue du site",
"Structures are disabled" => "Les structures sont désactivées",
"Intertiki exchange feature" => "Fonctionnalité d'échange InterTiki",
"Text Area" => "Zone de texte",
"Semantic" => "Sémantique",
"Webservices management" => "Gestion des webservices",
"You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "Vous devez renseigner <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">l'émetteur des Email</a>",
"Passcode" => "code",
"Users can select a group to join at registration" => "Les utilisateurs peuvent sélectionner un groupe à rejoindre lors de l'enregistrement",
"Use HTTPS login" => "Utiliser un login HTTPS",
"HTTP port" => "Port HTTP",
"HTTPS port" => "Port HTTPS",
"Cookie name" => "Nom du Cookie",
"Minimum length" => "Taille Minimale",
"Username pattern" => "Patron du nom d'utilisateur",
"If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "Si le mot de passe </em>est stocké <em> en texte clair, il sera envoyé par email à l'utilisateur",
"If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "Si le mot de passe </em>n'est pas stocké</em> en texte clair, les informations pour réinitialiser seront envoyées par email à l'utilisateur",
"Encryption method" => "Méthode de chiffrage",
"You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "Vous devez changer la méthode d'authentification en PEAR::Auth pour que les options ci-dessous soient exploitées",
"Create user if not in Auth" => "Créer l'utilisateur si il n'existe pas dans Auth",
"Search scope" => "Délimiter la recherche",
"PAM service" => "Service PAM",
"CAS server version" => "Version du serveur CAS",
"Hostname" => "Nom du serveur",
"General Layout" => "Mise en page générale",
"Reg users can change theme" => "Les utilisateurs peuvent changer de thème",
"Slideshows theme" => "Thème des diaporamas",
"Use transition style sheet from version" => "Utiliser une feuille de style de transition depuis la version",
"Template Viewing" => "Affichage du gabarit",
"Site logo source (image path)" => "Source du logo du site (chemin d'accès de l'image)",
"Site logo background color" => "Couleur du fond du logo du site",
"Site logo background style" => "Couleur de fond du logo du site",
"Site logo alignment" => "Alignement du logo",
"Site logo title (on mouse over)" => "Titre du logo du site (quand la souris passe dessus)",
"Site subtitle" => "Sous-titre du Site",
"Site Search Bar" => "Barre de recherche",
"Site Login Bar" => "Barre de Login du Site",
"Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: PHPLayers doit être activé (défaut), ou CSS Menu dans ",
"Site Breadcrumbs" => "Fils d'Ariane du site",
"at top of page" => "en haut de la page",
"at top of center column" => "en haut de la colonne du centre",
"entire location" => "fil d'Ariane complet",
"page name" => "nom de la page",
"Left blank to use the default sender email" => "Laisser vide pour utiliser l'expéditeur par défaut",
"Custom End of <body> Code" => "Personnalisation de la fin du <body> Code",
"Other options" => "Autres options",
"Context Menus (only in file galleries so far)" => "Menu contextuel (uniquement dans les galeries de fichiers pour le moment)",
"Change Preferences" => "Changer les préférences",
"Filter the list of profiles" => "Filtrer la liste des profils",
"installed" => "installé",
"Repository URLs" => "URLs de dépôt",
"Maximum number of items to display" => "Nombre maximum d'éléments à afficher",
"Show Author" => "Afficher l'auteur",
"Homepage URL" => "URL de la page d'accueil",
"Default RDF version" => "Version RDF par défaut",
"Editor" => "Éditeur",
"Webmaster" => "Administrateur du site",
"Image Path" => "Chemin vers l'image",
"Show quicktags above textareas" => "Afficher les raccourcis au-dessus des zones de texte",
"If the page does not exist, Tiki will create it" => "Si la page n'existe pas, Tiki la créera",
"Select the characters that can be used with Wiki link syntax: ((page name))" => "Choisissez les caractères qui peuvent être utilisés pour la syntaxe d'un lien wiki: ((nom de page))",
"Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Saisissez un caractère à utiliser en tant que délimiteur lors de l'affichage de noms de pages. Tous les caractères après le délimiteur seront masqués à l'affichage du nom de page.",
"Wiki action bar" => "Barre d'action Wiki",
"Page navigation bar location" => "Emplacement de la barre de navigation pour la page multiple",
"Wiki top line" => "Ligne du haut Wiki",
"Individual cache" => "Cache individuel",
"Requires AJAX" => "Nécessite AJAX",
"experimental" => "experimentale",
"Regex search and replace" => "Recherche et remplacement avec une expression régulière",
"Orphan page" => "Page orpheline",
"Toolbar content" => "Contenu de la barre d'outils",
"A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>." => "Une nouvelle version de Tikiwiki, <b>{\$tiki_release}</b>, est disponible. Vous utilisez actuellement la version <b>{\$tiki_version}</b>. Veuillez visiter <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>.",
"Configure" => "Configurer",
"Perms inherited from closest parent if possible or from global perms" => "Permissions héritées du parent le plus proche ou des permissions globales",
"Assign permissions automatically" => "Attribuer les permissions automatiquement",
"recommended for best performance" => "recommandé pour une meilleure performance",
"image gal" => "gal image",
"file gal" => "gal fichier",
"Admin chart items" => "Administrer les items d'un palmarès",
"Edit Chart" => "Modifier un palmarès",
"Chart items" => "Items de palmarès",
"No items defined yet" => "Aucun item n'a encore été défini",
"Add or edit a chart" => "Ajouter/modifier un palmarès",
"Users can vote for only one item from this chart per period" => "Les utilisateurs ne peuvent voter que pour un item de ce palmarès par période",
"Prevent users from voting for the same item more than once" => "Empêcher les utilisateurs de voter pour le même item plusieurs fois",
"Users can suggest new items" => "Les utilisateurs peuvent suggérer de nouveaux items",
"Auto validate user suggestions" => "Valider automatiquement les suggestions des utilisateurs",
"Ranking shows" => "Le classement montre",
"All items" => "Tous les éléments",
"Top 10 items" => "10 premiers items",
"Top 20 items" => "20 premiers items",
"Top 40 items" => "40 premiers items",
"Top 50 items" => "50 premiers items",
"Top 100 items" => "100 premiers items",
"Top 250 items" => "250 premiers items",
"Voting system" => "Système de vote",
"Vote items" => "Voter oui ou non",
"Rank 1..5" => "Note 1..5",
"Rank 1..10" => "Note 1..10",
"Ranking frequency" => "Fréquence des classements",
"Realtime" => "En temps réel",
"Each 5 minutes" => "Toutes les 5 minutes",
"Show Average" => "Afficher la moyenne",
"Show Votes" => "Afficher les votes",
"Use Cookies for unregistered users" => "Utiliser des cookies pour les utilisateurs anonymes",
"Users can vote again after" => "Les utilisateurs peuvent encore voter après",
"Anytime" => "N'importe quand",
"Ranks" => "Classements",
"No charts defined yet" => "Aucun palmarès n'a encore été défini",
"Admin drawings" => "Administrer les dessins",
"To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "Pour insérer un dessin dans une page Wiki, utiliser {literal}{draw name=foo}{/literal}, où foo est le nom du dessin. Après sauvegarde, cliquer le lien du dessin.",
"Available drawings" => "Dessins disponibles",
"Enable Features" => "Activé la foncitonnalité",
"no display" => "pas affiché",
"List Forums" => "Liste des Forums",
"To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "Pour utiliser les menus dans un <a href=\"tiki-admin_modules.php\">module</a>, l'<a href=\"tiki-admin.php?page=siteid\">identité du site</a> ou un template, utiliser {literal}{menu id=x}{/literal}, où x est l'ID du menu.",
"For example, the default icon is: pics/icons/folder.png" => "Exemple, l'icône par défaut est : pics/icons/folder.png",
"The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "Le nom du fichier icône pour les répertoires ouvert est : pics/icons/ofolder.png",
"Available polls" => "Sondages disponibles",
"Random image from" => "Image choisie au hasard de",
"Dynamic content blocks" => "Blocs de contenu dynamique",
"Banner zones" => "Zones de bannière",
"Group users" => "Utilisateurs du groupe",
"Admin Quicktags" => "Administrer les raccourcis",
"Create/Edit QuickTags" => "Créer/modifier un raccourci",
"Quicktags category filter" => "Filtre des raccourcis",
"Insert (use 'text' for figuring the selection)" => "Ajout (utiliser 'text' pour représenter la sélection)",
"Path to the tag icon" => "Chemin d'accès à l'icône",
"Admin RSS Modules" => "Administrer les canaux de syndication RSS",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Cette page permet de configurer les canaux de syndication RSS lus/importés par Tiki. Pour créer/exporter des canaux de syndication RSS, regardez \"Canaux de syndication RSS\" dans le panneau d'administration, ou",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "Pour utiliser une alimentation RSS dans une zone de texte (page Wiki page, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{rss id=x}{/literal}, où x est l'Id de l'alimentation RSS.",
"Create new RSS Module" => "Créer un nouveau module RSS",
"show feed title" => "aff. titre",
"show publish date" => "afficher la date de publication",
"RSS channels" => "Canaux RSS",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Remarque&nbsp;: Vous devez importer vos données de sécurité via le processus d'installation (<a href=\"tiki-install.php\">tiki-install.php</a>). Importez les fichiers *secdb* mis à jour dans votre base de données.",
"Templates compiler" => "Compiler les gabarits",
"Compile" => "Compiler",
"tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "Le nom du formulaire doit être unique, les noms des champs doivent être uniques dans le formulaires et doivent être des noms valides SQL",
"Member of the default group of creator can modify items?" => "Les membres du groupe par défaut du créateur d'une fiche peuvent la modifier ?",
"Group Homepage" => "Page d'accueil du groupe",
"Default category assigned to uncategorized objects edited by a user with this default group" => "Catégorie assignée par défaut aux objets non catégorisés édités par un utilisateur faisant partie du groupe par défaut",
"Group Theme" => "Thème du groupe",
"Members List" => "Liste des membres",
"Updated users" => "Utilisateurs mis à jour",
"Rejected users" => "Utilisateurs refusés",
"Edit Account Settings" => "Modifier la configuration du compte",
"Edit Group" => "Editer le Groupe",
"Validate user" => "Valider l'utilisateur",
"Set the default group of the selected users to" => "Positionner le groupe par défaut des utilisateurs sélectionnés",
"Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth." => "Tikiwiki est configuré pour déléguer la gestion des mots de passe par LDAP via PEAR Auth.",
"Repeat Password" => "Répéter le mot de passe",
"Must Change Password" => "Le mot de passe doit être changé",
"Last Login" => "Dernière authentification",
"Assign User {\$assign_user} to Groups" => "Affecter l'utilisateur {\$assign_user} dans des groupes",
"Default Group" => "Groupe par défaut",
"available files" => "fichiers disponibles",
"Use Wysiwyg Editor" => "Utiliser l'éditeur Wysiwyg",
"Use Normal Editor" => "Utiliser l'éditeur Normal",
"Website" => "Site Web",
"Avanced parameters for iCal export" => "Paramètres avancés pour l'export iCal",
"Old password" => "Ancien mot de passe",
"Parent category" => "Catégorie parente",
"Most visited sub-categories" => "Sous-catégories les plus visitées",
"Category description" => "Description de la catégorie",
"Random sub-categories" => "Sous-catégories choisies au hasard",
"Allow sites in this category" => "Permettre des sites dans cette catégorie",
"Show number of sites in this category" => "Afficher le nombre de sites dans cette catégorie",
"Subcategories" => "Sous-catégories",
"Admin related categories" => "Administrer les catégories en relation",
"Add a related category" => "Ajouter une catégorie en relation",
"Related categories" => "Catégories en relation",
"Add a Category" => "Ajouter une catégorie",
"Add a directory Category" => "Ajouter une catégorie de répertoire ",
"in current category" => "dans la catégorie courante",
"Total categories" => "Nombre total de catégories",
"Creates an indentation for each plus(useful in list to continue at the same level)" => "Ajoute un niveau d'indentation pour chaque plus (utile dans une liste pour pouvoir poursuivre au même niveau)",
"creates the editable drawing foo" => "Créera le dessin éditable foo",
"text, bold" => "texte, gras",
"text, italic" => "texte, italique",
"text, underline" => "texte, souligné",
"table new" => "nouvelle table",
"external link" => "lien externe",
"wiki link'" => "lien wiki'",
"heading1" => "Titre 1",
"title bar" => "barre de titre",
"box" => "boîte",
"rss feed" => "canal de syndication RSS",
"dynamic content" => "contenu dynamique",
"tagline" => "citation",
"horizontal rule" => "ligne horizontale",
"center text" => "centré",
"colored text" => "texte coloré",
"dynamic variable" => "variable dynamique",
"New wms Metadata" => "Nouvelle méta données wms",
"New Class" => "Nouvelle classe",
"New Projection" => "Nouvelle projection",
"New Query" => "Nouvelle requête",
"New Scalebar" => "Nouvelle échelle graphique",
"New Layer" => "Nouvelle couche",
"New Label" => "Nouvelle étiquette",
"New Reference" => "Nouvelle référence",
"New Legend" => "Nouvelle légendé",
"New Web" => "Nouveau Web",
"New Outputformat" => "Nouveau format de sortie",
"New Mapfile" => "Nouveau fichier carte",
"Add image from File Gallery" => "Ajouter une image de la galerie de fichier",
"quote" => "citation",
"flash" => "objet flash",
"Add Image from File Gallery" => "Ajouter une image de la galerie de fichier",
"special chars" => "caractères spéciaux",
"special characters" => "caractères spéciaux",
"Leave Fullscreen Edit" => "Quitter le mode plein écran",
"Fullscreen Edit" => "Edition plein écran",
"Questions per page" => "Nombre de questions par page",
"Language of newly translated page" => "Langue de la nouvelle page traduite",
"Name of newly translated page" => "Nom de la nouvelle page traduite",
"Add existing page as a translation of this page" => "Rattacher une page existante comme traduction de cette page",
"Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Votre session d'édition va expirer dans une minute. Il faut effectuer maintenant une prévisualisation ou une sauvegarde pour ne pas perdre vos modifications.",
"This edit session will expire in {\$edittimeout} minutes" => "Cette session d'édition va expirer dans {\$edittimeout} minutes",
"Activity completed" => "Activité terminée",
"Admin process activities" => "Administrer les activités de processus",
"To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "Pour apprendre plus le <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">workflow Galaxia</a>",
"Add or edit an activity" => "Ajouter/modifier une activité",
"activity" => "activité",
"split" => "découpé",
"join" => "joindre",
"standalone" => "autonome",
"auto routed" => "automatiquement routé",
"Expiration Time" => "Temps d'expiration",
"Years" => "Années",
"Months" => "Mois",
"Add transitions" => "Ajouter une transition",
"No roles associated to this activity" => "Aucun rôle associé à cette activité",
"Add Role" => "Ajouter un rôle",
"Add New" => "Ajouter un nouveau",
"Process activities" => "Activités du processus",
"Routing" => "Routage",
"Automatic" => "Automatique",
"Auto routed" => "Automatiquement routé",
"Manual" => "Manuel",
"(no roles)" => "(aucun rôle)",
"No activities defined yet" => "Aucune activité n'a encore été définie",
"Process Transitions" => "Transitions du processus",
"List of transitions" => "Liste des transitions",
"Origin" => "Origine",
"No transitions defined yet" => "Aucune transition n'a encore été définie",
"Add a transition" => "Ajouter une transition",
"Process Graph" => "Graphe des processus",
"Galaxia Admin Graph" => "Graphe d'administration Galaxia",
"Galaxia Admin Graph tpl" => "Administrer le gabarit de Admin Graph",
"Edit Tpl" => "Modifier le gabarit",
"This process is invalid" => "Ce processus est invalide",
"Process Graph for" => "Graphes des processus pour",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Aucun graphe de processus disponible. Soit le processus contient des erreurs, Soit le graphe n'est pas encore généré, soit <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> n'est pas correctement installé.",
"List of processes" => "Liste des processus",
"Inactive" => "Inactif",
"Active Process" => "Activer le processus",
"Invalid Process" => "Invalider le processus",
"Valid Process" => "Valider le processus",
"Activities" => "Activités",
"New Minor" => "Nouveau mineur",
"New Major" => "Nouveau majeur",
"No processes defined yet" => "Aucun processus n'a encore été défini",
"Admin instance" => "Administrer une instance",
"completed" => "fini",
"Send all to" => "Envoyer à tous",
"Don't move" => "Ne pas déplacer",
"Act status" => "État act.",
"Ended" => "Terminé",
"Not Defined" => "Non défini",
"Not Interactive" => "Non interactive",
"Not Ended" => "Non terminé",
"Property" => "Propriété",
"Add property" => "Ajouter une propriété",
"run instance" => "lancer l'instance",
"Executed" => "Terminé(es)",
"erase" => "effacer",
"Admin processes" => "Administrer les processus",
"Galaxia Admin Processes" => "Administrer les processus Galaxia",
"Galaxia Admin Processes tpl" => "gabarit de l'administration des processus Galaxia",
"Add or edit a process" => "Ajouter/modifier un processus",
"Process Name" => "Nom du processus",
"is active?" => "est actif?",
"Or upload a process using this form" => "Ou afficher le formulaire pour envoyer un processus",
"Admin process roles" => "Administrer les rôles de processus",
"Add or edit a role" => "Ajouter/modifier un rôle",
"Process roles" => "Rôles de processus",
"No roles defined yet" => "Aucun rôle n'a encore été défini",
"Map users to roles" => "Associer un utilisateur à un rôle",
"map" => "associer",
"Map groups to roles" => "Associer un groupe à un rôle",
"Operation" => "Opération",
"No roles are defined yet so no roles can be mapped" => "Aucun rôle n'a été défini, les rôles ne peuvent donc pas être associés",
"List of mappings" => "Liste des associations",
"No mappings defined yet" => "Aucune association définie",
"Admin process sources" => "Administrer les sources de processus",
"select source" => "sélectionner une source",
"Shared code" => "Code partagé",
"Set next user" => "Valider l'utilisateur suivant",
"Get property" => "Récupérer la propriété",
"Set property" => "Valider la propriété",
"Process form" => "Formulaire de processus",
"Set Next act" => "Valider l'activité suivante",
"Switch construct" => "Échanger la construction",
"Map process roles" => "Associer un processus à un rôle",
"Admin Processes" => "Administrer les processus",
"Admin Activities" => "Administrer les activités",
"Admin Roles" => "Administrer les rôles",
"Edit this Process" => "Modifier ce processus",
"Monitor Activities" => "Surveiller les activités",
"Galaxia Monitor Activities" => "Surveiller les activités Galaxia",
"Galaxia Monitor Activities tpl" => "gabarit de la surveillance des activités Galaxia",
"List of activities" => "Liste des activités",
"routing" => "routage",
"run" => "lancer",
"run activity" => "lancer une activité",
"Enter the name of this instance" => "Donner le nom de cette instance",
"The name is not valid. Please, enter the name again" => "Le nom est invalide. SVP, donnez en un autre",
"monitor processes" => "surveiller les processus",
"monitor activities" => "surveiller les activités",
"monitor instances" => "surveiller les instances",
"monitor workitems" => "surveiller les workitems",
"Monitor Instances" => "Surveiller les instances",
"Galaxia Monitor Instances" => "Surveiller les instances Galaxia",
"Galaxia Monitor Instances tpl" => "gabarit de la surveillance des instances Galaxia",
"List of instances" => "Liste des instances",
"Not ended" => "Non terminé",
"No instances created yet" => "Aucune instance n'a encore été créée",
"Monitor Processes" => "Surveiller les processus",
"Galaxia Monitor Processes" => "Surveiller les processus Galaxia",
"Galaxia Monitor Processes tpl" => "gabarit de la surveillance des processus Galaxia",
"processes" => "processus",
"being run" => "en cours d'exécution",
"Monitor workitems" => "Surveiller les workitems",
"List of workitems" => "Liste des workitems",
"Instance Id" => "Id de l'instance",
"Instance Name" => "Nom de l'instance",
"Instance Status" => "État de l'instance",
"Elapsed time" => "Temps écoulé",
"My activities" => "Mes activités",
"Current Activity" => "Activité courante",
"Assigned To" => "Attribué à",
"exception instance" => "instance exception",
"exceptions instance" => "instance exceptions",
"Send Instance" => "Envoyer une instance",
"abort instance" => "interrompre l'instance",
"grab instance" => "prendre l'instance",
"release instance" => "relâcher l'instance",
"No activities found" => "Aucune activité trouvée",
"My instances" => "Mes instances",
"No instances found" => "Aucune instance trouvée",
"User Activities" => "Activités utilisateur",
"Galaxia User Activities" => "Activités utilisateur Galaxia",
"Galaxia User Activities tpl" => "gabarit des activités utilisateur Galaxia",
"process" => "processus",
"No processes defined or activated yet" => "Aucun processus défini ou activé pour l'instant",
"user processes" => "processus utilisateur",
"user activities" => "activités utilisateur",
"user instances" => "instances utilisateur",
"User Instances" => "Instances utilisateur",
"Galaxia User Instances" => "Instances utilisateur Galaxia",
"Galaxia User Instances tpl" => "Gabarit des instances utilisateur Galaxia",
"Inst Status" => "État de l'inst.",
"Not defined" => "Non défini",
"No instances defined yet" => "Aucune instance n'a été définie",
"User Processes" => "Processus utilisateur",
"Galaxia User Processes" => "Processus utilisateur Galaxia",
"Galaxia User Processes tpl" => "gabarit des processus utilisateur Galaxia",
"Browsing Workitem" => "Parcourir le workitem",
"Workitem information" => "Information sur le workitem",
"Install &amp; Update Profile" => "Installer &amp; Mettre à jour un profil",
"Bare-bones default install" => "Installation par défaut à paramétrer",
"Personal Blog and Profile" => "Blogue et profil personnel",
"Small Organization Web Presence" => "Présence web pour petite organisation",
"Company Intranet" => "Intranet d'entreprise",
"Collaborative community" => "Communauté Collaborative",
"Use cache for external pages" => "Utiliser l'antémémoire pour les pages externes",
"All games are from" => "Tous les jeux proviennent de",
"visit the site for more games and fun" => "Visiter le site pour plus de jeux et de plaisir",
"Upload a game" => "Envoyer un jeu",
"Upload a new game" => "Envoyer un nouveau jeu",
"Flash binary (.swf or .dcr)" => "Binaire Flash (.swf or .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Vignette (si le jeu est foo.swf, la vignette doit être appelée foo.swf.gif ou foo.swf.png ou foo.swf.jpg)",
"Edit game" => "Modifier le jeu",
"Played" => "Joué",
"If you can't see the game then you need a flash plugin for your browser" => "Si le jeu ne s'affiche pas à l'écran, vous avez besoin du module d'extension Flash",
"Accepted requests" => "Demandes acceptées",
"since" => "depuis",
"This is an experimental feature" => "Cette fonctionnalité est experimentale",
"My Contacts" => "Mes contacts",
"My Wiki Pages" => "Mes pages Wiki",
"My Galleries" => "Mes galeries",
"My Tracker Items" => "Mes fiches de formulaire",
"Assigned items" => "Fiches attribués",
"My Messages" => "Mes messages",
"My Tasks" => "Mes tâches",
"Select news group" => "Choisir un groupe de news",
"Back to servers" => "Retour au serveur",
"News from" => "Des nouvelles de",
"Back to groups" => "Retour aux groupes",
"Save position" => "Enregistrer la position",
"Reading article from" => "Article lu de",
"Back to list of articles" => "Retour à la liste des articles",
"Configure news servers" => "Configurer les serveurs de news",
"Configure Newsreader" => "Configurer le lecteur de news",
"configure newsreader server tpl" => "gabarit de la configuration de lecteur de news",
"Select a news server to browse" => "Sélectionner un serveur de news à parcourir",
"server" => "serveur",
"Read the news" => "Lire les news",
"Add a news server" => "Ajouter un serveur de news",
"Edit news server" => "Éditer le serveur de news",
"News server" => "Serveur de news",
"View Permissions" => "Voir les permissions",
"To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "Pour attribuer les droits d'accès globaux <a class=\"rbox-link\" href=\"tiki-admingroups.php\">cliquer ici</a>.",
"Current permissions for this object" => "Droits d'accès pour cet objet",
"No individual permissions, category permissions apply" => "Aucune permission individuelle ne s'applique, les permissions sur les catégories s'appliquent",
"Current permissions for categories that this object belongs to" => "Permissions courantes sur les catégories auxquelles cet objet appartient",
"These permissions do not apply. Special permissions apply." => "Ces permissions ne s'appliquent pas. Les permissions spéciales s'appliquent.",
"No category permissions; global permissions apply" => "Aucune permission sur les catégories&nbsp;: les droits globaux s'appliquent",
"No category permissions; special permissions apply" => "Pas de permissions sur les catégories; les permissions spéciales s'appliquent",
"Perms Help" => "Aide pour les droits d'accès",
"Preview of version" => "Aperçu de cette version",
"Source of version" => "Source de cette version",
"Updated from" => "Mis à jour par",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "Attention: mettez le domaine du site en liste blanche dans votre logiciel de mail pour que les courriels du site ne partent pas dans la boîte aux lettres des indésirables!",
"Replicate" => "Réplication",
"Slave" => "Esclave",
"Master" => "Maître",
"Operations" => "Opérations",
"Operations Log" => "Journal des opérations",
"Data HTML" => "Données HTML",
"Data Txt" => "Données Txt",
"Tiki Shoutbox" => "Mégaphone Tiki",
"Click to Navigate" => "Cliquer pour naviguer",
"big grin" => "large sourire",
"cry" => "pleure",
"eek" => "oh!",
"evil" => "diable",
"lol" => "riant fort",
"mr green" => "inexpérimenté",
"razz" => "nargue",
"redface" => "rougissant",
"rolleyes" => "yeux qui tournent",
"smile" => "sourire",
"surprised" => "surpris",
"twisted" => "dingue",
"arrow" => "flèche",
"santa" => "Père Noël",
"Note: Maximum image size is limited to" => "Remarque: la taille maximum de l'image est limitée à",
"Current folder" => "Répertoire courant",
"a URL" => "une URL",
"This user is your friend" => "Cet utilisateur est votre ami",
"Your personal Wiki Page" => "Page Wiki personnelle",
"Your personal tracker information" => "Votre formulaire d'informations personnelles",
"Your preferred language" => "Votre langue préférée",
"Other languages you can read (select on the left to add to the list on the right)" => "Autres langues que vous pouvez lire (sélectionnez à gauche pour ajouter à droite)",
"Confirm new password" => "Confirmer le nouveau mot de passe",
"Current password (required)" => "Mot de passe courant (obligatoire)",
"Edit Items" => "Modifier un item",
"List Charts" => "Liste des palmarès",
"Last Chart" => "Dernier palmarès",
"Previous Chart" => "Palmarès précédent",
"Chart created" => "Palmarès créé",
"Next Chart" => "Palmarès suivant",
"Permanency" => "Stabilité",
"Avg" => "Moy.",
"Next chart will be generated on" => "Le prochain palmarès sera généré le",
"View or vote items not listed in the chart" => "Afficher ou voter pour des items non listés dans le palmarès",
"Select something to vote on" => "Sélectionner pour pouvoir voter",
"Item information" => "Information sur l'item",
"Best Position" => "Meilleure position",
"Vote this item" => "Voter pour cet item",
"Highest" => "Maxi",
"Click to activate" => "Cliquer pour activer",
"Number of voices" => "nombre de voix",
"Your vote" => "Votre vote",
"%s set" => "%s activé",
"%s unset" => "%s désactivé",
"RSS settings" => "Configuration RSS",
"Current version is up to date : <b>%s</b>" => "La version courante est à jour&nbsp;: <b>%s</b>",
"No chart indicated" => "Aucun palmarès indiqué",
"No category indicated" => "Aucune catégorie indiquée",
"Permission denied; you cannot assign permissions for this category" => "Droit d'accès refusé&nbsp;: vous n'avez pas les droits d'attribuer cette catégorie",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Derniers sites du répertoire \".\$rc[\"name\"].\" .",
"Translation in progress." => "Traduction en cours.",
"No process indicated" => "Aucun processus indiqué",
"Role name cannot be empty" => "Le nom de rôle ne peut pas être vide",
"Activity name cannot be empty" => "Le nom de l'activité ne peut pas être vide",
"Activity name already exists" => "Le nom de l'activité existe déjà",
"indicates if the process is active. Invalid processes cant be active" => "indique si le processus est actif. Les processus invalides ne peuvent pas être actifs",
"No instance indicated" => "Aucune instance indiquée",
"No activity indicated" => "Aucune activité indiquée",
"The process name already exists" => "Le nom de processus existe déjà",
"Process already exists" => "Le processus existe déjà",
"Invalid source path" => "Chemin vers la source invalide",
"A start activity requires a name for the instance" => "Une activité initiale a besoin d'un nom d'instance",
"You cant execute this activity" => "Vous ne pouvez pas exécuter cette activité",
"You couldn't abort a instance" => "Vous ne pouvez pas interrompre une instance",
"You couldn't exception a instance" => "Vous ne pouvez pas appliquer une exception sur une instance",
"No title indicated" => "Aucun titre indiqué",
"No comment indicated" => "Aucun commentaire indiqué",
"No date indicated" => "Aucune date indiquée",
"The game file must have .swf or .dcr extension" => "Le jeu doit avoir une extension .swf ou .dcr",
"The thumbnail name must be" => "Le nom de la vignette doit être",
"Please supply both files" => "SVP, fournissez les 2 fichiers",
"Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "SVP, créez un répertoire nommé '.\$prefs['map_path'].' pour organiser les fichiers-cartes.",
"No server indicated" => "Aucun serveur indiqué",
"Cannot connect to" => "Impossible de se connecter à",
"Missing information to read news (server,port,username,password,group) required" => "Informations manquantes pour lire les news (serveur, port, nom utilisateur, mot de passe, groupe) exigées",
"Cannot get messages" => "Impossible de récupérer les messages",
"mail adress" => "adresse électronique",
"A password and your IP address reminder email has been sent " => "Un rappel de votre mot de passe et de votre adresse IP a été envoyé",
"changed '%s' from '%s' to '%s'" => "Modifié&nbsp;: '%s' de '%s' en '%s'",
"\$tpl_module_title" => "\$tpl_module_title",
"Tiki Calendar" => "Calendrier Tiki",
"Admin Menu" => "Menu d'administration",
"RSS Modules" => "Syndication RSS",
"Chat" => "Discussion",
"Import PHPWiki Dump" => "Importer un PHPWiki Dump",
"Tiki Cache/Sys Admin" => "Cache Tiki / Admin Sys",
"Syntax Highlighting" => "Mise en relief de la syntaxe",
"Current events" => "Évènements courants",
"Last `\$module_rows` visitors" => "Derniers `\$module_rows` visiteurs",
"No avatar." => "Aucun avatar.",
"Tiki Logo" => "Logo Tiki",
"RSS Feeds" => "Canaux de syndication RSS",
"User informations" => "Info Utilisateur",
"Group informations" => "Info Groupe",
"You need to activate user and/or group trackers" => "Vous devez activer les formulaires utilisateur et/ou groupe",
"Email This Post" => "envoyer par email cet article",
"RSS feeds" => "Canaux de syndication RSS",
"Use titles in blog posts" => "Utiliser les titres dans les articles de blogue",
"Send blog post" => "Envoyer l'article de blogue",
"Send post to this addresses" => "Envoyer les articles à ces adresses",
"List of email addresses separated by commas" => "Listes des adresses électroniques séparées par une virgule",
"Compose Message" => "Composer un message",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Si vous souhaitez que les autres utilisateurs puissent vous répondre, vous devez vérifier que vous avez sélectionné <a href='tiki-user_preferences.php'>Autoriser des messages d'autres utilisateurs</a>",
"Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Séparez les différents noms d'utilisateurs par des virgules (&nbsp;,&nbsp;).",
"If you use apache, you need a .htaccess file to have this feature working" => "Si vous utilisez If you use apache, you need a .htaccess file to have this feature working",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> supprimé avec succès.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> mis dans le groupe %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> supprimé du groupe %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "le groupe <b>%s</b> est affecté comme groupe par défaut pour l'utilisateur <b>%s</b>.",
"Post recommendation at" => "Un bon article sur",
"Prevent flooding" => "Empêcher les raz-de-marée",
"Minimum time between posts" => "Temps minimum entre 2 publications",
"Moderator user" => "Utilisateur modérateur",
"Moderator group" => "Groupe modérateur",
"Only allow replies to the first message (flat forum)" => "Ne permettre des réponses qu'au dernier message (forum à plat)",
"Send this forums posts to this email" => "Envoyer les articles de ce forum à cette adresse électronique",
"Prune unreplied messages after" => "Éliminer les messages sans réponses après",
"Prune old messages after" => "Éliminer les anciens messages après",
"POP3 server" => "Serveur POP3",
"Max attachment size (bytes)" => "Taille max. des fichiers joints (octets)",
"Default ordering for topics" => "Ordre par défaut des sujets",
"Topics per page" => "Nombre de sujets par page",
"Default ordering for threads" => "Ordre par défaut des fils de discussion",
"Default style for threads" => "Style par défaut des fils de discussion",
"History includes only page data, description, and change comment" => "L'historique n'inclut que les données, la description et les commentaires de modifications",
"Includes" => "Inclut",
"Only directly included" => "Seulement directement inclus",
"will have all the permissions of the included groups" => "aura toutes les authorisations hériter des groupes sélectionnés",
"Assign Perms to this Group" => "Attribuer des permissions à ce groupe",
"Assign permissions to category" => "Attribuer des droits d'accès à une catégorie",
"Current permissions for this category" => "Droits d'accès donnés à cette catégorie",
"Remove from this Category Only" => "Supprimer seulement de cette catégorie",
"Remove from this Category &amp; all its Children" => "Supprimer de cette catégorie &amp; tous ces enfants",
"Assign permissions" => "Attribuer des droits d'accès",
"to group" => "au groupe",
"this category &amp; all its children" => "cette catégorie &amp; et tous ses enfants",
"this category only" => "cette catégorie seulement",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Attribuer les permissions à <b>tous les enfants</b> est recommandé pour une meilleure performance.",
"ERROR: you must include a subject or a message at least" => "ERREUR&nbsp;: vous devez inclure au moins un sujet ou un message",
"Registration code" => "Code d'enregistrement",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "PostgreSQL" => "PostgreSQL",
// "Slovene" => "Slovene",
// "All Day" => "All Day",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki and LDAP" => "Tiki and LDAP",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "Group Alert" => "Group Alert",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Search and replace" => "Search and replace",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Category path" => "Category path",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Local" => "Local",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Object filter" => "Object filter",
// "Pertinence" => "Pertinence",
// "Blog-level" => "Blog-level",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Use thread title instead" => "Use thread title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Top " => "Top ",
// "Proxy host" => "Proxy host",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Random" => "Random",
// "Parse the results" => "Parse the results",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "Wiki top line location" => "Wiki top line location",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "uploaded the file" => "uploaded the file",
// "change" => "change",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "tip" => "tip",
// "comment" => "comment",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "Foo" => "Foo",
// "Face" => "Face",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "url" => "url",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "left|right" => "left|right",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Independant series" => "Independant series",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Maximum Rows" => "Maximum Rows",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "Download button label" => "Download button label",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "googledoc" => "googledoc",
// "Type of Google document" => "Type of Google document",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Margin Height" => "Margin Height",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "groups" => "groups",
// "Groups separated by " => "Groups separated by ",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "Frame title" => "Frame title",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "Structure Head" => "Structure Head",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Related to Find" => "Related to Find",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "articles" => "articles",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace Page" => "MySpace Page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quoted text" => "Quoted text",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "name|desc" => "name|desc",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "Maximum result count" => "Maximum result count",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Item Rank" => "Show Item Rank",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "goIfOne" => "goIfOne",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "User Count" => "User Count",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "Show Stats After" => "Show Stats After",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Registered service name" => "Registered service name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "quality" => "quality",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Can admin external feeds" => "Can admin external feeds",
// "Can list newsletters" => "Can list newsletters",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "View page backlinks" => "View page backlinks",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "feature version checks" => "feature version checks",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "ip can be checked" => "ip can be checked",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "File gallery" => "File gallery",
// "Duplicate permissions" => "Duplicate permissions",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "not in" => "not in",
// "Clear Filter" => "Clear Filter",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "registered at your site" => "registered at your site",
// "Someone" => "Someone",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Last attempt" => "Last attempt",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "A file was attached to %s" => "A file was attached to %s",
// "Confirmation" => "Confirmation",
// "Toggle Vertically" => "Toggle Vertically",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No avatar" => "No avatar",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "CapsLock is on" => "CapsLock is on",
// "What is OpenID" => "What is OpenID",
// "new messages" => "new messages",
// "new message" => "new message",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Up-to-date-ness" => "Up-to-date-ness",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Group information" => "Group information",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "User does not accept messages" => "User does not accept messages",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "You need to set" => "You need to set",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Server performance settings" => "Server performance settings",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "Blogs Listings" => "Blogs Listings",
// "A subset of available calendars" => "A subset of available calendars",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Enable copyright management for" => "Enable copyright management for",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Score is disabled" => "Score is disabled",
// "Gallery Listings" => "Gallery Listings",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Camera settinsg" => "Camera settinsg",
// "No Gallery exists" => "No Gallery exists",
// "Pixels Default" => "Pixels Default",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Visible to admin only" => "Visible to admin only",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Redirects" => "Redirects",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "click here" => "click here",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Validate user's email server" => "Validate user's email server",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group description attribute" => "Group description attribute",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "Valid affiliations" => "Valid affiliations",
// "Themes" => "Themes",
// "Theme Screenshot" => "Theme Screenshot",
// "Slideshow theme" => "Slideshow theme",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Entire location" => "Entire location",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Individual image galleries" => "Individual image galleries",
// "Individual file galleries" => "Individual file galleries",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "The indexation is always updated" => "The indexation is always updated",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Plugin disabled" => "Plugin disabled",
// "rows" => "rows",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "Body Label" => "Body Label",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Switch storage" => "Switch storage",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Allow override per page" => "Allow override per page",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Remove a tag" => "Remove a tag",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Staging" => "Staging",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Pages not in structure" => "Pages not in structure",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "preference" => "preference",
// "preference name" => "preference name",
// "Edit Languages" => "Edit Languages",
// "External Pages Cache" => "External Pages Cache",
// "External Wikis" => "External Wikis",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "See Statistics" => "See Statistics",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Ex" => "Ex",
// "Browse the category system" => "Browse the category system",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin external wikis" => "Admin external wikis",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Admin dynamic zones" => "Admin dynamic zones",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "The following required parameters are missing" => "The following required parameters are missing",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Edit Newsletter" => "Edit Newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "remove" => "remove",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Admin External Feeds" => "Admin External Feeds",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "View feed" => "View feed",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "XML Zip Import" => "XML Zip Import",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Closed" => "Closed",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Manage permissions" => "Manage permissions",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Confirm user email" => "Confirm user email",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Network of Tags related to" => "Network of Tags related to",
// "More Popular Tags" => "More Popular Tags",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "o" => "o",
// "No description" => "No description",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Directory Categories" => "Directory Categories",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Add a Directory Category" => "Add a Directory Category",
// "Max impressions for a user" => "Max impressions for a user",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "2 dashes" => "2 dashes",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Monospace font" => "Monospace font",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Block description: " => "Block description: ",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Select from available options.." => "Select from available options..",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "This edit session will expire in" => "This edit session will expire in",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "the staging copy" => "the staging copy",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Edit page" => "Edit page",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Allow comments on this page" => "Allow comments on this page",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Reset view to default" => "Reset view to default",
// "Reset view to site default" => "Reset view to site default",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall" => "Reinstall",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page aliases found" => "Page aliases found",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Back to admin" => "Back to admin",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "No mods found" => "No mods found",
// "Records" => "Records",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Used to update" => "Used to update",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "Add Structure Pages" => "Add Structure Pages",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "Params" => "Params",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "File title" => "File title",
// "File description" => "File description",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Maximum file size is around" => "Maximum file size is around",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "The column is disabled" => "The column is disabled",
// "a bookmark" => "a bookmark",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "This user is your friend " => "This user is your friend ",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "My user items" => "My user items",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "version" => "version",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Post New" => "Post New",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Group messages" => "Group messages",
// "Part" => "Part",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Clik to delete your vote" => "Clik to delete your vote",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Feeds settings" => "Feeds settings",
// "Kaltura settings" => "Kaltura settings",
// "Object doesn't exists" => "Object doesn't exists",
// "No display" => "No display",
// "You must specify a directory" => "You must specify a directory",
// "Test Image" => "Test Image",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "off" => "off",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Group name can not be empty" => "Group name can not be empty",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Calendar event : " => "Calendar event : ",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Last replied forum topics" => "Last replied forum topics",
// "Invalid software name" => "Invalid software name",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "Note not found" => "Note not found",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You are already logged in" => "You are already logged in",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "A password reminder email has been sent " => "A password reminder email has been sent ",
// "to the email" => "to the email",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "Error: " => "Error: ",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Language watch" => "Language watch",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Plugin modified by editor" => "Plugin modified by editor",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"ID" => "ID",
"Type" => "Type",
"Description" => "Description",
"Afghanistan" => "Afghanistan",
"Angola" => "Angola",
"Anguilla" => "Anguilla",
"Antigua" => "Antigua",
"Aruba" => "Aruba",
"Bahamas" => "Bahamas",
"Bangladesh" => "Bangladesh",
"Belize" => "Belize",
"Botswana" => "Botswana",
"Brunei" => "Brunei",
"Burkina Faso" => "Burkina Faso",
"Burundi" => "Burundi",
"Canada" => "Canada",
"Congo" => "Congo",
"Costa Rica" => "Costa Rica",
"Cuba" => "Cuba",
"Djibouti" => "Djibouti",
"Europe" => "Europe",
"France" => "France",
"Gabon" => "Gabon",
"Ghana" => "Ghana",
"Gibraltar" => "Gibraltar",
"Guadeloupe" => "Guadeloupe",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Guyana" => "Guyana",
"Honduras" => "Honduras",
"Hong Kong" => "Hong Kong",
"Iran" => "Iran",
"Iraq" => "Iraq",
"Jersey" => "Jersey",
"Kazakstan" => "Kazakstan",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Laos" => "Laos",
"Lesotho" => "Lesotho",
"Liechtenstein" => "Liechtenstein",
"Macao" => "Macao",
"Madagascar" => "Madagascar",
"Malawi" => "Malawi",
"Maldives" => "Maldives",
"Mali" => "Mali",
"Martinique" => "Martinique",
"Mayotte" => "Mayotte",
"Monaco" => "Monaco",
"Montserrat" => "Montserrat",
"Mozambique" => "Mozambique",
"Myanmar" => "Myanmar",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Niger" => "Niger",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Oman" => "Oman",
"Pakistan" => "Pakistan",
"Palestine" => "Palestine",
"Panama" => "Panama",
"Paraguay" => "Paraguay",
"Philippines" => "Philippines",
"Portugal" => "Portugal",
"Rwanda" => "Rwanda",
"Samoa" => "Samoa",
"Seychelles" => "Seychelles",
"Sierra Leone" => "Sierra Leone",
"Sri Lanka" => "Sri Lanka",
"St Vincent Grenadines" => "St Vincent Grenadines",
"Swaziland" => "Swaziland",
"Taiwan" => "Taiwan",
"Togo" => "Togo",
"Tokelau" => "Tokelau",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Ukraine" => "Ukraine",
"Uruguay" => "Uruguay",
"Vanuatu" => "Vanuatu",
"Vatican" => "Vatican",
"Venezuela" => "Venezuela",
"Zimbabwe" => "Zimbabwe",
"MySQL classic (mysql)" => "MySQL classic (mysql)",
"Catalan" => "Catalan",
"Fijian" => "Fijian",
"Tuvaluan" => "Tuvaluan",
"Wiki" => "Wiki",
"Articles" => "Articles",
"Forums" => "Forums",
"FAQs" => "FAQs",
"article" => "article",
"faq" => "faq",
"forum" => "forum",
"image" => "image",
"Page" => "Page",
"Contributions" => "Contributions",
"menu" => "menu",
"Section" => "Section",
"Visible" => "Visible",
"Images" => "Images",
"Points" => "Points",
"Tiki" => "Tiki",
"Shibboleth" => "Shibboleth",
"utf-8" => "utf-8",
"iso-8859-1" => "iso-8859-1",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Faqs" => "Faqs",
"Score" => "Score",
"Contribution" => "Contribution",
"FAQ" => "FAQ",
"Copyright" => "Copyright",
"Multimedia" => "Multimedia",
"PHPLayers" => "PHPLayers",
"Shadowbox" => "Shadowbox",
"Ajax" => "Ajax",
"Mobile" => "Mobile",
"Webmail" => "Webmail",
"Intertiki" => "Intertiki",
"Mail-in" => "Mail-in",
"TikiTests" => "TikiTests",
"Mb" => "Mb",
"CRLF (standard)" => "CRLF (standard)",
"geo.position" => "geo.position",
"geo.region" => "geo.region",
"geo.placename" => "geo.placename",
"Port" => "Port",
"Normal" => "Normal",
"minute" => "minute",
"minutes" => "minutes",
"Pages" => "Pages",
"Image" => "Image",
"Forum" => "Forum",
"Article" => "Article",
"Simple" => "Simple",
"information" => "information",
"mins" => "mins",
"min" => "min",
"secs" => "secs",
"sec" => "sec",
"km" => "km",
"wiki" => "wiki",
"forums" => "forums",
"index" => "index",
"%d points" => "%d points",
"Item" => "Item",
"max" => "max",
"jscalendar" => "jscalendar",
"action" => "action",
"multimedia" => "multimedia",
"Message" => "Message",
"Division" => "Division",
"Info" => "Info",
"~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
"Inline" => "Inline",
"Avatar" => "Avatar",
"Float" => "Float",
"1|0" => "1|0",
"Zone" => "Zone",
"Items" => "Items",
"Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
"Types" => "Types",
"Styles" => "Styles",
"Code" => "Code",
"code" => "code",
"on|off" => "on|off",
"Debug" => "Debug",
"Div" => "Div",
"left|right|center|justify" => "left|right|center|justify",
"0|1" => "0|1",
"ftp" => "ftp",
"description" => "description",
"Google Analytics" => "Google Analytics",
"type" => "type",
"Pixels" => "Pixels",
"HTML" => "HTML",
"URL" => "URL",
"Iframe" => "Iframe",
"iframe" => "iframe",
"Stop" => "Stop",
"Jabber" => "Jabber",
"255,255,255" => "255,255,255",
"JQuery" => "JQuery",
"Javascript" => "Javascript",
"txt" => "txt",
".ext" => ".ext",
"Style" => "Style",
"Mini Quiz" => "Mini Quiz",
"Max" => "Max",
"MySpace" => "MySpace",
"%" => "%",
"Information" => "Information",
"Maximum" => "Maximum",
"Date" => "Date",
"SourceForge" => "SourceForge",
"Skype" => "Skype",
"Action" => "Action",
"SQL" => "SQL",
"Tag" => "Tag",
"Original" => "Original",
"Public" => "Public",
"Test" => "Test",
"Mode" => "Mode",
"Versions" => "Versions",
"(version 3)" => "(version 3)",
"(version 2)" => "(version 2)",
"(version 1)" => "(version 1)",
"Table" => "Table",
", " => ", ",
"Youtube" => "Youtube",
"Messages" => "Messages",
"id" => "id",
"desc" => "desc",
"Version" => "Version",
"debug" => "debug",
"Actions" => "Actions",
"Copyrights" => "Copyrights",
"Total" => "Total",
"Archives" => "Archives",
"Tags" => "Tags",
"RSS Wiki" => "RSS Wiki",
"RSS Articles" => "RSS Articles",
"RSS Forums" => "RSS Forums",
"Pan" => "Pan",
"messages" => "messages",
"OK" => "OK",
"Archive" => "Archive",
"Modules" => "Modules",
"Menus" => "Menus",
"Standard" => "Standard",
"[-]" => "[-]",
"pages" => "pages",
"page" => "page",
"URI" => "URI",
"i18n" => "i18n",
"Module" => "Module",
"Performance" => "Performance",
"InterTiki" => "InterTiki",
"Webservices" => "Webservices",
"1 minute" => "1 minute",
"5 minutes" => "5 minutes",
"10 minutes" => "10 minutes",
"15 minutes" => "15 minutes",
"30 minutes" => "30 minutes",
"avatar" => "avatar",
"Distance" => "Distance",
"Experimental" => "Experimental",
"pixels" => "pixels",
"Parent" => "Parent",
"Session" => "Session",
"Contact" => "Contact",
"port" => "port",
"IP" => "IP",
"Wysiwyg" => "Wysiwyg",
"LDAP" => "LDAP",
"Subtree" => "Subtree",
"One level" => "One level",
"Base object" => "Base object",
"LDAP User" => "LDAP User",
"LDAP Group" => "LDAP Group",
"LDAP Admin" => "LDAP Admin",
"CAS" => "CAS",
"Version 1.0" => "Version 1.0",
"Version 2.0" => "Version 2.0",
"Direction" => "Direction",
"Vertical" => "Vertical",
"Horizontal" => "Horizontal",
"image/png" => "image/png",
"image/bmp" => "image/bmp",
"image/x-icon" => "image/x-icon",
"Robots" => "Robots",
"Admin &gt; Modules" => "Admin &gt; Modules",
"Expiration" => "Expiration",
"Plugins" => "Plugins",
"Validation" => "Validation",
"Argument" => "Argument",
"Quota (Mb)" => "Quota (Mb)",
"Structures" => "Structures",
"Configuration" => "Configuration",
"TikiCache/System" => "TikiCache/System",
"phpinfo" => "phpinfo",
"Mods" => "Mods",
"DSN" => "DSN",
"kb" => "kb",
"contribution" => "contribution",
"mns" => "mns",
"Sections" => "Sections",
"Loc" => "Loc",
"Participants" => "Participants",
"Cat" => "Cat",
"Lang" => "Lang",
"Prio" => "Prio",
"Perso" => "Perso",
"h" => "h",
"Orange" => "Orange",
"cookie" => "cookie",
"Coms" => "Coms",
"..." => "...",
"zone" => "zone",
"Regex" => "Regex",
"Position" => "Position",
"mn" => "mn",
"option" => "option",
"Options" => "Options",
"Multiple" => "Multiple",
"Votes" => "Votes",
"uid" => "uid",
"gid" => "gid",
"suid" => "suid",
"sgid" => "sgid",
"r" => "r",
"w" => "w",
"PDF" => "PDF",
"XML Zip" => "XML Zip",
"Alias" => "Alias",
"Question" => "Question",
"Questions" => "Questions",
"UTF-8" => "UTF-8",
"ISO-8859-1" => "ISO-8859-1",
"bcc" => "bcc",
"Source" => "Source",
"TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
"\$feature_label" => "\$feature_label",
"RSS" => "RSS",
"popup" => "popup",
"+" => "+",
"occurrences" => "occurrences",
"Contacts" => "Contacts",
"Structure" => "Structure",
"Sites" => "Sites",
"cType" => "cType",
"Client" => "Client",
"ex" => "ex",
"Indentation" => "Indentation",
"col" => "col",
"Option" => "Option",
"points" => "points",
"Page alias" => "Page alias",
"Important" => "Important",
"votes" => "votes",
"Format" => "Format",
"normal" => "normal",
"question" => "question",
"Imgs" => "Imgs",
"Portrait" => "Portrait",
"Installation" => "Installation",
"MultiTiki" => "MultiTiki",
"Documentation" => "Documentation",
"v" => "v",
"Img" => "Img",
"Impressions" => "Impressions",
"Modifications" => "Modifications",
"Distance (km)" => "Distance (km)",
"Vers." => "Vers.",
"Lang." => "Lang.",
"Xml Zip" => "Xml Zip",
"msgs" => "msgs",
"Prefs" => "Prefs",
"Attention" => "Attention",
"licence" => "licence",
"quota" => "quota",
"s=source" => "s=source",
"Site" => "Site",
"tikiwiki.org" => "tikiwiki.org",
"octets" => "octets",
"Config" => "Config",
"#" => "#",
"act" => "act",
"top" => "top",
"(non public)" => "(non public)",
"taskId" => "taskId",
"Pos" => "Pos",
"pts" => "pts",
"Cc" => "Cc",
"CC" => "CC",
"BCC" => "BCC",
"Latitude" => "Latitude",
"Longitude" => "Longitude",
"Administration" => "Administration",
"beige" => "beige",
"Date (desc)" => "Date (desc)",
"Date (asc)" => "Date (asc)",
"Score (desc)" => "Score (desc)",
"TOP" => "TOP",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Cette fonctionnalité est désactivée",
"Permission denied. You cannot view pages" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas afficher de pages",
"For you to vote, cookies must be allowed" => "Les cookies doivent être autorisés pour pouvoir voter",
"This forum is flat and doesn't allow replies to other replies" => "Ce Forum ne permet répondre individuellement aux réponses.",
"This script cannot be called directly" => "Ce script ne peut pas être appelé directement",
"The copyright management feature is not enabled." => "La fonctionnalité copyright n'est pas activée.",
"Copyright management" => "Gestion du copyright",
"No page indicated" => "Aucune page indiquée",
"You must supply all the information, including title and year." => "Vous devez fournir toutes les informations, y compris titre et année.",
"You do not have permission to use this feature" => "Vous n'avez pas le droit d'utiliser cette fonctionnalité.",
"This feature is for admins only" => "Cette fonctionnalité est réservée aux administrateurs",
"Name" => "Nom",
"Size" => "Taille",
"Created" => "Créé",
"Uploaded" => "Envoyé",
"Last Modified" => "Dernière modification",
"Creator" => "Créateur",
"Author" => "Auteur",
"Last editor" => "Dernier éditeur",
"Comment" => "Commentaire",
"Files" => "Fichiers",
"Hits" => "Visites",
"Locked by" => "Verrouillé par",
"Explorer" => "Explorateur",
"Path" => "Chemin d'accès",
"Slideshow" => "Diaporama",
"Default View" => "Vue par défaut",
"Aland Islands" => "Îles Aland",
"Albania" => "Albanie",
"Algeria" => "Algérie",
"American Samoa" => "Samoa",
"Andorra" => "Andorre",
"Argentina" => "Argentine",
"Armenia" => "Arménie",
"Australia" => "Australie",
"Austria" => "Autriche",
"Azerbaijan" => "Azerbaïdjan",
"Bahrain" => "Bahreïn",
"Barbados" => "Barbade",
"Belarus" => "Biélorussie",
"Belgium" => "Belgique",
"Benin" => "Bénin",
"Bermuda" => "Bermudes",
"Bhutan" => "Bhoutan",
"Bolivia" => "Bolivie",
"Bosnia and Herzegovina" => "Bosnie-Herzégovine",
"Bouvet Island" => "Île Bouvet",
"Brazil" => "Brésil",
"British Indian Ocean Territory" => "Territoire britannique de l'océan Indien",
"British Virgin Islands" => "Îles Vierges britanniques",
"Bulgaria" => "Bulgarie",
"Cambodia" => "Cambodge",
"Cameroon" => "Cameroun",
"Cape Verde" => "Cap-Vert",
"Catalan Countries" => "Pays_catalans",
"Cayman Islands" => "Îles Caïmans",
"Central African Republic" => "République centrafricaine",
"Chad" => "Tchad",
"Chile" => "Chili",
"China" => "Chine",
"Christmas Island" => "Île Christmas",
"Cocos Islands" => "Île Cocos",
"Colombia" => "Colombie",
"Comoros" => "Comores",
"Congo Democratic" => "Congo démocratique",
"Cook Islands" => "Îles Cook",
"Croatia" => "Croatie",
"Cyprus" => "Chypre",
"Czech Republic" => "République tchèque",
"Denmark" => "Danemark",
"Dominica" => "Dominique",
"Dominican Republic" => "République dominicaine",
"Ecuador" => "Equateur",
"Egypt" => "Egypte",
"El Salvador" => "Salvador",
"Equatorial Guinea" => "Guinée équatoriale",
"Eritrea" => "Erythrée",
"Estonia" => "Estonie",
"Ethiopia" => "Ethiopie",
"Falkland Islands" => "Îles Malouines",
"Faroe Islands" => "Îles Féroé",
"Federated States of Micronesia" => "États fédérés de Micronésie",
"Fiji" => "Fidji",
"Finland" => "Finlande",
"French Guiana" => "Guyane",
"French Polynesia" => "Polynésie française",
"French Southern Territories" => "Terres australes et antarctiques françaises",
"Gambia" => "Gambie",
"Georgia" => "Géorgie",
"Germany" => "Allemagne",
"Greece" => "Grèce",
"Greenland" => "Groenland",
"Grenada" => "Grenade",
"Guernsey" => "Guernesey",
"Guinea" => "Guinée",
"Guinea Bissau" => "Guinée-Bissao",
"Haiti" => "Haïti",
"Heard Island and McDonald Islands" => "Île Heard et îles McDonald",
"Hungary" => "Hongrie",
"Iceland" => "Islande",
"India" => "Inde",
"Indonesia" => "Indonésie",
"Ireland" => "Irlande",
"Isle of Man" => "Ile de Man",
"Israel" => "Israël",
"Italy" => "Italie",
"Ivory Coast" => "Côte d'Ivoire",
"Jamaica" => "Jamaïque",
"Japan" => "Japon",
"Jordan" => "Jordanie",
"Kuwait" => "Koweït",
"Kyrgyzstan" => "Kirghizistan",
"Latvia" => "Lettonie",
"Lebanon" => "Liban",
"Liberia" => "Libéria",
"Libya" => "Libye",
"Lithuania" => "Lituanie",
"Luxemburg" => "Luxembourg",
"Macedonia" => "Macédoine",
"Malaysia" => "Malaisie",
"Malta" => "Malte",
"Marshall Islands" => "Îles Marshall",
"Mauritania" => "Mauritanie",
"Mauritius" => "Mauritanie",
"Mexico" => "Mexique",
"Moldova" => "Moldavie",
"Mongolia" => "Mongolie",
"Montenegro" => "Monténégro",
"Morocco" => "Maroc",
"Namibia" => "Namibie",
"Nepal" => "Népal",
"Netherlands" => "Pays-Bas",
"Netherlands Antilles" => "Antilles néerlandaises",
"New Caledonia" => "Nouvelle_Calédonie",
"New Zealand" => "Nouvelle_Zélande",
"None" => "Aucun",
"Norfolk Island" => "Île Norfolk",
"Northern Mariana Islands" => "Îles Mariannes du Nord",
"North Korea" => "Corée du Nord",
"Norway" => "Norvège",
"Other" => "Autre",
"Palau" => "Palaos",
"Papua New Guinea" => "Papouasie - Nouvelle - Guinée",
"Peru" => "Pérou",
"Pitcairn" => "Îles Pitcairn",
"Poland" => "Pologne",
"Puerto Rico" => "Porto Rico",
"Quatar" => "Qatar",
"Republic of Macedonia" => "République de Macédoine",
"Reunion" => "Réunion",
"Romania" => "Roumanie",
"Russia" => "Russie",
"Saint Helena" => "Sainte-Hélène",
"Saint Kitts and Nevis" => "Saint-Christophe-et-Niévès",
"Saint Lucia" => "Sainte-Lucie",
"Saint Pierre and Miquelon" => "Saint Pierre et Miquelon",
"San Marino" => "Saint-Marin",
"Sao Tome and Principe" => "São Tomé-et-Principe",
"Saudi Arabia" => "Arabie Saoudite",
"Senegal" => "Sénégal",
"Serbia" => "Serbie",
"Singapore" => "Singapour",
"Slovakia" => "Slovaquie",
"Slovenia" => "Slovénie",
"Solomon Islands" => "Îles Salomon",
"Somalia" => "Somalie",
"South Africa" => "Afrique du Sud",
"South Georgia and South Sandwich Islands" => "Géorgie du Sud et les îles Sandwich du Sud",
"South Korea" => "Corée du Sud",
"Spain" => "Espagne",
"Sudan" => "Soudan",
"Surinam" => "Suriname",
"Svalbard and Jan Mayen" => "Svalbard et Jan Mayen",
"Sweden" => "Suède",
"Switzerland" => "Suisse",
"Syria" => "Syrie",
"Tajikistan" => "Tadjikistan",
"Tanzania" => "Tanzanie",
"Thailand" => "Thaïlande",
"Timor-Leste" => "Timor oriental",
"Trinidad Tobago" => "Trinité-et-Tobago",
"Tunisia" => "Tunisie",
"Turkey" => "Turquie",
"Turkmenistan" => "Turkménistan",
"Turks and Caicos Islands" => "Îles Turques et Caïques",
"Uganda" => "Ouganda",
"United Arab Emirates" => "Émirats arabes unis",
"United Kingdom" => "Royaume-Uni",
"United Nations Organization" => "Organisation des Nations Unies",
"United States" => "États-Unis",
"United States Minor Outlying Islands" => "Îles mineures éloignées des États-Unis",
"US Virgin Islands" => "Îles Vierges américaines",
"Uzbekistan" => "Ouzbékistan",
"Viet Nam" => "Viêt Nam",
"Wales" => "Pays de Galles",
"Wallis and Futuna" => "Wallis-et-Futuna",
"Western Sahara" => "Sahara occidental",
"World" => "Monde",
"Yemen" => "Yémen",
"Yugoslavia" => "Yougoslavie",
"Zambia" => "Zambie",
"MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Nécessite MySQL 4.1+",
"Email address not valid, test mail not sent" => "Email non valide, l'email de test n'a pas été envoyé",
"Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email et aucune copy ne sont définis, l'email de test n'a pas été envoyé",
"Test mail from Tiki installer " => "Test d'email provenant de l'installeur Tiki ",
"Tiki version:" => "Version de Tiki :",
"PHP version:" => "Version PHP :",
"Server:" => "Serveur :",
"Sent:" => "Envoyé :",
"Congratulations!\n\nYour server can send emails.\n\n" => "Félicitation !\n\nVotre serveur peut envoyer des emails.\n\n",
"Arabic" => "Arabe",
"Simplified Chinese" => "Chinois simp.",
"Chinese" => "Chinois",
"Czech" => "Tchèque",
"Danish" => "Danois",
"German" => "Allemand",
"English" => "Anglais",
"English British" => "Britannique",
"Spanish" => "Espagnol",
"Greek" => "Grec",
"Farsi" => "Persan",
"Finnish" => "Finnois",
"French" => "Français",
"Galician" => "Galicien",
"Hebrew" => "Hébreu",
"Croatian" => "Croate",
"Italian" => "Italien",
"Japanese" => "Japonais",
"Korean" => "Coréen",
"Hungarian" => "Hongrois",
"Dutch" => "Hollandais",
"Norwegian" => "Norvégien",
"Polish" => "Polonais",
"Português" => "Portugais",
"Brazilian Portuguese" => "Brésilien",
"Russian" => "Russe",
"Pijin Solomon" => "Pidgin des Îles des Salomons",
"Slovak" => "Slovaque",
"Serbian" => "Serbe",
"Serbian Latin" => "Serbe latin",
"Swedish" => "Suédois",
"Traditional Chinese" => "Chinois trad.",
"Ukrainian" => "Ukrainien",
"Permission denied" => "Droit d'accès refusé",
"Template %s not registered" => "Gabarit %s non enregistré",
"The file is not a CSV file or has not a correct syntax" => "Le fichier n'est pas un fichier CSV ou la syntaxe est incorrecte",
"Error line: %d" => "Erreur à la ligne&nbsp;: %d",
"locked" => "verrouillé",
"locked by" => "verrouillé par",
"in" => "dans",
"continued" => "se continue",
"New Image Uploaded by" => "Nouvelle image envoyée par",
"New Subscriptions" => "Nouvelles inscriptions",
"New Item in Tracker" => "Nouvelle fiche dans les formulaires",
"tracker" => "formulaire",
"by" => "par",
"Image Gallery" => "Galerie d'images",
"Blogs" => "Blogues",
"Directory" => "Répertoire des liens",
"File Gallery" => "Galerie de fichiers",
"Quizzes" => "QCMs",
"Trackers" => "Formulaires",
"Survey" => "Enquête",
"Newsletter" => "Lettre d'informations",
"blog" => "blogue",
"directory" => "répertoire des liens",
"file gallery" => "galerie de fichiers",
"image gallery" => "galerie d'images",
"newsletter" => "lettre d'informations",
"poll" => "sondage",
"quiz" => "QCM",
"survey" => "enquête",
"wiki page" => "page wiki",
"calendar" => "calendrier",
"Invalid filename (using filters for filenames)" => "Nom de fichier invalide (le nom ne répond pas aux filtres)",
"Cannot upload this file - maximum upload size exceeded" => "Envoi du fichier impossible - taille maximale dépassée",
"(not registered)" => "(non enregistré)",
"Anonymous" => "Anonyme",
"You have mistyped the anti-bot verification code; please try again." => "Vous avez mal tapé le code de vérification anti-bot; recommencez SVP",
"Please wait %d seconds between posts" => "Veuillez patienter %d secondes entre les posts",
"Wrong password. Cannot post comment" => "Mot de passe incorrect. Vous ne pouvez pas publier un commentaire",
"A contribution is mandatory" => "Une contribution est obligatoire",
"You have to enter a title and text" => "Vous devez saisir un titre et du texte",
"Invalid Email" => "Adresse mail invalide",
"Your message has been queued for approval and will be posted after a moderator approves it." => "Votre message a été mis en attente de validation. Il sera affiché après validation par le modérateur.",
"This forum is locked" => "Ce forum est verrouillé",
"This thread is locked" => "Ce fil de discussion est verrouillé",
"Those comments are locked" => "Ces commentaires sont verrouillés",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: nombre de lignes différent: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check&nbsp;: a échoué",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check&nbsp;: séquence de modification non optimale",
"WikiDiff Okay: LCS = %s" => "WikiDiff OK: LCS = %s",
"Newsletter subscription information at" => "Les informations concernant la lettre d'information sont disponibles à ",
"Tiki Link - Insert internal link" => "Tiki Link - Insérer un lien interne",
"Find" => "Trouver",
"find" => "trouver",
"prev" => "précédent",
"next" => "suivant",
"Link" => "Lien",
"Page name" => "Nom de la page",
"File Galleries" => "Galeries de fichiers",
"This is the value of your server's PHP '%s' setting" => "Valeur du paramètre '%s' du serveur PHP",
"You are alerted by the server " => "Alerte du serveur ",
"You can check the modifications at : " => "Vous pouvez accéder à la modification à l'adresse ",
"You are alerted of a change on " => "Vous êtes alerté d'un changement sur ",
"Wiki Home" => "Accueil-Wiki",
"Home" => "Accueil",
"Blog" => "Blogue",
"previous page" => "page précédente",
"next page" => "page suivante",
"posted on" => "publié le",
"Continue" => "Continuer",
"Read" => "Lu",
"List articles" => "Liste des articles",
"Last post" => "Dernière publication",
"Invalid imagename (using filters for filenames)" => "Nom d'image invalide (avec les filtres pour les noms de fichiers)",
"Errors detected" => "Erreurs détectées",
"Upload was not successful" => "L'envoi s'est mal passé",
"No image yet, sorry." => "Pas encore d'images, désolé.",
"unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "Répertoire cible inconnu. SVP le configurez dans <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
"unlink failed" => "unlink a échoué",
"No valid ogr2ogr executable" => "Aucun exécutable ogr2ogr valide",
"Could not create \$tdo.mif in data directory" => "Ne peut pas créer \$tdo.mif dans ce répertoire",
"Could not create \$tdo.mid in data directory" => "Ne peut pas créer \$tdo.mid dans ce répertoire",
"unknown" => "inconnu",
"NONE" => "AUCUN",
"File %s not found" => "Fichier %s non trouvé",
"File %s is not a valid archive" => "Le fichier %s n'est pas une archive valide",
"Impossible to open %s : %s" => "Impossible d'ouvrir %s&nbsp;: %s",
"The content retrieved at %s is not a list of mods" => "Le contenu recupéré à %s n'est pas une liste de Mods",
"Can't chdir to '%s'" => "Ne peut pas aller dans le répertoire '%s' (chdir)",
"%s impossible to remove" => "Impossible d'effacer %s",
"Language" => "Langue",
"Theme" => "Thème",
"Rows" => "Nb max. de rangées (si applicable au module)",
"section edit" => "édition de la section",
"This poll is closed." => "Ce sondage est fermé.",
"Users accept internal messages by default" => "Les utilisateurs acceptent les messages internes par défaut",
"Users can opt-out internal messages" => "Les utilisateurs peuvent désélectionner les messages internes",
"Title" => "Titre",
"Title length" => "Longueur du titre",
"Topic" => "Sujet",
"Publication date" => "Date de publication",
"Expiration date" => "Date d'expiration",
"Rating" => "Cote",
"Reads" => "Lectures",
"Default number per page" => "Nombre de commentaire par page par défaut",
"Default Ordering" => "Tri par défaut",
"Newest first" => "Le plus récent d'abord",
"Oldest first" => "Le plus vieux d'abord",
"Authentication method" => "Méthode d'authentification",
"Tiki and OpenID" => "Tiki et OpenID",
"Tiki and PAM" => "Tiki et l'authentification PAM",
"CAS (Central Authentication Service)" => "CAS (Service Centralisé d'Authentification)",
"Web Server" => "Serveur Web",
"Available languages" => "Langues disponibles",
"Creation date (desc)" => "Date de création (desc)",
"Last modification date (desc)" => "Date de dernière modification (desc)",
"Blog title (asc)" => "Titre du blogue (asc)",
"Number of posts (desc)" => "Nombre d'articles (desc)",
"Visits (desc)" => "Visites (desc)",
"Activity (desc)" => "Activité (desc)",
"Disabled" => "Désactivée",
"Plain text" => "Texte en clair",
"Link to user information" => "Lien vers les informations utilisateur",
"User avatar" => "Avatar utilisateur",
"Users can change site language" => "Les utilisateurs peuvent changer la langue du site",
"Spell checking" => "Correction orthographique",
"Contact user" => "Utilisateur du contact",
"Count admin pageviews" => "Compter les affichages de pages d'administration",
"Default charset for sending mail" => "Charset par défaut pour les emails sortant",
"default mapfile" => "fichier-carte par défaut",
"Show Country Flag" => "Afficher les drapeaux des pays",
"Validate URLs" => "Tester la validité des adresses Web",
"Links per page" => "Liens par page",
"Method to open directory links" => "Méthode pour ouvrir les liens du répertoire",
"replace current window" => "remplacer la fenêtre courante (r)",
"new window" => "nouvelle fenêtre",
"inline frame" => "cadre dans la fenêtre (i)",
"No error reporting" => "Rapport d'erreurs désactivé",
"Report all PHP errors" => "Signaler toutes les erreurs PHP",
"Default number of comments per page" => "Nb. max. de commentaires par page",
"Comments default ordering" => "Ordre par défaut des commentaires",
"Question and Answer prefix on Answers" => "Préfixes aux questions et réponses dans la partie réponses",
"Q and A" => "Q et R",
"Question ID" => "Numéro de la question",
"Polls" => "Sondages",
"Newsletters" => "Lettres d'informations",
"Calendar" => "Calendrier",
"Banners" => "Bannières",
"Category" => "Catégorie",
"Search" => "Recherche",
"Freetags" => "Mots clés",
"Action Log" => "Journal des actions",
"Multilingual" => "Multilingue",
"Surveys" => "Enquêtes",
"Featured links" => "Liens vedette",
"Shoutbox" => "Mégaphone",
"Maps" => "Cartes",
"Google Maps" => "Carte Google",
"Live support system" => "Système d'assistance en ligne",
"Tell a Friend" => "Dire à un ami",
"HTML pages" => "Pages HTML",
"Contact Us" => "Nous contacter",
"Allow posting of comments as Anonymous" => "Autoriser de poster des commentaires en tant qu'Anonyme",
"HTML Purifier" => "Purificateur HTML",
"Morcego 3D browser" => "Navigateur 3D Morcego",
"Wysiwyg editor" => "Éditeur Wysiwyg",
"Ajax auto-save" => "Enregistrement automatique Ajax",
"Save draft" => "Sauvegarder en brouillon",
"Friendship Network" => "Réseau des amis",
"Banning system" => "Système d'interdiction",
"Stats" => "Statistiques",
"Referer Stats" => "Statistiques des origines",
"Redirect On Error" => "Re-direction en cas d'erreur",
"Communications (send/receive objects)" => "Communications (envoyer/recevoir des objets)",
"Custom Home" => "Page d'accueil personnalisée",
"Mini Calendar" => "Mon calendrier",
"User Preferences Screen" => "Écrans des préférences utilisateur",
"User Notepad" => "Bloc-note utilisateur",
"User Bookmarks" => "Signets utilisateur",
"User Contacts" => "Contacts utilisateur",
"User Watches" => "Mes notifications de changement",
"User Watches Translations" => "Notification par email des changements dans un jeu de traduction",
"User Menu" => "Menu utilisateur",
"User Tasks" => "Tâches utilisateur",
"User Messages" => "Messages utilisateur",
"User Files" => "Fichiers utilisateur",
"User Levels" => "Niveaux Utilisateurs",
"Integrator" => "Intégrateur",
"XMLRPC API" => "API XMLRPC",
"Debugger Console" => "Console de debug",
"Check for updates automatically" => "Vérifier les mises à jour automatiquement",
"TikiWiki will check for updates when you access the main Administration page" => "TikiWiki va vérifier la présence de mises à jour lorsque vous accèderez à la page principale du menu d'administration",
"Use PEAR::Date library" => "Utiliser la bibliothèque PEAR::Date",
"Require confirmation if possible CSRF detected" => "Nécessite une confirmation si une attaque CSRF est détectée",
"Protect against CSRF with a ticket" => "Se protéger contre le Sea surfing(CSRF) avec des tickets",
"Detect browser language" => "Utiliser la préférence langue du navigateur",
"Translation assistant" => "Assistant de traduction",
"Urgent translation notifications" => "Notification d'une traduction urgente",
"Multilingual structures" => "Structures multilingues",
"GZip output" => "Activer la compression GZip des pages",
"Help System" => "Système d'aide",
"Smileys" => "Frimousses",
"Dynamic Content System" => "Système de contenu dynamique",
"External link icon" => "Icône des liens externes",
"Semantic links" => "Liens sémantiques",
"Display menus as folders" => "Afficher les icônes des menus comme des répertoires",
"Anonymous editors must enter anti-bot code (CAPTCHA)" => "Les éditeurs anonymes doivent saisir un code de vérification anti-bot (CAPTCHA)",
"Protect email against spam" => "Protéger les adresses mails contre les spammeurs",
"Activate" => "Activer",
"Comments" => "Commentaires",
"Submissions" => "Soumissions",
"Rankings" => "Classements",
"Content templates" => "Gabarits de contenu",
"Print" => "Imprimer",
"Specify notification emails when creating articles" => "Définir l'email de notification lors de la création d'article",
"Show category objects" => "Montrer les objets de la catégorie",
"Use PHPLayers for category browser" => "Utiliser PHPLayers pour parcourir les categories",
"Ignore category viewing restrictions" => "Ignorer les restrictions d'affichage sur les catégories",
"List pages" => "Liste des pages",
"Last changes" => "Dernières modifications",
"Orphan pages" => "Pages orphelines",
"Database search" => "Recherche base de données",
"Referer Search Highlighting" => "Mise en relief de la chaîne recherchée",
"Search stats" => "Statistiques des recherches",
"Ignore individual object permissions" => "Ignorer les droits individuels sur les objets",
"Search box" => "Boite de recherche",
"Visits" => "Visites",
"Object type" => "Type de l'objet",
"Last modified date" => "Date de la dernière modification",
"Batch uploading" => "Téléchargement par lot",
"Accept wiki syntax" => "Accepter la syntaxe Wiki",
"Store password as plain text" => "Stocker les mots de passe comme du texte",
"tikihash (old)" => "hashtiki (vieux)",
"Display 'MyTiki' in the application menu" => "Affiche 'MonTiki' dans le menu application",
"Show user's contribution on the user information page" => "Afficher les contributions de l'utilisateur sur ca page d'information",
"Permission to all (not just any) of an object's categories is required for access" => "Le droit d'accès à un objet nécessite les permissions sur toutes (pas seulement l'une d'entre elles) des catégories associées à un objet (ex catégories renforcées)",
"Require file author's name for anonymous uploads" => "Nécessite le nom de l'auteur pour les téléchargements en anonyme",
"Podcast directory" => "Répertoire des Podcasts",
"The server must be able to read/write the directory." => "Le serveur web doit avoir les droits en lecture écriture sur le répertoire.",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "Si vous autorisez le téléchargement par lots, il vous faudra définir un répertoire accessible en lecture depuis le web (en-dehors de votre espace web serait mieux). Ensuite, prévoir un moyen pour télécharger des fichiers vers ce répertoire (par scp, ftp ou d'autres protocoles).",
"The server must be able to read the directory." => "Le serveur web doit avoir les droits en lecture sur le répertoire.",
"The directory can be outside the web space." => "Le répertoire peut être en-dehors de l'espace web",
"Allow download limit per file" => "Autoriser la restriction du nombre de téléchargement par fichier",
"Allow same file to be uploaded more than once" => "Permettre à un même fichier d'être envoyé plusieurs fois",
"Never" => "Jamais",
"Yes, even in the same gallery" => "Oui, aussi dans la même galerie",
"Only in different galleries" => "Seulement dans des galeries différentes",
"Must match" => "Doit correspondre à ",
"Cannot match" => "Ne doit pas correspondre à ",
"Uploaded filenames must match regex" => "Les noms de fichiers envoyés doivent correspondre aux expressions régulières",
"Default style" => "Style par défaut",
"Plain" => "À plat",
"Threaded" => "Emboîté",
"Headers Only" => "En-têtes seulement",
"Default sort mode" => "Mode de tri par défaut",
"Title (desc)" => "Titre (desc)",
"Title (asc)" => "Titre (asc)",
"Topics" => "Sujets",
"Posts" => "Articles",
"Posts per day" => "Publications par jour",
"Description length" => "Taille de la description",
"Do not prefix messages titles by 'Re: '" => "Ne pas préfixer les titres des messages par 'Re&nbsp;: '",
"Default ordering" => "Tri par défaut",
"Creation Date (asc)" => "Date de Création (asc)",
"Creation Date (desc)" => "Date de création (desc)",
"Topics (desc)" => "Sujets (desc)",
"Threads (desc)" => "Fils de discussion (desc)",
"Last post (desc)" => "Dernier article (desc)",
"Name (desc)" => "Nom (desc)",
"Name (asc)" => "Nom (asc)",
"Browser title" => "Titre des fenêtres",
"Home page" => "Page d'accueil",
"Use group homepages" => "Utiliser les pages d'accueil de groupe",
"Go to group homepage only if login from default homepage" => "Aller à la page d'accueil du groupe seulement si connecté depuis la page d'accueil par défaut",
"Default language" => "Langue par défaut",
"Cache external pages" => "Mettre les pages externes en cache",
"Cache external images" => "Mettre les images externes en cache",
"Temporary directory" => "Répertoire temporaire",
"Help URL" => "URL de l'aide",
"Open external links in new window" => "Ouvrir les liens externes dans une nouvelle fenêtre",
"Submit notice" => "Soumettre une notice",
"Full path to gdaltindex" => "Chemin d'accès complet à gdaltindex",
"Full path to ogr2ogr" => "Chemin d'accès à ogr2ogr",
"Map Zone" => "Zone carte",
"Display modules to all groups always" => "Toujours afficher les modules à tous les groupes",
"Hide anonymous-only modules from registered users" => "Cacher aux utilisateurs inscrits les modules assignés aux utilisateurs anonymes",
"Maximum number of articles on articles home page" => "Nombre maximum d'articles afficher sur la page d'accueil des articles",
"Content" => "Contenu",
"Remind/forgot password" => "Rappel du mot de passe / mot de passe perdu",
"Use database for translation" => "Utiliser la base de données pour les traductions",
"Maximum average server load threshold in the last minute" => "Seuil maximum de charge du serveur dans la dernière minute",
"Log mail in Tiki logs" => "Noter les emails dans les journaux Tiki",
"Add HTML comment at start and end of each Smarty template (TPL)" => "Ajouter des commentaires HTML au début et à la fin de chaque modèle Smarty (TPL)",
"Log SQL" => "Journaux SQL",
"This may impact performance" => "Peut avoir un impact sur les performances",
"Mail end of line" => "Caractère de fin d'email",
"LF (some Unix MTA)" => "LF (certains MTA Unix)",
"full path to mapfiles" => "Chemin d'accès complet aux fichiers-carte",
"Wiki Page for Help" => "Page Wiki d'aide",
"Wiki Page for Comments" => "Page Wiki des commentaires",
"Maximum mailbox size (messages, 0=unlimited)" => "Taille maximum d'une boîte à lettres (messages, 0=illimité)",
"Maximum mail archive size (messages, 0=unlimited)" => "Taille maximum d'une archive de boîte à lettres (messages, 0=illimité)",
"Maximum sent box size (messages, 0=unlimited)" => "Taille maximum d'une boîte à lettres de messages envoyés (messages, 0=illimité)",
"Keywords" => "Mot(s) clé(s)",
"Include freetags" => "Inclure les mots clés",
"Use image title instead" => "Utiliser le titre de l'image à la place",
"Wiki buttons" => "Boutons Wiki",
"Bottom" => "Bas",
"Neither" => "Aucun",
"Show categories" => "Montrer les catégories",
"Show objects" => "Montrer les objets",
"Host" => "Serveur",
"Proxy port" => "Port du serveur proxy",
"Quantify change size" => "Quantifier la taille de la modification",
"Record untranslated strings" => "Enregistrer les chaînes non traduites",
"Restrict supported languages" => "Restreindre la liste des langues disponibles ",
"Refresh mode" => "Mode de rafraichissement",
"Refresh rate" => "Fréquence de réactualisation",
"Minimum length of search word" => "Longueur minimum des mots pouvant être cherchés",
"Max. number of words containing a syllable" => "Nombre max. de mots contenant une syllabe",
"Max. age in hours of syllable search cache" => "Durée max. en heures du cache recherche sur syllabe",
"LRU list purging rate" => "Taux de nettoyage du 'dernier utilisé'(LRU)",
"LRU list length" => "Longueur de la liste 'dernier utilisé'(LRU)",
"Sender email" => "Email de l'expéditeur",
"Database" => "Base de données",
"Session lifetime" => "Durée de la session",
"Display available translations" => "Afficher les traductions disponibles",
"?" => "&nbsp;?",
"Close site (except for those with permission)" => "Fermer le site (sauf pour les utilisateurs ayant les permissions)",
"Message to display" => "Message à afficher",
"Choices" => "Choix",
"After" => "Après",
"Before" => "Devant",
"Publish" => "Le publier",
"Smarty Security" => "Sécurité Smarty",
"Check frequency" => "Fréquence des contrôles",
"Each day" => "Chaque jour",
"Each week" => "Chaque semaine",
"Each month" => "Chaque mois",
"Close site when server load is above the threshold  (except for those with permission)" => "Fermer le site si la charge du serveur dépasse le seuil (sauf pour les utilisateurs ayant les permissions)",
"Use proxy" => "Utiliser un serveur proxy",
"Users can configure modules" => "Les utilisateurs peuvent configurer les modules",
"Always" => "Toujours",
"Allow viewing HTML mails?" => "Permettre d'afficher les mails en HTML?",
"Maximum size for each attachment" => "Taille maximum des fichiers joints",
"Unlimited" => "Illimité",
"Wiki link format" => "Format d'un lien Wiki",
"Complete" => "Fini",
"Business style" => "Style affaire",
"Collaborative style" => "Style collaboratif",
"Page last modified on" => "Modifiée dernièrement le",
"Top" => "Racine",
"Both" => "Les deux",
"When using the ...page... page break wiki syntax" => "Utile lors de l'utilisation de saut de page (\"...page...\" en wiki syntax)",
"Cache wiki pages (global)" => "Antémémoire globale à toutes les pages Wiki",
"no cache" => "non",
"hour" => "heure",
"hours" => "heures",
"Disable" => "Désactiver",
"Enable wiki 3D browser" => "Permettre le navigateur Wiki 3D",
"Load page on navigation" => "Charger la page à la navigation",
"Browser height" => "Hauteur du navigateur",
"Navigation depth" => "Profondeur de navigation",
"Node size" => "Taille de noeud",
"Text size" => "Taille du texte",
"Spring (connection) size" => "Taille de l'élastique (connexion)",
"Existing page node color" => "Couleur du noeud d'une page existante ",
"Missing page node color" => "Couleur du noeud d'une page manquante ",
"Camera distance adjusted relative to nearest node" => "Distance de la camera ajustée relativement au noeud le plus proche",
"Camera distance" => "Distance de la camera",
"Field of view" => "Champ de vision",
"Feed animation interval (milisecs)" => "Intervalle (millisecs) de rafraîchissement",
"Friction constant" => "Constante de friction",
"Elastic constant" => "Constante d'élasticité",
"Eletrostatic constant" => "Constante électrostatique",
"Node mass" => "Masse du noeud",
"Node charge" => "Charge de noeud",
"Wysiwyg Editor is optional" => "L'éditeur wysiwyg est optionnel",
"... and is displayed by default" => "... et est affiché par défaut",
"Reopen with the same editor" => "Réouvrir avec le même éditeur",
"Content is parsed like wiki page" => "Le contenu est analysé comme une page wiki",
"Content is partially parsed" => "Le contenu est partiellement analysé",
"Toolbar skin" => "Habillage de la barre d'outils",
"Default" => "Défaut",
"Created by profile installer" => "Créé par l'installeur de profils",
"Page updated by profile installer" => "Page mise à jour par l'installeur de profils",
"Wiki top pages" => "Pages Wiki les plus populaires",
"Most relevant pages" => "Pages les plus pertinentes",
"Relevance" => "Pertinence",
"Wiki last pages" => "Dernières pages Wiki",
"Modified" => "Modifié",
"Forums last posts" => "Derniers articles de forum",
"Topic date" => "Date du sujet",
"Forums most read topics" => "Sujets de forums les plus lus",
"Forums best topics" => "Sujets de forums les plus populaires",
"Forums most visited forums" => "Forums les plus visités",
"Forums with most posts" => "Forums avec le plus d'articles",
"Wiki top galleries" => "Galeries Wiki les plus populaires",
"Wiki top file galleries" => "Galeries de fichiers Wiki les plus populaires",
"Wiki top images" => "Images Wiki les plus populaires",
"Wiki top files" => "Fichiers Wiki les plus populaires",
"Downloads" => "Téléchargements",
"Wiki last images" => "Dernières images Wiki",
"Upload date" => "Date d'envoi",
"Wiki last files" => "Derniers fichiers Wiki",
"Wiki top articles" => "Articles Wiki les plus populaires",
"Most visited blogs" => "Blogues les plus visités",
"Most active blogs" => "Blogues les plus actifs",
"Activity" => "Activité",
"Blogs last posts" => "Dernières publications de blogue",
"Post date" => "Date de publication",
"Wiki top authors" => "Auteurs Wiki les plus actifs",
"Top article authors" => "Auteurs d'articles les plus actifs",
"The passwords do not match" => "Les mots de passe ne sont pas identiques",
"User already exists" => "Cet utilisateur existe déjà",
"Wrong registration code" => "Mauvais code d'enregistrement",
"Invalid username" => "Nom d'utilisateur invalide",
"Username is too long" => "Nom d'utilisateur trop long",
"Username cannot contain whitespace" => "Le nom d'utilisateur ne doit pas contenir d'espace",
"Wrong passcode. You need to know the passcode to register at this site" => "Passcode invalide&nbsp;: vous devez connaître le passcode pour vous inscrire dans ce site",
"Invalid email address. You must enter a valid email address" => "Adresse électronique invalide. Vous devez saisir une adresse valide",
"The registration mail can't be sent. Contact the administrator" => "Le message de confirmation ne peut être envoyé. Contactez l'administrateur",
"Today" => "Aujourd'hui",
"and" => "et",
"from" => "de",
"replied" => "répondu",
"Feed provided by %s. Click to visit." => "Canaux de syndication fourni par %s. Cliquer pour voir.",
"Login" => "Connexion",
"See other users' profiles" => "Voir les informations d'un autre utilisateur",
"Have your profile seen" => "Avoir ses informations visibles",
"Make friends" => "Se faire un ami",
"Receive message" => "Reçoit un message",
"Send message" => "Envoyer un message",
"Read an article" => "Lire un article",
"Publish an article" => "Publier un article",
"Have your article read" => "Avoir son article lu",
"Create new file gallery" => "Créer une nouvelle galerie de fichiers",
"Upload new file to gallery" => "Envoyer un nouveau fichier dans une galerie",
"Download other user's file" => "Télécharger un fichier d'un autre utilisateur",
"Have your file downloaded" => "Avoir un de ses fichiers téléchargé",
"Create a new image gallery" => "Créer une nouvelle galerie d'images",
"Upload new image to gallery" => "Envoyer une nouvelle image dans une galerie",
"See other users' galleries" => "Afficher une galerie d'images d'un autre utilisateur",
"See other users' images" => "Afficher une image d'un autre utilisateur",
"Have your gallery seen by other users" => "Avoir sa galerie affichée par un autre utilisateur",
"Have your image seen" => "Avoir une de ses images affichée",
"Create new blog" => "Créer un nouveau blogue",
"Post in a blog" => "Publier dans un blogue",
"Read other users' blogs" => "Lire un blogue d'un autre utilisateur",
"Have your blog read" => "Avoir un de ses blogues lu",
"Create a new wiki page" => "Créer une nouvelle page Wiki",
"Edit an existing page" => "Modifier une page existante",
"Attach file" => "Joindre un fichier",
"Wiki Comment" => "Commentaire Wiki",
"Calendar item" => "Item du Calendrier",
"Gallery" => "Galerie",
"Blog post" => "Article de blogue",
"Tracker item" => "Fiche du formulaire",
"Tracker" => "Formulaire",
"Unknown" => "Inconnu",
"Trackeritem" => "FicheFormulaire",
"Directory category" => "Catégorie de répertoire",
"Advanced" => "Avancé",
"_HOMEPAGE_CONTENT_" => "\n!Félicitation !\nCeci est la \"page d'accueil\" de votre Tiki. Si vous voyez cette page, votre installation est un succès.\n\nVous pouvez changer cette page après vous être authentifié. Veuillez consulter la [http://doc.tikiwiki.org/wiki+syntax|syntaxe wiki] pour les détails relatifs à l'édition.\n\n\n!!{img src=pics/icons/star.png alt=\"Démarrage\"} Mise en route.\nPour commencer la configuration de votre site:\n{FANCYLIST()}\n1) Connectez-vous en tant que __admin__ avec le mot de passe __admin__.\n2) Changez le mot de passe de l'utilisateur admin.\n3) Activez des fonctionnalités spécifiques de Tiki.\n4) Configurez les fonctionnalités.\n{FANCYLIST}\n\n!!{img src=pics/icons/help.png alt=\"Aide\"} Besoin d'aide ?\nPour plus d'informations:\n*[http://info.tikiwiki.org/Learn+More|Apprenez plus au sujet de TikiWiki].\n*[http://info.tikiwiki.org/Help+Others|Obtenez de l'aide], incluant la [http://doc.tikiwiki.org|documentation officielle] et [http://www.tikiwiki.org/forums|forums de support].\n*[http://info.tikiwiki.org/Join+the+community|Rejoignez la communauté TikiWiki].\n",
"Fast Next" => "Vite au suivant",
"Fast Prev" => "Retour rapide",
"Prev" => "Préc.",
"Next" => "Suivant",
"First {\$params['itemname']}" => "Premier {\$params['itemname']}",
"Last {\$params['itemname']}" => "Dernier {\$params['itemname']}",
"Next {\$params['itemname']}" => "Suivant {\$params['itemname']}",
"Prev {\$params['itemname']}" => "Précédent {\$params['itemname']}",
"Click Here" => "Cliquer ici",
"AutoSave" => "Sauvegarde automatique",
"Your edit session will expire in" => "Votre session d'édition va expirer dans",
"Edit Template" => "Modifier le gabarit",
"Admin Feature" => "Admin Fonctionnalités",
"Hide" => "Cacher",
"help" => "aide",
"All" => "Tous",
"The text is" => "Le texte est",
"character(s) too long - please edit it." => "caractère(s) trop long - SVP, modifiez-le.",
"Date Selector" => "Sélection de la date",
"phplayers are not available on this site" => "la fonctionalité phplayers n'est pas disponible sur ce site",
"Select All" => "Tout sélectionner",
"Invert Sort" => "Inverser le tri",
"days" => "jours",
"day" => "jour",
"done" => "fait",
"Text cut here" => "Texte coupé ici",
"Task" => "Tâche",
"for" => "pour",
"Priority" => "Priorité",
"Friend" => "Ami",
"Last seen on" => "Dernièrement vu le",
"(idle for %s seconds)" => "(aucune activité depuis %s secondes)",
"User information - Click for more info" => "Info. utilisateur - Cliquer pour en savoir plus",
"More info about \$other_user" => "Plus d'information sur \$other_user",
"(idle for \$idletime seconds)" => "(inactif depuis \$idletime secondes)",
"Yes" => "Oui",
"No" => "Non",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "1",
"Use this tree to copy the structure" => "Utiliser cet arbre pour copier la structure",
"created from structure" => "créé à partir d'une structure",
"Table of contents" => "Table des matières",
"You have to make %d choice(s) for the question" => "Vous devez donner %s réponses à la question",
"You have to make at least %d choice(s) for the question" => "Vous devez donner au moins %s réponses à la question",
"You have to make less than %d choice(s) for the question" => "Vous devez donner moins de %s réponses à la question",
"You have to choose at least %d choice(s) for the question" => "Vous devez sélectionner un minimum de %d choix pour répondre à cette question",
"text" => "texte",
"unknown error" => "erreur inconnue",
"You are not logged in" => "Vous n'êtes pas connecté",
"Page cannot be found" => "Page introuvable",
"Page '%0' cannot be found" => "La page '%0' est introuvable",
"Permission denied. You cannot view this section" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas afficher cette section",
"For the security of your password direct access to the feed is only available via https" => "Pour la sécurité de votre mot de passe, l'accès à ce canal n'est accessible que via https",
"Help link" => "Lien vers l'Aide",
"Help" => "Aide",
"You are banned from" => "Vous êtes interdit de la section ",
"img-g" => "gal-img",
"file-g" => "gal-fichiers",
"faqs" => "FAQs",
"quizzes" => "QCMs",
"arts" => "articles",
"blogs" => "blogues",
"Edit Plugin" => "Editer le Plugin ",
"Click to edit dynamic variable" => "Cliquer ici pour modifier la variable dynamique",
"Update variables" => "Mettre à jour les variables",
"Edit Section" => "Modifier une section",
"Show" => "Montrer",
"sad" => "triste",
"confused" => "confus",
"cool" => "relax",
"mad" => "furieux",
"The file you are trying upload was only partially uploaded." => "Le fichier que vous tentez d'envoyer n'a été transféré que partiellement.",
"Removed" => "Supprimé",
"__WARNING__: No such module \$plugin!" => "__ATTENTION__: Aucun module \$plugin!",
"at" => "sur",
"new" => "créer",
"Unknown language" => "Langue inconnue",
"Click here to confirm your action" => "Cliquer ici pour confirmer votre action",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) détecté. Opération bloquée.",
"Heading" => "En-tête",
"Background Color" => "Couleur du fond d'écran",
"Reduce area height" => "Réduire la hauteur de la zone",
"Enlarge area height" => "Augmenter la hauteur de la zone",
"Wiki Help" => "Aide Wiki",
"Upload was not successful. Duplicate file content ?" => "L'envoi n'a pas réussi. Le fichier existe peut-être déjà ?",
"Item Modification" => "Modification de la fiche",
"Item creation" => "Création d'une fiche",
"Subject" => "Sujet",
"Tracker was modified at " => "Le formulaire a été modifié à ",
"Field is not numeric" => "Le champ n'est pas numérique",
"Field is not a link to mp3 in the gallery" => " le champ n'est pas un lien vers un MP3 de la galerie",
"Field is not a link to FLV in the gallery" => "le champ n'est pas un lien vers un FLV de la galerie",
"Field is not a link to FLV or MP3 in the gallery" => "le champ n'est pas un lien vers un FLV ou MP3 dans la galerie",
"text field" => "champ texte",
"half column" => "demi-colonne",
"size" => "taille",
"prepend" => "concaténer avant",
"append" => "Ajouter",
"textarea" => "zone de texte",
"checkbox" => "à cocher",
"numeric field" => "champ numérique",
"drop down" => "liste déroulante",
"drop down with other textfield" => "liste déroulante avec champ de texte autre",
"radio buttons" => "boutons radio",
"user selector" => "sélection automatique d'utilisateur",
"group selector" => "sélection automatique de groupe",
"IP selector" => "sélecteur d'ip",
"page selector" => "sélecteur de page",
"country selector" => "sélection de pays",
"date and time" => "date et horaire",
"header" => "intertitre",
"static text" => "texte statique",
"category" => "catégorie",
"item link" => "lien de fiche",
"items list" => "liste de fiches",
"dynamic items list" => "liste dynamique",
"email" => "adresse électronique",
"auto-increment" => "auto-incrément",
"user subscription" => "réservation utilisateur",
"system" => "système",
"computed field" => "champ calculé",
"user preference" => "préférence utilisateur",
"attachment" => "fichier joint",
"open" => "en cours (o)",
"pending" => "en attente",
"closed" => "fermé",
"No extra information for that attached file. " => "Aucune information supplémentaire pour ce fichier joint. ",
"child categories" => "sous-catégories",
"objects in category" => "objets dans la catégorie",
"(AT)" => "(À)",
"(DOT)" => "(PT)",
"The administrator has not yet validated your account. Please wait." => "L'administrateur n'a pas encore validé votre compte. Attendez SVP.",
"You must validate your account first. An email has been sent to you" => "Vous devez tout d'abord valider votre compte. Un courriel vous a été envoyé.",
"Password should be at least" => "Le mot de passe doit avoir au moins",
"characters long" => "caractères",
"Password must contain both letters and numbers" => "Le mot de passe doit contenir des lettres et des chiffres",
"The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "Le message d'enregistrement n'a pas pu être envoyé puisqu'aucun serveur de messagerie n'est configuré, et cette fonctionnalité est désactivée",
"The user email confirmation can't be sent. Contact the administrator" => "Le courriel de confirmation n'a pas pu être envoyé. Contactez l'administrateur SVP",
"Personal Phone" => "Téléphone privé",
"Personal Mobile" => "Portable privé",
"Personal Fax" => "Télécopieur privé",
"Work Phone" => "Téléphone professionnel",
"Work Mobile" => "Portable professionnel",
"Work Fax" => "Fax professionnel",
"Company" => "Société",
"Organization" => "Organisation",
"Department" => "Départment",
"Job Title" => "Poste",
"Street Address" => "Adresse postale",
"City" => "Ville",
"State" => "État",
"Zip Code" => "Code postal",
"Country" => "Pays",
"No subject" => "Aucun sujet",
"User-Agent Info" => "Information du User-Agent",
"Displays browser client info" => "Affiche les informations du navigateur client",
"Anchor Link" => "Ancre",
"Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Met un lien vers un ancrage dans la page. A utiliser avec le plugin ANAME qui positionne l'ancrage et son nom",
"linktext" => "texte_du_lien",
"Anchor Name" => "Nom de l'Ancre",
"Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Met un ancrage dans la page. A utiliser avec le plugin ALINK qui crée le lien vers l'ancrage",
"Image Annotation" => "Annotation d'image",
"Location" => "Lieu",
"Width" => "Largeur",
"Image width." => "Largeur de l'image.",
"Height" => "Hauteur",
"Image height." => "Hauteur de l'image.",
"Alignment" => "Alignement",
"Image alignment. Possible values: left, right, center." => "Position de l'image. Valeurs possibles&nbsp;: left, right, center.",
"Save changes to annotations" => "Enregistre les modifications dans annotations",
"Field" => "Champ",
"Article ID" => "ID de l'Article",
"Includes an article" => "Inclut un article",
"Id is optional. If not given, last article is used. Default field is heading." => "Id est optionnel. S'il n'est pas indiqué, le drnier article est utilisé. Le champ par défaut est l'en-tête.",
"Article List" => "Liste d'articles",
"Articles displayed" => "Articles affichés",
"Category ID" => "ID de la catégorie",
"Sort order" => "Sens du tri",
"Quiet" => "Silencieux",
"Title only" => "Titre seulement",
"Start date" => "Date de début",
"End date" => "Date de fin",
"Includes articles listing into a wiki page" => "Inclut des listes d'articles dans une page wiki",
"Attachment" => "Fichier joint",
"File" => "Fichier",
"Show description" => "Afficher la description",
"Bullets" => "Puces",
"Number" => "Nombre",
"Show icon" => "Montrer l'icône",
"No such attachment on this page" => "Fichier joint inexistant sur cette page",
"Displays an attachment or a list of them" => "Afficher un fichier joint ou la liste des fichiers joints",
"Gives the name of the attached file to link to" => "Donne le nom des fichiers rattachés à lier",
"Same as name" => "Idem à name",
"Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Donne le nom d'une autre page où le fichier rattaché l'est également. Ne fonctionne qu'avec les pages wiki",
"Shows the description as the link text instead of the file name" => "Affiche la description du fichier en lieu et place du nom du fichier",
"Makes the list of attachments a bulleted list" => "Présente la liste des fichiers attachés sous forme de liste à puces",
"Says that this file is an image, and should be displayed inline using the img tag" => "Indique que ce fichier est une image qui devrait être présentée dans la page dans une balise html img",
"Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Place le contenu entre les balises {ATTACH} comme lien textuel en lieu et place du nom du fichier ou de la description",
"Shows all attachments from the whole wiki" => "Montre tous les fichiers rattachés à travers tout le wiki",
"Gives the number, in the list of attachments, of the attachment to link to" => "Donne le nombre, dans la liste des rattachements, de l'attachement vers lequel lier",
"Gives the actual id of the attachment to link in. You probably should never use this" => "Donne l'id de l'attachement courant pour faire des liens. Vous ne devriez pas utiliser celà",
"Puts the number of downloads in the alt comment" => "Insère le nombre de téléchargements dans le texte alternatif (balise alt)",
"Shows a file icon" => "Affiche une icône de fichier",
"Displays the user Avatar" => "Affiche l'avatar utilisateur",
"username" => "nom utilisateur",
"Back" => "Retour",
"Displays a link that allows to go back in the browser history" => "Affiche un lien qui permet le retour arriêre dans l'historique du navigateur",
"Insert back link on wiki page" => "Insère un lien de retour dans la page wiki",
"Backlinks" => "Pages pointant cette page",
"Displayed information" => "Informations affichées",
"Excluded pages" => "Pages exclues",
"No Header" => "Pas d'en-tête",
"List all pages that link to specific pages" => "Liste toutes les pages pointant vers un groupe de pages spécifiques",
"No pages links to" => "Aucune page ne pointe vers",
"One page links to" => "Une page pointe vers",
"pages link to" => "pages pointent vers",
"Banner" => "Bannière",
"Insert a banner" => "Insérer une bannière",
"Target" => "Cible",
"missing parameter" => "paramètre manquant",
"Blog List" => "List des blogues",
"Blog ID" => "ID du Blog",
"Numeric value" => "Valeur numérique",
"Use BLOGLIST to include posts from a blog. Syntax is" => "Utiliser BLOGLIST pour inclure des posts d'un blog. La syntax est",
"where Id is the blog Id and Items is the max number of posts to display" => "où Id est l'Id du blog et Items est le nombre max de posts à afficher",
"Box" => "Boite",
"Insert theme-styled box on wiki page" => "Insère le contenu du plugin dans une boîte avec une en-tête colorée",
"Box title" => "Titre de la boite",
"Displayed above the content" => "Affiché au-dessus du contenu",
"Background color" => "Couleur de fond",
"Box width" => "Largeur de la boite",
"Text Alignment" => "Alignement du texte",
"CSS Class" => "Classe CSS",
"Category IDs" => "IDs des Catégories",
"Sort Order" => "Ordre de tri",
"And" => "Et",
"Insert list of items with the current/given category in the wiki page" => "Insère la liste d'items pour la catégorie courante ou donnée",
"Categories are disabled" => "Les catégories sont désactivées",
"Display Tiki objects that have not been categorized" => "Affiche les objets Tiki qui n'ont pas été catégorisés",
"Objects" => "Objets",
"Separator" => "Séparateur",
"Display top category" => "Afficher la catégorie racine",
"yes|no, default to no" => "oui|non, valeur par défaut est non",
"Insert the full category path for each category that this wiki page belongs to" => "Insère l'arborescence complète de la catégorie pour chaque catégorie à laquelle appartient cette page",
"Center" => "Centre",
"Centers the plugin content in the wiki page" => "Centre le contenu du plugin dans la page Wiki",
"Chart" => "Palmarès",
"Sheet ID" => "ID de la feuille",
"Chart Width" => "Largeur du graphe",
"Chart Height" => "Hauteur du graphe",
"Value series" => "Série de valeurs",
"Required for pie charts" => "Requis pour les graphiques camembert",
"Required for types other than pie chart" => "Requis pour les autres types que les graphiques camembert",
"title" => "titre",
"Chart as PDF" => "Graphique en PDF",
"Chart as PostScript" => "Graphique en PostScript",
"Displays a snippet of code" => "Affiche un petit bout de code",
"Colors" => "Couleurs",
"Line numbers" => "Numéros de lignes",
"Wiki syntax" => "Syntaxe Wiki",
"Right to left" => "Droite à Gauche",
"0|1, switch the text display from left to right to right to left" => "0|1, changer le texte affiché de gauche à droite, vers droite à gauche",
"Content is HTML" => "Le contenu est du HTML",
"note: colors and ln are exclusive" => "remarque&nbsp;: colors et ln sont exclusifs",
"Dynamic Content" => "Contenu dynamique",
"Content ID" => "ID du contenu",
"Cookie" => "Citation",
"Insert copyright notices" => "Insère les notices de copyright",
"Countdown" => "Compte à rebours",
"Locate Time" => "Heure locale",
"Example" => "Exemple",
"seconds" => "secondes",
"DBReport" => "Rapport BDD",
"Run a database report" => "Lancer un rapport de base de données",
"report definition" => "définition du rapport",
"Full DSN" => "DSN complet",
"A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "Chaine de connexion DSN complète (Data Source Name). eg: mysql://user:pass@server/database",
"Wiki DSN name" => "Nom DSN Wiki",
"Missing db or dsn parameter" => "Paramètre DB ou DSN manquant",
"You do not have permission to use this DSN" => "Vous n'avez pas la permission d'utiliser ce DSN",
"Pre" => "Pré",
"Right" => "Droit",
"Left" => "Gauche",
"Clear" => "Effacer",
"Definition List" => "Liste de définition",
"Creates a definition list" => "Crée une liste de définition",
"term" => "terme",
"definition" => "définition",
"one definition per line" => "une définition par ligne",
"Equation" => "Équation",
"equation" => "équation",
"Events" => "Évènements",
"Calendar ID" => "ID du Calendrier",
"Numeric" => "Numérique",
"Maximum days" => "Nombre de jour maximum",
"Datetime" => "Date Heure",
"Desc" => "Description",
"~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insère un feed rss dans une page wiki",
"Upcoming events" => "Évènements à venir",
"Label" => "Étiquette",
"Use div" => "Utiliser div",
"Use div instead of ol" => "Utiliser div plutôt que ol",
"Displays the data using the Tikiwiki odd/even table style" => "Affiche les données en utilisant le style Tikiwiki de table pair/impair ",
"cells" => "cellules",
"sort" => "trier",
"Shows ID" => "Afficher l'ID",
"Shows Icon" => "Afficher l'icône",
"Shows Name" => "Afficher le nom",
"Shows Filename" => "Afficher le nom du fichier",
"Shows Size" => "Afficher la taille",
"Shows Description" => "Afficher la description",
"Shows Creation Date" => "Afficher la date de création",
"Shows Hits" => "Afficher les hits",
"Shows Locked by" => "Afficher les verrous",
"Shows Modification Date" => "Afficher la date de modification",
"Shows Author" => "Afficher l'auteur",
"Shows Creator" => "Afficher le créateur",
"Shows Parent Gallery Name" => "Afficher le nom de la galerie parente",
"Shows Number of Files" => "Afficher le nombre de fichiers",
"Shows the slideshow of a gallery" => "Afficher le diaporama de la galerie",
"Displays a Flash (.swf) file in the wiki page" => "Affiche un SWF dans une page Wiki",
"Default width: 425" => "Largeur par défaut : 425",
"Default height: 350" => "Hauteur par défaut : 350",
"Quality" => "Qualité",
"Missing parameter movie to the plugin flash" => "Paramètre manquant au plugin flash",
"Footnote" => "Note de pied de page",
"The footnote" => "La note de pied de page",
"Footnotearea" => "Zone de notes de pied de page",
"Inserts a section for collected footnotes in the wiki page" => "Insère une section pour la liste de notes de pied de page collectées dans la page wiki",
"file name" => "Nom du fichier",
"Ftp Server Name" => "Nom du Serveur Ftp",
"Ftp User name" => "Nom de l'utilisateur Ftp",
"Ftp password" => "Mot de passe Ftp",
"missing parameters" => "paramètres manquants",
"Connection failed" => "Échec de la connexion",
"Incorrect param" => "Paramètre incorrect",
"failed" => "a échoué",
"Gauge" => "Jauge",
"Displays a graphical gauge" => "Afficher une jauge graphique",
"Value" => "Valeur",
"current value (REQUIRED)" => "valeur actuelle (REQUIS)",
"Maximum Value" => "Valeur maximum",
"Color" => "Coleur",
"Label Width" => "Largeur de l'étiquette",
"Display Percentage" => "Afficher les pourcentages",
"Display Value" => "Afficher la valeur",
"Displays a graphical GAUGE" => "Affiche une jauge graphique",
"Missing parameter" => "Paramètre manquant",
"key" => "clé",
"Name of iframe" => "Nom de l'iframe",
"Pixels or %" => "Pixels ou %",
"Displays a Google document" => "Affiche un document Google",
"Group" => "Groupe",
"Allowed Groups" => "Groupes autorisés",
"Denied Groups" => "Groupes rejetés",
"Display wiki text if user is in one of listed groups" => "Affiche le texte wiki si l'utilisateur se trouve au moins dans l'un des groupes listés",
"Show Percentage" => "Afficher les pourcentages",
"Show Bar" => "Afficher les barres",
"Include literal HTML in a Wiki page" => "Inclure du code HTML dans une page Wiki",
"HTML code" => "Code HTML",
"Include literal HTML" => "Inclure du code HTML",
"name" => "nom",
"Displays an iframe" => "Affiche un iframe",
"Image ID" => "Id Image",
"Image Source" => "Source de l'image",
"Image size" => "pixel image",
"Image height" => "Hauteur de l'Image",
"Image width" => "Largeur de l'Image",
"Link title" => "Titre du lien",
"Image alt text" => "Texte alternatif (alt) de l'image",
"CSS Style" => "Style CSS",
"Default configuration" => "Configuration par défaut",
"Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Définitions des configurations par défaut. (Habituellement utilisées dans les configurations plutôt que sur chaque image.)",
"Mandatory configuration" => "Configuration obligatoire",
"Thumbnail" => "Vignette",
"Browse" => "Parcourir",
"Download" => "Télécharger",
"Include" => "Inclus les droits de",
"Page Name" => "Nom de la page",
"Start" => "Début",
"Include a page" => "Insère une page",
"Default group" => "Groupe par défaut",
"Following mandatory fields are missing" => "Les champs obligatoires suivants sont manquants",
"Email address" => "Adresse électronique",
"Runs a Java applet to access a local Jabber service" => "Lance un applet Java pour accéder au service local Jabber",
"Default Color" => "Couleur par défaut",
"javascript code" => "code javascript",
"Displays the text only if the language matchs" => "Affiche le texte seulement si la langue correspond",
"Last Modification" => "Dernière modification",
"List Pages" => "Liste des pages",
"List wiki pages." => "Liste des pages wiki.",
"Show Name Only" => "Affiche le Nom seulement",
"Show Page Alias" => "Afficher les alias de la page",
"Orphan Language" => "Langue orpheline",
"Load Translations" => "Charger les traductions",
"Exact Match" => "Correspondance exacte",
"Only Orphan Pages" => "Seules les Pages Orphelines",
"For List Pages" => "Pour la liste des Pages",
"Sort" => "Tri",
"or" => "ou",
"Limit" => "Limite",
"Filter" => "Filtrer",
"complete" => "presque tout",
"Lists files in a directory" => "Liste des fichiers d'un répertoire",
"URL Prefix" => "Préfixe d'URL",
"Maximum amount of files to display" => "Nombre maximum de fichiers à afficher",
"could not be opened because it doesn't exist or permission was denied" => "ne peut pas être ouvert parce que n'existe pas ou vous n'avez pas les droits",
"Map" => "Carte",
"Displays a map" => "Affiche une carte",
"Map File" => "Fichier carte",
"Feature disabled" => "Fonctionnalité désactivée",
"Template" => "Gabarit",
"Mediaplayer" => "Lecteur multimédia",
"Groups" => "Groupes",
"Module Name" => "Nom de module",
"Please choose a module" => "SVP choisissez un module",
"to be used as argument" => "à être utilisé comme paramètre",
"Displays a module inline in a wiki page" => "Affiche un module à l'intérieur de la page",
"Sorry, no such module" => "Désolé module inexistant",
"Font" => "Police",
"Displays the data using a monospace font" => "Affiche le texte en utilisant une police de caractères mono-espacée",
"Text" => "Texte",
"DEPRECATED" => "OBSOLETE",
"Sticky" => "Captivant",
"Effect speed" => "Rapidité des effets",
"true|false" => "vrai|faux",
"data" => "données",
"Displays a MySpace Flash mp3 playlist in the wiki page" => "Affiche un SWF myspace mp3 playlist dans une page wiki",
"Object" => "Objet",
"Object Type" => "Type de l'objet",
"Days" => "Jours",
"Displays object hit info by object and days" => "Affiche les informations sur les visites d'un objet par objet et par jours",
"Status" => "État",
"Picture" => "Image",
"Filename or full path to file" => "Nom du fichier ou chemin complet au fichier",
"picture not found" => "image non trouvée",
"Plugin Manager" => "Gestionnaire de plugin",
"Displays a list of plugins available in this wiki." => "Affiche la liste des plugins.",
"No version indicated" => "Aucune version indiquée",
"No arguments indicated" => "Aucun argument indiqué",
"Poll" => "Sondage",
"Displays the output of a poll, fields are indicated with numeric ids." => "Affiche les sorties d'un sondage, les champs sont indiqués par leur ID numérique.",
"missing poll ID for plugin POLL" => "ID de sondage inexistant pour le plugin POLL",
"Domain" => "Domaine",
"Proposal" => "Proposition",
"Accept proposal" => "Accepter la proposition",
"Still undecided" => "Toujours indécis",
"Reject proposal" => "Rejeter la proposition",
"Quote" => "Citation",
"Reply to" => "Répondre à",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Texte de la citation entouré d'une boîte, comme dans [QUOTE] de BBCode",
"Exclude" => "Exclure",
"Preferences" => "Préférences",
"User Information" => "Information utilisateur",
"Redirect" => "Redirection",
"Redirects you to another wiki page" => "Redirige vers une autre page wiki",
"Regular Expression" => "Expression régulière",
"one data per line" => "une donnée par ligne",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Modifie le texte entre les balises REGEX avec l'expression régulière",
"Displays a comment, tip, note or warning box" => "Affiche une boîte de commentaire, une astuce ou une alerte",
"Icon" => "Icône",
"Close" => "Fermer",
"Number of results displayed." => "Nombre de résultats affichés.",
"You need to specify a RSS Id" => "Vous devez spécifier un identifiant RSS",
"~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insère la syndication RSS dans une page Wiki",
"Automatically creates a link to the appropriate SourceForge object" => "Crée automatiquement un lien à l'objet Sourceforge correspondant",
"sharethis" => "partager ceci",
"Pop-up" => "Popup",
"Sheet" => "Feuille",
"Sheet Heading" => "En-tête de feuillet",
"TikiSheet" => "Feuillets",
"Edit Sheet" => "Éditer la feuille de calcul",
"Show Pages" => "Afficher les Pages",
"List wiki pages" => "Liste des pages Wiki",
"Search criteria" => "Critère de recherche",
"Display" => "Afficher",
"Last modified by" => "Dernière modification par",
"Clickable Skype link" => "Lien Skype clickable",
"Snarf" => "Incrustation",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "Le plugin SNARF remplace l'URL avec le code HTML associé. Des remplacements regex arbitraires peuvent être faits sur le contenu en utilisant regex et regexres, ce dernier étant utilisé comme second paramètre de preg_replace.",
"This data is put in a CODE caption." => "Cette donnée est mise dans un bloc CODE.",
"Missing url parameter for SNARF plugin." => "Paramètre manquant pour le plugin SNARF.",
"Sorts the plugin content in the wiki page" => "Trie les lignes de données",
"Order" => "Ordre",
"asc|desc|shuffle" => "asc|desc|mélangé",
"Split a page into rows and columns" => "Découpe une page en rangées et colonnes",
"Fixed Size" => "Taille Fixe",
"Column Size" => "Taille de Colonne",
"First" => "Prem.",
"Editable" => "Éditable",
"Edit" => "Modifier",
"row1col1" => "rangée1col1",
"row1col2" => "rangée1col2",
"row2col1" => "rangée2col1",
"row2col2" => "rangée2col2",
"Run a sql query" => "Exécuter une requête sql",
"sql query" => "requête sql",
"DNS Name" => "Nom DNS",
"ADODB DNS" => "DNS ADODB",
"Missing db param" => "Le paramètre db manque",
"Subscript" => "Souscrit",
"Displays text in subscript." => "Affiche le texte en lettres inférieures.",
"Subscribe or unsubscribe to a group" => "S'inscrire ou se désinscrire d'un groupe",
"Subscribe Group" => "Inscrire un groupe",
"Group Name" => "Nom de Groupe",
"Unsubscribe Text" => "Texte de désabonnement",
"Subscribe" => "S'abonner",
"Url" => "Adresse Web",
"Id" => "ID",
"Displays a survey" => "Affiche une enquête",
"Displays text between HTML tags" => "Affiche le texte entre les balises html",
"Displays the thumbnail for an image" => "Affiche la vignette pour une image",
"URL to the image." => "URL de l'image.",
"Maximum Size" => "Taille maximum",
"Maximum width or height for the image." => "Largeur ou hauteur maximum de l'image.",
"Floating" => "Flottant",
"Search the titles of all pages in this wiki" => "Cherche parmi les titres des pages Wiki",
"No pages found for title search" => "Aucune page trouvée avec la recherche par titre",
"One page found for title search" => "Une page trouvée avec la recherche par titre",
"pages found for title search" => "pages trouvées avec la recherche par titre",
"Maximum Depth" => "Profondeur Maximum",
"Structure ID" => "ID de la structure",
"Show Description" => "Afficher la Description",
"List top-scoring users" => "Liste des utilisateurs ayant le meilleur score",
"Translate" => "Traduire",
"string" => "chaîne",
"Translate a string" => "Traduire une chaîne",
"Fields" => "Champs",
"Show Title" => "Afficher le Titre",
"Email" => "Adresse électronique",
"to" => "à",
"template" => "gabarit",
"Values" => "Valeurs",
"Preview" => "Aperçu",
"preview" => "pré-visualisation",
"Reset" => "Réinitialiser",
"View" => "Afficher",
"Error" => "Erreur",
"Following fields are incorrect" => "Les champs suivants sont incorrects",
"Displays an input form for tracker submit" => "Affiche un champ de saisie pour soumettre un formulaire",
"You do not have permission to insert an item" => "Vous n'avez pas le droit d'ajouter une fiche",
"You do not have permission to modify an item" => "Vous n'avez pas les droits pour modifier un élément",
"Fields marked with a * are mandatory." => "Les champs marqués d'une astérisque(*) sont obligatoires",
"Filters" => "Filtres",
"Display List" => "Afficher la Liste",
"Line" => "Ligne",
"tracker field type not processed yet" => "champ de formulaire non traité pour l'instant",
"Filters the items of a tracker, fields are indicated with numeric ids." => "Filtre les fiches d'un formulaire, les champs sont indiqués par leur Id.",
"Wiki text" => "Texte Wiki",
"Field ID" => "ID du Champ",
"Tracker List" => "Liste de Formulaires",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Affiche la sortie du contenu du formulaire, les champs sont indiqués par des IDs numériques.",
"Show Links" => "Afficher les liens",
"Show Status" => "Afficher le Statut",
"Show Creation Date" => "Afficher la Date de Création",
"Show Last Modification" => "Afficher les dernières modifications",
"Show Field Name" => "Afficher le nom du champ",
"Status Filter" => "État du Filter",
"Sort Mode" => "Type de Tri",
"Filter Field" => "Champ du filtre",
"Filter Value" => "Filtre",
"Exact Value" => "Valeur Exacte",
"Checkbox" => "Case à cocher",
"More" => "Plus",
"Left Deliminator" => "Délimiteur gauche",
"Right Deliminator" => "Délimiteur droit",
"If y, value will be truncated" => "Si y, la valeur sera tronquée",
"Export Button" => "Bouton d'Export",
"Compute" => "Calculer",
"Delete" => "Effacer",
"incorrect filterfield" => "filterfield incorrect",
"Error in tracker ID" => "Erreur sur l'ID du formulaire",
"No field indicated" => "Aucun champ indiqué",
"Field 1" => "Champ 1",
"Value 1" => "Valeur 1",
"Content of the field." => "Contenu du champ.",
"Field 2" => "Champ 2",
"Value 2" => "Valeur 2",
"Field 3" => "Champ 3",
"Value 3" => "Valeur 3",
"Field 4" => "Champ 4",
"Value 4" => "Valeur 4",
"Field 5" => "Champ 5",
"Value 5" => "Valeur 5",
"Tracker Stats" => "Statistiques des formulaires",
"Show link to tiki-view_tracker" => "Afficher le lien vers tiki-view_tracker",
"Displays some stat of a tracker content, fields are indicated with numeric ids." => "Affiche des statistiques sur le contenu d'un formulaire - les champs sont indiqués par leur Ids numériques.",
"incorrect fieldId" => "fieldId incorrect",
"Title Field" => "Champ titre",
"Summary Field" => "Champ résumé",
"Start Date" => "Date de début",
"End Date" => "Date de fin",
"hour, day, week, month or year (default to hour)" => "heure, jour, semaine, mois ou année (heure par défaut)",
"hour, day, week, month, year or empty (default to empty)" => "heure, jour, semaine, mois, année ou vide (vide par défaut)",
"Missing parameter: %0" => "Paramètre manquant: %0",
"Translated" => "Traduite",
"Links to a translated content" => "Liens au contenu traduit",
"[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((nom de la page wiki)) or ((inter:interwiki)) (utiliser la wiki syntax)",
"Two letter language code of the language, ex: fr" => "Code de langue à deux caractères, ex: fr",
"Flag" => "Drapeau",
"Country name, ex: France" => "Nom du pays, ex: France",
"Displays the number of registered users" => "Affiche le nombre d'utilisateurs inscrits",
"Group name" => "Groupe",
"User List" => "Liste des Utilisateurs",
"Displays a list of registered users" => "Affiche une liste d'utilisateurs inscrits",
"Real Name" => "Nom réel",
"users" => "utilisateurs",
"Split the text in parts visible only under some conditions" => "Découpe le texte en parties visibles seulement sous certaines conditions",
"This is the default text" => "Ceci est le texte de la page",
"This is version 3 info" => "Voici les informations de la version 3",
"This is version 2 info" => "Voici les informations de la version 2",
"This is version 1 info" => "Voici les informations de la version 1",
"Vote" => "Voter",
"Show Stats" => "Afficher les Stats",
"Show Creator" => "Afficher l'auteur",
"Ignore" => "Ignorer",
"Level" => "Niveau",
"Lists ''wanted'' Wiki pages: " => "Pages Wiki ''voulues''&nbsp;: ",
"Page-Pattern" => "Expression régulière pour page",
"^Parameters: key=>value,...\n" => "^Paramètres: clé=>valeur,...\n",
"__key__ | __default__ | __comments__\n" => "__clé__ | __défaut__ | __commentaires__\n",
"empty string" => "chaîne vide",
"(refer to PHP function fnmatch() for details)\n" => "(voir la fonction PHP fnmatch() pour plus de détails)\n",
"possible values: characters\n" => "valeurs possibles: characters\n",
"possible values: " => "valeurs possible: ",
"a valid regex-expression (PCRE)" => "une expression régulière regex (PCRE) valide",
"non-valid custom regex" => "expression régulière regex invalide",
"ignored" => "ignoré",
"External Wiki" => "Wiki externe",
"dash-WikiWord" => "WikiWord-tiret",
"WikiWord" => "MotWiki",
"not in level" => "pas dans le niveau",
"valid" => "valide",
"End of debug output." => "Fin des messages de debug.",
"Wanted Page" => "Page voulue",
"Referenced By Page" => "Reférencé par une page",
"Service Name" => "Nom du service",
"Template Name" => "Nom du template",
"Unknown Template" => "Modèle inconnu",
"Unknown Service" => "Service inconnu",
"Missing parameters" => "Paramètres manquants",
"Display youtube video in a wiki page" => "Afficher la vidéo youtube dans une page wiki",
"URL to the Youtube video" => "URL de la vidéo sur Youtube",
"width" => "largeur",
"Width in pixels" => "Largeur en pixels",
"height" => "hauteur",
"Height in pixels" => "Hauteur en pixels",
"Missing parameter movie to the youtube plugin" => "Le paramètre de la vidéo youtube est manquant dans le plugin",
"Can't parse HTML data - no grammar file" => "Impossible de convertir les données HTML - aucun fichier de grammaire",
"Removed version \$version" => "Version \$version supprimée",
"rollback version " => "retour à la version ",
"Changed actual version to \$version" => "Version courante changée en \$version",
"Page locked" => "Page verrouillée",
"Page unlocked" => "Page déverrouillée",
"Removed last version" => "Dernière version supprimée",
"ERROR: Either the subject or body must be non-empty" => "ERREUR&nbsp;: Le sujet et le corps ne peuvent pas être vides en même temps",
"ERROR: No valid users to send the message" => "ERREUR&nbsp;: Aucun utilisateur valide à qui envoyer le message",
"Invalid user" => "Utilisateur invalide",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "La boîte des messages envoyés est pleine. Archivez ou supprimez quelques messages envoyés avant, si vous souhaitez pouvoir envoyer d'autres messages.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Vous devez pouvoir recevoir des messages pour pouvoir en envoyer. Allez dans vos préférences utilisateur et activez 'Autoriser des messages d'autres utilisateurs'",
"User %s can not receive messages, mailbox is full" => "L'utilisateur %s ne peut pas recevoir de messages. Sa boîte à lettres est pleine",
"User %s can not receive messages" => "L'utilisateur %s ne peut pas recevoir de messages",
"Invalid user: %s" => "Utilisateur invalide&nbsp;: %s",
"Message will be sent to: " => "Le message a été envoyé à&nbsp;: ",
"Archive is full. Delete some messages from archive first." => "L'archive est pleine. Supprimez des messages de l'archive d'abord.",
"No more messages" => "Plus de messages",
"Article Topics" => "Sujets des articles",
"Maximum length" => "Taille Maximale",
"Categories" => "Catégories",
"Categorize" => "Catégoriser",
"Unassign" => "Désattribuer",
"Assign" => "Attribuer",
"Categorize %s in %s" => "Catégoriser %s dans %s",
"Received objects" => "Objets reçus",
"File galleries" => "Galeries de fichiers",
"Last forum posts" => "Derniers articles de forum",
"Topics only" => "Sujets uniquement",
"Most commented forums" => "Forums avec le plus de commentaires",
"Most read topics" => "Sujets les plus lus",
"Most visited forums" => "Forums les plus visités",
"Most popular tags" => "Tags les plus populaires",
"My preferred tags" => "Mes Tags préférés",
"Google Search" => "Rechercher avec Google",
"Last actions" => "Dernières actions",
"Last blog posts" => "Derniers articles de blogue",
"no object here yet" => "pas encore d'objet",
"Last Created blogs" => "Derniers blogues créés",
"Last Created FAQs" => "Dernières FAQs créées",
"Last Created Quizzes" => "Derniers QCMs créés",
"Last modified file galleries" => "Dernières galeries de fichiers modifiées",
"Last Files" => "Derniers fichiers",
"Last Images" => "Dernières images",
"Last modified events" => "Derniers évènements modifiés",
"Last Modified blogs" => "Derniers blogues modifiés",
"Last submissions" => "Dernières soumissions",
"Last Items" => "Dernières fiches",
"Last Modified Items" => "Dernières fiches modifiées",
"Last Visitors" => "Derniers visiteurs",
"Live support" => "Assistance en ligne",
"List by month" => "Liste par mois",
"Waiting Submissions" => "Soumissions en attente",
"Old articles" => "Archives",
"Create/Edit" => "Créer/Modifier",
"Quick Edit a Wiki Page" => "Créer/modifier une page Wiki",
"Random Pages" => "Pages choisies au hasard",
"New user registration" => "Inscription d'un nouvel utilisateur",
"Button label" => "Nom du bouton",
"Post" => "Publier",
"Since your last visit" => "Depuis votre dernière visite",
"Changes since" => "Modifications depuis",
"Since your last visit..." => "Depuis votre dernière visite...",
"new comments" => "nouveau(x) commentaire(s)",
"new posts" => "nouveau(x) article(s) de forum",
"wiki pages changed" => "page(s) Wiki modifiée(s)",
"new articles" => "nouveau(x) article(s)",
"new FAQs" => "nouvelle(s) FAQ(s)",
"new blogs" => "nouveau(x) blogue(s)",
"new blog posts" => "nouvelle(s) publication(s) de blogue",
"new image galleries" => "nouvelle(s) galerie(s) d'images",
"new images" => "nouvelle(s) image(s)",
"new file galleries" => "nouvelle(s) galerie(s) de fichiers",
"new files" => "nouveau(x) fichier(s)",
"new polls" => "nouveau(x) sondage(s)",
"new users" => "nouveau(x) utilisateur(s)",
"new tracker items" => "nouvelle(s) fiche(s) de formulaire",
"Terminology" => "Terminologie",
"Most Active blogs" => "Blogues les plus actifs",
"Top articles" => "Articles les plus populaires",
"Top File Galleries" => "Galeries de fichiers les plus populaires",
"Top files" => "Fichiers les plus populaires",
"Top Forum Posters" => "Publieurs de forum les plus actifs",
"Top Images" => "Images les plus populaires",
"Top Objects" => "Objets les plus vus",
"Top Pages" => "Pages les plus populaires",
"Top Quizzes" => "QCMs les plus populaires",
"Top Visited FAQs" => "Dernières FAQs visitées",
"Page translation" => "Traduction de Page",
"User Blogs" => "Mes blogues",
"My blogs" => "Mes blogues",
"User bookmarks" => "Signets des utilisateurs",
"My galleries" => "Mes galeries",
"User Pages" => "Mes pages",
"My Pages" => "Mes pages",
"User tasks" => "Tâches utilisateur",
"The task title must have at least 3 characters" => "Le titre du message doit avoir au moins 3 caractères",
"Public tasks" => "Tâches publiques",
"Top users" => "Utilisateurs les plus actifs",
"Online users" => "Utilisateurs connectés",
"Last wiki comments" => "Derniers commentaires Wiki",
"Videos on YouTube" => "Vidéos sur YouTube",
"Invalid server key" => "Clé du serveur invalide",
"Invalid username or password" => "Nom d'utilisateur ou mot de passe invalide",
"Cookie not found" => "Cookie non trouvé",
"Can create/admin calendars" => "Droit de créer/administrer les calendriers",
"Can add events in the calendar" => "Droit d'ajouter des évènements dans le calendrier",
"Can change events in the calendar" => "Droit de modifier des évènements dans le calendrier",
"Can browse the calendar" => "Droit de parcourir le calendrier",
"Can view events details" => "Droit de voir le détail des évènements",
"Can view Tikiwiki tools calendar" => "Droit de voir les outils du calendrier Tikiwiki",
"Administrator, can create channels remove channels etc" => "Administrateur, peut créer et supprimer des canaux",
"Can use the chat system" => "Droit d'utiliser le système de discussions (chat)",
"Can admin the cms" => "Droit d'administrer les articles (cms)",
"Can approve submissions" => "Droit d'approuver les soumissions",
"Can admin article topics" => "Droit d'administrer les sujets d'articles",
"Can admin article types" => "Droit d'administrer les types d'articles",
"Can read article headings" => "Droit de lire les en-têtes d'articles",
"Submited articles automatically approved" => "Les articles soumis sont automatiquement approuvés",
"Can edit articles" => "Droit de modifier les articles",
"Can edit submissions" => "Droit de modifier les soumissions",
"Can read articles" => "Droit de lire les articles",
"Can remove articles" => "Droit de suppression d'articles",
"Can remove submissions" => "Droit de suppression de soumissions",
"Can submit articles" => "Droit de soumettre des articles",
"Can read a topic (Applies only to individual topic perms)" => "Droit de lire un élément (ne s'applique qu'aux éléments individuels)",
"Can admin contributions" => "Droit d'administrer les contributions",
"Can admin the directory" => "Droit d'administrer le répertoire des liens",
"Can admin directory categories" => "Droit d'administrer les catégories de répertoire",
"Can admin directory sites" => "Droit d'administrer les sites des répertoires",
"Submited links are valid" => "Les liens soumis sont valides",
"Can submit sites to the directory" => "Droit de soumettre des sites au répertoire des liens",
"Can validate submited links" => "Droit de valider des liens soumis",
"Can use the directory" => "Droit d'utiliser le répertoire des liens",
"Can admin faqs" => "Droit d'administrer les faqs",
"Can suggest faq questions" => "Droit de suggérer des questions dans les faqs",
"Can view faqs" => "Droit de voir les faqs",
"Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrateur, peut gérer les comptes utilisateurs, les groupes, les permissions, les mots/liens automatiques (Hotwords) ainsi que les fonctionnalités du blogue",
"Can admin users" => "Droit d'administrer les utilisateurs",
"Can access site when closed" => "Peut accéder au site lorsqu'il est fermé",
"Administrator, can admin banners" => "Administrateur, peut administrer les bannières",
"Can ban users or ips" => "Droit de bannir des utilisateurs ou des ips",
"Can admin the dynamic content system" => "Droit d'administrer le système de contenu dynamique",
"Can admin integrator repositories and rules" => "Droit d'administrer les dépots d'intégration Tiki et les règles",
"Can admin mail-in accounts" => "Droit d'administrer les comptes mail-in",
"Can edit object permissions" => "Droit de modifier les permissions des objets",
"Can clean cache" => "Droit de vider le cache",
"Can create new css suffixed with -user" => "Droit de créer des css suffixé avec -user",
"Can remove association between two pages in a translation set" => "Droit de supprimer l'association entre des pages d'un jeu de traduction",
"Can admin cookies" => "Droit d'administrer les cookies",
"Can edit translations and create new languages" => "Droit de modifier les traductions et d'ajout de nouvelles langues",
"Can edit menu" => "Droit de modifier les menus",
"Can edit menu option" => "Droit de modifier les options des menus",
"Can edit site templates" => "Droit de modifier les gabarits de site",
"Can search" => "Droit de rechercher",
"Can report a link to the webmaster" => "Droit de signaler un lien à l'administrateur du site",
"Can subscribe to groups" => "Droit de s'inscrire dans les groupes",
"Can send a link to a friend" => "Droit d'envoyer un lien à un ami",
"Can use HTML in pages" => "Droit d'utiliser du code HTML dans les pages",
"Can view action log" => "Droit de voir le journal des actions",
"Can view action log for users of his own groups" => "Droit de voir le journal des actions pour ses propres groupes",
"Can view integrated repositories" => "Droit de lecture sur les dépots d'intégration",
"Can view referer stats" => "Droit de voir les statistiques des origines",
"Can view site stats" => "Droit de voir les statistiques du site",
"Can view site templates" => "Droit de voir les modèles du site",
"Can admin blogs" => "Droit d'administrer les blogues",
"Can assign perms to blog" => "Droit d'assigner des permissions sur les blogues",
"Can post to a blog" => "Droit de publier dans un blogue",
"Can create a blog" => "Droit de créer des blogues",
"Can read blogs" => "Droit de lire les blogues",
"Can admin file galleries" => "Droit d'administrer les galeries de fichiers",
"Can assign perms to file gallery" => "Droit d'assigner des permissions sur les galeries de fichiers",
"Can use Directory Batch Load" => "Droit d'utiliser le chargement par lot dans le répertoire des liens",
"Can upload zip files with files" => "Droit d'envoyer des fichiers zip avec les fichiers",
"Can create file galleries" => "Droit de créer des galeries de fichiers",
"Can download files" => "Droit de télécharger des fichiers",
"Can edit a gallery file" => "Droit d'édition d'un fichier de la galerie",
"Can list file galleries" => "Droit de lister les galeries de fichiers",
"Can upload files" => "Droit d'envoyer (upload) des fichiers",
"Can view file galleries explorer" => "Droit de voir l'explorateur de galeries de fichiers",
"Can view file galleries path" => "Droit de voir le chemin des galeries de fichiers",
"Can view file galleries" => "Droit de voir les galeries de fichiers",
"Can admin forums" => "Droit d'administrer les forums",
"Can attach to forum posts" => "Droit d'attacher des fichiers aux articles du forum",
"Auto approve forum posts" => "Validation automatique des articles du forum",
"Can edit own forum posts" => "Droit de modifier ses propres articles du forum",
"Can post in forums" => "Droit de publier dans le forum",
"Can start threads in forums" => "Droit de démarrer des fils de discussion dans le forum",
"Can read forums" => "Droit de lire des forums",
"Can report msgs to moderator" => "Droit de rapporter des messages vers le modérateur",
"Can vote comments in forums" => "Droit de voter pour des commentaires dans les forums",
"Can admin freetags" => "Peut administrer les freetags",
"Can admin Image Galleries" => "Droit d'administrer les galeries d'images",
"Can assign perms to image gallery" => "Droit d'assigner les droits d'accès des galeries d'images",
"Can upload zip files with images" => "Droit d'envoyer des fichiers zip avec les images",
"Can create image galleries" => "Droit de créer des galeries d'images",
"Can tag objects" => "Droit de marquer des objets",
"Can list image galleries" => "Droit de lister le contenu des galeries d'images",
"Can unassign tags from an object" => "Droit de supprimer des tags associés à un objet",
"Can upload images" => "Droit d'envoyer (upload) des images",
"Can browse freetags" => "Droit de parcourir les freetags",
"Can view image galleries" => "Droit de voir les galeries d'images",
"Can admin newsletters" => "Droit d'administrer les lettres d'informations",
"Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Droit de soumettre des adresses mail par lot (recquiert tiki_p_subscribe email)",
"Can send newsletters" => "Droit d'envoyer des lettres d'informations",
"Can subscribe any email to newsletters" => "Droit de souscrire toute adresse mail aux lettres d'informations",
"Can subscribe to newsletters" => "Droit de s'inscrire à des lettres d'informations",
"Can admin polls" => "Droit d'administrer les sondages",
"Can view poll results" => "Droit de voir des résultats de sondages",
"Can vote polls" => "Droit de voter à un sondage",
"Can admin quizzes" => "Droit d'administrer les QCMs",
"Can take quizzes" => "Droit de remplir des QCMs",
"Can view quiz stats" => "Droit de voir les statistiques du QCM",
"Can view user quiz results" => "Droit de voir les résultats des QCMs",
"Can admin sheet" => "Droit d'administrer les feuillets",
"Can create and edit sheets" => "Droit de créer et éditer des feuillets",
"Can view sheet" => "Droit de voir les feuillets",
"Can view sheet history" => "Droit de voir l'historique des feuillets",
"Can admin shoutbox (Edit/remove msgs)" => "Droit d'administrer le mégaphone Tiki (Éditer/supprimer les msgs)",
"Can post messages in shoutbox" => "Droit de publier des messages dans le megaphone Tiki",
"Can view shoutbox" => "Droit de voir le mégaphone Tiki",
"Can admin surveys" => "Droit d'administrer les enquêtes",
"Can take surveys" => "Droit de remplir des enquêtes",
"Can view survey stats" => "Droit de voir les statistiques des enquêtes",
"Can admin trackers" => "Droit d'administrer les formulaires",
"Can attach files to tracker items" => "Droit d'attacher des fichiers aux fiches de formulaire",
"Can insert comments for tracker items" => "Droit d'ajouter des commentaires aux fiches de formulaire",
"Can view tracker items comments" => "Droit de voir les commentaires des fiches de formulaires",
"Can create new items for trackers" => "Droit de créer de nouvelles fiches de formulaire",
"Can list trackers" => "Droit de lister les formulaires",
"Can change tracker items" => "Droit de changer des fiches de formulaire",
"Can view rating result for tracker items" => "Droit de voir les notations pour les fiches de formulaire",
"Can vote a rating for tracker items" => "Droit de noter les fiches de formulaire",
"Can view trackers" => "Droit de voir les formulaires",
"Can view trackers closed items" => "Droit de voir les fiches de formlaires cloturées",
"Can view trackers pending items" => "Droit de voir les fiches de formulaire en attente",
"Can watch tracker" => "Droit de voir les formulaires",
"Can export tracker items" => "Droit d'exporter des fiches de formulaires",
"Can admin the wiki" => "Droit d'administrer le wiki",
"Can assign perms to wiki pages" => "Droit d'assigner des permissions aux pages wiki",
"Can edit pages" => "Droit de modifier des pages wiki",
"Can edit copyright notices" => "Droit de modifier les messages de copyright",
"Can edit dynamic variables" => "Droit de modifier les variables dynamiques",
"Can create and edit structures" => "Droit de créer et éditer des structures",
"Can export wiki pages using the export feature" => "Droit d'exporter des pages wiki avec la fonctionnalité d'export",
"Can lock pages" => "Droit de verrouiller des pages",
"Can save as minor edit" => "Droit d'enregistrer en tant que version mineure",
"Can remove" => "Droit de supprimer les pages Wiki",
"Can rename pages" => "Droit de renommer des pages",
"Can rollback pages" => "Droit de revenir vers des versions antérieures",
"Can upload pictures to wiki pages" => "Droit d'envoyer des images vers des pages wiki",
"Can use the page as a tracker template" => "Peut utiliser une page comme gabarit de formulaire",
"Can view page/pages" => "Droit de voir les pages wiki",
"Can watch structure" => "Droit de voir les structures",
"Can admin attachments to wiki pages" => "Droit d'administrer les fichiers joints aux pages wiki",
"Can add and change ratings on wiki pages" => "Droit d'ajouter et modifier les notes associées aux pages du wiki",
"Can attach files to wiki pages" => "Droit d'attacher des fichiers aux pages wiki",
"Can view wiki attachments and download" => "Droit de voir les pièces jointes aux pages wiki et de les télécharger",
"Can view wiki comments" => "Droit de voir les commentaires associés aux pages wiki",
"Can view wiki history" => "Droit de voir l'historique des pages wiki",
"Can view rating of wiki pages" => "Droit de voir les notations des pages du wiki",
"Can view source of wiki pages" => "Droit de voir le source des pages wiki",
"Can admin received articles" => "Droit d'administrer les articles reçus",
"Can admin received pages" => "Droit d'administrer les pages reçues",
"Can send articles to other sites" => "Droit d'envoyer des articles vers d'autres sites",
"Can send articles to this site" => "Droit d'envoyer des articles à ce site",
"Can send pages to this site" => "Droit d'envoyer des pages à ce site",
"Can send pages to other sites" => "Droit d'envoyer des pages vers d'autres sites",
"Can admin the TikiTests" => "Droit d'administrer les TikiTests",
"Can edit TikiTests" => "Droit d'éditer des TikiTests",
"Can replay the TikiTests" => "Droit de rejouer des TikiTests",
"Can cache user bookmarks" => "Droit de mettre des signets en antémémoire",
"Can configure modules" => "Droit de configurer des modules",
"Can create user bookmarks" => "Droit de créer des signets utilisateur",
"Can use the mini event calendar" => "Droit d'utiliser Mon Calendrier",
"Can use the notepad" => "Droit d'utiliser le bloc-notes",
"Can admin public tasks" => "Droit d'administrer les tâches publiques",
"Can use tasks" => "Droit d'utiliser les tâches",
"Can send tasks to other users" => "Droit d'envoyer des tâches à d'autres utilisateurs",
"Can upload personal files" => "Droit d'envoyer (upload) des fichiers personels",
"Can create items in personal menu" => "Droit de créer des éléments du menu personnel",
"Can broadcast messages to all user" => "Droit de diffuser des messages vers tous les utilisateurs",
"Can broadcast messages to groups" => "Droit de diffuser des messages vers les groupes",
"Can use the messaging system" => "Droit d'utiliser le système de messagerie",
"Can admin comments" => "Droit d'administrer les commentaires",
"Can edit all comments" => "Droit d'édition de tous les commentaires",
"Can post new comments" => "Droit de publier de nouveaux commentaires",
"Can read comments" => "Droit de lire des commentaires",
"Can delete comments" => "Droit de supprimer des commentaires",
"Can vote comments" => "Droit de voter pour un commentaire",
"Can admin content templates" => "Droit d'administrer les gabarits de contenu",
"Can edit content templates" => "Droit de modifier les gabarits de contenu",
"Can use content templates" => "Droit d'utiliser des gabarits de contenu",
"Can edit HTML pages" => "Droit de modifier les pages HTML",
"Can view HTML pages" => "Droit de voir les pages HTML",
"Can list registered users" => "Droit de lister les utilisateurs enregistrés",
"Admin live support system" => "Droit d'administrer le système d'assistance en ligne",
"Can use live support system" => "Droit d'utiliser le système de support en ligne",
"Can create new mapfile" => "Droit de créer de nouveaux fichiers-carte",
"Can delete mapfiles" => "Droit de supprimer des fichiers-carte",
"Can edit mapfiles" => "Droit de modifier les fichiers-carte",
"Can view mapfiles" => "Droit de voir les fichiers-cartes",
"Can view contents of mapfiles" => "Droit de voir le contenu des fichiers-carte",
"Can use webmail" => "Droit d'utiliser le webmail",
"Can view unapproved plugin details" => "Droit de voir les détails des plugins non autorisés",
"Can execute unapproved plugin" => "Droit d'exécuter des plugins non autorisés",
"Can approve plugin execution" => "Droit d'autoriser l'exécution des plugins",
"Trust all user inputs (no security checks)" => "Faire confiance à toutes les entrées utilisateurs (pas de vérification de sécurité)",
"Can admin mail notifications" => "Droit d'administrer les notifications par mail",
"Can admin categories" => "Droit d'administrer les catégories",
"tiki release" => "Release Tiki",
"tiki needs upgrade" => "Votre Tiki a besoin d'une mise à jour",
"tiki version last check" => "Dernière vérification de la version de Tiki",
"tiki version check frequency" => "Fréquence de vérification de la version de Tiki",
"TotalTime" => "Temps total",
"VideoHeight" => "Hauteur de la vidéo",
"VideoLength" => "Largeur de la vidéo",
"username pattern" => "Patron du nom d'utilisateur",
"server timezone" => "Fuseau horaire du serveur",
"long date format" => "Date au format long",
"long time format" => "Heure au format long",
"short date format" => "Format court pour la date",
"short time format" => "Format court pour l'heure",
"unsuccessful logins" => "Authentification échouée",
"permission denied url" => "URL pour les accès refusés",
"language" => "langue",
"show available translations" => "Montrer les traductions disponibles",
"keep versions" => "Versions conservées",
"sitelogo title" => "Titre du logo du site",
"sitelogo src" => "Source du logo du site",
"smarty notice reporting" => "signaler les notices Smarty",
"proxy host" => "Hôte du proxy",
"proxy port" => "Port du proxy",
"sender email" => "Email de l'expéditeur",
"session lifetime" => "Durée d'une session",
"use proxy" => "Utiliser un serveur proxy",
"country" => "pays",
"user information" => "Info utilisateur",
"theme" => "thème",
"Anti-Bot verification code" => "Code de vérification anti-bot",
"Random Image" => "Image choisie au hasard",
"Enter the code you see above" => "Entrer le code que vous voyez au-dessus",
"List of attached files" => "Liste des fichiers joints",
"uploaded" => "envoyé",
"Remove" => "Supprimer",
"Upload file" => "Envoyer un fichier",
"Attach" => "Joindre",
"Attach a file to this item" => "Joindre un fichier à cette fiche",
"Attachments" => "Fichiers joints",
"more info" => "plus d'informations",
"No attachments for this item" => "Aucun fichier joint à cette fiche",
"Fatal error" => "Erreur fatale",
"Created by" => "Créé par",
"on" => "le",
"Activity=" => "Activité=",
"Properties" => "Propriétés",
"No records found" => "Aucun résultat",
"Select Categories" => "Sélectionner une ou plusieurs catégorie(s)",
"Admin Categories" => "Administrer les catégories",
"Select/deselect all categories" => "Cocher/Décocher toutes les catégories",
"No categories defined" => "Aucune catégorie définie",
"Browse Category" => "Parcourir les catégories",
"stars" => "étoiles",
"User Level" => "Niveau utilisateur",
"private message" => "message privé",
"Send eMail to User" => "Envoyer un email à l'utilisateur",
"user online" => "utilisateur connecté",
"user offline" => "utilisateur non connecté",
"top of page" => "haut de page",
"Reply" => "Répondre",
"Approve" => "Approuver",
"Reject" => "Rejeter",
"Report this post" => "Signaler cette publication",
"Save to notepad" => "Enregistrer dans le bloc-note",
"Monitor this Topic" => "Surveiller ce sujet",
"Stop Monitoring this Topic" => "Arrêter de surveiller ce sujet",
"Group Monitor" => "Surveillance de groupe",
"Watched by categories" => "Surveillé via une catégorie",
"Errors" => "Erreurs",
"Moderator actions" => "Actions du modérateur",
"Move" => "Déplacer",
"Delete Selected" => "Effacer les sélectionnés",
"Unlock" => "Déverrouiller",
"Lock" => "Verrouiller",
"Threshold" => "Seuil",
"Set" => "Valider",
"Replies" => "Réponses",
"below your current threshold" => "en dessous de votre seuil courant",
"Note" => "Remarque",
"New Reply" => "Nouvelle réponse",
"Editing reply" => "Modifier la réponse",
"Reply to the selected post" => "Répondre au message sélectionné",
"Post new message" => "Publier un nouveau message",
"Editing comment" => "Modifier le commentaire sélectionné",
"Comment on the selected post" => "Répondre au commentaire sélectionné",
"Post new comment" => "Publier un nouveau commentaire",
"required" => "obligatoire",
"Toolbars" => "Raccourcis",
"Enter your name" => "Saisir votre nom",
"optional" => "facultatif",
"Reply to parent post" => "Répondre à un message parent",
"Post new reply" => "Publier un nouveau message",
"Post as Anonymous" => "Poster en tant qu'Anonyme",
"Cancel" => "Annuler",
"Posting replies" => "Publier des réponses",
"Posting comments" => "Publier des commentaires",
"Add Comment" => "Commenter",
"1 comment" => "1 commentaire",
"Go back" => "Revenir à la page précédente",
"Return to home page" => "Retour à la page d'accueil",
"Contributors" => "Contributeurs",
"Year" => "Année",
"Authors" => "Auteurs",
"Add" => "Ajouter",
"Tiki Debugger Console" => "Console de debug Tiki",
"Current URL" => "URL courante",
"Command" => "Commande",
"exec" => "exécuter",
"Type <code>help</code> to get list of available commands" => "Taper <code>help</code> pour avoir une liste des commandes disponibles",
"Syntax" => "Syntaxe",
"Page generation debugging log" => "Trace de debug de la génération de la page",
"Features state" => "État de la fonctionnalité",
"features matched" => "fonctionnalités trouvées",
"Watchlist" => "Liste des variables surveillées",
"Duplicate File Gallery" => "Dupliquer une galerie",
"Duplicate categories" => "Dupliquer les catégories",
"duplicate" => "dupliquer",
"There are individual permissions set for this file gallery" => "Des droits d'accès individuels ont été appliqués à cette galerie de fichiers",
"Save" => "Enregistrer",
"View inserted gallery" => "Voir la galerie insérée",
"Required for podcasts" => "Nécessaire pour les podcasts",
"System" => "Système",
"Maximum number of archives for each file" => "Nombre maximum d'archives pour chaque fichier",
"Use" => "Utilisation",
"unlimited" => "illimité",
"none" => "aucun",
"Parent gallery" => "Galerie parente",
"Owner of the gallery" => "Propriétaire de la galerie",
"Group of users alerted when file gallery is modified" => "groupe des utilisateurs alerté quand un élément de la galerie est modifié",
"Allows to select each user for small groups" => "Permettre de sélectionner chaque utilisateur individuellement",
"Display Properties" => "Propriétés d'affichage",
"Default sort order" => "Ordre du tri par défaut",
"Descending" => "Descendant",
"Ascending" => "Ascendant",
"Max description display size" => "Taille maximum affichée de la description",
"Please login" => "SVP, connectez-vous",
"There are no wiki pages similar to '{\$page}'" => "Il n'y a pas de page similaire à '{\$page}'",
"You are not logged in." => "Vous n'êtes pas connecté.",
"Go to Login Page" => "Aller à la page de connexion",
"Create this page" => "Créer cette page",
"(page will be orphaned)" => "(la page sera orpheline)",
"Close Window" => "Fermer la fenêtre",
"Go to" => "Aller dans",
"Private Gallery" => "Galerie privée",
"Active Perms" => "Perms activées",
"Perms" => "Droits",
"Upload New Version" => "Envoyer une Nouvelle Version",
"Replace" => "Remplacer",
"Download and lock" => "Télécharger et verrouiller",
"List" => "Liste",
"Name-filename" => "Nom-Nom du fichier",
"Filename only" => "Nom du fichier uniquement",
"Show as a column" => "Afficher en tant que colonne",
"Show in popup box" => "Montrer dans une popup",
"Show an icon in a column" => "Afficher une icône dans une colonne",
"Exact&nbsp;match" => "Contient&nbsp;exactement",
"any type" => "tout type",
"all topic" => "tous les sujets",
"any language" => "toutes langues",
"any category" => "toutes catégories",
"Number of displayed rows" => "Nombre de lignes affichées",
"in:" => "dans&nbsp;:",
":" => " :",
"Go" => "OK",
"Show php error messages" => "Afficher les messages d'erreurs PHP",
"Folksonomy Tags" => "Marqueurs de folksonomie (freetags)",
"Translate tags" => "Traduire les freetags",
"Images Galleries" => "Galeries d'images",
"Edit this page!" => "Éditer cette page !",
"RSS Blogs" => "RSS Blogues",
"RSS Image Galleries" => "RSS Galeries d'images",
"RSS File Galleries" => "RSS Galeries de fichiers",
"RSS Maps" => "RSS Cartes",
"RSS Directories" => "RSS Répertoires",
"RSS Calendars" => "Calendriers RSS",
"Show Tree" => "Montrer l'Arbre",
"Hide Tree" => "Masquer l'Arbre",
"Move Selected Files" => "Déplacer les fichiers sélectionnés",
"Are you sure you want to delete the selected files?" => "Êtes-vous certain de vouloir détruire les fichiers sélectionnés?",
"Download the zip" => "Télécharger le fichier zip",
"Assign Permissions" => "Attribuer des droits d'accès",
"Move to" => "Déplacer vers",
"Filename" => "Nom du fichier",
"Other Sorts" => "Autres tris",
"No Additionnal Sort" => "Pas de tri additionnel",
"No information" => "Pas d'information",
"The administrator approved your account." => "L'administrateur a validé votre compte.",
"Confirm your email at %s" => "Confirmez votre adresse électronique à %s",
"A new message was posted to forum" => "Un nouveau message a été posté sur le forum ",
"GET:WikiName to get a wiki page" => "GET:NomPageWiki pour récupérer une page Wiki",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:NomPageWikiName pour mettre à jour/créer une page Wiki (le corps du message = le contenu de la page)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:NomPageWikipour ajouter en fin de page Wiki (le corps du message = le contenu de la page à ajouter)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:NomPageWiki pour ajouter en haut de page Wiki",
"Tiki mail-in instructions" => "Instruction pour le mail-in Tiki",
"Tiki mail-in auto-reply." => "Réponse automatique du mail-in Tiki.",
"Hi," => "Bonjour,",
"A new message was posted to you at {\$mail_machine}" => "Un nouveau message vous a été envoyé sur {\$mail_machine}",
"From" => "De",
"New message arrived from %s" => "Un nouveau message est arrivé sur %s",
"Hi" => "Bonjour",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Votre compte pour le site {\$mail_site} a été validé par l'administrateur de ce site. Votre compte est maintenant actif.",
"Enjoy the site!" => "Bonne visite sur le site!",
"User Account Activated" => "Compte utilisateur activé",
"{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> a demandé un mot de passe sur {\$mail_site}, mais vous devez valider son compte d'abord",
"has requested an account on" => "a demandé un compte sur",
"User Registration Request" => "Demande d'inscription d'un utilisateur",
"Go to your friendship network to accept or refuse this request" => "Allez au réseau des amis pour accepter ou refuser cette demande",
"You're invited to join my network of friends!" => "Vous êtes invité à vous joindre à mon réseau d'amis",
"The user" => "L'utilisateur",
"Bye bye!" => "Au revoir!",
"Bye bye from %s at %s" => "Désinscription à %s de %s",
"You can unsubscribe from this newsletter following this link" => "Vous pouvez vous désinscrire de la lettre d'informations en suivant ce lien ",
"Welcome to our newsletter!" => "Bienvenue sur notre lettre d'informations !",
"Welcome to %s at %s" => "Bienvenue sur %s de %s",
"Email notification" => "Email de notification",
"requested a reminder of the password for your account" => "a demandé de vous renvoyer votre mot de passe pour votre compte",
"requested password reset for your account" => "a demandé un nouveau mot de passe pour votre compte",
"Since this is your registered email address we inform that the password for this account is" => "Comme ceci est l'adresse électronique de votre inscription, nous vous informons que le mot de passe pour ce compte est",
"Important: Username & password are CaSe SenSitiVe" => "Important&nbsp;: Nom d'utilisateur et mot de passe tiennent compte de la casse (lettres minuscules vs MAJUSCULES)",
"Important: The old password remains active if you don't click the link above." => "Important&nbsp;: L'ancien mot de passe reste actif tant que vous ne cliquez pas sur le lien ci-dessus",
"Your account information for %s" => "Les informations de votre compte sur %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Un nouvel article a été soumis par {\$mail_user} sur {\$mail_site} le {\$mail_date|tiki_short_datetime}",
"New article submitted at %s" => "Nouvel article soumis sur %s",
"ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} été supprimé dans le formulaire {\$mail_trackerName}",
"Tracker was modified at" => "Formulaire modifié à",
"Confirm your account at %s" => "Confirmez votre compte à %s",
"You or someone registered this email address at" => "Vous (ou quelqu'un d'autre) a inscrit cette adresse électronique à",
"Your registration confirmation" => "Votre inscription Tiki",
"You will receive an email with information to login for the first time into this site" => "Vous allez recevoir un email avec les informations vous expliquant comment activer votre compte.",
"Your account request has been stored and will be activated by the admin as soon as possible." => "Votre demande de compte a été enregistrée et va être traitée dès que possible par un administrateur.",
"You'll receive email notification once your account is activated." => "Vous allez recevoir un courriel dès que votre compte aura été activé.",
"Please do not attempt to login until you receive the email notification." => "Merci de ne pas essayer de vous connecter avant réception du courriel de confirmation.",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "Nouvel article de blogue: {\$mail_title}, \"{\$mail_post_title}\", par {\$mail_user|username} à {\$mail_date|tiki_short_datetime}",
"New blog post at %s" => "Nouvelle publication dans un blogue de %s",
"Modified calendar item" => "Évènement de calendrier modifié",
"New calendar item" => "Nouvel évènement de calendrier",
"changed" => "modifié",
"A new category was created in" => "Une nouvelle catégorie a été créée dans",
"created" => "créé",
"A category was removed in" => "Une catégorie a été supprimée dans",
"Removed by" => "Supprimé par",
"removed" => "supprimé",
"A category was updated" => "Une catégorie a été mise à jour",
"Updated by" => "Mise à jour par",
"Old" => "Vieux",
"New" => "Nouveau",
"updated" => "mis à jour",
"File Gallery %s changed" => "La galerie de fichiers %s a été changée",
"A file was removed from the file gallery" => "Le fichier a été retiré de la galerie",
"File Name" => "Nom du fichier",
"A new file was posted to file gallery" => "Un nouveau fichier a été téléchargé dans la galerie de fichiers",
"Posted by" => "Envoyé par",
"File Description" => "Description du fichier",
"Image Gallery {\$galleryName} changed" => "La galerie d'images {\$galleryName} a changé",
"A new file was posted to image gallery" => "Un nouveau fichier a été téléchargé dans une galerie d'images ",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La carte - {\$mail_page} - a été changée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"An object was added to category" => "Un object a été ajouté dans une catégorie",
"Added by" => "Ajouté par",
"An object was removed from category" => "Un objet a été supprimé d'une catégorie",
"Structure modified" => "Structure modifiée",
"A new file have been attached to page" => "Un nouveau fichier a été attaché à la page",
"File name" => "Nom du fichier",
"New attachment on %s, page" => "Nouveau fichier joint sur la page %s",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été créée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page {\$mail_page} a été supprimée par {\$mail_user} le {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été changée par {\$mail_user} le {\$mail_date|tiki_short_datetime}",
"The changes in this version follow below, followed after by the current full page text." => "Ci-dessous, les changements de cette version suivis du texte complet de la page",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lignes: {\$oldd} changées en +Lignes: {\$newd}",
"The new page content follows below." => "Ci-dessous, le nouveau contenu de la page",
"Wiki page %s created by {\$mail_user}" => "Page Wiki %s créé par {\$mail_user}",
"Wiki page %s deleted by {\$mail_user}" => "Page Wiki %s supprimée par {\$mail_user}",
"Wiki page %s changed by {\$mail_user}" => "Page Wiki %s modifiée par {\$mail_user}",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "La page - {\$mail_page} - a été commentée par {\$mail_user} à {\$mail_date|tiki_short_datetime}",
"Wiki page %s was commented on by" => "La page Wiki %s a été commentée par",
"an anonymous user" => "un utilisateur anonyme",
"Wiki page renamed" => "Page Wiki renommée",
"Old name" => "Ancien nom",
"New name" => "Nouveau nom",
"Thank you for your registration. You may log in now." => "Merci pour votre inscription. Vous pouvez vous connecter maintenant.",
"click on the map to zoom or pan, do not drag" => "cliquer sur la carte pour zoomer ou faire un panoramique, ne pas faire glisser ",
"Query Results" => "Résultats de la requête",
"Querying" => "Requête",
"Scroll Up" => "Défiler vers le haut",
"Scroll Down" => "Défiler vers le bas",
"Scale" => "Échelle",
"Zoom out" => "Zoom arriêre",
"Query" => "Requête",
"Zoom in" => "Zoom avant",
"Redraw" => "Redessiner",
"select zoom/pan/query and image size" => "sélectionner zoom/panoramique/recherche et la taille de l'image",
"View the Map Only" => "Voir la carte seulement",
"Reset Map" => "Réinitialiser la carte",
"Click on the map or click redraw" => "Cliquer sur la carte ou cliquer sur Redessiner",
"Last modification date" => "Date de dernière modification",
"Overview" => "Vue d'ensemble",
"Legend" => "Légende",
"Layer Manager" => "Gestion des couches",
"Layer" => "Couche",
"On" => "Le",
"Download Layer" => "Télécharger une layer",
"This layer has been set by the maps administrator to not be downloadable" => "Cette layer a été configurée par l'administrateur pour ne pas être téléchargeable",
"Mapfiles" => "Fichiers-carte",
"Mapfile" => "Fichier-carte",
"Available mapfiles" => "Fichiers-carte disponibles",
"hits last 7 days" => "visites ces derniers 7 jours",
"monitor this map" => "surveiller cette carte",
"Stop Monitoring this Map" => "Arrêter de surveiller cette carte",
"Create a new mapfile" => "Créer un nouveau fichier-carte",
"Create" => "Créer",
"Mapfile listing" => "Liste des fichiers-carte",
"Reload" => "Recharger",
"History" => "Historique",
"You can view this map in your browser using" => "Vous pouvez afficher cette carte votre navigateur en utilisant",
"Zoom out x2" => "Zoom arrière x2",
"Zoom in x2" => "Zoom avant x2",
"Mapfile History" => "Historique des cartes",
"of" => "de",
"Compare" => "Comparer",
"Comparing version {\$old.version} with version {\$new.version}" => "Comparaison de la version {\$old.version} à la version {\$new.version}",
"Current" => "En&nbsp;cours",
"Versions are identical" => "Les versions sont identiques",
"v=view" => "v=afficher",
"c=compare" => "c=comparer",
"d=diff" => "d=différences",
"Full side-by-side diff" => "Diff. côte à côte complet",
"Unified diff" => "Diff. entrelacé",
"Side-by-side view" => "Affichage côte à côte",
"User" => "Utilisateur",
"Ip" => "IP",
"Diff" => "Différences",
"Older Version" => "Version plus ancienne",
"Directories" => "Répertoires",
"back to" => "revenir à",
"Upload Files" => "Envoyer un fichier",
"Bytes maximum" => "Maximum d'octets",
"Message Archive" => "Message archivé",
"Archive is full!" => "l'archive est pleine !",
"Unread" => "Non-lu",
"Flagged" => "Avec drapeau",
"Unflagged" => "Pas de drapeau",
"Containing" => "Contient",
"Sender" => "expéditeur",
"No messages to display" => "Aucun message à afficher",
"Broadcast message" => "Diffuser un message",
"Please Confirm" => "Confirmer l'envoi",
"All users" => "Tous les utilisateurs",
"Lowest" => "Mini",
"Low" => "Peu prioritaire",
"High" => "Prioritaire",
"Very High" => "Très prioritaire",
"Send" => "Envoyer",
"Compose message" => "Composer un message",
"If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences." => "Si vous voulez donner la possibilité aux autres utilisateurs de vous répondre, activez <a href='tiki-user_preferences.php'>Autoriser les messages d'autres utilisateurs</a> dans vos préférences.",
"ERROR" => "ERREUR",
"Invalid" => "Invalide",
"No messages to download" => "Pas de messages à télécharger",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "La boîte à lettre est pleine! Détruisez ou archivez des messages si vous voulez continuer à en recevoir",
"is reply to" => "répond à",
"Find replied message" => "trouver les messages répondus",
"Mark as read" => "Marquer lu",
"Mark as unread" => "Marquer non-lu",
"Mark as flagged" => "Mettre un drapeau",
"Mark as unflagged" => "Ne pas mettre de drapeau",
"Mark" => "marquer",
"Mailbox" => "Boîte aux lettres",
"Compose" => "Envoyer à des utilisateurs",
"Broadcast" => "Envoyer à un groupe",
"Sent" => "Envoyé",
"Read message" => "Lire le message",
"Return to mailbox" => "Revenir à la boîte principale",
"replyall" => "répondre à tous",
"Unflag" => "Supprimer le drapeau",
"Flag this message" => "Mettre un drapeau à ce message",
"Return to archive" => "Retourner aux archives",
"Return to outbox" => "Retourner à la boîte à lettres",
"Sent Messages" => "Messages envoyés",
"Replied" => "Répondu",
"Not replied" => "Non répondu",
"move to archive" => "mettre dans l'archive",
"receiver" => "destinataire",
"'name' parameter for tikimodule missed" => "le paramètre 'name' manque à tikimodule",
"Move module up" => "Remonter le module",
"Up" => "+haut",
"Move module down" => "Descendre le module",
"Down" => "+bas",
"Move module to opposite side" => "Déplacer le module vers le côté opposé",
"opp side" => "côté opposé",
"Unassign this module" => "Désattribuer ce module",
"Are you sure you want to unassign this module?" => "Êtes vous sûre que vous voulez désattribuer ce module?",
"Toggle module contents" => "Afficher/cacher le contenu du module",
"toggle" => "afficher/cacher",
"Display type unknown, you have to enter the banner type" => "Type de bannière inconnu. Vous devez donner le type de bannière",
"You forgot your Google ad_client number !" => "Vous avez oublié votre nombre Google ad_client!",
"More..." => "La suite...",
"Thank you for installing Tikiwiki" => "Merci d'avoir installé Tiki",
"To configure your Tiki" => "Pour configurer votre Tiki",
"Select" => "Choisir",
"Admin Home" => "Accueil administration",
"Admin" => "Administrer",
"from the menu" => "du menu",
"Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Lire la <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">documentation sur la configuration</a>",
"To remove this module" => "Pour retirer ce module",
"Admin Modules" => "Administrer les modules",
"and remove the assistant module" => "et retirer l'assistant module",
"You can also add other modules" => "Vous pouvez aussi ajouter d'autres modules",
"To customize the menu" => "Pour modifier le menu",
"Admin Menus" => "Administrer les menus",
"and edit menu ID 42" => "et modifier le menu ID 42",
"Or, create your own menu and add it to a module" => "Ou créez votre propre menu et ajoutez-le à un module",
"To begin configuring Tiki, please" => "Pour commencer la configuration de Tiki&nbsp;: ",
"login" => "identification",
"as admin" => "en tant qu'Admin",
"The Tikiwiki Community" => "La Communauté Tikiwiki",
"To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "Pour en savoir plus, visitez: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
"Tikiwiki Documentation" => "Documentation Tikiwiki",
"For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "Pour de l'aide, visitez <a href=\"http://doc.tikiwiki.org\" title=\"Documentation Tikiwiki\" target=\"_blank\">http://doc.tikiwiki.org</a>",
"on blogpost" => "sur l'article de blogue",
"Add event" => "Ajouter un évènement",
"Apply" => "Appliquer",
"Tags This Page Has" => "Tags associés à cette page",
"Add tags" => "Ajouter des tags",
"No records to display" => "Aucun enregistrement à afficher",
"insert original" => "insérer l'original",
"insert thumbnail" => "insérer la miniature",
"more" => "plus",
"Register" => "S'inscrire",
"You" => "Vous",
"Open operator console" => "Ouvrir une console opérateur",
"Logged in as" => "Connecté comme",
"Logout" => "Fermer la connexion",
"Switch User" => "Se connecter comme",
"Switch" => "Échanger",
"Switch user" => "Se connecter comme",
"Login through CAS" => "Connexion avec CAS",
"Login as admin" => "Connexion comme admin",
"Login through Shibboleth" => "Connection via Shibboleth",
"Login as" => "Connexion comme",
"eMail" => "Adresse électronique",
"Password" => "Mot de passe",
"Remember me" => "Mémorisez-moi",
"week" => "semaine",
"month" => "mois",
"year" => "année",
"Click here to register" => "Cliquer ici pour vous inscrire",
"Click here if you've forgotten your password" => "Cliquer ici si vous avez oublié votre mot de passe",
"I forgot my password" => "J'ai oublié mon mot de passe",
"Click here to login using the default security protocol" => "Cliquer ici pour vous connecter avec le protocole de sécurité par défaut",
"Click here to login using a secure protocol" => "Cliquer ici pour vos connecter en utilisant un protocole sécurisé",
"Secure" => "Sécurisé",
"Stay in ssl Mode" => "Rester dans le mode SSL",
"local account" => "compte local",
"OpenID Login" => "Login OpenID",
"You have" => "Vous avez",
"You have 0 new messages" => "Vous n'avez aucun nouveau message",
"We have" => "Il y a",
"submissions waiting to be examined" => "Soumissions en attente d'examen",
"Image Galleries" => "Galeries d'images",
"Calendars" => "Calendriers",
"Entire Site" => "Tout le site",
"Wiki Pages" => "Pages Wiki",
"Image Gals" => "Galeries d'images",
"Blog Posts" => "Articles du blogue",
"Advanced Search Help" => "Aide pour la Recherche Avancée",
"Search Wiki PageName" => "Rechercher une page Wiki par nom",
"Read More" => "En lire plus",
"Since your last visit on" => "Depuis votre dernière visite",
"New Images" => "Nouvelle(s) image(s)",
"Wiki Pages Changed" => "Page(s) Wiki modifiée(s)",
"New Files" => "Nouveau(x) fichier(s)",
"New Comments" => "Nouveau(x) commentaire(s)",
"New Tracker Items" => "Nouvelle(s) fiche(s) de formulaire",
"New Calendar Events" => "Nouveaux évènements du calendrier",
"New Users" => "Nouveau(x) utilisateur(s)",
"click to edit" => "cliquer pour modifier",
"Nothing has changed" => "Aucun changement",
"Site default" => "Réglage par défaut du site",
"TikiTests Menu" => "Menu TikiTests",
"List Tests" => "Liste de Tests",
"Create Test" => "Créer un Test",
"Top galleries" => "Galeries les plus populaires",
"There are no translations of this page." => "Il n'y a pas de traductions de cette page.",
"view" => "afficher",
"Set your preferred languages." => "Mettre à jour vos langues préférées.",
"preferred languages" => "langues préférées",
"update it" => "mettre à jour",
"click to view" => "cliquer pour voir",
"Bookmarks" => "Signets",
"Cache" => "Antémémoire",
"Done" => "fait",
"Del" => "Effacer",
"select" => "choisissez",
"Refresh" => "Réactualiser",
"online users" => "utilisateurs connectés",
"online user" => "utilisateur connecté",
"on host" => "sur le serveur",
"Send a message to" => "Envoyer un message à",
"Send a message" => "Envoyer un message",
"vote" => "voter",
"Requires" => "Nécessite",
"Warning" => "Avertissement",
"Users" => "Utilisateurs",
"Send Newsletter" => "Envoyer la lettre d'informations",
"Insert/Edit an internal wiki link" => "Insérer/Éditer un lien wiki interne",
"Wiki Link insert" => "Inserer un lien Wiki",
"Please make a selection of text in order to create a link" => "Veuillez sélectionner un texte pour pouvoir créer un lien",
"Insert an image" => "Insérer une image",
"Tiki Image - Insert an image" => "Tiki Image - Insérer une image",
"Switch to normal (wiki) editor" => "Basculer dans l'éditeur normal (Wiki)",
"By" => "Par",
"RSS feed" => "Syndication RSS",
"Edit blog" => "Modifier le blogue",
"Monitor this Blog" => "Surveiller ce blogue",
"Stop Monitoring this Blog" => "Arrêter de surveiller ce blogue",
"Read more" => "Lire plus",
"To edit the copyright notices" => "Pour modifier les notices de copyright",
"The content on this page is licensed under the terms of the" => "Le contenu de cette page est licencié sous les termes ",
"Permalink" => "URL du blogue (permalink)",
"comments" => "commentaires",
"First page" => "Première page",
"Previous page" => "Page précédente",
"Next page" => "Page suivante",
"Last page" => "Dernière page",
"referenced by" => "référencés par",
"references" => "références",
"View Comments" => "Afficher les commentaires",
"Trackback pings" => "Pings 'je vous ai référencé'",
"Blog name" => "Nom du blogue",
"Do not group by item" => "Ne pas grouper par élément",
"Group by item" => "Grouper par élément",
"Calendar View" => "Vue calendrier",
"List View" => "Vue en liste",
"Tiki Action Calendar" => "Calendrier des actions Tiki",
"Tools Calendars" => "Calendriers des objets Tiki",
"Check / Uncheck All" => "Cocher/décocher tout",
"Tip" => "Astuce",
"Cancel Edit" => "Annuler la modification",
"Change preferences" => "Modifier les préférences",
"Site Ads and Banners" => "Bannières et publicité du site",
"General" => "Général",
"Features" => "Fonctionnalités",
"Community" => "Communauté",
"Profiles" => "Profils",
"Look & Feel" => "Thèmes & Apparence",
"Meta Tags" => "Méta balises",
"Security" => "Sécurité",
"Connect" => "Connecter",
"User files" => "Fichiers utilisateur",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Pour ajouter ou supprimer un blogue, aller dans \"Ajouter/modifier un blogue\" sous \"Blogues\" dans le menu application, ou",
"General Settings" => "Configuration générale",
"Home Blog (main blog)" => "Accueil - Blogues",
"Create a blog" => "Créer un blog",
"Requires a separate download" => "Nécessite un téléchargement séparé",
"Force and limit categorization to within subtree of" => "Forcer et limiter la catégorisation à cette sous-arborescence",
"Select which items to display when listing blogs" => "Sélectionner les éléments à afficher lors du listing des blogues",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Pour ajouter/supprimer des calendriers, allez à Calendrier sous l'option Administrer du menu application, ou",
"Change settings" => "Changer la configuration",
"General settings" => "Paramètres généraux",
"Default calendars to display" => "Calendrier par défaut à afficher",
"All calendars" => "Tous les calendriers",
"Create calendar" => "Créer un calendrier",
"Default view mode" => "Vue par défaut",
"Day" => "Jour",
"Week" => "Semaine",
"Month" => "Mois",
"Quarter" => "Trimestre",
"Semester" => "Semestre",
"First day of the week" => "Premier jour de la semaine",
"Saturday" => "samedi",
"Sunday" => "dimanche",
"Monday" => "lundi",
"Depends user language" => "Selon langue utilisateur",
"Split hours in periods of" => "Découpage des heures par",
"Manual selection of time/date" => "Sélection manuelle de la date et de l'heure",
"Browse categories" => "Parcourir les catégories",
"Administer categories" => "Administrer les catégories",
"Separate category IDs with a comma (,)" => "Séparer les IDs des catégories avec une virgule (,)",
"Permissions" => "Droits d'accès",
"Will improve performance, but may show forbidden results" => "Augmente les performances, mais risque d'afficher des résultats non autorisés",
"Look under \"Articles\" on the application menu for links to" => "Regardez sous \"Articles\" dans le menu application pour les liens vers",
"Title of articles home page" => "Titre de la page d'accueil des articles",
"Import CSV file" => "Importer un fichier CSV",
"Batch upload (CSV file)" => "Chargement par lot (fichier CSV)",
"Import" => "Importer",
"Select which items to display when listing articles" => "Sélectionner les informations à afficher lors du listing des articles",
"Admin Groups" => "Administrer les groupes",
"Admin Users" => "Administrer les utilisateurs",
"Users can choose to show their gender" => "Les utilisateurs peuvent choisir d'afficher leur genre",
"Show user's information on mouseover" => "Afficher les informations utilisateur lors du passage de la souris",
"Requires user's information to be public" => "Nécessite que les informations de l'utilisateur soient publiques",
"Real name" => "Nom",
"Gender" => "Sexe",
"Number of friends" => "Nombre d'amis",
"Feature is disabled" => "Fonctionalité désactivée",
"Enable now" => "Activer maintenant",
"E-mail" => "Adresse électronique",
"Last login" => "Dernière connexion",
"Default user preferences" => "Préférences par défaut de l'utilisateur",
"Users Default Preferences" => "Préférences de l'utilisateur par défaut",
"Character set for mail" => "Encodage des emails",
"default" => "défaut",
"Number of visited pages to remember" => "Nombre de pages visitées à conserver",
"Displayed time zone" => "Fuseau horaire affiché",
"Detect user timezone if browser allows, otherwise site default" => "Détecter le fuseau horaire utilisateur (si le navigateur le permet). Sinon, appliquer le fuseau horaire par défaut",
"User information" => "Confidentialité",
"Private" => "Privé",
"public" => "publique",
"Use double-click to edit pages" => "Utiliser le double clic pour modifier une page",
"Show user's info on mouseover" => "Montrer ses info. utilisateur au passage de la souris",
"Tasks per page" => "Tâches par page",
"User messages" => "Messages utilisateur",
"Messages per page" => "Messages par page",
"Allow messages from other users" => "Autoriser des messages d'autres utilisateurs",
"Notify sender when reading mail" => "Notifier l'expéditeur lors de la lecture de l'email",
"Send me an email for messages with priority equal or greater than" => "Envoyez-moi un email pour les messages de priorité égale ou supérieure à",
"Auto-archive read messages after x days" => "Archiver les messages automatiquement après x jours",
"never" => "jamais",
"My Tiki" => "Mon Tiki",
"My pages" => "Mes pages",
"My messages" => "Mes messages",
"My tasks" => "Mes tâches",
"My forum topics" => "Mes sujets dans le forum",
"My forum replies" => "Mes réponses dans le forum",
"My items" => "Mes fiches",
"Select which items to display when listing users" => "Sélectionner les informations utilisateurs à afficher lors du listing",
"Score ascending" => "Score croissant",
"Score descending" => "Score décroissant",
"Name ascending" => "Nom croissant",
"Name descending" => "Nom décroissant",
"Login ascending" => "Login croissant",
"Login descending" => "Login décroissant",
"Copyright allows to determine a copyright for all the objects of tikiwiki" => "Le Copyright permet de fixer le droit d'exploitation sur tous les objets du tikiwiki",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Pour configurer vos liens, allez dans \"Administrer les liens \" dans \"Répertoire de liens\" dans le menu application, ou",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Pour créer/supprimer une FAQ, allez dans \"Administrer les FAQs\" dans \"FAQs\" dans le menu application, ou",
"Settings" => "Configurations",
"Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Merci d'aller voir <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>l'évaluation de chaque fonctionnalité</a> sur le site de développement de TikiWiki.",
"Watches" => "Notifications",
"Programmer" => "Codeur",
"To create or remove file galleries, select" => "Pour créer ou supprimer une galerie de fichier, sélectionner",
"from the application menu" => " dans le menu des applications",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Si vous décidez d'archiver les fichiers dans un répertoire vous devez vous assurez que les utilisateurs ne peuvent accéder directement au répertoire.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Vous avez deux options pour effectuer cela:<br /><ul><li>Utiliser un répertoire hors du repertoire Web, assurer vous que votre script php ne peut pas lire et écrire dans ce répertoire</li><li>Uitiliser un répertoire dans le répertoire Web et utiliser un fichier .htaccess pour empêcher les utilisateur de lire le contenu du répertoire</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Pour configurer le chemin du répertoire, utiliser la syntaxe UN*X, comme par exemple&nbsp;: fichiers/ ou c:/foo/fichiers ou /www/fichiers/",
"Home Gallery (main gallery)" => "Accueil - Galerie",
"Create a Gallery" => "Créer une galerie",
"Store in database" => "Stocker en base de données",
"Store in directory" => "Stocker sur le système de fichier dans un répertoire",
"Upload Regex" => "Patron du téléchargement",
"Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "L'application de ces changements <emn'affectera pas </em> les galeries existantes. Ils n'affectent que les nouvelles galeries",
"Select which items to display when listing galleries: " => "Sélectionner les informations que vous souhaitez voir apparaître lors de l'affichage des galeries ",
"Search Indexing" => "Indexation de recherche",
"Automatically index files on upload or change" => "Indexer automatiquement les fichiers lors du téléchargement et des modifications",
"MIME Type" => "Type MIME",
"System Command" => "Commande système",
"Reindex all files for search" => "Ré-indexe tous les fichiers pour la recherche",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Pour créer/supprimer un forum, allez dans \"Administrer les forums\" sous \"Forums\" dans le menu application, ou",
"Home Forum (main forum)" => "Accueil - forums",
"Create a forum" => "Créer un forum",
"Searches" => "Recherches",
"Show tag cloud" => "Afficher le nuage de tag",
"Maximum number of tags in cloud" => "Nombre maximum de tags dans le nuage",
"Separate colors with a comma (,)" => "Séparer les couleurs avec une virgule (,)",
"Number of Tags to show in Tag Suggestions" => "Nombre de tags à présenter dans les suggestions de tags",
"Valid characters pattern" => "Expression régulière des caractères valides ",
"Alphanumeric ASCII characters only" => "Caractères alphanumériques ASCII uniqement",
"No accents or special characters" => "Pas d'accents ou caractères spéciaux",
"basic" => "basique",
"weighted" => "pondéré",
"Tag Management" => "Gestion des freetags",
"Cleanup unused tags" => "Purge des freetags inutilisés",
"Enable freetags 3D browser" => "Activer le navigateur de mots-clés 3D",
"Browser width" => "Largeur du navigateur",
"Graph appearance" => "Apparence du graphique",
"Node color" => "Couleur des noeuds",
"Physics engine" => "Moteur physique",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Pour créer/supprimer une galerie d'images, allez dans \"Galeries d'images\" dans le menu application, ou",
"You can upload images of a size of " => "Vous pouvez envoyer des images d'une taille de ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Modifier les variables dans php.ini&nbsp;: file_uploads, upload_max_filesize, post_max_size et les variables de base de données (max_allowed_packet pour mysql) pour changer cette valeur",
"Home Gallery" => "Accueil-Galerie d'images",
"Galleries features" => "Fonctionnalités des galeries",
"Uses Slideshow" => "Permettre les diaporamas",
"Use database to store images" => "Utiliser la base de données pour stocker les images",
"Use a directory to store images" => "Utiliser un répertoire pour stocker les images",
"Directory path" => "Chemin du répertoire",
"Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Remarque&nbsp;: si vous changez le répertoire, vous devez déplacer le contenu dans le nouveau répertoire. Vous pouvez aussi utiliser l'outil 'Déplacer' ci-dessous.",
"Library to use for processing images" => "Bibliothèque à utiliser pour transformer les images",
"Uploaded image names must match regex" => "Les noms d'images envoyées doivent correspondre aux expressions régulières",
"Uploaded image names cannot match regex" => "Les noms d'images envoyées ne doivent pas correspondre aux expressions régulières",
"Directory Batch Loading" => "Répertoire de téléchargement par lot",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Si vous activez le téléchargement par lot, vous devez créer un répertoire pouvant être lu par le serveur web (de préférence hors de l'arborescence du site). Ensuite installer un moyen d'envoyer les images dans ce répertoire par ftp, scp ou autres",
"Enable directory batch loading" => "Permettre le téléchargement par lot par répertoire",
"Batch loading directory" => "Répertoire de téléchargement par lot",
"Display image informations in a mouseover box" => "Afficher les informations lors du survol de l'image dans une fenêtre popup",
"yes, and don't display those informations under the image" => "Oui et ne plus afficher ces informations sous l'image",
"Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Utiliser les paramètres nombre max de rangées, images par rangée, taille des vignettes et échelle par défaut pour toutes les galeries (valeurs fixées ci-dessous)",
"Max Rows per page" => "Nombre maximum de rangées par page",
"Images per row" => "Nombre d'images par rangée",
"Thumbnails size X" => "Taille X des vignettes",
"Thumbnails size Y" => "Taille Y des vignettes",
"Default scale size" => "Echelle par défaut",
"Set features" => "Valider les fonctionnalités",
"Exterminator" => "Nettoyer les caches",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Supprimer les images de la galerie système qui ne sont pas utilisées dans les pages Wiki, dans les articles ou dans les articles des blogues",
"Mover" => "Déplacer",
"Move images from database storage to filesystem storage" => "Déplacer les images de la base de données vers le filesystem",
"Move images from filesystem storage to database storage" => "Déplacer les images du filesystem vers la base de données",
"All galleries" => "Toutes les galeries",
"System Gallery" => "Galerie système",
"Move images from old filesystem store to new directory" => "Déplace les images de l'ancien filesystem dans un nouveu répertoire",
"Moved" => "Déplacé",
"Gallery listing configuration" => "Configuration de l'affichage des galeries",
"Last modified" => "Modifié",
"Change configuration" => "Modifier la configuration",
"Image galleries comments settings" => "Configuration des commentaires de galeries d'images",
"General Preferences" => "Préférences générales",
"Release Check" => "Vérification des versions",
"Reset or upgrade your database" => "Réinitialiser ou mettre à jour votre base de données",
"Check for updates now" => "Vérifier les mises à jour maintenant",
"Site Identity" => "Identité du site",
"Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Consulter <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> pour plus de préférences pour la personnalisation",
"Mail" => "Email",
"Username" => "Nom d'utilisateur",
"Logging and Reporting" => "Journaux et rapports",
"Include Smarty notices" => "Inclure les avertissements Smarty",
"Server" => "Serveur",
"Miscellaneous" => "Divers",
"Home Page" => "Page d'accueil",
"Custom home" => "Personnaliser l'accueil",
"Use different URL as home page" => "Utiliser une page différente pour la page d'accueil",
"If a requested page doesn't exist, redirect to a similarly named page" => "Lors de l'édition d'une page, rediriger vers une page de nom similaire si celle-ci n'existe pas",
"On permission denied, display login module (for Anonymous)" => "Lors d'un accès refusé, afficher le module de login (pour les anonymes)",
"Send to URL" => "Rediriger vers l'URL",
"Site Access" => "Accès au site",
"Date and Time Formats" => "Format des dates et heure",
"Use site default to show times" => "Utiliser le fuseau horaire par défaut du site",
"Date and Time Format Help" => "Aide sur le format des dates et heures",
"Change admin password" => "Modifier le mot de passe de l'administrateur",
"Change the <strong>Admin</strong> password" => "Changer le mot de passe <strong>Admin</strong>",
"Minimum {\$prefs.min_pass_length} characters long" => "Il faut au minimum {\$prefs.min_pass_length} caractères de long",
"Change password" => "Changer votre mot de passe",
"Defaults" => "Defauts",
"Default x for map center" => "x par défaut pour le centre de la carte",
"Default y from map center" => "y par défaut pour le centre de la carte",
"Default zoom level" => "Niveau du zoom par défaut",
"whole earth" => "toute la terre",
"country size" => "taille pays",
"city size" => "taille ville",
"max zoom" => "zoom maximum",
"Internationalization" => "Internationalisation",
"Babelfish links" => "Liens Babelfish",
"Customized String Translation" => "Traduction personnalisée",
"Syntax error" => "Erreur de syntaxe",
"Intertiki client" => "Client Intertiki",
"Tiki Unique key" => "Clé unique Tiki",
"InterTiki Slave mode" => "Mode InterTiki esclave",
"Warning: overrides manually registered local users" => "Attention: écrase manuellement les utilisateurs localement enregistrés",
"as master" => "comme maître",
"Import user preferences" => "Importer des préférences utilisateur",
"Import user groups" => "Importer des groupes d'utilisateurs",
"Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limiter les groupes importés (liste séparée par des virgules des groupes, laisser vide pour ne pas limiter)",
"Intertiki shared cookie for sliding auth under same domain" => "Cookie partagé par plusieurs Tiki pour le partage de l'authentification pour un même domaine",
"InterTiki Server" => "Serveur InterTiki",
"host" => "hôte",
"Add new server" => "Ajouter un nouveau serveur",
"Intertiki server" => "Serveur Intertiki",
"Intertiki Server enabled" => "Serveur Intertiki activé",
"Access Log file" => "Fichier log des accès",
"Errors Log file" => "Fichier log des erreurs",
"Known hosts" => "Hôtes connus",
"Key" => "Clé",
"Enable/disable Tiki features in " => "Activez/désactivez les fonctionnalités Tiki dans ",
", but configure them elsewhere" => ", mais configurez les dans leurs pages associées",
"Tiki and HTTP Auth" => "Auth Tiki et HTTP",
"Registration" => "Enregistrement",
"Users can register" => "Permettre aux utilisateurs de s'inscrire",
"Validate by email" => "Valider par email",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Vous devez configurer <a href=\"tiki-admin.php?page=general\">Adresse électronique des messages envoyés</a>",
"Require validation by Admin" => "Demande une validation par Admin",
"Require passcode to register" => "Demande une code pour l'enregistrement",
"Users must enter this code to register" => "Les utilisateurs devront saisir ce code pour s'enregistrer",
"Use CAPTCHA to prevent automatic/robot registrations" => "Utiliser CAPTCHA pour se protéger des enregistrements automatiques par des robots",
"Requires PHP GD library" => "Nécessite la bibliothèque PHP GD",
"By default, new users automatically join the Registered group" => "Par défaut, les nouveaux utilisateurs rejoignent le groupe \"Registered\"",
"Account validated successfully." => "Compte validé avec succès.",
"Use tracker to collect more user information" => "Utiliser les formulaires pour collecter des informations complémentaires sur les utilisateurs",
"Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Utiliser <strong><a href=\"tiki-admingroups.php\" title=\"Administration des groupes\">Administration: Groupes</a></strong> pour sélectionner quel formulaire et champ(s) à afficher",
"Use tracker to collect more group information" => "Utiliser le formulaire pour collecter plus d'informations sur les groupes",
"Re-validate user by email after" => "Demander aux utilisateurs de se confirmer par courrier électronique après",
"Use <strong>-1</strong> for never" => "Utilisez <strong>-1</strong> pour jamais",
"unsuccessful login attempts" => "logins non réussis",
"Create a new group for each user" => "Créer un nouveau groupe pour chaque utilisateur",
"The group will be named identical to the user's username" => "Le groupe portera le même nom que celui de l'utilisateur",
"Disable browser's autocomplete feature for username and password fields" => "Désactiver la fonction de complétion automatique du navigateur pour les champs username et le mot de passe",
"Use challenge/response authentication" => "Utiliser une authentification challenge/réponse",
"Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirmer que le compte Admin possède une adresse mail valide ou vous ne pourrez pas vous connecter",
"Allow secure (https) login" => "Permettre une connexion sécurisée (HTTPS)",
"Encourage secure (https) login" => "Encourager les connexions sécurisés (HTTPS)",
"Consider we are always in HTTPS, but do not check" => "Considère que nous sommes toujours en HTTPS, sans le vérifier",
"Require secure (https) login" => "Exiger une connexion sécurisée (HTTPS)",
"Users can choose to stay in SSL mode after an HTTPS login" => "Les utilisateurs peuvent choisir de rester en mode SSL après un login HTTPS",
"Users can switch between secured or standard mode at login" => "Les utilisateurs peuvent commuter entre le mode standard et le mode sécurisé au login",
"User's choice" => "Choix de l'utilisateur",
"Use email as username" => "Utiliser l'email en tant que nom d'utilisateur",
"Force lowercase" => "Forcer en minuscules",
"Users can change their password" => "Les utilisateurs peuvent changer leur mot de passe",
"Require characters and numerals" => "Exiger des caractères alphanumériques",
"Password expires after" => "Mot de passe expire après",
"Create user if not in Tiki" => "Créer l'utilisateur si il n'existe pas dans Tiki",
"Use Tiki authentication for Admin login" => "Utiliser l'authentification Tiki pour le compte Admin",
"Will override the Host and Port settings" => "Surcharge les paramètres de Serveur et de Port",
"PAM" => "AuthentificationPAM",
"You must change the Authentication Method to PAM for these changes to take effect" => "Vous devez changer la méthode d'authentification en PAM pour que les options ci-dessous soient exploitées",
"Currently unused" => "Actuellement non utilisé",
"Shibboleth Authentication " => " Authentification Shibboleth ",
"You must change the Authentication Method to Shibboleth for these changes to take effect" => "Vous devez changer la méthode d'authentification en Shibboleth pour que les options ci-dessous soient exploitées",
"Separate multiple affiliations with commas" => "Utiliser la virgule pour séparer les affiliations multiples",
"Create with default group" => "Créer avec le groupe par défaut",
"You must change the Authentication Method to CAS for these changes to take effect" => "Vous devez changer la méthode d'authentification en CAS pour que les options ci-dessous soient exploitées",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Vous devez aussi envoyer la <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">bibliothèque phpCAS</a> séparément dans lib/phpcas/.",
"CAS Server" => "Serveur CAS",
"You must enable PHP CAS first" => "Vous devez activer PHP CAS d'abord",
"Theme options" => "Options du thème",
"Theme not saved yet - click \"Apply\"" => "Le thème n'est pas encore sauvegardé - cliquer sur \"Appliquer\"",
"Users can change theme" => "Les utilisateurs peuvent changer de thème",
"Restrict available themes" => "Limiter les thèmes disponibles",
"Each group can have its theme" => "Chaque groupe peut avoir son propre thème",
"Edit CSS" => "Modifier le CSS",
"Theme Control" => "Contrôle des thèmes",
"Tiki Template Viewing" => "Affichage du gabarit Tiki",
"View Templates" => "Voir les gabarits",
"Edit Templates" => "Modifier les gabarits",
"General Layout options" => "Options générales de mise en page",
"Custom Site Header" => "En-tête du site sur mesure",
"logged as" => "Connecté comme",
"Site Logo and Title" => "Titre et logo du site",
"Examples" => "Exemples",
"Alt. description (e.g. for text browsers)" => "Description Alt. (pour les navigateurs textuels)",
"Site title" => "Titre du Site",
"Subtitle" => "Sous-titre",
"Top Bar" => "Barre du haut",
"Site menu bar" => "Barre de menu sur le site",
"Menu ID" => "ID du menu",
"Custom code" => "Personnalisation du code",
"Left column" => "Colonne de gauche",
"always" => "toujours",
"user decides" => "l'utilisateur décide",
"Users can Flip Columns" => "Les utilisateurs peuvent afficher/cacher la colonne",
"Right column" => "Colonne de droite",
"Site location bar" => "Fil d'Ariane du site",
"Larger font for" => "Police de caractères plus large pour",
"Custom Site Footer" => "Bas de page du site sur mesure",
"Bottom bar" => "Barre du bas",
"Bottom bar icons" => "Barre du bas avec les icônes",
"Bottom bar debug" => "Barre du bas de debug",
"Bottom bar (RSS)" => "Barre du bas (RSS)",
"Webmaster Email" => "Email du webmaster",
"Email this page" => "Envoyez cette page par courrier électronique",
"Pagination links" => "Liens de pagination",
"Maximum number of records in listings" => "Nombre maximum d'éléments affichés dans chaque liste",
"Use relative (next / previous) pagination links" => "Utiliser des liens de pagination (suivant / précédent) relatifs",
"Use direct pagination links" => "Utiliser les liens de pagination directs",
"Display 'First' and 'Last' links" => "Afficher les 'Premier' et 'Dernier' liens",
"Display fast move links (by 10 percent of the total number of pages) " => "Afficher des liens rapides (par tranches de 10% du nombre total de pages)",
"Hide pagination when there is only one page" => "Masquer la pagination lorsqu'il n'y a qu'une seule page",
"Use Icons" => "Utiliser les icones",
"Requires jquery feature" => "Nécessite la fonctionnalité jquery",
"For future use" => "Pour une utilisation future",
"Fast" => "Rapide",
"Slow" => "Lente",
"Use Tabs" => "Utiliser les onglets",
"Layout per section" => "Mise en page par section",
"Admin layout per section" => "Administrer la mise en page par section",
"Use context menus for actions (icons)" => "Utiliser des icons pour les actions des menus contextuels",
"Use context menus for actions (text)" => "Utiliser du texte pour les actions des menus contextuels",
"Separators" => "Séparateur",
"Generate User Map" => "Générer la carte utilisateur",
"ProgressBar Color" => "Couleur de la barre de progression",
"Volume Button Color" => "Couleur du bouton de volume",
"Button Color" => "Couleur du bouton",
"Button Info Color" => "Couleur du bouton d'information",
"Button Info Pressed Color" => "Couleur du bouton d'information lors d'une pression",
"Button Info Text Color" => "Couleur du texte du bouton d'information",
"ID3 Tag Color" => "Couleur des tags ID3",
"Play Time Color" => "Couleur de la position du temps de lecture",
"Total Time Color" => "Couleur du temps total",
"Video Length" => "Largeur de la vidéo",
"Video Heigth" => "Hauteur de la vidéo",
"Compression is handled by" => "La compression est gérée par",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Pour créer/supprimer un sondage, aller dans \"Sondages\" sous \"Admin\" dans le menu application",
"Waiting" => "En attente",
"TikiWiki Profiles" => "Profils TikiWiki",
"Profile" => "Profil",
"Repository" => "Dépot",
"Last update" => "Modifié le",
"Repositories" => "Dépôts",
"Enter multiple repository URLs, one per line" => "Saisir plusieurs URLs de dépot, une par ligne",
"More information" => "Plus d'informations",
"Feed for articles" => "Canaux de syndication des articles",
"Feature is disabled." => "Fonctionalité désactivée.",
"Image galleries" => "Galeries d'images",
"Feed for image galleries" => "Canal de syndication pour les galeries d'images",
"Feed for file galleries" => "Canaux de syndication des galeries de fichiers",
"Feed for wiki" => "Canaux de syndication de wiki",
"Feed for forums" => "Syndication des forums",
"Calendar events" => "Évènements du calendrier",
"Feed for directory" => "Canaux de syndication des répertoires des liens",
"Map files" => "Fichiers de cartes",
"Feed for maps" => "Canaux de syndication des cartes",
"Specification" => "Spécification",
"Use <strong>0</strong> for no caching" => "Utiliser <strong>0</strong> pour désactiver la mise en cache",
"Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Activer la mise en antémémoire (caching) va passer outre aux permissions existantes - Tout le contenu sera public. N'activer cette option <strong>que</strong> si votre contenu syndiqué peut être public.",
"You can see users rank by score in the module users_rank, for that go to" => "Vous pouvez voir le classement des utilisateurs dans le modules users_rank, pour cela allez à",
"Admin modules" => "Administrer les modules",
"can be seen on page" => "peut être vu sur la page",
"in Admin menu" => "dans le menu Admin",
"Search type" => "Type de recherche",
"This search uses the MySQL Full-Text feature" => "Cette recherche utilise la recherche Full-Text de MySQL",
"Tiki search" => "Recherche Tiki",
"Specify the Tiki search settings" => "Définir les paramètres de recherche Tiki",
"Use <strong>0</strong> for no refresh" => "Utiliser <strong>0</strong> pour désactiver le rafraichissement",
"Refresh wiki search index now" => "Refaire la table d'index des pages Wiki maintenant",
"Refresh trackers search index now" => "Réactualiser les indexes des formulaires maintenant",
"Refresh tracker search index now" => "Réactualiser les indexes des formulaires maintenant",
"May impact performance" => "Peut impacter les performances",
"Search Results" => "Résultat de la recherche",
"Select the information to display for each result" => "Sélectionner les informations à afficher pour chaque résultat",
"See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "Consulter <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> pour plus de paramétrages de sécurité",
"CSRF Security" => "Sécurité contre CSRF (Cross-Site Request Forgeries)",
"Use these options to protect against cross-site request forgeries (CSRF)" => "Utiliser cette option pour se protéger des Cross-Site Request Forgeries (CSRF)",
"Known Types" => "Types connus",
"Token" => "Jeton",
"Text area (that apply throughout many features)" => "Zones de texte (que l'on retrouve à travers plusieurs fonctionnalités)",
"Automonospaced text" => "Texte à espacement constant",
"Tables syntax" => "Syntaxe des tables",
"|| for rows" => "|| pour les rangées",
"&lt;return&gt; for rows" => "&lt;Entrée&gt; pour les rangées",
"AutoLinks" => "Liens automatiques",
"Hotwords" => "Mot/liens automatiques",
"Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Pour le texte auquel on répond, utilise le plugin QUOTE à la place de &ldquo;&gt;&rdquo;",
"Default size" => "Taille par défaut",
"External links will be identified with" => "Les liens externes seront identifiés par",
"About plugins" => "A propos des plugins",
"About plugin aliases" => "A propos du \"plugin aliases\"",
"This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "Cette page a été conçue pour fonctionner avec JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
"General Information" => "Informations générales",
"Plugin Name" => "Nom du plugin",
"Base Plugin" => " Plugin de base",
"Dependencies" => "Dépendances",
"New Argument" => "Nouveau argument",
"Required" => "Requis",
"Parameters" => "Paramètres",
"Encoding" => "Encodage",
"Default Value" => "Valeur par défaut",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Pour configurer vos formulaires, allez sur \"Administrer les formulaires\" sous \"Formulaires\" dans l'application menu, ou",
"Use database to store files" => "Utiliser la base de données pour stocker les fichiers",
"Use a directory to store files" => "Utiliser un répertoire pour stocker les fichiers",
"dls" => "téléchgts",
"Storage" => "Stockage",
"No records" => "Aucun résultat",
"Change all to db" => "Les mettre tous dans la base de données",
"Change all to file" => "Les mettre tous en fichiers",
"Trackers with mirror tables" => "Formulaires avec des tables miroirs",
"Use trackers with mirror tables" => "Utiliser les formulaires avec les tables miroirs",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Les valeurs sont stockées dans une table dédiée pour chaque formulaire. Elles peuvent ainsi être facilement manipulées à l'extérieur de Tikiwiki",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "ATTENTION&nbsp;: Les anciens et nouveaux formulaires ne peuvent pas cohabiter. Les formulaires créés avec la nouvelle bibliothèque ne fonctionneront pas avec l'ancienne et vice-versa",
"Validate choice" => "Valider le choix",
"Use database to store userfiles" => "Utiliser la base de données pour stocker les fichiers utilisateurs",
"Use a directory to store userfiles" => "Utiliser un répertoire pour stocker les fichiers utilisateurs",
"Create New" => "Créer un nouveau",
"Not supported" => "Non supporté",
"Schema Version" => "Version du schéma",
"Schema Documentation" => "Documentation du schéma",
"Content Type" => "Type de contenu",
"Not specified" => "Non spécifié",
"Page display" => "Affichage d'une page",
"Page ID" => "ID de la page",
"Page version" => "Version de la page",
"List authors" => "Liste des auteurs",
"Not Installed" => "Pas installé",
"Warn on edit conflict" => "Avertir en cas de conflit de modification",
"Undo" => "Annuler",
"Footnotes" => "Notes de bas de page",
"Permission" => "Droit d'accès",
"Allow HTML" => "Permettre le HTML",
"Edit section" => "Éditer la section",
"Allow minor edits" => "Autoriser les modifications mineures",
"Log bytes changes (+/-) in action logs" => "Journaliser les changements d'octets (+/-) dans le journal des actions",
"Sandbox" => "Bac à sable",
"Display by default" => "Afficher par défaut",
"Manage attachments" => "Administrer les fichiers joints",
"Dumps" => "Fichiers-dump",
"Restore" => "Restaurer",
"Generate dump" => "Générer un fichier-dump",
"Download last dump" => "Télécharger le dernier fichier-dump",
"Pictures" => "Images",
"Use File Galleries to store pictures " => "Utiliser les galeries de fichiers pour stocker les images ",
"Remove unused pictures" => "Supprimer les images inutilisées",
"Export" => "Exporter",
"Export Wiki Pages" => "Exporter les pages Wiki dans un Dump PhpWiki",
"WikiWords" => "Mots Wiki",
"Accept dashes and underscores in WikiWords" => "Accepter les tirets et les tires bas(underscores) dans les mots Wiki",
"Link plural WikiWords to their singular forms" => "Lier les pluriels des MotWikis à leur singulier",
"Never delete versions younger than" => "Ne jamais supprimer une version plus jeune que",
"Display IP address" => "Afficher l'adresse IP",
"Default diff style" => "Style par défaut du diff",
"Only with last version" => "Seulement avec la dernière version",
"HTML diff" => "diff HTML",
"Side-by-side diff" => "Diff. côte à côte",
"Side-by-side diff by characters" => "Diff. côte à côte sur les caractères",
"Inline diff" => "Diff. entrelacée",
"Inline diff by characters" => "Diff. entrelacée sur les caractères",
"Full side-by-side diff by characters" => "Diff. côte à côte complète sur les caractères",
"Full inline diff" => "Diff. entrelacée complète",
"Full inline diff by characters" => "Diff. entrelacée complète sur les caractères",
"Discuss pages on forums" => "Discuter les pages dans un forum",
"Forums are disabled." => "Les forums sont disactivés.",
"View source" => "Voir fichier source",
"Similar" => "Similaire",
"Open page as structure" => "Ouvrir une page en tant que structure",
"Make structure from page" => "Créer une structure avec la page",
"Categorize structure pages together" => "Catégoriser les structures de pages ensemble",
"Import HTML" => "Importer du HTML",
"Import pages" => "Import de pages",
"Slideshows" => "Diaporama",
"User's page" => "Page de l'utilisateur",
"Users can lock pages" => "Les utilisateurs peuvent verrouiller les pages",
"Page creators are admin of their pages" => "L'auteur de la page est administrateur de celle-ci",
"MultiPrint" => "Multi-impression",
"Wiki watch" => "Surveillance Wiki",
"Create watch for author on page creation" => "Activer la surveillance de la page pour l'auteur automatiquement à la création de la page",
"Enable watch events when I am the editor" => "Envoyer une notification de changement même si je suis l'éditeur",
"Enable watches on comments" => "La surveillance d'une page tient compte des commentaires",
"Watch minor edits" => "Surveiller les modifications mineures",
"Hide page name prefix" => "Cacher le préfixe des noms de page",
"Approved" => "Approuvé",
"Out-of-sync" => "Désynchronisé",
"Page Listings" => "Préférences d'affichage",
"Links" => "Liens",
"Categories path" => "Chemin des catégories",
"Wiki 3D Browser Configuration" => "Configuration du navigateur Wiki 3D",
"Camera settings" => "Propriétés de la caméra",
"Maximum size" => "Taille maximum",
"Wiki attachments" => "Fichiers joints Wiki",
"Change" => "Modifier",
"Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg signifie \"What You See Is What You Get\" (Ce que vous avez est ce que vous obtenez) et est implémenté dans Tikiwiki par <a href=\"http://fckeditor.net\">FCKeditor</a>",
"Wysiwyg Editor Features" => "Options de l'éditeur wysiwyg",
"Database Version Problem" => "Il y a un problème avec la version de votre base de données",
"disabled" => "désactivé",
"enabled" => "activé",
"Crosslinks to other features and settings" => "Liens vers d'autres fonctionnalités et configurations",
"Other sections" => "Autres sections",
"Spreadsheet" => "Tableur",
"Shoutbox Words" => "Tabous du mégaphone",
"Live Support" => "Assistance en ligne",
"Contact us" => "Nous contacter",
"Administration features" => "Fonctionnalités d'administration",
"SysLogs" => "Logs système",
"Banning" => "Interdiction",
"Transversal features" => "Fonctionnalités transversales",
"which apply to more than one section" => "qui s'appliquent à plus d'une section",
"Mail Notifications" => "Notification par courrier",
"Navigation features" => "Fonctionnalités de navigation",
"Look & feel" => "Aspect &amp; conviviabilité",
"themes" => "thèmes",
"Text area features" => "Fonctionnalités des zones de texte",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "fonctionnalités que vous pouvez utiliser dans toutes les zones de texte, comme dans les pages Wiki, les blogues, les articles, les forums",
"Cookies" => "Citations",
"Content Templates" => "Gabarits de contenu",
"Stats &amp; banners" => "Statistiques &amp; bannières",
"Search Stats" => "Statistiques des recherches",
"Report" => "Rapport",
"Please select some actions to view." => "Veuillez sélectionner des actions à visualiser.",
"bytes" => "octets",
"contributor" => "contributeur",
"Edit Action" => "Modifier l'action",
"Save Action" => "Sauvegarder l'action",
"Statistics" => "Statistiques",
"Volumes are equally distributed on each contributors/author" => "Les volumes sont distribués équitablement entre chaque contributeur ou auteur",
"connection time" => "durée de connexion",
"connection seconds" => "seconde de connexion",
"Volumn per category" => "Volume par catégorie",
"Volumn per category and per user" => "Volume par catégorie et par utilisateur",
"Number of actions per user" => "Nombre d'actions par utilisateur",
"Total number of users" => "Nombre total d'utilisateurs",
"Number of actions per object" => "Nombre d'actions par objet",
"Total number of objects" => "Nombre total d'objets",
"Number of actions per category" => "Nombre d'actions par catégorie",
"Number of actions per category and per user" => "Nombre d'actions par catégorie et par utilisateur",
"Volumn per the users'group and per contribution" => "Volume par le groupe de l'utilisateur et par contribution",
"Volumn per group and per contribution" => "Volume par groupe et par contribution",
"Volumn per user and per contribution" => "Volume par utilisateur et par contribution",
"Volumn per users'contribution and time" => "Volume par contribution d'utilisateur et heure",
"Volumn per contribution and time" => "Volume par contribution et heure",
"Weeks" => "Semaines",
"Setting" => "Configuration",
"recorded" => "enregistré",
"viewed" => "vu",
"Wiki page actions except viewed will always be recorded but can be not reported" => "Les actions sur les pages Wiki sauf la visualisation seront toujours enregistrées mais peuvent ne pas être affichées",
"Add or edit a rule" => "Ajouter/modifier une règle",
"Rule title" => "Titre de la règle",
"Username regex matching" => "Expression régulière sur les noms d'utilisateur",
"IP regex matching" => "Expression régulière sur les IP",
"Banned from sections" => "Interdit des sections",
"Rule activated by dates" => "Règle activée sur des dates",
"Rule active from" => "Règle active depuis",
"Rule active until" => "Règle active jusqu'à",
"Custom message to the user" => "Message personnalisé à l'utilisateur",
"Rules" => "Règles",
"x" => "supprimer",
"User/IP" => "Utilisateur/IP",
"Admin Calendars" => "Administrer les calendriers",
"Create Calendar" => "Créer un calendrier",
"View Calendars" => "Voir les calendriers",
"List of Calendars" => "Liste des calendriers",
"Subscription" => "Inscription",
"View Calendar" => "Voir le Calendrier",
"Add Event" => "Ajouter un évènement",
"Create/Edit Calendars" => "Créer/Éditer un calendrier",
"Custom Locations" => "Lieux configurables",
"Custom Participants" => "Participants configurables",
"Custom Categories" => "Catégories configurables",
"Custom Languages" => "Langues configurables",
"Custom URL" => "Adresses URL configurables",
"Custom Subscription List" => "Liste d'inscriptions configurables",
"Custom Priorities" => "Priorités configurables",
"Personal Calendar" => "Calendrier personnel",
"Start of day" => "Début de la journée",
"End of day" => "Fin de la journée",
"Standard Colors" => "Couleurs standard",
"Green" => "Vert",
"Blue" => "Bleu",
"Purple" => "Violet",
"Red" => "Rouge",
"Yellow" => "Jaune",
"Let me select my own colors" => "Me permettre de choisir mes propres couleurs",
"Custom foreground color" => "Couleur d'avant-plan particulière",
"Custom background color" => "Couleur du fond personnalisée",
"Default event status" => "État par défaut des évènements",
"Show in calendar view" => "Afficher dans la vue calendrier",
"Group of users alerted when calendar event is modified" => "Groupe d'utilisateurs alerté quand le calendrier est modifié",
"Current category" => "Catégorie courante",
"Child categories" => "Sous-catégories",
"Edit permissions for this category" => "Modifier les permissions pour cette catégorie",
"Add new category" => "Ajouter une nouvelle catégorie",
"Objects in category" => "Objets dans la catégorie",
"Remove from this Category" => "Supprimer de cette catégorie",
"No records found." => "Aucun résultat.",
"Add objects to category" => "Ajouter des objets à la catégorie",
"Admin templates" => "Administrer les gabarits",
"Create new template" => "Créer un nouveau gabarit",
"Use wysiwyg editor" => "Utiliser un éditeur Wysiwyg",
"Use normal editor" => "Utiliser un éditeur non Wysiwyg",
"Use in" => "Utilisé dans",
"CMS" => "Articles",
"HTML Pages" => "Pages HTML",
"No features are configured to use templates." => "Aucune fonctionnalité n'utilise les gabarits.",
"Templates" => "Gabarits",
"Admin Contributions" => "Administrer les contributions",
"Contributions are mandatory in wiki pages" => "Contributions obligatoires dans les pages wiki",
"Contributions are mandatory in forums" => "Contributions obligatoires dans les forums",
"Contributions are mandatory in comments" => "Contributions obligatoires dans les commentaires",
"Contributions are mandatory in blogs" => "Contributions obligatoires dans les blogues",
"Contributions are displayed in the comment/post" => "Contributions affichées avec les commentaires ou les articles",
"Create a new contribution" => "Créer une nouvelle contribution",
"List of contributions" => "Liste des contributions",
"Admin cookies" => "Administrer les cookies",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Pour utiliser un cookie dans une zone de texte (page Wiki, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Ajouter/modifier un cookie",
"Upload Cookies from textfile" => "Envoyer un fichier texte de citations",
"Upload" => "Envoyer",
"Remove all cookies" => "Supprimer tous les cookies",
"Admin dsn" => "Administrer les DSNs",
"Use Admin DSN to define the database to be used by the SQL plugin." => "Aller à Administration->DSN pour définir la base de données utilisée dans le plugin SQL.",
"Create/edit dsn" => "Ajouter/modifier un DSN (Data Source Name)",
"Admin External Wikis" => "Administrer des Wikis externes",
"View template" => "Afficher le gabarit",
"tiki admin external wikis template" => "gabarit de l'administration des Wiki externes",
"Edit template" => "Modifier le gabarit",
"Create/Edit External Wiki" => "Créer/modifier un Wiki externe",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "Adresse Web ( \$page sera remplacé par le nom de la page dans l'URL - exemple&nbsp;: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Wiki externe",
"Admin Forums" => "Administrer les forums",
"Create new forum" => "Créer un nouveau forum",
"Duplicate forum" => "Dupliquer un forum",
"View this forum" => "Voir ce forum",
"Import forums" => "Importer des forums",
"List forums" => "Liste des forums",
"Age" => "Âge",
"PPD" => "Ar/jo",
"Create New Forum" => "Créer un nouveau forum",
"There are individual permissions set for this forum" => "Des droits d'accès individuels ont été mis sur ce forum",
"Create new" => "Créer une nouvelle",
"Password protected" => "Protéger par un mot de passe",
"Forum password" => "Mot de passe du forum",
"Topic list configuration" => "Configuration de la liste des sujets",
"Posts can be rated" => "Les publications peuvent être notées",
"Display last post titles" => "Afficher les titres des dernières publications",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Faire suivre les messages de ce forum à cette adresse électronique, dans un format pouvant être renvoyé au forum",
"Send mails even when the post is generated by inbound mail" => "Envoyer un mail, si le commentaire posté est généré par une procédure de mail interne",
"Append a reply link to outbound mails" => "Ajouter un lien de réponse aux messages sortants",
"Originating e-mail address for mails from this forum" => "Adresse électronique de l'expéditeur des messages du forum",
"Add messages from this email to the forum" => "Ajouter les messages venant de cette adresse électronique au forum",
"Use topic smileys" => "Pouvoir mettre un émoticône sur un sujet",
"Show topic summary" => "Afficher le résumé du sujet",
"User information display" => "Informations affichées de l'éditeur",
"Online" => "Connecté",
"Approval type" => "Type d'approbation",
"Set topics preferences" => "Définir les préférences des sujets",
"Show topics preferences" => "Afficher les préférences des sujets",
"hide topics preferences" => "Masquer les préférences des sujets",
"Duplicate Forum" => "Dupliquer un forum",
"Duplicate perms" => "Dupliquer les droits d'accès",
"Duplicate" => "Dupliquer",
"Admin Hotwords" => "Administrer les mot/liens automatiques",
"Add Hotword" => "Ajouter un mot/lien automatique",
"Word" => "Mot",
"Admin HTML Page Dynamic Zones" => "Administrer les zones dynamiques des pages HTML",
"Admin HTML pages" => "Administrer les pages HTML",
"Edit this page" => "Modifier cette page",
"View page" => "Afficher la page",
"Edit zone" => "Modifier une zone",
"Dynamic zones" => "Zones dynamiques",
"content" => "contenu",
"Mass update" => "Mise à jour massive",
"Create new HTML page" => "Créer une nouvelle page HTML",
"Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Utiliser {literal}{ed id=name}{/literal} ou {literal}{ted id=name}{/literal} pour insérer des zones dynamiques",
"Apply template" => "Appliquer un gabarit",
"Dynamic" => "Dynamique",
"Static" => "Statique",
"Refresh rate (if dynamic)" => "Temps de rafraichissement (si dynamique)",
"Last Modif" => "Dernière modif.",
"An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "Un moyen facile d'intégrer le contenu d'un autre site dans Tiki est via des liens iframe utilisant la fonctionnalité Tiki <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> .",
"Create New Repository" => "Créer un nouveau répertoire",
"List Repositories" => "Liste des répertoires",
"New Repository" => "Nouveau répertoire",
"View Repository" => "Afficher le répertoire",
"Human readable repository name" => "Nom compréhensible du répertoire",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Chemin d'accès au répertoire (si local&nbsp;: relative ou absolu / racine web - sinon: préfixé avec 'http://'",
"File name of start page" => "Nom du fichier pour la première page",
"Start page" => "Première page",
"CSS file to load when browse this repository" => "Fichier CSS à charger pour parcourir ce répertoire",
"CSS file" => "Fichier CSS",
"Is repository visible to users" => "Ce répertoire est-il visible par les utilisateurs",
"Can files from repository be cached" => "Les fichiers du répertoire peuvent-ils être mis en antémémoire",
"Cacheable" => "Peut être mis en antémémoire",
"Are files from repository can be cached" => "Les fichiers du répertoire peuvent ils être dans l'antémémoire",
"Clear all cached pages of this repository" => "Supprimer toutes les pages de ce répertoire qui ont été mis dans l'antémémoire",
"Clear cache" => "Vider l'antémémoire",
"Seconds count 'till cached page will be expired" => "Secondes jusqu'à ce que la page en antémémoire soit supprimé",
"Cache expiration" => "Expiration de l'antémémoire",
"Human readable text description of repository" => "Description compréhensible du répertoire",
"Available Repositories" => "Répertoires disponibles",
"CSS File" => "Fichier CSS",
"Edit rules" => "Modifier les règles",
"Configure Repositories" => "Configurer les répertoires",
"Configure this Repository" => "Configurer ce répertoire",
"View this Repository" => "Voir ce répertoire",
"New Rule" => "Nouvelle règle",
"Copy Rules" => "Recopie des règles",
"view/hide copy rules dialog" => "afficher/masquer le dialogue des règles pour copier",
"Source repository" => "Répertoire source",
"Copy" => "Recopie",
"According this order rules will be applied ('0' or empty = auto)" => "Ordre dans lequel les règles s'appliquent ('0' ou vide = automatique)",
"Rule order" => "Ordre des règles",
"Text to search for" => "Texte recherché",
"Text to replace" => "Texte à remplacer",
"Is this regular expression or simple search/replacer" => "Est ce une expression régulière ou un simple chercher/remplacer",
"Is case sensitive (for simple replacer)" => "La casse est-elle prise en compte (pour un simple remplacer)",
"Case sensitive" => "Casse prise en compte",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "sous ensemble de caractères&nbsp;: imsxeADSXUu, qui sont des modificateurs Regex",
"Regex modifiers" => "Modificateurs Regex",
"Human readable text description of rule" => "Description facilement compréhensible de la règle",
"Check to enable this rule" => "Cocher pour permettre cette règle",
"Enabled" => "Activé",
"Preview options" => "Options de l'aperçu",
"Apply all rules or just this to generate preview" => "Appliquer toutes les règles ou seulement celle-là pour générer l'aperçu",
"Apply all rules" => "Appliquer toutes les règles",
"View source code after rules applied" => "Voir le code source après l'application des règles",
"Code preview" => "Aperçu du code",
"Generate HTML preview" => "Générer un aperçu HTML",
"HTML preview" => "Aperçu HTML",
"Test file from repository to generate preview for (empty = configured start page)" => "Fichier de test du répertoire pour créer un aperçu (vide = page initiale configurée)",
"Preview Results" => "Aperçu des résultats",
"Rules List" => "Liste des règles",
"Case" => "Casse",
"Configure/Options" => "Configurer/Options",
"Admin layout" => "Administrer la mise en page",
"Theme control" => "Contrôle des thèmes",
"layout options" => "Options de mise en page",
"Top bar" => "Barre du haut",
"Generate positions by hits" => "Générer les positions par le nombre de visites",
"List of featured links" => "Liste des liens vedette",
"Add Featured Link" => "Ajouter un lien vedette",
"Create new Featured Link" => "Créer un nouveau lien vedette",
"disables the link" => "désactive l'hyper-lien",
"Link type" => "Type de lien",
"replace current page" => "remplacer la page en cours",
"framed" => "encadré",
"open new window" => "ouvrir nouvelle fenêtre",
"Mail-in accounts" => "Comptes mail-ins",
"Account" => "Compte",
"Add new Mail-in account" => "Ajouter un nouveau compte Mail-in",
"Edit Mail-in account" => "Modifier un compte mail-in",
"Account name" => "Nom du compte",
"POP server" => "Serveur POP",
"SMTP server" => "Serveur SMTP",
"SMTP requires authentication" => "SMTP exige une authentification",
"article-put" => "recevoir-article",
"wiki-get" => "envoyer-wiki",
"wiki-put" => "recevoir-wiki",
"wiki-append" => "concaténer-wiki",
"Article Topic" => "Sujet de l'article",
"Admin Topics" => "Administrer les sujets",
"Article Type" => "Type de l'article",
"Admin Types" => "Administrer les types",
"Active" => "Activé",
"Allow anonymous acces" => "Permettre un accès anonyme",
"Allow attachments" => "Permettre les fichiers joints",
"Discard to the end from" => "Ignorer la fin à partir de",
"Check Mail-in accounts" => "Vérifier les comptes mail-ins",
"Check automatically" => "Vérifier automatiquement",
"Frequency" => "Fréquence",
"List menus" => "Liste des menus",
"Edit this menu" => "Modifier ce menu",
"Edit menu options" => "Modifier les options du menu",
"Show Quick Urls" => "Montre l'aide URLs",
"Some useful URLs" => "Adresses Web utiles",
"Hide Quick Urls" => "Cacher l'aide URLs",
"For wiki page, use ((PageName))." => "Pour les pages wiki, utilisez ((NomdePage)).",
"Use Ctrl+Click to select multiple groups." => "Utilisez Ctrl+Clic pour sélectioner de multiples groupes.",
"section level 0" => "section niveau 0",
"section level 1" => "section niveau 1",
"section level 2" => "section niveau 2",
"section level 3" => "section niveau 3",
"sorted section level 0" => "section triée niveau 0",
"separator" => "intercalaire",
"Choose" => "Choisir",
"Home Blog" => "Accueil-Blogue",
"Home Image Gal" => "Accueil-Gal. images",
"Home Image Gallery" => "Accueil-Galerie d'images",
"Home File Gal" => "Accueil-Gal. fichiers",
"Home File Gallery" => "Accueil-Galerie de fichiers",
"User preferences" => "Préférences utilisateur",
"User prefs" => "Préf. utilisateur",
"List galleries" => "Liste des galeries",
"List image galleries" => "Liste des galeries d'images",
"Upload image" => "Envoyer une image",
"Gallery Rankings" => "Classements des galeries",
"Browse a gallery" => "Parcourir une galerie",
"Articles home" => "Accueil-articles",
"All articles" => "Tous les articles",
"Submit" => "Soumettre",
"List Blogs" => "Liste des blogues",
"Create blog" => "Créer un blogue",
"View a forum" => "Afficher un forum",
"View a thread" => "Afficher un fil de discussion",
"View a FAQ" => "Afficher une FAQ",
"Take a quiz" => "Remplir un QCM",
"Quiz stats" => "Statistiques sur les QCMs",
"Stats for a Quiz" => "Statistiques sur le QCM",
"Preview menu" => "Aperçu du menu",
"Menu options" => "Options du menu",
"switch with previous option" => "échanger avec l'option précédente",
"switch with next option" => "échanger avec l'option suivante",
"Export CSV data" => "Exporter des données CSV",
"Import CSV data" => "Importer des données CSV",
"Active Permissions" => "Permissions activées",
"Create new Menu" => "Créer un nouveau menu",
"dynamic collapsed" => "sous-menus non vus",
"dynamic extended" => "sous-menus vus",
"fixed" => "fixe",
"Folder Icon" => "Icône des répertoires",
"Path and filename of closed folder icon" => "Chemin et nom de l'icône d'un répertoire fermé",
"This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Cela va marcher (ou non !) selon votre thème. Pour en apprendre plus sur les <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">thèmes</a>",
"Clear Cache" => "Vider l'antémémoire",
"Assign/Edit modules" => "Assigner/Editer les modules",
"Assigned Modules" => "Modules attribués",
"Left Modules" => "Modules gauches",
"Move Up" => "Déplacer vers le haut",
"Move Down" => "Déplcer vers le bas",
"Move to Right Column" => "Déplacer vers la colonne de droite",
"Right Modules" => "Modules droits",
"Move to Left Column" => "Déplacer vers la colonne de gauche",
"Assign new module" => "Attribuer un nouveau module",
"Cache Time" => "Temps d'antémémoire",
"Display Modules to All Groups" => "Afficher les modules à tous les groupes",
"Visibility" => "Visibilité",
"Displayed now for all eligible users even with personal assigned modules" => "Affiché pour tous les utilisateurs ayant droit même avec des modules personnellement assignés",
"Displayed for the eligible users with no personal assigned modules" => "Affiché pour les utilisateurs ayant droit sans module personnellement assigné",
"Displayed now, can't be unassigned" => "Affiché maintenant, ne peut pas être désassigné",
"Not displayed until a user chooses it" => "Non affiché jusqu'à ce que l'utilisateur en décide autrement",
"User Modules" => "Modules utilisateur",
"Create new user module" => "Créer un nouveau module utilisateur",
"Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Créer votre module fait sur mesure. Assurez vous de faire un aperçu avant de <a href=\"#assign\">l'assigner</a>. L'utilisation d'une mauvaise syntaxe wiki ou de code smarty (pas de problème avec html) peut vous empêcher d'utiliser le site",
"Must be wiki parsed" => "Doit être analysé Wiki",
"Objects that can be included" => "Objets pouvant être inclus",
"Random active poll" => "Sondage actif choisi au hasard",
"Random current poll" => "Sondage courant choisi au hasard",
"Use Poll" => "Utiliser ce sondage",
"Use Gallery" => "Utiliser cette galerie",
"Use Dynamic Content" => "Utiliser ce contenu",
"Use RSS Module" => "Utiliser ce RSS",
"Use Menu" => "Utiliser ce menu",
"Use phplayermenu" => "Utiliser phplayermenu",
"Use Banner Zone" => "Utiliser cette bannière",
"Use Wiki Structure" => "Utiliser cette structure Wiki",
"Data" => "Contenu",
"Admin newsletter subscriptions" => "Administrer les abonnements à une lettre d'informations",
"List Newsletters" => "Liste des lettres d'informations",
"Admin Newsletters" => "Administrer les lettres d'informations",
"Send Newsletters" => "Envoyer des lettres d'informations",
"Add a subscription newsletters" => "Ajouter un abonné à une lettre d'informations",
"You can add several email addresses by separating them with commas." => "Vous pouvez ajouter plusieurs courriels en les séparant par des virgules.",
"Group subscription also subscribes included groups" => "L'inscription d'un groupe inscrit aussi les groupes inclus.",
"Don't send confirmation mail" => "Ne pas envoyer de messages de confirmation",
"The user email will be refreshed at each newsletter sending" => "L'adresse électronique de l'utilisateur sera reconstruite à chaque envoi de lettre d'informations",
"Batch e-mail subscribe" => "Inscription d'adresse électronique par lot",
"txt file, one e-mail per line" => "fichier texte, une adresse par ligne",
"Export Subscriber Emails" => "Exporter les adresses électroniques des inscrits",
"Subscribe group" => "Inscrire un groupe",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Les groupes inclus, les utilisateurs des groupes et leurs adresses électroniques seront reconstruits à chaque envoi de lettre d'informations",
"Add subscribers of another newsletter" => "Ajouter les inscrits d'une autre lettre d'informations",
"Subscriptions" => "Inscriptions",
"Valid" => "Valide",
"Subscribed" => "inscrit",
"Admin newsletters" => "Administrer les lettres d'informations",
"Editions" => "Éditions",
"Drafts" => "Brouillons",
"Last Sent" => "Dernier envoi",
"Create/Edit Newsletters" => "Ajouter/Modifier une lettre d'informations",
"There are individual permissions set for this newsletter" => "Des droits individuels ont été mis sur cette lettre d'informations",
"Users can subscribe/unsubscribe to this list" => "Les utilisateurs peuvent s'abonner/se désabonner à cette liste",
"Users can subscribe any email address" => "Les utilisateurs peuvent s'abonner avec une adresse électronique différente",
"Add unsubscribe instructions to each newsletter" => "Ajouter les instructions pour se désabonner dans chaque lettre d'informations envoyée",
"Validate email addresses" => "Les inscriptions sont validées après réponse à un email",
"Allow customized text message to be sent with the html version" => "Accompagner la version HTML d'une version personnalisable en format texte",
"Mail notifications" => "Notification par email",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "Vous devez configurer <a href=\"tiki-admin.php?page=general\">l'Email de l'émetteur</a> avant de poser des notifications par mail.",
"Add notification" => "Ajouter une notification",
"Alert" => "Alerte",
"Event" => "Évènement",
"Preload Admin Account" => "Précharger le compte Admin",
"User / Group" => "Utilisateur / Groupe",
"edit" => "éditer",
"Update" => "Mettre à jour",
"List polls" => "Liste des sondages",
"Edit this poll" => "Modifier ce sondage",
"Preview poll" => "Aperçu du sondage",
"Poll options" => "Options de sondage",
"Admin Polls" => "Administrer les sondages",
"Set last poll as current" => "Mettre le dernier sondage comme courant",
"Close all polls but last" => "Fermer tous les sondages sauf le dernier",
"Activate all polls" => "Activer tous les sondages",
"active" => "activé",
"current" => "en cours",
"object" => "objet",
"Add Option" => "Ajouter une Option",
"PublishDate" => "Date de publication",
"Results" => "Résultats",
"Add poll to pages" => "Ajouter un sondage à des pages",
"Wiki pages" => "Pages Wiki",
"Use Ctrl+Click to select multiple pages." => "Utilisez Ctrl+Clic pour sélectionner plusieurs pages.",
"Lock the pages" => "Verrouiller les pages",
"Tips" => "Astuces",
"Content for the feed" => "Affichage du canal",
"Show Title?" => "Afficher le titre ?",
"Show Date?" => "Afficher la date ?",
"Security Admin" => "Admin sécurité",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "Pour <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">signaler tout problème de sécurité</a>.",
"PHP settings" => "Configuration PHP",
"PHP variable" => "Variable PHP",
"Risk Factor" => "Facteur de risque",
"Explanation" => "Explication",
"TikiWiki settings" => "Paramètre TikiWiki",
"Tiki variable" => "Variable Tikiwiki",
"Security checks" => "Vérification de sécurité",
"Check all tiki files" => "Vérifier tous les fichiers Tikiwiki",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Remarque&nbsp;: cela peut prendre beaucoup de temps. Vous devez vérifier votre temps maximum d'exécution max_execution_time dans php.ini",
"File checks" => "Fichiers vérifiés",
"Check file permissions" => "Vérifier des permissions des fichiers",
"This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "Cette vérification tente de trouver des fichiers avec des permissions problématiques. Certains fichiers qui sont présentés ici comme posant problème peuvent ne pas être problématiques ou inévitables dans certains environnements.",
"See end of table for detailed explanations." => "Voir la fin de la table pour des explications détaillées.",
"owner" => "propriétaire",
"special" => "spécial",
"user" => "utilisateur",
"group" => "groupe",
"other" => "autre",
"sticky" => "captivant",
"Set User ID (suid) files" => "Set User ID (suid) des fichiers",
"World writable files or directories" => "Fichiers ou répertoires modifiables par tout le monde",
"Files or directories the Webserver can write to" => "Fichiers ou répertoires dans lesquels le serveur Web peut écrire",
"Strange Inodes (not file, not link, not directory)" => "Inodes étranges (ni fichier, ni lien, ni répertoire)",
"Executable files" => "Fichiers exécutables",
"What to do with these check results?" => "Que faire de ces résultats ?",
"Admin Shoutbox Words" => "Administration des mots du mégaphone",
"Add Banned Word" => "Ajouter un mot tabou",
"Are you sure you want to delete this word?" => "Etes-vous sûr(e) de vouloir enlever ce tabou ?",
"The structure" => "La structure",
"has just been created." => "vient d'être crée.",
"You will remove structure" => "Vous allez supprimer la structure",
"Destroy the structure leaving the wiki pages" => "Détruire la structure en laissant les pages Wiki",
"Destroy the structure and remove the pages" => "Détruire la structure et supprimer les pages",
"Edit structure" => "Modifier la structure",
"View structure" => "Afficher la structure",
"Export Pages" => "Exporter les pages",
"Dump Tree" => "Dumper l'arbre",
"Create WebHelp" => "Créer l'aide Web",
"View WebHelp" => "Afficher l'aide-web",
"Create new structure" => "Ajouter une nouvelle structure",
"Tree" => "Arbre",
"Use single spaces to indent structure levels" => "Utiliser un seul espace pour une mise en retrait",
"Create New Structure" => "Ajouter une nouvelle structure",
"Add a New Question" => "Ajouter une nouvelle question",
"List surveys" => "Liste des enquêtes",
"Survey Stats" => "Statistiques sur les enquêtes",
"This survey stats" => "Statistiques de cette enquête",
"Edit this Survey" => "Modifier cette enquête",
"Admin Surveys" => "Administrer les enquêtes",
"Edit Survey Question" => "Editer les questions de l'Enquête",
"Add a New Question to this survey" => "Ajouter une nouvelle question à cette enquête",
"One choice" => "1 choix (c)",
"Multiple choices" => "Choix multiple (m)",
"Short text" => "Texte court (t)",
"Wiki textarea" => "Zone de texte Wiki",
"Rate (1..5)" => "Notation (1..5) (r)",
"Rate (1..10)" => "Notation (1..10) (s)",
"Rate" => "Notation",
"For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "Pour une question à multiple réponses, mettre les réponses dans le champ suivant séparés par des virgules. Example: un,deux,trois",
"For a rate, you can give the maximum value." => "Pour une notation, vous pouvez utiliser la valeur maximum.",
"Options (if apply)" => "Les options (si elles s'appliquent)",
"Admin surveys" => "Administrer les enquêtes",
"List Surveys" => "Liste des enquêtes",
"Create New Survey" => "Créer une nouvelle enquête",
"There are individual permissions set for this survey" => "Des droits d'accès individuels ont été placés sur cette enquête",
"Open" => "En cours (o)",
"Tiki Cache/System Admin" => "Administration des caches & du système Tiki",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Si votre Tiki se comporte bizarrement, la première chose à faire est de vider vos caches. Il est aussi important de vider les caches après un upgrade (utiliser FTP/SSH si nécessaire).",
"Exterminator of cached content" => "Exterminateur du cache des contenus",
"Directory to exterminate" => "Répertoires à purger",
"Clear all Tiki caches" => "Purger tous les caches Tiki",
"Empty" => "Vider",
"All user prefs sessions" => "Toutes les préférences dans les sessions utilisateur",
"Directories to save" => "Répertoire à sauvegarder",
"Generate a zip of those directories" => "Créer une archive ZIP avec les répertoires ci-dessous",
"A zip has been written to {\$zipPath}" => "Une archive ZIP a été créée dans {\$zipPath}",
"Directory is not writeable" => "Le répertoire n'est pas accessible en écriture",
"Advanced feature" => "Fonctionnalité avancée",
"Fix UTF-8 Errors in Tables" => "Corriger les erreurs UTF-8 dans les tables",
"Warning: Make a backup of your Database before using this function!" => "Attention&nbsp;: Faire une sauvegarde de votre base de données avant d'utiliser cette fonction!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Attention: Si vous avez de grandes tables, augmenter le temps maximum d'exécution dans votre php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Cette fonction convertit les chaînes encodées en ISO-8859-1 dans vos tables en UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Ceci peut être nécessaire si vous avez utilisé tiki &lt; 1.8.4 et la configuration apache Default Charset=ISO-8859-1 pour créer du contenu",
"UTF-8 Errors fixed" => "Erreurs UTF-8 réparées",
"Investigate" => "Examiner",
"Fix it" => "Réparer",
"Create a new topic" => "Créer un nouveau sujet",
"Topic Name" => "Libellé du sujet",
"Upload Image" => "Envoyer une image",
"List of topics" => "Liste des sujets",
"Articles (subs)" => "Articles (soumis)",
"topic image" => "image du sujet",
"Inactive - Click to Activate" => "Inactif - cliquer pour activer",
"Deactivate" => "Désactiver",
"Active - Click to Deactivate" => "Actif - cliquer pour désactiver",
"Remove with articles" => "Supprimer avec les articles",
"List Trackers" => "Liste des formulaires",
"Admin Trackers" => "Administrer les formulaires",
"Edit This Tracker" => "Modifier ce formulaire",
"View This Tracker's Items" => "Liste des fiches de ce formulaire",
"Tracker fields" => "Champs du formulaire",
"Mandatory" => "Obligatoire",
"Is column visible when listing tracker items?" => "La colonne est-elle visible en mode liste ?",
"Tbl vis" => "Visible",
"Column links to edit/view item?" => "La colonne a-t-elle un lien vers la fiche ?",
"isMain" => "Principal",
"Searchable" => "Filtrable",
"Field is public? (viewed in trackerlist plugin)" => "Le champ est-il public ? (visible par l'intermédiaire du plugin trackerlist)",
"Hidden" => "Caché",
"New tracker field" => "Nouveau champ du formulaire",
"Edit tracker field" => "Modifier le champ du formulaire",
"Field is mandatory?" => "Le champ est-il obligatoire?",
"Multilingual content" => "Contenu multilingue",
"Column is searchable?" => "La colonne est filtrable?",
"Field is hidden?" => "Le champ est-il caché?",
"not hidden" => "non caché",
"visible to admin only" => "visible seulement par les administrateurs",
"editable by admin only" => "modifiable par admin seulement",
"visible by creator &amp; admin only" => "visible par le créateur &amp; l'administrateur seulement",
"The option creator needs a field of type user selector and option 1" => "L'option créateur a besoin d'un champ de type sélection automatique d'utilisateur avec le paramètre 1",
"Import/Export Trackers Fields" => "Importer/exporter des champs de formulaires",
"Export fieldId also" => "Exporter les Ids de champs aussi",
"Edit This Tracker's Fields" => "Modifier les champs de ce formulaire",
"Found" => "Trouvé",
"trackers" => "formulaires",
"with" => "avec",
"Edit Tracker" => "Modifier ce formulaire",
"Create Tracker" => "Créer un nouveau formulaire",
"Create/Edit Tracker" => "Ajouter/modifier un formulaire",
"There are individual permissions set for this tracker" => "Des droits d'accès individuels sont utilisés par ce formulaire",
"No individual permissions. Global permissions apply." => "Pas de droit d'accès individuel&nbsp;: les droits globaux s'appliquent",
"Auto create corresponding categories" => "Crée automatiquement les catégories correspondantes",
"Create a group for each item" => "Créer un groupe pour chaque fiche",
"Use \"explicit\" names in the mirror table" => "Utilisez des noms \"explicites\" dans la table miroir",
"Show status" => "Voir les statuts",
"Default status displayed in list mode" => "État par défaut affiché en mode liste",
"Show status to tracker admin only" => "Ne montrer les statuts qu'aux administrateurs du formulaire",
"Send copies of all activity in this tracker to this e-mail address" => "Envoyer toute activité dans ce formulaire à cette adresse électronique",
"Use simplified e-mail format" => "Utiliser un format email simplifié",
"The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "Le formulaire utilisera le champ de texte nommé Subject s'il existe, le courriel de l'utilisateur si existe ou pour un anonyme le champ email de la fiche si existe",
"New items are created with status" => "Les nouvelles fiches sont créées avec le statut",
"Authoritative status for modified items" => "Statut qui sera positionné pour les fiches modifiées",
"No change" => "Aucun changement",
"Item creator can modify his items?" => "Le créateur d'une fiche peut la modifier ?",
"The tracker needs a user field with the option 1" => "Le formulaire a besoin d'un champ utilisateur avec l'option 1",
"Only one item per user or IP" => "Une seule fiche par utilisateur ou IP",
"The tracker needs a user or IP field with the option 1" => "le formulaire a besoin d'un champ utilisateur ou IP avec l'option 1",
"The tracker needs a group field with the option 1" => "Le formulaire a besoin d'un champ groupe avec l'option 1",
"Show creation date when listing tracker items?" => "Afficher la date de création dans la liste des fiches ?",
"Show creation date when viewing tracker item?" => "Montre la date de création lors de l'affichage d'une fiche ?",
"Show lastModif date when listing tracker items?" => "Afficher la date de dernière modification dans la liste des fiches ?",
"Show lastModif date when viewing tracker item?" => "Montre la date de la dernière modification lors de l'affichage d'une fiche ?",
"What field is used for default sort?" => "Quel est le champ utilisé pour l'ordre de tri par défaut ?",
"LastModif" => "dernière modif.",
"What is default sort order in list?" => "Quel est le sens de l'ordre de tri par défaut ?",
"ascending" => "croissant",
"descending" => "décroissant",
"Tracker items allow ratings?" => "Les fiches de formulaire peuvent être notées ?",
"with values" => "avec valeurs",
"and display rating results in listing?" => "et afficher les résultats des notes dans les listes ?",
"Tracker items allow comments?" => "Commentaires permis dans les fiches ?",
"and display comments in listing?" => "et afficher les commentaires en mode liste ?",
"Tracker items allow attachments?" => "Fichiers joints permis dans les fiches ?",
"and display attachments in listing?" => "et afficher les fichiers joints en mode liste ?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Options d'affichage des fichiers joints (utilisez des chiffres pour ordonner les éléments, 0 inhibe l'affichage, et les valeurs négatives s'afficheront dans une popup)",
"Filesize" => "Taille du fichier",
"Filetype" => "Type du fichier",
"LongDesc" => "Desc-longue",
"Items can be created only during a certain time" => "Les fiches ne peuvent être créées que pendant un certain temps",
"Do not show empty fields in item view?" => "Ne pas montrer les champs vides à l'affichage d'une fiche?",
"Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Montrer ces champs (Ids séparés par des virgules) dans une popup au passage sur le lien vers la fiche lors de l'affichage des fiches d'un formulaire?",
"Group of users alerted when tracker is modified" => "Groupe d'utilisateur alerté quand le formulaire est modifié",
"Import/Export" => "Importer/Exporter",
"Import/export trackers" => "Importer/exporter des formulaires",
"Date Format" => "Format de Date",
"timestamp" => "horodatage",
"Charset encoding" => "Encodage des caractères",
"Duplicate Tracker" => "Dupliquer un formulaire",
"Admin groups" => "Administrer les groupes",
"Admin users" => "Administrer les utilisateurs",
"Add new group" => "Ajouter un nouveau groupe",
"List of existing groups" => "Liste des groupes existants",
"Inherits Permissions from" => "Hérite les permissions de",
"User Choice" => "Choix utilisateur",
"Edit group" => "Modifier le groupe",
"Add a New Group" => "Ajouter un nouveau groupe",
"Inherit permissions directly from following groups." => "Hérite les permissions directement des groupes suivants.",
"Selected groups only. Use Ctrl+Click to select more than one." => "Groupes sélectionnés seulement. Faire Ctrl+Clic pour en sélectionner plus qu'un.",
"Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)." => "Le groupe hérite aussi les permissions des groupes suivants (héritage indirect à travers les groupes sélectionnés ci-dessus).",
"Use wiki page name or full URL" => "Utiliser le nom de la page Wiki ou l'URL complet",
"Group Information Tracker" => "Formulaire d'information sur le groupe",
"choose a group tracker ..." => "choisissez un formulaire pour le groupe ...",
"choose a field ..." => "choisissez un champ ...",
"Users Information Tracker" => "Formulaire d'information sur l'utilisateur",
"choose a users tracker ..." => "choisissez un formulaire pour les utilisateurs ...",
"User can assign to the group himself" => "Un utilisateur peut se mettre dans ce groupe lui-même",
"Group tracker item : {\$groupitemid}" => "La fiche du groupe&nbsp;: {\$groupitemid}",
"Edit Item" => "Modifier la fiche",
"Group tracker item not found" => "La fiche du groupe non trouvée",
"Create Item" => "Créer une fiche",
"Members" => "Membres",
"Remove from Group" => "Supprimé du groupe",
"users in group" => "utilisateurs du groupe",
"Add to group" => "Ajouter a un groupe",
"Download CSV export" => "Exporter en CSV",
"To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "Pour créer des utilisateurs et/ou les assigner à un/plusieurs groupe, aller à <a href=\"tiki-adminusers.php\">admin->users</a>",
"CSV File" => "Fichier CSV",
"Add a New User" => "Ajouter un nouvel utilisateur",
"Reason" => "Raison",
"More Criteria" => "Plus de critères",
"Group (direct)" => "Groupe (direct)",
"Registered" => "Inscrit",
"Assign to group" => "Assigner au groupe",
"to groups" => "aux groupes",
"Edit Included Group" => "Modifier les groupes inclus",
"Invalid email" => "Adresse électronique invalide",
"Remove Users and their Userpages" => "Supprimer les utilisateurs et leurs pages utilisateur",
"Manage Group Assignments" => "Mettre dans des groupes",
"Set Default Groups" => "Positionner les groupes par défaut",
"Assign selected to" => "Mettre les sélectionnés dans",
"Remove selected from" => "Supprimer les sélectionnés de",
"Tip: Hold down CTRL to select multiple" => "Astuce&nbsp;: Maintenir la touche CTRL enfoncée pour une sélection multiple",
"Template wiki page" => "Page wiki modèle",
"Edit user" => "Modifier l'utilisateur",
"Assign user to Groups" => "Assigner l'utilisateur aux Groupes",
"Use the email as username" => "Utilisez l'adresse électronique comme nom d'utilisateur",
"Lowercase only" => "Minuscules seulement",
"No password is required" => "Un mot de passe n'est pas obligatoire",
"Generate a password" => "Générer un mot de passe",
"User must change password at first login" => "L'utilisateur doit changer de mot de passe à la première connexion",
"User tracker item : {\$usersitemid}" => "Fiche de l'utilisateur: {\$usersitemid}",
"Overwrite" => "Écraser",
"Overwrite but keep the previous login if the login exists in another case" => "Écraser mais garder le nom d'utilisateur précédent si ce nom existe déja dans une autre case",
"Don't overwrite" => "Ne pas écraser",
"You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "Vous pouvez exporter les utilisateurs d'un groupe via <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
"Loading..." => "En train de charger...",
"Page has been approved" => "La page a été approuvée",
"New attachments" => "Nouvelles pièces jointes",
"Old attachments" => "Anciennes pièces jointes",
"Changes from the following versions under staging have been merged into the approved version" => "Les changements de cette versions ont été fusionnés dans la version approuvée",
"Admin Article Types" => "Administrer les types des articles",
"List of types" => "Liste des types",
"Show Help" => "Affiche l'aide",
"Article type" => "Type d'article",
"Shows up in the drop down list of article types" => "Montrer la liste des types d'articles",
"Allow ratings by the author" => "Permettre à l'auteur de noter",
"Show before publish date" => "Afficher avant la date de publication",
"non-admins can view before the publish date" => "Les utilisateurs autres que l'administrateur peuvent voir l'article avant la date de publication",
"Show after expire date" => "Afficher après la date d'expiration",
"non-admins can view after the expire date" => "Les utilisateurs autres que l'administrateur peuvent voir l'article après la date d'expiration",
"Heading only" => "En-tête seulement",
"No article body, heading only" => "Pas de corps d'article, uniquement un en-tête",
"Allow comments for this type" => "Permettre les commentaires pour ce type",
"Comment Can Rate Article" => "Les commentaires entrent dans le vote des articles",
"Allow comments to include a rating value" => "Permettre aux commentaires d'avoir une note",
"Show image" => "Afficher l'image",
"Show topic or own image" => "Montrer l'image propre ou celle du sujet",
"Show avatar" => "Afficher l'avatar",
"Show author's avatar" => "Montrer l'avatar de l'auteur",
"Show author" => "Afficher l'auteur",
"Show author name" => "Montrer le nom de l'auteur",
"Show publish date" => "Afficher la date de publication",
"Show expire date" => "Afficher la date d'expiration",
"Show reads" => "Afficher le nombre de lecture",
"Show the number of times the article was read" => "Montrer le nombre de fois que l'article est lu",
"Show size" => "Afficher la taille",
"Show the size of the article" => "Montrer la taille de l'article",
"Show topline" => "Montrer le surtitre",
"Show a small title over the title" => "Montrer un petit titre au-dessus du titre",
"Show subtitle" => "Montrer le sous-titre",
"Show the subtitle" => "Montrer le sous-titre",
"Show source" => "Montrer la source",
"Show link to source after article body" => "Montrer le lien vers la source après le corps de l'article",
"Show Image Caption" => "Montrer la légende de l'image",
"Show a legend under the image" => "Montrer une légende en dessus de l'image",
"Show Language" => "Montrer la langue",
"Show the language" => "Montrer la langue",
"Creator can edit" => "Le créateur peut modifier",
"The person who submits an article of this type can edit it" => "L'utilisateur qui soumet un article de ce type peut le modifier",
"Actions on this article type" => "Actions pour ce type d'article",
"Show lang" => "Montrer la langue",
"Review" => "Article noté",
"Classified" => "Annonce",
"Create a new type" => "Créer un nouveau type",
"Group Information" => "Information sur le groupe",
"level" => "niveau",
"inherited from" => "hérite de",
"inherited" => "héritée",
"Level configuration" => "Niveau de configuration",
"Create level" => "Créer un niveau",
"all permissions in level" => "tous les droits d'accès dans le niveau",
"Assign User to Group" => "Affecter l'utilisateur dans ce groupe",
"backlinks to" => "Pages pointant vers",
"No backlinks to this page" => "Aucune page ne pointe vers cette page",
"Directory batch upload" => "Répertoire d'envoi par lot",
"Browse Gallery" => "Parcourir la galerie",
"Upload From Disk" => "Envoyer à partir de son disque",
"available images" => "images disponibles",
"Remove File Extension from Image Name" => "Donner comme nom d'image, le nom du fichier sans son extension",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "ex. pour \"digicam0001.jpg\" le nom sera digicam0001",
"Convert the last sub directory to a sub gallery" => "convertir le dernier sous répertoire en une sous galerie",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "exemple : pour une arborescence \"misc/screenshots/digicam0001.jpg\" une galerie nommée \"screenshots\" sera créée",
"Use the last sub directory name as description" => "Utiliser le nom de la dernière sous-catégorie comme description",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "exemple : pour une arborescence comme \"misc/screenshots/digicam0001.jpg\" une description \"screenshots\" sera ajouté aux images",
"Select a Gallery" => "Sélectionner une galerie",
"Process" => "Processus",
"Browse File Gallery" => "Parcourir la galerie de fichiers",
"Please do not use this feature to upload data into the database." => "SVP, n'utilisez pas cette fonctionnalité pour envoyer des données dans la base de données.",
"Available Files" => "Fichiers disponibles",
"Select a File Gallery" => "Sélectionner une galerie de fichiers",
"Process files" => "Traiter les fichiers",
"Edit Post" => "Modifier une publication",
"View Blog" => "Afficher le blogue",
"If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "À Noter&nbsp;: Pour insérer des images, enregistrer votre message tout d'abord avant de pouvoir éditer/poster des images. Vous pouvez utiliser le code &lt;img&gt; pour inclure des images disponibles sur ce tiki ou l'URL pour inclure des images avec l'éditeur Wysiwyg.",
"Use ...page... to separate pages in a multi-page post" => "Utiliser ...page... pour séparer les pages",
"Body" => "Corps",
"Upload image for this post" => "Envoyer cette image pour cette publication",
"Trash" => "Corbeille",
"Spellcheck" => "Correcteur orthographique",
"Save and Exit" => "Enregistrer et quitter",
"Report to Webmaster" => "Signaler au Webmaster",
"Powered by" => "Utilise",
"Made with" => "Utilise",
"powered by" => "Utilise",
"Wiki RSS" => "RSS Wiki",
"Blogs RSS" => "RSS Blogues",
"Articles RSS" => "RSS Articles",
"Image Galleries RSS" => "RSS Galeries d'images",
"File Galleries RSS" => "RSS Galeries de fichiers",
"Forums RSS" => "RSS Forums",
"Maps RSS" => "RSS Cartes",
"The TikiWiki Community" => "La communauté TikiWiki",
"Execution time" => "Temps d'exécution",
"Memory usage" => "Mémoire utilisée",
"database queries used in " => "requête à la base de données utilisés dans ",
"Server load" => "Charge du serveur",
"Last update from SVN" => "Derniêre mise à jour depuis SVN",
"Watch Only This Category" => "Surveiller seulement cette catégorie",
"Watch This Category and Their Descendants" => "Surveiller cette catégorie et ses descendants",
"Stop Watching Only This Category" => "Arrêter de surveiller seulement cette catégorie",
"Stop Watching This Category and Their Descendants" => "Arrêter de surveiller seulement cette catégorie et ses descendants",
"Admin Category" => "Administrer les catégories",
"Admin the Category System" => "Administrer le système de catégories",
"Browse in" => "Parcourir dans",
"Trackers Items" => "Fiches de formulaires",
"Sheets" => "Feuillets",
"in the current category - and its subcategories: " => "dans la catégorie courante - et dans ses sous-catégories",
"Hide subcategories objects" => "Cacher les objets des sous-catégories",
"Show subcategories objects" => "Montrer aussi les objets des sous-catégories",
"Upper level" => "Niveau supérieur",
"Browse related tags" => "Recherche à l'aide des freetags",
"With all selected tags" => "Avec tous les tags sélectionnés",
"With one selected tag" => "Avec l'un des tags sélectionnés",
"With last selected tag" => "Avec le dernier tag sélectionné",
"Alphabetically" => "Alphabetique",
"By Size" => "par taille",
"Cloud" => "Nuage",
"results found" => "résultats trouvés",
"List Galleries" => "Liste des galeries",
"Edit Gallery" => "Modifier la galerie",
"Rebuild Thumbnails" => "Refaire les vignettes",
"Directory Batch" => "Téléchargement serveur",
"List Gallery" => "Contenu de la galerie",
"All Images" => "Toutes les images",
"Monitor this Gallery" => "Surveiller cette galerie",
"Stop Monitoring this Gallery" => "Ne plus surveiller cette galerie",
"Sort Images by" => "Trier les images par",
"subgallery" => "sous-galerie",
"Subgallery" => "Sous-galerie",
"Hit" => "Visite",
"Original Size" => "Taille originale",
"rotate right" => "pivoter à droite",
"rotate" => "pivoter",
"Details" => "Détails",
"You can include the gallery's image in an HTML page using one of these lines" => "Vous pouvez inclure des images de la galerie dans des pages HTML en utilisant les une de ces lignes",
"You can include the image in a tiki page using one of these lines" => "Vous pouvez insérer l'image dans une page Wiki en utilisant l'une de ces lignes",
"Return to Gallery" => "Retour à la galerie",
"Edit Image" => "Modifier l'image",
"First Image" => "Première image",
"Prev Image" => "Image précédente",
"Smaller" => "Plus petit",
"Bigger" => "Plus grand",
"Popup window" => "Fenêtre popup",
"Next Image" => "Image suivante",
"Slideshow Forward" => "Diapositive suivante",
"Last Image" => "Dernière image",
"Cyclic" => "Cyclique",
"Click to zoom" => "Cliquer pour zoomer",
"Image Name" => "Nom de l'image",
"Image Scale" => "échelleImage",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/degrés décimaux)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/degrés décimaux)",
"Move image" => "Déplacer l'image",
"Stop Monitoring this Page" => "Arrêter de surveiller cette page",
"Monitor this Page" => "Surveiller cette page",
"Admin Calendar" => "Administrer les calendriers",
"Export Calendars" => "Exporter les calendriers",
"Click to export calendars" => "Cliquer pour exporter les calendriers",
"Visible Calendars" => "Calendriers visibles",
"Click to select visible calendars" => "Cliquer pour sélectionner les calendriers visibles",
"Group Calendars" => "Calendriers de groupe",
"Export calendars" => "Export de calendriers",
"advanced parameters" => "paramètres avancés",
"Edit event" => "Modifier cet évènement",
"Delete event" => "Supprimer cet évènement",
"View event" => "Voir cet évènement",
"All-Day" => "Journée entière",
"Tentative" => "Proposé",
"Confirmed" => "Confirmé",
"Cancelled" => "Annulé",
"View this Week" => "Afficher cette semaine",
"Change Focus" => "Changer le focus",
"View this Day" => "Afficher ce jour",
"Calendar Item" => "Évènement",
"Edit Calendar" => "Modifier le calendrier",
"New event" => "Nouvel évènement",
"Edit Calendar Item" => "Modifier un évènement de calendrier",
"New Calendar Item" => "Nouvel évènement de calendrier",
"Recurrence" => "Récurrence",
"This event depends on a recurrence rule" => "Cet événement est récurrent",
"This event is not recurrent" => "Cet événement n'est pas récurrent",
"On a weekly basis" => "Hebdomadaire",
"Each" => "Chaque",
"Tuesday" => "mardi",
"Wednesday" => "mercredi",
"Thursday" => "jeudi",
"Friday" => "vendredi",
"of the week" => "de la semaine",
"On a monthly basis" => "Mensuel",
"of the month" => "du mois",
"On a yearly basis" => "Annuel",
"January" => "janvier",
"February" => "février",
"March" => "mars",
"April" => "avril",
"May" => "mai",
"June" => "juin",
"July" => "juillet",
"August" => "août",
"September" => "septembre",
"October" => "octobre",
"November" => "novembre",
"December" => "décembre",
"There's no such date as" => "Il n'existe pas de date telle que le",
"Starting on" => "Commençant le",
"ending by" => "terminant le",
"ending after" => "terminant après",
"events" => "événements",
"Start period" => "Début de la période",
"End after" => "Fin après",
"End before" => "Fin avant le",
"Event is repeated" => "L'événement est répété",
"times" => "fois",
"every" => "chaque",
"of every month" => "de chaque mois",
"on each" => "chaque",
"End" => "Fin",
"Duration" => "Durée",
"Date and time of end" => "Date et heure de fin",
"Events cannot end before they start" => "Un événement ne peut finir avant son commencement",
"or new" => "ou nouveau",
"Choose users to alert" => "Choisir les utilisateurs à alerter",
"Organized by" => "Organisé par",
"Roles" => "Rôles",
"chair" => "president de séance",
"default role" => "rôle par défaut",
"required participant" => "participant requis",
"optional participant" => "participant non obligatoire",
"non participant" => "non-participant",
"role:login_or_email,login_or_email" => "rôle:login_ou_email,login_ou_email",
"If no role is provided, default role will be \"Chair participant\"." => "Si aucun rôle n'est défini, le rôle attribué par défaut sera \"président de séance\".",
"Update this event only" => "Ne mettre à jour que cet événement",
"Update every unchanged events of this recurrence rule" => "Mettre à jour tous les événements inchangés de cette récurrence",
"Update every events of this recurrence rule" => "Mettre à jour tous les événements de cette récurrence",
"Delete Recurrent events" => "Supprimer tous les événements liés à cette récurrence",
"Calendar import" => "Importation de calendrier",
"Calendar has been updated" => "Le calendrier a été mis à jour",
"import" => "importer",
"%m/%d" => "%d/%m",
"Calendars to be exported" => "Calendriers à exporter",
"Change password enforced" => "Changement de mot de passe imposé",
"Change your password" => "Modifiez votre mot de passe",
"Send a message to us" => "Nous envoyer un message",
"Contact us by email" => "Nous contacter par email",
"Click here to send us an email" => "Cliquer ici pour nous envoyer un email",
"Send another message" => "Envoyer un autre message",
"Group View" => "Vue par groupe",
"Create/edit contacts" => "Ajouter/modifier un contact",
"First Name" => "Prénom",
"Publish this contact to groups" => "Partager ce contact avec les groupes",
"Last Name" => "Nom de famille",
"Nickname" => "Surnom",
"You can browse the generated WebHelp here" => "Vous pouvez parcourir l'aide Web ici",
"Top page" => "Page du 1ier niveau",
"Add a new site" => "Ajouter un nouveau site",
"You cannot add sites until Directory Categories are setup." => "Vous ne pouvez pas ajouter de sites avant que les catégories de répertoires soient configurées",
"Please contact the Site Administrator" => "SVP, contacter l'administrateur du site",
"Site added" => "Site ajouté",
"Edit a site" => "Éditer un site",
"Add a site" => "Ajouter un site",
"Directory Administration" => "Administrer le répertoire des liens",
"There are" => "Il y a",
"invalid sites" => "sites invalides",
"valid sites" => "sites valides",
"Users have visited" => "Les utilisateurs ont visité",
"sites from the directory" => "sites de ce répertoire",
"Users have searched" => "Les utilisateurs ont cherché",
"times from the directory" => "fois de ce répertoire",
"Related" => "En relation",
"Validate" => "Valider",
"Admin directory categories" => "Administrer les catégories de répertoire",
"Parent directory category" => "Catégorie de répertoire parente",
"Add a directory category" => "Ajouter une catégorie de répertoire",
"Edit this directory category" => "Modifier les catégories de ce répertoire",
"Children type" => "Type de l'affichage complémentaire",
"Maximum number of children to show" => "Nombre maximum de sous-catégories à montrer",
"Show number of sites in this directory category" => "Afficher le nombre de sites dans cette catégorie de répertoire",
"Editor group" => "Groupe éditeur",
"Directory Subcategories" => "Sous-catégories de répertoire",
"allow" => "permis",
"count" => "nombre",
"editor" => "éditeur",
"relate" => "relation",
"Admin related directory categories" => "Administrer les catégories de répertoire en relation",
"Mutual" => "Mutuelle",
"Related directory categories" => "Catégories de répertoire en relation",
"Admin sites" => "Administrer les sites",
"Is valid" => "Est valide",
"New Sites" => "Nouveaux sites",
"Cool Sites" => "Sites cools",
"Add a Site" => "Ajouter un site",
"any" => "quelconque",
"in entire directory" => "dans le répertoire entier",
"in current directory category" => "dans la catégorie de répertoire courante",
"Sort by" => "Trier par",
"name (desc)" => "nom (desc)",
"name (asc)" => "nom (asc)",
"hits (desc)" => "visites (desc)",
"hits (asc)" => "visites (asc)",
"creation date (desc)" => "date de création (desc)",
"creation date (asc)" => "date de création (asc)",
"last updated (desc)" => "dernière mise à jour (desc)",
"last updated (asc)" => "dernière mise à jour (asc)",
"Added" => "Ajouté",
"Last updated" => "Dernière modification",
"Total directory categories" => "Nombre total de catégories de répertoire",
"Total links" => "Nombre total de liens",
"Links to validate" => "Liens à valider",
"Searches performed" => "Recherches faites",
"Total links visited" => "Nombre total de liens visités",
"Directory ranking" => "Classement des liens du répertoire",
"Search results" => "Résultats de la recherche",
"Validate sites" => "Sites validés",
"Edit article" => "Modifier un article",
"List Articles" => "Liste des articles",
"View Articles" => "Afficher les articles",
"One of the email addresses you typed is invalid" => "L'une des adresses email que vous avez tapé est invalide",
"Topline" => "Surtitre",
"Author Name" => "Nom de l'auteur",
"Own Image" => "Image associée",
"Article image" => "Image d'article",
"Use own image" => "Utiliser l'image associée",
"Float text around image" => "Texte flottant autour de l'image",
"Own image size x" => "Taille x de l'image associée",
"Own image size y" => "Taille y de l'image associée",
"Image caption" => "Légende de l'image",
"Publish Date" => "Date de publication",
"Expiration Date" => "Date d'expiration",
"Emails to be notified (separated with commas)" => "Adresses électroniques à notifier (séparaté par des virgules)",
"Edit or create banners" => "Ajouter/modifier une bannière",
"List banners" => "Liste des bannières",
"URL to link the banner" => "Adresse Web de la bannière",
"Max impressions" => "Max. d'impressions",
"-1 for unlimited" => "-1 pour illimté",
"Max clicks" => "Max de clics",
"Or, create a new zone" => "Ou, créer une nouvelle zone",
"Show the banner only between these dates" => "Afficher la bannière seulement entre ces dates",
"From date" => "De cette date",
"To date" => "À cette date",
"Use dates" => "Avec des dates",
"Show the banner only in this hours" => "Afficher la bannière seulement entre ces heures",
"Show the banner only on" => "Afficher la bannière seulement les",
"Mon" => "lun.",
"Tue" => "mar.",
"Wed" => "mer.",
"Thu" => "jeu.",
"Fri" => "ven.",
"Sat" => "sam.",
"Sun" => "dim.",
"Select ONE method for the banner" => "Sélectionner UNE méthode pour la bannière",
"Use HTML" => "Utiliser le HTML",
"Use image" => "Utiliser l'image",
"Current Image" => "Image en cours",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Utiliser l'image provenant de cette adresse Web (cette image va être cherchée à cette adresse Web à chaque impression)",
"Use Flash" => "Utiliser Flash",
"Movie Size" => "Taille de la vidéo",
"FlashPlugin min version" => "Version minimum du plugin Flash",
"Use text" => "Utiliser le texte",
"Save the Banner" => "Enregistrer la bannière",
"Remove Zones (you lose entered info for the banner)" => "Supprimer les zones (vous perdrez toute l'information entrée pour la bannière)",
"Create Blog" => "Créer un blogue",
"A category is mandatory" => "Une catégorie est obligatoire",
"Current heading" => "En-tête courant",
"There are individual permissions set for this blog" => "Des droits d'accès individuels ont été mis sur ce blogue",
"Number of posts to show" => "Nombre d'articles à afficher",
"Allow other user to post in this blog" => "Permettre à un autre utilisateur de publier des articles dans ce blogue",
"Allow search" => "Permettre les recherches",
"Allow comments" => "Permettre les commentaires",
"Show user avatar" => "Afficher les avatars",
"Blog heading" => "En-tête de blogue",
"Edit Style Sheet" => "Modifier la feuille de style",
"Style Sheet" => "Feuille de style",
"choose a stylesheet" => "choisissez une feuille de style",
"Try" => "Essayer",
"Wiki Syntax" => "Syntaxe Wiki",
"More help on editing wiki pages" => "Aide supplémentaire pour éditer des pages Wiki",
"Bold text" => "Texte en gras",
"Italic text" => "Texte en italique",
"single quotes" => "apostrophes simples",
"Underlined text" => "Texte souligné",
"Colored text" => "Texte coloré",
"Deleted text" => "Texte effacé",
"Headings" => "En-têtes",
"Show/Hide" => "Afficher/Cacher",
"show/hide heading section. + (shown) or - (hidden) by default" => "montre/cache les en-têtes de sections. + (vu) ou - (caché) par défaut",
"Autonumbered Headings" => "En-têtes autonumérotées",
"Horizontal rule" => "Règle horizontale",
"Text box" => "Boîte texte",
"Box content" => "texte",
"Centered text" => "Texte centré",
"Dynamic variables" => "Variable dynamique",
"Inserts an editable variable" => "Insérer une variable dynamique",
"External links" => "Liens externes",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Pour un Wiki externe, utiliser NomWikiExterne:NomPage ou ((Nom Wiki Externe: Nom Page))",
"Square Brackets" => "Crochets",
"Use [[foo] to show [foo]." => "Utiliser [[toto] pour afficher [toto].",
"Wiki References" => "Références Wiki",
"JoinCapitalizedWords or use" => "JuxtaposerLesMotsEnMajuscules ou utiliser",
"page|description" => "page|desc",
"for wiki references" => "pour une référence Wiki",
"page|#anchor" => "page|#anchrage",
"page|#anchor|desc" => "page|#anchrage|desc",
"SomeName" => "UnNom",
"prevents referencing" => "pour empêcher de faire une référence",
"Lists" => "Listes",
"for bullet lists" => "pour une liste à puces",
"for numbered lists" => "pour une liste numérotée",
"for definiton lists" => "pour une définition",
"Creates an indentation for each plus (useful in list to continue at the same level)" => "Ajoute un niveau d'indentation pour chaque plus (utile dans une liste pour pouvoir poursuivre au même niveau)",
"Tables" => "Tableaux",
"row" => "rangée",
"Title bar" => "Barre de titre",
"Code sample" => "Echantillon de code",
"Line break" => "Saut de ligne",
"(very useful especially in tables)" => "(très utile particulièrement dans les tables)",
"Multi-page pages" => "Multi-pages",
"to separate pages" => "pour séparer les pages",
"Non parsed sections" => "Sections non analysables",
"Prevents wiki parsing of the enclosed data." => "Empêche l'analyse Wiki pour les données encadrées.",
"Preformated sections" => "Sections préformatées",
"Block Preformatting" => "Préformatter un bloc de texte",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indente le texte avec autant de caractères que nécessaire pour suivre les autres instructions Wiki. L'indentation sera la même que celle que vous utilisez. Remarquez que ce mode ne conserve pas exactement le même nombre d'espaces et de retours à la ligne; utiliser ~pp~...~/pp~ pour cela.",
"Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => " Insertion de, respectivement, une partie de texte orientée de droite à gauche ou de gauche à droite (jusquà la fin du texte) et des marqueurs pour les langues arabes ou hébraïques",
"Special characters" => "Caractère spéciaux",
"Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Puisque la fonction de formattage des paragraphes est active, tous les groupes de lignes avec du texte sont rassemblées au sein de paragraphes. Les lignes, qui peuvent être de tailles indifférentes, sont agrégées avec les lignes suivantes. Les paragraphes sont séparés par des lignes blanches.",
"Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Puisque la fonction de formattage des paragraphes est désactivée, chaque ligne sera présentée comme vous la saisissez. Celà signifie que si vous voulez que les paragraphes soient présentés convenablement, vous devez saisir tout le paragraphe consécutivement.",
"Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "Notez que les arguments des plugins peuvent être encadrés par des double-cotes (&quot;); Ceci leur permet de comporter des virgules (,), des \"égal\" (=) ou des \"supérieur à\" (&gt;)",
"No description available" => "Aucune description disponible",
"Browse Images" => "Parcourir les images",
"Edit successful!" => "Modification réussie!",
"The following image was successfully edited" => "L'image suivante a été modifiée avec succès",
"Image Description" => "Description de l'image",
"Save and Go Next" => "Enregistrer et continuer",
"You can view this image in your browser using" => "Vous pouvez afficher cette page dans votre navigateur en utilisant ",
"You can include the image in an HTML page using one of these lines" => "Vous pouvez insérer l'image dans une page HTML en utilisant l'une de ces lignes",
"Edit or ex/import Languages" => "Modifier ou Im/Export une langue",
"Edit and create Languages" => "Ajouter/modifier une langue",
"Edit and create languages" => "Ajouter/modifier une langue",
"Create Language" => "Créer une langue",
"Shortname" => "Diminutif",
"like" => "comme",
"Longname" => "Nom complet",
"Select the language to edit" => "Sélectionner la langue à modifier",
"Add a translation" => "Ajouter une traduction",
"Edit translations" => "Modifier une traduction",
"Translate recorded" => "Traduction enregistrée",
"Translation" => "Traduction",
"reset table" => "vider la table",
"Create New Block" => "Créer un nouveau bloc",
"Return to block listing" => "Retour à la liste de blocs",
"Publishing date" => "Date de publication",
"Publishing Date" => "Date de publication",
"Edit question options" => "Modifier les options d'une question",
"List Quizzes" => "Liste des QCMs",
"Quiz Stats" => "Statistiques sur les QCMs",
"This Quiz Stats" => "Statistiques de ce QCM",
"Edit this Quiz" => "Modifier ce QCM",
"Admin Quizzes" => "Administrer les QCMs",
"Create/edit options for question" => "Ajouter/modifier une option à la question",
"Quiz" => "QCM",
"canRepeat" => "rempliNFois",
"timeLimit" => "limiteDeTemps",
"Create/edit quizzes" => "Ajouter/modifier un QCM",
"There are individual permissions set for this quiz" => "Des droits d'accès individuels ont été mis sur ce QCM",
"Quiz can be repeated" => "Le QCM peut être rempli plusieurs fois",
"Store quiz results" => "Stocker les résultats du QCM",
"Immediate feedback" => "Commentaires immédiats",
"Show correct answers" => "Montrer les réponses correctes",
"Shuffle questions" => "Mélanger les questions",
"Shuffle answers" => "Mélanger les réponses",
"Quiz is time limited" => "Durée limitée pour remplir le QCM",
"Maximum time" => "Temps maximum",
"Passing Percentage" => "Pourcentage d'accomplissement",
"Edit quiz questions" => "Modifier les questions du QCM",
"Create/edit questions for quiz" => "Ajouter/modifier une question au QCM",
"Question Type" => "Type de la question",
"Import questions from text" => "Importer des questions d'un texte",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: tapez ou collez vos questions à choix multiples ci-dessous. Une ligne pour la question, ensuite sur les lignes suivantes les choix de réponses. Séparez chaque nouvelle question par une ligne blanche. Indiquez les réponses correctes en les commençant par un caractère \"*\" (sans guillemet).",
"Input" => "Saisie",
"maxScore" => "Score max.",
"Edit quiz results" => "Editer les résultats du quiz",
"From Points" => "Des points",
"To Points" => "Aux points",
"Answer" => "Réponse",
"Modify Structure" => "Modifier une structure",
"You will remove" => "Vous allez supprimer",
"and its subpages from the structure" => "et les sous-pages de la structure",
"Remove only from structure" => "Retirer seulement de la structure",
"Remove from structure and remove page too" => "Retirer de la structure et supprimer la page aussi",
"The page already exists. The page that has been added to the structure is the existing one." => "La page existe déjà. La page qui a été ajoutée à la structure est celle qui existe.",
"Structure Layout" => "Contenu de la structure",
"Monitor the Sub-Structure" => "Surveiller la sous-structure",
"Stop Monitoring the Sub-Structure" => "Arrêter de surveiller cette sous-structure",
"Promote" => "Promouvoir",
"Demote" => "Rétrograder",
"Previous" => "Précédent",
"Current Node" => "Courante structure",
"Move in this structure" => "Déplacer dans cette structure",
"Move to another structure" => "Déplacer dans une autre structure",
"at the beginning" => "au début",
"at the end" => "à la fin",
"Add pages to current node" => "Ajouter la page à la structure courante",
"After page" => "Après la page",
"Create Page" => "Créer une page",
"Use pre-existing page" => "Utiliser une page préexistante",
"Categorize all pages in structure together" => "Catégoriser toutes les pages dans la structure",
"Remove existing categories from ALL pages before recategorizing" => "Supprimer toutes les catégories de TOUTES les pages avant \"re-catégorisation\"",
"Submit article" => "Soumettre un article",
"List Submissions" => "Liste des soumissions",
"<b>*</b>=optional" => "<b>*</b>=optionnel",
"<b>Topline</b>=small line above Title" => "<b>Surtitre</b>=petite ligne au-dessus du titre",
"<b>Subtitle</b>=small line below Title" => "<b>Sous_titre</b>=petite ligne en dessous du titre",
"<b>Source</b>=URL to article source" => "<b>Source</b>=URL vers le source de l'article",
"Submit Article" => "Soumettre un article",
"Auto-Approve Article" => "Auto-approuver l'article",
"Edit templates" => "Modifier les gabarits",
"Template listing" => "Liste des gabarits",
"Available templates" => "Gabarits disponibles",
"You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "Vous ne devriez modifier le contenu du fichier header.tpl et des autres fichiers importants, qu'au travers un éditeurs de texte, ou en SSH , ou via un client FTP. Et seulement si vous savez ce que vous faites! ;-)",
"Edit a topic" => "Modifier un sujet",
"Add Notification Email" => "Ajouter une Notification par Email",
"Admin notifications" => "Administrer les notifications",
"View Page" => "Voir la Page",
"View Article" => "Voir l'Article",
"You must specify the object language" => "Vous devez spécifier la langue de l'objet",
"The object doesn't exist" => "L'objet n'existe pas",
"The object doesn't have a language" => "L'objet n'a pas d'indication de langue",
"The object has already a translation for this language" => "L'objet a déjà une traduction pour cette langue",
"The object is already in the set of translations" => "L'objet est déjà dans le jeu de traductions",
"Unspecified" => "Non spécifié",
"Create translation" => "Créer la traduction",
"\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"Vous avez oublié de définir une langue pour cette traduction. Merci d'en choisir une dans la liste.\"",
"Or" => "Ou",
"Manage existing translations of this page" => "Gérer les traductions existantes de cette page",
"detach" => "détacher",
"Change language for this page" => "Changer la langue pour cette page",
"Change Language" => "Changer de Langue",
"Set Current Page's Language" => "Définir la langue de la page en cours",
"View object" => "Voir l'objet",
"Preview your changes." => "Avoir un aperçu de vos modifications.",
"Save the page." => "Enregistrer la page.",
"Cancel the edit, you will lose your changes." => "Annuler la modification, vous allez perdre les modifications.",
"Are you sure you do not want to edit" => "Etes-vous sûr de ne pas vouloir éditer",
"instead?" => "à la place ?",
"Draft written on" => "Brouillon écrit sur",
"Warning: new versions of this page have been made after this draft" => "Attention&nbsp;: de nouvelles versions de cette page ont été faites après ce brouillon",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Le bac à sable est une page où vous pouvez vous entraîner à mettre à jour une page&nbsp;: utiliser la fonction 'Aperçu' pour avoir un aperçu de la page; aucune version de cette page ne sera sauvegardée.",
"Change diff styles" => "Changer le style du diff",
"Edit Comment" => "Commentaire",
"Monitor this page" => "Surveiller cette page",
"Upload picture" => "Envoyer une image",
"Add another image" => "Ajouter une image",
"Tools" => "Outils",
"Admin Content Templates" => "Administrer les gabarits",
"Lock this page" => "Verrouiller cette page",
"Regex search " => "Recherche avec expression régulière",
"Replace with" => "Remplacer par",
"Case Insensitivity" => "Casse non différiencée",
"Try to convert HTML to wiki" => "Essayer de convertir du HTML en Wiki",
"Import page" => "Importer une page",
"export all versions" => "exporter toutes les versions",
"Manage structures" => "Gérer les structures",
"License" => "Licence",
"My Footnotes" => "Mes notes de bas de page personnelles",
"Use rating" => "Utiliser les notes",
"There is no available poll template." => "Il n'y a aucun gabarit de sondage.",
"You should ask an admin to create them." => "Vous devez demander à l'administrateur de les créer.",
"or use" => "ou utiliser",
"an existing poll" => "un sondage existant",
"Translation request" => "Demande de traducation",
"Send urgent translation request." => "Envoyer une demande de traduction urgente.",
"List Sheets" => "Liste des feuillets",
"Graph" => "Graphe",
"Export to file" => "Exporter dans un fichier",
"Autodetect" => "Détection automatique",
"Export Tracker Items" => "Exporter les fiches du formulaire",
"Delimitors" => "Délimiteurs",
"Carriage Return inside Field Value" => "Sauts de lignes dans la valeur du champs",
"Parse as Wiki Text" => "Analyser comme un texte Wiki",
"status" => "état",
"lastModif" => "Dernière modif.",
"Fields visible in items list" => "Champs visibles dans la liste des items",
"Fields searchable or visible in items list" => "Champs visible ou que l'on peut rechercher dans la liste des items",
"Fields visible in an item view" => "Champs visibles dans l'affichage d'une fiche",
"All fields" => "Tous les champs",
"These fields" => "Ces champs",
"Admin FAQ" => "Administrer la FAQ",
"List FAQs" => "Liste des FAQs",
"View FAQ" => "Afficher les FAQs",
"Edit this FAQ" => "Modifier cette FAQ",
"New Question" => "Nouvelle question",
"Edit FAQ question" => "Modifier les questions de la FAQ",
"Add FAQ question" => "Ajouter une question à la FAQ",
"Use a question from another FAQ" => "Utiliser une question d'une autre FAQ",
"FAQ questions" => "Questions de la FAQ",
"Suggested questions" => "Questions suggérées",
"No suggested questions" => "Aucune question suggérée",
"File Archive" => "Archive de fichiers",
"Upload File" => "Envoyer un fichier",
"View tpl" => "Voir le gabarit",
"File Galleries tpl" => "gabarit des galeries de fichiers",
"Be careful to set the right permissions on the files you link to" => "Attention, il faut définir les droits suffisants sur le fichier lié pour qu'il soit lisible",
"Create New File Gallery" => "Créer une nouvelle galerie de fichiers",
"You can access the file gallery using the following URL" => "Vous pouvez accéder à cette galerie de fichiers par cette adresse Web",
"Size (width x height)" => "Dimensions (largeur x hauteur)",
"Forum Importer" => "Import de Forums",
"Admin forums" => "Administrer les forums",
"Import from a Local SQL File" => "Importer depuis un fichier SQL local",
"Forum Type" => "Type de forum",
"DB Prefix" => "Préfixe de la base de données",
"Local SQL Filename on Server (path will be stripped)" => "Nom du Fichier SQL local sur le serveur (le chemin sera strippé)",
"Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Doit être dans tikiroot/{\$tmpdir} ou tikiroot/img/wiki_up",
"Verification" => "Vérification",
"File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>." => "Le fichier doit être un fichier SQL et se situer soit dans <i>\$tikiroot/temp</i> ou <i>\$tikiroot/img/wiki_up</i>.",
"File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "Le fichier n'a pas été spécifié ou n'a pas pu être trouvé dans l'un des répertoires. Veuillez placer le fichier dans l'un des répertoires et recommencez l'opération. Si le fichier est à la fois dans les deux répertoires, celui dans \$tikiroot/{\$filecheck} sera préféré.",
"Select a Forum You Wish to Move (ONE at a time!)" => "Sélectionnez un Forum que vous voulez déplacer (UN seul à la fois !)",
"Which Forum Do You Wish to Import this Into?" => "Quel Forum voulez-vous importer dans celui-ci ?",
"Message queue for forum" => "File d'attente de messages pour le forum",
"Back to forum" => "Retour au forum",
"Edit queued message" => "Modifier un message en attente",
"make this a thread of" => "faire de ceci un fil de discussion",
"None, this is a thread message" => "Aucun, c'est un message de fil de discussion",
"summary" => "résumé",
"announce" => "annonce",
"hot" => "populaire",
"no feeling" => "pas de sentiment",
"frown" => "renfrogné",
"exclaim" => "exclamatif",
"idea" => "idée!",
"neutral" => "neutre",
"happy" => "heureux",
"wink" => "clin d'oeil",
"Save and Approve" => "Enregistrer et approuver",
"convert to topic" => "convertir en sujet",
"List of messages" => "Liste des messages",
"New Topic" => "Nouveau sujet",
"no summary" => "aucun résumé",
"No messages queued yet" => "Aucun message en attente actuellement",
"Search by name" => "Chercher par le nom",
"Search in content" => "Chercher dans le contenu",
"Last Post" => "Dernier article",
"Configure Forum" => "Configurer le forum",
"Reported messages for forum" => "Messages signalés pour le forum",
"Reported by" => "Signalé par",
"Un-report" => "Dé-signaler",
"Set language" => "Définir la langue",
"Universal" => "Universel",
"Show the following languages" => "Afficher les langues suivantes",
"Pending requests" => "Requêtes en attente",
"Request Time" => "Date de la requête",
"Accept" => "Accepter",
"Refuse" => "Refuser",
"Waiting requests" => "Requêtes en attente",
"Cancel friendship request" => "Annuler la demande de mise en relation",
"Your friends" => "Vos amis",
"break friendship" => "casser une amitié",
"Galleries" => "Galeries",
"Create New Gallery" => "Créer une nouvelle galerie",
"Create a gallery" => "Créer une galerie",
"There are individual permissions set for this gallery" => "Des droits d'accès individuels ont été mis sur cette galerie",
"Gallery is visible to non-admin users?" => "Cette galerie est visible aux utilisateurs autres qu'administrateur?",
"Geographic" => "Géographique",
"Fields to show during browsing the gallery" => "Champs affichés au parcours de la galerie",
"Creation Date" => "Date de création",
"XY-Size" => "Taille-XY",
"Gallery Image" => "Galerie d'images",
"Available scales" => "Échelles disponibles",
"Global default" => "Défaut global",
"Bounding box" => "Boîte maximale",
"default scale" => "échelle par défaut",
"No scales available" => "Aucune échelle disponible",
"Original image is default scale" => "L'échelle par défaut est la taille d'origine de l'image",
"Add scaled images with bounding box of square size" => "Ajouter des images avec un cadre à l'échelle suivante",
"Other users can upload images to this gallery" => "Les autres utilisateurs peuvent envoyer des images vers cette galerie",
"You can access the gallery using the following URL" => "Vous pouvez accéder à cette galerie par l'adresse Web suivante",
"Available Galleries" => "Galeries disponibles",
"Choose a filter" => "Choisir un filtre",
"Make Map" => "Construire une carte",
"Save clicked point" => "Sauvegarder le point cliqué",
"Save current view as default" => "Sauvegarder la vue courante comme défaut",
"Center map to saved point" => "Centrer la carte sur le point sauvegardé",
"Users Map" => "Carte utilisateur",
"Select Graphic Type" => "Sélectionner le type de graphique",
"Pie Chart" => "Graphique circulaire",
"Multiline" => "Multi-ligne",
"Multibar" => "Multi-barre",
"Bar Stack" => "Pile des barres",
"Landscape" => "Paysage",
"Independant Scale" => "Echelle indépendante",
"Horizontal Scale" => "Echelle horizontale",
"Vertical Scale" => "Echelle verticale",
"Series" => "Séries",
"Wiki plug-in" => "Plug-in Wiki",
"Ical import / Export" => "Importer/exporter en Ical",
"Select The calendar to export" => "Sélectionner le calendrier à exporter",
"To" => "À",
"Calendar Import" => "Importer un calendrier",
"ICal File" => "Fichier ICal",
"Im- Export languages" => "Langues Im/Export",
"Select the language to Import" => "Sélectionner la langue à importer",
"Select the language to Export" => "Sélectionner la langue à exporter",
"Import From File" => "Importer d'un fichier",
"Grab Wiki Tables" => "Récupérer les tables Wiki",
"Import pages from a Structured Text Dump" => "Importer les pages d'un Dump Texte Structuré",
"Name of the dump file (it has to be in dump/)" => "Nom du fichier-dump (il doit être dans dump/)",
"Overwrite existing pages if the name is the same" => "Écraser les pages existantes si le nom est le même",
"Previously remove existing page versions" => "Supprimer les versions préexistantes de la page",
"excerpt" => "extrait",
"Result" => "Résultat",
"body" => "corps",
"Locked" => "Verrouillé",
"Tiki installer" => "Installation Tiki",
"Welcome" => "Bienvenue",
"Use this script to install a new Tiki database or upgrade your existing database to release" => "Utilisez ce script pour installer une nouvelle base de données Tiki ou mettre à jour votre base de données pour installer",
"For the latest information about this release, please read the" => "Pour les dernières informations concernant cette release, veuillez consulter",
"Release Notes" => "Notes de release",
"For complete documentation, please visit" => "Pour une documantation complète, veuillez consulter",
"For more information about Tiki, please visit" => "Pour plus d'informations concernant Tiki, veuillez consulter",
"Read the License" => "Lire la licence",
" <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/deed.fr\" target=\"_blank\">En cliquant ici, vous obtiendrez un résumé plus abordable de la license ci-dessous, incluant de nombreuses traductions.</a>",
"Review the System Requirements" => "Vérifier les pré-requis systèmes",
"Memory" => "Mémoire",
"Success" => "Succès",
"Copy test mail to " => "Faire une copie de l'email de test à ",
"Send Test Message" => "Envoyer un message de test",
"Tiki was able to send a test message to" => "Tiki a réussi à envoyer un message à",
"Image Processing" => "Génération d'images",
"Set the Database Connection" => "Configuration de la connexion à la base de données",
"Use Existing Connection" => "Utiliser la connexion existante",
"Database information" => "Configuration de la base de données",
"Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension." => "Les seuls moteurs de bases de données qui sont listés ici sont ceux acceptés par votre installation PHP. Si votre moteur de base de données ne figure pas dans cette liste, essayez d'installer les bonnes extensions PHP.",
"Database user" => "Utilisateur de la base de données",
"Install" => "Installer",
"Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page." => "Impossible d'alonger la durée max_execution_time dans PHP. Vous pouvez rencontrer des problèmes lors de la création ou la mise à jour de la base de données sur des systèmes lents. Vous obtiendrez alors une page blanche.",
"Reinstall the database" => "Réinstallez la base de données",
"Upgrade" => "Mise à jour",
"Automatically upgrade your existing database to v" => "Mettre à jour votre base de données existante vers la version ",
"Review the Upgrade" => "Vérifier la mise à jour",
"Review the Installation" => "Vérifier l'installation",
"Upgrade complete" => "Mise à jour terminée",
"Installation complete" => "Installation terminée",
"Your database has been configured and Tiki is ready to run!" => "Votre base de données a été configurée et Tiki est prêt à fonctionner !",
"If this is your first install, your admin password is <strong>admin</strong>." => "Si ceci est votre première installation, veuillez noter que le mot de passe admin est <strong>admin</strong>.",
"You can now log in into Tiki as user <strong>admin</strong> and start configuring the application." => "Vous pouvez maintenant vous connecter à Tiki en tant qu'<strong>admin</strong> et débuter la configuration de l'application.",
"Failed" => "Echoué",
".htaccess File" => "Fichier .htaccess",
"We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "Nous recommandons d'activer le fichier <strong>.htaccess</strong> pour votre Tiki",
"This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "Ceci vous permettra d'utiliser SEFURLs ('Search Engine Friendly URLs' ou 'URLs plus adaptées aux moteurs de recherche') et améliore la sécurité du site",
"Configure General Settings" => "Configuration générale",
"Secure Login" => "Connexion sécurisée",
"Administrator" => "Administrateur",
"Enter Your Tiki" => "Accéder à votre Tiki",
"If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu." => "Si ceci est une évolution, nettoyez les caches manuellement (le répertoire <strong>templates_c</strong>) ou en utilisant l'option <strong>Admin &gt; System</strong> du menu d'administration.",
"Enter Tiki and Lock Installer" => "Entrer dans Tiki en désactivant l'installeur",
"Recommended" => "Recommandé",
"Enter Tiki Without Locking Installer" => "Entrer dans Tiki sans désactiver l'installeur",
"MultiTiki Setup" => "Configuration MultiTiki",
"Default Installation" => "Installation par défaut",
"DB OK" => "BDD OK",
"No DB" => "Pas de BDD",
"Install/Upgrade" => "Installer/Mettre à jour",
"Database Connection" => "Connexion à la base de données",
"Reset the Database Connection" => "Réinitialiser la connexion à la base de données",
"Install Profile" => "Installer un profil",
"Configure the General Settings" => "Configurer les paramètres généraux",
"Tiki Icon" => "Icone Tiki",
"TikiWiki Project Web Site" => "Site web du projet TikiWiki",
"Support Forums" => "Forums de support",
"TikiWiki CMS/Groupware Project" => "Projet TikiWiki CMS/Groupware",
"Powered by TikiWiki" => "Utilise TikiWiki",
"Clear cached version and refresh cache" => "Vider l'antémémoire et la reconstruire",
"configure rules" => "configurer les règles",
"Edit Repository" => "Modifier un répertoire",
"Interactive translator" => "Translation interactive",
"has been updated" => "a été mis à jour",
"Close this window" => "Fermer cette fenêtre",
"Go Back" => "Retour",
"Clicking 'Close this window' will reload the main window from where it was opened" => "Cliquer sur 'Fermer cette fenêtre' va recharger la fenêtre principale à partir de l'endroit où elle a été ouverte",
"Last Changes" => "Dernières modifications",
"Last 2 days" => "2 derniers jours",
"Last 3 days" => "3 derniers jours",
"Last 5 days" => "5 derniers jours",
"Last week" => "Dernière semaine",
"Last 2 weeks" => "2 dernières semaines",
"Last month" => "Dernier mois",
"Search by Date" => "Recherche par date",
"LastChanges" => "DerniersChangements",
"Rollback" => "Reprendre",
"Pages like" => "Pages similaires à",
"No pages found" => "Aucun résultat",
"Edit New Article" => "Créer un article",
"View Submissions" => "Liste des soumissions",
"ExpireDate" => "Date d'expiration",
"AuthorName" => "Auteur",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Pour utiliser une bannière dans un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{banner zone=ABC}{/literal}, où ABC est le nom de la zone.",
"Create banner" => "Créer une bannière",
"Method" => "Méthode",
"Use Dates?" => "Utiliser des dates?",
"Max Impressions" => "Max. d'impressions",
"Max Clicks" => "Max. de clics",
"Clicks" => "Clics",
"Create New Blog" => "Créer un nouveau blogue",
"Approval" => "Approbation",
"Rejected" => "Rejeté",
"Dynamic content system" => "Système de contenu dynamique",
"To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "Pour utiliser les blocs de contenus dans une zone de texte (page Wiki page, etc.), un <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> ou un gabarit, utiliser {literal}{content id=x}{/literal}, où x est l'Id du bloc de contenu.",
"Available content blocks" => "Blocs de contenu disponibles",
"Current ver" => "Version en cours",
"Next ver" => "Prochaine version",
"Future vers" => "Versions futures",
"Program" => "Programmer",
"Available FAQs" => "FAQs disponibles",
"Edit/Create" => "Modifier/Ajouter",
"Create new FAQ" => "Créer une nouvelle FAQ",
"Users can suggest questions" => "Les utilisateurs peuvent suggérer des questions",
"Create a File Gallery" => "Créer une galerie de fichiers",
"SlideShow" => "Diaporama",
"Keep gallery window open" => "Maintenir la fenêtre de la galerie ouverte",
"Your comment" => "Votre commentaire",
"Property <b>{\$fgp_name}</b> Changed" => "Propriété <b>{\$fgp_name}</b> Modifiée",
"Gallery Images" => "Galerie d'images",
"Additional Info" => "Info additionnelles",
"Edit Blog" => "Modifier le blogue",
"Blog Title" => "Titre du blogue",
"Edit New Submission" => "Créer une nouvelle soumission",
"Survey stats" => "Statistiques sur les enquêtes",
"Take Survey" => "Remplir une enquête",
"users registered" => "utilisateurs enregistrés",
"List Movies" => "Liste des films",
"Choose a movie" => "Choisir un film",
"Last mod" => "Der. mod",
"Last modification" => "Dernière modification",
"Page creator" => "Créateur",
"Last author" => "Dernier auteur",
"Last version" => "Dernière version",
"Last ver." => "Derniêre ver.",
"Status of the page" => "Statut de la page",
"Page size" => "Taille de page",
"unlocked" => "non verrouillé",
"Perform action with checked" => "Action à mener sur les items sélectionnés",
"Open client window" => "Ouvrir une console client",
"Generate HTML" => "Générer en HTML",
"Transcripts" => "Rapports",
"Online operators" => "Opérateur connecté",
"Operator" => "Opérateur",
"transcripts" => "rapports",
"offline" => "non connecté",
"Offline operators" => "Opérateurs non connectés",
"Add an operator to the system" => "Ajouter un opérateur au système",
"Operators must be tiki users" => "Les opérateurs doivent être des utilisateurs Tiki",
"Set as Operator" => "Le mettre en opérateur",
"Chat started" => "Discussion commencée",
"Live support:User window" => "Assistance en ligne&nbsp;: Fenêtre utilisateur",
"Request live support" => "Demande d'assistance en ligne",
"Request support" => "Demande d'assistance",
"Open a support ticket instead" => "Ouvrir un ticket d'assistance à la place",
"Your request is being processed" => "Votre demande a été prise en compte",
"cancel request and exit" => "supprimer la demande et sortir",
"cancel request and leave a message" => "supprimer la demande et laisser un message",
"Live support:Console" => "Assistance en ligne&nbsp;: Console",
"be online" => "se connecter",
"be offline" => "se déconnecter",
"Support requests" => "Demandes d'assistance",
"Requested" => "Demandé",
"Join" => "Joindre",
"Support chat transcripts" => "Rapports des discussions d'assistance",
"operator" => "opérateur",
"started" => "commencé",
"reason" => "raison",
"Transcript" => "Rapport",
"For security purposes we must periodically validate your email address to allow continued access to this site." => "Pour des raisons de sécurité, vous devez périodiquement revalider votre adresse électronique pour pouvoir accéder au site.",
"A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "Un courriel de validation vous a été envoyé. SVP ouvrez le et suivez les instructions pour pouvoir réaccéder au site",
"Thank you" => "Merci",
"Mail-in feature" => "Fonctionnalité mail-in",
"Daily" => "Journalier",
"Weekly" => "Hebdomadaire",
"Remove old events" => "Supprimer les vieux évènements",
"duration" => "durée",
"Mini Calendar: Preferences" => "Mon Calendrier&nbsp;: Préférences",
"Calendar Interval in daily view" => "Intervalle de temps dans la vue journalière",
"Start hour for days" => "Première heure vue du jour",
"End hour for days" => "Dernière heure vue du jour",
"Reminders" => "Rappels",
"no reminders" => "Aucun rappel",
"Or enter path or URL" => "Ou donner un chemin d'accès ou une adresse Web",
"Add Topic" => "Ajouter le sujet",
"Tikiwiki Mods" => "Mods Tikiwiki",
"Mods Configuration" => "Configuration des Mods",
"Update remote index" => "Mettre à jour l'index à partir du serveur distant",
"Rebuild local list" => "Reconstruire la liste locale",
"Republish all" => "Republier tout",
"Publish all" => "Publier tout",
"Unpublish all" => "Dépublier tout",
"Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Les Tiki \"mods\" sont des fonctionnalités additionnelles qui ne sont pas incluses dans la version publique de Tikiwiki. Pour en savoir plus, aller sur <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
"all types" => "tous les types",
"for version" => "pour la version",
"all versions" => "Toutes les versions",
"or later" => "où plus tard",
"Display only this type" => "N'afficher que ce type",
"Unpublish" => "Le dépublier",
"Republish" => "Republier",
"Tikiwiki Mods Configuration" => "Configuration des Mods Tikiwiki",
"Mods Install/uninstall" => "Installer/Désinstaller les mods",
"Enable Mods providing" => "Permettre au serveur local d'être serveur de Mods",
"Mods local directory" => "Répertoire des Mods sur le serveur local",
"Mods remote server" => "Répertoire des Mods sur le serveur distant",
"Package Config" => "Configuration des Progiciels",
"y" => "oui",
"User Galleries" => "Mes galeries",
"My Articles" => "Mes articles",
"User Articles" => "Articles de l'utilisateur",
"Unread Messages" => "Messages non lus",
"Tasks" => "Tâches",
"User forum topics" => "Sujet de l'utilisateur dans le forum",
"Forum topics" => "Sujets de forum",
"Date of post" => "Date du post",
"User forum replies" => "Réponses de l'utilisateur dans le forum",
"Forum replies" => "Réponses dans le forum",
"MyTiki" => "MonTiki",
"MyInfo" => "Mes infos",
"Contacts Preferences" => "Préférences des contacts",
"Notepad" => "Bloc-note",
"MyFiles" => "MesFichiers",
"My Watches" => "Mes notifications",
"Sent editions" => "Lettres d'informations envoyées",
"Sent Edition" => "Lettre d'informations envoyée",
"HTML version" => "Version HTML",
"Text version" => "Version texte",
"The newsletter was sent to {\$sent} email addresses" => "Cette lettre d'informations a été envoyée à {\$sent} adresses électroniques",
"Delete errors" => "Effacer les erreurs",
"Not sent" => "Non envoyé",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Merci pour votre inscription. Vous recevrez un email bientôt pour confirmer votre inscription. Aucune lettre d'information ne vous sera envoyée tant que l'inscription ne sera pas confirmée.",
"Your email address was removed from the list of subscriptors." => "Votre adresse électronique a été supprimée dans la liste des abonnés",
"Subscription confirmed!" => "Votre inscription est confirmée!",
"Subscribe to Newsletter" => "S'abonner à une lettre d'informations",
"Subscribe to this Newsletter" => "S'abonner à cette lettre d'informations",
"Available Newsletters" => "Lettres d'informations disponibles",
"Notes" => "Liste des notes",
"Write a note" => "Écrire une note",
"No notes yet" => "Aucune note pour l'instant",
"Merge selected notes into" => "fusionner les notes sélectionnées dans",
"List notes" => "Liste des notes",
"Write note" => "Écrire une note",
"Wiki Create" => "Créer la page Wiki",
"Wiki Overwrite" => "écraser la page Wiki",
"Assign permissions to " => "Attribuer des droits d'accès&nbsp;: ",
"Edit Permissions" => "Éditer les permissions",
"Assign permissions to this object" => "Attribuer de nouveaux droits d'accès à cet objet",
"These permissions override any global permissions or category permissions affecting this object." => "Ces permissions remplacent toutes les permissions globales ou de catégories rattachées à cet objet.",
"Published" => "Publié",
"Your OpenID identity is valid" => "Votre compte OpenID est correct",
"However, no account is associated to the OpenID identifier." => "Cependant, aucun compte est associé avec l'identifi",
"Create a new Tikiwiki account from OpenID" => "Créer un compte Tikiwiki pour cet OpenId",
"Passcode to register (not your user password)" => "Passcode pour s'inscrire (pas votre mot de passe d'utilisateur)",
"Your identity gives you access to multiple user accounts." => "Votre identité vous donne accès à plusieurs comptes utilisateur.",
"Select account" => "Choisir un compte",
"Orphan Pages" => "Pages orphelines",
"Browser not supported" => "Navigateur non supporté",
"Rename" => "Renommer",
"Make Structure" => "Créer une structure",
"Slides" => "Diapositives",
"Discuss" => "Discussion",
"Attach File" => "Fichier-joint",
"1 File Attached" => "1 fichier joint",
"(current)" => "(courant)",
"Rollback to this version" => "Revenir à cette version",
"b=rollback" => "b=reprendre",
"Update Translation" => "Mettre à jour la traduction",
"Hide translation history" => "Cacher l'historique des traductions",
"Show translation history" => "Montrer l'historique des traductions",
"Pick your avatar" => "Choisissez votre avatar",
"User Preferences" => "Préférences utilisateur",
"Your current avatar" => "Votre avatar actuel",
"no avatar" => "aucun avatar",
"reset" => "réinitialiser",
"Pick avatar from the library" => "Choisissez un avatar de la bibliothèque",
"Pick user Avatar" => "Choisissez un avatar utilisateur",
"Hide all" => "Masquer tout",
"icons" => "icônes",
"Show all" => "Montrer tout",
"Avatar Image" => "Image avatar",
"random" => "au hasard",
"Upload your own avatar" => "Envoyer votre avatar",
"View arguments" => "Voir les arguments",
"Execute the plugin in preview mode (may be dangerous)" => "Exécute le plugin en mode prévisualisation (peut être risqué)",
"Approve the plugin for public execution" => "Autoriser le plugin pour une exécution publique",
"View Details" => "Voir les Détails",
"Insert" => "Insérer",
"Any" => "Tout",
"Rank" => "Rang",
"atts" => "joints",
"List Attachments" => "Liste des fichiers joints",
"Average" => "Moyenne",
"Sum" => "Somme",
"View Results" => "Voir les résultats",
"Vote poll" => "Voter",
"Other Polls" => "Autres sondages",
"Poll Results" => "Resultats des sondages",
"All votes" => "Tous les votes",
"List Votes" => "Liste des votes",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Note&nbsp;: Ceci est un aperçu, et n'a pas encore été sauvegardé",
"Topic image" => "image du sujet",
"Permission denied. You do not have permission to read complete articles." => "Droit d'accès refusé&nbsp;: vous ne pouvez pas consulter les articles complets.",
"Viewing blog post" => "Affichage des articles du blogue",
"Return to blog" => "Retourner au blogue",
"The original document is available at" => "Le document d'origine est disponible à",
"Print multiple pages" => "Imprimer des pages multiples",
"Selected Structures" => "Structures Sélectionnées",
"Add Structure" => "Ajouter une structure",
"No structures" => "Aucune structure",
"Add Pages" => "Ajouter les pages",
"No pages" => "Aucune page",
"Use Ctrl+Click to select multiple pages" => "Utiliser Ctrl+Click pour sélectionner plusieurs pages",
"Add Page" => "Ajouter des pages",
"Add Pages from Structures" => "Ajouter les pages des structures",
"Selected Pages" => "Pages sélectionnées",
"No pages selected." => "Aucune page n'a été sélectionnée.",
"Edit quiz" => "Modifier un QCM",
"Current Version" => "Version courante",
"General Options" => "Options générales",
"Publication Date" => "Date de publication",
"at " => "à ",
"Use " => "Utilisez ",
"randomly selected questions." => "questions choisies au hasard.",
"Test-time Options" => "Options sur la période de test",
"Limit questions displayed per page to " => "Limiter les questions affiché par page à ",
"&nbsp question(s)." => "&nbsp; question(s).",
"Impose a time limit of " => "Imposer un temps limite de ",
"Allow students to store partial results and return to quiz." => "Permettre aux étudiants de sauvegarder des réponses partielles et de revenir au QCM",
"Allow students to retake this quiz " => "Permettre aux étudiants de repasser ce QCM",
"Grading and Feedback" => "Corrections et commentaires",
"Grading method " => "Méthode de correction ",
"Show students their score " => "Montrer aux étudiants leur score",
"Show students the correct answers " => "Montrer aux étudiants les réponses correctes",
"Publish statistics " => "Publier les statistiques ",
"Extra Options" => "Options supplémentaires",
"Solicit additional questions from students" => "Solliciter des questions supplémentaires aux étudiants",
"Link quiz to forum named: " => "Lié le QCM au forum de nom&nbsp;: ",
"Quiz result stats" => "Statistiques sur les résultats de QCM",
"Time" => "Temps",
"User answers" => "Réponses de l'utilisateur",
"Stats for quizzes" => "Statistiques sur les QCMs",
"taken" => "Réponses",
"Av score" => "Score moyen",
"Av time" => "Temps moyen",
"Clear Stats" => "Effacer les statistiques",
"time taken" => "temps utilisé",
"P/F" => "R/E",
"Passed" => "Réussi",
"Stats for this quiz Questions " => "Statistiques sur les questions de ce QCM",
"Top 10" => "10 premiers",
"Top 20" => "20 premiers",
"Top 50" => "50 premiers",
"Top 100" => "100 premiers",
"star" => "étoile",
"half star" => "demi étoile",
"Send a link" => "Envoyer un lien",
"Received articles" => "Articles reçus",
"Edit received article" => "Modifier l'article reçu",
"Use Image" => "Utiliser images",
"Image x size" => "Image x pixel",
"Image y size" => "Image y pixel",
"Image name" => "Nom de l'image",
"Accept Article" => "Accepter article",
"Received Pages" => "Pages reçues",
"Edit Received Page" => "Éditer les pages reçues",
"The highlight pages already exist." => "Les pages surlignées existent déjà.",
"Please, change the name if you want the page to be uploaded." => "Veuillez changer le nom si vous désirez pouvoir charger la page.",
"Referer stats" => "Statistiques des origines",
"Last" => "Derniers",
"Your email could not be validated; make sure you email is correct and click register below." => "Votre adresse électronique ne peut pas être validée, vérifier qu'il est correct et cliquer sur S'inscrire.",
"Register as a new user" => "S'inscrire comme nouvel utilisateur",
"Use your email as login" => "Utilisez votre adresse électronique pour vous connecter",
"Repeat password" => "Encore",
"A valid email is mandatory to register" => "Une adresse électronique valide est nécessaire pour s'inscrire",
"Select your group" => "Choissisez votre groupe",
"Tiki site registered" => "Site Tiki enregistré",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Le site suivant a été ajouté, la validation de l'administrateur est peut être nécessaire",
"You don't have permission to use this feature." => "Vous n'avez pas le droit d'utiliser cette fonctionnalité.",
"Please register." => "Enregistrez-vous",
"Register this site at tikiwiki.org" => "Enregistrez ce site sur tikiwiki.org",
"Read this first!" => "Lisez ceci d'abord!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Sur cette page, vous pouvez faire connaître votre site à tikiwiki.org",
"Registering is voluntary." => "L'inscription est libre.",
"Registering does not give you any benefits except one more link to your site." => "L'inscription n'apporte rien de plus qu'un lien vers votre site.",
"You don't get any emails, we don't sell the data about your site." => "Vous ne recevrez pas d'emails. Nous ne vendons pas vos informations.",
"Registering is just for us to get an overview of Tiki's usage." => "L'inscription nous sert à avoir une idée de l'utilisation de Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Si votre site est privé ou sur un intranet, ne l'inscrivez pas!",
"Information about your site" => "Information sur votre site",
"Enter your username or email." => "Entrer votre compte ou adresse mail.",
"Send me my Password" => "Envoyez-moi mon mot de passe",
"Request Password Reset" => "Demander une réinitialisation du mot de passe",
"Remove page" => "Supprimer la page",
"Last Version" => "Dernière version",
"Back to page" => "Retour à la page",
"You are about to remove the page" => "Vous êtes sur le point de supprimer la page",
"permanently" => "définitivement",
"Remove all versions of this page" => "Supprimer toutes les versions de la page",
"Rollback page" => "Retour en arrière",
"Searched" => "Recherché",
"Search in" => "Rechercher dans",
"Simple search" => "Recherche simple",
"No pages matched the search criteria" => "Aucune page ne correspond au critère de recherche",
"This newsletter will be sent to {\$subscribers} email addresses." => "Cette lettre d'informations va être envoyée à {\$subscribers} adresses électroniques.",
"Prepare a newsletter to be sent" => "Préparer une lettre d'informations pour être envoyée",
"Apply content template" => "Appliquer un gabarit de contenu",
"Attached Files" => "Fichier(s) attaché(s)",
"To add a file, click here" => "Pour ajouter un fichier, cliquer ici",
"Save as Draft" => "Enregistrer comme brouillon",
"Send objects" => "Envoyer des objets",
"Transmission results" => "Transmission des résultats",
"Send Wiki Pages" => "Envoyer des pages Wiki",
"Send a structure" => "Envoyer une structure",
"Send Articles" => "Envoyer des articles",
"Add Article" => "Ajouter un article",
"Send objects to this site" => "Envoyer des objets à ce site",
"Ex: http://tikiwiki.org or localhost" => "Exemple&nbsp;: http://tikiwiki.org ou localhost",
"Create a sheet" => "Créer un feuillet",
"Create New Sheet" => "Créer un nouveau feuillet",
"There are individual permissions set for this sheet" => "Des droits d'accès individuels ont été mis sur ce feuillet",
"Class Name" => "Nom de la classe",
"Header Rows" => "Rangées en-tête",
"Footer Rows" => "Rangées bas-de-page",
"Create new Sheet" => "Créer un nouveau feuillet",
"You can access the sheet using the following URL" => "Vous pouvez accéder à ce feuillet par l'adresse Web suivante",
"Available Sheets" => "Feuillets disponibles",
"Change shoutbox general settings" => "Changer la configuration générale du mégaphone",
"auto-link urls" => "reconnaissance automatique des URLs",
"Post or edit a message" => "Publier ou modifier un message",
"Location : " => "Position&nbsp;: ",
"Approve changes." => "Approuver les modifications.",
"Content may be out of date" => "Le contenu peut ne plus être à jour",
"TOC" => "Sommaire",
"Parent page" => "Page parente",
"Child" => "Enfant",
"page: %0/%1" => "page : %0/%1",
"Last edited by" => "Dernièrement modifié par",
"based on work by" => "Basé sur le travail de",
"Contributors to this page" => "Collaborateur(s) de cette page",
"Page last modified on %0 by %1" => "Page dernièrement modifiée le %0 par %1",
"Created by %0" => "Créé par %0",
"Last Modification: %0 by %1" => "Dernière Modification : %0 par %1",
"Clean" => "Nettoyer",
"Most viewed objects" => "Objets les plus vus",
"Most viewed objects in the last 7 days" => "Objets les plus vus ces derniers 7 jours",
"Site Stats" => "Statistiques du site",
"Started" => "Débuté le",
"Days online" => "Nombre de jours en ligne",
"Total pageviews" => "Total des pages vues",
"Average pageviews per day" => "Nombre moyen de pages vues par jour",
"pvs" => "pages vues",
"Best day" => "Jour le plus populaire",
"Worst day" => "Jour le moins populaire",
"Wiki Stats" => "Statistiques de Wiki",
"Size of Wiki Pages" => "Taille totale des pages Wiki",
"Average page length" => "Taille moyenne d'une page",
"Average versions per page" => "Nombre moyen de versions par page",
"Visits to wiki pages" => "Nombre de visites aux pages Wiki",
"Average links per page" => "Nombre moyen de liens par page",
"Image galleries Stats" => "Statistiques sur les galeries d'images",
"Average images per gallery" => "Nombre moyen d'images par galerie",
"Total size of images" => "Taille totale des images",
"Average image size" => "Taille moyenne d'une image",
"Visits to image galleries" => "Nombre de visites aux galeries d'images",
"File galleries Stats" => "Statistiques sur les galeries de fichiers",
"Average files per gallery" => "Nombre moyen de fichiers par galerie",
"Total size of files" => "Taille totale des fichiers",
"Average file size" => "Taille moyenne d'un fichier",
"Visits to file galleries" => "Nombre de visites aux galeries de fichiers",
"CMS Stats" => "Statistiques sur les articles",
"Total reads" => "Nombre total de lectures",
"Average reads per article" => "Nombre moyen de lectures par article",
"Total articles size" => "Taille totale des articles",
"Average article size" => "Taille moyenne d'un article",
"Forum Stats" => "Statistiques sur les forums",
"Total topics" => "Nombre total de sujets",
"Average topics per forums" => "Nombre moyen de sujets par forum",
"Total replies" => "Nombre total de réponses",
"Average number of replies per topic" => "Nombre moyen de réponses par sujet",
"Visits to forums" => "Visites aux forums",
"Blog Stats" => "Statistiques sur les blogues",
"Weblogs" => "Blogues",
"Total posts" => "Total des articles",
"Average posts per weblog" => "Moyenne d'articles par blogue",
"Total size of blog posts" => "Taille totale des articles du blogue",
"Average posts size" => "Taille moyenne d'un article",
"Visits to weblogs" => "Visites aux blogues",
"Poll Stats" => "Statistiques sur les sondages",
"Total votes" => "Total de votes",
"Average votes per poll" => "Nombre moyen de votes par sondage",
"FAQ Stats" => "Statistiques des FAQ",
"Total questions" => "Nombre total de questions",
"Average questions per FAQ" => "Nombre moyen de questions par FAQ",
"User Stats" => "Statistiques sur les utilisateurs",
"Average bookmarks per user" => "Nombre moyen de signets par utilisateur",
"Average questions per quiz" => "Nombre moyen de questions par QCM",
"Quizzes taken" => "QCMs remplis",
"Average quiz score" => "Moyenne des scores de QCM",
"Average time per quiz" => "Temps moyen pour remplir un QCM",
"Usage chart" => "Graphe d'utilisation",
"Usage chart image" => "Image du graphe d'utilisation",
"Daily Usage" => "Usage journalier",
"Stats for surveys" => "Statistiques sur les enquêtes",
"Last taken" => "Dernière réponse",
"Tiki Logs" => "Logs Tiki",
"Clean logs older than" => "Nettoyer les entrées de journal plus vieilles que",
"months" => "mois",
"Time Left" => "Temps restant",
"Send Answers" => "Envoyer les réponses",
"Thank you for your submission" => "Merci pour votre soumission",
"Send a link to a friend" => "Envoyer ce lien à un ami",
"Your email was sent" => "Votre email a été envoyé",
"Friend's email" => "Adresse mail de votre ami",
"Separate multiple email addresses with a comma." => "Séparer les adresses mail par des virgules.</em>",
"Your name" => "Votre nom",
"Your email" => "Votre adresse email",
"I found an interesting page that I thought you would like." => "J'ai trouvé cette page qui pourrait t'intéresser.",
"TikiTests Edit" => "Editer des TikiTests",
"Summary mode" => "Mode résumé",
"Show Page Differences" => "Montrer les différences de page",
"Show POST Data" => "Afficher les données du POST",
"Delete this link" => "Supprimer ce lien",
"TikiTests List" => "Liste des TikiTests",
"Replay" => "Rejouer",
"Tidy extension not present" => "Extension Tidy non présente",
"PECL HTTP extension present" => "Extension PECL HTTP présente",
"cURL extension present" => "Extension cURL présente",
"List TikiTests" => "Lister les TikiTests",
"Create a TikiTest" => "Créer un TikiTest",
"Replay the TikiTest" => "Rejouer un TikiTest",
"Edit the TikiTest" => "Editer un TikiTest",
"TikiTests Record Configuration" => "Configuration de l'enregistrement des TikiTests",
"Start Recording Test" => "Démarrer l'enregistrement du test",
"Failure" => "Échec",
"Reference" => "Référence",
"The pages are different" => "Les pages sont différentes",
"The pages are identical" => "Les pages sont identiques",
"Recording to pause press the pause button" => "Enregistre, pour interrompre appuyer sur le bouton pause",
"Pause the recording" => "Interrompre l'enregistrement",
"Paused to resume press the play button" => "Pause, pour reprendre appuyer sur le bouton lecture",
"Resume the recording" => "Reprendre l'enregistrement",
"Stop the recording" => "Arrêter l'enregistrement",
"Theme Control Center: Categories" => "Contrôle des thèmes/Catégories",
"Theme is selected as follows" => "Le thème est choisi comme suit",
"If a theme is assigned to the individual object that theme is used." => "Si un thème est attribué à l'objet lui-même, ce thème est utilisé",
"If not then if a theme is assigned to the object's category that theme is used" => "Sinon, si un thème est attribué à la catégorie de l'objet, ce thème est utilisé",
"If not then a theme for the section is used" => "Sinon, le thème de la section est utilisé",
"If none of the above was selected the user theme is used" => "Si rien au-dessus n'est sélectionné, le thème de l'utilisateur est utilisé",
"Finally if the user didn't select a theme the default theme is used" => "Finalement, si l'utilisateur n'a pas sélectionné un thème, le thème par défaut est utilisé",
"Control by Objects" => "Contrôle des thèmes/objets",
"Control by Sections" => "Contrôle des thèmes/sections",
"Assign themes to categories" => "Attribuer un thème à une catégorie",
"Assigned categories" => "Catégories avec thème",
"Theme Control Center: Objects" => "Contrôle des thèmes/objets",
"Control by Categories" => "Contrôle des thèmes/catégories",
"Assign themes to objects" => "Attribuer un thème à un objet",
"Assigned objects" => "Objets avec thème",
"Theme Control Center: Sections" => "Contrôle des thèmes: Sections",
"Assign themes to sections" => "Attribuer un thème à une section",
"Assigned sections" => "Sections avec thème",
"The following file was successfully uploaded" => "Ce fichier a été envoyé avec succès",
"The following files have been successfully uploaded" => "Les fichiers suivants ont été téléchargés avec succès",
"You can download this file using" => "Vous pouvez télécharger ce fichier avec",
"You can link to the file from a Wiki page using" => "Vous pouvez inclure un lien vers le fichier dans une page Wiki en utilisant",
"You can display an image in a Wiki page using" => "Vous pouvez afficher l'image dans une page Wiki en utilisant",
"You can link to the file from an HTML page using" => "Vous pouvez inclure un lien vers le fichier dans une page HTML en utilisant",
"You locked the file" => "Vous avez verrouillé le fichier",
"The file is locked by {\$fileInfo.lockedby}" => "Le fichier est verrouillé par {\$fileInfo.lockedby}",
"required field for podcasts" => "champ obligatoire pour podcasts",
"Unzip zip files" => "Dézipper les fichiers zip",
"Add File" => "Ajouter",
"Uploading file..." => "Envoi du fichier...",
"No File to Upload..." => "Pas de fichier à envoyer...",
"Batch Upload Results" => "Résultats de l'envoi par lot",
"Upload successful!" => "Envoi réussi !",
"The following image was successfully uploaded" => "L'image suivante a été envoyée avec succès",
"Image ID thumb" => "Vignette de l'image",
"You can include the image in an Wiki page using" => "Vous pouvez insérer cette image dans une page Wiki en utilisant",
"or use filename" => "ou utiliser le nom du fichier",
"Now enter the image URL" => "Entrer maintenant l'adresse Web",
"or upload a local image from your disk" => "ou envoyer une image à partir de votre disque",
"Batch Upload" => "Envoi par lot",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Vignette (optionnel, annule et remplace la génération automatique de vignettes)",
"You have to create a gallery first!" => "Il faut tout d'abord créer une galerie !",
"User assigned modules" => "Modules utilisateur",
"Restore defaults" => "Restaurer les valeurs par défaut",
"Assign module" => "Attribuer un module",
"Column" => "Colonne",
"Folders" => "Répertoires",
"Folder in" => "Aller dans le répertoire",
"Remove Folder" => "Supprimer le répertoire",
"Refresh Cache" => "Réactualiser l'antémémoire",
"Admin folders and bookmarks" => "Administrer les répertoires et les signets",
"a folder" => "un répertoire",
"User Contacts Preferences" => "Préférences sur mes contacts",
"Default view" => "Vue par défaut",
"Manage Fields" => "Gérer les champs",
"Send me a message" => "Envoyez-moi un message",
"Assign Group" => "Mettre dans un groupe",
"Change user preferences" => "Changer les préférences utilisateur",
"Homepage" => "Page d'accueil",
"Users HomePage" => "Page d'accueil des utilisateurs",
"Personal Wiki Page" => "Page Wiki personnelle",
"Create page" => "Créer une page",
"The user requested friendship with you" => "Cet utilisateur a demandé une mise en relation avec vous",
"Accept friendship from this user" => "Accepter la mise en relation de cet utilisateur",
"Refuse friendship from this user" => "Refuser la mise en relation de cet utilisateur",
"Currently waiting for user approval" => "En attente d'approbation",
"Cancel friendship request towards this user" => "Annuler la demande de mise en relation envers cet utilisateur",
"Request friendship from this user" => "Proposer de devenir ami avec cet utilisateur",
"Forum comments" => "Commentaires de forum",
"Toggle" => "Afficher/cacher",
"Toggle options" => "Afficher/cacher les sous menus",
"Personal Information" => "Informations personnelles",
"Male" => "Homme",
"Female" => "Femme",
"Use Google Map locator" => "Utiliser le localisateur de carte google",
"View extra information" => "Voir les informations supplémentaires",
"Is email public? (uses scrambling to prevent spam)" => "Brouiller l'adresse électronique pour éviter le spam",
"Unavailable - please set your e-mail below" => "Indisponible - donnez votre adresse électronique ci-dessous SVP",
"Does your mail reader need a special charset" => "Votre lecteur de messages a-t-il besoin d'un encodage des caractères particulier",
"Can you read more languages?" => "Vous pouvez lire plus de langues?",
"Select language..." => "Choisir une langue...",
"Display info tooltip on mouseover for every user who allows his/her information to be public" => "Lors du survol de la souris, afficher les informations utilisateurs pour celles qui sont définies comme public",
"Notify sender when reading his mail" => "Marque le message dans les messages envoyés de l'auteur quand son message est lu",
"My level" => "Mon niveau",
"Account Information" => "Informations sur le compte",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Laisser les champs \"Nouveau mot de passe\" et \"Confirmer le nouveau mot de passe\" vides pour garder le mot de passe courant",
"Change administrative info" => "Changer les informations sur le compte",
"New task" => "Nouvelle tâche",
"Task list" => "Liste des tâches",
"Admin mode off" => "Mode admin off",
"Admin mode on" => "Mode admin on",
"Task help" => "Aide (Tâches)",
"Empty Trash" => "Vider la corbeille",
"Received task" => "Tâches reçues",
"You received this task, please read and execute it" => "Vous avez reçu cette tâche. SVP, lisez la et faites la",
"Send task" => "Envoyer une tâche",
"You send this task to a other user" => "Vous envoyez cette tâche à un autre utilisateur",
"Shared task" => "Tâche partagée",
"This task is public to a special group" => "Cette tâche est commune pour un groupe défini",
"Accepted by Task User and Creator" => "Accepté par l'utilisateur et le créateur de la tâche",
"Accepted User and Creator" => "Accepté par l'utilisateur et le créateur",
"Task is accepted by user and creator" => "Tâche acceptée par l'utilisateur et créateur",
"Not Accepted by One User" => "Non accepté par un utilisateur",
"Not Accepted User" => "Non accepté par utilisateur",
"Task is rejected by one user" => "Tâche refusée par un utilisateur",
"Waiting for Me" => "En attente de mon acceptation",
"Task is not accepted by you, read the task and accept or reject it" => "Vous n'avez pas accepté cette tâche pour l'instant, lisez son contenu et acceptez-la ou refusez-la",
"Waiting for Other User" => "En attente d'autres utilisateurs",
"Task is not accepted/rejected by other user" => "Cette tâche est en attente de refus/acceptation par d'autres utilisateurs",
"Admin Mode" => "Mode administration",
"Edit task" => "Modifier une tâche",
"NOT accept" => "NON accepté",
"Remove from Trash" => "Retirer de la corbeille",
"Move into Trash" => "Mettre dans la corbeille",
"Task saved" => "Tâche sauvegardée",
"Edit Task" => "Modifier une tâche",
"View Task" => "Afficher une tâche",
"Open a new task" => "Ouvrir une nouvelle tâche",
"Task user" => "Utilisateur de la tâche",
"Only the creator can delete this task" => "Seul son créateur peut effacer cette tâche",
"Use start date and time" => "Utiliser date et temps de départ",
"Use end date and time" => "Utiliser date et temps de fin",
"Open / In Process" => "Ouvert / en cours",
"Waiting / Not Started" => "En attente / non démarrée",
"Percentage completed" => "Pourcentage accompli",
"Shared for Group" => "Partagé par le groupe",
"Accepted by User" => "Accepté par l'utilisateur",
"No / Rejected" => "Non / refusé",
"Accepted by Creator" => "Accepté par le créateur",
"This message will be send to users if you are makeing changes of assigned tasks" => "Ce message va être envoyé aux utilisateurs si vous faites des changements aux tâches attribuées",
"Send message with changes" => "Envoyer un message avec les changements",
"Modified by" => "Modifié par",
"Marked as deleted" => "Marqué comme supprimé",
"Inform task user by email" => "Informer l'utilisateur de la tâche par email",
"You can only view this task" => "Vous ne pouvez voir que cette tâche",
"Completed" => "Fini",
"%m/%d/%Y [%H:%M]" => "%d/%m/%Y [%H:%M]",
"No tasks entered" => "Aucune tâche entrée",
"Select One" => "Choisir parmi",
"Undo Trash" => "Retirer de la corbeille",
"Received" => "Reçu",
"Submitted" => "Soumis",
"Shared" => "Partagé",
"All Shared Tasks" => "Toutes les tâches partagées",
"completed (100%)" => "fini (100%)",
"Monthly" => "Mensuel",
"Add Watch" => "Ajouter une notification",
"Select event type" => "Sélection des types d'évènements",
"All watched events" => "Tous les évènements surveillés",
"A user submits an article" => "Un utilisateur soumet un article",
"A user edited an article" => "Un utilisateur a édité un article",
"A user deleted an article" => "Un utilisateur a supprimé un article",
"A user submits a blog post" => "Nouvel article de blogue",
"A user posts a forum thread" => "Nouveau message dans fil discussion",
"A user posts a forum topic" => "Nouveau sujet forum",
"A user edited a wiki page" => "Page wiki modifiée",
"A user created a wiki page in a language" => "Un utilisateur a créé une page wiki dans une langue",
"A user edits an article" => "Un utilisateur a édité un article",
"A user deletes an article" => "Un utilisateur a supprimé un article",
"up to" => "sur",
"no limit for admin" => "aucune limite pour l'administrateur",
"May need to refresh twice to see changes" => "Vous devrez peut-être réactualiser 2 fois pour voir les modifications",
"Add top level bookmarks to menu" => "Ajouter les signets du niveau supérieur au menu utilisateur",
"Add or edit an item" => "Ajouter/modifier un item",
"New Window" => "Nouvelle fenêtre (n)",
"replace window" => "remplacer la fenêtre (w)",
"User_versions_for" => "Versions pour",
"This page is being edited by" => "Cette page est en train d'être modifiée par",
"Proceed at your own peril" => "Continuez à vos propres risques",
"Insert Row" => "Ajouter une ligne",
"Insert Column" => "Ajouter une colonne",
"Remove Row" => "Supprimer une ligne",
"Remove Column" => "Supprimer une colonne",
"Merge Cells" => "Fusionner des cellules",
"Restore Cells" => "Restaurer les cellules",
"Copy Calculation" => "Copier la formule",
"Format Cell" => "Formater une cellule",
"Add an article" => "Ajouter un article",
"Banner stats" => "Statistiques de la bannière",
"Create new banner" => "Créer une nouvelle bannière",
"Banner Information" => "Information sur la bannière",
"Click ratio" => "Proportion de clics",
"Hours" => "Heures",
"Weekdays" => "Jours de semaines",
"mon" => "lun",
"tue" => "mar",
"wed" => "mer",
"thu" => "jeu",
"fri" => "ven",
"sat" => "sam",
"sun" => "dim",
"Banner raw data" => "Données brutes de la bannière",
"Cached" => "Dans l'antémémoire",
"This is a cached version of the page." => "Cette version de la page est dans l'antémémoire.",
"Click here to view the Google cache of the page instead." => "Cliquer ici pour voir à la place le cache Google de la page.",
"There are no questions in this FAQ." => "Il n'y a pas de questions dans cette galerie.",
"Answers" => "Réponses",
"Add Suggestion" => "Ajouter une suggestion",
"Forum List" => "Liste des forums",
"Edit Forum" => "Modifier ce forum",
"Manage Message Queue" => "Gérer la file d'attente de messages",
"Manage Reported Messages" => "Gérer les messages signalés",
"Monitor Topics of this Forum" => "Surveiller les fils de discussions de ce forum",
"Stop Monitoring Topics of this Forum" => "Arrêter de surveiller les fils de discussion de ce forum",
"Monitor Topics and Threads of this Forum" => "Surveiller les fils de discussions et les articles de ce forum",
"Stop Monitoring Topics and Threads of this Forum" => "Arrêter de surveiller les fils de discussions et les articles de ce forum",
"Editing" => "Édition",
"Summary" => "Résumé",
"Watch for replies" => "Surveiller les réponses",
"Send me an e-mail when someone replies to my topic" => "M'envoyer un courriel lorsqu'une modification est faite à mon sujet",
"Don't send me any e-mails" => "Ne pas m'envoyer de courriels",
"Editing posts" => "Edition des articles",
"for links" => "pour les liens",
"HTML tags are not allowed inside posts" => "Les balises HTML sont interdites dans les messages",
"Moderator Actions" => "Actions du modérateur",
"Move Selected Topics" => "Déplacer les sujets sélectionnés",
"Unlock Selected Topics" => "Déverrouiller les sujets sélectionnés",
"Lock Selected Topics" => "Verrouiller les sujets sélectionnés",
"Delete Selected Topics" => "Effacer les sujets sélectionnés",
"Merge" => "Fusionner",
"Merge Selected Topics" => "Fusionner les sujets sélectionnés",
"Merge into topic" => "Fusionner dans le sujet",
"Emot" => "émot",
"Announce" => "Annonce",
"Hot" => "Populaire",
"Forum Lock" => "Forum verrouillé",
"Unarchive" => "Pas archivé",
"No topics yet" => "Aucun sujet pour l'instant",
"posts in this forum" => "articles dans ce forum",
"Filter Posts" => "Filtrer les articles",
"Jump to forum" => "Aller au forum",
"Posts Filtering" => "Filtre des articles",
"Last post date" => "Date du dernier article",
"All posts" => "Tous les articles",
"Last hour" => "De la dernière heure",
"Last 24 hours" => "Des dernières 24h",
"Last 48 hours" => "Des dernières 48h",
"Show archived posts" => "Afficher les messages archivés",
"Containing posts by" => "Poster par",
"Me" => "Moi",
"Posts with no replies" => "Articles sans réponses",
"Archived" => "Archivé",
"Topic List" => "Liste des sujets",
"The post has been reported and will be reviewed by a moderator." => "La publication a été signalée à un modérateur et sera révisée.",
"prev topic" => "sujet préc.",
"next topic" => "sujet suivant",
"Print this page only" => "Imprimer cette page seulement",
"Print all pages" => "imprimer toutes les pages",
"Show posts" => "Afficher les articles",
"Monitor" => "Surveiller",
"Stop Monitor" => "Arrêter la surveillance",
"Insert New Item" => "Insérer une nouvelle fiche",
"Edit Fields" => "Modifier les champs",
"Tracker Items" => "Eléments du formulaire",
"Pending" => "En attente",
"View inserted item" => "Voir la fiche insérée",
"Insert new item" => "Ajouter un nouvel item",
"View Item" => "Voir la fiche",
"Filter Tracker Items" => "Filtrer les fiches du formulaire",
"Add a Comment" => "Ajouter un commentaire",
"Edit/Delete" => "Modifier/Supprimer",
"Items list" => "Liste de fiches",
"Special Operations" => "Opération spéciales",
"close" => "fermer",
"Add a new" => "Ajouter un nouveau",
"Edit this" => "Editer ce",
" mail account" => " compte de messagerie",
"Group (shared mail inbox) or private" => "Boite aux lettres partagé ou privée",
"Auto-refresh page time" => "Temps du rafraichissement automatique",
"Group e-mail accounts" => "Boite aux lettres partagée",
"Show All" => "Afficher tout",
"Show Unread" => "Afficher les non-lus",
"Show Flagged" => "Afficher les Show Flagged",
"Refresh now" => "Actualiser",
"unFlagged" => "Pas de drapeau",
"Clip" => "clip",
"Back To Mailbox" => "retourner à la boîte à lettre",
"Full Headers" => "en-têtes complets",
"Normal Headers" => "en-têtes normaux",
"Reply To All" => "répondre à tous",
"Forward" => "transférer",
"Select from address book" => "sélectionner du carnet d'adresses",
"Use HTML mail" => "Utiliser HTML pour le mail",
"The following addresses are not in your address book" => "Les adresses suivantes ne sont pas dans votre carnet d'adresses",
"Add Contacts" => "Ajouter des contacts",
"Attachment 1" => "Fichier joint 1",
"Attachment 2" => "Fichier joint 2",
"Attachment 3" => "Fichier joint 3",
"Address book" => "Carnet d'adresses",
"page id" => "id page",
"3d browser" => "navigateur 3d",
"Jump to Content" => "Aller au contenu",
"Fullscreen" => "Plein écran",
"Cancel Fullscreen" => "Annuler plein écran",
"Show/Hide Left Column" => "Voir/Cacher menus de gauche",
"Show/Hide Right Column" => "Voir/Cacher menus de droite",
"Remove Image" => "Supprimer l'image",
"Word Limit Exceeded" => "Nombre maximum de mots atteint",
"Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom où x est la longitude, et y la latitude. Zoom est compris entre 0(vue de la terre) à 19. Vous pouvez utiliser <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
"You have ever subscribed" => "Vous êtes déjà inscrit",
"You have not yet subscribed" => "Vous n'êtes pas inscrit",
"friends" => "amis",
"Unsubscribe" => "Se désabonner",
"Google Maps is not enabled." => "Google Maps n'est pas activée.",
"The main text of this page is available in the following languages" => "Le texte principal de cette page disponible dans les langues suivantes",
"Missing or incorrect trackerId parameter for the plugin." => "Paramètre incorrect ou manquant pour le plugin.",
"Subscribe to a group" => "S'inscrire dans un groupe",
"Toggle display" => "Afficher/cacher l'affichage",
"as Creator &amp; Last Editor" => "créateur &amp; dernier éditeur",
"no (disabled)" => "non (désactivé)",
"Save the page as a partial translation." => "Enregistrer la page comme une traduction partielle.",
"Partial Translation" => "Traduction partielle",
"Save the page as a completed translation." => "Enregistrer la page comme une traduction complète.",
"Complete Translation" => "Traduction complète",
"Save the page, but do not send notifications and do not count it as new content to be translated." => "Enregistrer la page sans envoi de notification par courrier. Ne pas enregistrer le contenu comme à être traduit",
"Save Minor Edit" => "Enreg. modif. mineure",
"Save the page as a draft." => "Enregistrer la page comme brouillon.",
"Save Draft" => "Enregistrer brouillon",
"Permission denied you cannot view the Tiki calendar" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas voir le calendrier Tiki",
"Help on Configuration Sections" => "Aide sur les différentes sections de configuration",
"Enable/disable Tiki features here, but configure them elsewhere" => "Activez/désactivez les fonctionnalités Tiki ici, mais configurez dans leur page d'administration associée",
"General preferences and settings" => "Préférences et configurations générales",
"User registration, login and authentication" => "Inscription utilisateur, connexion et authentification",
"Wiki settings" => "Configuration Wiki",
"Wiki Attachments" => "Fichiers joints Wiki",
"Article/CMS settings" => "Configuration des articles/CMS",
"Poll comments settings" => "Configuration des commentaires de sondages",
"Configuration options for all blogs on your site" => "Options de configuration pour tous les blogues de votre site",
"Forums settings" => "Configuration des forums",
"FAQ comments settings" => "Configuration des commentaires de FAQ",
"Trackers settings" => "Configuration des formulaires",
"Directory settings" => "Configuration du répertoire des liens",
"Maps configuration" => "Configuration des cartes",
"Meta Tags settings" => "Configuration des Méta balises",
"Search settings" => "Configuration de la recherche",
"Score settings" => "Configurations des scores",
"Community settings" => "Configuration de la communauté",
"Calendar settings" => "Configuration des calendriers",
"Intertiki settings" => "Configuration Intertiki",
"Freetags settings" => "Configuration de la folksonomie(freetags)",
"Customize look and feel of your Tiki" => "Modifier l'aspect et la convivialité de votre Tikiwiki",
"Text area" => "Zone de texte",
"Configure Site Ads and Banners" => "Configurer les bannières et publicité du site",
"Help on \$admintitle Config" => "Aide sur la configuration de&nbsp;: \$admintitle",
"Must specify actionId" => "actionId doit être spécifié",
"Users Contributions: Addition" => "Contributions utilisateur: Ajouts",
"%s Contributions: Addition" => "%s Contributions: Ajouts",
"Users Contributions: Suppression" => "Contributions utilisateur: Suppressions",
"%s Contributions: Suppression" => "%s Contributions: Suppressions",
"Total Contributions Addition per Day" => "Total des contributions Ajouts par jour",
"Total Contributions Addition per Week" => "Total des contributions Ajouts par semaine",
"Total Contributions Suppression per Day" => "Total des contributions Suppressions par jour",
"Total Contributions Suppression per Week" => "Total des contributions Suppressions par semaine",
"Total Contributions: Addition" => "Total des contributions: Ajouts",
"Total Contributions: Suppression" => "Total des contributions: Suppressions",
"Groups Contributions: Addition" => "Contributions des groupes: Ajouts",
"Groups Contributions: Suppression" => "Contributions des groupes: Suppressions",
"white" => "blanc",
"gray" => "gris",
"silver" => "argenté",
"ivory" => "ivoire",
"whitesmoke" => "blanc fumée",
"darkgrey" => "gris fonçé",
"You can not create a category with a name already existing at this level" => "Vous ne pouvez pas créer une catégorie avec un nom existant déjà à ce niveau",
"Category can`t be parent of itself" => "Une catégorie ne peut pas être parente d'elle-même",
"Upload failed" => "Échec de l'envoi",
"All posted" => "Tout approuver automatiquement",
"Queue anonymous posts" => "Approuver les non-anonymes automatiquement",
"Queue all posts" => "Ne rien approuver automatiquement",
"No attachments" => "Aucun fichier joint",
"Everybody can attach" => "Tout le monde peut joindre un fichier",
"Only users with attach permission" => "Seuls les utilisateurs ayant droit peuvent joindre un fichier",
"Moderators and admin can attach" => "Modérateur et administrateur peuvent joindre un fichier",
"Replies (desc)" => "Réponses (desc)",
"Reads (desc)" => "Lectures (desc)",
"You have to provide a hotword and a URL" => "Vous devez fournir un mot/lien automatique ou une adresse Web",
"Owner" => "Créateur",
"moved %d images, %d errors occured." => "%d images déplacées, %d erreurs trouvées.",
"a timeout occured. Hit the reload button to move the rest" => "un timeout est arrivé. Pressez le bouton recherger pour déplacer le reste",
"Not detected." => "Pas trouvé.",
"Your admin password has been changed" => "Votre mot de passe administrateur a été changé",
"You cannot have a blank password" => "Vous ne pouvez pas avoir un mot de passe vide",
"All Fields except gdaltindex must be filled" => "Tous les champs sauf gdaltindex doivent être remplis",
"Path to mapfiles is invalid" => "Le chemin d'accès au fichier de carte est invalide",
"No valid gdaltindex executable" => "Aucun exécutable gdaltindex valide",
"You cannot mix old and new trackers" => "Vous ne pouvez pas mélanger les anciens et les nouveaux formulaires",
"Tag already exists" => "Le marqueur existe déjà",
"Tag not found" => "Aucun marqueur trouvé",
"Repository name can't be an empty" => "Un nom de répertoire ne peut pas être vide",
"Requested action is not supported on repository" => "L'action demandée n'est pas supportée sur le répertoire",
"No repository" => "Aucun répertoire indiqué",
"Search is mandatory field" => "Le champ Recherche est obligatoire",
"File not found " => "Fichier non trouvé",
"Requested action in not supported on repository" => "L'action demandée n'est pas supportée dans ce répertoire",
"Non-existent link" => "Lien inexistant",
"Mail-in account %s incorrect" => "Compte mail-in %s incorrect",
"Mail-in account %s saved" => "Compte mail-in %s sauvegardé",
"Frequency should be a positive integer!" => "La fréquence doit être un entier positif!",
"Mail-in accounts set to be checked every %s minutes" => "Les comptes mail-in sont synchronisés toutes les %s minutes",
"Automatic Mail-in accounts checking disabled" => "Les comptes mail-in ne sont pas synchronisés automatiquement",
"No menu indicated" => "Aucun menu indiqué",
"Cannot create or update module: You need to specify a name to the module" => "Impossible de créer ou de mettre à jour le module&nbsp;: vous devez spécifier le nom du module",
"Cannot create or update module: You cannot leave the data field empty" => "Impossible de créer ou de mettre à jour le module&nbsp;: vous ne pouvez pas laisser le champ de données vide",
"No newsletter indicated" => "Aucune lettre d'informations indiquée",
"Error opening uploaded file" => "Erreur lors de l'ouverture du fichier envoyé",
"A user registers" => "Un utilisateur s'inscrit",
"Any wiki page is changed" => "Une page Wiki est changée",
"Any wiki page is changed, even minor changes" => "Toute page Wiki est marquée changée, même si les modifications sont mineures",
"A comment in a wiki page is posted or edited" => "Un commentaire dans une page Wiki a été envoyé ou modifié",
"PHP error" => "Erreur PHP",
"You need to provide a username or an email" => "Vous devez donner un nom d'utilisateur ou une adresse électronique",
"No poll indicated" => "Aucun sondage indiqué",
"unsafe" => "dangereux",
"register_globals should be off by default. See the php manual for details." => "register_globals doit être off par défaut. Voir le manuel php pour les détails.",
"safe" => "sans danger",
"risky" => "risqué",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid doit être off par défaut. Voir le manuel php pour les détails.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir est probablement dans votre répertoire Tikiwiki. C'est un risque car quelqu'un peut envoyer un fichier dans ce répertoire puis y accéder par le Web",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "ne peut pas vérifier que upload_tmp_dir est accessible par le web. Vous devez contrôler la configuration de votre serveur Web",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "mettre l'option xbithack est dangereux. Selon la façon dont votre serveur Web gère les fichiers et votre configuration Tikiwiki, il est possible d'attaquer en envoyant des scripts dans les galeries de fichiers et de les exécuter",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen peut être utilisé pour envoyer des données ou scripts sur le serveur. Si vous n'utilisez pas les blogues, vous pouvez le désactiver.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Le chemin de sauvegarde des fichiers des galeries de fichiers doit être hors du répertoire Tikiwiki",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Le chemin de sauvegarde des fichiers des galeries d'images doit être hors du répertoire Tikiwiki",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "La fonctionnalité \"Modifier les gabarits\" est activée. Ne laisser personne de peu fiable utiliser cette fonctionnalité. Il est facile d'injecter du code php.",
"Path disclosure" => "Faille Path disclosure",
"Path disclosure through error message" => "Faille Path disclosure au travers d'un message d'erreur",
"SQL injection" => "Injection SQL",
"SQL injection by authenticated user" => "Injection SQL par un utilisateur authentifié",
"SQL injection by authenticated user with special privileges" => "Injection SQL par un utilisateur authentifié avec des privilèges spéciaux",
"SQL injection without authentication" => "Injection SQL sans authentification",
"PHP command injection" => "Injection de commande PHP",
"PHP command injection by authenticated user" => "Injection de commande PHP par un utilisateur authentifié",
"PHP command injection by authenticated user with special privileges" => "Injection de commande PHPpar un utilisateur authentifié avec des privilèges spéciaux",
"PHP command injection without authentication" => "Injection de commande PHP sans authentification",
"File upload" => "Envoi de fichier",
"File is not readable. Unable to check." => "Fichier sans droit de lecture. Impossible de vérifier.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Ceci n'est pas un fichier Tikiwiki. Contrôlez si ce fichier a été envoyé par un tiers et si il est dangereux.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "C'est un fichier modifié. Impossible de vérifier la version. Vérifiez si c'est dangereux",
"This file is from another Tikiwiki version: " => "Ce fichier est d'une autre version de Tikiwiki",
"You have to provide a word" => "Vous devez indiquer un mot",
"Permission denied. You cannot view this page." => "Droit d'accès refusé&nbsp;: vous ne pouvez afficher cette page",
"Permission denied you cannot edit this page" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas modifier cette page",
"You must specify a page name, it will be created if it doesn't exist." => "Vous devez donner un nom de page, la page sera créée si elle n'existe pas.",
"page not added (Exists)" => "page non ajoutée (Existe)",
"No survey indicated" => "Aucune enquête indiquée",
"You don't have permission to use this feature" => "Vous n'avez pas le droit d'utiliser cette fonctionnalité",
"No Errors detected" => "Aucune erreur détectée",
"No tracker indicated" => "Aucun formulaire indiqué",
"Tracker does not allow attachments" => "Le formulaire n'autorise pas les pièces jointes",
"Group already exists" => "Ce groupe existe déjà",
"Remove group: " => "Supprimer le groupe&nbsp;: ",
"Remove permission: %s on %s" => "Retirer la permission: %s suron %s",
"User doesn't exist" => "Cet utilisateur n'existe pas",
"The description is mandatory as it is used as mail subject" => "La description est obligatoire car elle est utilisé comme sujet dans les emails",
"Invalid or unknown email" => "Adresse électronique incorrecte ou inconnue",
"No records were found. Check the file please!" => "Pas d'entrée trouvée. Vérifier le fichier SVP!",
"User login or email is required" => "Identifiant ou email requis",
"User does not exist on master" => "L'utilisateur n'existe pas sur le maitre",
"User login is required" => "Nom utilisateur obligatoire",
"Password is required" => "Mot de passe obligatoire",
"Email is required" => "Adresse électronique obligatoire",
"User is duplicated" => "L'utilisateur est dupliqué",
"Created account %s <%s>" => "Compte créé %s <%s>",
"Assigned %s in group %s" => "Mettre %s dans le groupe %s",
"User %s already exists" => "L'utilisateur %s existe déjà",
"User login contains invalid characters" => "Le nom utilisateur contient des caractères invalides",
"New %s created with %s %s." => "Un nouveau %s a été créé avec le %s %s.",
"Impossible to create new %s with %s %s." => "Impossible de créer un nouveau %s avec %s %s.",
"%s %s successfully deleted." => "%s %s supprimé avec succès.",
"Deleted account %s" => "Supprimer le compte %s",
"%s %s removed from %s %s." => "%s %s supprimé de %s %s.",
"Login contains invalid characters" => "Le nom utilisateur contient des caractères invalides",
"%s changed from %s to %s" => "%s changé de %s en %s",
"Impossible to change %s from %s to %s" => "Impossible de changer %s de %s à %s",
"%s modified successfully." => "%s modifié avec succès.",
"password" => "mot de passe",
"%s modification failed." => "la modification de %s modification a échoué.",
"approved by " => "approuvé par ",
"Permission denied you cannot approve staging pages" => "Accès refusé, vous n'avez pas le droit d'approuver des pages",
"rss feed disabled" => "alimentation rss désactivée",
"Tiki RSS feed for articles" => "Canal de syndication RSS Tiki pour les articles",
"Last articles." => "Derniers articles.",
"Unassign perm %s from group %s" => "Désattribuerle droit %s au groupe %s",
"Unknown group" => "Groupe inconnu",
"Group doesn't exist" => "Ce groupe n'existe pas",
"You have to indicate a group" => "Vous devez indiquer un groupe",
"This group is invalid" => "Ce groupe est invalide",
"Permission denied you cannot view backlinks for this page" => "Droit d'accès refusé : vous ne pouvez pas afficher les pages pointant cette page",
"The page cannot be found" => "Cette page n'a pu être trouvée",
"Image Galleries Admin Panel" => "Panneau d'administration des galeries d'images",
"Could not read image %s." => "Ne peut pas lire l'image %s.",
"Image %s upload failed." => "Echec de l'envoi de l'image %s.",
"Image %s uploaded successfully." => "Image %s envoyée avec succès.",
"Image %s removed from Batch directory." => "Image %s supprimée du répertoire de téléchargement par lot.",
"Impossible to remove image %s from Batch directory." => "Impossible de supprimer l'image %s du répertoire Batch.",
"Permission denied you cannot use the batch directory loading" => "Droit d'accès refusé: vous ne pouvez pas utiliser le répertoire de téléchargement par lot",
"Incorrect directory chosen for batch upload of images." => "Répertoire invalide choisi pour l'envoi des images par lot.",
"Please setup that dir on " => "SVP, positionner ce répertoire sur ",
"Please contact the website administrator." => "SVP, contacter l'administrateur du site.",
"Invalid directory name" => "Nom de répertoire invalide",
"File Galleries Admin Panel" => "Panneau d'administration des galeries de fichiers",
"Could not read file %s." => "Impossible de lire le fichier %s.",
"Could not write to file %s." => "Impossible d'écrire le fichier %s.",
"File %s upload failed." => "L'envoi du fichier %s a échoué.",
"Upload was successful" => "Envoi réussi",
"File %s removed from Batch directory." => "Fichier %s supprimé du répertoire de téléchargement par lot.",
"Impossible to remove file %s from Batch directory." => "Impossible de détruire le fichier %s du répertoire de téléchargement par lot.",
"Incorrect directory chosen for batch upload of files." => "Répertoire invalide choisi pour le téléchargement par lot de fichiers.",
"It isn't possible to post in any blog. You may need to create a blog first." => "Vous ne pouvez publier d'articles dans aucun blogue&nbsp;: peut-être devez-vous en créer un",
"Permission denied you cannot post" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas publier d'articles",
"Permission denied you cannot edit this post" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier cet article",
"Top visited blogs" => "Blogues les plus visités",
"Last posts" => "Derniers articles de blogue",
"Top active blogs" => "Blogues les plus actifs",
"Tiki RSS feed for blog: " => "Canal de syndication RSS Tiki pour le blogue&nbsp;: ",
"No blogId specified" => "Aucun Id de blogue spécifié",
"Tiki RSS feed for weblogs" => "Canal de syndication RSS Tiki pour les blogues",
"Last posts to weblogs." => "Derniers articles des blogues.",
"Nothing tagged yet" => "Aucun tag pour le moment",
"You must clear your browser cache." => "Il faut vider le cache de votre navigateur.",
"Permission denied you cannot access this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas accéder à cette galerie",
"No gallery indicated" => "Aucune galerie indiquée",
"Permission denied you can not view this section" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas afficher cette section",
"Permission denied you cannot remove images from this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas supprimer d'images de cette galerie",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas reconstruire les vignettes dans cette galerie",
"Permission denied you cannot rotate images in this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas pivoter les images dans cette galerie",
"No image indicated" => "Aucune image indiquée",
"Permission denied you cannot move images from this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas déplacer d'images de cette galerie",
"Permission denied you cannot view the calendar" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas voir le calendrier",
"You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "Vous devez <a href=\"tiki-admin_calendars.php\">créer un calendrier</a>",
"event without name" => "évènement sans nom",
"Permission denied you can not view this page" => "Droit d'accès refusé. Vous ne pouvez pas voir cette page.",
"Access Denied" => "Accès refusé",
"%H:%M %Z" => "%Hh%M",
"Tiki RSS feed for calendars" => "Canaux de syndication RSS Tiki pour les calendriers",
"Upcoming events." => "Évènements à venir.",
"Invalid username or activation code. Maybe this code has already been used." => "Nom utilisateur ou code d'activation invalide. Peut être ce code est déjà utilisé.",
"You can not use the same password again" => "Vous ne pouvez pas réutiliser le même mot de passe à nouveau",
"Invalid old password or unknown user" => "Ancien mot de passe invalide ou utilisateur inconnu",
"Top authors" => "Auteurs les plus actifs",
"Problem. Try to log in again to receive new confirmation instructions." => "Problème. Essayez de vour connecter encore pour recevoir les instructions de confirmation.",
"Message sent to" => "Message envoyé à",
"You need to change chmod 'whelp' manually to 777" => "Vous devez faire manuellement un chmod 777 sur 'whelp'",
"This feature has been disabled" => "Cette fonctionnalité a été désactivée",
"Tiki RSS feed for directory sites" => "Canal de syndication RSS Tiki pour les sites des répertoires",
"Last sites." => "Derniers sites.",
"Must enter a name to add a site. " => "Vous devez donner un nom pour ajouter un site. ",
"Must enter a url to add a site. " => "Vous devez entrer une adresse Web pour ajouter un site. ",
"URL already added to the directory. Duplicate site? " => "Adresse Web déjà présente dans le répertoire. Enregistrer un doublon ? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "L'adresse Web ne peut pas être accédée&nbsp;: mauvaise adresse Web ou site déconnecté. L'adresse Web ne peut pas être ajoutée au répertoire. ",
"Must select a category. " => "Vous devez choisir une catégorie. ",
"Must enter a name to add a site" => "Vous devez donner un nom pour ajouter un site",
"Must enter a url to add a site" => "Vous devez entrer une adresse Web pour ajouter un site",
"URL already added to the directory. Duplicate site?" => "Adresse Web déjà présente dans le répertoire. Enregistrer un doublon ?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "L'URL ne peut pas être accédé (mauvaise URL ou site offline)&nbsp;: l'URL ne peut pas être ajoutée au répertoire",
"Must select a category" => "Vous devez choisir une catégorie",
"No site indicated" => "Aucun site indiqué",
"No parent specified" => "aucun parent spécifié",
"Error : The file %s doesn't exist." => "Erreur&nbsp;: Le fichier %s n'existe pas.",
"Article not found" => "Article introuvable",
"Permission denied you cannot edit this article" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier cet article",
"The language can't be changed as its set of translations has already this language" => "La langue ne peut pas être changée parce qu'il y a déjà cette langue dans le jeu de traductions",
"You do not have permissions to edit banners" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier les bannières",
"Banner not found" => "Page d'ouverture introuvable",
"You do not have permission to edit this banner" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier cette bannière",
"Permission denied you cannot create or edit blogs" => "Droit d'accès refusé&nbsp;: vous ne pouvez créer/modifier de blogues",
"Permission denied you cannot edit this blog" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier ce blogue",
"You do not have permission to write the style sheet" => "Vous n'avez pas la permission d'écrire la feuille de style",
"Invalid request to edit an image" => "Demande de modification d'image invalide",
"Permission denied you cannot edit images" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier les images",
"Permission denied you can edit images but not in this gallery" => "Droit d'accès refusé&nbsp;: vous pouvez modifier des images mais pas dans cette galerie",
"Failed to edit the image" => "Échec de la modification de l'image",
"Permission denied to use this feature" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas utiliser cette fonctionnalité",
"Shortname must be 2 Characters" => "Un diminutif doit avoir 2 caractères",
"You must provide a longname" => "Vous devez donner un nom long",
"Language created" => "Langue créée",
"No content id indicated" => "Aucun ID de contenu indiqué",
"No question indicated" => "Aucune question indiquée",
"No quiz indicated" => "Aucun QCM indiqué",
"No structure indicated" => "Aucune structure indiquée",
"Invalid structure_id or page_ref_id" => "Structure_id ou page_ref_id invalide",
"Permission denied you cannot send submissions" => "Droit d'accès refusé&nbsp;: vous ne pouvez publier d'articles",
"Permission denied you cannot edit submissions" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier les articles publiés",
"You have to create a topic first" => "Vous devez créer un sujet d'abord",
"You do not have permission to do that" => "Vous n'avez pas les droits d'accès pour faire cela",
"You do not have permission to read the template" => "Droit d'accès refusé&nbsp;: vous ne pouvez lire le gabarit",
"No topic id specified" => "Aucun id de sujet spécifié",
"Invalid topic id specified" => "Id de sujet invalide",
"No object indicated" => "Aucun objet indiqué",
"Translation of this page is incomplete." => "La traduction de cette page n'est pas terminée.",
"No type indicated" => "Aucun type indiqué",
"Not enable for this type of object" => "Non permis pour ce type d'objet",
"Override lock and carry on with edit" => "Outrepasser le verrou et continuer en mode édition",
"Page is currently being edited" => "La page est en cours d'édition",
"page imported" => "page importée",
"created from import" => "créé de l'importation",
"This page is being edited by " => "Cette page est en cours de modification par ",
"Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Veuillez consulter cet utilisateur avant d'éditer la page,\n\t\t\tsinon les modifications seront sauvegardées en deux versions distinctes de l'historique et\n\t\t\tvous devrez fusionner plus tard les différences manuellement. ",
"Can't import remote HTML page" => "On ne peut pas importer une page HTML distante",
"The SandBox is disabled" => "Le bac à sable est désactivé",
"Cannot edit page because it is locked" => "Cette page ne peut être modifiée&nbsp;: elle est verrouillée",
"Page already exists. Go back and choose a different name." => "La page existe déjà. Revenez en arriêre et choisissez un nom différent.",
"No questions group indicated" => "Aucun groupe de questions indiqué",
"Remove archive: " => "Supprimer l'archive&nbsp;: ",
"Remove file gallery: " => "Supprimer la galerie de fichiers&nbsp;: ",
"Permission denied you cannot edit this file" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas modifier ce fichier",
"Permission denied you cannot remove files from this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer de fichiers de cette galerie",
"Top visited file galleries" => "Galeries de fichiers les plus visitées",
"Most downloaded files" => "Fichiers les plus téléchargés",
"Last files" => "Derniers fichiers",
"Tiki RSS feed for file galleries" => "Canal de syndication RSS Tiki pour les galeries de fichiers",
"Last files uploaded to the file galleries." => "Derniers fichiers envoyés dans les galeries de fichiers.",
"No galleryId specified" => "Aucun galleryId spécifié",
"Tiki RSS feed for the file gallery: " => "Canal de syndication RSS Tiki pour la galerie de fichiers&nbsp;: ",
"Form error - no import method selected for some reason." => "Erreur de formulaire - aucune méthode d'import n'a été sélectionnée.",
"Form error - no server-side filename entered for selected import method." => "Erreur de formulaire - aucun fichier situé sur le serveur n'a été saisi pour la méthode d'import sélectionnée.",
"No forum indicated" => "Aucun forum indiqué",
"Last forum topics" => "Derniers sujets de forum",
"Top topics" => "Sujets les plus populaires",
"Forum posts" => "Articles de forums",
"No forumId specified" => "Aucun ID de forum indiqué",
"Tiki RSS feed for forum: " => "Canal de syndication RSS Tiki pour le forum&nbsp;: ",
"Tiki RSS feed for forums" => "Canal de syndication RSS Tiki pour les forums",
"Last topics in forums." => "Derniers sujets des forums.",
"Not supported yet." => "Pas encore supporté.",
"Accepted friendship request from %s" => "Demande d'amitié acceptée de %s",
"Refused friendship request from %s" => "Demande d'amitié refusée de %s",
"Canceled friendship request with %s" => "Annulé la mise en relation avec %s",
"Broke friendship with %s" => "Casser l'amitié avec %s",
"I have broken our friendship!" => "J'ai cassé notre amitié!",
"You must be logged in to use this feature" => "Vous devez vous inscrire pour utiliser cette fonctionnalité",
"Friendship request sent to %s" => "Demande d'amitié envoyé à %s",
"You're already friend of %s" => "Vous êtes déjà l'ami de %s",
"I have accepted your friendship request!" => "J'ai accepté votre demande d'amitié",
"I have refused your friendship request." => "J'ai refusé votre demande d'amitié.",
"first uploaded image" => "première image envoyée",
"last uploaded image" => "dernière image envoyée",
"first image" => "première image",
"last image" => "dernière image",
"random image" => "image choisie au hasard",
"Permission denied you cannot create galleries and so you cant edit them" => "Droit d'accès refusé&nbsp;: vous ne pouvez ni créer ni modifier de galeries",
"Permission denied you cannot edit this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez modifier cette galerie",
"Permission denied you cannot remove this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer cette galerie",
"Permission denied you cannot make the map of this gallery" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas la carte de cette galerie",
"Top images" => "Images les plus populaires",
"Last images" => "Dernières images",
"Back to preferences" => "Revenir aux préférences",
"Back to item" => "Retour à l'élément",
"No valid renderer found. GD or PDFLib required." => "Aucun moteur de rendu trouvé. GD ou PDFLib nécessaire.",
"No sheet specified." => "Aucun feuillet spécifié.",
"You must select a renderer." => "Vous devez choisir un moteur de rendu",
"Invalid Series for current graphic." => "Séries invalides pour le graphique courant.",
"Tiki RSS feed for image galleries" => "Canal de syndication RSS Tiki pour les galeries d'image",
"Last images uploaded to the image galleries." => "Dernières images envoyées dans les galeries d'images.",
"Tiki RSS feed for the image gallery: " => "Canal de syndication RSS Tiki pour la galerie d'images&nbsp;: ",
"Only the administrator can upload language files." => "Seul l'administrateur peu tgélécharger des fichiers de langues.",
"overwriting old page" => "écrasement de la vieille page",
"updated from structured text import" => "modifié d'un import de Texte Structuré",
"page created" => "page crée",
"created from structured text import" => "créé d'un import de Texte Structuré",
"Operations executed successfully" => "Opérations réussie",
"No name indicated for wiki page" => "Aucun nom indiqué pour la page Wiki",
"No repository given" => "Aucun répertoire indiqué",
"Error writing in the databse: \$query" => "Erreur à l'écriture dans la base de données&nbsp;: \$query",
"Permission denied. You cannot view pages like this page" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas afficher les pages similaires à celle-ci",
"Permission denied you cannot remove articles" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer d'articles",
"Permission denied you cannot remove banners" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer de bannière",
"Permission denied you cannot remove this blog" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer ce blogue",
"Delete comments" => "Supprimer les commantaires",
"Approved Status" => "Statut d'approbation",
"Queued" => "Mis en attente",
"Non-existent gallery" => "Galerie inexistante",
"The file is already locked by %s" => "Le fichier est déjà verrouillé par %s",
"Remove file: " => "Supprimer le fichier&nbsp;: ",
"Permission denied you can upload files but not to this file gallery" => "Droit d'accès refusé&nbsp;: vous pouvez envoyer des fichiers mais pas dans cette galerie",
"Please re-upload your file" => "SVP, réenvoyer votre fichier",
"Could not upload the file" => "Ne peut pas envoyer le fichier",
"Could not find the file requested" => "Fichier demandé non trouvé",
"Permission denied you can edit this file" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas modifier ce fichier",
"Upload was not successful. Duplicate file content" => "L'envoi n'a pas réussi. Un fichier de même contenu existe déjà",
"File update was successful" => "Succès de la mise à jour du fichier",
"Permission denied you can't upload files so you can't edit them" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas envoyer de fichier et ainsi vous ne pouvez pas le modifier",
"This gallery does not exist" => "Cette galerie n'existe pas",
"You cannot admin blogs" => "Vous ne pouvez pas administrer les blogues",
"Permission denied you cannot remove submissions" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer d'articles publiés",
"Permission denied you cannot approve submissions" => "Droit d'accès refusé&nbsp;: vous ne pouvez approuver les soumissions",
"You have to enable cookies to be able to login to this site" => "Vous devez authoriser les cookies si vous voulez vous connecter sur ce site",
"Unable to contact remote server." => "Incapable de contacter le serveur distant.",
"XMLRPC Error: " => "Erreur XMLRPC: ",
"Unable to create login" => "Incapable de créer un utilisateur",
"More than %d unsuccessful login attempts have been made." => "Plus de %d connexions non réussies ont été faites.",
"An email has been sent to you with the instructions to follow." => "Un courrier électronique vous a été envoyé avec les instructions à suivre.",
"Your default nickname is already in use. A new one has to be selected." => "Votre pseudonyme est déjà utilisé. Veuillez en choisir un autre.",
"unknown action" => "action inconnue",
"Authentication method is not OpenID" => "La méthode d'authentification n'est pas OpenID",
"Invalid password" => "Mot de passe invalide",
"Account disabled" => "Compte désactivé",
"You must use the right case for your user name" => "Vous devez respecter majuscules et minuscules pour votre nom utilisateur",
"Tiki mail-in auto-reply" => "Réponse automatique du mail-in Tiki",
"Sorry, you can't use this feature." => "Désolé, vous ne pouvez pas utiliser cette fonctionnalité.",
"Feature Ajax Disabled. Please ask your site administrator to enable" => "La fonctionnalité Ajax est désactivé, Merci de demander à l'administrateur du site de l'activer",
"You must first setup MapServer" => "Vous devez d'abord définir le Serveur de carte",
"invalid mapfile name" => "nom de fichier-carte invalide",
"You do not have permissions to view the maps" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas voir les cartes",
"Maps feature is not correctly setup : Maps path is missing." => "La fonctionnalité Cartes n'est pas correctement configurée: Le chemin d'accès Cartes est incorrect",
"mapfile name incorrect" => "nom de fichier-carte incorrect",
"This mapfile already exists" => "Le fichier-carte existe déjà",
"You do not have permission to write to the mapfile" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas écrire le fichier-carte",
"You do not have permission to delete the mapfile" => "Droit d'accès refusé&nbsp;: vous ne pouvez effacer le fichier-carte",
"I could not make a copy" => "Copie impossible",
"You do not have permission to read the mapfile" => "Droit d'accès refusé&nbsp;: vous ne pouvez lire le fichier-carte",
"map edit" => "Edition de la carte",
"You dont have permission to do that" => "Vous n'avez pas les droits pour faire cela",
"Tiki RSS feed for maps" => "Canal de syndication RSS Tiki pour les cartes",
"List of maps available." => "Liste des cartes disponibles.",
"You do not have permissions to view the layers" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas voir les layers",
"You do not have permissions to delete a file" => "Droit d'accès refusé&nbsp;: vous ne pouvez effacer le fichier",
"File not found" => "Fichier non trouvé",
"You do not have permissions to create a directory" => "Droit d'accès refusé&nbsp;: vous ne pouvez créer le répertoire",
"The Directory is not empty" => "Le répertoire est vide",
"You do not have permissions to delete a directory" => "Droit d'accès refusé&nbsp;: vous ne pouvez effacer le répertoire",
"You do not have permissions to create an index file" => "Droit d'accès refusé&nbsp;: vous ne pouvez créer un fichier index",
"Invalid file name" => "Nom de fichier invalide",
"Invalid files to index" => "Fichiers à indexer invalide",
"I do not know where is gdaltindex. Set correctly the Map feature" => "gdaltindex invalide. Positionnez le correctement dans l'administration des cartes",
"I could not create the index file" => "Le fichier d'index ne peut être créé",
"Page \"%0\" does not exist" => "La page \"%0\" n'existe pas",
"Must be logged to use this feature" => "Vous devez être connecté pour utiliser cette fonctionnalité",
"Welcome at Hawiki" => "Bienvenu sur Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Ce site Tikiwiki peut être accéder par de nombreux équipements mobiles, entre autres Téléphone WAP, PDA, i-mode...",
"About" => "A propos",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Vous devez exécuter setup.sh&nbsp;:<br />./setup.sh \$APACHEUSER all<br />Les utilisateurs classiques de Apache sont www-data, apache ou nobody",
"Your PHP installation does not have zlib enabled." => "Votre installation PHP n'a pas l'option zlib activée.",
"You must log in to use this feature" => "Vous devez vous inscrire pour utiliser cette fonctionnalité",
"You do not have permission to view other users data" => "Droit d'accès refusé&nbsp;: vous ne pouvez afficher les données des autres utilisateurs",
"You must be logged in to subscribe to newsletters" => "Vous devez vous connecter pour vous inscrire à une lettre d'informations",
"No note indicated" => "Aucune note indiquée",
"File is too big" => "Fichier trop gros",
"No item indicated" => "Aucune fiche indiquée",
"created from notepad" => "crée du bloc-note",
"Page already exists" => "La page existe déjà",
"Not enough information to display this page" => "Information insuffisante pour afficher cette page",
"Permission denied you cannot assign permissions for this object" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas attribuer des droits d'accès à cet objet",
"Permission denied you cannot browse this page history" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas afficher l'historique de cette page",
"Permission denied you cannot view the source of this page" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas voir le source de cette page",
"No article indicated" => "Aucun article indiqué",
"Article is not published yet" => "Cet article n'a pas encore été publié",
"No post indicated" => "Aucun article indiqué",
"Blog not found" => "Blogue introuvable",
"No pages indicated" => "Aucune page indiquée",
"Pageviews" => "Affichage de page",
"You don't have permission to edit quizzes." => "Vous n'avez pas la permission de modifier les QCMs",
"No result indicated" => "Aucun résultat indiqué",
"You must choose a group" => "Vous devez choisir un groupe",
"This is not a valid mail adress" => "Ce n'est pas une adresse électronique valide",
"The passwords don't match" => "Les mots de passe ne correspondent pas",
"Username cannot contain uppercase letters" => "Le nom d'utilisateur ne peut contenir de majuscules",
"Username must be at least" => "Le nom d'utilisateur doit avoir au moins",
"Username cannot contain more than" => "Le nom d'utilisateur ne peut pas contenir plus de",
"characters" => "caractères",
"Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "SVP, saisissez un %s valide. Pas d'espace, plus de %d caractères et contenant %s",
"Invalid or unknown username" => "Nom utilisateur invalide ou inconnu",
"Unable to send mail. User has not configured email" => "Impossible d'envoyer le courriel. L'utilisateur n'a pas configuré son adresse électronique",
"The mail can't be sent. Contact the administrator" => "Le courriel ne peut pas être envoyé. Contactez l'administrateur",
"An email with a link to reset your password has been sent " => "Un courriel comportant un lien qui permet de réinitialiser votre mot de passe a été envoyé ",
"to the registered email address for" => "à l'adresse électronique inscrite pour",
"last version" => "dernière version",
"Permission denied you cannot remove versions from this page" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas supprimer de versions de cette page",
"Permission denied you cannot rename this page" => "Vous n'avez pas le droit de renommer cette page",
"Cannot rename page because the new name begins with reserved prefix" => "Vous ne pouvez pas renommer la page avec un nom qui commence par un préfixe réservé",
"Cannot rename page maybe new page already exists" => "Ne peut pas renommer la page, peut-être que la page existe déjà",
"Non-existent version" => "Version inexistante",
"Permission denied you cannot rollback this page" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas revenir à cette page",
"Error Message" => "Message d'erreur",
"Tiki RSS Feed Error Message: \$errmsg" => "Message d'erreur du canal de syndication Tiki RSS&nbsp;: \$errmsg",
"No newsletters available." => "Aucune lettre d'informations n'est disponible.",
"invalid email" => "email invalide",
"successfully sent" => "envoyé avec succès",
"not sent" => "pas envoyé",
"Permission denied you cannot remove this sheet" => "Droit d'accès refusé&nbsp;: vous ne pouvez pas supprimer ce feuillet",
"You do not have permission to edit messages \$owner" => "Vous n'avez pas les droits de modifer les messages \$owner",
"Page must be defined inside a structure to use this feature" => "La page doit être définie à l'intérieur d'une structure pour utiliser cette fonctionnalité",
"Clean the sql logs" => "Purger les logs SQL",
"You cannot take this quiz twice" => "Vous ne pouvez remplir ce QCM deux fois",
"Quiz time limit exceeded quiz cannot be computed" => "Limite de temps dépassée&nbsp;: le QCM ne peut pas être traité",
"You cannot take this survey twice" => "Vous ne pouvez pas répondre à cette enquête deux fois",
"Report to the webmaster" => "Signaler au webmaster",
"Please create a category first" => "SVP, créer d'abord une catégorie",
"empty" => "vide",
"No trackerId specified" => "Pas d'identifiant de formulaire spécifié",
"Tiki RSS feed for individual trackers: " => "Canaux de syndication RSS Tiki pour les formulaires individuels: ",
"You must lock the file before editing it" => "Vous devez vérouiller ce fichier avant de le modifier",
"No permission to upload zipped file packages" => "Aucun droit pour envoyer des paquetages de fichiers zippés",
"Error processing zipped image package" => "Erreur lors du traitement de paquetage image zippé",
"No permission to upload zipped image packages" => "Aucun droit pour envoyer des paquetages d'images zippées",
"The uploaded file ist not recognized as a image" => "Le fichier envoyé n'est pas une image",
"Permission denied you cannot upload images" => "Droit d'accès refusé&nbsp;: vous ne pouvez envoyer d'images",
"Permission denied you can upload images but not to this gallery" => "Droit d'accès refusé&nbsp;: vous pouvez envoyer des images, mais pas dans cette galerie",
"Cannot get image from URL" => "Impossible d'obtenir d'image de cette adresse Web",
"That is not an image (or you have php < 4.0.5)" => "Ceci n'est pas une image (ou votre version php < 4.0.5)",
"Usage" => "Utilisation",
"No url indicated" => "Aucune adresse Web indiquée",
"Unknown user" => "Utilisateur inconnu",
"You are not logged in and no user indicated" => "Vous n'êtes pas connecté et aucun utilisateur n'est indiqué",
"The user has chosen to make his information private" => "L'utilisateur a choisi de garder ses informations privées",
"Password has been changed" => "Le mot de passe a été changé",
"Invalid password. Your current password is required to change administrative information" => "Mot de passe invalide. Votre mot de passe actuel est requis pour modifier vos paramètres administratifs",
"Email is set to %s" => "L'adresse électronique est changée en %s",
"The passwords did not match" => "Les mots de passe ne correspondent pas",
"no" => "non",
"was moved into trash" => "a été mis à la corbeille",
"trashed by" => "mis à la corbeille par",
"open / in process" => "ouvert / en cours",
"Public for group" => "Publique pour le groupe",
"Rights by creator" => "Droits par créateur",
"END" => "FIN",
"Percentage" => "Pourcentage",
"Task accepted by creator" => "Tâche acceptée par le créateur",
"Task accepted by task user" => "Tâche acceptée par l'utilisateur de la tâche",
"Task NOT accepted by creator" => "Tâche NON acceptée par le créateur",
"Task NOT accepted by task user" => "Tâche NON acceptée par l'utilisateur de la tâche",
"Sorry this task does not exist or you have no rights to view this task" => "Désolé, cette tâche n'existe pas ou vous n'avez pas les droits de la voir",
"Info message" => "Message d'info",
"NEW Task" => "NOUVELLE tâche",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Désolé, vous ne pouvez envoyer une tâche à un autre utilisateur, ou l'utilisateur n'a pas les droits de recevoir des tâches",
"Changes on Task" => "Modification de la tâche",
"You received a new task" => "Vous avez reçu une nouvelle tâche",
"The priority is" => "La priorité est",
"very low" => "très bas",
"low" => "bas",
"high" => "haut",
"very high" => "très haut",
"You've to start your work at least on" => "Vous devez commencer le travail au moins le",
"You've to finish your work on" => "Vous devez finir le travail pour le",
"Login and click the link below" => "Connectez-vous et cliquez sur le lien ci-dessous",
"Please read the task and work on it!" => "SVP, lisez la tâche et travaillez dessus!",
"Sorry, there was an error while trying to write data into the database" => "Désolé, il y a une erreur lors de l'enregistrement des données dans la base de données",
"A new page is created in a language" => "Une nouvelle page a été créé dans une langue",
"Cannot upload this file not enough quota" => "Envoi du fichier impossible, quota insuffisant",
"No user indicated" => "Aucun utilisateur indiqué",
"Non-existent user" => "Utilisateur inexistant",
"No banner indicated" => "Aucune bannière indiquée",
"No blog indicated" => "Aucun blogue indiqué",
"Permission denied you cannot remove the post" => "Droit d'accès refusé&nbsp;: vous ne pouvez supprimer cet article",
"Permission denied: you cannot view this blog post while it is marked private" => "Accès refusé: vous ne pouvez pas voir le post car il est en statut privé",
"No cache information available" => "Aucune information sur l'antémémoire disponible",
"No faq indicated" => "Aucune FAQ indiquée",
"You are not permitted to remove someone else\\'s post!" => "Vous n'avez pas les droits d'effacer les publications de quelqu'un d'autre!",
"Incorrect thread" => "Fil de discussion incorrect",
"No thread indicated" => "Aucun fil de discussion indiqué",
"A SheetId is required." => "Le SheetId est exigé.",
"That tracker don't use extras." => "Ce formulaire n'utilise pas de supplément pour les pièces attachées.",
"Aborted" => "Interrompu",
"Top pages" => "Pages les plus populaires",
"Last pages" => "Dernières pages",
"Tiki RSS feed for the wiki pages" => "Canal de syndication RSS Tiki pour les pages Wiki",
"Last modifications to the Wiki." => "Dernières pages Wiki modifiées.",
"Tidy Extension not present" => "Extension Tidy non présente",
"Error deleting the file" => "Erreur lors de la suppression du fichier",
"TikiTest List" => "Liste TikiTest",
"TikiTest Record" => "Enregistrement TikiTest",
"You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "L'extension pecl HTTP ou Curl est requise pour rejouer le Tikitest",
"TikiTest Replay" => "Rejouer TikiTest",
"The page is empty" => "La page est vide",
"###end###"=>"###end###");
