/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.filetypes;

import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.utils.LabelFieldEditorWith2Cols;

public class FileTypesPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String VALID_SOURCE_FILES = "VALID_SOURCE_FILES";
    public static final String DEFAULT_VALID_SOURCE_FILES = "py, pyw";
    public static final String FIRST_CHOICE_PYTHON_SOURCE_FILE = "FIRST_CHOICE_PYTHON_SOURCE_FILE";
    public static final String DEFAULT_FIRST_CHOICE_PYTHON_SOURCE_FILE = "py";

    public FileTypesPreferencesPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("File Types Preferences");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField(new LabelFieldEditorWith2Cols("Label_Info_File_Preferences1", WordUtils.wrap((String)"These setting are used to know which files should be considered valid internally, and are not used in the file association of those files to the pydev editor.\n\n", (int)80), p){

            public String getLabelTextCol1() {
                return "Note:\n\n";
            }
        });
        this.addField(new LabelFieldEditorWith2Cols("Label_Info_File_Preferences2", WordUtils.wrap((String)"After changing those settings, a manual reconfiguration of the interpreter and a manual rebuild of the projects may be needed to update the inner caches that may be affected by those changes.\n\n", (int)80), p){

            public String getLabelTextCol1() {
                return "Important:\n\n";
            }
        });
        this.addField((FieldEditor)new StringFieldEditor(VALID_SOURCE_FILES, "Valid source files (comma-separated):", StringFieldEditor.UNLIMITED, p));
        this.addField((FieldEditor)new StringFieldEditor(FIRST_CHOICE_PYTHON_SOURCE_FILE, "Default python extension:", StringFieldEditor.UNLIMITED, p));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean isValidZipFile(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip") || fileName.endsWith(".egg");
    }

    public static boolean isValidDll(String path) {
        return path.endsWith(".pyd") || path.endsWith(".so") || path.endsWith(".dll") || path.endsWith(".a");
    }

    public static boolean isValidDllExtension(String extension) {
        return extension.equals("pyd") || extension.equals("so") || extension.equals("dll") || extension.equals("a");
    }

    public static final String getDefaultDottedPythonExtension() {
        return "." + PydevPrefs.getPreferences().getString(FIRST_CHOICE_PYTHON_SOURCE_FILE);
    }

    public static String[] getWildcardJythonValidZipFiles() {
        return new String[]{"*.jar", "*.zip"};
    }

    public static String[] getWildcardPythonValidZipFiles() {
        return new String[]{"*.egg", "*.zip"};
    }

    public static String[] getWildcardValidSourceFiles() {
        try {
            return PreferencesCacheHelper.get().getCacheWildcardValidSourceFiles();
        }
        catch (NullPointerException nullPointerException) {
            return new String[]{"*.py", "*.pyw"};
        }
    }

    public static final String[] getDottedValidSourceFiles() {
        try {
            return PreferencesCacheHelper.get().getCacheDottedValidSourceFiles();
        }
        catch (NullPointerException nullPointerException) {
            return new String[]{".py", ".pyw"};
        }
    }

    public static final String[] getValidSourceFiles() {
        try {
            return PreferencesCacheHelper.get().getCacheValidSourceFiles();
        }
        catch (NullPointerException nullPointerException) {
            return new String[]{DEFAULT_FIRST_CHOICE_PYTHON_SOURCE_FILE, "pyw"};
        }
    }

    public static final String[] getValidInitFiles() {
        try {
            return PreferencesCacheHelper.get().getCacheValidInitFiles();
        }
        catch (NullPointerException nullPointerException) {
            return new String[]{"__init__.py", "__init__.pyw"};
        }
    }

    private static class PreferencesCacheHelper
    implements Preferences.IPropertyChangeListener {
        private static PreferencesCacheHelper singleton;
        private String[] wildcaldValidSourceFiles;
        private String[] dottedValidSourceFiles;
        private String[] pythondValidSourceFiles;
        private String[] pythonValidInitFiles;

        static synchronized PreferencesCacheHelper get() {
            if (singleton == null) {
                singleton = new PreferencesCacheHelper();
            }
            return singleton;
        }

        public PreferencesCacheHelper() {
            PydevPrefs.getPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            this.wildcaldValidSourceFiles = null;
            this.dottedValidSourceFiles = null;
            this.pythondValidSourceFiles = null;
            this.pythonValidInitFiles = null;
        }

        public String[] getCacheWildcardValidSourceFiles() {
            String[] ret = this.wildcaldValidSourceFiles;
            if (ret == null) {
                String[] validSourceFiles = this.getCacheValidSourceFiles();
                String[] s = new String[validSourceFiles.length];
                int i = 0;
                while (i < validSourceFiles.length) {
                    s[i] = "*." + validSourceFiles[i];
                    ++i;
                }
                this.wildcaldValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }

        public String[] getCacheDottedValidSourceFiles() {
            String[] ret = this.dottedValidSourceFiles;
            if (ret == null) {
                String[] validSourceFiles = this.getCacheValidSourceFiles();
                String[] s = new String[validSourceFiles.length];
                int i = 0;
                while (i < validSourceFiles.length) {
                    s[i] = "." + validSourceFiles[i];
                    ++i;
                }
                this.dottedValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }

        public String[] getCacheValidInitFiles() {
            String[] ret = this.pythonValidInitFiles;
            if (ret == null) {
                String[] cacheValidSourceFiles = this.getCacheValidSourceFiles();
                ret = new String[cacheValidSourceFiles.length];
                int i = 0;
                while (i < ret.length) {
                    ret[i] = "__init__." + cacheValidSourceFiles[i];
                    ++i;
                }
            }
            return ret;
        }

        public String[] getCacheValidSourceFiles() {
            String[] ret = this.pythondValidSourceFiles;
            if (ret == null) {
                String validStr = PydevPrefs.getPreferences().getString(FileTypesPreferencesPage.VALID_SOURCE_FILES);
                List temp = StringUtils.splitAndRemoveEmptyTrimmed((String)validStr, (char)',');
                String[] s = temp.toArray(new String[temp.size()]);
                int i = 0;
                while (i < s.length) {
                    s[i] = s[i].trim();
                    ++i;
                }
                this.pythondValidSourceFiles = s;
                ret = s;
            }
            return ret;
        }
    }
}

