/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleMessages;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.dltk.console.ui.internal.actions.CloseScriptConsoleAction;
import org.python.pydev.dltk.console.ui.internal.actions.SaveConsoleSessionAction;

public class ScriptConsolePage
extends TextConsolePage
implements IScriptConsoleContentHandler {
    public static final String SCRIPT_GROUP = "scriptGroup";
    private SourceViewerConfiguration cfg;
    private ScriptConsoleViewer viewer;
    private TextViewerAction proposalsAction;
    private TextViewerAction quickAssistAction;

    protected void createActions() {
        super.createActions();
        this.proposalsAction = new ContentAssistProposalsAction((ITextViewer)this.getViewer());
        this.quickAssistAction = new QuickAssistProposalsAction((ITextViewer)this.getViewer());
        SaveConsoleSessionAction saveSessionAction = new SaveConsoleSessionAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.SaveSessionAction, ScriptConsoleMessages.SaveSessionTooltip);
        CloseScriptConsoleAction closeConsoleAction = new CloseScriptConsoleAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.TerminateConsoleAction, ScriptConsoleMessages.TerminateConsoleTooltip);
        IActionBars bars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = bars.getToolBarManager();
        toolbarManager.prependToGroup("launchGroup", (IContributionItem)new GroupMarker(SCRIPT_GROUP));
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IContributionItem)new Separator());
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IAction)closeConsoleAction);
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IAction)saveSessionAction);
        bars.updateActionBars();
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        ScriptConsole console = (ScriptConsole)this.getConsole();
        this.viewer = new ScriptConsoleViewer(parent, console, this, console.createStyleProvider(), console.getInitialCommands());
        this.viewer.configure(this.cfg);
        return this.viewer;
    }

    public ScriptConsolePage(ScriptConsole console, IConsoleView view, SourceViewerConfiguration cfg) {
        super((TextConsole)console, view);
        this.cfg = cfg;
    }

    public void clearConsolePage() {
        this.viewer.clear(false);
    }

    public void contentAssistRequired() {
        this.proposalsAction.run();
    }

    public void quickAssistRequired() {
        this.quickAssistAction.run();
    }

    protected class ContentAssistProposalsAction
    extends TextViewerAction {
        public ContentAssistProposalsAction(ITextViewer viewer) {
            super(viewer, 13);
        }
    }

    protected class QuickAssistProposalsAction
    extends TextViewerAction {
        public QuickAssistProposalsAction(ITextViewer viewer) {
            super(viewer, 22);
        }
    }
}

