/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.customizations.app_engine.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.customizations.CustomizationsPlugin;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineConfigWizardPage
extends WizardPage {
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Tree tree;
    private Image imageSystemLib;
    private Image imageAppEngine;
    private final List<String> externalSourceFolders = new ArrayList<String>();
    private final Map<String, String> variableSubstitution = new HashMap<String, String>();
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            AppEngineConfigWizardPage.this.setPageComplete(AppEngineConfigWizardPage.this.validatePage());
        }
    };

    protected AppEngineConfigWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.initialLocationFieldValue = new Path("");
        this.customLocationFieldValue = "";
        this.imageAppEngine = CustomizationsPlugin.getImageCache().get("icons/AppEngine-16.png");
        this.imageSystemLib = PydevPlugin.getImageCache().get("icons/jar_l_obj.gif");
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        Composite appEngineGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        appEngineGroup.setLayout((Layout)layout);
        appEngineGroup.setLayoutData((Object)new GridData(768));
        appEngineGroup.setFont(font);
        this.createUserSpecifiedGoogleAppEngineLocationGroup(appEngineGroup);
        this.tree = new Tree(composite, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.setFont(font);
        this.setControl((Control)composite);
    }

    private void createUserSpecifiedGoogleAppEngineLocationGroup(Composite appEngineGroup) {
        Font font = appEngineGroup.getFont();
        this.locationLabel = new Label(appEngineGroup, 0);
        this.locationLabel.setFont(font);
        this.locationLabel.setText("Google App Engine Director&y");
        this.locationPathField = new Text(appEngineGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(appEngineGroup, 8);
        this.browseButton.setFont(font);
        this.browseButton.setText("B&rowse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AppEngineConfigWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage("Select the Google App Engine root directory (dir containing dev_appserver.py, appcfg.py, lib, etc).");
        String dirName = this.getAppEngineLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private String getAppEngineLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    public void setAppEngineLocationFieldValue(String location) {
        this.locationPathField.setText(location);
    }

    private boolean validatePage() {
        String[] preconditions;
        this.tree.removeAll();
        this.externalSourceFolders.clear();
        this.variableSubstitution.clear();
        String locationFieldContents = this.getAppEngineLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage("Google App Engine location is empty");
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage("Google App Engine location is not valid");
            return false;
        }
        File loc = new File(locationFieldContents);
        if (!loc.exists()) {
            this.setErrorMessage("Google App Engine location does not exist");
            return false;
        }
        if (!loc.isDirectory()) {
            this.setErrorMessage("Expecting directory to be selected (not a file)");
            return false;
        }
        File[] files = loc.listFiles();
        HashMap<String, File> map = new HashMap<String, File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            map.put(f.getName(), f);
            ++n2;
        }
        String[] stringArray = preconditions = new String[]{"appcfg.py", "bulkload_client.py", "bulkloader.py", "dev_appserver.py", "VERSION", "lib"};
        int n3 = preconditions.length;
        n = 0;
        while (n < n3) {
            String precondition = stringArray[n];
            if (!map.containsKey(precondition)) {
                this.setErrorMessage(StringUtils.format((String)"Invalid Google App Engine directory. Did not find: %s in %s", (Object[])new Object[]{precondition, locationFieldContents}));
                return false;
            }
            ++n;
        }
        List<File> libFoldersForPythonpath = this.gatherLibFoldersForPythonpath(loc.getAbsolutePath());
        for (File libLoc : libFoldersForPythonpath) {
            if (!libLoc.exists()) {
                this.setErrorMessage(StringUtils.format((String)"Invalid Google App Engine directory. Did not find: %s", (Object[])new Object[]{libLoc.getAbsolutePath()}));
                return false;
            }
            if (libLoc.isDirectory()) continue;
            this.setErrorMessage(StringUtils.format((String)"Invalid Google App Engine install. Expected directory for: %s", (Object[])new Object[]{libLoc.getAbsolutePath()}));
        }
        this.variableSubstitution.put("GOOGLE_APP_ENGINE", loc.getAbsolutePath());
        this.fillExternalSourceFolders(this.variableSubstitution, new String[]{"${GOOGLE_APP_ENGINE}", "${GOOGLE_APP_ENGINE}/lib/django", "${GOOGLE_APP_ENGINE}/lib/webob", "${GOOGLE_APP_ENGINE}/lib/yaml/lib"});
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private List<File> gatherLibFoldersForPythonpath(String appEngineLoc) {
        String[] preconditions;
        ArrayList<File> ret = new ArrayList<File>();
        String[] stringArray = preconditions = new String[]{"django", "webob", "yaml/lib"};
        int n = preconditions.length;
        int n2 = 0;
        while (n2 < n) {
            String precondition = stringArray[n2];
            List parts = StringUtils.split((String)precondition, (char)'/');
            File libLoc = new File(appEngineLoc, "lib");
            for (String part : parts) {
                libLoc = new File(libLoc, part);
            }
            ret.add(libLoc);
            ++n2;
        }
        return ret;
    }

    private void fillExternalSourceFolders(Map<String, String> variableSubstitution, String[] libFoldersForPythonpath) {
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText(new StringBuffer("GOOGLE_APP_ENGINE: ").append(variableSubstitution.get("GOOGLE_APP_ENGINE")).toString());
        item.setImage(this.imageAppEngine);
        String[] stringArray = libFoldersForPythonpath;
        int n = libFoldersForPythonpath.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            TreeItem subItem = new TreeItem(item, 0);
            subItem.setText(file);
            subItem.setImage(this.imageSystemLib);
            item.setExpanded(true);
            this.externalSourceFolders.add(file);
            ++n2;
        }
    }

    public List<String> getExternalSourceFolders() {
        return this.externalSourceFolders;
    }

    public Map<String, String> getVariableSubstitution() {
        return this.variableSubstitution;
    }
}

