#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from prewikka.templates.ClassicLayout import ClassicLayout

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1298520634.003897
__CHEETAH_genTimestamp__ = 'Wed Feb 23 21:10:34 2011'
__CHEETAH_src__ = 'prewikka/templates/HeartbeatAnalyze.tmpl'
__CHEETAH_srcLastModified__ = 'Tue May  5 08:55:59 2009'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class HeartbeatAnalyze(ClassicLayout):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(HeartbeatAnalyze, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def main_content(self, **KWS):



        ## CHEETAH: generated from #block main_content at line 3, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''<table class="heartbeat_analyze">
  <thead>
    <tr class="heartbeat_analyze_header">
      <td>Name</td>
      <td>Model</td>
      <td>OS</td>
      <td>Node Name</td>
      <td>Node Location</td>
      <td>Node Address</td>
      <td>Latest heartbeat</td>
      <td>Current status</td>
    </tr>
  </thead>
  <tbody>

''')
        row_classes = ("table_row_even", "table_row_odd")
        cnt = 0
        write(u'''  
  <tr class="''')
        _v = VFFSL(SL,"row_classes",True)[VFFSL(SL,"cnt",True)%2] # u'$row_classes[$cnt%2]' on line 22, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'$row_classes[$cnt%2]')) # from line 22, col 14.
        write(u'''">
    <td>''')
        _v = VFFSL(SL,"analyzer.name",True) # u'$analyzer.name' on line 23, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.name')) # from line 23, col 9.
        write(u'''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.model",True) # u'$analyzer.model' on line 24, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.model')) # from line 24, col 9.
        write(u''' ''')
        _v = VFFSL(SL,"analyzer.version",True) # u'$analyzer.version' on line 24, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.version')) # from line 24, col 25.
        write(u'''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.ostype",True) # u'$analyzer.ostype' on line 25, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.ostype')) # from line 25, col 9.
        write(u''' ''')
        _v = VFFSL(SL,"analyzer.osversion",True) # u'$analyzer.osversion' on line 25, col 26
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.osversion')) # from line 25, col 26.
        write(u'''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.node_name",True) # u'$analyzer.node_name' on line 26, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.node_name')) # from line 26, col 9.
        write(u'''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.node_location",True) # u'$analyzer.node_location' on line 27, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.node_location')) # from line 27, col 9.
        write(u'''</td>
    <td>
''')
        if len(VFFSL(SL,"analyzer.node_addresses",True)) > 0: # generated from line 29, col 7
            for address in VFFSL(SL,"analyzer.node_addresses",True): # generated from line 30, col 9
                write(u'''          ''')
                _v = VFFSL(SL,"address",True) # u'$address' on line 31, col 11
                if _v is not None: write(_filter(_v, rawExpr=u'$address')) # from line 31, col 11.
                write(u'''<br/>
''')
        else: # generated from line 33, col 7
            write(u'''        n/a
''')
        write(u'''    </td>
    <td>''')
        _v = VFFSL(SL,"analyzer.last_heartbeat_time",True) # u'$analyzer.last_heartbeat_time' on line 37, col 9
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.last_heartbeat_time')) # from line 37, col 9.
        write(u'''</td>
    <td class="heartbeat_analyze_sensor_status_''')
        _v = VFFSL(SL,"analyzer.status",True) # u'$analyzer.status' on line 38, col 48
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.status')) # from line 38, col 48.
        write(u'''">
      <b>''')
        _v = VFFSL(SL,"analyzer.status_meaning",True) # u'$analyzer.status_meaning' on line 39, col 10
        if _v is not None: write(_filter(_v, rawExpr=u'$analyzer.status_meaning')) # from line 39, col 10.
        write(u'''</b>
    </td>
  </tr>
''')
        cnt += 1
        write(u''' </tbody>
</table>
  
<table class="heartbeat_analyze">
  <thead>
    <tr class="heartbeat_analyze_header"><td class="">Events</td></tr>
  </thead>

  <tbody>
''')
        row_classes = ("table_row_even", "table_row_odd")
        cnt = 0
        for event in VFFSL(SL,"analyzer.events",True): # generated from line 54, col 5
            write(u'''      <tr class="''')
            _v = VFFSL(SL,"row_classes",True)[VFFSL(SL,"cnt",True)%2] # u'$row_classes[$cnt%2]' on line 55, col 18
            if _v is not None: write(_filter(_v, rawExpr=u'$row_classes[$cnt%2]')) # from line 55, col 18.
            write(u'''"><td colspan="8" class="heartbeat_analyzer_event_''')
            _v = VFFSL(SL,"event.type",True) # u'$event.type' on line 55, col 88
            if _v is not None: write(_filter(_v, rawExpr=u'$event.type')) # from line 55, col 88.
            write(u'''">''')
            _v = VFFSL(SL,"event.value",True) # u'$event.value' on line 55, col 101
            if _v is not None: write(_filter(_v, rawExpr=u'$event.value')) # from line 55, col 101.
            write(u'''</td></tr>
''')
            cnt += 1
        write(u'''  </tbody>
</table>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''
''')
        self.main_content(trans=trans)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_HeartbeatAnalyze= 'writeBody'

## END CLASS DEFINITION

if not hasattr(HeartbeatAnalyze, '_initCheetahAttributes'):
    templateAPIClass = getattr(HeartbeatAnalyze, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(HeartbeatAnalyze)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=HeartbeatAnalyze()).run()


