#ifndef __MSP430_HEADERS_FLASH_H
#define __MSP430_HEADERS_FLASH_H

/* flash_5xx.h
 *
 * mspgcc project: MSP430 device headers
 * Flash Memory Controller module
 * Based on cc430x613x.h version 1.5 by Texas Instruments
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 */

/* Switches:

__MSP430_FLASH_BASE__ - base address of the flash memory controller module, present if defined

*/

#if defined(__MSP430_FLASH_BASE__)

#define __MSP430_HAS_FLASH__                  /* Definition to show that Module is available */

#define FCTL1_ __MSP430_FLASH_BASE__ + 0x00  /* FLASH Control 1 */
sfrw(FCTL1, FCTL1_);
#define FCTL1_L_ __MSP430_FLASH_BASE__ + 0x00  
sfrb(FCTL1_L, FCTL1_L_);
#define FCTL1_H_ __MSP430_FLASH_BASE__ + 0x01  
sfrb(FCTL1_H, FCTL1_H_);
//sfrbw    FCTL2               (0x0142)  /* FLASH Control 2 */
#define FCTL3_ __MSP430_FLASH_BASE__ + 0x04  /* FLASH Control 3 */
sfrw(FCTL3, FCTL3_);
#define FCTL3_L_ __MSP430_FLASH_BASE__ + 0x04  
sfrb(FCTL3_L, FCTL3_L_);
#define FCTL3_H_ __MSP430_FLASH_BASE__ + 0x05  
sfrb(FCTL3_H, FCTL3_H_);
#define FCTL4_ __MSP430_FLASH_BASE__ + 0x06  /* FLASH Control 4 */
sfrw(FCTL4, FCTL4_);
#define FCTL4_L_ __MSP430_FLASH_BASE__ + 0x06  
sfrb(FCTL4_L, FCTL4_L_);
#define FCTL4_H_ __MSP430_FLASH_BASE__ + 0x07  
sfrb(FCTL4_H, FCTL4_H_);

#define FRKEY                  (0x9600)       /* Flash key returned by read */
#define FWKEY                  (0xA500)       /* Flash key for write */
#define FXKEY                  (0x3300)       /* for use with XOR instruction */

/* FCTL1 Control Bits */
//#define RESERVED            (0x0001)  /* Reserved */
#define ERASE                  (0x0002)       /* Enable bit for Flash segment erase */
#define MERAS                  (0x0004)       /* Enable bit for Flash mass erase */
//#define RESERVED            (0x0008)  /* Reserved */
//#define RESERVED            (0x0010)  /* Reserved */
#define SWRT                   (0x0020)       /* Smart Write enable */
#define WRT                    (0x0040)       /* Enable bit for Flash write */
#define BLKWRT                 (0x0080)       /* Enable bit for Flash segment write */

/* FCTL1 Control Bits */
//#define RESERVED            (0x0001)  /* Reserved */
#define ERASE_L                (0x0002)       /* Enable bit for Flash segment erase */
#define MERAS_L                (0x0004)       /* Enable bit for Flash mass erase */
//#define RESERVED            (0x0008)  /* Reserved */
//#define RESERVED            (0x0010)  /* Reserved */
#define SWRT_L                 (0x0020)       /* Smart Write enable */
#define WRT_L                  (0x0040)       /* Enable bit for Flash write */
#define BLKWRT_L               (0x0080)       /* Enable bit for Flash segment write */

/* FCTL1 Control Bits */
//#define RESERVED            (0x0001)  /* Reserved */
//#define RESERVED            (0x0008)  /* Reserved */
//#define RESERVED            (0x0010)  /* Reserved */

/* FCTL3 Control Bits */
#define BUSY                   (0x0001)       /* Flash busy: 1 */
#define KEYV                   (0x0002)       /* Flash Key violation flag */
#define ACCVIFG                (0x0004)       /* Flash Access violation flag */
#define WAIT                   (0x0008)       /* Wait flag for segment write */
#define LOCK                   (0x0010)       /* Lock bit: 1 - Flash is locked (read only) */
#define EMEX                   (0x0020)       /* Flash Emergency Exit */
#define LOCKA                  (0x0040)       /* Segment A Lock bit: read = 1 - Segment is locked (read only) */
//#define RESERVED            (0x0080)  /* Reserved *

/* FCTL3 Control Bits */
#define BUSY_L                 (0x0001)       /* Flash busy: 1 */
#define KEYV_L                 (0x0002)       /* Flash Key violation flag */
#define ACCVIFG_L              (0x0004)       /* Flash Access violation flag */
#define WAIT_L                 (0x0008)       /* Wait flag for segment write */
#define LOCK_L                 (0x0010)       /* Lock bit: 1 - Flash is locked (read only) */
#define EMEX_L                 (0x0020)       /* Flash Emergency Exit */
#define LOCKA_L                (0x0040)       /* Segment A Lock bit: read = 1 - Segment is locked (read only) */
//#define RESERVED            (0x0080)  /* Reserved */

/* FCTL3 Control Bits */
//#define RESERVED            (0x0080)  /* Reserved */

/* FCTL4 Control Bits */
#define VPE                    (0x0001)       /* Voltage Changed during Program Error Flag */
#define MGR0                   (0x0010)       /* Marginal read 0 mode. */
#define MGR1                   (0x0020)       /* Marginal read 1 mode. */
#define LOCKINFO               (0x0080)       /* Lock INFO Memory bit: read = 1 - Segment is locked (read only) */

/* FCTL4 Control Bits */
#define VPE_L                  (0x0001)       /* Voltage Changed during Program Error Flag */
#define MGR0_L                 (0x0010)       /* Marginal read 0 mode. */
#define MGR1_L                 (0x0020)       /* Marginal read 1 mode. */
#define LOCKINFO_L             (0x0080)       /* Lock INFO Memory bit: read = 1 - Segment is locked (read only) */

/* FCTL4 Control Bits */

#endif /* __MSP430_FLASH_BASE__ */

#endif /* __MSP430_HEADERS_FLASH_H */
