/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.dataflow.DataFlowConstants;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.FrameStorePlacementProblem;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.compiler.ir.instructions.ALLOC_FRAME_Instr;
import org.jruby.compiler.ir.instructions.CLOSURE_RETURN_Instr;
import org.jruby.compiler.ir.instructions.CallInstruction;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.STORE_TO_FRAME_Instr;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.SelfVariable;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

public class FrameStorePlacementNode
extends FlowGraphNode {
    Set<Variable> _inDirtyVars;
    Set<Variable> _outDirtyVars;
    boolean _inFrameAllocated;
    boolean _outFrameAllocated;

    public FrameStorePlacementNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    public void init() {
        this._inDirtyVars = new HashSet<Variable>();
        this._outDirtyVars = new HashSet<Variable>();
        if (this._prob.getCFG().getScope() instanceof IR_Closure) {
            this._outFrameAllocated = true;
            this._inFrameAllocated = true;
        } else {
            this._outFrameAllocated = false;
            this._inFrameAllocated = false;
        }
    }

    public void buildDataFlowVars(IR_Instr i) {
        FrameStorePlacementProblem fsp = (FrameStorePlacementProblem)this._prob;
        for (Variable v : i.getUsedVariables()) {
            if (!(v instanceof LocalVariable) && !(v instanceof SelfVariable)) continue;
            fsp.recordUsedVar(v);
        }
        Variable v = i.getResult();
        if (v != null && (v instanceof LocalVariable || v instanceof SelfVariable)) {
            fsp.recordDefVar(v);
        }
    }

    public void initSolnForNode() {
    }

    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        FrameStorePlacementNode n = (FrameStorePlacementNode)pred2;
        this._inDirtyVars.addAll(n._outDirtyVars);
        this._inFrameAllocated = this._inFrameAllocated && n._outFrameAllocated;
    }

    public boolean applyTransferFunction() {
        boolean frameAllocated = this._inFrameAllocated;
        FrameStorePlacementProblem fsp = (FrameStorePlacementProblem)this._prob;
        HashSet<Variable> dirtyVars = new HashSet<Variable>(this._inDirtyVars);
        for (IR_Instr i : this._bb.getInstrs()) {
            Variable v;
            if (i._op == Operation.FRAME_LOAD) continue;
            if (i instanceof CallInstruction) {
                CallInstruction call2 = (CallInstruction)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    frameAllocated = true;
                    IR_Closure cl = (IR_Closure)((MetaObject)o)._scope;
                    CFG cl_cfg = cl.getCFG();
                    FrameStorePlacementProblem cl_fsp = new FrameStorePlacementProblem();
                    cl_fsp.setup(cl_cfg);
                    cl_fsp.compute_MOP_Solution();
                    cl_cfg.setDataFlowSolution(cl_fsp.getName(), cl_fsp);
                    boolean spillAllVars = call2.canBeEval() || call2.canCaptureCallersFrame();
                    HashSet<Variable> newDirtyVars = new HashSet<Variable>(dirtyVars);
                    for (Variable v2 : dirtyVars) {
                        if (!spillAllVars && !cl_fsp.scopeUsesVariable(v2) && !cl_fsp.scopeDefinesVariable(v2)) continue;
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                } else if (call2.requiresFrame()) {
                    dirtyVars.clear();
                    frameAllocated = true;
                }
            }
            if ((v = i.getResult()) != null && (v instanceof LocalVariable || v instanceof SelfVariable)) {
                dirtyVars.add(v);
            }
            if (!i._op.isReturn()) continue;
            dirtyVars.clear();
        }
        CFG cfg = this._prob.getCFG();
        if (this._bb == cfg.getExitBB()) {
            dirtyVars.clear();
        }
        if (this._outDirtyVars.equals(dirtyVars) && this._outFrameAllocated == frameAllocated) {
            return false;
        }
        this._outDirtyVars = dirtyVars;
        this._outFrameAllocated = frameAllocated;
        return true;
    }

    public String toString() {
        return "";
    }

    public void addStoreAndFrameAllocInstructions() {
        FrameStorePlacementProblem fsp = (FrameStorePlacementProblem)this._prob;
        IR_ExecutionScope s = fsp.getCFG().getScope();
        ListIterator<IR_Instr> instrs = this._bb.getInstrs().listIterator();
        HashSet<Variable> dirtyVars = new HashSet<Variable>(this._inDirtyVars);
        boolean frameAllocated = this._inFrameAllocated;
        while (instrs.hasNext()) {
            Variable v;
            IR_Instr i = instrs.next();
            if (i._op == Operation.FRAME_LOAD) continue;
            if (i instanceof CallInstruction) {
                CallInstruction call2 = (CallInstruction)i;
                Operand o = call2.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    CFG cl_cfg = ((IR_Closure)((MetaObject)o)._scope).getCFG();
                    FrameStorePlacementProblem cl_fsp = (FrameStorePlacementProblem)cl_cfg.getDataFlowSolution(fsp.getName());
                    instrs.previous();
                    if (!frameAllocated) {
                        instrs.add(new ALLOC_FRAME_Instr(s));
                        frameAllocated = true;
                    }
                    boolean spillAllVars = call2.canBeEval() || call2.canCaptureCallersFrame();
                    HashSet<Variable> newDirtyVars = new HashSet<Variable>(dirtyVars);
                    for (Variable v2 : dirtyVars) {
                        if (spillAllVars || cl_fsp.scopeUsesVariable(v2)) {
                            instrs.add(new STORE_TO_FRAME_Instr(s, v2.getName(), v2));
                            newDirtyVars.remove(v2);
                            continue;
                        }
                        if (!cl_fsp.scopeDefinesVariable(v2)) continue;
                        newDirtyVars.remove(v2);
                    }
                    dirtyVars = newDirtyVars;
                    instrs.next();
                    ((FrameStorePlacementProblem)cl_cfg.getDataFlowSolution(fsp.getName())).addStoreAndFrameAllocInstructions();
                } else if (call2.requiresFrame()) {
                    instrs.previous();
                    if (!frameAllocated) {
                        instrs.add(new ALLOC_FRAME_Instr(s));
                        frameAllocated = true;
                    }
                    for (Variable v3 : dirtyVars) {
                        instrs.add(new STORE_TO_FRAME_Instr(s, v3.getName(), v3));
                    }
                    instrs.next();
                    dirtyVars.clear();
                }
            } else if (i instanceof CLOSURE_RETURN_Instr) {
                LiveVariablesProblem lvp = (LiveVariablesProblem)fsp.getCFG().getDataFlowSolution(DataFlowConstants.LVP_NAME);
                dirtyVars.retainAll(lvp.getVarsLiveOnExit());
                instrs.previous();
                for (Variable v4 : dirtyVars) {
                    instrs.add(new STORE_TO_FRAME_Instr(s, v4.getName(), v4));
                }
                instrs.next();
            }
            if ((v = i.getResult()) == null || !(v instanceof LocalVariable) && !(v instanceof SelfVariable)) continue;
            dirtyVars.add(v);
        }
    }
}

