/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.ChainedChildBodyCompiler;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class ChildScopedBodyCompiler
extends BaseBodyCompiler {
    public ChildScopedBodyCompiler(StandardASMCompiler scriptCompiler, String closureMethodName, ASTInspector inspector, StaticScope scope) {
        super(scriptCompiler, closureMethodName, inspector, scope);
    }

    protected int getActualArgsCount(StaticScope scope) {
        return 1;
    }

    protected String getSignature() {
        return StandardASMCompiler.getStaticClosureSignature(this.script.getClassname());
    }

    protected void createVariableCompiler() {
        this.variableCompiler = this.inspector == null ? new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : (this.inspector.hasClosure() || this.inspector.hasScopeAwareMethods() ? new HeapBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()) : new StackBasedVariableCompiler(this, this.method, this.scope, false, 3, this.getFirstTempIndex()));
    }

    public void beginMethod(CompilerCallback args2, StaticScope scope) {
        this.method.start();
        this.method.aload(1);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        this.method.astore(this.getRuntimeIndex());
        this.method.aload(this.getRuntimeIndex());
        this.invokeRuby("getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.method.astore(this.getNilIndex());
        if (scope == null) {
            this.variableCompiler.beginFlatClosure(args2, this.scope);
        } else {
            this.variableCompiler.beginClosure(args2, scope);
        }
        this.redoJump = new Label();
        this.method.label(this.scopeStart);
    }

    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
    }

    public ChainedChildBodyCompiler outline(String methodName) {
        this.method.aload(0);
        for (int i = 1; i <= 4; ++i) {
            this.method.aload(i);
        }
        methodName = methodName + "_" + this.script.getAndIncrementMethodIndex();
        this.method.invokestatic(this.script.getClassname(), methodName, this.getSignature());
        ChainedChildBodyCompiler methodCompiler = new ChainedChildBodyCompiler(this.script, methodName, this.inspector, this.scope, this);
        methodCompiler.beginChainedMethod();
        return methodCompiler;
    }

    public void endBody() {
        this.method.areturn();
        this.method.label(this.scopeEnd);
        if (this.inspector == null || this.inspector.hasScopeAwareMethods()) {
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, CodegenUtils.p(JumpException.RedoJump.class));
        }
        this.variableCompiler.declareLocals(this.scope, this.scopeStart, this.scopeEnd);
        this.method.end();
    }

    public void loadBlock() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
    }

    public void performReturn() {
        this.loadThreadContext();
        this.invokeUtilityMethod("returnJump", CodegenUtils.sig(JumpException.ReturnJump.class, IRubyObject.class, ThreadContext.class));
        this.method.athrow();
    }

    public void issueBreakEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopBreak();
        } else {
            this.loadThreadContext();
            value2.call(this);
            this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
    }

    public void issueNextEvent(CompilerCallback value2) {
        if (this.currentLoopLabels != null) {
            value2.call(this);
            this.issueLoopNext();
        } else {
            value2.call(this);
            this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        }
    }

    public void issueRedoEvent() {
        if (this.currentLoopLabels != null) {
            this.issueLoopRedo();
        } else if (this.inNestedMethod) {
            this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        } else {
            this.method.go_to(this.scopeStart);
        }
    }
}

