/*
 * Decompiled with CFR 0.152.
 */
package org.yecht;

import org.yecht.Bytestring;
import org.yecht.Data;
import org.yecht.MapPart;
import org.yecht.Node;
import org.yecht.NodeHandler;
import org.yecht.Parser;

public class BytecodeNodeHandler
implements NodeHandler {
    public static byte[] bytes(String s) {
        try {
            return s.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object handle(Parser p, Node n) {
        Bytestring val = new Bytestring();
        if (n.anchor != null) {
            val.append((byte)65, BytecodeNodeHandler.bytes(n.anchor), 0, -1);
        }
        if (n.type_id != null) {
            if (p.taguri_expansion) {
                val.append((byte)84, BytecodeNodeHandler.bytes(n.type_id), 0, -1);
            } else {
                val.append((byte)84, BytecodeNodeHandler.bytes("!" + n.type_id), 0, -1);
            }
        }
        block0 : switch (n.kind) {
            case Str: {
                int nextcode = 83;
                Data.Str dd = (Data.Str)n.data;
                byte[] buf = dd.ptr.buffer;
                int start = dd.ptr.start;
                int finish = start + dd.len - 1;
                int current = start;
                while (true) {
                    byte ch;
                    if (10 == (ch = buf[current]) || 0 == ch || current > finish) {
                        if (current >= start) {
                            val.append((byte)nextcode, buf, start, current);
                            nextcode = 67;
                        }
                        start = current + 1;
                        if (current > finish) break block0;
                        if (10 == ch) {
                            val.append((byte)78, null, 0, -1);
                        } else if (0 == ch) {
                            val.append((byte)90, null, 0, -1);
                        }
                    }
                    ++current;
                }
            }
            case Seq: {
                val.append((byte)81, null, 0, -1);
                Data.Seq dd = (Data.Seq)n.data;
                for (int i = 0; i < dd.idx; ++i) {
                    val.extend((Bytestring)n.seqRead(i));
                }
                val.append((byte)69, null, 0, -1);
                break;
            }
            case Map: {
                val.append((byte)77, null, 0, -1);
                Data.Map dd = (Data.Map)n.data;
                for (int i = 0; i < dd.idx; ++i) {
                    val.extend((Bytestring)n.mapRead(MapPart.Key, i));
                    val.extend((Bytestring)n.mapRead(MapPart.Value, i));
                }
                val.append((byte)69, null, 0, -1);
                break;
            }
        }
        return val;
    }
}

