/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static Logger logger = Logger.getLogger(MultiFetchServerObjectReader.class.getName());
    private static int MAX_IDS_PER_REQUEST = 200;
    private HashSet<Long> nodes = new HashSet();
    private HashSet<Long> ways = new HashSet();
    private HashSet<Long> relations = new HashSet();
    private HashSet<Long> missingPrimitives;
    private DataSet outputDataSet = new DataSet();

    public MultiFetchServerObjectReader() {
        this.missingPrimitives = new HashSet();
    }

    protected void remember(PrimitiveId id) {
        if (id.isNew()) {
            return;
        }
        switch (id.getType()) {
            case NODE: {
                this.nodes.add(id.getUniqueId());
                break;
            }
            case WAY: {
                this.ways.add(id.getUniqueId());
                break;
            }
            case RELATION: {
                this.relations.add(id.getUniqueId());
            }
        }
    }

    protected void remember(DataSet ds, long id, OsmPrimitiveType type) throws IllegalArgumentException, NoSuchElementException {
        CheckParameterUtil.ensureParameterNotNull(ds, "ds");
        if (id <= 0L) {
            return;
        }
        OsmPrimitive primitive = ds.getPrimitiveById(id, type);
        if (primitive == null) {
            throw new NoSuchElementException(I18n.tr("No primitive with id {0} in local dataset. Cannot infer primitive type.", id));
        }
        this.remember(primitive.getPrimitiveId());
    }

    public MultiFetchServerObjectReader append(DataSet ds, long id, OsmPrimitiveType type) {
        switch (type) {
            case NODE: {
                Node n = (Node)ds.getPrimitiveById(id, type);
                this.append(n);
                break;
            }
            case WAY: {
                Way w = (Way)ds.getPrimitiveById(id, type);
                this.append(w);
                break;
            }
            case RELATION: {
                Relation r = (Relation)ds.getPrimitiveById(id, type);
                this.append(r);
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Node node) {
        if (node == null) {
            return this;
        }
        this.remember(node.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader append(Way way) {
        if (way == null) {
            return this;
        }
        if (way.isNew()) {
            return this;
        }
        for (Node node : way.getNodes()) {
            if (node.isNew()) continue;
            this.remember(node.getPrimitiveId());
        }
        this.remember(way.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader append(Relation relation) {
        if (relation == null) {
            return this;
        }
        if (relation.isNew()) {
            return this;
        }
        this.remember(relation.getPrimitiveId());
        for (RelationMember member : relation.getMembers()) {
            if (OsmPrimitiveType.from(member.getMember()).equals((Object)OsmPrimitiveType.RELATION) && this.relations.contains(member.getMember().getId()) || member.getMember().isIncomplete()) continue;
            this.appendGeneric(member.getMember());
        }
        return this;
    }

    protected MultiFetchServerObjectReader appendGeneric(OsmPrimitive primitive) {
        if (OsmPrimitiveType.from(primitive).equals((Object)OsmPrimitiveType.NODE)) {
            return this.append((Node)primitive);
        }
        if (OsmPrimitiveType.from(primitive).equals((Object)OsmPrimitiveType.WAY)) {
            return this.append((Way)primitive);
        }
        if (OsmPrimitiveType.from(primitive).equals((Object)OsmPrimitiveType.RELATION)) {
            return this.append((Relation)primitive);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return this;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            this.appendGeneric(osmPrimitive);
        }
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> ids) {
        HashSet<Long> pkg = new HashSet<Long>();
        if (ids.isEmpty()) {
            return pkg;
        }
        if (ids.size() > MAX_IDS_PER_REQUEST) {
            Iterator<Long> it = ids.iterator();
            for (int i = 0; i < MAX_IDS_PER_REQUEST; ++i) {
                pkg.add(it.next());
            }
            ids.removeAll(pkg);
        } else {
            pkg.addAll(ids);
            ids.clear();
        }
        return pkg;
    }

    protected String buildRequestString(OsmPrimitiveType type, Set<Long> idPackage) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getAPIName()).append("s?").append(type.getAPIName()).append("s=");
        Iterator<Long> it = idPackage.iterator();
        for (int i = 0; i < idPackage.size(); ++i) {
            sb.append(it.next());
            if (i >= idPackage.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected String buildRequestString(OsmPrimitiveType type, long id) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getAPIName()).append("s?").append(type.getAPIName()).append("s=").append(id);
        return sb.toString();
    }

    protected void multiGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
        String request = this.buildRequestString(type, pkg);
        InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);
        if (in == null) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
        try {
            DataSet loaded = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
            this.rememberNodesOfIncompleteWaysToLoad(loaded);
            this.merge(loaded);
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
    }

    protected void singleGetId(OsmPrimitiveType type, long id, ProgressMonitor progressMonitor) throws OsmTransferException {
        String request = this.buildRequestString(type, id);
        InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);
        if (in == null) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
        try {
            DataSet loaded = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
            this.rememberNodesOfIncompleteWaysToLoad(loaded);
            this.merge(loaded);
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
    }

    protected void singleGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
        for (long id : pkg) {
            try {
                String msg = "";
                switch (type) {
                    case NODE: {
                        msg = I18n.tr("Fetching node with id {0} from ''{1}''", id, OsmApi.getOsmApi().getBaseUrl());
                        break;
                    }
                    case WAY: {
                        msg = I18n.tr("Fetching way with id {0} from ''{1}''", id, OsmApi.getOsmApi().getBaseUrl());
                        break;
                    }
                    case RELATION: {
                        msg = I18n.tr("Fetching relation with id {0} from ''{1}''", id, OsmApi.getOsmApi().getBaseUrl());
                    }
                }
                progressMonitor.setCustomText(msg);
                this.singleGetId(type, id, progressMonitor);
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() == 404) {
                    logger.warning(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(id)));
                    this.missingPrimitives.add(id);
                    continue;
                }
                throw e;
            }
        }
    }

    protected void rememberNodesOfIncompleteWaysToLoad(DataSet from) {
        for (Way w : from.getWays()) {
            if (!w.hasIncompleteNodes()) continue;
            for (Node n : w.getNodes()) {
                if (!n.isIncomplete()) continue;
                this.nodes.add(n.getId());
            }
        }
    }

    protected void merge(DataSet from) {
        DataSetMerger visitor = new DataSetMerger(this.outputDataSet, from);
        visitor.merge();
    }

    protected void fetchPrimitives(Set<Long> ids, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        String msg = "";
        switch (type) {
            case NODE: {
                msg = I18n.tr("Fetching a package of nodes from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
                break;
            }
            case WAY: {
                msg = I18n.tr("Fetching a package of ways from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
                break;
            }
            case RELATION: {
                msg = I18n.tr("Fetching a package of relations from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
            }
        }
        progressMonitor.indeterminateSubTask(msg);
        HashSet<Long> toFetch = new HashSet<Long>(ids);
        toFetch.addAll(ids);
        while (!toFetch.isEmpty() && !this.isCanceled()) {
            Set<Long> pkg = this.extractIdPackage(toFetch);
            try {
                this.multiGetIdPackage(type, pkg, progressMonitor);
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() == 404) {
                    logger.warning(I18n.tr("Server replied with response code 404, retrying with an individual request for each primitive."));
                    this.singleGetIdPackage(type, pkg, progressMonitor);
                    continue;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        int n = this.nodes.size() + this.ways.size() + this.relations.size();
        progressMonitor.beginTask(I18n.trn("Downloading {0} object from ''{1}''", "Downloading {0} objects from ''{1}''", n, n, OsmApi.getOsmApi().getBaseUrl()));
        try {
            this.missingPrimitives = new HashSet();
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.relations, OsmPrimitiveType.RELATION, progressMonitor);
            if (this.outputDataSet != null) {
                this.outputDataSet.deleteInvisible();
            }
            DataSet dataSet = this.outputDataSet;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Set<Long> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

