/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.I18n;

public class ServerAccessPreference
implements PreferenceSetting {
    private OsmApiUrlInputPanel pnlApiUrlPreferences;
    private JTabbedPane tpServerPreferences;
    private AuthenticationPreferencesPanel pnlAuthPreferences;
    private ProxyPreferencesPanel pnlProxyPreferences;

    protected JScrollPane wrapVerticallyScrollablePanel(VerticallyScrollablePanel panel) {
        JScrollPane sp = new JScrollPane(panel);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        return sp;
    }

    protected JPanel buildTabbedServerPreferences() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.tpServerPreferences = new JTabbedPane();
        this.pnlAuthPreferences = new AuthenticationPreferencesPanel();
        this.tpServerPreferences.add(this.wrapVerticallyScrollablePanel(this.pnlAuthPreferences));
        this.pnlProxyPreferences = new ProxyPreferencesPanel();
        this.tpServerPreferences.add(this.wrapVerticallyScrollablePanel(this.pnlProxyPreferences));
        this.tpServerPreferences.setTitleAt(0, I18n.tr("Authentication"));
        this.tpServerPreferences.setTitleAt(1, I18n.tr("Proxy settings"));
        this.tpServerPreferences.setToolTipTextAt(0, I18n.tr("Configure your identity and how to authenticate at the OSM server"));
        this.tpServerPreferences.setToolTipTextAt(1, I18n.tr("Configure whether to use a proxy server"));
        pnl.add((Component)this.tpServerPreferences, "Center");
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        this.pnlApiUrlPreferences = new OsmApiUrlInputPanel();
        pnl.add((Component)this.pnlApiUrlPreferences, gc);
        gc.gridy = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(10, 0, 3, 3);
        pnl.add((Component)this.buildTabbedServerPreferences(), gc);
        this.pnlApiUrlPreferences.addPropertyChangeListener(this.pnlAuthPreferences);
        HelpUtil.setHelpContext(pnl, HelpUtil.ht("/Preferences/Connection"));
        return pnl;
    }

    public void addGui(PreferenceTabbedPane gui) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        gui.connection.add((Component)this.buildContentPanel(), gc);
        this.initFromPreferences();
    }

    public void initFromPreferences() {
        this.pnlApiUrlPreferences.initFromPreferences();
        this.pnlAuthPreferences.initFromPreferences();
        this.pnlProxyPreferences.initFromPreferences();
    }

    public boolean ok() {
        this.pnlApiUrlPreferences.saveToPreferences();
        this.pnlAuthPreferences.saveToPreferences();
        this.pnlProxyPreferences.saveToPreferences();
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

