/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AudioPreference
implements PreferenceSetting {
    private JCheckBox audioMenuVisible = new JCheckBox(I18n.tr("Display the Audio menu."));
    private JCheckBox markerButtonLabels = new JCheckBox(I18n.tr("Label audio (and image and web) markers."));
    private JCheckBox markerAudioTraceVisible = new JCheckBox(I18n.tr("Display live audio trace."));
    private JCheckBox audioMarkersFromExplicitWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with valid timestamps."));
    private JCheckBox audioMarkersFromUntimedWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with time estimated from track position."));
    private JCheckBox audioMarkersFromNamedTrackpoints = new JCheckBox(I18n.tr("Named trackpoints."));
    private JCheckBox audioMarkersFromWavTimestamps = new JCheckBox(I18n.tr("Modified times (time stamps) of audio files."));
    private JCheckBox audioMarkersFromStart = new JCheckBox(I18n.tr("Start of track (will always do this if no other markers available)."));
    private JTextField audioLeadIn = new JTextField(8);
    private JTextField audioForwardBackAmount = new JTextField(8);
    private JTextField audioFastForwardMultiplier = new JTextField(8);
    private JTextField audioCalibration = new JTextField(8);

    public void addGui(PreferenceTabbedPane gui) {
        this.audioMenuVisible.setSelected(!Main.pref.getBoolean("audio.menuinvisible"));
        this.audioMenuVisible.setToolTipText(I18n.tr("Show or hide the audio menu entry on the main menu bar."));
        gui.audio.add((Component)this.audioMenuVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerAudioTraceVisible.setSelected(Main.pref.getBoolean("marker.traceaudio", true));
        this.markerAudioTraceVisible.setToolTipText(I18n.tr("Display a moving icon representing the point on the synchronized track where the audio currently playing was recorded."));
        gui.audio.add((Component)this.markerAudioTraceVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerButtonLabels.setSelected(Main.pref.getBoolean("marker.buttonlabels"));
        this.markerButtonLabels.setToolTipText(I18n.tr("Put text labels against audio (and image and web) markers as well as their button icons."));
        gui.audio.add((Component)this.markerButtonLabels, GBC.eol().insets(0, 0, 0, 0));
        gui.audio.add((Component)new JLabel(I18n.tr("When importing audio, make markers from...")), GBC.eol());
        this.audioMarkersFromExplicitWaypoints.setSelected(Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true));
        this.audioMarkersFromExplicitWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer."));
        gui.audio.add((Component)this.audioMarkersFromExplicitWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromUntimedWaypoints.setSelected(Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true));
        this.audioMarkersFromUntimedWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer."));
        gui.audio.add((Component)this.audioMarkersFromUntimedWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromNamedTrackpoints.setSelected(Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false));
        this.audioMarkersFromNamedTrackpoints.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions."));
        gui.audio.add((Component)this.audioMarkersFromNamedTrackpoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromWavTimestamps.setSelected(Main.pref.getBoolean("marker.audiofromwavtimestamps", false));
        this.audioMarkersFromWavTimestamps.setToolTipText(I18n.tr("Create audio markers at the position on the track corresponding to the modified time of each audio WAV file imported."));
        gui.audio.add((Component)this.audioMarkersFromWavTimestamps, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromStart.setSelected(Main.pref.getBoolean("marker.audiofromstart"));
        this.audioMarkersFromStart.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions."));
        gui.audio.add((Component)this.audioMarkersFromStart, GBC.eol().insets(10, 0, 0, 0));
        this.audioForwardBackAmount.setText(Main.pref.get("audio.forwardbackamount", "10.0"));
        this.audioForwardBackAmount.setToolTipText(I18n.tr("The number of seconds to jump forward or back when the relevant button is pressed"));
        gui.audio.add((Component)new JLabel(I18n.tr("Forward/back time (seconds)")), GBC.std());
        gui.audio.add((Component)this.audioForwardBackAmount, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioFastForwardMultiplier.setText(Main.pref.get("audio.fastfwdmultiplier", "1.3"));
        this.audioFastForwardMultiplier.setToolTipText(I18n.tr("The amount by which the speed is multiplied for fast forwarding"));
        gui.audio.add((Component)new JLabel(I18n.tr("Fast forward multiplier")), GBC.std());
        gui.audio.add((Component)this.audioFastForwardMultiplier, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioLeadIn.setText(Main.pref.get("audio.leadin", "1.0"));
        this.audioLeadIn.setToolTipText(I18n.tr("Playback starts this number of seconds before (or after, if negative) the audio track position requested"));
        gui.audio.add((Component)new JLabel(I18n.tr("Lead-in time (seconds)")), GBC.std());
        gui.audio.add((Component)this.audioLeadIn, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioCalibration.setText(Main.pref.get("audio.calibration", "1.0"));
        this.audioCalibration.setToolTipText(I18n.tr("The ratio of voice recorder elapsed time to true elapsed time"));
        gui.audio.add((Component)new JLabel(I18n.tr("Voice recorder calibration")), GBC.std());
        gui.audio.add((Component)this.audioCalibration, GBC.eol().fill(2).insets(5, 0, 0, 5));
        gui.audio.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Main.pref.put("audio.menuinvisible", !this.audioMenuVisible.isSelected());
        Main.pref.put("marker.traceaudio", this.markerAudioTraceVisible.isSelected());
        Main.pref.put("marker.buttonlabels", this.markerButtonLabels.isSelected());
        Main.pref.put("marker.audiofromexplicitwaypoints", this.audioMarkersFromExplicitWaypoints.isSelected());
        Main.pref.put("marker.audiofromuntimedwaypoints", this.audioMarkersFromUntimedWaypoints.isSelected());
        Main.pref.put("marker.audiofromnamedtrackpoints", this.audioMarkersFromNamedTrackpoints.isSelected());
        Main.pref.put("marker.audiofromwavtimestamps", this.audioMarkersFromWavTimestamps.isSelected());
        Main.pref.put("marker.audiofromstart", this.audioMarkersFromStart.isSelected());
        Main.pref.put("audio.forwardbackamount", this.audioForwardBackAmount.getText());
        Main.pref.put("audio.fastfwdmultiplier", this.audioFastForwardMultiplier.getText());
        Main.pref.put("audio.leadin", this.audioLeadIn.getText());
        Main.pref.put("audio.calibration", this.audioCalibration.getText());
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AudioPreference();
        }
    }
}

