/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageLayer
extends Layer
implements PropertyChangeListener {
    List<ImageEntry> data;
    GpxLayer gpxLayer;
    private Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private int currentPhoto = -1;
    boolean useThumbs = false;
    ThumbsLoader thumbsloader;
    boolean thumbsLoaded = false;
    private BufferedImage offscreenBuffer;
    boolean updateOffscreenBuffer = true;
    private static List<Action> menuAdditions = new LinkedList<Action>();
    private MouseAdapter mouseAdapter = null;
    private MapFrame.MapModeChangeListener mapModeListener = null;

    public static void create(Collection<File> files, GpxLayer gpxLayer) {
        Loader loader = new Loader(files, gpxLayer);
        Main.worker.execute(loader);
    }

    private GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer) {
        super(I18n.tr("Geotagged Images"));
        Collections.sort(data);
        this.data = data;
        this.gpxLayer = gpxLayer;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage");
    }

    public static void registerMenuAddition(Action addition) {
        menuAdditions.add(addition);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> entries = new ArrayList<Action>();
        entries.add(LayerListDialog.getInstance().createShowHideLayerAction());
        entries.add(LayerListDialog.getInstance().createDeleteLayerAction());
        entries.add(new RenameLayerAction(null, this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new CorrelateGpxWithImages(this));
        if (!menuAdditions.isEmpty()) {
            entries.add(Layer.SeparatorLayerAction.INSTANCE);
            entries.addAll(menuAdditions);
        }
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new LayerListPopup.InfoAction(this));
        return entries.toArray(new Action[0]);
    }

    private String infoText() {
        int i = 0;
        for (ImageEntry e : this.data) {
            if (e.getPos() == null) continue;
            ++i;
        }
        return I18n.trn("{0} image loaded.", "{0} images loaded.", this.data.size(), this.data.size()) + " " + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", i, i);
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        GeoImageLayer l = (GeoImageLayer)from;
        ImageEntry selected = null;
        if (l.currentPhoto >= 0) {
            selected = l.data.get(l.currentPhoto);
        }
        this.data.addAll(l.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry prev = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry cur = this.data.get(i);
                if (cur.getFile().equals(prev.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                prev = cur;
            }
        }
        if (selected != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) != selected) continue;
                this.currentPhoto = i;
                ImageViewerDialog.showImage(this, this.data.get(i));
                break;
            }
        }
        this.setName(l.getName());
    }

    private Dimension scaledDimension(Image thumb) {
        double d = Main.map.mapView.getDist100Pixel();
        double size = 10.0;
        double s = 1000.0 / d;
        double sMin = 22.0;
        double sMax = 120.0;
        if (s < 22.0) {
            s = 22.0;
        }
        if (s > 120.0) {
            s = 120.0;
        }
        double f = s / 120.0;
        if (thumb == null) {
            return null;
        }
        return new Dimension((int)Math.round(f * (double)thumb.getWidth(null)), (int)Math.round(f * (double)thumb.getHeight(null)));
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        ImageEntry e;
        int width = Main.map.mapView.getWidth();
        int height = Main.map.mapView.getHeight();
        Rectangle clip = g.getClipBounds();
        if (this.useThumbs) {
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != width || this.offscreenBuffer.getHeight() != height) {
                this.offscreenBuffer = new BufferedImage(width, height, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                Graphics2D tempG = this.offscreenBuffer.createGraphics();
                tempG.setColor(new Color(0, 0, 0, 0));
                Composite saveComp = tempG.getComposite();
                tempG.setComposite(AlphaComposite.Clear);
                tempG.fillRect(0, 0, width, height);
                tempG.setComposite(saveComp);
                for (ImageEntry e2 : this.data) {
                    if (e2.getPos() == null) continue;
                    Point p = mv.getPoint(e2.getPos());
                    if (e2.thumbnail != null) {
                        Dimension d = this.scaledDimension(e2.thumbnail);
                        Rectangle target = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
                        if (!clip.intersects(target)) continue;
                        tempG.drawImage(e2.thumbnail, target.x, target.y, target.width, target.height, null);
                        continue;
                    }
                    this.icon.paintIcon(mv, tempG, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
                }
                this.updateOffscreenBuffer = false;
            }
            g.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            for (ImageEntry e3 : this.data) {
                if (e3.getPos() == null) continue;
                Point p = mv.getPoint(e3.getPos());
                this.icon.paintIcon(mv, g, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
            }
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size() && (e = this.data.get(this.currentPhoto)).getPos() != null) {
            Point p = mv.getPoint(e.getPos());
            if (e.thumbnail != null) {
                Dimension d = this.scaledDimension(e.thumbnail);
                g.setColor(new Color(128, 0, 0, 122));
                g.fillRect(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
            } else {
                if (e.getExifImgDir() != null) {
                    double arrowlength = 25.0;
                    double arrowwidth = 18.0;
                    double dir = e.getExifImgDir();
                    double headdir = dir < 90.0 ? dir + 270.0 : dir - 90.0;
                    double leftdir = headdir < 90.0 ? headdir + 270.0 : headdir - 90.0;
                    double rightdir = headdir > 270.0 ? headdir - 270.0 : headdir + 90.0;
                    double ptx = (double)p.x + Math.cos(Math.toRadians(headdir)) * arrowlength;
                    double pty = (double)p.y + Math.sin(Math.toRadians(headdir)) * arrowlength;
                    double ltx = (double)p.x + Math.cos(Math.toRadians(leftdir)) * arrowwidth / 2.0;
                    double lty = (double)p.y + Math.sin(Math.toRadians(leftdir)) * arrowwidth / 2.0;
                    double rtx = (double)p.x + Math.cos(Math.toRadians(rightdir)) * arrowwidth / 2.0;
                    double rty = (double)p.y + Math.sin(Math.toRadians(rightdir)) * arrowwidth / 2.0;
                    g.setColor(Color.white);
                    int[] xar = new int[]{(int)ltx, (int)ptx, (int)rtx, (int)ltx};
                    int[] yar = new int[]{(int)lty, (int)pty, (int)rty, (int)lty};
                    g.fillPolygon(xar, yar, 4);
                }
                this.selectedIcon.paintIcon(mv, g, p.x - this.selectedIcon.getIconWidth() / 2, p.y - this.selectedIcon.getIconHeight() / 2);
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data) {
            v.visit(e.getPos());
        }
    }

    private static void extractExif(ImageEntry e) {
        Metadata metadata = null;
        Directory dir = null;
        try {
            metadata = JpegMetadataReader.readMetadata(e.getFile());
            dir = metadata.getDirectory(GpsDirectory.class);
        }
        catch (CompoundException p) {
            e.setExifCoor(null);
            e.setPos(null);
            return;
        }
        try {
            Rational[] components = dir.getRationalArray(4);
            int deg = components[0].intValue();
            double min = components[1].floatValue();
            double sec = components[2].floatValue();
            double lon = (double)deg + min / 60.0 + sec / 3600.0;
            if (dir.getString(3).charAt(0) == 'W') {
                lon = -lon;
            }
            components = dir.getRationalArray(2);
            deg = components[0].intValue();
            min = components[1].floatValue();
            sec = components[2].floatValue();
            double lat = (double)deg + min / 60.0 + sec / 3600.0;
            if (dir.getString(1).charAt(0) == 'S') {
                lat = -lat;
            }
            e.setExifCoor(new LatLon(lat, lon));
            e.setPos(e.getExifCoor());
        }
        catch (CompoundException p) {
            try {
                Double longitude = dir.getDouble(4);
                Double latitude = dir.getDouble(2);
                if (longitude == null || latitude == null) {
                    throw new CompoundException("");
                }
                e.setExifCoor(new LatLon(latitude, longitude));
                e.setPos(e.getExifCoor());
            }
            catch (CompoundException ex) {
                e.setExifCoor(null);
                e.setPos(null);
            }
        }
        catch (Exception ex) {
            System.err.println("Error when reading EXIF from file: " + ex);
            e.setExifCoor(null);
            e.setPos(null);
        }
        Rational direction = null;
        try {
            direction = dir.getRational(17);
            if (direction != null) {
                e.setExifImgDir(direction.doubleValue());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && this.data.size() > 0) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void checkPreviousNextButtons() {
        ImageViewerDialog.setNextEnabled(this.currentPhoto < this.data.size() - 1);
        ImageViewerDialog.setPreviousEnabled(this.currentPhoto > 0);
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                ImageViewerDialog.showImage(this, null);
            }
            this.updateOffscreenBuffer = true;
            Main.map.repaint();
        }
    }

    public void removeCurrentPhotoFromDisk() {
        ImageEntry toDelete = null;
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            toDelete = this.data.get(this.currentPhoto);
            int result = new ExtendedDialog(Main.parent, I18n.tr("Delete image file from disk"), new String[]{I18n.tr("Cancel"), I18n.tr("Delete")}).setButtonIcons(new String[]{"cancel.png", "dialogs/delete.png"}).setContent(new JLabel(I18n.tr("<html><h3>Delete the file {0} from disk?<p>The image file will be permanently lost!</h3></html>", toDelete.getFile().getName()), ImageProvider.get("dialogs/geoimage/deletefromdisk"), 2)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
            if (result == 2) {
                this.data.remove(this.currentPhoto);
                if (this.currentPhoto >= this.data.size()) {
                    this.currentPhoto = this.data.size() - 1;
                }
                if (this.currentPhoto >= 0) {
                    ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
                } else {
                    ImageViewerDialog.showImage(this, null);
                }
                if (toDelete.getFile().delete()) {
                    System.out.println("File " + toDelete.getFile().toString() + " deleted. ");
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image file could not be deleted."), I18n.tr("Error"), 0);
                }
                this.updateOffscreenBuffer = true;
                Main.map.repaint();
            }
        }
    }

    private void hook_up_mouse_events() {
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() != 1) {
                    return;
                }
                if (!GeoImageLayer.this.isVisible()) {
                    return;
                }
                for (int i = GeoImageLayer.this.data.size() - 1; i >= 0; --i) {
                    Rectangle r;
                    ImageEntry e = GeoImageLayer.this.data.get(i);
                    if (e.getPos() == null) continue;
                    Point p = Main.map.mapView.getPoint(e.getPos());
                    if (e.thumbnail != null) {
                        Dimension d = GeoImageLayer.this.scaledDimension(e.thumbnail);
                        r = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
                    } else {
                        r = new Rectangle(p.x - GeoImageLayer.this.icon.getIconWidth() / 2, p.y - GeoImageLayer.this.icon.getIconHeight() / 2, GeoImageLayer.this.icon.getIconWidth(), GeoImageLayer.this.icon.getIconHeight());
                    }
                    if (!r.contains(ev.getPoint())) continue;
                    GeoImageLayer.this.currentPhoto = i;
                    ImageViewerDialog.showImage(GeoImageLayer.this, e);
                    Main.map.repaint();
                    break;
                }
            }
        };
        this.mapModeListener = new MapFrame.MapModeChangeListener(){

            public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
                if (newMapMode instanceof SelectAction) {
                    Main.map.mapView.addMouseListener(GeoImageLayer.this.mouseAdapter);
                } else {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, Main.map.mapMode);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                if (newLayer == GeoImageLayer.this) {
                    Main.map.selectSelectTool(false);
                }
            }

            public void layerAdded(Layer newLayer) {
            }

            public void layerRemoved(Layer oldLayer) {
                if (oldLayer == GeoImageLayer.this) {
                    if (GeoImageLayer.this.thumbsloader != null) {
                        GeoImageLayer.this.thumbsloader.stop = true;
                    }
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                    MapFrame.removeMapModeChangeListener(GeoImageLayer.this.mapModeListener);
                    GeoImageLayer.this.currentPhoto = -1;
                    GeoImageLayer.this.data.clear();
                    GeoImageLayer.this.data = null;
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("center".equals(evt.getPropertyName()) || "scale".equals(evt.getPropertyName())) {
            this.updateOffscreenBuffer = true;
        }
    }

    public void loadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded) {
            this.thumbsLoaded = true;
            this.thumbsloader = new ThumbsLoader(this);
            Thread t = new Thread(this.thumbsloader);
            t.setPriority(1);
            t.start();
        }
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    public List<ImageEntry> getImages() {
        ArrayList<ImageEntry> copy = new ArrayList<ImageEntry>();
        for (ImageEntry ie : this.data) {
            copy.add(ie.clone());
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean cancelled = false;
        private GeoImageLayer layer;
        private Collection<File> selection;
        private HashSet<String> loadedDirectories = new HashSet();
        private LinkedHashSet<String> errorMessages;
        private GpxLayer gpxLayer;

        protected void rememberError(String message) {
            this.errorMessages.add(message);
        }

        public Loader(Collection<File> selection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF"));
            this.selection = selection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet();
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan"));
            ArrayList<File> files = new ArrayList<File>();
            try {
                this.addRecursiveFiles(files, this.selection);
            }
            catch (NullPointerException npe) {
                this.rememberError(I18n.tr("One of the selected files was null"));
            }
            if (this.cancelled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos..."));
            this.progressMonitor.setTicksCount(files.size());
            this.progressMonitor.subTask(I18n.tr("Read photos..."));
            this.progressMonitor.setTicksCount(files.size());
            ArrayList<ImageEntry> data = new ArrayList<ImageEntry>(files.size());
            for (File f : files) {
                if (this.cancelled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", f.getName()));
                this.progressMonitor.worked(1);
                ImageEntry e = new ImageEntry();
                try {
                    e.setExifTime(ExifReader.readTime(f));
                }
                catch (ParseException e1) {
                    e.setExifTime(null);
                }
                e.setFile(f);
                GeoImageLayer.extractExif(e);
                data.add(e);
            }
            this.layer = new GeoImageLayer(data, this.gpxLayer);
            files.clear();
        }

        private void addRecursiveFiles(Collection<File> files, Collection<File> sel) {
            boolean nullFile = false;
            for (File f : sel) {
                if (this.cancelled) break;
                if (f == null) {
                    nullFile = true;
                    continue;
                }
                if (f.isDirectory()) {
                    String canonical = null;
                    try {
                        canonical = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", f.getAbsolutePath()));
                    }
                    if (canonical == null || this.loadedDirectories.contains(canonical)) continue;
                    this.loadedDirectories.add(canonical);
                    List<File> children = Arrays.asList(f.listFiles(JpegFileFilter.getInstance()));
                    if (children != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", f.getPath()));
                        try {
                            this.addRecursiveFiles(files, children);
                        }
                        catch (NullPointerException npe) {
                            npe.printStackTrace();
                            this.rememberError(I18n.tr("Found null file in directory {0}\n", f.getPath()));
                        }
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", f.getPath()));
                    continue;
                }
                files.add(f);
            }
            if (nullFile) {
                throw new NullPointerException();
            }
        }

        protected String formatErrorMessages() {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            if (this.errorMessages.size() == 1) {
                sb.append((String)this.errorMessages.iterator().next());
            } else {
                sb.append("<ul>");
                for (String msg : this.errorMessages) {
                    sb.append("<li>").append(msg).append("</li>");
                }
                sb.append("/ul>");
            }
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, this.formatErrorMessages(), I18n.tr("Error"), 0);
            }
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
                this.layer.hook_up_mouse_events();
                Main.map.mapView.addPropertyChangeListener(this.layer);
                if (Main.map.getToggleDialog(ImageViewerDialog.class) == null) {
                    ImageViewerDialog.newInstance();
                    Main.map.addToggleDialog(ImageViewerDialog.getInstance());
                }
                if (!this.cancelled && this.layer.data.size() > 0) {
                    boolean noGeotagFound = true;
                    for (ImageEntry e : this.layer.data) {
                        if (e.getPos() == null) continue;
                        noGeotagFound = false;
                    }
                    if (noGeotagFound) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }
    }
}

