/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderNode(HistoryBrowserModel.NodeListTableModel model, Long nodeId, int row, boolean isSelected) {
        String text = "";
        Color bgColor = Color.WHITE;
        if (nodeId == null) {
            text = "";
            bgColor = BGCOLOR_EMPTY_ROW;
            this.setIcon(null);
        } else {
            text = I18n.tr("Node {0}", nodeId.toString());
            this.setIcon(this.nodeIcon);
            bgColor = model.isSameInOppositeWay(row) ? Color.WHITE : (model.isInOppositeWay(row) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        if (isSelected) {
            bgColor = BGCOLOR_SELECTED;
        }
        this.setText(text);
        this.setBackground(bgColor);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        HistoryBrowserModel.NodeListTableModel model = this.getNodeListTableModel(table);
        Long nodeId = (Long)value;
        this.renderNode(model, nodeId, row, isSelected);
        return this;
    }

    protected HistoryBrowserModel.NodeListTableModel getNodeListTableModel(JTable table) {
        return (HistoryBrowserModel.NodeListTableModel)table.getModel();
    }
}

