/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class HistoryBrowserDialog
extends JDialog
implements HistoryDataSetListener {
    private HistoryBrowser browser;
    private CloseAction closeAction;

    protected void renderTitle(History h) {
        String title = "";
        switch (h.getEarliest().getType()) {
            case NODE: {
                title = I18n.marktr("History for node {0}");
                break;
            }
            case WAY: {
                title = I18n.marktr("History for way {0}");
                break;
            }
            case RELATION: {
                title = I18n.marktr("History for relation {0}");
            }
        }
        this.setTitle(I18n.tr(title, Long.toString(h.getId())));
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.browser = new HistoryBrowser();
        this.add((Component)this.browser, "Center");
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        SideButton btn = new SideButton(new ReloadAction());
        btn.setName("btn.reload");
        pnl.add(btn);
        this.closeAction = new CloseAction();
        btn = new SideButton(this.closeAction);
        btn.setName("btn.close");
        pnl.add(btn);
        btn = new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/History")));
        btn.setName("btn.help");
        pnl.add(btn);
        this.add((Component)pnl, "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/History"));
        this.setSize(800, 500);
    }

    public HistoryBrowserDialog(History history) {
        super(JOptionPane.getFrameForComponent(Main.parent), false);
        this.build();
        this.setHistory(history);
        this.renderTitle(history);
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        this.addWindowListener(new WindowClosingAdapter());
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    public void unlinkAsListener() {
        this.getHistoryBrowser().getModel().unlinkAsListener();
    }

    public void historyUpdated(HistoryDataSet source, PrimitiveId primitiveId) {
        if (primitiveId == null || primitiveId.equals(this.browser.getHistory().getPrimitmiveId())) {
            this.browser.populate(source.getHistory(this.browser.getHistory().getPrimitmiveId()));
        }
    }

    public void historyDataSetCleared(HistoryDataSet source) {
        this.closeAction.run();
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            HistoryBrowserDialog.this.closeAction.run();
        }
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reload the history from the server"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        public void actionPerformed(ActionEvent e) {
            HistoryLoadTask task = new HistoryLoadTask();
            task.add(HistoryBrowserDialog.this.browser.getHistory());
            Main.worker.submit(task);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", I18n.tr("Close"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void run() {
            HistoryBrowserDialog.this.getHistoryBrowser().getModel().unlinkAsListener();
            HistoryDataSet.getInstance().removeHistoryDataSetListener(HistoryBrowserDialog.this);
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }
}

