/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static JPanel pluginHook = new JPanel();
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem o1, AutoCompletionListItem o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
        }
    };
    private DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private HelpAction helpAction = new HelpAction();
    private AddAction addAction = new AddAction();
    private Shortcut addActionShortcut = Shortcut.registerShortcut("properties:add", I18n.tr("Add Properties"), 66, 6);
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    public JComboBox taggingPresets = new JComboBox();
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Please select the objects you want to change properties for.") + "</p></html>");
    private PresetListPanel.PresetHandler presetHandler = new PresetListPanel.PresetHandler(){

        @Override
        public void updateTags(List<Tag> tags) {
            Command command = TaggingPreset.createCommand(this.getSelection(), tags);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return null;
            }
            return Main.main.getCurrentDataSet().getSelected();
        }
    };

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        this.updateSelection();
        Main.registerActionShortcut((Action)this.addAction, this.addActionShortcut);
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
        Main.unregisterActionShortcut(this.addAction, this.addActionShortcut);
    }

    void propertyEdit(int row) {
        String newkey;
        String key;
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            return;
        }
        this.objKey = key = this.propertyData.getValueAt(row, 0).toString();
        String msg = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", sel.size(), sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", key) + ")</html>";
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(msg), "North");
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "Center");
        AutoCompletionManager autocomplete = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> keyList = autocomplete.getKeys();
        Collections.sort(keyList, this.defaultACItemComparator);
        AutoCompletingComboBox keys = new AutoCompletingComboBox();
        keys.setPossibleACItems(keyList);
        keys.setEditable(true);
        keys.setSelectedItem(key);
        p.add((Component)new JLabel(I18n.tr("Key")), GBC.std());
        p.add(Box.createHorizontalStrut(10), GBC.std());
        p.add((Component)keys, GBC.eol().fill(2));
        final AutoCompletingComboBox values = new AutoCompletingComboBox();
        values.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel) {
                    Map m;
                    String str = null;
                    str = ((AutoCompletionListItem)value).getValue();
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (m = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(str)) {
                        str = str + "(" + m.get(str) + ")";
                        c.setFont(c.getFont().deriveFont(3));
                    }
                    ((JLabel)c).setText(str);
                }
                return c;
            }
        });
        values.setEditable(true);
        List<AutoCompletionListItem> valueList = autocomplete.getValues(key);
        Collections.sort(valueList, this.defaultACItemComparator);
        values.setPossibleACItems(valueList);
        Map m = (Map)this.propertyData.getValueAt(row, 1);
        String selection = m.size() != 1 ? I18n.tr("<different>") : (String)m.entrySet().iterator().next().getKey();
        values.setSelectedItem(selection);
        values.getEditor().setItem(selection);
        p.add((Component)new JLabel(I18n.tr("Value")), GBC.std());
        p.add(Box.createHorizontalStrut(10), GBC.std());
        p.add((Component)values, GBC.eol().fill(2));
        this.addFocusAdapter(row, keys, values, autocomplete);
        final JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            public void selectInitialValue() {
                values.requestFocusInWindow();
                values.getEditor().selectAll();
            }
        };
        final JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        values.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                optionPane.setValue(0);
            }
        });
        String oldValue = values.getEditor().getItem().toString();
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            values.getEditor().setItem(oldValue);
            return;
        }
        String value = values.getEditor().getItem().toString().trim();
        if (value.equals("")) {
            value = null;
        }
        if ((newkey = keys.getEditor().getItem().toString().trim()).equals("")) {
            newkey = key;
            value = null;
        }
        if (key.equals(newkey) && I18n.tr("<different>").equals(value)) {
            return;
        }
        if (key.equals(newkey) || value == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, newkey, value));
        } else {
            Vector<Command> commands = new Vector<Command>();
            commands.add(new ChangePropertyCommand(sel, key, null));
            if (value.equals(I18n.tr("<different>"))) {
                HashMap map = new HashMap();
                for (OsmPrimitive osmPrimitive : sel) {
                    String val = osmPrimitive.get(key);
                    if (val == null) continue;
                    if (map.containsKey(val)) {
                        ((Vector)map.get(val)).add(osmPrimitive);
                        continue;
                    }
                    Vector<OsmPrimitive> v = new Vector<OsmPrimitive>();
                    v.add(osmPrimitive);
                    map.put(val, v);
                }
                for (Map.Entry entry : map.entrySet()) {
                    commands.add(new ChangePropertyCommand((Collection)entry.getValue(), newkey, (String)entry.getKey()));
                }
            } else {
                commands.add(new ChangePropertyCommand(sel, newkey, value));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", sel.size(), sel.size()), commands));
        }
        if (!key.equals(newkey)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (!this.propertyData.getValueAt(i, 0).toString().equals(newkey)) continue;
                row = i;
                break;
            }
        }
        this.propertyTable.changeSelection(row, 0, false, false);
    }

    void membershipEdit(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt((int)row, (int)1)).role).setVisible(true);
    }

    void add() {
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            return;
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", sel.size(), sel.size()) + "<br><br>" + I18n.tr("Please select a key")), "North");
        final AutoCompletingComboBox keys = new AutoCompletingComboBox();
        AutoCompletionManager autocomplete = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> keyList = autocomplete.getKeys();
        Iterator<AutoCompletionListItem> iter = keyList.iterator();
        block0: while (iter.hasNext()) {
            AutoCompletionListItem item = iter.next();
            for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
                if (!item.getValue().equals(this.propertyData.getValueAt(i, 0))) continue;
                iter.remove();
                continue block0;
            }
        }
        Collections.sort(keyList, this.defaultACItemComparator);
        keys.setPossibleACItems(keyList);
        keys.setEditable(true);
        p.add((Component)keys, "Center");
        JPanel p2 = new JPanel(new BorderLayout());
        p.add((Component)p2, "South");
        p2.add((Component)new JLabel(I18n.tr("Please select a value")), "North");
        AutoCompletingComboBox values = new AutoCompletingComboBox();
        values.setEditable(true);
        p2.add((Component)values, "Center");
        FocusAdapter focus = this.addFocusAdapter(-1, keys, values, autocomplete);
        focus.focusGained(null);
        JOptionPane pane = new JOptionPane(p, -1, 2){

            public void selectInitialValue() {
                keys.requestFocusInWindow();
                keys.getEditor().selectAll();
            }
        };
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr("Change values?"));
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return;
        }
        String key = keys.getEditor().getItem().toString().trim();
        String value = values.getEditor().getItem().toString().trim();
        if (value.equals("")) {
            return;
        }
        Main.main.undoRedo.add(new ChangePropertyCommand(sel, key, value));
        this.btnAdd.requestFocusInWindow();
    }

    private FocusAdapter addFocusAdapter(int row, final AutoCompletingComboBox keys, final AutoCompletingComboBox values, final AutoCompletionManager autocomplete) {
        JTextComponent editor = (JTextComponent)values.getEditor().getEditorComponent();
        FocusAdapter focus = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                String key = keys.getEditor().getItem().toString();
                List<AutoCompletionListItem> valueList = autocomplete.getValues(key);
                Collections.sort(valueList, PropertiesDialog.this.defaultACItemComparator);
                values.setPossibleACItems(valueList);
                PropertiesDialog.this.objKey = key;
            }
        };
        editor.addFocusListener(focus);
        return focus;
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships"), "propertiesdialog", I18n.tr("Properties for selected objects."), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships")), 80, 4, 1), 150, true);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent evt) {
                Point p = evt.getPoint();
                int row = PropertiesDialog.this.propertyTable.rowAtPoint(p);
                if (row > -1) {
                    PropertiesDialog.this.propertyTable.changeSelection(row, 0, false, false);
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(PropertiesDialog.this.helpAction);
                    menu.show(PropertiesDialog.this.propertyTable, p.x, p.y - 3);
                }
            }
        });
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (c instanceof JLabel) {
                    String str = null;
                    if (value instanceof String) {
                        str = (String)value;
                    } else if (value instanceof Map) {
                        Map v = (Map)value;
                        if (v.size() != 1) {
                            str = I18n.tr("<different>");
                            c.setFont(c.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = v.entrySet().iterator().next();
                            str = (String)entry.getKey();
                        }
                    }
                    ((JLabel)c).setText(str);
                }
                return c;
            }
        });
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of"), I18n.tr("Role"), I18n.tr("Position")});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent evt) {
                Point p = evt.getPoint();
                int row = PropertiesDialog.this.membershipTable.rowAtPoint(p);
                if (row > -1) {
                    PropertiesDialog.this.membershipTable.changeSelection(row, 0, false, false);
                    JPopupMenu menu = new JPopupMenu();
                    Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0);
                    menu.add(new SelectRelationAction(relation, true));
                    menu.add(new SelectRelationAction(relation, false));
                    menu.addSeparator();
                    menu.add(PropertiesDialog.this.helpAction);
                    menu.show(PropertiesDialog.this.membershipTable, p.x, p.y - 3);
                }
            }
        });
        TableColumnModel mod = this.membershipTable.getColumnModel();
        mod.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    Relation r = (Relation)value;
                    label.setText(r.getDisplayName(DefaultNameFormatter.getInstance()));
                    if (r.isDisabledAndHidden()) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    MemberInfo col = (MemberInfo)value;
                    String text = null;
                    for (RelationMember r : col.role) {
                        if (text == null) {
                            text = r.getRole();
                            continue;
                        }
                        if (text.equals(r.getRole())) continue;
                        text = I18n.tr("<different>");
                        break;
                    }
                    label.setText(text);
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    label.setText(((MemberInfo)table.getValueAt(row, 1)).getPositionString());
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setPreferredWidth(20);
        mod.getColumn(1).setPreferredWidth(40);
        mod.getColumn(0).setPreferredWidth(200);
        JPanel bothTables = new JPanel();
        boolean top = Main.pref.getBoolean("properties.presets.top", true);
        bothTables.setLayout(new GridBagLayout());
        if (top) {
            bothTables.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double epsilon = Double.MIN_VALUE;
            bothTables.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(epsilon, epsilon));
        }
        bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        bothTables.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        bothTables.add((Component)this.propertyTable, GBC.eol().fill(1));
        bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!top) {
            bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        DblClickWatch dblClickWatch = new DblClickWatch();
        this.propertyTable.addMouseListener(dblClickWatch);
        this.membershipTable.addMouseListener(dblClickWatch);
        JScrollPane scrollPane = new JScrollPane(bothTables);
        scrollPane.addMouseListener(dblClickWatch);
        this.add((Component)scrollPane, "Center");
        this.selectSth.setPreferredSize(scrollPane.getSize());
        this.presets.setSize(scrollPane.getSize());
        JPanel buttonPanel = this.getButtonPanel(3);
        this.btnAdd = new SideButton(this.addAction);
        this.btnAdd.setFocusable(true);
        buttonPanel.add(this.btnAdd);
        this.btnAdd.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "onEnter");
        this.btnAdd.getActionMap().put("onEnter", this.addAction);
        EditAction editAction = new EditAction();
        this.propertyTable.getSelectionModel().addListSelectionListener(editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(editAction);
        this.btnEdit = new SideButton(editAction);
        buttonPanel.add(this.btnEdit);
        DeleteAction deleteAction = new DeleteAction();
        this.btnDel = new SideButton(deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteAction);
        buttonPanel.add(this.btnDel);
        this.add((Component)buttonPanel, "South");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    private int findRow(TableModel model, Object value) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(value)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        int selectedIndex;
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        String selectedTag = null;
        Relation selectedRelation = null;
        if (this.propertyTable.getSelectedRowCount() == 1) {
            selectedTag = (String)this.propertyData.getValueAt(this.propertyTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            selectedRelation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.propertyData.setRowCount(0);
        int nodes = 0;
        int ways = 0;
        int relations = 0;
        int closedways = 0;
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
        this.valueCount.clear();
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (osmPrimitive instanceof Node) {
                ++nodes;
            } else if (osmPrimitive instanceof Relation) {
                ++relations;
            } else if (((Way)osmPrimitive).isClosed()) {
                ++closedways;
            } else {
                ++ways;
            }
            for (String key : osmPrimitive.keySet()) {
                Map<Object, Object> v;
                String value = osmPrimitive.get(key);
                keyCount.put(key, keyCount.containsKey(key) ? (Integer)keyCount.get(key) + 1 : 1);
                if (this.valueCount.containsKey(key)) {
                    v.put(value, (v = this.valueCount.get(key)).containsKey(value) ? (Integer)v.get(value) + 1 : 1);
                    continue;
                }
                v = new TreeMap<String, Integer>();
                ((TreeMap)v).put(value, 1);
                this.valueCount.put(key, v);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var11_17;
            boolean bl = false;
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                var11_17 += ((Integer)e1.getValue()).intValue();
            }
            if (var11_17 < newSelection.size()) {
                ((Map)entry.getValue()).put("", newSelection.size() - var11_17);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, MemberInfo> roles = new HashMap<Relation, MemberInfo>();
        for (OsmPrimitive osmPrimitive : newSelection) {
            for (OsmPrimitive ref : osmPrimitive.getReferrers()) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                Relation r = (Relation)ref;
                MemberInfo mi = (MemberInfo)roles.get(r);
                if (mi == null) {
                    mi = new MemberInfo();
                }
                roles.put(r, mi);
                int i = 1;
                for (RelationMember m : r.getMembers()) {
                    if (m.getMember() == osmPrimitive) {
                        mi.add(m, i);
                    }
                    ++i;
                }
            }
        }
        ArrayList arrayList = new ArrayList(roles.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation o1, Relation o2) {
                int comp = Boolean.valueOf(o1.isDisabledAndHidden()).compareTo(o2.isDisabledAndHidden());
                if (comp == 0) {
                    comp = o1.getDisplayName(DefaultNameFormatter.getInstance()).compareTo(o2.getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return comp;
            }
        });
        for (Relation r : arrayList) {
            this.membershipData.addRow(new Object[]{r, roles.get(r)});
        }
        this.presets.updatePresets(nodes, ways, relations, closedways, this.valueCount, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !newSelection.isEmpty();
        boolean hasTags = bl && this.propertyData.getRowCount() > 0;
        boolean hasMemberships = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(hasTags || hasMemberships);
        this.btnDel.setEnabled(hasTags || hasMemberships);
        this.propertyTable.setVisible(hasTags);
        this.propertyTable.getTableHeader().setVisible(hasTags);
        this.selectSth.setVisible(!bl);
        pluginHook.setVisible(bl);
        if (selectedTag != null && (selectedIndex = this.findRow(this.propertyData, selectedTag)) != -1) {
            this.propertyTable.changeSelection(selectedIndex, 0, false, false);
        } else if (selectedRelation != null && (selectedIndex = this.findRow(this.membershipData, selectedRelation)) != -1) {
            this.membershipTable.changeSelection(selectedIndex, 0, false, false);
        } else if (hasTags) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships"));
        }
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateSelection();
    }

    static class SelectRelationAction
    extends AbstractAction {
        boolean selectionmode;
        Relation relation;

        public SelectRelationAction(Relation r, boolean select) {
            this.selectionmode = select;
            this.relation = r;
            if (select) {
                this.putValue("Name", I18n.tr("Select relation"));
                this.putValue("ShortDescription", I18n.tr("Select relation in main selection."));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            } else {
                this.putValue("Name", I18n.tr("Select in relation list"));
                this.putValue("ShortDescription", I18n.tr("Select relation in relation list."));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "relationlist"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.selectionmode) {
                Main.map.mapView.getEditLayer().data.setSelected(this.relation);
            } else {
                Main.map.relationListDialog.selectRelation(this.relation);
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help (F1)"));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help to selected object"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String base = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String lang = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> uris = new ArrayList<URI>();
                if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.propertyTable.getSelectedRow();
                    String key = URLEncoder.encode(PropertiesDialog.this.propertyData.getValueAt(row, 0).toString(), "UTF-8");
                    String val = URLEncoder.encode((String)((Map)PropertiesDialog.this.propertyData.getValueAt(row, 1)).entrySet().iterator().next().getKey(), "UTF-8");
                    uris.add(new URI(String.format("%s%sTag:%s=%s", base, lang, key, val)));
                    uris.add(new URI(String.format("%sTag:%s=%s", base, key, val)));
                    uris.add(new URI(String.format("%s%sKey:%s", base, lang, key)));
                    uris.add(new URI(String.format("%sKey:%s", base, key)));
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String type = URLEncoder.encode(((Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0)).get("type"), "UTF-8");
                    if (type != null && !type.equals("")) {
                        uris.add(new URI(String.format("%s%sRelation:%s", base, lang, type)));
                        uris.add(new URI(String.format("%sRelation:%s", base, type)));
                    }
                    uris.add(new URI(String.format("%s%sRelations", base, lang)));
                    uris.add(new URI(String.format("%sRelations", base)));
                } else {
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                }
                Main.worker.execute(new Runnable(){

                    public void run() {
                        try {
                            for (URI u : uris) {
                                HttpURLConnection conn = (HttpURLConnection)u.toURL().openConnection();
                                conn.setConnectTimeout(5000);
                                if (conn.getResponseCode() != 200) {
                                    System.out.println("INFO: " + u + " does not exist");
                                    conn.disconnect();
                                    continue;
                                }
                                int osize = conn.getContentLength();
                                conn.disconnect();
                                conn = (HttpURLConnection)new URI(u.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL().openConnection();
                                conn.setConnectTimeout(5000);
                                if (Math.abs(conn.getContentLength() - osize) > 200) {
                                    System.out.println("INFO: " + u + " is a mediawiki redirect");
                                    conn.disconnect();
                                    continue;
                                }
                                System.out.println("INFO: browsing to " + u);
                                conn.disconnect();
                                OpenBrowser.displayUrl(u.toString());
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the value of the selected key for all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                int row = PropertiesDialog.this.propertyTable.getSelectedRow();
                PropertiesDialog.this.propertyEdit(row);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.membershipEdit(row);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1 ^ PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
            this.putValue("ShortDescription", I18n.tr("Add a new key/value pair to all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesDialog.this.add();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        protected void deleteProperty(int row) {
            String key = PropertiesDialog.this.propertyData.getValueAt(row, 0).toString();
            String nextKey = null;
            int rowCount = PropertiesDialog.this.propertyData.getRowCount();
            if (rowCount > 1) {
                nextKey = (String)PropertiesDialog.this.propertyData.getValueAt(row + 1 < rowCount ? row + 1 : row - 1, 0);
            }
            Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, key, null));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (nextKey != null) {
                PropertiesDialog.this.propertyTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.propertyData, nextKey), 0, false, false);
            }
        }

        protected void deleteFromRelation(int row) {
            Relation cur = (Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0);
            Relation nextRelation = null;
            int rowCount = PropertiesDialog.this.membershipTable.getRowCount();
            if (rowCount > 1) {
                nextRelation = (Relation)PropertiesDialog.this.membershipData.getValueAt(row + 1 < rowCount ? row + 1 : row - 1, 0);
            }
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Change relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
            ed.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            ed.setContent(I18n.tr("Really delete selection from relation {0}?", cur.getDisplayName(DefaultNameFormatter.getInstance())));
            ed.showDialog();
            if (ed.getValue() != 1) {
                return;
            }
            Relation rel = new Relation(cur);
            Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive primitive : sel) {
                rel.removeMembersFor(primitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(cur, rel));
            PropertiesDialog.this.propertyTable.clearSelection();
            if (nextRelation != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, nextRelation), 0, false, false);
            }
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected key in all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            Shortcut s = Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties"), 81, 6);
            this.putValue("MnemonicKey", KeyEvent.getKeyText(s.getAssignedKey()).charAt(0));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int row = PropertiesDialog.this.propertyTable.getSelectedRow();
                this.deleteProperty(row);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                this.deleteFromRelation(row);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0 || PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class MemberInfo {
        List<RelationMember> role = new ArrayList<RelationMember>();
        List<Integer> position = new ArrayList<Integer>();
        private String positionString = null;

        MemberInfo() {
        }

        void add(RelationMember r, Integer p) {
            this.role.add(r);
            this.position.add(p);
        }

        String getPositionString() {
            if (this.positionString == null) {
                Collections.sort(this.position);
                this.positionString = String.valueOf(this.position.get(0));
                int cnt = 0;
                int last = this.position.get(0);
                for (int i = 1; i < this.position.size(); ++i) {
                    int cur = this.position.get(i);
                    if (cur == last + 1) {
                        ++cnt;
                    } else {
                        if (cnt == 1) {
                            this.positionString = this.positionString + "," + String.valueOf(last);
                        } else if (cnt > 1) {
                            this.positionString = this.positionString + "-" + String.valueOf(last);
                        }
                        this.positionString = this.positionString + "-" + String.valueOf(cur);
                        cnt = 0;
                    }
                    last = cur;
                }
                if (cnt == 1) {
                    this.positionString = this.positionString + "," + String.valueOf(last);
                } else if (cnt > 1) {
                    this.positionString = this.positionString + "-" + String.valueOf(last);
                }
            }
            if (this.positionString.length() > 20) {
                this.positionString = this.positionString.substring(0, 17) + "...";
            }
            return this.positionString;
        }
    }

    public class DblClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (e.getSource() == PropertiesDialog.this.propertyTable) {
                int row = PropertiesDialog.this.propertyTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.propertyEdit(row);
                }
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                int row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.membershipEdit(row);
                }
            } else {
                PropertiesDialog.this.add();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == PropertiesDialog.this.propertyTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.propertyTable.clearSelection();
            }
        }
    }
}

