/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.InspectPrimitiveDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectionListDialog
extends ToggleDialog {
    private static final Logger logger = Logger.getLogger(SelectionListDialog.class.getName());
    private JList lstPrimitives;
    private SelectionListModel model;
    private SelectAction actSelect;
    private SearchAction actSearch;
    private ZoomToJOSMSelectionAction actZoomToJOSMSelection;
    private ZoomToListSelection actZoomToListSelection;
    private SetRelationSelection actSetRelationSelection;
    private EditRelationSelection actEditRelationSelection;
    private DownloadSelectedIncompleteMembersAction actDownloadSelectedIncompleteMembers;
    private InspectAction actInspect;

    protected JPanel buildListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new SelectionListModel(selectionModel);
        this.lstPrimitives = new JList(this.model);
        this.lstPrimitives.setSelectionMode(2);
        this.lstPrimitives.setSelectionModel(selectionModel);
        this.lstPrimitives.setCellRenderer(new OsmPrimitivRenderer());
        pnl.add((Component)new JScrollPane(this.lstPrimitives), "Center");
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridLayout(1, 2));
        this.actSelect = new SelectAction();
        final SideButton selectButton = new SideButton(this.actSelect);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSelect);
        pnl.add(selectButton);
        BasicArrowButton selectionHistoryMenuButton = this.createArrowButton(selectButton);
        selectionHistoryMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionHistoryPopup.launch(selectButton, SelectionListDialog.this.model.getSelectionHistory());
            }
        });
        this.actSearch = new SearchAction();
        final SideButton searchButton = new SideButton(this.actSearch);
        pnl.add(searchButton);
        BasicArrowButton searchHistoryMenuButton = this.createArrowButton(searchButton);
        searchHistoryMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPopupMenu.launch(searchButton);
            }
        });
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildListPanel(), "Center");
        pnl.add((Component)this.buildActionPanel(), "South");
        return pnl;
    }

    public SelectionListDialog() {
        super(I18n.tr("Current Selection"), "selectionlist", I18n.tr("Open a selection list window."), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection")), 84, 4, 1), 150, true);
        this.add((Component)this.buildContentPanel(), "Center");
        this.model.addListDataListener(new TitleUpdater());
        this.actZoomToJOSMSelection = new ZoomToJOSMSelectionAction();
        this.model.addListDataListener(this.actZoomToJOSMSelection);
        this.actZoomToListSelection = new ZoomToListSelection();
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actZoomToListSelection);
        this.actSetRelationSelection = new SetRelationSelection();
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSetRelationSelection);
        this.actEditRelationSelection = new EditRelationSelection();
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actEditRelationSelection);
        this.actDownloadSelectedIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actDownloadSelectedIncompleteMembers);
        this.actInspect = new InspectAction();
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actInspect);
        this.lstPrimitives.addMouseListener(new SelectionPopupMenuLauncher());
        this.lstPrimitives.addMouseListener(new DblClickHandler());
    }

    public void showNotify() {
        MapView.addEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().addSelectionListener(this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        DatasetEventManager.getInstance().addDatasetListener(this.model, DatasetEventManager.FireMode.IN_EDT);
        MapView.addEditLayerChangeListener(this.actSearch);
        if (Main.map.mapView.getEditLayer() != null) {
            this.model.setJOSMSelection(Main.map.mapView.getEditLayer().data.getSelected());
        }
        this.actSearch.updateEnabledState();
    }

    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this.actSearch);
        MapView.removeEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().removeSelectionListener(this.model);
        DatasetEventManager.getInstance().removeDatasetListener(this.model);
    }

    private BasicArrowButton createArrowButton(JButton parentButton) {
        BasicArrowButton arrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        parentButton.setLayout(new BorderLayout());
        parentButton.add((Component)arrowButton, "East");
        return arrowButton;
    }

    public void clearSelectionHistory() {
        this.model.clearSelectionHistory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OsmPrimitiveComparator
    implements Comparator<OsmPrimitive> {
        private final HashMap<OsmPrimitive, String> cache = new HashMap();
        private final DefaultNameFormatter df = DefaultNameFormatter.getInstance();

        private OsmPrimitiveComparator() {
        }

        private String cachedName(OsmPrimitive p) {
            String name = this.cache.get(p);
            if (name == null) {
                name = p.getDisplayName(this.df);
                this.cache.put(p, name);
            }
            return name;
        }

        private int compareName(OsmPrimitive a, OsmPrimitive b) {
            String an = this.cachedName(a);
            String bn = this.cachedName(b);
            if (Character.isDigit(an.charAt(0)) && Character.isDigit(bn.charAt(0))) {
                return an.compareTo(bn);
            }
            if (Character.isDigit(an.charAt(0)) && !Character.isDigit(bn.charAt(0))) {
                return 1;
            }
            if (!Character.isDigit(an.charAt(0)) && Character.isDigit(bn.charAt(0))) {
                return -1;
            }
            return an.compareTo(bn);
        }

        private int compareType(OsmPrimitive a, OsmPrimitive b) {
            if (a.getType().equals((Object)b.getType())) {
                return 0;
            }
            if (a.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return -1;
            }
            if (a.getType().equals((Object)OsmPrimitiveType.NODE)) {
                return 1;
            }
            if (b.getType().equals((Object)OsmPrimitiveType.WAY)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(OsmPrimitive a, OsmPrimitive b) {
            if (a.getType().equals((Object)b.getType())) {
                return this.compareName(a, b);
            }
            return this.compareType(a, b);
        }
    }

    class InspectAction
    extends AbstractAction
    implements ListSelectionListener {
        public InspectAction() {
            this.putValue("ShortDescription", I18n.tr("Get detailed information on the internal state of the objects."));
            this.putValue("Name", I18n.tr("Inspect"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty()) {
                return;
            }
            InspectPrimitiveDialog inspectDialog = new InspectPrimitiveDialog(sel);
            inspectDialog.showDialog();
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadSelectedIncompleteMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members"));
            this.updateEnabledState();
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(List<Relation> rels) {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (Relation r : rels) {
                ret.addAll(r.getIncompleteMembers());
            }
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> rels = SelectionListDialog.this.model.getSelectedRelationsWithIncompleteMembers();
            if (rels.isEmpty()) {
                return;
            }
            Main.worker.submit(new DownloadRelationMemberTask(rels, this.buildSetOfIncompleteMembers(rels), Main.map.mapView.getEditLayer()));
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelectedRelationsWithIncompleteMembers().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionHistoryPopup
    extends JPopupMenu {
        public static void launch(Component parent, Collection<Collection<? extends OsmPrimitive>> history) {
            if (history == null || history.isEmpty()) {
                return;
            }
            SelectionHistoryPopup menu = new SelectionHistoryPopup(history);
            Rectangle r = parent.getBounds();
            menu.show(parent, r.x, r.y + r.height);
        }

        public SelectionHistoryPopup(Collection<Collection<? extends OsmPrimitive>> history) {
            for (Collection<? extends OsmPrimitive> sel : history) {
                this.add(new SelectionMenuItem(sel));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        private final DefaultNameFormatter df = DefaultNameFormatter.getInstance();
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> sel) {
            this.sel = sel;
            int ways = 0;
            int nodes = 0;
            int relations = 0;
            for (OsmPrimitive osmPrimitive : sel) {
                if (osmPrimitive instanceof Way) {
                    ++ways;
                    continue;
                }
                if (osmPrimitive instanceof Node) {
                    ++nodes;
                    continue;
                }
                if (!(osmPrimitive instanceof Relation)) continue;
                ++relations;
            }
            StringBuffer text = new StringBuffer();
            if (ways != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} way", "{0} ways", ways, ways));
            }
            if (nodes != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} node", "{0} nodes", nodes, nodes));
            }
            if (relations != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} relation", "{0} relations", relations, relations));
            }
            if (ways + nodes + relations == 1) {
                text.append(": ");
                for (OsmPrimitive osmPrimitive : sel) {
                    text.append(osmPrimitive.getDisplayName(this.df));
                }
                this.setText(text.toString());
            } else {
                this.setText(I18n.tr("Selection: {0}", text));
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }

    protected static class SearchPopupMenu
    extends JPopupMenu {
        public static void launch(Component parent) {
            if (org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory().isEmpty()) {
                return;
            }
            SearchPopupMenu menu = new SearchPopupMenu();
            Rectangle r = parent.getBounds();
            menu.show(parent, r.x, r.y + r.height);
        }

        public SearchPopupMenu() {
            for (SearchAction.SearchSetting ss : org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory()) {
                this.add(new SearchMenuItem(ss));
            }
        }
    }

    protected static class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected final SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting s) {
            super(s.toString());
            this.s = s;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(this.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectionListModel
    extends AbstractListModel
    implements MapView.EditLayerChangeListener,
    SelectionChangedListener,
    DataSetListener {
        private static final int SELECTION_HISTORY_SIZE = 10;
        private final LinkedList<Collection<? extends OsmPrimitive>> history = new LinkedList();
        private final List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        private DefaultListSelectionModel selectionModel;

        public SelectionListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public String getJOSMSelectionSummary() {
            if (this.selection.isEmpty()) {
                return I18n.tr("Selection");
            }
            int numNodes = 0;
            int numWays = 0;
            int numRelations = 0;
            for (OsmPrimitive p : this.selection) {
                switch (p.getType()) {
                    case NODE: {
                        ++numNodes;
                        break;
                    }
                    case WAY: {
                        ++numWays;
                        break;
                    }
                    case RELATION: {
                        ++numRelations;
                    }
                }
            }
            return I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", numRelations, numWays, numNodes);
        }

        public void remember(Collection<? extends OsmPrimitive> selection) {
            if (selection == null) {
                return;
            }
            if (selection.isEmpty()) {
                return;
            }
            if (this.history.isEmpty()) {
                this.history.add(selection);
                return;
            }
            if (((Object)this.history.getFirst()).equals(selection)) {
                return;
            }
            this.history.addFirst(selection);
            for (int i = 1; i < this.history.size(); ++i) {
                if (!((Object)this.history.get(i)).equals(selection)) continue;
                this.history.remove(i);
                break;
            }
            int maxsize = Main.pref.getInteger("select.history-size", 10);
            while (this.history.size() > maxsize) {
                this.history.removeLast();
            }
        }

        public List<Collection<? extends OsmPrimitive>> getSelectionHistory() {
            return this.history;
        }

        public void clearSelectionHistory() {
            this.history.clear();
        }

        @Override
        public Object getElementAt(int index) {
            return this.selection.get(index);
        }

        @Override
        public int getSize() {
            return this.selection.size();
        }

        public Collection<OsmPrimitive> getSelected() {
            HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                sel.add(this.selection.get(i));
            }
            return sel;
        }

        public Collection<OsmPrimitive> getAllElements() {
            return this.selection;
        }

        public void setSelected(Collection<OsmPrimitive> sel) {
            this.selectionModel.clearSelection();
            if (sel == null) {
                return;
            }
            for (OsmPrimitive p : sel) {
                int i = this.selection.indexOf(p);
                if (i < 0) continue;
                this.selectionModel.addSelectionInterval(i, i);
            }
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            Collection<OsmPrimitive> sel = this.getSelected();
            super.fireContentsChanged(source, index0, index1);
            this.setSelected(sel);
        }

        public void setJOSMSelection(Collection<? extends OsmPrimitive> selection) {
            this.selection.clear();
            if (selection == null) {
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            this.selection.addAll(selection);
            this.sort();
            this.fireContentsChanged(this, 0, this.getSize());
            this.remember(selection);
        }

        public void update(Collection<? extends OsmPrimitive> toUpdate) {
            if (toUpdate == null) {
                return;
            }
            if (toUpdate.isEmpty()) {
                return;
            }
            Collection<OsmPrimitive> sel = this.getSelected();
            for (OsmPrimitive osmPrimitive : toUpdate) {
                int i = this.selection.indexOf(osmPrimitive);
                if (i < 0) continue;
                super.fireContentsChanged(this, i, i);
            }
            this.setSelected(sel);
        }

        public List<Relation> getSelectedRelationsWithIncompleteMembers() {
            LinkedList<Relation> ret = new LinkedList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                Relation r;
                OsmPrimitive p;
                if (!this.selectionModel.isSelectedIndex(i) || !((p = this.selection.get(i)) instanceof Relation) || p.isNew() || !(r = (Relation)p).hasIncompleteMembers()) continue;
                ret.add(r);
            }
            return ret;
        }

        public void sort() {
            Collections.sort(this.selection, new OsmPrimitiveComparator());
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            if (newLayer == null) {
                this.setJOSMSelection(null);
            } else {
                this.setJOSMSelection(newLayer.data.getSelected());
            }
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            this.setJOSMSelection(newSelection);
        }

        @Override
        public void dataChanged(DataChangedEvent event) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void nodeMoved(NodeMovedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void relationMembersChanged(RelationMembersChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void tagsChanged(TagsChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void wayNodesChanged(WayNodesChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void primtivesAdded(PrimitivesAddedEvent event) {
        }

        @Override
        public void primtivesRemoved(PrimitivesRemovedEvent event) {
        }
    }

    class SetRelationSelection
    extends AbstractAction
    implements ListSelectionListener {
        public SetRelationSelection() {
            this.putValue("Name", I18n.tr("Select in relation list"));
            this.putValue("ShortDescription", I18n.tr("Select relation in relation list."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "selectionlist"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Relation relation = (Relation)SelectionListDialog.this.model.getSelected().toArray()[0];
            Main.map.relationListDialog.selectRelation(relation);
        }

        public void updateEnabledState() {
            Object[] sel = SelectionListDialog.this.model.getSelected().toArray();
            this.setEnabled(sel.length == 1 && sel[0] instanceof Relation);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class EditRelationSelection
    extends SetRelationSelection {
        public EditRelationSelection() {
            this.putValue("Name", I18n.tr("Call editor for relation"));
            this.putValue("ShortDescription", I18n.tr("Call relation editor for selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Relation relation = (Relation)SelectionListDialog.this.model.getSelected().toArray()[0];
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            Collection<OsmPrimitive> selection = SelectionListDialog.this.model.getAllElements();
            for (RelationMember member : relation.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
            Main.map.relationListDialog.selectRelation(relation);
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, members).setVisible(true);
        }
    }

    class ZoomToListSelection
    extends AbstractAction
    implements ListSelectionListener {
        public ZoomToListSelection() {
            this.putValue("Name", I18n.tr("Zoom to selected element(s)"));
            this.putValue("ShortDescription", I18n.tr("Zoom to selected element(s)"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            BoundingXYVisitor box = new BoundingXYVisitor();
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty()) {
                return;
            }
            box.computeBoundingBox(sel);
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(box);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ZoomToJOSMSelectionAction
    extends AbstractAction
    implements ListDataListener {
        public ZoomToJOSMSelectionAction() {
            this.putValue("Name", I18n.tr("Zoom to selection"));
            this.putValue("ShortDescription", I18n.tr("Zoom to selection"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            AutoScaleAction.autoScale("selection");
        }

        public void updateEnabledState() {
            this.setEnabled(SelectionListDialog.this.model.getSize() > 0);
        }

        public void contentsChanged(ListDataEvent e) {
            this.updateEnabledState();
        }

        public void intervalAdded(ListDataEvent e) {
            this.updateEnabledState();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Set the selected elements on the map to the selected items in the list above."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty()) {
                return;
            }
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getEditLayer() == null) {
                return;
            }
            Main.map.mapView.getEditLayer().data.setSelected(sel);
        }

        public void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class SearchAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search"));
            this.putValue("ShortDescription", I18n.tr("Search for objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            org.openstreetmap.josm.actions.search.SearchAction.search();
        }

        public void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class TitleUpdater
    implements ListDataListener {
        TitleUpdater() {
        }

        protected void updateTitle() {
            SelectionListDialog.this.setTitle(SelectionListDialog.this.model.getJOSMSelectionSummary());
        }

        public void contentsChanged(ListDataEvent e) {
            this.updateTitle();
        }

        public void intervalAdded(ListDataEvent e) {
            this.updateTitle();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.updateTitle();
        }
    }

    class SelectionPopup
    extends JPopupMenu {
        public SelectionPopup() {
            this.add(SelectionListDialog.this.actZoomToJOSMSelection);
            this.add(SelectionListDialog.this.actZoomToListSelection);
            this.addSeparator();
            this.add(SelectionListDialog.this.actSetRelationSelection);
            this.add(SelectionListDialog.this.actEditRelationSelection);
            this.addSeparator();
            this.add(SelectionListDialog.this.actDownloadSelectedIncompleteMembers);
            this.addSeparator();
            this.add(SelectionListDialog.this.actInspect);
        }
    }

    class SelectionPopupMenuLauncher
    extends PopupMenuLauncher {
        private SelectionPopup popup;

        SelectionPopupMenuLauncher() {
            this.popup = new SelectionPopup();
        }

        public void launch(MouseEvent evt) {
            if (SelectionListDialog.this.model.getSelected().isEmpty()) {
                int idx = SelectionListDialog.this.lstPrimitives.locationToIndex(evt.getPoint());
                if (idx < 0) {
                    return;
                }
                SelectionListDialog.this.model.setSelected(Collections.singleton((OsmPrimitive)SelectionListDialog.this.model.getElementAt(idx)));
            }
            this.popup.show(SelectionListDialog.this.lstPrimitives, evt.getX(), evt.getY());
        }
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2 || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int idx = SelectionListDialog.this.lstPrimitives.locationToIndex(e.getPoint());
            if (idx < 0) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            layer.data.setSelected(Collections.singleton((OsmPrimitive)SelectionListDialog.this.model.getElementAt(idx)));
        }
    }
}

