/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.tools.I18n;

public class MultiValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JComboBox editor;
    private DefaultComboBoxModel editorModel = new DefaultComboBoxModel();
    private CopyOnWriteArrayList<NavigationListener> listeners;

    public void addNavigationListeners(NavigationListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeavigationListeners(NavigationListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireGotoNextDecision() {
        for (NavigationListener l : this.listeners) {
            l.gotoNextDecision();
        }
    }

    protected void fireGotoPreviousDecision() {
        for (NavigationListener l : this.listeners) {
            l.gotoPreviousDecision();
        }
    }

    public MultiValueCellEditor() {
        this.editor = new JComboBox(this.editorModel){

            public void processKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && e.getKeyCode() == 10) {
                    MultiValueCellEditor.this.fireGotoNextDecision();
                }
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        MultiValueCellEditor.this.fireGotoPreviousDecision();
                    } else {
                        MultiValueCellEditor.this.fireGotoNextDecision();
                    }
                } else if (e.getID() == 401 && e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                    if (MultiValueCellEditor.this.editorModel.getIndexOf((Object)MultiValueDecisionType.KEEP_NONE) > 0) {
                        MultiValueCellEditor.this.editorModel.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                        MultiValueCellEditor.this.fireGotoNextDecision();
                    }
                } else if (e.getID() == 401 && e.getKeyCode() == 27) {
                    MultiValueCellEditor.this.cancelCellEditing();
                }
                super.processKeyEvent(e);
            }
        };
        this.editor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MultiValueCellEditor.this.editor.showPopup();
            }
        });
        this.editor.setRenderer(new EditorCellRenderer());
        this.listeners = new CopyOnWriteArrayList();
    }

    protected void initEditor(MultiValueResolutionDecision decision) {
        this.editorModel.removeAllElements();
        for (String value : decision.getValues()) {
            this.editorModel.addElement(value);
        }
        if (decision.canKeepNone()) {
            this.editorModel.addElement(MultiValueDecisionType.KEEP_NONE);
        }
        if (decision.canKeepAll()) {
            this.editorModel.addElement(MultiValueDecisionType.KEEP_ALL);
        }
        switch (decision.getDecisionType()) {
            case UNDECIDED: {
                this.editor.setSelectedIndex(0);
                break;
            }
            case KEEP_ONE: {
                this.editor.setSelectedItem(decision.getChosenValue());
                break;
            }
            case KEEP_NONE: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                break;
            }
            case KEEP_ALL: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_ALL);
            }
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        MultiValueResolutionDecision decision = (MultiValueResolutionDecision)value;
        this.initEditor(decision);
        this.editor.requestFocus();
        return this.editor;
    }

    public Object getCellEditorValue() {
        return this.editor.getSelectedItem();
    }

    private static class EditorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public EditorCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColors(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
                this.setBackground(UIManager.getColor("ComboBox.background"));
            }
        }

        protected void renderValue(Object value) {
            this.setFont(UIManager.getFont("ComboBox.font"));
            if (String.class.isInstance(value)) {
                this.setText((String)String.class.cast(value));
            } else if (MultiValueDecisionType.class.isInstance(value)) {
                switch ((MultiValueDecisionType)((Object)MultiValueDecisionType.class.cast(value))) {
                    case KEEP_NONE: {
                        this.setText(I18n.tr("none"));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case KEEP_ALL: {
                        this.setText(I18n.tr("all"));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                }
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderColors(isSelected);
            this.renderValue(value);
            return this;
        }
    }

    public static interface NavigationListener {
        public void gotoNextDecision();

        public void gotoPreviousDecision();
    }
}

