/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PleaseWaitDialog
extends JDialog {
    private final JProgressBar progressBar = new JProgressBar();
    public final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    public final BoundedRangeModel progress = this.progressBar.getModel();
    private JButton btnCancel;
    private JTextArea taLog = new JTextArea(5, 50);
    private JScrollPane spLog;

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)this.currentAction, GBC.eol().fill(2));
        pane.add((Component)this.customText, GBC.eol().fill(2));
        pane.add((Component)this.progressBar, GBC.eop().fill(2));
        this.btnCancel = new JButton(I18n.tr("Cancel"));
        this.btnCancel.setIcon(ImageProvider.get("cancel"));
        this.btnCancel.setToolTipText(I18n.tr("Click to cancel the current operation"));
        pane.add((Component)this.btnCancel, GBC.eol().anchor(10));
        GBC gc = GBC.eol().fill(1);
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.spLog = new JScrollPane(this.taLog);
        pane.add((Component)this.spLog, gc);
        this.spLog.setVisible(false);
        this.setContentPane(pane);
        this.setCustomText("");
        this.setLocationRelativeTo(this.getParent());
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent ev) {
                int w = PleaseWaitDialog.this.getWidth();
                if (w > 200) {
                    Main.pref.putInteger("progressdialog.size", w);
                }
            }
        });
    }

    public PleaseWaitDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    public void setIndeterminate(boolean newValue) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(newValue);
    }

    protected void adjustLayout() {
        this.invalidate();
        this.pack();
        this.setSize(Main.pref.getInteger("progressdialog.size", 600), this.getSize().height);
    }

    public void setCustomText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.customText.setVisible(false);
            this.adjustLayout();
            return;
        }
        this.customText.setText(text);
        if (!this.customText.isVisible()) {
            this.customText.setVisible(true);
            this.adjustLayout();
        }
    }

    public void appendLogMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        if (!this.spLog.isVisible()) {
            this.spLog.setVisible(true);
            this.taLog.setVisible(true);
            this.adjustLayout();
        }
        this.taLog.append(message);
        this.taLog.append("\n");
        this.spLog.getVerticalScrollBar().setValue(this.spLog.getVerticalScrollBar().getMaximum());
    }

    public void setCancelEnabled(boolean enabled) {
        this.btnCancel.setEnabled(enabled);
    }

    public void setCancelCallback(ActionListener callback) {
        if (callback == null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = this.btnCancel.getActionListeners()) {
                this.btnCancel.removeActionListener(l);
            }
        } else {
            this.btnCancel.addActionListener(callback);
        }
    }
}

